/*-----------------------------------------------------------------------------
	Paper Plane xUI	 Virtual File System				path  

S-JIS ΉiɁu\vĂ悢j
 VFS tꂽ֐́AVFS p̏ĂB
 VFS tĂȂ֐́AVFS p̏ȂAVFS pɎg
-----------------------------------------------------------------------------*/
#define ONVFSDLL // VFS.H  DLL export w
#include "WINAPI.H"
#include <shlobj.h>
#include "PPX.H"
#include "WINAPIIO.H"
#include "PPD_DEF.H"
#include "VFS.H"
#include "VFS_STRU.H"
#pragma hdrstop

#ifndef ERROR_CANT_ACCESS_FILE
#define ERROR_CANT_ACCESS_FILE 1920
#endif

const TCHAR StrHttp[] = T("http://");
const TCHAR StrHttps[] = T("https://");
const TCHAR StrFileScheme[] = T("file://");
const TCHAR DomainNameRegPathString[] = T("SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters");
const TCHAR DomainNameRegNameString[] = T("Domain");

HWND PasswordDialogWnd = NULL;

/*-----------------------------------------------------------------------------
	gq̈ʒu擾			Kwwuxx.xxx\yyyvɂ͔Ή
-----------------------------------------------------------------------------*/
VFSDLL int PPXAPI FindExtSeparator(const TCHAR *src)
{
	const TCHAR *ptr, *findptr = NULL;
	TCHAR type;

	ptr = src;
	if ( *ptr == '\0' ) return 0;
	ptr++;
	for ( ; ; ){
		type = *ptr;
		if ( type == '\0' ) break;
		if ( type == '.' ) findptr = ptr;
		ptr++;
	}
	return ToSIZE32_T( ((findptr != NULL) ? findptr : ptr) - src);
}
/*-----------------------------------------------------------------------------
	̃pX؂擾		pX؂́u\vu/v
-----------------------------------------------------------------------------*/
VFSDLL TCHAR * PPXAPI FindPathSeparator(const TCHAR *src)
{
	for ( ; ; ){
		TCHAR type;

		type = *src;
		if ( type == '\0' ) return NULL;
		if ( (type == '\\') || (type == '/') ) return (TCHAR *)src;
#ifndef UNICODE
		if ( Iskanji(type) ) src++;
#endif
		src++;
	}
}

/*-----------------------------------------------------------------------------
	ŉw̃Gg|C^肷(rootȊO \ w)
-----------------------------------------------------------------------------*/
VFSDLL TCHAR * PPXAPI VFSFindLastEntry(const TCHAR *src)
{
	const TCHAR *rp, *tp;
	TCHAR rpchr;

	rp = VFSGetDriveType(src, NULL, NULL);	// hCuwXLbv
	if ( rp == NULL ) rp = src;	// hCuw肪
	rpchr = *rp;
	if ( rpchr != '\0' ){			// root Ȃ *rp == 0
		if ( (rpchr == '/') || (rpchr == '\\') ) rp++;
		tp = FindPathSeparator(rp);
		if ( tp != NULL ){
			do {
				if ( (*(tp + 1) == '\\') && ((tp - 1) > src) && (*(tp - 1) == '(') ){ // #:\PC\x (\\server)(x:)\ ΍
					tp = FindPathSeparator(tp + 2);
					if ( tp == NULL ) break;
				}
				rp = tp;
				tp = FindPathSeparator(rp + 1);
			} while(tp != NULL);
		}
	}
	return (TCHAR *)rp;
}

TCHAR * FindLastEntryPoint(const TCHAR *src)
{
	const TCHAR *rp, *tp;

	rp = VFSGetDriveType(src, NULL, NULL);	// hCuwXLbv
	if ( rp == NULL ) rp = src;	// hCuw肪
	if ( *rp ){				// root Ȃ *rp == 0
		tp = rp;
		for ( ;; ){
			TCHAR type;

			type = *tp;
			if ( (type == '/') || (type == '\\') ){
				rp = tp + 1;
			}else if ( type == '\0' ){
				break;
#ifndef UNICODE
			}else{
				if ( Iskanji(type) ) tp++;
#endif
			}
			tp++;
		}
	}
	return (TCHAR *)rp;
}

const TCHAR * USEFASTCALL FindSepPtr(const TCHAR *vfp)
{
	TCHAR *p;

	p = tstrchr(vfp, '/');
	return (p != NULL) ? p : (vfp + tstrlen(vfp));
}

/*-----------------------------------------------------------------------------
	hCu̎ނ𒲂ׂ
-----------------------------------------------------------------------------*/
_Success_(return != NULL) VFSDLL TCHAR * PPXAPI VFSGetDriveType(_In_z_ const TCHAR *vfp, _Out_opt_ int *resultmode, _Out_opt_ int *force)
{
	int Mode = VFSPT_UNKNOWN;
	int Force = VFSPTF_AUTO;
										// XLbv
	if ( *vfp == '\"' ) vfp++;

										// force w(+/-)mF
	if ( *vfp == '+' ){
		Force = VFSPTF_SHN;
		vfp++;
	}else if ( *vfp == '-' ){
		Force = VFSPTF_FS;
		vfp++;
	}
										// \\ ̔
	if ( (*vfp == '\\') && (*(vfp + 1) == '\\') ){
		vfp += 2;								// long w(\\?)̊mF
		if ( (*vfp == '?') && (*(vfp + 1) == '\\') ){
			vfp += 2;
			if ( !tstrnicmp(vfp, T("UNC"), 3) ){
				vfp += 3;
			}
		}
		Mode = VFSPT_UNC;
		goto fin;
	}
										// DriveList ?
	if ( *vfp == ':' ){
		vfp++;

		if ( *vfp == '?' ){
			vfp ++;
			Mode = VFSPT_DRIVE;
			goto fin;
		}

		if ( (*vfp == ':') && (*(vfp + 1) == '{') ){
			TCHAR *p;

			p = FindPathSeparator(vfp);
			vfp = (p != NULL) ? p : (vfp + tstrlen(vfp));
			Mode = VFSPT_SHELLSCHEME;
			goto fin;
		}

		while ( *vfp != '\0' ){
			if ( *vfp == '\\' ) break;
			#ifndef UNICODE
				if ( IskanjiA(*vfp) ) vfp++;
			#endif
			vfp++;
		}
		Mode = VFSPT_DRIVELIST;
		goto fin;
	}
	if ( *vfp == '#' ){
		vfp++;
										// raw disk ?
		if ( Isalpha(*vfp) && (*(vfp + 1) == ':') ){
			Mode = VFSPT_RAWDISK;
			vfp += 2;
			goto fin;
		}
										// PIDL folder ?
		Mode = VFSPT_UNKNOWN;
		for ( ; ; ){
			if ( *vfp == ':' ){
				vfp++;
				Mode = VFSPT_SHN_DESK - Mode;
				goto fin;
			}
			if ( !Isdigit(*vfp) ) return NULL;
			Mode = (Mode * 10) + (*vfp++ - '0');
		}
	}
										// A-Z: ?
	if ( Isalpha(*vfp) && (*(vfp + 1) == ':') ){
		vfp += 2;
		Mode = VFSPT_DRIVE;
		goto fin;
	}

	switch ( *vfp ){
		case 'a':						// aux: ?
			if ( !memcmp(vfp + 1, StrAux + 1, StrAuxSize - sizeof(TCHAR)) ){
				vfp += 4;
				if ( *vfp == '/' ){
					while ( *(++vfp) == '/' );
					vfp = FindSepPtr(vfp);
				}else{
					TCHAR *p = FindPathSeparator(vfp);
					if ( p != NULL ) vfp = p;
				}
				Mode = VFSPT_AUXOP;
				goto fin;
			}
			break;

		case 'f':
										// ftp: ?
			if ( !memcmp(vfp + 1, StrFtp + 1, StrFtpSize - sizeof(TCHAR)) ){
				vfp += 4;
				while ( *vfp == '/' ) vfp++;
				vfp = FindSepPtr(vfp + 6);
				Mode = VFSPT_FTP;
				goto fin;
			}
										// file: ?
			if ( !memcmp(vfp + 1, StrFileScheme + 1, TSTROFF(5 - 1)) && vfp[5] && vfp[6] ){
				vfp += 7;
				if ( *vfp == '/' ) vfp++;
				Mode = VFSPT_FILESCHEME;
				goto fin;
			}
			break;

		case 'h':
										// http:// ?
			if ( !memcmp(vfp + 1, StrHttp + 1, TSTROFF(7 - 1)) ){
				vfp = FindSepPtr(vfp + 7);
				Mode = VFSPT_HTTP;
				goto fin;
			}
										// https:// ?
			if ( !memcmp(vfp + 1, StrHttps + 1, TSTROFF(8 - 1)) ){
				vfp = FindSepPtr(vfp + 8);
				Mode = VFSPT_HTTP;
				goto fin;
			}
			break;

		case 's':
										// shell: ?
			if ( !memcmp(vfp + 1, StrShellScheme + 1, SIZEOFTSTR(StrShellScheme) - sizeof(TCHAR)) ){
				TCHAR *p;

				p = FindPathSeparator(vfp);
				vfp = (p != NULL) ? p : (vfp + tstrlen(vfp));
				Mode = VFSPT_SHELLSCHEME;
				goto fin;
			}
			break;
	}
#ifdef USESLASHPATH
										// / ?
	if ( *vfp == '/' ){
		Mode = VFSPT_SLASH;
		goto fin;
	}
#endif
	if ( Mode == VFSPT_UNKNOWN ) return NULL;
fin:
	if ( resultmode != NULL ) *resultmode = Mode;
	if ( force != NULL ) *force = Force;
	return (TCHAR *)vfp;
}
/*-----------------------------------------------------------------------------
	src  fname ̊ԂɁu\v 𐶐
	src ̖[Ɂu\vĂȂĂ悢
-----------------------------------------------------------------------------*/
VFSDLL void PPXAPI CatPath(TCHAR *dst, TCHAR *src, _In_z_ const TCHAR *fname)
{
	TCHAR *sep;	// u\v̈ʒuoĂ
	TCHAR *readp;
	int len;

	sep = src;
	if ( dst == NULL ){				// src Ɍʂi[ -------------------
		readp = src;
		while ( *readp ){
			if ( *readp == '\\' ) sep = readp + 1;
			#ifndef UNICODE
				if ( IskanjiA(*readp++) ){
					if ( *readp ) readp++;
				}
			#else
				readp++;
			#endif
		}
		if ( sep != readp ) *(readp++) = '\\';

		len = tstrlen32(fname) + 1;
		if ( (readp - src + len) >= VFPS ){
			tstrcpy(src, T(OVER_VFPS_MSG));
			return;
		}
		memcpy(readp, fname, TSTROFF(len));
		return;
	}else{							// dst Ɍʂi[ -------------------
		readp = src;
		while ( *readp ){
			if ( *readp == '\\' ) sep = readp + 1;
			#ifndef UNICODE
				if ( IskanjiA(*dst++ = *readp++) ){
					if ( *readp ) *dst++ = *readp++;
				}
			#else
				*dst++ = *readp++;
			#endif
		}
		if ( sep != readp ){
			*(dst++) = '\\';
			readp++;
		}
		len = tstrlen32(fname) + 1;
		if ( (readp - src + len) >= VFPS ){
			tstrcpy(dst - (readp - src), T(OVER_VFPS_MSG));
			return;
		}
		memcpy(dst, fname, TSTROFF(len));
		return;
	}
}

//BOOL CheckProtcol(TCHAR *path, TCHAR *sep, int flag, const TCHAR *cur)
BOOL CheckProtcol(TCHAR *path, int flag, const TCHAR *cur)
{
//	const TCHAR *scheme;
	TCHAR *p1;	// , *p2;
	TCHAR buf[VFPS];
//	DWORD size;
//							// hC(xxx.xxx)邩
//	p1 = tstrchr(path, '.');
//	if ( (p1 == NULL) || (p1 > sep) ) return FALSE;
							// fBNg邩mF
						// '\' ɓ
	p1 = path;
	while ( (p1 = tstrchr(p1, '/')) != NULL ) *p1++ = '\\';
	p1 = path;
	if ( flag & VFSFIX_FULLPATH ){
		buf[0] = '\0';
		if ( TSIZEOF(buf) <= ExpandEnvironmentStrings(p1, buf, TSIZEOF(buf)) ){
			tstrcpy(buf, p1);
		}
		VFSFullPath(NULL, buf, cur);
//		p1 = buf;
	}
	return FALSE;
/*
	if ( GetFileAttributesL(p1) != BADATTR ) return FALSE;
	scheme = StrHttp;
	size = SIZEOFTSTR(StrHttp);

							// ftp / http ̔
	if (tstrchr(VFSFindLastEntry(p1), '.') != NULL){
		scheme = StrHttp;
		size = SIZEOFTSTR(StrHttp);
	}else{
		scheme = StrFtp;
		size = StrFtpSize;
	}

							// Zp[^ '/' ɓ
	p2 = path;
	while ( (p2 = FindPathSeparator(p2)) != NULL ) *p2++ = '/';
							// ǉ
	memmove(path + size, path, TSTRSIZE(path));
	memcpy(path, scheme, size);
	return TRUE;
*/
}

/*-----------------------------------------------------------------------------
	src 𐳋KpXɕϊ
-----------------------------------------------------------------------------*/
VFSDLL TCHAR * PPXAPI VFSFixPath(TCHAR *dst, TCHAR *src, _In_opt_z_ const TCHAR *cur, int flags)
{
	TCHAR buf[VFPS + MAX_PATH];
	TCHAR buf2[VFPS];

	if ( dst == NULL ) dst = src;
	if ( flags & VFSFIX_NOFIXEDGE ){
		TCHAR *last;

		last = tstplimcpy(buf, src, VFPS + MAX_PATH);
		if ( last >= (buf + VFPS + MAX_PATH - 1) ) goto lenerror;
	}else{ // Ő󔒂폜
		TCHAR *sptr, *dptr;

		sptr = src;
		while ( (*sptr == ' ') || (*sptr == '\t') ) sptr++;

		dptr = buf;
		for ( ;; ){
			TCHAR c;

			c = *sptr++;
			if ( c == '\0' ) break;
			if ( c != '\"' ){
				*dptr++ = c;
				if ( dptr < (buf + VFPS + MAX_PATH - 1) ) continue;
				goto lenerror;
			}
			// Zp[^LcPȂ珜
			if ( *sptr != '\"' ) continue;
			sptr++;
			*dptr++ = c;
			if ( dptr < (buf + VFPS + MAX_PATH - 1) ) continue;
			goto lenerror;
/*
			for ( ;; ){
				TCHAR sc;

				sc = *sptr;
				if ( sc == '\0' ) break;
				sptr++;
				if ( sc != '\"' ){
					*dptr++ = sc;
					continue;
				}
				if ( *sptr == '\"' ){
					sptr++;
					*dptr++ = sc;
					continue;
				}
				break;
			}
*/
		}
		*dptr = '\0';
	}

	if ( (buf[2] != '?') && (buf[0] != '\\') && (buf[1] != '\\') ){
		TCHAR *cptr, lastchar;
										// ̋󔒁Eu.v폜
		cptr = buf + tstrlen(buf);
		while ( cptr > buf ){
			lastchar = *(cptr - 1);
			if ( (lastchar == ' ') ||
				 (lastchar == '.') ||
				 (lastchar == '\t') ||
				 (lastchar == '\r') ||
				 (lastchar == '\n') ){
				cptr--;
				continue;
			}
			break;
		}
							// sIhAΎwł猳ɖ߂
		if ( *cptr == '.' ){
			TCHAR *lastentry;

			lastentry = FindLastEntryPoint(buf);
			if ( cptr == lastentry ){
				do {
					cptr++;
				} while ( *cptr == '.' );
			}else if ( (flags & VFSFIX_KEEPLASTPERIOD) &&
					((UTCHAR)*(cptr + 1) <= ' ') ){
				cptr++; // u.vێ
			}
		}
		*cptr = '\0';
	}
										// 󗓂ȂG[
	if ( (flags & VFSFIX_NOBLANK) && (buf[0] == '\0') ) return NULL;

										// PhCuw̕␳
	if ( (flags & VFSFIX_DRIVE) && Isalnum(buf[0]) && (buf[1] == '\0') ){
		int drivename;
		DWORD X_odrv;
										// w蕶̃hCu݂邩mF
		drivename = buf[0];
		X_odrv = GetCustDword(T("X_odrv"), 1);

		if ( drivename <= '9' ){
			if ( X_odrv == 1 ) X_odrv = 0;
			drivename += ('A' - '1');
		}
		if ( drivename >= 'a' ) drivename -= ('a' - 'A');
		if ( X_odrv && (GetLogicalDrives() & (1 << (drivename - 'A'))) ){
			TCHAR curtmp[VFPS];
			const TCHAR *curp;

			if ( cur == NULL ){
				GetCurrentDirectory(TSIZEOF(curtmp), curtmp);
				curp = curtmp;
			}else{
				curp = cur;
			}
			CatPath(&buf[2], (TCHAR *)curp, buf);
			for ( ; ; ){
				DWORD atr;

				atr = GetFileAttributesL(&buf[2]); // w蕶dir邩
				if ( (atr != BADATTR) && (atr & FILE_ATTRIBUTE_DIRECTORY) ){
					thprintf(buf2, TSIZEOF(buf2), MessageText(MES_QISD), buf);
					if ( PMessageBox(NULL, buf2, MES_TISD, MB_YESNO) != IDYES ){
						break;
					}
				}
				buf[0] = (TCHAR)drivename;
				buf[1] = ':';
				buf[2] = '\0';
				break;
			}
		}
	}
														// Zp[^̕␳
	if ( flags & VFSFIX_SEPARATOR ){
		// file: ̏
		if ( !memcmp(buf, StrFileScheme, SIZEOFTSTR(StrFileScheme)) ){
			int extra;
			extra = (buf[SIZEOFTSTR(StrFileScheme)] == '/') ?
					SIZEOFTSTR(StrFileScheme) + 1 : SIZEOFTSTR(StrFileScheme);
			memmove(buf, buf + extra, TSTRSIZE(buf + extra) );
		}
#ifdef USESLASHPATH						// http/ftp wb_̊mF
		if ( buf[0] != '/' ) // ␳Ȃ
#endif
		{
			if ( memcmp(buf, StrHttp, SIZEOFTSTR(StrHttp) ) &&
				 memcmp(buf, StrHttps, SIZEOFTSTR(StrHttps) ) &&
				 memcmp(buf, StrFtp , StrFtpSize) &&
				 !(!memcmp(buf, StrAux, StrAuxSize) && (buf[4] == '/')) ){
				if ( tstrchr(buf, '/') != NULL ) CheckProtcol(buf, flags, cur);
			}else{
				TCHAR *bsptr;

				bsptr = buf;
				while ( (bsptr = FindPathSeparator(bsptr)) != NULL ){
					*bsptr++ = '/';
				}
			}
		}
	}
	{
		TCHAR *result, *last;

		result = buf;
		if ( flags & VFSFIX_FULLPATH ){ // Ή
			TCHAR srcbuf[TSIZEOF(buf)];
										// ϐ̓WJ
			if ( !(flags & VFSFIX_DISABLE_EXPAND) &&
				 (tstrchr(buf, '%') != NULL) ){ // ϐ肻
				if ( (VFSFullPath(srcbuf, buf, cur) != NULL) && // Ή\
					 (GetFileAttributesL(srcbuf) == BADATTR ) && // ̖
					 (tstrstr(srcbuf, T("//")) == NULL) ){ // http:// łȂ
					tstrcpy(srcbuf, buf);
					if ( TSIZEOF(buf) <= ExpandEnvironmentStrings(srcbuf, buf, TSIZEOF(buf)) ){
						tstrcpy(buf, srcbuf);
					}
				}
			}
			result = VFSFullPath(NULL, buf, cur);
			if ( result == NULL ) return NULL;
		}
														// ̉
		if ( flags & VFSFIX_REALPATH ){
			int mode;

			if ( VFSGetDriveType(buf, &mode, NULL) != NULL ){
				if ( (mode <= VFSPT_SHN_DESK) || (mode == VFSPT_SHELLSCHEME) ){
					HRESULT ComInitResult;
					ComInitResult = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE);
					if ( flags & VFSFIX_VREALPATH ){
						if ( IsTrue(VFSGetRealPath(NULL, buf2, buf)) ){
							tstrcpy(buf, buf2);
						}
					}else{
						if ( VFSGetRealPath(NULL, buf, buf) == FALSE ){
							buf[0] = '?';
							buf[1] = '\0';
						}
					}
					if ( SUCCEEDED(ComInitResult) ) CoUninitialize();
				}
			}
		}
#if 0 // ݎgpĂȂ߁A1.12  
		if ( flags & VFSFIX_CASE ) CharUpper(buf);			// 啶
#endif
		last = tstplimcpy(dst, buf, VFPS);
		if ( (last < (dst + VFPS - 1)) || (tstrlen(buf) < VFPS) ){
			return dst + (result - buf);
		}
		// 
	}

lenerror:
	tstrcpy(dst, T(OVER_VFPS_MSG));
	SetLastError(ERROR_FILENAME_EXCED_RANGE);
	return NULL;
}

#if UseExtraLongPath
TCHAR expathbuf[MAX_PATH_EX] = T("");
BOOL ConvertToShortPath(TCHAR *path, size_t req_length) // VFPS ɔ[߂邽ߒZt@Cɂ
{
	TCHAR pathbuf[MAX_PATH_EX] ,*dest = pathbuf, *lastentry, *src = path;
	size_t headlen = 3;

	if ( (src[0] == ':') && (src[1] == '?') ){
		dest = tstpcpy(dest, expathbuf);
		src += 2;
	}
	if ( ((dest - pathbuf) + req_length) >= MAX_PATH_EX ) return FALSE;
	dest = tstpcpy(dest, src);
	lastentry = tstrrchr(pathbuf, '\\');
	if ( (lastentry == NULL) ||
		 ((dest - lastentry) >= (VFPS - headlen)) ){ // pX؂ŕłȂƂ
		lastentry = dest - (MAX_PATH + headlen);
	}
	tstrcpypart(expathbuf, pathbuf, lastentry - pathbuf);
	src[0] = ':';
	src[1] = '?';
	tstrcpypart(src + 2, lastentry, dest - lastentry);
	return TRUE;
}
#else
DWORD ConvertToShortPathSplit(WCHAR *path) // ŜZłȂŏIGg쐬̉\̂ŁAŏIGgȊOZ
{
	WCHAR dir[(VFPS * 2) + 16], *sep;
	DWORD len, newlen;

	sep = strrchrW(path, '\\'); //  \ ͌
	*sep = '\0';
	len = GetShortPathNameW(path, dir, sizeof(dir) / sizeof(WCHAR));
	*sep = '\\';
	newlen = len + strlenW(sep);
	if ( (len == 0) || (newlen >= VFPS) ) return 0;
	strcatW(dir, sep);
	strcpyW(path, dir);
	return newlen;
}

#define ConvertToShortPath(path, req_length) _ConvertToShortPath(path)
BOOL _ConvertToShortPath(TCHAR *path) // VFPS ɔ[߂邽ߒZt@Cɂ
{
	WCHAR buf[(VFPS * 2) + 16], *dest = buf + 4;
	DWORD len, offset = 0;

	if ( (path[1] != ':') && (path[0] != '\\') ) return FALSE;

	// C:\name\name			\\?\C:\name\name
	// \\name\name\name		\\?\UNC\name\name\name
	buf[0] = '\\';
	buf[1] = '\\';
	buf[2] = '?';
	buf[3] = '\\';
	if ( *path == '\\' ){
		offset = 1;
		buf[4] = 'U';
		buf[5] = 'N';
		buf[6] = 'C';
		dest = buf + 7;
	}
	strcpyToW(dest, path + offset, VFPS * 2);
	len = GetShortPathNameW(buf, buf, sizeof(buf) / sizeof(WCHAR));
	if ( len == 0 ) len = ConvertToShortPathSplit(buf);
	if ( (len == 0) || ((len + offset) >= VFPS) ) return FALSE;
	#ifdef UNICODE
		strcpyW(path + offset, dest);
	#else
		len = WideCharToMultiByte(CP_ACP, 0, dest, -1, path + offset, VFPS - offset, NULL, NULL);
		if ( len >= VFPS ) return FALSE;
	#endif
	return TRUE;
}
#endif

/*-----------------------------------------------------------------------------
	Ύw src Ύw cur Ύwɕϊ
	Kw؂'\'̂
-----------------------------------------------------------------------------*/
// \\pcname\sharename\path1\path2
//   ^               ^
//------------------------------------- UNC  root 肷
// \\pc\share\path....
//   ^ ^     ^
TCHAR *GetUncRootPtr(TCHAR *path)
{
	TCHAR *pc, *share;

	pc = FindPathSeparator(path);	// PCXLbv
	if ( pc == NULL ) return path + tstrlen(path);

	pc++;	// '\\' XLbv
	share = FindPathSeparator(pc);	// LXLbv
	if ( share != NULL ){
		if ( share > pc ) return share;	// Lȍ~
		return pc - 1;				// \\pc\\.... `ُ̈큨pc܂
	}
	if ( *pc == '\0' ) return pc - 1;	// Lpc܂
	return pc + tstrlen(pc);			// L̖܂
}

VFSDLL TCHAR * PPXAPI VFSFullPath(TCHAR *dst, TCHAR *src, _In_opt_z_ const TCHAR *cur)
{
	// HpX֘A
		TCHAR dir[VFPS * 2];	// H̃fBNg
		TCHAR *drvp;			// hCu̖(rootʒuLp)
		TCHAR *cutp;			// `pŏI݈ʒu(\菜)
		TCHAR *dstp;			// ŏI݈ʒu
		TCHAR *bp;				// [Gg̐擪
		TCHAR sep = '\\';		// pX؂(url mode Ȃ /)
		int sepcnt = 0;			// fBNg̊Kw 0:root -1:drive list
	// src֘A
		TCHAR *srcp;		// Qƈʒu
		int mode = VFSPT_UNKNOWN;
		BOOL relative = FALSE;	// JgΎwL
		int force = VFSPTF_AUTO;

	TCHAR *drvlastp;

	if ( dst == NULL ) dst = src;
								// src ̃pXނƑ΂𔻒f ===============
	srcp = src;
	drvlastp = VFSGetDriveType(src, &mode, &force);
	if ( drvlastp == NULL ){	// hCuȂ
		relative = TRUE;
		dstp = dir;
	}else{
		switch( mode ){
			case VFSPT_FILESCHEME:
				srcp = VFSGetDriveType(drvlastp, &mode, &force);
				if ( srcp == NULL ){
					dir[0] = '\\';
					dir[1] = '\\';
					tstrcpy(dir + 2, drvlastp);
					drvlastp = dir;
				}
				return VFSFullPath(dst, (TCHAR *)drvlastp, cur);

			case VFSPT_AUXOP:
				if ( *(src + 4) != '/' ) break;
				// VFSPT_SLASH 
								// FTP/HTTP wtȂKΎw
			case VFSPT_SLASH:
			case VFSPT_FTP:
			case VFSPT_HTTP:
				sep = '/';
				break;
								// UNC wtȂKΎw
			case VFSPT_UNC:
						// \\server\share hCuɂ
				if ( *drvlastp != '>' ) drvlastp = GetUncRootPtr(drvlastp);
				break;
								// shell: wtȂKΎw
			case VFSPT_SHELLSCHEME:
				break;

			default:			// GNC ȂAZp[^̗LŔf
				if ( *drvlastp != sep ) relative = TRUE;
		}
								// hCu]
		memcpy(dir, src, TSTROFF(drvlastp - src));
		dstp = dir + (drvlastp - src);
		srcp = drvlastp;
		#ifdef WINEGCC // system Ŏs
			if ( mode == VFSPT_SLASH ){
				tstrcpy(dir, T("Z:/"));
				dstp = dir + 2;
				mode = VFSPT_DRIVE;
				srcp++;
			}
		#endif

		if ( mode == VFSPT_DRIVE ){ // hCu啶
			*(dstp - 2) = TinyCharUpper(*(dstp - 2));
		}

		if ( mode == VFSPT_DRIVELIST ){	// DriveList  GCAX𔻒
			*dstp = '\0';
			if ( (dir[1] != '\0') && (dir[1] != ':') ){
				TCHAR *dlp;

				if ( dir[1] == '<' ){ // :<comment>path 
					TCHAR *lastp;
					lastp = tstrchr(src, '>');
					if ( lastp != NULL ) return VFSFullPath(dst, lastp + 1, cur);
				}
					// hCuXgpRg
				dlp = tstrchr(src, '\t');
				if ( dlp != NULL ){
					tstrcpy(dir, src + 1);
					*(dir + (dlp - src) - 1) = '\0';
					return VFSFullPath(dst, dir, cur);
				}

				if ( NO_ERROR == GetCustTable(
					(GetCustDword(StrX_dlf, 0) & XDLF_USEMDRIVES) ?
							StrMDrives : PathJumpName,
					dir + 1, dir, sizeof(dir)) ){
												// GCAX
					PP_ExtractMacro(NULL, NULL, NULL, dir, dir, XEO_DISPONLY);
					VFSFullPath(NULL, dir, cur);
					if ( *srcp == sep ) srcp++;
					return VFSFullPath(dst, (TCHAR *)srcp, dir);
				}
			}
		}
	}
	if ( relative == FALSE ){	// ΎwȂϐ̂ ====
		*dstp++ = sep;	// root pZp[^ǉ
		bp = cutp = drvp = dstp;
		if ( *srcp == sep ) srcp++; // root  '\' XLbv
	}else{						// ΎwȂAJgpӂ =======
		TCHAR curtmp[VFPS];	//
		TCHAR *curp;			// Jg cp
		int cmode = VFSPT_UNKNOWN;

		if ( cur == NULL ){
			GetCurrentDirectory(TSIZEOF(curtmp), curtmp);
		}else{
			tstrcpy(curtmp, cur);
		}
#if UseExtraLongPath
		if ( (curtmp[0] == ':') && (curtmp[1] == '?') ){
			VFSGetDriveType(expathbuf, &cmode, NULL);
			curp = FindPathSeparator(curtmp);
		}else
#endif
		{
			curp = VFSGetDriveType(curtmp, &cmode, NULL);
			if ( curp == NULL ){
				*dst = '\0';
				SetLastError(ERROR_INVALID_DRIVE);
				return NULL;
			}
			if ( cmode == VFSPT_DRIVE ){ // hCu啶
				*(curp - 2) = TinyCharUpper(*(curp - 2));
			}

			if ( (cmode == VFSPT_SLASH) || (cmode == VFSPT_FTP) || (cmode == VFSPT_HTTP) || ((cmode == VFSPT_AUXOP) && (curtmp[4] == '/')) ){
			sep = '/';
			}
							// curhCusrcƓmFAႤꍇ͍Ď擾
			if ( ((mode != VFSPT_UNKNOWN) && (mode != cmode) ) ||
				 ((mode == VFSPT_DRIVE)   && (*(curp - 2) != *(dstp - 2))) ){
				const TCHAR *hist;

				*dstp = '\0';
				UsePPx();
				hist = SearchPHistory(PPXH_PPCPATH, dir);	// qXg擾
				if ( hist != NULL ){
					tstrcpy(curtmp, hist);
					FreePPx();
				}else{								// qXg擾s
					FreePPx();
					if ( mode == VFSPT_DRIVE ){	// 'A:'`Ȃ API Ŏ擾
						*dstp = '\0';
						if ( GetFullPathName(dir, VFPS, curtmp, &drvlastp) == 0 ){
							*dst = '\0';
							return NULL;
						}
					}else{						// ̂قJĝroot
						CatPath(curtmp, dir, NilStr);
					}
				}
				cmode = VFSPT_UNKNOWN;
				curp = VFSGetDriveType(curtmp, &cmode, NULL);
				if ( cmode == VFSPT_DRIVE ){
					*(curp - 2) = TinyCharUpper(*(curp - 2));
				}
			}
			if ( cmode == VFSPT_UNKNOWN ){
				*dst = '\0';
				SetLastError(ERROR_INVALID_DRIVE);
				return NULL;
			}
		}
										// JgpXޖ̕␳
		if ( cmode == VFSPT_FTP ){
			sep = '/';
		}else if ( cmode == VFSPT_HTTP ){ // Jg␳
			TCHAR *clp, *cl;

			sep = '/';
			cl = curp;
			if ( (*srcp == '/') && (*(srcp + 1) == '/') ){ // //` ̂Ƃ
				clp = tstrchr(curtmp, '/');
				if ( clp != NULL ) curp = cl = clp + 1;
			}else{ // curtmp ̍Ō̃pX؂擾
				clp = tstrchr(cl, '/');
				if ( clp != NULL ){
					for ( ; ; ){
						cl = clp;
						clp = tstrchr(cl + 1, '/');
						if ( clp == NULL ) break;
					}
				}else{ // http:// Ȃ̂ŁAṒu/vw悤
					if ( (curp - curtmp) <= 8 ) curp--;
				}
			}
			*cl = '\0';
		}else if ( cmode == VFSPT_UNC ){
			curp = GetUncRootPtr(curp);
			if ( curp == (curtmp + 2) ) curp--;	// \\ ͍̎Ṓu\vw悤
		}
		// JgZp[^ȂXLbvAȂΒǉ
		if ( *curp == sep ){
			curp++;
		}else if ( *curp == '\0' ){
			*curp++ = sep;
			*curp = '\0';
		}
		tstrcpy(dir, curtmp);
		mode = cmode;
		dstp = dir + (curp - curtmp);
		bp = cutp = drvp = dstp;

		if ( *srcp == sep ){	// hCûݖAƂ͐Ύw
			srcp++;
		}else{					// JgΎw聨Jg̊Kw擾
			for ( ; ; ){
				TCHAR *sepp;

				sepp = dstp;
				for ( ; ; ){ // FindPathSeparator
					TCHAR type;

					type = *sepp;
					if ( type == sep ) break;
					if ( type == '\0' ){
						sepp = NULL;
						break;
					}
				#ifndef UNICODE
					if ( Iskanji(type) ) sepp++;
				#endif
					sepp++;
				}
				if ( sepp == NULL ){
					if ( *dstp != '\0' ){
						bp = dstp;
						sepcnt++;
						dstp += tstrlen(dstp);
						cutp = dstp;
						*dstp++ = sep;
					}
					break;
				}
				sepcnt++;
				bp = dstp;
				cutp = sepp;
				dstp = sepp + 1;
				if ( *dstp == '\0' ) break;
			}
		}
	}
	if ( mode == VFSPT_DRIVELIST ) sepcnt = -1;
										// src ̃fBNgݒ ===========
										// srcp:́u\vłʒu
	//  hCu > ȍ~̓RgƂĖ
	if ( *srcp != '>' ) while( *srcp != '\0' ){
		int reldircnt; // Ύw萔
		TCHAR *srcpp;

		// Kw1ڏ
		if ( sepcnt <= 0 ) bp = cutp = dstp = drvp;	// ߂肷̏ꍇ̑΍
		if ( *srcp == sep ){ // Au\v
			if ( mode != VFSPT_AUXOP ){ // aux: ͓r // KvȂƂ
				if ( ((mode > VFSPT_SHN_DESK) && (mode != VFSPT_SHELLSCHEME)) ||
					!((*(srcp + 1) != '\0') &&
					  ((srcp - 2) > src) &&
					  (*(srcp - 2) == '(')) ){
					do {
						srcp++;
					}while ( *srcp == sep );
					if ( *srcp == '\0' ) break;
				}
			}
		}
		if ( *srcp == ':' ){		// ^hCu(quasi-drive)w
			const TCHAR *hist, *histr;

			srcp++;
			*dstp = '\0';

			UsePPx();
			hist = SearchPHistory(PPXH_PPCPATH, dir);	// qXg擾
			if ( hist == NULL ){	// Jg^[g
				FreePPx();
				continue;
			}
										// ^[g̕A^TuOH
			if ( *cutp == sep ) *cutp = '\0';	// Ô߁Ar
			histr = SearchHistory(PPXH_PPCPATH, dir);	// qXg擾
			if ( histr != NULL ){
				if ( histr < hist ) hist = histr;
			}

			CatPath(dir, (TCHAR *)hist, NilStr);
			FreePPx();
			bp = dstp = dir + tstrlen(dir);
			cutp = dstp - 1;
			continue;
		}
										// Ύw
		reldircnt = 0;
		if ( *srcp == '.' ){
			srcpp = srcp;
			for (;;){
				TCHAR relchr;

				srcpp++;
				reldircnt++;

				relchr = *srcpp;
				if ( (relchr == '\0') || (relchr == sep) ) break;
				if ( relchr == '.' ) continue;
				reldircnt = 0;
				break;
			}
		}

		if ( reldircnt == 0 ){						// ʎw
			bp = dstp;
			srcpp = FindPathSeparator(srcp);
			sepcnt++;
			if ( srcpp != NULL ){		// ʊKwL
				size_t len;

				srcpp++;
				len = srcpp - srcp;
				if ( (dstp + len) >= (dir + VFPS) ){
					DWORD dirlen;

					*dstp = '\0';
					if ( ConvertToShortPath(dir, (dstp - dir) + len) == FALSE ){
						goto lenerror;
					}
					dirlen = tstrlen(dir);
					dstp = bp = dir + dirlen;
				}
				memcpy(dstp, srcp, TSTROFF(len));
				srcp = srcpp;
				dstp += len;
				cutp = dstp - 1;
				if ( mode != VFSPT_HTTP ) continue;
				cutp++; // http ł͖Zp[^c
				continue;
			}else{					// Ȃ
				size_t len;

				len = tstrlen(srcp);
				if ( (dstp + len) >= (dir + VFPS) ){
					DWORD dirlen;

					*dstp = '\0';
					if ( ConvertToShortPath(dir, (dstp - dir) + len) == FALSE ) goto lenerror;
					dirlen = tstrlen(dir);
					dstp = bp = dir + dirlen;
				}
				memcpy(dstp, srcp, TSTROFF(len));
				cutp = dstp + len;
				break;
			}
		}else{							// Ύw
			int relpos;

			if ( *srcpp != '\0' ) srcpp++; // Zp[^XLbv
			srcp = srcpp;
			if ( reldircnt <= 1 ) continue;	// '.'
			*dstp = '\0';
			sepcnt -= reldircnt - 1;
			cutp = dstp = drvp;
			for ( relpos = 0 ; relpos < sepcnt ; relpos++ ){
				TCHAR *dstpp;

				bp = dstp;
				dstpp = FindPathSeparator(dstp);
				if ( dstpp == NULL ){
					dstp += tstrlen(dstp);
					break;
				}

				if ( (*(dstpp + 1) == '\\') && ((dstpp - 1) > drvp) && (*(dstpp - 1) == '(') ){ // #:\PC\x (\\server)(x:)\ ΍
					relpos += 2;
					if ( relpos >= sepcnt ) break;
					dstpp = FindPathSeparator(dstpp + 2);
					if ( dstpp == NULL ){
						dstp += tstrlen(dstp);
						break;
					}
				}

				cutp = dstpp;
				dstp = dstpp + 1;
			}
			continue;
		}
	}
	*cutp = '\0';
	if ( sepcnt < 0 ){
		tstrcpy(dir, T(":"));
	}else if ( (sepcnt == 0) && (mode == VFSPT_UNC) ){
		if ( (drvp - dir) > 2 ){	// \\pc\share\  \\pc\share ɉH
			*(--bp) = '\0';
		}
	}
	{
		DWORD len;

		len = tstrlen32(dir) + 1;
		if ( len > VFPS ){
			if ( ConvertToShortPath(dir, len) == FALSE ) goto lenerror;
			bp = VFSFindLastEntry(dir);
			if ( (*bp == '\\') || (*bp == '/') ) bp++;
			len = tstrlen32(dir) + 1;
		}
		if ( force == VFSPTF_FS ){
			if ( FALSE == VFSGetRealPath(NULL, dst, dir + 1) ){
				memcpy(dst, dir + 1, TSTROFF(len - 1));
			}
		}else{
			memcpy(dst, dir, TSTROFF(len));
		}
	}
	return dst + (bp - dir);

lenerror:
	tstrcpy(dst, T(OVER_VFPS_MSG));
	SetLastError(ERROR_FILENAME_EXCED_RANGE);
	return NULL;
}
/*-----------------------------------------------------------------------------
	KwfBNg̈ꊇ쐬
-----------------------------------------------------------------------------*/
VFSDLL ERRORCODE PPXAPI MakeDirectories(const TCHAR *dst, const TCHAR *src)
{
	BOOL err;
	ERRORCODE result = NO_ERROR;
	TCHAR *shortsrc = NULL, shortsrcbuf[VFPS], shortdst[VFPS], *wp;

	#ifndef UNICODE
		if ( WinType == WINTYPE_9x ) src = NULL;
	#endif
	if ( src != NULL ){
		err = CreateDirectoryExL(src, dst, NULL);
	}else{
		err = CreateDirectoryL(dst, NULL);
	}
	if ( err == FALSE ){
		result = GetLastError();

		if ( !memcmp(dst, StrFtp, StrFtpSize) ){
			result = CreateFtpDirectory(dst);
			if ( result == NO_ERROR ) return NO_ERROR;
		}
		if ( !memcmp(dst, StrAux, StrAuxSize) ){
			result = AuxFileOperation(T("makedir"), dst, NilStr, NilStr);
			if ( result == NO_ERROR ) return NO_ERROR;
		}
		// FILE_ATTRIBUTE_VIRTUAL ̂Ƃ́AERROR_INVALID_PARAMETER ł
		// Samba  ERROR_INVALID_LEVEL ł
		if ( (src != NULL) &&
			 ((result == ERROR_ACCESS_DENIED) || (result == ERROR_INVALID_PARAMETER) || (result == ERROR_INVALID_LEVEL)) ){
			result = NO_ERROR;
			if ( CreateDirectoryL(dst, NULL) == FALSE ) result = GetLastError();
		}
		if ( result == ERROR_PATH_NOT_FOUND ){
			tstrcpy(shortdst, dst);
			wp = VFSFindLastEntry(shortdst);
			if ( *wp ){
				*wp = '\0';
				if ( src != NULL ){
					tstrcpy(shortsrcbuf, src);
					wp = VFSFindLastEntry(shortsrcbuf);
					if ( *wp != '\0' ) *wp = '\0';
					shortsrc = shortsrcbuf;
				}
				result = MakeDirectories(shortdst, shortsrc);
				if ( result == NO_ERROR ){
					if ( src != NULL ){
						err = CreateDirectoryExL(src, dst, NULL);
					}else{
						err = CreateDirectoryL(dst, NULL);
					}
					if ( err == FALSE ) result = GetLastError();
				}
			}
		}
	}
	// ̕
	while ( (src != NULL) && (result == NO_ERROR) ){
		HANDLE hFile;
		FILETIME fc, fa, fw;

		hFile = CreateFileL(src, GENERIC_READ, FILE_SHARE_READ, NULL,
				OPEN_EXISTING,
				FILE_FLAG_BACKUP_SEMANTICS | FILE_ATTRIBUTE_NORMAL, NULL);
		if ( hFile == INVALID_HANDLE_VALUE ) break;
		if ( !GetFileTime(hFile, &fc, &fa, &fw) ){
			CloseHandle(hFile);
			break;
		}
		CloseHandle(hFile);
		hFile = CreateFileL(dst, GENERIC_WRITE,
				FILE_SHARE_WRITE | FILE_SHARE_READ, NULL, OPEN_EXISTING,
				FILE_FLAG_BACKUP_SEMANTICS | FILE_ATTRIBUTE_NORMAL, NULL);
		if ( hFile == INVALID_HANDLE_VALUE ) break;
		SetFileTime(hFile, &fc, &fa, &fw);
		CloseHandle(hFile);
		break;
	}
	return result;
}

typedef struct {
	TCHAR path[VFPS];
	TCHAR username[VFPS];
	TCHAR password[VFPS];
} TRYLOGINSTRUCT;

// wfBNgւ̔F؂s߂̃_CAO{bNX ---------------------
INT_PTR CALLBACK VFSChangeDirectoryDlgBox(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch(iMsg){
//-----------------------------------------------------------------------------
		case WM_INITDIALOG: {
			TRYLOGINSTRUCT *tls;

			CenterWindow(hDlg);
			LocalizeDialogText(hDlg, IDD_LOGIN);
			tls = (TRYLOGINSTRUCT *)lParam;
			SetDlgItemText(hDlg, IDS_LOGINPATH, tls->path);
			SetDlgItemText(hDlg, IDE_LOGINUSER, tls->username);
//			SetDlgItemText(hDlg, IDE_LOGINPASS, tls->password);
			SendDlgItemMessage(hDlg, IDE_LOGINUSER, EM_SETSEL, 0, EC_LAST);
			SetDlgFocus(hDlg, IDE_LOGINUSER);
			return FALSE;
		}
		case WM_COMMAND:
			switch ( LOWORD(wParam) ){
//-----------------------------------------------------------------------------
				case IDOK: {
					TCHAR user[MAX_PATH * 2];
					TCHAR buf1[0x1000], buf2[VFPS];
					TCHAR path[MAX_PATH];
					NETRESOURCE nr;
					DWORD connectflag;

					GetDlgItemText(hDlg, IDS_LOGINPATH, path, TSIZEOF(path));
					GetDlgItemText(hDlg, IDE_LOGINUSER, user, TSIZEOF(user));
					GetDlgItemText(hDlg, IDE_LOGINPASS, buf2, TSIZEOF(buf2));
					connectflag = IsDlgButtonChecked(hDlg, IDX_LOGINRE) ?
							CONNECT_UPDATE_PROFILE : 0;
					nr.dwType		= RESOURCETYPE_DISK;
					nr.lpLocalName	= NULL;
					nr.lpRemoteName	= path;
					nr.lpProvider	= NULL;

					SetMessageOnCaption(hDlg, MES_BUSY);

					//  VFSChangeDirectory œo^
					if ( DWNetAddConnection3(hDlg, &nr, buf2, user, connectflag)
							== NO_ERROR ){
						if ( IsDlgButtonChecked(hDlg, IDX_LOGINRE) ){
							TCHAR *p;

							GetDlgItemText(hDlg, IDE_LOGINUSER, buf2, 120);
							p = buf2 + tstrlen(buf2) + 1;
							GetDlgItemText(hDlg, IDE_LOGINPASS, p, 120);
							p = p + tstrlen(p) + 1;
							WriteEString(buf1, (BYTE *)buf2, TSTROFF32(p - buf2));
							SetCustStringTable(T("_IDpwd"), path, buf1, 0);
						}
						EndDialog(hDlg, 1);
					}else{
/*	ʂ̃[UŐڑĂƂɁAؒfĂ݂悤ƂĂA
	ʂ̃\[XɐڑĂƂ͐ؒfłȂ̂ŁAG[\̏ƂB
*/
						ErrorPathBox(hDlg, T("connect"), buf2, PPERROR_GETLASTERROR);
						SetMessageOnCaption(hDlg, NULL);
					}
					ClearMemory(buf2, sizeof(buf2));
					break;
				}
				case IDCANCEL:
					EndDialog(hDlg, 0);
					break;
			}
			break;

		default:
			return PPxDialogHelper(hDlg, iMsg, wParam, lParam);
	}
	return TRUE;
}

// Ώۂlbg[NhCuȂGNXv[gčĐڑĂ݂
ERRORCODE VFSTryDirectory_Local(const TCHAR *vpath)
{
	HANDLE hFF;
	WIN32_FIND_DATA ff;
	TCHAR path[VFPS];

	thprintf(path, TSIZEOF(path), T("+%c:\\*"), *vpath);

	hFF = VFSFindFirst(path, &ff);
	if ( hFF != INVALID_HANDLE_VALUE ){
		VFSFindClose(hFF);
		return NO_ERROR;
	}
	return GetLastError();
}

ERRORCODE VFSTryDirectory_UNC(HWND hWnd, const TCHAR *vpath)
{
	NETRESOURCE nr;
	TRYLOGINSTRUCT tls;
	TCHAR phrasebuf[0x1000], *ptr;
	ERRORCODE er;

	tstrcpy(tls.path, vpath);

	FixBeforeDialog(hWnd);
	// OC̃pXpӂ/L\ -------------------------------------
	ptr = VFSGetDriveType(tls.path, NULL, NULL);
	if ( ptr != NULL ){
		ptr = FindPathSeparator(ptr);
		if ( ptr != NULL ){
			ptr = FindPathSeparator(ptr + 1);
			if ( ptr != NULL ) *ptr = '\0';
		}
	}

	// ftHg̃[U(hCȂPCp) ---------
	tls.password[0] = '\0';
	GetRegString(HKEY_LOCAL_MACHINE, DomainNameRegPathString, DomainNameRegNameString, tls.password, TSIZEOF(tls.password));
	if ( tls.password[0] != '\0' ){
		TCHAR *src, *dest;

		src = tls.path + 2; // u\\v̂
		dest = tls.username;
		while ( *src && (*src != '\\') ) *dest++ = *src++;
		*dest++ = '\\';
		*dest = '\0';
	}else{
		tstrcpy(tls.username, UserName);
	}

	// LbVꂽ[UƃpX[ho -----------------
	if ( NO_ERROR == GetCustTable(T("_IDpwd"), tls.path, phrasebuf, sizeof(phrasebuf)) ){
		ERRORCODE ec;
		TCHAR *ptr;

		ptr = phrasebuf;
		ReadEString(&ptr, tls.username, sizeof(tls.username));
		ptr = tls.username + tstrlen(tls.username) + 1;
		tstrcpy(tls.password, ptr);
		ClearMemory(ptr, sizeof(tls.password) - (ptr - tls.username) * sizeof(TCHAR) );
		nr.dwType = RESOURCETYPE_DISK;
		nr.lpLocalName = NULL;
		nr.lpRemoteName = tls.path;
		nr.lpProvider = NULL;
		ec = DWNetAddConnection3(hWnd, &nr, tls.password, tls.username, 0);
		ClearMemory(tls.password, sizeof(tls.password));
		if ( ec == NO_ERROR ){
			SetCurrentDirectory(vpath);
			return NO_ERROR;
		}
	}
	if ( (PasswordDialogWnd != NULL) && IsWindow(PasswordDialogWnd) ){
		er = ERROR_PATH_BUSY;
	}else{
		PasswordDialogWnd = hWnd;
		er = (PPxDialogBoxParam(DLLhInst, MAKEINTRESOURCE(IDD_LOGIN), hWnd,
				VFSChangeDirectoryDlgBox, (LPARAM)&tls) > 0) ?
				NO_ERROR : ERROR_ACCESS_DENIED;
		PasswordDialogWnd = NULL;
	}
	return er;
}

// [UFؕt SetCurrentDirectory -----------------------------------------
VFSDLL ERRORCODE PPXAPI VFSChangeDirectory(HWND hWnd, const TCHAR *path)
{
	return VFSTryDirectory(hWnd, path, TRYDIR_CHECKEXIST);
}

VFSDLL ERRORCODE PPXAPI VFSTryDirectory(HWND hWnd, const TCHAR *path, int trymode)
{
	ERRORCODE result;
	TCHAR FullPath[VFPS];
	int mode;
	TCHAR *vp;
	TCHAR regpath[VFPS], rpath[MAX_PATH];

	vp = VFSGetDriveType(path, &mode, NULL);
	if ( vp == NULL ){		// ނȂΎw̉\Ή
		VFSFullPath(FullPath, (TCHAR *)path, NULL);
		vp = VFSGetDriveType(FullPath, &mode, NULL);
		if ( vp == NULL ){	// łނȂG[
			return ERROR_BAD_PATHNAME;
		}
	}

	if ( mode == VFSPT_DRIVE ){	// A:
		thprintf(regpath, TSIZEOF(regpath), T("Network\\%c"), *(vp - 2));
		rpath[0] = '\0';
		GetRegString(HKEY_CURRENT_USER, regpath, RPATHSTR, rpath, TSIZEOF(rpath));
		if ( rpath[0] != '\0' ){ // lbg[NhCuł遨݃`FbN
			TCHAR *p;

			p = FindPathSeparator(rpath);
			if ( p == NULL ) p = rpath;
			if ( CheckComputerActive(rpath, p - rpath) == FALSE ){
				return ERROR_BAD_NETPATH;
			}
		}else{
			if ( trymode ) return NO_ERROR; // ݃`FbNȂ
		}
	}else if ( mode == VFSPT_UNC ){ // unc
		TCHAR *p;

		if ( *vp == '\0' ) return NO_ERROR;	// '\\'...łȂ̂ŏI

		p = FindPathSeparator(vp);
		if ( (p == NULL) || (*(p + 1) == '\0') ) return NO_ERROR; // \\pcname

		// WinXPȑȌꍇASetCurrentDirectory ŃubN|̂ŁA
		// \ߑ݂邩𒲂ׂĂB
		if ( CheckComputerActive(vp - 2, p - path) == FALSE ){
			return ERROR_BAD_NETPATH;
		}
	}else{ // GNC/UNC ȊO͎smȂ̂ŏI
//		XMessage(NULL, NULL, XM_DbgLOG, T("no check %s"),vp);
		return NO_ERROR;
	}
	vp -= 2;

	{ // :: t͊Oă`FbN
		TCHAR *p;

		p = tstrstr(vp, T("::"));
		if ( p != NULL ){
			tstrcpy(regpath, vp);
			regpath[p - vp] = '\0';
			vp = regpath;
		}
	}

	if ( trymode == TRYDIR_CHECKEXIST ){
	//	if ( tstrlen(vp) >= (MAX_PATH - 4) ) return ERROR_FILENAME_EXCED_RANGE;
		if ( IsTrue(SetCurrentDirectory(vp)) ) return NO_ERROR;
		result = GetLastError();
		if ( result == ERROR_INVALID_NAME ) return NO_ERROR; // ɒpX̉\
	}else{
		// trymode ̂ƂA擾\ȂƂȂG[
		//  SetCurrentDirectory ݂̂łȂƂ悤H
		if ( GetFileAttributesL(vp) != BADATTR ){
			return NO_ERROR;
		}else{
			result = GetLastError();
//			XMessage(NULL, NULL, XM_DbgLOG, T("try %Mm %s"),result, vp);
		}
	}

	if ( mode == VFSPT_DRIVE ){	// A:
		if ( (result == ERROR_PATH_NOT_FOUND) && (rpath[0] != '\0') ){
			result = VFSTryDirectory_Local(vp);
		}
	}else{
		if ( (result == ERROR_ACCESS_DENIED) ||
			 (result == ERROR_INVALID_PASSWORD) ||
			 (result == ERROR_ACCOUNT_DISABLED) ||
			 (result == ERROR_LOGON_FAILURE) ||
			 (result == ERROR_CANT_ACCESS_FILE) ||
			 (result == ERROR_LOGON_TYPE_NOT_GRANTED) ){
			// UNCȂ玩OŃ_CAO\
			if ( IsTrue(LoadNetFunctions()) ){
				ERRORCODE dlgresult;

//				XMessage(NULL, NULL, XM_DbgLOG, T("VFSTryDirectory_UNC %Mm %s"),result, vp);
				dlgresult = VFSTryDirectory_UNC(hWnd, vp);
				if ( dlgresult != ERROR_ACCESS_DENIED ) result = dlgresult;
			}
		}
	}
	return result;
}


BOOL IsRelativeDirectory(const TCHAR *path)
{
	return IsRelativeDir(path);
}

BOOL IsParentDirectory(const TCHAR *path)
{
	return IsParentDir(path);
}

DWORD PPXAPI GetSelAttr(const TCHAR *name)
{
	TCHAR buf[VFPS];

// SearchVLINE ֘A
#ifdef UNICODE
	tstrcpy(buf, name);
	tstrreplace(buf, T("|"), NilStr);
#else
	{
		char type, *dest;

		dest = buf;
		for ( ;; ){
			type = *name++;
			if ( type == '\0' ) break;
			if ( type == '|' ) continue;
			*dest++ = type;
			if ( Iskanji(type) ) *dest++ = *name++;
		}
		*dest = '\0';
	}
#endif
	return GetFileAttributesL(buf);
}

VFSDLL BOOL PPXAPI GetUniqueEntryName(TCHAR *src)
{
	TCHAR name[VFPS], ext[VFPS], splitter[16];
	int addnum = 0;
	int maxtry = 10000;	// ő厎s
	TCHAR *ptr;
	DWORD (PPXAPI * GetAttr)(const TCHAR *name), attr;

	GetAttr = (SearchVLINE(src) == NULL) ? GetFileAttributesL : GetSelAttr;
	attr = GetAttr(src);
	if ( attr == BADATTR ) return TRUE;
	if ( tstrlen(src) >= (VFPS - 5) ) return TRUE; // O̕ύXۏ؂łȂ

	tstrcpy(name, src);
	if ( attr & FILE_ATTRIBUTE_DIRECTORY ){
		ptr = name + tstrlen(name);
	}else{		// gqu
		ptr = VFSFindLastEntry(name);
		ptr += FindExtSeparator(ptr);
	}
#ifdef UNICODE
	while ( (ptr > name) && (*(ptr - 1) == '|') ) ptr--;
#else
	// ͊Ȉ
	while ( (ptr > (name + 1) ) && (*(ptr - 1) == '|') && !Iskanji(*(ptr - 2)) ){
		ptr--;
	}
#endif
	tstrcpy(ext, ptr);
	*ptr = '\0';

						// ȑO̔ԍ𒊏o -------------------
	splitter[0] = '\0';
	GetCustTable(StrCustOthers, T("subnump"), splitter, TSIZEOF(splitter));
	if ( splitter[0] == '\0' ) tstrcpy(splitter, T("-"));
	tstrreplace(splitter, T("\""), NilStr);
	{
		size_t size;
		int mulnum = 1;

		size = tstrlen(splitter);
		for ( ; name < ptr ; mulnum *= 10 ){ // `(subnump)(l) 
			ptr--;

			if ( Isdigit(*ptr) ){
				addnum += ((int)*ptr - '0') * mulnum;
				continue;
			}

			if ( !memcmp(ptr, splitter, size * sizeof(TCHAR)) && (*(ptr + size) != '0') ){
				*ptr = '\0';
			}else{
				addnum = 0;
			}
			break;
		}
	}
						// 󂫂{ -------------------------
	do{
		if ( addnum != 0 ){
			thprintf(src, VFPS, T("%s%s%d%s"), name, splitter, addnum, ext);
		}else{
			thprintf(src, VFPS, T("%s%s"), name, ext);
		}
		addnum++;
		maxtry--;
		if ( maxtry == 0 ) return FALSE;
	}while( GetAttr(src) != BADATTR );
	return TRUE;
}

// hCu𒊏o -------------------------------------------------------
VFSDLL TCHAR * PPXAPI GetDriveName(_Out_writes_z_(VFPS) TCHAR *dst, _In_z_ const TCHAR *src)
{
	TCHAR *p, *q, *r;
	int mode;

	*dst = '\0';
	p = VFSGetDriveType(src, &mode, NULL);
	if ( p == NULL ) return NULL;
	if ( mode == VFSPT_DRIVE ){
		memcpy(dst, p - 2, TSTROFF(2));
		*(dst + 2) = '\\';
		*(dst + 3) = '\0';
		return p;
	}else if ( mode == VFSPT_UNC ){
		q = FindPathSeparator(p);
		if ( q == NULL ) return NULL;
		r = FindPathSeparator(q + 1);
		if ( r == NULL ){
			r = q + tstrlen(q);
		}
		memcpy(dst, p - 2, TSTROFF(r - p + 2));
		*(dst + (r - p + 2)) = '\\';
		*(dst + (r - p + 3)) = '\0';
		return r;
	}
	return NULL;
}

void GetIDLSub(TCHAR *path, LPSHELLFOLDER pSF, LPITEMIDLIST pSHidl)
{
	TCHAR *destp;
	BYTE *idlPtr;

	tstrcpy(path, T("#:\\"));
	destp = path + 3; // '\0'
	idlPtr = (BYTE *)pSHidl;
	while( *(WORD *)idlPtr != 0 ){
		WORD *nextp, old;

		nextp = (WORD *)(BYTE *)(idlPtr + *(WORD *)idlPtr);
		old = *nextp;
		*nextp = 0;
		if ( FALSE == PIDL2DisplayNameOf(destp, pSF, pSHidl) ) break;
		*(destp - 1) = '\\'; // '\0''\\'
		destp += tstrlen(destp) + 1;
		*nextp = old;
		idlPtr = (BYTE *)nextp;
	}
}

VFSDLL DWORD PPXAPI GetReparsePath(const TCHAR *path, TCHAR *pathbuf)
{
	HANDLE hFile;
	REPARSE_DATA_IOBUFFER rdio;
	DWORD size;

	*pathbuf = '\0';
	hFile = CreateFileL(path, 0, 0, NULL, OPEN_EXISTING,
			FILE_FLAG_BACKUP_SEMANTICS | FILE_FLAG_OPEN_REPARSE_POINT, NULL);
	if ( hFile == INVALID_HANDLE_VALUE ) return 0;

	if ( IsTrue(DeviceIoControl(hFile, FSCTL_GET_REPARSE_POINT,
			NULL, 0, &rdio, sizeof(rdio), &size, NULL)) ){
		if ( rdio.ReparseTag == IO_REPARSE_TAG_LX_SYMLINK ){ // WSL
			DWORD len;

			len = rdio.ReparseDataLength - sizeof(rdio.data.LxSymlinkReparseBuffer.FileType);
			if ( len >= MAXIMUM_REPARSE_DATA_BUFFER_SIZE ){
				len = MAXIMUM_REPARSE_DATA_BUFFER_SIZE - 1;
			}
			rdio.data.LxSymlinkReparseBuffer.PathBuffer[len] = '\0';
#ifdef UNICODE
			len = MultiByteToWideCharU8(CP_UTF8, 0, rdio.data.LxSymlinkReparseBuffer.PathBuffer, -1, pathbuf, VFPS - 1);
			pathbuf[len] = '\0';
#else
			{
				WCHAR bufW[VFPS];

				MultiByteToWideCharU8(CP_UTF8, 0, rdio.data.LxSymlinkReparseBuffer.PathBuffer, -1, bufW, VFPS);
				bufW[VFPS - 1] = '\0';
				strcpyWToT(pathbuf, bufW, VFPS);
				pathbuf[VFPS - 1] = '\0';
			}
#endif
		}else{
			WCHAR *src;

			src = rdio.data.ReparseGuid.PathBuffer + (rdio.data.ReparseGuid.SubstituteNameOffset / sizeof(WCHAR));
			if ( rdio.ReparseTag == IO_REPARSE_TAG_SYMLINK ){
				src += sizeof(DWORD) / sizeof(WCHAR); // flags XLbv
			}

			if ( ((DWORD_PTR)((BYTE *)src - (BYTE *)&rdio) + rdio.data.ReparseGuid.SubstituteNameLength) >= sizeof(rdio) ){
				rdio.ReparseTag = 0;
			}else{
				src[rdio.data.ReparseGuid.SubstituteNameLength / sizeof(WCHAR)] = '\0';
				// Ύw \?\C:... \?\UNC\... \?\Volume
				if ( memcmp(src, L"\\??\\", 4 * sizeof(WCHAR)) == 0 ){
					src += 4;
					if ( memicmp(src, L"UNC\\", 4 * sizeof(WCHAR)) == 0 ){
						src += 2;
						*src = '\\';
					}
				}
				strcpyWToT(pathbuf, src, VFPS);
			}
		}
	}else{
		rdio.ReparseTag = 0;
	}
	CloseHandle(hFile);
	return rdio.ReparseTag;
}

TCHAR *SplitAuxName(const TCHAR *AuxPath, TCHAR *dest)
{
	TCHAR *ptr = dest, sep = '\\';

	AuxPath += 4;
	if ( *AuxPath == '/' ){
		sep = '/';
		while ( *AuxPath == '/' ) AuxPath++;
	}
	tstrcpy(dest, AuxPath);

	for (;;){
		if ( *ptr == '\0' ) break;
		if ( *ptr == sep ){
			*ptr++ = '\0';
			break;
		}
		ptr++;
	}
	return ptr;
}
