/*-----------------------------------------------------------------------------
	Paper Plane xUI	 Virtual File System

	 shlobj.h  include ȂƁAꕔ̒`ɂȂ
-----------------------------------------------------------------------------*/
#ifdef ONPPXDLL
#define ONVFSDLL
#endif
#if !NODLL && !defined(WINEGCC)
	#ifdef ONVFSDLL
		#define VFSDLL __declspec(dllexport)
	#else
		#define VFSDLL __declspec(dllimport)
	#endif
#else
	#define VFSDLL
#endif

#if 0 || defined(WINEGCC)
#define USESLASHPATH
#endif

#ifdef __cplusplus
extern "C" { // Assume C declarations for C++
#endif // __cplusplus
//--------------------------------------------------------- ʒ`
#define VFS_check_size		0x11000	// t@C`ʂɎgwb_̃TCY
#define VFS_TINYREADSIZE	0x800 // EXEwb_̔fɕKvȃTCY
#define VFS_ARCREADSIZE		0x2000 // EXEɓ̏ɂ̔ʂɕKvȃTCY
#define VFS_GENERALREADSIZE	0x4000 // ʂ̔ʂɕKvȃTCY

								// fBNg̎ -------------------------
#define VFSDT_UNKNOWN	0			// s
#define VFSDT_PATH		1			// path(drive/unc)
#define VFSDT_DLIST		2			// Drive list
#define VFSDT_SHN		3			// SHN/Shell's Namespace
#define VFSDT_LFILE		4			// list file
#define VFSDT_FATIMG	5			// FAT / ExFAT / NTFS disk image file
#define VFSDT_FATDISK	6			// FAT / ExFAT / NTFS disk raw access
#define VFSDT_CDIMG		7			// CD-ROM / UDF image file
#define VFSDT_CDDISK	8			// CD-ROM / UDF raw access
#define VFSDT_STREAM	9			// xxx:xxxx
#define VFSDT_SLASH		10			// posixn /
#define VFSDT_AUXOP		11			// Auxiliary Operation
#define VFSDT_RAWIMG	20			// RAW disk raw access (fop  raw copy p)
#define VFSDT_FTP		21			// FTP
#define VFSDT_ARCFOLDER	60			// archive folder (zipflder.dll, 7z,bz2,gz,rar,tar,tbz2,tgz,txz,tzst,xz,zst)
#define VFSDT_CABFOLDER	61			// cab folder (cabview.dll, cab)
#define VFSDT_LZHFOLDER	62			// lzh folder (lzhfldr2.dll, lzh)
#define VFSDT_ZIPFOLDER	63			// zip folder (zipflder.dll, zip)
#define VFSDT_SUSIE		64			// SUSIE
#define VFSDT_HTTP		80			// HTTP
#define VFSDT_UN		96			// UNxxx

#define LHEADER		";ListFile\r\n"
#define LHEADERU	";\0L\0i\0s\0t\0F\0i\0l\0e\0\r\0\n" // Ō\0ȗ
#define LHEADERJSONO	"{\"ListFile\""
#define LHEADERJSONT	"[\"ListFile\""

#define X_wdel_default {1, 0, 1, 1}

//--------------------------------------------------------- SDKɂȂ`
#ifndef COPY_FILE_FAIL_IF_EXISTS
#define COPY_FILE_FAIL_IF_EXISTS        0x00000001
#define COPY_FILE_RESTARTABLE           0x00000002
#define COPY_FILE_OPEN_SOURCE_FOR_WRITE 0x00000004
#define CALLBACK_CHUNK_FINISHED         0x00000000
#define CALLBACK_STREAM_SWITCH          0x00000001

#define PROGRESS_CONTINUE   0
#define PROGRESS_CANCEL     1
#define PROGRESS_STOP       2
#define PROGRESS_QUIET      3
#endif

#ifndef CopyFileEx
typedef DWORD (WINAPI *LPPROGRESS_ROUTINE)(
	LARGE_INTEGER TotalFileSize,
	LARGE_INTEGER TotalBytesTransferred,
	LARGE_INTEGER StreamSize,
	LARGE_INTEGER StreamBytesTransferred,
	DWORD dwStreamNumber,
	DWORD dwCallbackReason,
	HANDLE hSourceFile,
	HANDLE hDestinationFile,
	LPVOID lpData OPTIONAL);
#endif

#define VFSFT_TYPE		B0	// ޖ ":type"
#define VFSFT_TYPETEXT	B1	// ޖڍ "type name"
#define VFSFT_EXT		B2	// ޖɊYgq "EXT"
#define VFSFT_INFO		B3	// t@C擾 "rect=640x480\r\n"
#define VFSFT_COMMENT	B4	// t@C擾Rg "comment text"
#define VFSFT_BIGBUF	B5	// image == NULL A傫t@Cobt@g(X_wsiz܂)
#define VFSFT_STRICT	B30	// ނm肵Ȃꍇ̓G[ɂ(Ȃ)

#define VFSFILETYPE_TYPESIZE	16
#define VFSFILETYPE_TEXTSIZE	80
#define VFSFILETYPE_EXTSIZE		16
typedef struct {
	DWORD flags;		// ǂ̏擾邩̎w VFSFT_
	DWORD dtype;		// PPv p(LOWORD:DISPT_xx, HIWORD:VD_xx)
	TCHAR type[VFSFILETYPE_TYPESIZE];		// VFSFT_TYPE ̌
	TCHAR typetext[VFSFILETYPE_TEXTSIZE];	// VFSFT_TYPETEXT ̌
	TCHAR ext[VFSFILETYPE_EXTSIZE];			// VFSFT_EXT ̌
	TCHAR *info;		// VFSFT_INFO ̌ʁAHeapFree(GetProcessHeap(cŉ
	TCHAR *comment;		// VFSFT_COMMENT ̌ʁAHeapFree(GetProcessHecŉ
} VFSFILETYPE;

#define VFSFTSIZE_FROMTYPE MAX32 // imagesize wAgq(:dir)w肵Ď擾
/*-----------------------------------------------------------------------------
	wt@C^C[W̎ʂ𔻕ʂ

	FileName	t@C
	header		(size != 0)C[W̐擪
	size		(=0)FileNamet@C𔻕
				(!0)FileNameheaderɔ
	result		ʂލ\
-----------------------------------------------------------------------------*/
extern VFSDLL ERRORCODE PPXAPI VFSGetFileType(const TCHAR *FileName, const char *image, SIZE32_T imagesize, VFSFILETYPE *result);
extern VFSDLL BOOL PPXAPI VFSCheckFileByExt(const TCHAR *FileName, TCHAR *result);
extern VFSDLL DWORD PPXAPI ReadFileHeader(HANDLE hFile, BYTE *header, SIZE32_T headersize);

extern VFSDLL TCHAR * PPXAPI GetDriveName(_Out_writes_z_(VFPS) TCHAR *dst, _In_z_ const TCHAR *src);
extern VFSDLL ERRORCODE PPXAPI CreateJunction(const TCHAR *FileName, const TCHAR *ExistingFileName, SECURITY_ATTRIBUTES *sa);
/*=============================================================================
=============================================== ɒpXΉWin32API݊֐ */
extern VFSDLL HANDLE PPXAPI CreateFileL(const TCHAR *FileName, DWORD Access,
		DWORD ShareMode, LPSECURITY_ATTRIBUTES SecurityAttributes,
		DWORD CreationDisposition, DWORD FlagsAndAttributes,
		HANDLE hTemplateFile);

extern VFSDLL BOOL PPXAPI DeleteFileL(const TCHAR *FileName);
extern VFSDLL BOOL PPXAPI CreateDirectoryL(const TCHAR *FileName,
		LPSECURITY_ATTRIBUTES sa);
extern VFSDLL BOOL PPXAPI RemoveDirectoryL(const TCHAR *FileName);
extern VFSDLL HANDLE PPXAPI FindFirstFileL(_In_z_ const TCHAR *dir, _Out_ WIN32_FIND_DATA *findfile);
extern VFSDLL DWORD PPXAPI GetFileAttributesL(const TCHAR *FileName);
extern VFSDLL BOOL PPXAPI SetFileAttributesL(const TCHAR *FileName, DWORD attributes);

// WIN32_FIND_DATAcFileName,cAlternateFileNameȊȌ擾
typedef WIN32_FIND_DATA FILE_STAT_DATA;
extern VFSDLL BOOL PPXAPI GetFileSTAT(const TCHAR *lpFileName, FILE_STAT_DATA *FindFileData);

extern VFSDLL BOOL PPXAPI MoveFileWithProgressL(const TCHAR *ExistingFileName,
		const TCHAR *NewFileName,
		LPPROGRESS_ROUTINE ProgressRoutine, LPVOID Data, DWORD dwFlags);
#define MoveFileL(ExistingFileName, NewFileName) MoveFileWithProgressL((ExistingFileName), (NewFileName), NULL, NULL, 0)

extern VFSDLL BOOL PPXAPI CopyFileExL(const TCHAR *ExistingFileName,
		const TCHAR *NewFileName, LPPROGRESS_ROUTINE ProgressRoutine,
		LPVOID Data, LPBOOL Cancel, DWORD CopyFlags);

/*=============================================================================
==================================================================  ʊ֐ */
/*-----------------------------------------------------------------------------
	VFS  Plug Dll @\LɂA֘A DLL ǂݍށBxĂяo邪A
	̉񐔂AVFSOff gpKvB

	mode	Lɂ@\iL define QƁjB鎞"|"wB
-----------------------------------------------------------------------------*/
#define VFS_BMP			B0			// bitmap
#define VFS_DIRECTORY	B1			// directory
#define VFS_ALL			B31			// ɂPlugDLLǂݍ
extern VFSDLL void PPXAPI VFSOn(int mode);

/*-----------------------------------------------------------------------------
	VFS  Plug - in @\𖳌ɂBŌɌĂ΂ꂽAPlugin DLL 
-----------------------------------------------------------------------------*/
extern VFSDLL void PPXAPI VFSOff(void);

//-------------------------------------- wURL̃C[W擾
extern VFSDLL BOOL PPXAPI GetImageByHttp(const TCHAR *urladr, ThSTRUCT *th);
extern VFSDLL HRESULT PPXAPI MakeShortCut(const TCHAR *LinkedFile, const TCHAR *LinkFname, const TCHAR *DestPath);

extern VFSDLL ERRORCODE PPXAPI VFSGetArchivefileImage(HWND hWnd, HANDLE hFile, const TCHAR *ArchiveName, const TCHAR *EntryName, SIZE32_T *sizeL, SIZE32_T *sizeH, HANDLE *hMap, BYTE **mem);

// ACgƂ̂ŌŒɂ on X64
#pragma pack(push, 4)
typedef struct {
	WIN32_FIND_DATA ff;
	TCHAR dest[VFPS];
	LPPROGRESS_ROUTINE Progress;
	LPVOID lpData;
	BOOL *Cancel;
} IMAGEGETEXINFO;
#pragma pack(pop)
/*-----------------------------------------------------------------------------
	FindFirstFilenVFSŁBgFindFirstFilenƓȂ̂ŏȗ
-----------------------------------------------------------------------------*/
#define FILE_ATTRIBUTEX_LF_MARK	B25	// ListFileŃ}[NLBPPxƎg
// #define FILE_ATTRIBUTEX_LF_COMMENT	B26	// ListFileŃRgLBPPxƎg 1.78p~
#define FILE_ATTRIBUTEX_NODETAIL	B26	// t@CȊȌ񂪂ȂBƎg
		// 1.95 B29B26 ֈړ(FILE_ATTRIBUTE_STRICTLY_SEQUENTIALΉ)
#define FILE_ATTRIBUTEX_FOLDER	B27	// t@CtH_Ȃǂ\BPPxƎg
#define FILE_ATTRIBUTEX_VIRTUAL	B28	// zGg\BPPxƎg
		// SHN  WIN32_FIND_DATA łȂGgB
#define FILE_ATTRIBUTEX_EXTRA	B30	// ǉ񂠂(VFSFindOptionData)BƎg1.78
#define FILE_ATTRIBUTEX_MESSAGE (FILE_ATTRIBUTE_LABEL | FILE_ATTRIBUTE_TEMPORARY)	// ListfileBbZ[WGg

extern VFSDLL HANDLE PPXAPI VFSFindFirst(const TCHAR *dir, WIN32_FIND_DATA *findfile);
extern VFSDLL BOOL PPXAPI VFSFindNext(HANDLE hFF, WIN32_FIND_DATA *findfile);
extern VFSDLL BOOL PPXAPI VFSFindClose(HANDLE hFF);

#define WFD_R1_SIGNATURE B0
//#define WFD_R1_HEADDATA B1
#define WFD_R1_JSON B1
#define WFD_R1_JSON_OBJ B2

// optionID
#define FINDOPTIONDATA_LONGNAME	1 // MAX_PATHz̃t@C(VFPS)擾
#define FINDOPTIONDATA_COMMENT	2 // Rg(T: , CMDLINESIZE)
#define FINDOPTIONDATA_EXTRA	3 // FILE_ATTRIBUTEX_EXTRA = 1 ̂Ƃ FOD_EXTRADATA 擾
#define FINDOPTIONDATA_SETCALLBACK	4 // ǉ FOD_CALLBACK o^BX PathInfo Kvȕs
#define FINDOPTION_LONGNAME '>' // MAX_PATH z̃t@ĈƂAcFileName[0]

#define FODE_COLOR	B0 // gqF(X:)
#define FODE_HIGHLIGHT	B1 // nCCg(H:)
#define FODE_COMMENT	B2 // Rg(T:)
//#define FODE_EXTDATA	B3 // gRg,Jg(On:) gp̂ߍ폜2.03
#define FODE_MARK_ON	B4 // }[N(M:1) FODE_MARK_ON  FILE_ATTRIBUTEX_EXTRA  on ɂȂ FILE_ATTRIBUTEX_LF_MARK  on ɂ
#define FODE_MARK_OFF	B5 // }[N(M:0)
#define FODE_MARK_TOGGLE	B6 // }[N](M:-1)
typedef struct {
	DWORD size; // FOD_EXTRADATȂ傫
	DWORD mask; // FODE_xxx
	COLORREF extC; // gqF(X:)
	DWORD highlight; // nCCg(H:)
} FOD_EXTRADATA;

struct tagFOD_CALLBACK;
typedef void (PPXAPI *FODC_PathInfo)(struct tagFOD_CALLBACK *extra, const TCHAR *key, const TCHAR *value, size_t valuelen);
typedef void (PPXAPI *FODC_EntryInfo)(struct tagFOD_CALLBACK *extra, const TCHAR *key, const TCHAR *value, size_t valuelen);

typedef struct tagFOD_CALLBACK {
	PPXAPPINFO *appinfo;
	FODC_PathInfo PathInfo;
	FODC_EntryInfo EntryInfo;
} FOD_CALLBACK;

extern VFSDLL BOOL PPXAPI VFSFindOptionData(HANDLE hFF, DWORD optionID, void *data);

// VFSFind ɓǂݍݑΏۂ̏ڍ׏擾
// ftable
// VFSDT_LFILE	ListFileeLXgւ̃|C^
// VFSDT_SUSIE	SUSIE_FINFO ւ̃|C^
// VFSDT_UN		UN_DLL ւ̃|C^
// type  VFSGETFFINFO_TYPESIZE ̑傫Kv
// VFSFILETYPE Őݒ肳閼
#define VFSFFTYPENAME_STREAM	T("stream")
#define VFSFFTYPENAME_HTML		T("HTML")
#define VFSFFTYPENAME_FAT		T("FAT")
#define VFSFFTYPENAME_CD		T("CD")
#define VFSFFTYPENAME_ZIPfolder	T("ZIPfdr")
#define VFSFFTYPENAME_LHAfolder	T("LHAfdr")
#define VFSFFTYPENAME_CABfolder	T("CABfdr")
#define VFSFFTYPENAME_ARCfolder	T("ARCfdr")
#define VFSFFTYPENAME_DriveList	T("Drives")
#define VFSFFTYPENAME_FTP		T("FTP")
#define VFSFFTYPENAME_root		T("/")
#define VFSFFTYPENAME_Network	T("Netwrk")
#define VFSFFTYPENAME_LongPath	T("Xlong")
#define VFSFFTYPENAME_SHN		T("ShellN")
#define VFSFFTYPENAME_desktopSHN	T("desktopS ")
#define VFSFFTYPENAME_directorySHN	T("dir-SHN ")
#define VFSFFTYPENAME_vfolderSHN	T("vfolderS ")
#define VFSFFTYPENAME_storageSHN	T("storageS ")
#define VFSFFTYPENAME_exFAT 	T("exFAT")
#define VFSFFTYPENAME_NTFS		T("NTFS")

// path::id Ŏw\ ID
#define VFS_TYPEID_LISTFILE	T("listfile")
#define VFS_TYPEID_JSON		T("JSON")
#define VFS_TYPEID_STREAM	VFSFFTYPENAME_STREAM
#define VFS_TYPEID_CDROM	VFSFFTYPENAME_CD
#define VFS_TYPEID_DISK		T("disk") // VFSFFTYPENAME_FAT
#define VFS_TYPEID_zipfldr	T("zipfldr.dll")
#define VFS_TYPEID_lzhfldr	T("lzhfldr2.dll")
#define VFS_TYPEID_cabfldr	T("cabview.dll")
#define VFS_TYPEID_arcfolder T("arcfolder")
// DLL c Susie / Unxxx (iftwic.spi / unlha32.dll)

// VFSDT_LFILE ̂ƂAmode Ɏw肷邱Ƃœl
#define VFSGETFFINFOMODE_LF_BASE 1 // ;Base=
#define VFSGETFFINFOMODE_IDMAX 10
// type ̑傫 VFSGETFFINFO_TYPESIZEAVFSGETFFINFOMODE_LF_BASE ́AVFPS
// dt_opt
//  VFSDT_LFILE ListFile ݂̌̓ǂݍ݈ʒu
//  VFSDT_SUSIE SUSIE_DLL  index
//  VFSDT_UN UN_DLL  index
extern VFSDLL void PPXAPI VFSGetFFInfo(HANDLE hFF, int *mode, TCHAR *type, void **dt_opt);

// VFSCheckDir: VFSFindFirst ̑Ώۂł邩𒲂ׂ
// filename  `::dllname ̂ƂAu::dllnamev폜
//hsize ɕtBfnctable  HMENU 
#define VFSCHKDIR_GETDIRMENU B31		// dirړp
#define VFSCHKDIR_GETEXTRACTMENU B30	// WJp
#define VFSCHK_MENUID 0xe200 // VFSCheckDir / VFSCheckImage Œǉ擪 ID
extern VFSDLL int PPXAPI VFSCheckDir(_Inout_ TCHAR *filename, BYTE *header, SIZE32_T headersize, void **dt_opt); // filename  :: ȍ~폜
extern VFSDLL int PPXAPI VFSCheckImage(const TCHAR *filename, BYTE *header, SIZE32_T headersize, HMENU hPopupMenu);

// evOCgărbg}bv擾
typedef struct {
	DWORD header, state;
	void *image;
	DWORD_PTR size;
	DWORD page_number, all_pages;
	DWORD animate_time, rotate;
	SIZE request_size;
} VFSGetDibDelayParam;
#define VGDDP_HEADER (sizeof(VFSGetDibDelayParam) + 0x16000)

extern VFSDLL BOOL PPXAPI VFSGetDib(const TCHAR *filename, void *image, SIZE32_T sizeL, TCHAR *type, HANDLE *Info, HANDLE *Bm);
extern VFSDLL int PPXAPI VFSGetDibDelay(const TCHAR *filename, void *param, SIZE32_T paramsize, TCHAR *type, HANDLE *Info, HANDLE *Bm, DWORD (*AllReadProc)(void));

// w肵hCuSHN\擾 tbs[ANZXȂ
extern VFSDLL void PPXAPI GetDriveNameTitle(TCHAR *buf, TCHAR drive);
extern VFSDLL DWORD PPXAPI GetReparsePath(const TCHAR *path, TCHAR *pathbuf);

/*=============================================================================
======================================================== Path 񑀍֌W */
/*-----------------------------------------------------------------------------
	gq̈ʒu擾

	Kwwuxx.xxx\yyyv̏ꍇ́A
		(VFSFindLastEntry(src) - src) + FindExtSeparator(VFSFindLastEntry(src))
		ƂČ邱

	src:	ւ̃|C^
	->		src ɑ΂鑊Έʒu(".")Bgqꍇ́Asrc ̖[
-----------------------------------------------------------------------------*/
extern VFSDLL int PPXAPI FindExtSeparator(const TCHAR *src);

/*-----------------------------------------------------------------------------
	̃pX؂擾		pX؂́u\v̂

	vfp:	ւ̃|C^Aꂪu\vƖ߂l vfp ɂȂ
	->		u\vBNULL Ȃ玸s
-----------------------------------------------------------------------------*/
extern VFSDLL TCHAR * PPXAPI FindPathSeparator(const TCHAR *src);

/*-----------------------------------------------------------------------------
	ŉw̃Gg|C^肷

	src:	ւ̃|C^
	->		ɎʒuԂ

	a:\dir1\dir2\dir3		entryonly
	   ^   ^    ^			^
-----------------------------------------------------------------------------*/
extern VFSDLL TCHAR * PPXAPI VFSFindLastEntry(const TCHAR *src);

/*-----------------------------------------------------------------------------
	hCu̎ނ𒲂ׂ

	vfp:	ւ̃|C^
	mode:	ߒlƂăhCu̎ނi[邽߂̃|C^BNULLw
				0<	SHNB]-1  SHGetSpecialFolderLocation p̒l
				ȂAL define  VFSPT_xxx ɊY

	force:	ߒlƂĎނ̋wi[邽߂̃|C^BNULLw
				L define  VFSPTF_xxx ɊY

	->		hCu̎ނ̎̃|C^(Root ẃu\v΂)
			NULLȂ玸s

		UNC					GNC				URL
			\\xxx\yyy\...		@:\xxx...		xxxx://xxxxx/
			  ^					  ^							^
-----------------------------------------------------------------------------*/
#define VFSPT_SHN_DESK	-1		// -1 ȉȂ΁AExplorer ̓pX
#define VFSPT_UNKNOWN	0		// VFSGetDriveType ݂̂ł̏ԂɂȂ
#define VFSPT_DRIVE		1		// 'x:'
#define VFSPT_DRIVELIST	2		// ':'
#define VFSPT_UNC		3		// '\\'
#define VFSPT_SLASH		4		// '/'
#define VFSPT_RAWDISK	6		// disk raw access
#define VFSPT_FILESCHEME 20		// 'file://'
#define VFSPT_FTP		21		// 'ftp://'
#define VFSPT_SHELLSCHEME 22	// 'shell://'
#define VFSPT_AUXOP		23		// 'aux:'
#define VFSPT_HTTP		80		// 'http://'

#define VFSPTF_AUTO		0		//	:ł邾 DriveName/UNC gp
#define VFSPTF_FS		1		// -: UNC/DN gp
#define VFSPTF_SHN		2		// +: Shell's Namespace gp

_Success_(return != NULL) extern VFSDLL TCHAR * PPXAPI VFSGetDriveType(_In_z_ const TCHAR *vfp, _Out_opt_ int *resultmode, _Out_opt_ int *force);

/*-----------------------------------------------------------------------------
	src  fname ̊ԂɁu\v 𐶐
	src ̖[Ɂu\vĂȂĂ悢

	dst:	|C^B NULL Ȃ src Ɍʂ
	src:	Oɔzu镶Bdst  NULL ȂAobt@
	fname:	㑤ɔzu镶
	->		void
-----------------------------------------------------------------------------*/
extern VFSDLL void PPXAPI CatPath(TCHAR *dst, TCHAR *src, _In_z_ const TCHAR *fname);

/*-----------------------------------------------------------------------------
	src 𐳋KpXɕϊ

	dst:	|C^B NULL Ȃ src Ɍʂ
	src:	ϊO̕ւ̃|C^Bdst  NULL Ȃ炱Ɍʂ
	cur:	ƂȂpXւ̃|C^BNULL Ȃ GetCurrentDirectory ̓e
	flag:	K@ K擪Ɩ́A󔒂ƃ^u

	->		NULL						ϊɎs
			(flag & VFSFIX_FULLPATH)	ŉw̃Gg|C^
			!(flag & VFSFIX_FULLPATH)	ϊꂽpX̐擪
-----------------------------------------------------------------------------*/
// flags p萔
#define VFSFIX_DRIVE		B0	// PhCuw̕␳i"A""A:"j
#define VFSFIX_SEPARATOR	B1	// Zp[^"\", "/" ̕␳i"/""\"j
// #define VFSFIX_CASE		B2	// 啶(1.12薳)
#define VFSFIX_FULLPATH		B3	// Ύwɕϊi"A:""A:\WINDOWS"j
#define VFSFIX_REALPATH		B4	// zpX̎̉
#define VFSFIX_NOBLANK		B5	// 󗓂G[Ƃ
#define VFSFIX_NOFIXEDGE	B6	// 擪E[̉HȂ(`ς݂𗘗p)
#define VFSFIX_VREALPATH	B7	// zpX̎̉(̉łȂƂ͂̂܂)
#define VFSFIX_KEEPLASTPERIOD	B8	// u.vێ
#define VFSFIX_DISABLE_EXPAND	B9	// VFSFIX_FULLPATH  ϐ̓WJsȂ

#define VFSFIX_VFPS			(VFSFIX_DRIVE | VFSFIX_SEPARATOR | VFSFIX_FULLPATH)
#define VFSFIX_PATH			(VFSFIX_VFPS | VFSFIX_REALPATH)
extern VFSDLL TCHAR * PPXAPI VFSFixPath(TCHAR *dst, TCHAR *src, _In_opt_z_ const TCHAR *cur, int flags);

/*-----------------------------------------------------------------------------
	Ύw src Ύw cur Ύwɕϊ
	Kw؂'\'̂

	dst:	|C^B NULL Ȃ src Ɍʂ
	src:	ϊO̕ւ̃|C^Bdst  NULL Ȃ炱Ɍʂ
	cur:	ƂȂpXւ̃|C^BNULL Ȃ GetCurrentDirectory ̓e

	->		NULL			ϊɎs
			!NULL			ŉw̃Gg|C^
			́ArootȂu***\vAdirȂu***v
-----------------------------------------------------------------------------*/
extern VFSDLL TCHAR * PPXAPI VFSFullPath(TCHAR *dst, TCHAR *src, _In_opt_z_ const TCHAR *cur);

/*-----------------------------------------------------------------------------
	zfBNg̉
-----------------------------------------------------------------------------*/
extern VFSDLL BOOL PPXAPI VFSGetRealPath(HWND hWnd, TCHAR *path, const TCHAR *vfs);

/*-----------------------------------------------------------------------------
	wpXꊇ쐬
-----------------------------------------------------------------------------*/
extern VFSDLL ERRORCODE PPXAPI MakeDirectories(const TCHAR *dst, const TCHAR *src);

extern VFSDLL ERRORCODE PPXAPI VFSChangeDirectory(HWND hWnd, const TCHAR *path);
#define TRYDIR_CHECKEXIST 0
#define TRYDIR_SPEEDCHECK 1
extern VFSDLL ERRORCODE PPXAPI VFSTryDirectory(HWND hWnd, const TCHAR *path, int trymode);

// KvȂu-nvtāAd̂ȂOɂ
extern VFSDLL BOOL PPXAPI GetUniqueEntryName(TCHAR *src);
/*=============================================================================
================================ Shell's Namespace IDL ֌WAv shlobj.h */
#ifdef _SHLOBJ_H_
extern VFSDLL BOOL PPXAPI PIDL2DisplayNameOf(TCHAR *name, LPSHELLFOLDER sfolder, LPCITEMIDLIST pidl); // SHGDN_INFOLDER ̂
extern VFSDLL BOOL PPXAPI PIDL2DisplayName(TCHAR *name, LPSHELLFOLDER sfolder, LPCITEMIDLIST pidl, int SHGDNflags);
extern VFSDLL LPSHELLFOLDER PPXAPI VFPtoIShell(HWND hWnd, const TCHAR *vfp, LPITEMIDLIST *idl);
extern VFSDLL UINT PPXAPI GetPidlSize(LPCITEMIDLIST pidl);
extern VFSDLL LPITEMIDLIST PPXAPI PathToPidl(LPCTSTR pszFile);
extern VFSDLL LPSHELLFOLDER PPXAPI PidlToIShell(LPCITEMIDLIST  pidl);
extern VFSDLL LPITEMIDLIST PPXAPI IShellToPidl(LPSHELLFOLDER pParent, LPCTSTR pszFile);
extern VFSDLL LPITEMIDLIST PPXAPI BindIShellAndFname(LPSHELLFOLDER pParentFolder, const TCHAR *fname);
extern VFSDLL LPITEMIDLIST PPXAPI BindIShellAndFdata(LPSHELLFOLDER pParentFolder, WIN32_FIND_DATA *fdata);
extern VFSDLL void PPXAPI FreePIDL(LPCITEMIDLIST pidl);

#define SHCM_NOSHIFTKEY	B31
#define SHCM_EXTENDED	B30
#define SHCM_ITEMMENU	B29
#define SHCM_VIEWPANE	B28
#define SHCM_PIECESMASK 0x0fffffff
extern VFSDLL BOOL PPXAPI SHContextMenu(HWND hwnd, LPPOINT lppt, LPSHELLFOLDER lpsfParent, LPITEMIDLIST *lpi, int flags_pieces, const TCHAR *cmd);
extern VFSDLL BOOL PPXAPI VFSMakeIDL(const TCHAR *path, LPSHELLFOLDER *ppSF, LPITEMIDLIST *pidl, const TCHAR *filename);
extern VFSDLL void PPXAPI GetTextFromCF_SHELLIDLIST(TCHAR *text, SIZE32_T textsize, HGLOBAL hGMem, BOOL lf);
#endif
extern VFSDLL BOOL PPXAPI VFSSHContextMenu(HWND hWnd, LPPOINT pos, const TCHAR *path, const TCHAR *entry, const TCHAR *cmd);
/*=============================================================================
============================================================= File Operation */
#define VFSFOP_AUTOSTART	B0	// [OK]ȂĂɏJn
#define VFSFOP_FREEFILES	B1	// files  HeapFree(GetProcessHeap())ŉ
#define VFSFOP_NOTIFYREADY	B2	// 쐬_CAO(hDialogWnd)ʒm
#define VFSFOP_SPECIALDEST	B3	// VFSFILEOPERATIONdestɂ
#define VFSFOP_USEKEEPDIR	B4	// KwČw(VFSFOP_OPTFLAG_KEEPDIR)gp\ɂ
#define VFSFOP_NEWDIRNAME	B5	// -src:path\src\* pAOL*FOPŏ
#define VFSFOP_MODELESSDIALOG	B6	// [hX_CAOŊJ
#define VFSFOP_SPLITTHREAD	B7	// ʃXbhŎs
#define VFSFOP_GENR_THREAD	B8	// CX^XXbh

typedef struct {
	const TCHAR *action;	// IN @
	const TCHAR *src;		// IN Rs[pX(NULL or "" : gp)
	const TCHAR *dest;		// IN Rs[揀pX(NULL or "" : gp)
	const TCHAR *files;		// IN Rs[̧ٖ name1\0name2\0...namex\0\0 `
	const TCHAR *option;	// IN ǉp[^(NULL or "" : gp)
	int dtype;				// IN Rs[̃t@C`(ʏ VFSDT_UNKNOWN )
	PPXAPPINFO *info;		// IN QƗp
	HWND hReturnWnd;		// IN IAANeBuɂEBhE(NULL:gp)
	DWORD flags;			// IN/OUT ǉw VFSFOP_
	HWND hLogWnd; // unused ʃEBhE ݖgp

	HANDLE hReadyEvent;		// IN /hDialogWndLʒmCxg(VFSFOP_NOTIFYREADYw莞̂ݐݒ肪Kv)
	HWND hDialogWnd;		// OUT 쐬ꂽ_CAO
} VFSFILEOPERATION;

extern VFSDLL BOOL PPXAPI PPxFileOperation(HWND hWnd, VFSFILEOPERATION *fileop);

#define VFSDE_WARNFILEINDIR B0	// Dir̃t@CΌx邩
#define VFSDE_REPORT B1	// logo͂邩
#define VFSDE_SYMDEL_SHIFT	2
#define VFSDE_SYMDEL_SYM	B2 // V{bNN/WNVdir
#define VFSDE_SYMDEL_FILE	B3 // V{bNN/WNVdirt@C폜
#define VFSDE_CHECK_OFFSCR_MARK	B4 // (PPc)ʊO}[NƂɌx
#define VFSDE_SKIP_SLIGHT_ERROR	B5	// yG[(t@CȂ)𖳎
typedef struct {
	PPXAPPINFO *info;
	const TCHAR *path;	// ΏۃpX
	DWORD OldTime;		// \Ԉp̎Ԍv
	DWORD count;		// 폜t@C
	DWORD useaction;	// G[̑Ώ@(Rg[ID)
	BOOL noempty;		// 폜łȂfBNgƂ TRUE
	DWORD flags;		// VFSDE_xxx
	DWORD warnattr;		// x鑮
} DELETESTATUS;

extern VFSDLL ERRORCODE PPXAPI VFSDeleteEntry(DELETESTATUS *dinfo, const TCHAR *path, DWORD attr);

extern VFSDLL ERRORCODE PPXAPI VFSLoadFileImage(const TCHAR *filename, DWORD margin, char **image, DWORD *imagesize, DWORD *filesize);

/*=============================================================================
============================================================= Tree */
#define VFSTREECLASS	"VfsTreeClass"
extern VFSDLL void PPXAPI InitVFSTree(void); // VFSTREECLASS gp\ɂ

#define VTM_SETFLAG		(WM_APP + 0) //Tree ̋w肷
#define VTM_INITTREE	(WM_APP + 1)
#define VTM_SETPATH		(WM_APP + 2)
#define VTM_GETPATH		(WM_APP + 3)
#define VTM_SCROLL		(WM_APP + 4)
#define VTM_POINTPATH	(WM_APP + 5)
#define VTM_ADDTREEITEM	(WM_APP + 6)
#define VTM_GETSETTINGS	(WM_APP + 7)
#define VTM_TREECOMMAND	(WM_APP + 8)
#define VTM_SETRESULT	(WM_APP + 9)
#define VTM_CHANGEDDISPDPI	(WM_APP + 10)

// VTM_SETFLAG Ŏw\ȃtO
#define VFSTREE_SELECT		B0	// II
#define VFSTREE_PATHNOTIFY	B1	// pXύXʒm
#define VFSTREE_SYNC		B2	// I炻̓xɒʒm
#define VFSTREE_PPC			B3	// PPc p UI
#define VFSTREE_SPLITR		B4	// Eɕ\
#define VFSTREE_MENU		B5	// |bvAbvj[
#define VFSTREE_DISABLEDRAG	B6	// hbO

// VTM_POINTPATH p
#define VTMPP_CANADDITEM B0 // ߂l:ړo^
typedef struct {
	DWORD_PTR Titem;	// œKpAVK̎ 0 ݒ
	POINT pos;		// XN[W
	TCHAR *path;	// ۑꏊBTitemωȂƂ͏Ȃ
} VTMPOINTPATHSTRUCT;
/*=============================================================================
====================== Plugin DLL ֘A̒`B̃wb_Ȃ */
#define VFSAS_UNDLL 0
#define VFSAS_SUSIE 1
#define VFSAS_ENTER 0
#define VFSAS_SERIALIZE B5
#define VFSAS_LEAVE B6
#define VFSAS_CHECK B7

extern VFSDLL int PPXAPI VFSArchiveSection(DWORD mode, const TCHAR *threadname);
//-------------------------------------------------------------- OpenArchive n
//-------------------------------------- DLL 萔
#define FNAME_MAX32		512
typedef HGLOBAL HARC;

typedef struct {
	DWORD l, h;
} ARCSIZE64;
//-------------------------------------- DLL \
typedef struct {						// FindFirst p -----------------------
	DWORD	dwOriginalSize;		/* t@C̃TCY */
	DWORD	dwCompressedSize;	/* k̃TCY */
	DWORD	dwCRC;				/* i[t@C̃`FbNT */
	UINT	uFlag;				/*  */
	UINT	uOSType;			/* ɍ쐬Ɏgꂽnr */
	WORD	wRatio;				/* k */
	WORD	wDate;				/* i[t@C̓t(DOS `) */
	WORD	wTime;				/* i[t@C̎(V) */
	char	szFileName[FNAME_MAX32 + 1];	/* ɖ */
	char	dummy1[3];
	char	szAttribute[8];		/* i[t@C̑(ɌŗL) */
	char	szMode[8];			/* i[t@C̊i[[h(V) */
} INDIVIDUALINFOA, *LPINDIVIDUALINFOA;

typedef struct {						// FindFirst p -----------------------
	DWORD	dwOriginalSize;		/* t@C̃TCY */
	DWORD	dwCompressedSize;	/* k̃TCY */
	DWORD	dwCRC;				/* i[t@C̃`FbNT */
	UINT	uFlag;				/*  */
	UINT	uOSType;			/* ɍ쐬Ɏgꂽnr */
	WORD	wRatio;				/* k */
	WORD	wDate;				/* i[t@C̓t(DOS `) */
	WORD	wTime;				/* i[t@C̎(V) */
	WCHAR	szFileName[FNAME_MAX32 + 1];	/* ɖ */
	WCHAR	dummy1[3];
	WCHAR	szAttribute[8];		/* i[t@C̑(ɌŗL) */
	WCHAR	szMode[8];			/* i[t@C̊i[[h(V) */
} INDIVIDUALINFOW, *LPINDIVIDUALINFOW;
#ifdef UNICODE
typedef INDIVIDUALINFOA   INDIVIDUALINFO;
typedef LPINDIVIDUALINFOA LPINDIVIDUALINFO;
#else
typedef INDIVIDUALINFOW   INDIVIDUALINFO;
typedef LPINDIVIDUALINFOW LPINDIVIDUALINFO;
#endif

//-------------------------------------- DLL ֐
typedef int (WINAPI *ARCPROC)();
typedef BOOL (WINAPI *impUnGetRunning)(VOID);
typedef int (WINAPI *impUnarc)(const HWND hwnd, LPCSTR szCmdLine, LPSTR szOutput, const DWORD wSize);
typedef int (WINAPI *impUnarcW)(const HWND hwnd, LPCWSTR szCmdLine, LPWSTR szOutput, const DWORD wSize);
typedef int (WINAPI *impUnarcParam)(const HWND hwnd, LPCSTR szCmdLine, LPSTR szOutput, const DWORD wSize, HLOCAL hParam);
typedef HARC (WINAPI *impUnOpenArchive)(const HWND hwnd, LPCSTR szFileName, const DWORD dwMode);
typedef HARC (WINAPI *impUnOpenArchiveW)(const HWND hwnd, LPCWSTR szFileName, const DWORD dwMode);
typedef int (WINAPI *impUnCloseArchive)(HARC harc);
typedef int (WINAPI *impUnFindFirst)(HARC harc, LPCSTR szWildName, INDIVIDUALINFOA *lpSubInfo);
typedef int (WINAPI *impUnFindFirstW)(HARC harc, LPCWSTR szWildName, INDIVIDUALINFOW *lpSubInfo);
typedef int (WINAPI *impUnFindNext)(HARC harc, INDIVIDUALINFOA *lpSubInfo);
typedef int (WINAPI *impUnFindNextW)(HARC harc, INDIVIDUALINFOW *lpSubInfo);
typedef BOOL (WINAPI *impUnCheckArchive)(LPCSTR szFileName, const int iMode);
typedef BOOL (WINAPI *impUnCheckArchiveW)(LPCWSTR szFileName, const int iMode);
typedef BOOL (WINAPI *impSetUnicodeMode)(const BOOL _bUnicode);
typedef BOOL (WINAPI *impUnGetOriginalSizeEx)(HARC harc, ARCSIZE64 *_lpllSize);
typedef BOOL (WINAPI *impUnGetWriteTimeEx)(HARC harc, FILETIME *_lpftLastWriteTime);
typedef BOOL (WINAPI *impUnGetCreateTimeEx)(HARC harc, FILETIME *_lpftCreationTime);
typedef BOOL (WINAPI *impUnGetAccessTimeEx)(HARC harc, FILETIME *_lpftLastAccessTime);
//-------------------------------------- PPx `
#if defined(ONPPXDLL)
typedef struct {
	const char *filename;
	BYTE *header;
	SIZE32_T fsize;
	int floatheader;	// -1:VOpX`FbN 0:Œwb_ 1:wb_
	#ifdef UNICODE
		char filename8[VFPS];
		const WCHAR *filenameW;
	#endif
} VUCHECKSTRUCT;

typedef BOOL (*VUCHECKFUNC)(void *uD, VUCHECKSTRUCT *vcs);
typedef struct tagUNDLL{				// ďop ---------------------------
	HANDLE hadd;					// DLL ̃nh
	impUnarc			Unarc;
	impUnGetRunning		UnGetRunning;
	impUnOpenArchive	UnOpenArchive;
	impUnCloseArchive	UnCloseArchive;
	impUnFindFirst		UnFindFirst;
	impUnFindNext		UnFindNext;
	impUnCheckArchive	UnCheckArchive;
	impUnGetWriteTimeEx UnGetWriteTimeEx;
	impUnGetCreateTimeEx UnGetCreateTimeEx;
	impUnGetAccessTimeEx UnGetAccessTimeEx;
	impUnGetOriginalSizeEx UnGetOriginalSizeEx;
	impUnarcParam		UnarcParam;

	#ifdef UNICODE
		impUnarcW			UnarcW;
		impUnOpenArchiveW	UnOpenArchiveW;
		impUnFindFirstW		UnFindFirstW;
		impUnFindNextW		UnFindNextW;
		impUnCheckArchiveW	UnCheckArchiveW;
		impSetUnicodeMode	SetUnicodeMode;
	#endif
	VUCHECKFUNC VUCheck;

	const TCHAR *DllName;
	const TCHAR *DllYetAnotherName; // y= \DLL
	const TCHAR *ApiHeadName;

	const TCHAR *AllExtCMD;		// a= ɓt@CSWJR}h
	const TCHAR *PartExtCMD;	// e= ɓt@Cw肵ēWJR}h
	const TCHAR *SingleExtCMD;	// s= ɓ̂Pt@CWJR}h
	const TCHAR *DeleteCMD;		// d= ɓ̃t@C폜R}h
	const TCHAR *RenameCMD;		// r= ɓ̃t@C𖼑OύXR}h
	const TCHAR *CheckWildcard;	// w= t@C̏Ƀ`FbNɎgp郏ChJ[h
	const TCHAR *SupportWildcard; // i= ΉĂgqChJ[h
	const TCHAR *params; // P_arc ̂̑`̐擪

#define UNDLLFLAG_32bit					B0	// 32bit
#define UNDLLFLAG_64bit					B1	// 64bit
#define UNDLLFLAG_nativebit				ValueX3264(UNDLLFLAG_32bit, UNDLLFLAG_64bit)
#define UNDLLFLAG_DISABLE_DIR			B3	// fBNg\ɎgpȂ
#define UNDLLFLAG_DISABLE_UNPACK		B4	// WJɎgpȂ
#define UNDLLFLAG_DISABLE_PACK			B5	// kɎgpȂ
#define UNDLLFLAG_DISABLE_UNICODEMODE	B6	// `SetUnicodeMode gpȂ
#define UNDLLFLAG_DISABLE_WIDEFUNCTION	B7	// `W nAPI gpȂ

#define UNDLLFLAG_RESPONSE_UTF8			B8	// `W nAPIX|Xt@CUTF8

#define UNDLLFLAG_SKIP_OPENED			B10	// Open̏ɂ`FbNΏۊOɂ(UNRAR32, LMZIP32, 7zca32)
#define UNDLLFLAG_FIX_UNARCRESULT		B11	// UnArčʕ␳(CAB32)
#define UNDLLFLAG_FIX_BRACKET			B12	// t@C [,] escape(UNZIP32)
#define UNDLLFLAG_FIX_IME				B13	// IME𖳌ɂ(7-zip32)
#define UNDLLFLAG_FIX_DUMMYWINDOW		B14	// _~[pӂ(UNRAR32)
#define UNDLLFLAG_ENABLENAMECHECK		B15	// Ύw蓙ɂ댯`FbN
#define UNDLLFLAG_SKIPDLLCHECK			B16	// CheckArchiveɂ`FbNȂ

	DWORD flags;
	int knowntype; // mDLL
	#ifdef UNICODE
	UINT codepage;	// VFSFind / UnArc_Extract`UnArc_Exec Ŏgp
	#endif
} UN_DLL;
#else
typedef void UN_DLL;
#endif
//-------------------------------------- UnXXX32 Ăяo
// extern VFSDLL int PPXAPI UnARCExec(UN_DLL *uD, HWND hWnd, const char *Cmd, char *Log, DWORD LogSize); 1.27 p~BExecUnarcɕύX
// extern VFSDLL int PPXAPI UnARC(const TCHAR *DllName, HWND hWnd, const TCHAR *Cmd, char *Log, DWORD LogSize); 1.27 p~B%ugp

#define UNARCEXTRACT_ALL 0
#define UNARCEXTRACT_PART 1
#define UNARCEXTRACT_SINGLE 2
#define UNARCEXTRACT_DELETE 3
#define UNARCEXTRACT_RENAME 4
#define UNARCEXTRACT_MAX UNARCEXTRACT_RENAME
extern VFSDLL ERRORCODE PPXAPI UnArc_Extract(PPXAPPINFO *info, const void *dt_opt, int extractmode, TCHAR *extract, int flag);
extern VFSDLL void PPXAPI UnArc_Exec(PPXAPPINFO *info, const void *dt_opt, TCHAR *param, HANDLE hBatchfile, const TCHAR *tmppath, DWORD X_unbg, const TCHAR *chopdir);

//------------------------------------------------------------ SUSIE Plug-in n
//-------------------------------------- DLL 萔
#define SUSIEERROR_NOERROR       0
#define SUSIEERROR_NOTSUPPORT   -1
#define SUSIEERROR_USERCANCEL    1
#define SUSIEERROR_UNKNOWNFORMAT 2
#define SUSIEERROR_BROKENDATA    3
#define SUSIEERROR_EMPTYMEMORY   4
#define SUSIEERROR_FAULTMEMORY   5
#define SUSIEERROR_FAULTREAD     6
#define SUSIEERROR_RESERVED      7
#define SUSIEERROR_INTERNAL      8

#define SUSIE_SOURCE_DISK 0
#define SUSIE_SOURCE_MEM 1
#define SUSIE_IGNORECASE B7
#define SUSIE_DEST_DISK 0
#define SUSIE_DEST_MEM 0x100

#define SUSIE_DECODE_REQUEST_BITMAP        0x01 // [IN] BITMAP 擾
#define SUSIE_DECODE_REQUEST_INFOTEXT      0x02 // [IN] infotextΎ擾
#define SUSIE_DECODE_ALLOW_BMPV5           0x04 // [IN] BMPv5 gp\
#define SUSIE_DECODE_ENABLE_SIZE           0x08 // [IN] request_size L
#define SUSIE_DECODE_REQUEST_ROTATE        0x10 // [IN] ]␳]
#define SUSIE_DECODE_REQUEST_MERGE_ALPHA   0x20 // [IN] ߕ␳]
#define SUSIE_DECODE_REQUEST_FIX_ASPECT    0x40 // [IN] AXyNg䒲]
#define SUSIE_DECODE_REQUEST_COLOR_PROFILE 0x80 // [IN] J[vt@C]
#define SUSIE_DECODE_REQUEST_FIX_sRGB     0x100 // [IN] sRGBɕ␳]
#define SUSIE_DECODE_ALLOW_TOP_DOWN       0x200 // [IN] ㉺](top down)

#define SUSIE_DECODE_USE_SIZE              0x08 // [OUT] request_size QƂ
#define SUSIE_DECODE_FIX_ROTATE            0x10 // [OUT] ]␳
#define SUSIE_DECODE_MERGE_ALPHA           0x20 // [OUT] ߕ␳
#define SUSIE_DECODE_FIX_ASPECT            0x40 // [OUT] AXyNg䒲
#define SUSIE_DECODE_FIX_sRGB             0x100 // [OUT] sRGBɕ␳

#define SUSIE_DECODE_VECTOR             0x20000 // [OUT]
#define SUSIE_DECODE_ROTATE             0x40000 // [OUT] ]␳L
#define SUSIE_DECODE_ALPHA              0x80000 // [OUT] ߏL
#define SUSIE_DECODE_IN_COLOR_PROFILE 0x0200000 // [OUT] J[vt@CL
#define SUSIE_DECODE_ANIMATION        0x0800000 // [OUT] Aj[V\
#define SUSIE_DECODE_LAYER            0x1000000 // [OUT] C[

typedef ULONG_PTR susie_time_t;
typedef int (__stdcall *SUSIE_PROGRESS)(int nNum, int nDenom, LONG_PTR lData);
#define SUSIE_PATH_MAX 200
#define SUSIE_CHECK_SIZE 2048 // IsSupported KvƂ傫

//-------------------------------------- DLL \
#pragma pack(push, 1)
struct PictureInfo{
	long	left, top;				// 摜WJʒu
	long	width;					// 摜̕(pixel)
	long	height;					// 摜̍(pixel)
	WORD	x_density;				// f̐x
	WORD	y_density;				// f̐x
	short	colorDepth;				// Pfbit
	#ifdef _WIN64
	  char  dummy[2]; // ACg
	#endif
	HLOCAL	hInfo;					// 摜̃eLXg
};

typedef struct {
	unsigned char	method[8];		// k@̎
	ULONG_PTR		position;		// t@Cł̈ʒu
	ULONG_PTR		compsize;		// kꂽTCY
	ULONG_PTR		filesize;		// ̃t@CTCY
	susie_time_t	timestamp;		// t@C̍XV
	char			path[SUSIE_PATH_MAX];		// ΃pX
	char			filename[SUSIE_PATH_MAX];	// t@Cl[
	unsigned long	crc;			// CRC
	#ifdef _WIN64
		char dummy[4]; // ACg
	#endif
} SUSIE_FINFO;

typedef struct {
	unsigned char	method[8];		// k@̎
	ULONG_PTR		position;		// t@Cł̈ʒu
	ULONG_PTR		compsize;		// kꂽTCY
	ULONG_PTR		filesize;		// ̃t@CTCY
	susie_time_t	timestamp;		// t@C̍XV
	WCHAR			path[SUSIE_PATH_MAX];		// ΃pX
	WCHAR			filename[SUSIE_PATH_MAX];	// t@Cl[
	unsigned long	crc;			// CRC
	#ifdef _WIN64
		char dummy[4]; // ACg
	#endif
} SUSIE_FINFOW;

typedef struct {
	DWORD struct_size;  // [IN] sizeof(SUSIE_DECODE_PARAMETERS)
	DWORD input_flags;  // [IN] Plug-in ɓn SUSIE_DECODE_xxx
	DWORD reserved;     // gpAACgp
	DWORD page_number;  // [IN] }`y[W̎̎擾y[W 0: 1Ԗ

	const WCHAR *filename; // [IN] t@C (fileimageL̎łʗpɗp)
	LONG_PTR file_offset;  // [IN,OPTION] t@Cǂݍݏoʒu(fileimageNULL̂ƂɎgp)
	const char *fileimage; // [IN] t@C̃C[W ( NULL)
	LONG_PTR image_size;   // [IN,OPTION] fileimage ̑傫(fileimage != NULL̂ƂɎgp)

	SUSIE_PROGRESS progressCallback; // [IN] oߕ\EfpR[obN ( NULL)
	LONG_PTR lData;                  // [IN,OPTION] progressCallback ̃[U`

	char *infotext; // [OUT,OPTION] t@C(SUSIE_DECODE_REQUEST_INFOTEXT LALocalFree ŉKvANULL: Ȃ)
	HLOCAL *pHBInfo, *pHBm; // [OUT,OPTION] fR[h BMP
		// pHBInfo BITMAPINFOHEADER  BITMAPV5HEADER
		// pHBm    rbg}bvf

	DWORD output_flags; // [OUT] Plug-in 񍐂 SUSIE_DECODE_xxx
	DWORD rotate;       // [OUT,OPTION] ]␳B␳ς݂łl(SUSIE_DECODE_ROTATE)
	DWORD all_pages;    // [OUT] }`y[W̃y[W 1: S1y[W
	DWORD animate_time; // [OUT,OPTION] Aj[V̎̎̃t[܂ł̑ҋ@ ms(SUSIE_DECODE_ANIMATION)
	POINT left_top;     // [OUT] \Jnʒu(layer, icon)
	SIZE request_size;  // [IN,OPTION] vector / preview Ŋ]傫(SUSIE_DECODE_ENABLE_SIZE)
} SUSIE_DECODE_PARAMETERS;
#pragma pack(pop)
//-------------------------------------- DLL ֐
typedef int (__stdcall *GETPLUGININFO)(int infono, LPSTR buf, int buflen);
typedef int (__stdcall *ISSUPPORTED)(LPCSTR filename, void *dw);
typedef int (__stdcall *ISSUPPORTEDW)(LPCWSTR filename, void *dw);
typedef int (__stdcall *CONFIGURATIONDLG)(HWND hWnd, int function);
typedef int (__stdcall *GETPICTUREINFO)(LPCSTR buf, LONG_PTR len, unsigned int flag, struct PictureInfo *lpInfo);
typedef int (__stdcall *GETPICTUREINFOW)(LPCWSTR buf, LONG_PTR len, unsigned int flag, struct PictureInfo *lpInfo);
typedef int (__stdcall *GETPICTURE)(LPCSTR buf, LONG_PTR len, unsigned int flag, HANDLE *pHBInfo, HANDLE *pHBm, FARPROC lpPrgressCallback, LONG_PTR lData);
typedef int (__stdcall *GETPICTUREW)(LPCWSTR buf, LONG_PTR len, unsigned int flag, HANDLE *pHBInfo, HANDLE *pHBm, FARPROC lpPrgressCallback, LONG_PTR lData);
typedef int (__stdcall *GETPREVIEW)(LPCSTR buf, LONG_PTR len, unsigned int flag, HANDLE *pHBInfo, HANDLE *pHBm, FARPROC lpPrgressCallback, LONG_PTR lData);
typedef int (__stdcall *GETPREVIEWW)(LPCWSTR buf, LONG_PTR len, unsigned int flag, HANDLE *pHBInfo, HANDLE *pHBm, FARPROC lpPrgressCallback, LONG_PTR lData);
typedef int (__stdcall *GETARCHIVEINFO)(LPCSTR buf, LONG_PTR len, unsigned int flag, HLOCAL *lphInf);
typedef int (__stdcall *GETARCHIVEINFOW)(LPCWSTR buf, LONG_PTR len, unsigned int flag, HLOCAL *lphInf);
typedef int (__stdcall *GETFILE)(LPCSTR src, LONG_PTR len, LPSTR dest, unsigned int flag, FARPROC prgressCallback, LONG_PTR lData);
typedef int (__stdcall *GETFILEW)(LPCWSTR src, LONG_PTR len, LPWSTR dest, unsigned int flag, FARPROC prgressCallback, LONG_PTR lData);
typedef int (__stdcall *GETFILEINFO)(LPCSTR buf, LONG_PTR len, LPCSTR filename, unsigned int flag, SUSIE_FINFO *lpInfo);
typedef int (__stdcall *GETFILEINFOW)(LPCWSTR buf, LONG_PTR len, LPCWSTR filename, unsigned int flag, SUSIE_FINFOW *lpInfo);
typedef int (__stdcall *DECODEPICTUREW)(SUSIE_DECODE_PARAMETERS *params);

//-------------------------------------- PPx `
#define VFSSUSIE_BMP B0 // GetPicture Ή
#define VFSSUSIE_ARC B1 // GetFile Ή
#define VFSSUSIE_NOAUTODETECT B2 // oEKpsȂ
#define VFSSUSIE_USESUSIEAPI B3 // DecodePictureW g킸A GetPicture gp
#define VFSSUSIE_DISABLEUNICODE B4 // ANSIAPÎݎgp
typedef struct {
	HANDLE hadd;					// DLL ̃nh
	GETPLUGININFO	GetPluginInfo;	// Plug-inɊւ𓾂
	ISSUPPORTED		IsSupported;	// WJ\(ΉĂ)t@C`
	GETPICTURE		GetPicture;		// 摜WJ
	GETPREVIEW		GetPreview;
	GETARCHIVEINFO	GetArchiveInfo;
	GETFILE			GetFile;
	GETFILEINFO		GetFileInfo;
#ifdef UNICODE
//	GETPLUGININFOW	GetPluginInfoW;
	ISSUPPORTEDW	IsSupportedW;
	GETPICTUREW		GetPictureW;
	GETARCHIVEINFOW	GetArchiveInfoW;
	GETFILEW		GetFileW;
	GETFILEINFOW	GetFileInfoW;
#endif
	DECODEPICTUREW	DecodePictureW;
	DWORD flags;
	DWORD DllNameOffset;
	DWORD SupportExtOffset;	// Ήgq
} SUSIE_DLL;
// DllNameOffset, SupportExtOffset e[u
#define SUSIE_MASK_LENGTH VFPS
typedef struct {
	DWORD flags;	// VFSSUSIE_BMP, VFSSUSIE_ARC
	TCHAR filemask[SUSIE_MASK_LENGTH];
} SUSIE_DLLSTRINGS;

extern VFSDLL int PPXAPI VFSGetSusieList(const SUSIE_DLL **su, BYTE **strings);
extern VFSDLL const SUSIE_DLL * PPXAPI VFSGetSusieFuncs(const void *dt_opt);
#ifdef __cplusplus
}
#endif
