/*-----------------------------------------------------------------------------
	Paper Plane xUI	 commom library								PPx Task
-----------------------------------------------------------------------------*/
#define ONPPXDLL		// PPCOMMON.H  DLL `w
#include "WINAPI.H"
#include "PPX.H"
#include "PPCOMMON.RH"
#include "PPD_DEF.H"
#pragma hdrstop

int PPxRegistCombo(HWND hWnd, TCHAR *ID, int mode);
int PPxRegistLiveSearch(TCHAR *ID, int mode);
COLORREF CJ_log[2];

ValueWinAPI(SetDllDirectory) = INVALID_VALUE(impSetDllDirectory);
DefineWinAPI(HRESULT, SetCurrentProcessExplicitAppUserModelID, (const WCHAR *AppID)) = NULL;

#ifdef UNICODE
	#define PLATFORMAPPID ValueX3264(T("W"), T("6"))
#else
	#define PLATFORMAPPID T("A")
#endif

// Wuꗗ
#define JOBLOG 0 // WuǗ̃O

WNDPROC OldJobProc;

#define JOBSELECTMODE_FOCUS 0
#define JOBSELECTMODE_PAUSE 1
#define JOBSELECTMODE_CLOSE 2

#define SHOWJOBBUTTON_MINRATE 3

int jobselectmode = JOBSELECTMODE_FOCUS;

const TCHAR strSendPPb[] = T("PPb I/O");

//****************************************************************************
//		PPx Ǘ
//****************************************************************************

/*-----------------------------------------------------------------------------
 ^XNǗe[u̐mFB
-----------------------------------------------------------------------------*/
BOOL AliveCheck(ShareX *P)
{
	DWORD result;
	HANDLE hProcess;

	if ( P->ProcessID == MAX32 ) return TRUE; // ܂ݒ肵ĂȂ
	hProcess = OpenProcess(SYNCHRONIZE, FALSE, P->ProcessID);
	if ( hProcess != NULL ){
		result = WaitForSingleObject(hProcess, 0);
		CloseHandle(hProcess);
	}else{
		result = WAIT_ABANDONED;
	}
	if ( result != WAIT_TIMEOUT ){
		XMessage(NULL, NULL, XM_DbgLOG, T("Task broken:%s"), P->ID);
		return FALSE;
	}
	return TRUE;
}

void FixTask(void)
{
	ShareX *P;
	int i;
								// L̔j`FbN
	if ( Sm->Version != ShareM_VersionValue ){
		XMessage(NULL, NULL, XM_FaERRld, MES_FDLW, Sm->Version);
		Sm->Version = ShareM_VersionValue;
	}
								// eڂ̃EBhEL̃`FbN
	P = Sm->P;
	UsePPx();
	for ( i = 0 ; i < X_Mtask ; i++, P++ ){
		if ( P->ID[0] == '\0' ) continue;			// o^
		if ( P->hWnd == BADHWND ) continue;		// o^
		if ( P->hWnd == NULL ) continue;		// o^/
		if ( IsTrue(IsWindow(P->hWnd)) ) continue;			// ̑͐
		if ( AliveCheck(P) == FALSE ){	// ُIƌȂ
			P->ID[0] = '\0';
		}else{	// mɋ߂ĂȂ̂ŁA
				// mF𒆒fB(ԃXbv̎Ȃǂɔ)
			break;
		}
	}
	FreePPx();
}

/*-----------------------------------------------------------------------------
 wID
-----------------------------------------------------------------------------*/
int SearchPPx(TCHAR *ID)
{
	int RegNo;

	FixTask();
	for ( RegNo = 0 ; RegNo < X_Mtask ; RegNo++ ){
		if ( tstrcmp(Sm->P[RegNo].ID, ID) == 0 ) break;
	}
	if ( RegNo == X_Mtask ) RegNo = -1;
	return RegNo;
}

/*-----------------------------------------------------------------------------
	wPPx
-----------------------------------------------------------------------------*/
HWND PPxGetWindow(const TCHAR *refid, int d)
{
	int i;
	HWND hWnd;

	if ( refid == NULL ){
		THREADSTRUCT *Th;

		Th = GetCurrentThreadInfo();
		if ( Th == NULL ) return NULL;
		if ( Th->PPxNo < 0 ) return NULL;
		refid = Sm->P[Th->PPxNo].ID;
	}

	FixTask();
	UsePPx();
	if ( d >= 0 ){
		int found = -1;
		for ( i = 0 ; i < X_Mtask ; i++ ){
			if ( tstrcmp(Sm->P[i].ID, refid) == 0 ){
				if ( found != -1 ) break;
			}else if ( Sm->P[i].ID[0] ){
				found = i;
			}
		}
		i = found;
	}else{
		int found = -1, center = 0;
		for ( i = 0 ; i < X_Mtask ; i++ ){
			if ( tstrcmp(Sm->P[i].ID, refid) == 0 ){
				center = 1;
			}else if ( Sm->P[i].ID[0] ){
				if ( found == -1 ) found = i;
				if ( center ){
					found = i;
					break;
				}
			}
		}
		i = found;
	}
	hWnd = (i == -1) ? NULL : Sm->P[i].hWnd;
	FreePPx();
	return hWnd;
}
/*-----------------------------------------------------------------------------
	Y ID ̓o^ς PPx  HWND 𓾂B񐮌`̏ꍇ GetPPxhWndFromIDB
-----------------------------------------------------------------------------*/
PPXDLL HWND PPXAPI PPxGetHWND(TCHAR *id)
{
	int i;
	HWND hWnd = NULL;

	UsePPx();
	i = SearchPPx(id);
	if ( i >= 0 ) hWnd = Sm->P[i].hWnd;
	FreePPx();
	return hWnd;
}

void SetAppID(void)
{
	TCHAR appIDname[128]; // 128܂ŁA[C.P.]S.V PascalCase
	DWORD X_tskb;

	X_tskb = GetCustDword(T("X_tskb"), 1);
	if ( X_tskb == 0 ) return; // ܂Ƃ߂ȂƂ́AIDݒsv
	// V[gJbg AppID ݒ肷΂悢炵

	GETDLLPROC(hShell32, SetCurrentProcessExplicitAppUserModelID);
	if ( DSetCurrentProcessExplicitAppUserModelID == NULL ) return;

	thprintf(appIDname, TSIZEOF(appIDname), (X_tskb == 1) ?
			T("PPx ") PLATFORMAPPID T("%s") : // ` PPx ?PPX?????
			T("PPx") PLATFORMAPPID T(".%s"), // V` PPx?.PPX?????
	 		SyncTag);

#ifdef UNICODE
	DSetCurrentProcessExplicitAppUserModelID(appIDname);
#else
	{
		WCHAR namebuf[256];

		AnsiToUnicode(appIDname, namebuf, 256);
		DSetCurrentProcessExplicitAppUserModelID(namebuf);
	}
#endif
// ITaskbarList3::SetOverlayIcon
}

/*-----------------------------------------------------------------------------
	^XNǗe[uɃEBhEo^
	hWND		o^̃EBhEnh
				(BADHWND:EBhEgpĂȂ/ꎞw)
	ID			3bytes ̎/4bytes̕ۑꏊ
	߂l:		o^ԍ(0-), -1:gpς/wς
-----------------------------------------------------------------------------*/
PPXDLL int PPXAPI PPxRegist(HWND hWnd, TCHAR *ID, int mode)
{
	ShareX *P;
	int i, imax;
	int RegNo = -1;
	TCHAR limit = 'Z';

	if ( DSetDllDirectory == INVALID_HANDLE_VALUE ){
		GETDLLPROCT(hKernel32, SetDllDirectory);
		if ( DSetDllDirectory != NULL ){
			DSetDllDirectory(NilStr); // DLĽpXJg
		}
	}

	if ( mode >= PPXREGIST_COMBO_FIRST ){
		return PPxRegistCombo(hWnd, ID, mode);
	}
	FixTask();

	if ( mode <= PPXREGIST_SEARCH_LIVEID_MAX ){
		if ( mode == PPXREGIST_SETPPcFOCUS ){
			Sm->ppc.hLastFocusWnd = hWnd;
			return 0;
		}
		return PPxRegistLiveSearch(ID, mode);
	}
	UsePPx();
									// ID n߂
	if ( mode == PPXREGIST_NORMAL ){
		if ( ID[2] == '\0' ) ID[2] = 'A';
	}else if ( mode == PPXREGIST_MAX ){
		limit = ID[2];
		ID[2] = 'A';
	}

	ID[3] = '\0';
	imax = (ID[0] == 'C') ? (X_Mtask - 6) : X_Mtask; // PPc ͏炷

	P = Sm->P;
	for ( i = 0 ; i < imax ; ){
		if ( P->ID[0] == '\0' ){			// 󂫂𔭌
			RegNo = i;
		}else if ( tstrcmp(P->ID, ID) == 0 ){	// IDL
			switch ( mode ){
				case PPXREGIST_FREE:
					P->ID[0] = '\0';	// o^𖕏
				//	PPxDefInfo = &PPxDefInfoDummy;
					goto notfound;

				case PPXREGIST_SETHWND:
					P->hWnd = hWnd;		// HWND o^
					goto notfound;

				case PPXREGIST_IDASSIGN: // 聨o^łȂ
					if ( ID[2] != 'Z' ) goto notfound;
					RegNo = i;
					i = X_Mtask;
					break;

				default:	// PPXREGIST_NORMAL / PPXREGIST_MAX
					if ( ID[2] >= limit ){ // Ō܂Ō
						if ( mode == PPXREGIST_MAX ) goto notfound;
						RegNo = i;
						i = X_Mtask;
						break;
					}
							// IĎJn
					P = Sm->P;
					ID[2]++;
					i = 0;
					continue;
			}
		}
		i++;
		P++;
	}
	if ( (RegNo >= 0) && (mode != PPXREGIST_FREE) ){
		THREADSTRUCT *Th;
		ShareX *RegP = &Sm->P[RegNo];

		RegP->hWnd = hWnd;
		RegP->UsehWnd = BADHWND;
		RegP->ProcessID = GetCurrentProcessId();
		RegP->ActiveID = Sm->Active.high++;
		RegP->path[0] = '\0';
		tstrcpy(RegP->ID, ID);

		Th = GetCurrentThreadInfo();
		if ( Th != NULL ) Th->PPxNo = RegNo;

		// Windows7 ȍ~̃^XNo[ɓZ߂鏈
		if ( WinType >= WINTYPE_7 ) SetAppID();
	}
	FreePPx();
	return RegNo;
notfound:
	FreePPx();
	return -1;
}
/*-----------------------------------------------------------------------------
	^XNǗe[uɓo^ꂽ PPx SĂɃR}h𔭍s
-----------------------------------------------------------------------------*/
void USEFASTCALL ClosePPxOne(HWND hWnd, BOOL AllClose)
{
	DWORD ProcessID;
	HANDLE hProcess;
	DWORD_PTR sendresult;

	if ( GetWindowThreadProcessId(hWnd, &ProcessID) == 0 ) return; // closeς
	if ( ProcessID == GetCurrentProcessId() ){ // g
		PostMessage(hWnd, WM_CLOSE, (WPARAM)WM_PPXCOMMAND, (LPARAM)AllClose);
		return;
	}else{
		SendMessageTimeout(hWnd, WM_CLOSE, (WPARAM)WM_PPXCOMMAND, (LPARAM)AllClose, SMTO_ABORTIFHUNG, 2000, &sendresult);
		if ( GetWindowThreadProcessId(hWnd, &ProcessID) == 0 ) return; // closeς
	}

	hProcess = OpenProcess(SYNCHRONIZE, FALSE, ProcessID);
	if ( hProcess != NULL ){
		WaitForSingleObject(hProcess, 2000);
		CloseHandle(hProcess);
	}
	Sleep(100);	// Ô߂ɂĂ
}


PPXDLL void PPXAPI PPxSendMessage(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int index;
	DWORD_PTR sendresult;

	FixTask();

	if ( uMsg == WM_CLOSE ){ // WM_CLOSE ȂAꊇI悤
		wParam = WM_PPXCOMMAND;
		lParam = 1;
	}

	// Combo Window ɑM
	for ( index = 0 ; index < X_MaxComboID ; index++ ){
		HWND hComboWnd;

		hComboWnd = Sm->ppc.hComboWnd[index];
		if ( (hComboWnd == NULL) || (hComboWnd == BADHWND) ) continue;

		if ( uMsg == WM_CLOSE ){
			ClosePPxOne(hComboWnd, TRUE);
		}else{
			SendMessageTimeout(hComboWnd, uMsg, wParam, lParam, SMTO_ABORTIFHUNG, 2000, &sendresult);
		}
	}

	// Ɨ PPx ɑM
	for ( index = 0 ; index < X_Mtask ; index++ ){
		HWND hWnd;

		if ( Sm->P[index].ID[0] == '\0' ) continue;
		hWnd = Sm->P[index].hWnd;
		if ( (hWnd == NULL) ||
			 (((LONG_PTR)hWnd & (LONG_PTR)HWND_BROADCAST) == (LONG_PTR)HWND_BROADCAST) ){
			continue;
		}
		if ( uMsg == WM_CLOSE ){
			ClosePPxOne(hWnd, TRUE);
		}else{
			SendMessageTimeout(hWnd, uMsg, wParam, lParam, SMTO_ABORTIFHUNG, 2000, &sendresult);
		}
	}
}

void PPxPostMessagePPb(UINT uMsg, WPARAM wParam, int index)
{
	TCHAR buf[0x100];
	HANDLE hCommIdleEvent;
	DWORD result;

	if ( Sm->P[index].UsehWnd != BADHWND ) return;
	if ( uMsg != WM_PPXCOMMAND ) return;

	thprintf(buf, TSIZEOF(buf), T("%s%sR"), SyncTag, Sm->P[index].ID);
	hCommIdleEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, buf);
	if ( hCommIdleEvent == NULL ) return;
	// PPb [1]ҋ@ԁH
	result = WaitForSingleObject(hCommIdleEvent, 0);
	CloseHandle(hCommIdleEvent);
	if ( result == WAIT_OBJECT_0 ){
		// ҋ@ԂȂ̂őM
		thprintf(buf, TSIZEOF(buf), T(">M%u"), (DWORD)wParam);
		SendPPB(BADHWND, buf, index);
	}
}

/*-----------------------------------------------------------------------------
	^XNǗe[uɓo^ꂽ PPx SĂɃR}h𔭍s
-----------------------------------------------------------------------------*/
PPXDLL void PPXAPI PPxPostMessage(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int index;

	FixTask();
	// Combo Window ɑM
	for ( index = 0 ; index < X_MaxComboID ; index++ ){
		HWND hComboWnd;

		hComboWnd = Sm->ppc.hComboWnd[index];
		if ( (hComboWnd == NULL) || (hComboWnd == BADHWND) ) continue;

		PostMessage(hComboWnd, uMsg, wParam, lParam);
	}

	// Ɨ PPx ɑM
	for ( index = 0 ; index < X_Mtask ; index++ ){
		HWND hWnd;

		if ( Sm->P[index].ID[0] == '\0' ) continue;
		hWnd = Sm->P[index].hWnd;
		if ( (hWnd == NULL) ||
			 (((LONG_PTR)hWnd & (LONG_PTR)HWND_BROADCAST) == (LONG_PTR)HWND_BROADCAST) ){
			continue;
		}

		if ( (Sm->P[index].ID[0] != 'B') || (Sm->P[index].ID[1] != '_') ){
			PostMessage(Sm->P[index].hWnd, uMsg, wParam, lParam);
		}else{ // PPbp
			PPxPostMessagePPb(uMsg, wParam, index);
		}
	}
}
/*-----------------------------------------------------------------------------
	JgfBNgo^
-----------------------------------------------------------------------------*/
PPXDLL void PPXAPI PPxSetPath(int RegNo, TCHAR *path)
{
	if ( (RegNo < 0) || (RegNo >= X_Mtask) ) return;
	UsePPx();
	tstrcpy(Sm->P[RegNo].path, path);
	FreePPx();
}
//====================================================================== to PPB
/*-----------------------------------------------------------------------------
	PPb L
-----------------------------------------------------------------------------*/
int UsePPb(HWND hOwner)
{
	ShareX *P;
	int id, tmpid = -1;

	P = Sm->P;
	UsePPx();
								// 󂢂Ă PPb  ----
	for ( id = 0 ; id < X_Mtask ; id++, P++ ){
		if ( (P->ID[0] == 'B') && (P->ID[1] == '_') ){
			if ( P->UsehWnd != BADHWND ){	// gp
				if ( tmpid < 0 ){
					tmpid = -2; // gpʒm
				}
			}else{				// gpcmF
				HANDLE hCommEvent;
				DWORD result;
				TCHAR buf[32];

				tstrcpy(buf, SyncTag);
				tstrcat(buf, P->ID);
				hCommEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, buf);
				if ( hCommEvent == NULL ) continue;
				result = WaitForSingleObject(hCommEvent, 0);
				CloseHandle(hCommEvent);
				if ( result == WAIT_OBJECT_0 ){	// 
					if ( tmpid < 0 ){		// m
						tmpid = id;
						P->UsehWnd = hOwner;
					}
					continue;
				}
				P->UsehWnd = hOwner;
				break;
			}
		}
	}
	if ( id == X_Mtask ){		// 󂫂Ȃ牼mۂ̂gp ---------
		id = tmpid;
	}else{
		if ( (id != tmpid) && (tmpid >= 0) ){	// mۂ
			Sm->P[tmpid].UsehWnd = BADHWND;
		}
	}
	FreePPx();
	return id;
}
/*-----------------------------------------------------------------------------
	LPPb
-----------------------------------------------------------------------------*/
void FreePPb(HWND hOwner, int useID)
{
	ShareX *P;

	if ( useID < 0 ) return;
	P = &Sm->P[useID];
	UsePPx();
	if ( (P->ID[0] == 'B') && (P->ID[1] == '_') && (P->UsehWnd == hOwner) ){
		P->UsehWnd = BADHWND;
	}
	FreePPx();
}
/*-----------------------------------------------------------------------------
	VK PPb N
-----------------------------------------------------------------------------*/
BOOL BootPPB(const TCHAR *path, const TCHAR *line, int flags)
{
	TCHAR param[CMDLINESIZE + VFPS * 2 + 32], term[VFPS];
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
											// s̎w
	si.cb			= sizeof(si);
	si.lpReserved	= NULL;
	si.lpDesktop	= NULL;
	si.lpTitle		= NULL;
	si.dwFlags		= 0;
	si.cbReserved2	= 0;
	si.lpReserved2	= NULL;

	if ( flags & (XEO_MAX | XEO_MIN | XEO_NOACTIVE /* | XEO_HIDE */) ){
		si.dwFlags = STARTF_USESHOWWINDOW;
		if ( flags & XEO_MAX ) si.wShowWindow = SW_SHOWMAXIMIZED;
		if ( flags & XEO_MIN ) si.wShowWindow = SW_SHOWMINNOACTIVE;
		if ( flags & XEO_NOACTIVE ) si.wShowWindow = SW_SHOWNOACTIVATE;
	//	if ( flags & XEO_HIDE ) si.wShowWindow = SW_HIDE;
	}

	term[0] = '\0';
	GetCustData(T("X_term"), term, sizeof(term));
	if ( term[0] != '\0' ) tstrcat(term, T(" "));

	thprintf(param, TSIZEOF(param),
			T("%s\"%s") T(PPBEXE) T("\" -P\"%s\" %s"),
			term, DLLpath, path, line);

	if ( IsTrue(CreateProcess(NULL, param, NULL, NULL, FALSE,
			CREATE_DEFAULT_ERROR_MODE, NULL, DLLpath, &si, &pi)) ){
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
		return FALSE;
	}
	return TRUE;
}
/*-----------------------------------------------------------------------------
	PPb ɃR}h𑗐M

PPb			PPx				hCommSendEvent	hCommIdleEvent	ParamID
[1]PPb N	t҂		---				---				free
[2]t\					---				[signal]		free
[3]			t~		---				[---]			free
[4]			eݒ		---				---				checkuse
[5]			ݒʒm		[signal]		---				use
[6]e					---				---				usefree
[7]s						---				---				free
[8]ԐM						[---]			---				free
[9]Ďt
-----------------------------------------------------------------------------*/
int SendPPB(HWND hOwner, const TCHAR *param, int useID)
{
	HANDLE hCommSendEvent, hCommIdleEvent;
	ShareX *P;
	TCHAR buf[32];

	P = &Sm->P[useID];
	UsePPx();
	if ( (P->ID[0] != 'B') || (P->ID[1] != '_') || (P->UsehWnd != hOwner) ){
		FreePPx();
		XMessage(hOwner, NULL, XM_FaERRd, MES_EPBY, T("useID destroy"));
		return -1;
	}

	tstrcpy(buf, SyncTag);
	tstrcat(buf, P->ID);					// PPb Ƃ̒ʐMim ---------
	FreePPx();
	hCommSendEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, buf);
	tstrcat(buf, T("R"));
	hCommIdleEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, buf);

	if ( (hCommSendEvent == NULL) || (hCommIdleEvent == NULL) ){
		XMessage(hOwner, NULL, XM_FaERRd, MES_EPBY, T("Event destroyed/1"));
		return -1;
	}
	{
		DWORD result, timeout = WAIT_NO_DIALOG_TIME, tick;
		HWND hDlg = NULL;
		WAITDLGSTRUCT wds;

		tick = GetTickCount() + WAIT_NO_DIALOG_TIME;
		wds.choose = WDS_UNCHOOSE;

		for ( ; ; ){
			if ( GetAsyncKeyState(VK_PAUSE) & KEYSTATE_PUSH ) break;

			result = MsgWaitForMultipleObjects(1, &hCommIdleEvent, FALSE,
					timeout, QS_ALLEVENTS | QS_SENDMESSAGE);

			if ( IsChooseWDS(wds.choose) ) break;

			if ( result == WAIT_OBJECT_0 ) break;

			if ( result == WAIT_OBJECT_0 + 1 ){ // Message
				MSG msg;

				while ( PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) ){
					if ( msg.message == WM_QUIT ) break;
				// EBhẼL[́E}EX͂𖳌
				//  EnableWindow gƁAtH[JX܂ŖāA
				//    ʂ̃EBhEɃtH[JXړĂ܂Ƃ邽
				//  WM_IME_KEYLAST  WM_KEYLAST
				//  (WM_PARENTNOTIFY - 1)  WM_MOUSELAST
					if ( (msg.hwnd == hOwner) &&
						( ((msg.message >= WM_KEYFIRST) && (msg.message <= WM_IME_KEYLAST)) ||
						  ((msg.message >= WM_MOUSEFIRST) && (msg.message < WM_PARENTNOTIFY))) ){
						continue;
					}
					if ( DialogKeyProc(&msg) ) continue;

					if ( (hDlg == NULL) || (IsDialogMessage(hDlg, &msg) == FALSE) ){
						TranslateMessage(&msg);
						DispatchMessage(&msg);
					}
				}
				continue;
			}

			if ( GetTickCount() > tick ){
				tick = MAX32;
				if ( hDlg == NULL ){
					BOOL hide;

					if ( X_uxt[0] == UXT_NA ) InitUnthemeCmd();
					wds.md.title = strSendPPb;
					wds.PPbID = useID;
					hDlg = CreateDialogParam(DLLhInst, MAKEINTRESOURCE(IDD_NULLMIN), NULL, WaitDlgBox, (LPARAM)&wds);

					if ( hOwner != NULL ) MoveCenterWindow(hDlg, hOwner);

					hide = SetJobTask(hDlg, JOBSTATE_WAITEXEC);
					ShowWindow(hDlg,
							(hide &&
							 (Sm->JobList.hWnd != NULL) &&
							 (Sm->JobList.hidemode == JOBLIST_HIDE)) ?
							SW_HIDE : SW_SHOWNOACTIVATE);
				}
				timeout = INFINITE;
			}
			if ( result == WAIT_FAILED ) goto error;
		}
		if ( hDlg ){
			DestroyWindow(hDlg);
			SetJobTask(hDlg, JOBSTATE_FINWEXEC);
			if ( IsChooseWDS(wds.choose) ) goto error;
		}
	}

	for ( ; ; ){
		DWORD result;			//[1][2] PPb ҋ@ԂɂȂ܂ő҂ ---

		if ( GetAsyncKeyState(VK_PAUSE) & KEYSTATE_PUSH ) goto cancel;
		result = WaitForSingleObject(hCommIdleEvent, 100);
		if ( result == WAIT_FAILED ) goto error;
		if ( result != WAIT_OBJECT_0 ) continue;
		// [2]t\
		ResetEvent(hCommIdleEvent);	// [3]t~
										// Sm->Param ɐݒ
		if ( TSTRLENGTH(param) >= sizeof(Sm->Param) ){
			XMessage(hOwner, NULL, XM_FaERRd, MES_EPBY, T("trans"));
		}else{		// [4]eݒ
			if ( Sm->ParamID[0] != '\0' ){
				int count = 200;
				for (;;){
					Sleep(100);
					if ( (Sm->ParamID[0] == '\0') || (count-- == 0) ) break;
				}
			}
			tstrcpy(Sm->ParamID, P->ID);
			tstrcpy(Sm->Param, param);
			SetEvent(hCommSendEvent); // [5]ݒʒm
		}
		break;
	}
	CloseHandle(hCommIdleEvent);
	CloseHandle(hCommSendEvent);
	return 0;
error:
	XMessage(hOwner, NULL, XM_FaERRd, MES_EPBY, T("Event destroyed/2"));
cancel:
	CloseHandle(hCommIdleEvent);
	CloseHandle(hCommSendEvent);
	return -1;
}

#define ONESENDLEN (CMDLINESIZE - 1)
int LongSendPPB(HWND hOwner, const TCHAR *param, TCHAR command, int useID)
{
	TCHAR SendParam[RECEIVESTRINGSLENGTH];
	size_t leftlen;
	int result;

	SendParam[0] = '>';
	// '>' 'command' "param" '\0'  1xőMł邩H
	leftlen = tstrlen(param);
	if ( leftlen < CMDLINESIZE ){ // 1xőM\
		SendParam[1] = command;
		memcpy(SendParam + 2, param, TSTROFF(leftlen + 1));
		return SendPPB(hOwner, SendParam, useID);
	}
	// MKv
	// 1ځc> B 'command' "param"
	SendParam[1] = 'B';
	SendParam[2] = command;
	tstrcpypart(SendParam + 3, param, ONESENDLEN);

	// 2ڈȍ~c> B "param"
	for(;;){
		result = SendPPB(hOwner, SendParam, useID);
		if ( result < 0 ) return result;
		param += ONESENDLEN;
		leftlen -= ONESENDLEN;
		if ( leftlen > ONESENDLEN ){ // 1xł͖
			tstrcpypart(SendParam + 2, param, ONESENDLEN);
			continue;
		}
		// Ōc> P "param"
		SendParam[1] = 'P';
		tstrcpypart(SendParam + 2, param, leftlen);
		return SendPPB(hOwner, SendParam, useID);
	}
}

DWORD RecvPPBExitCode(HWND hOwner, int useID)
{
	TCHAR buf[32];
	HANDLE hCommSendEvent;
	int count = 2000;
	DWORD result;

	if ( SendPPB(hOwner, PPBSPECIAL_EXITCODE, useID) != 0 ) return MAX32;

	tstrcpy(buf, SyncTag);
	tstrcat(buf, Sm->P[useID].ID);
	hCommSendEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, buf);
	if ( hCommSendEvent != NULL ){
		for ( ; ; ){
			if ( GetAsyncKeyState(VK_PAUSE) & KEYSTATE_PUSH ) break;
			result = WaitForSingleObject(hCommSendEvent, 0);
			if ( result != WAIT_OBJECT_0 ) break;
			Sleep(20);
			if ( count-- == 0 ) break;
		}
		CloseHandle(hCommSendEvent);
	}
	result = *(DWORD *)Sm->Param;
	Sm->ParamID[0] = '\0';
	return result;
}

DWORD PPbSpecialMessage(HWND hOwner, int useID, const TCHAR *command)
{
	HANDLE hCommSendEvent;
	ShareX *P;
	TCHAR buf[32];
	int count = 2000;

	P = &Sm->P[useID];
	UsePPx();
	if ( (P->ID[0] != 'B') || (P->ID[1] != '_') || (P->UsehWnd != hOwner) ){
		FreePPx();
		XMessage(hOwner, NULL, XM_FaERRd, MES_EPBY, T("useID destroy"));
		return -1;
	}

	tstrcpy(buf, SyncTag);
	tstrcat(buf, P->ID);					// PPb Ƃ̒ʐMim ---------
	FreePPx();
	hCommSendEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, buf);

	if ( hCommSendEvent == NULL ){
		XMessage(hOwner, NULL, XM_FaERRd, MES_EPBY, T("Event destroyed/1"));
		return -1;
	}

	// MȂҋ@(hCommSendEvent VOiȂ莞ԑҋ@)
	for ( ; ; ){
		DWORD result;

		if ( GetAsyncKeyState(VK_PAUSE) & KEYSTATE_PUSH ) break;
		result = WaitForSingleObject(hCommSendEvent, 0);
		if ( result != WAIT_OBJECT_0 ) break;
		Sleep(20);
		if ( count-- != 0 ) continue;
		CloseHandle(hCommSendEvent); // ҋ@̃^CAEg
		return -2;
	}

	for ( ; ; ){
										// Sm->Param ɐݒ
		if ( TSTRLENGTH(command) >= sizeof(Sm->Param) ){
			XMessage(hOwner, NULL, XM_FaERRd, MES_EPBY, T("trans"));
		}else{		// [4]eݒ
			if ( Sm->ParamID[0] != '\0' ){
				int count = 200;
				for (;;){
					Sleep(100);
					if ( (Sm->ParamID[0] == '\0') || (count-- == 0) ) break;
				}
			}
			tstrcpy(Sm->ParamID, P->ID);
			tstrcpy(Sm->Param, command);
			SetEvent(hCommSendEvent); // [5]ݒʒm
		}
		break;
	}
	CloseHandle(hCommSendEvent);
	return 0;
}
/*-----------------------------------------------------------------------------
	M(PPbp)
-----------------------------------------------------------------------------*/
PPXDLL int PPXAPI ReceiveStrings(const TCHAR *ID, TCHAR *str)
{
	UsePPx();
	if ( ID == NULL ){
		tstrcpy(Sm->Param, str);
		FreePPx();
		return 0;
	}
	if ( tstrcmp(Sm->ParamID, ID) == 0 ){
		if ( Sm->Param[0] != '=' ){ // ʏ
			tstrcpy(str, Sm->Param);
			Sm->ParamID[0] = '\0';
			FreePPx();
			return 0;
		}
		// =X ߂l  RecvPPBExitCode Sm->ParamID Kv
		if ( Sm->Param[1] == 'E' ){ // PPBSPECIAL_EXITCODE ̂Ƃ
			*(DWORD *)Sm->Param = *(DWORD *)str;
			FreePPx();
			return 1;
		}else{
			tstrcpy(str, Sm->Param);
			FreePPx();
			return 2;
		}
	}
	FreePPx();
	// ID sv
	XMessage(NULL, NULL, XM_FaERRd, T("ReceiveStrings - IDerror %s,%s"), Sm->ParamID, ID);
	return -1;
}
//====================================================================== to PPC
BOOL USEFASTCALL CheckPPcID(int no)
{
	TCHAR *id;

	id = Sm->P[no].ID;
	return (id[0] == 'C') && (id[1] == '_');
}

/*-----------------------------------------------------------------------------
	O PPc ԍ擾
	d:̎w		>0: <0:O CGETW_PAIR
out	Number
-----------------------------------------------------------------------------*/
int PPcGetNo(int RegNo, int direction)
{
	TCHAR ID[REGIDSIZE];
	int i, j;

	if ( RegNo < 0 ) return 0;
	tstrcpy(ID, Sm->P[RegNo].ID);
	FixTask();
	if ( direction == CGETW_PAIR ){
		ID[2] = (TCHAR)(((ID[2] - 1) ^ 1) + 1);
		for ( j = 0 ; j < X_Mtask ; j++ ){
			if ( !tstrcmp(Sm->P[j].ID, ID) ) break;
		}
	}else if ( direction >= 0 ){ // 
		for ( i = 0 ; i < X_MaxPPxID ; i++ ){
			ID[2]++;
			if ( ID[2] > 'Z' ) ID[2] = 'A';
			for ( j = 0 ; j < X_Mtask ; j++ ){
				if ( tstrcmp(Sm->P[j].ID, ID) == 0 ){
					i = 999;
					break;
				}
			}
		}
	}else{ // 
		for ( i = 0 ; i < X_MaxPPxID ; i++ ){
			ID[2]--;
			if ( ID[2] < 'A' ) ID[2] = 'Z';
			for ( j = 0 ; j < X_Mtask ; j++ ){
				if ( !tstrcmp( Sm->P[j].ID, ID) ){
					i = 999;
					break;
				}
			}
		}
	}
	if ( j == X_Mtask ) j = RegNo;
	return j;
}

int PPxRegistCombo(HWND hWnd, TCHAR *ID, int mode)
{
	int index;

	index = ID[2] - 'A'; // CB[A]

	if ( (index < 0) || (index >= X_MaxComboID) ){
		if ( mode != PPXREGIST_COMBO_IDASSIGN ) return 0;
		for ( index = 1 ; index < (X_MaxComboID - 1) ; index++ ){
			HWND hComboWnd;

			hComboWnd = Sm->ppc.hComboWnd[index];
			if ( hComboWnd == NULL ) break;
			if ( hComboWnd == BADHWND ) continue;
			if ( IsWindow(hComboWnd) == FALSE ){
				Sm->ppc.hComboWnd[index] = NULL;
				break;
			}
		}
		ID[2] = (TCHAR)('A' + index);
	}
	// PPXREGIST_COMBO_IDASSIGN / PPXREGIST_COMBO_FREE
	Sm->ppc.hComboWnd[index] = hProcessComboWnd =
			(mode == PPXREGIST_COMBO_IDASSIGN) ? hWnd : NULL;
	return 0;
}

// w肳ꂽꏊ琶ĂID
int PPxRegistLiveSearch(TCHAR *ID, int mode)
{
	int index = -1;
	int delta;

	UsePPx();
	{
		int focus, pair;

		focus = Sm->ppc.LastFocusID;
		pair = PPcGetNo(focus, CGETW_PAIR);

		if ( mode == PPXREGIST_SEARCH_LIVEID ) index = focus;
		if ( mode == (PPXREGIST_SEARCH_LIVEID + 1) ) index = pair;

		if ( (index < 0) || (CheckPPcID(index) == FALSE) ){ // gpςIDT
			int left = mode - PPXREGIST_SEARCH_LIVEID;

			for ( index = 0 ; index < X_Mtask ; index++ ){
				if ( IsTrue(CheckPPcID(index)) ){
					if ( (index != focus) && (index != pair) ){
						if ( left == 0 ) break;
					}
					if ( left ) left--;
				}
			}
		}
	}

	delta = 1;
	ID[3] = '\0';
	if ( index < X_Mtask ){ // gpςIDL
		ID[2] = Sm->P[index].ID[2];
	}else{ // gpIDT
		ID[2] = (TCHAR)('A' + (mode - PPXREGIST_SEARCH_LIVEID));
		while ( ID[2] < 'Z' ){
			if ( SearchPPx(ID) < 0 ) break;
			ID[2]++;
			delta++;
		}
	}
	FreePPx();
	if ( (mode + delta) >= PPXREGIST_SEARCH_LIVEID_MAX ){
		delta = PPXREGIST_SEARCH_LIVEID_MAX - mode;
	}
	return delta;
}

/*-----------------------------------------------------------------------------
	PPc̎擾
-----------------------------------------------------------------------------*/
PPXDLL HWND PPXAPI PPcGetWindow(int RegNo, int direction)
{
	if ( direction == CGETW_SAVEFOCUS ){
		if ( Sm->ppc.LastFocusID != RegNo ){
			if ( IsTrue(CheckPPcID(Sm->ppc.LastFocusID)) ){
				// SendMessagéAShowWindowŃfbhbN
				PostMessage(Sm->P[Sm->ppc.LastFocusID].hWnd,
						WM_PPXCOMMAND, KC_UNFOCUS, 0);
			}
			if ( (RegNo >= 0) && (RegNo < X_Mtask) ){
				Sm->P[RegNo].ActiveID = Sm->Active.high++;
				Sm->ppc.PrevFocusID = Sm->ppc.LastFocusID;
				Sm->ppc.LastFocusID = RegNo;
			}
		}
		return NULL;
	}
	if ( (direction == CGETW_GETFOCUS) || (direction == CGETW_GETFOCUSPAIR) ){
		HWND hWnd;
		int index;

		index = Sm->ppc.LastFocusID;
		if ( IsWindow(Sm->P[index].hWnd) ){
			if ( direction == CGETW_GETFOCUSPAIR ){
				index = PPcGetNo(index, CGETW_PAIR);
			}
		}else{
			index = -1;
			FixTask();
		}

		UsePPx();
		if ( (index >= 0) && IsTrue(CheckPPcID(index)) ){
			hWnd = Sm->P[index].hWnd;
		}else{
			hWnd = NULL;
			for ( index = 0 ; index < X_Mtask ; index++ ){
				if ( IsTrue(CheckPPcID(index)) ){
					hWnd = Sm->P[index].hWnd;
					break;
				}
			}
		}
		FreePPx();
		return hWnd;
	}
	if ( direction == CGETW_PREV ){
		if ( Sm->P[Sm->ppc.PrevFocusID].ID[0] == 'C' ){
			return Sm->P[Sm->ppc.PrevFocusID].hWnd;
		}
	}
	if ( direction == CGETW_GETCOMBOHWND ){
		HWND hComboWnd;

		if ( (RegNo < 0) || (RegNo > 25) ) return NULL;

		hComboWnd = Sm->ppc.hComboWnd[RegNo];
		if ( hComboWnd != NULL ){
			if ( (hComboWnd != BADHWND) && (IsWindow(hComboWnd) == FALSE) ){
				Sm->ppc.hComboWnd[RegNo] = NULL;
				hComboWnd = NULL;
			}
		}
		return hComboWnd;
	}

	if ( (RegNo < 0) || (RegNo >= X_Mtask) ) return NULL;
	{
		int i;
		HWND hWnd;

		UsePPx();
		i = PPcGetNo(RegNo, direction);
		if ( i == RegNo ){
			hWnd = NULL;
		}else{
			#pragma warning(suppress:6385) // i  X_Mtask 
			hWnd = Sm->P[i].hWnd;
		}
		FreePPx();
		return hWnd;
	}
}

/*-----------------------------------------------------------------------------
	OpX̎擾
-----------------------------------------------------------------------------*/
PPXDLL void PPXAPI PPcOldPath(INT_PTR RegNo, DWORD join, TCHAR *str)
{
	int index = -1;

	UsePPx();
	if ( join == MAX32 ){
		for ( index = 0 ; index < X_Mtask ; index++ ){
			if ( Sm->P[index].hWnd == (HWND)RegNo ){
				break;
			}
		}
	}else if ( (RegNo >= 0) && (RegNo < X_Mtask) ){
		if ( X_prtg < 0 ) X_prtg = GetCustDword(T("X_prtg"), 0);
		if ( X_prtg == 0 ){
			index = PPcGetNo((int)RegNo, CGETW_PAIR);
			if ( (join == 0) && (index == RegNo) ){
				if ( Sm->P[Sm->ppc.PrevFocusID].ID[0] == 'C' ){
					index = Sm->ppc.PrevFocusID;
				}
			}
		}else{
			if ( Sm->P[Sm->ppc.PrevFocusID].ID[0] == 'C' ){
				index = Sm->ppc.PrevFocusID;
			}else{
				index = (int)RegNo;
			}
			if ( index == RegNo ) index = PPcGetNo((int)RegNo, CGETW_PAIR);
		}
	}
	if ( (index == RegNo) || (index < 0) || (index >= X_Mtask) ){
		str[0] = '\0';
	}else{
		tstrcpy(str, Sm->P[index].path);
	}
	FreePPx();
}
//====================================================================== to PPV
/*-----------------------------------------------------------------------------
	PPv N
-----------------------------------------------------------------------------*/
void bootPPv(HWND hWnd, const TCHAR *fname, int flags)
{
	TCHAR buf[VFPS * 3];
	TCHAR *dest;
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
											// s̎w
	si.cb			= sizeof(si);
	si.lpReserved	= NULL;
	si.lpDesktop	= NULL;
	si.lpTitle		= NULL;
	si.dwFlags		= 0;
	si.cbReserved2	= 0;
	si.lpReserved2	= NULL;

	dest = thprintf(buf, TSIZEOF(buf), T("\"%s") T(PPVEXE) T("\" "), DLLpath);

	if ( flags & (PPV_NOFOREGROUND | PPV_BOOTID | PPV_SETPARENTWND) ){
//		dest = tstpcpy(dest, T("-noactive "));
		if ( flags & PPV_NOFOREGROUND ){
			dest = thprintf(dest, 64, T("-focus:%u "), (DWORD)(DWORD_PTR)hWnd);
		}
		if ( flags & PPV_BOOTID ){
			dest = thprintf(dest, 64, T("-bootid:%c "), (flags >> 24));
		}
		if ( flags & PPV_SETPARENTWND ){
			dest = thprintf(dest, 64, T("-setparent:%u "), (DWORD)(DWORD_PTR)hWnd);
		}
	}
	thprintf(dest, TSIZEOF(buf) - (dest - buf),
			(flags & PPV_PARAM) ? T("%s") : T("\"%s\""), fname);

	if ( IsTrue(CreateProcess(NULL, buf, NULL, NULL, FALSE,
				CREATE_DEFAULT_ERROR_MODE, NULL, DLLpath, &si, &pi)) ){
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}else{
		ErrorPathBox(hWnd, NULL, buf, PPERROR_GETLASTERROR);
	}
}
/*-----------------------------------------------------------------------------
	t@C̓e\
-----------------------------------------------------------------------------*/
#define RESERVE_HWND ((HWND)(LONG_PTR)-2)
PPXDLL BOOL PPXAPI PPxView(HWND hWnd, const TCHAR *param, int flags)
{
	ShareX *FindP = NULL, *ReserveP = NULL;
	int i;

	FixTask();
	UsePPx();
	for ( i = 0 ; i < X_Mtask ; i++ ){ // gpłPPv
		if ( (Sm->P[i].ID[0] == 'V') && (Sm->P[i].ID[1] == '_') ){
			if ( flags & PPV_BOOTID ){ // IDŒ
				if ( Sm->P[i].ID[2] != (flags >> 24) ) continue;
				FindP = &Sm->P[i];
				break;
			}else{
				if ( Sm->P[i].UsehWnd == RESERVE_HWND ) continue;
			}

			if ( Sm->P[i].UsehWnd == hWnd ){
				FindP = &Sm->P[i];
				break;
			}

			if ( ReserveP == NULL ){
				ReserveP = &Sm->P[i];
			}else{
				if ( ReserveP->UsehWnd == RESERVE_HWND ) ReserveP = &Sm->P[i];
			}
		}
	}
	if ( FindP == NULL ) FindP = ReserveP;
	if ( FindP != NULL ){ // PPv𔭌
		HWND hVWnd;

		Sm->view.flags = flags;
		hVWnd = FindP->hWnd;
		tstplimcpy((TCHAR *)Sm->view.param, param, TSIZEOF(Sm->view.param));

		if ( (flags & (PPV_SYNCVIEW | PPV_BOOTID)) == (PPV_SYNCVIEW | PPV_BOOTID)){
			FindP->UsehWnd = RESERVE_HWND;
		}

		FreePPx();
		if ( !(flags & (PPV_NOFOREGROUND | PPV_NOENSURE)) ){
			SetForegroundWindow(hVWnd);
		}
		PostMessage(hVWnd, WM_PPXCOMMAND, KV_Load, (LPARAM)hWnd);
		return TRUE;
	}
	FreePPx();
	if ( *param == 2 ) param++;
	if ( flags & PPV_DISABLEBOOT ){
		return FALSE;
	}else{
		bootPPv(hWnd, param, flags | PPV_SETPARENTWND);
		return TRUE;
	}
}

// w肵 hWnd  PPx L
PPXDLL BOOL PPXAPI BusyPPx(HWND hWnd, HWND hUseWnd)
{
	int i;

	FixTask();
	UsePPx();
	for ( i = 0 ; i < X_Mtask ; i++ ){
		if ( Sm->P[i].hWnd == hWnd ){
			Sm->P[i].UsehWnd = hUseWnd;
			FreePPx();
			return TRUE;
		}
	}
	FreePPx();
	return FALSE;
}
/*-----------------------------------------------------------------------------
	t@C擾
	0: 1:ɓǂݍ
-----------------------------------------------------------------------------*/
PPXDLL int PPXAPI PPvViewName(TCHAR *param)
{
	int flags;

	UsePPx();
	if ( !*Sm->view.param ){
		FreePPx();
		return -1;
	}
	tstrcpy(param, (TCHAR *)Sm->view.param);
	flags = Sm->view.flags;
	FreePPx();
	return flags;
}

// Combo Window o^/擾
// hWnd = NULL : o^ς hWnd 擾A߂l BADHWND ȂVK
// hWnd = HWND : o^Bxw肷Ɖ
// hWnd = BADHWND : ݂hWnd𓾂
PPXDLL HWND PPXAPI PPxCombo(HWND hWnd)
{
	UsePPx();

	if ( hWnd == NULL ){
		if ( Sm->ppc.hComboWnd[0] == NULL ){
			Sm->ppc.hComboWnd[0] = hProcessComboWnd = BADHWND;
		}
	}else if ( hWnd != BADHWND ){
		if ( hWnd == Sm->ppc.hComboWnd[0] ){
			Sm->ppc.hComboWnd[0] = hProcessComboWnd = NULL;
		}else{
			if ( IsWindow(Sm->ppc.hComboWnd[0]) == FALSE ){ // Combo window Ă邩H
				Sm->ppc.hComboWnd[0] = hProcessComboWnd = NULL;
			}
			if ( (Sm->ppc.hComboWnd[0] == NULL) || (Sm->ppc.hComboWnd[0] == BADHWND) ){
				Sm->ppc.hComboWnd[0] = hProcessComboWnd = hWnd;
			}
		}
	}
	FreePPx();
	return Sm->ppc.hComboWnd[0];
}

int GetPPxListFromCombo(HMENU hPopupMenu, int mode, ThSTRUCT *thMenuData, TCHAR *ppclist, DWORD *useppclist, MENUITEMINFO *minfo)
{
	TCHAR *listIDptr, *listPathPtr;
	int item = 0;
	TCHAR buf2[VFPS];

	if ( ppclist == NULL ) return 0;

	listIDptr = ppclist;
	for ( ; *listIDptr != '\0'; ){
		listPathPtr = listIDptr + tstrlen(listIDptr) + 1;
		if ( *listIDptr == '\t' ){
			if ( hPopupMenu ) AppendMenu(hPopupMenu, MF_SEPARATOR, 0, NULL);
		}else{
			setflag(*useppclist, 1 << (listIDptr[2] - 'A'));
			if ( hPopupMenu != NULL ){
				if ( mode == GetPPcList_Path ){
					if ( thMenuData != NULL ){
						ThAddString(thMenuData, EscapeMacrochar(listPathPtr, minfo->dwTypeData));
					}
					thprintf(minfo->dwTypeData, VFPS, T("%c&%s: %s"), *listIDptr, listIDptr + 2, listPathPtr);
				}else{
					thprintf(minfo->dwTypeData, VFPS, T("PPc %c&%s: %s"), *listIDptr, listIDptr + 2, listPathPtr);
				}
				minfo->fMask = MIIM_STATE | MIIM_TYPE | MIIM_ID | MIIM_DATA;
				minfo->dwItemData = 0;
				InsertMenuItem(hPopupMenu, 0xffff, TRUE, minfo);
				++minfo->wID;
			}
			if ( thMenuData != NULL ){
				thprintf(buf2, TSIZEOF(buf2), T("C_%s"), listIDptr + 2);
				switch ( mode ){
					case GetPPxList_IdList:
						tstrcat(buf2, T(","));
						ThCatString(thMenuData, buf2);
						break;
					case GetPPxList_Id:
						ThAddString(thMenuData, buf2);
						break;
					case GetPPxList_Select:
						thprintf(minfo->dwTypeData, VFPS, T("*focus %s"), buf2);
						ThAddString(thMenuData, minfo->dwTypeData);
						break;
				}
			}
			item++;
		}
		listIDptr = listPathPtr + tstrlen(listPathPtr) + 1;
	}
	HeapFree(DLLheap, 0, ppclist);
	if ( (mode != GetPPcList_Path) && (hPopupMenu != NULL) ){
		AppendMenu(hPopupMenu, MF_SEPARATOR, 0, NULL);
	}
	return item;
}

int GetPPxListFromCurrentCombo(HMENU hPopupMenu, int mode, ThSTRUCT *th, DWORD *useppclist, MENUITEMINFO *minfo)
{
	return GetPPxListFromCombo(hPopupMenu, mode, th, (TCHAR *)SendMessage(hProcessComboWnd, WM_PPXCOMMAND, KCW_ppclist, 0), useppclist, minfo);
}

int GetPPxListFromProcessCombo(HMENU hPopupMenu, int mode, ThSTRUCT *th, DWORD *useppclist, MENUITEMINFO *minfo, HWND hComboWnd)
{
	LRESULT lr;
	TCHAR buf1[VFPS + 16], buf2[VFPS];
	TCHAR *ppclist;
	DWORD size;
	ERRORCODE ec;

	lr = SendMessage(hComboWnd, WM_PPXCOMMAND, TMAKEWPARAM(KCW_ppclist, 1), 0);
	if ( lr == 0 ) return 0;

	thprintf(buf1, TSIZEOF(buf1), T("%%temp%%\\ppxl%d"), (int)lr);
	ExpandEnvironmentStrings(buf1, buf2, TSIZEOF(buf2));

	ppclist = NULL;
	ec = LoadFileImage(buf2, 4, (char **)&ppclist, &size, LFI_ALWAYSLIMITLESS);
	DeleteFile(buf2);
	if ( ec != NO_ERROR ) return 0;

	return GetPPxListFromCombo(hPopupMenu, mode, th, ppclist, useppclist, minfo);
}

/*
	GetPPcList_Path Ȃ "x&ID: path" `
	 mode Ȃ "PPc x&ID: path"  "PPx ID: & " `
*/
int GetPPxList(HMENU hPopupMenu, int mode, ThSTRUCT *th, DWORD *menuid)
{
	int i, minpos, pos, items = 0;
	MENUITEMINFO minfo;
	ShareX *sx;
	TCHAR buf1[VFPS + 16], buf2[VFPS];
	DWORD useppclist = 0; // vZXŎgpĂPPcIDꗗ

	minfo.cbSize = sizeof(minfo);
	minfo.fType = MFT_STRING;
	minfo.fState = MFS_ENABLED;
	minfo.dwTypeData = buf1;
	minfo.wID = *menuid;

	// Ȉ̉
	if ( hProcessComboWnd != NULL ){
		items += GetPPxListFromCurrentCombo(hPopupMenu, mode, th, &useppclist, &minfo);
	}

	// ̉
	for ( i = 0 ; i < X_MaxComboID ; i++ ){
		HWND hComboWnd;

		hComboWnd = Sm->ppc.hComboWnd[i];
		if ( (hComboWnd == NULL) || (hComboWnd == BADHWND) || (hComboWnd == hProcessComboWnd) ){
			continue;
		}
		items += GetPPxListFromProcessCombo(hPopupMenu, mode, th, &useppclist, &minfo, hComboWnd);
	}

	minpos = GetMenuItemCount(hPopupMenu);

	// Ɨ
	UsePPx();
	sx = Sm->P;
	for ( i = 0 ; i < X_Mtask ; i++, sx++ ){
		TCHAR *name, ID;

		ID = sx->ID[0];
		if ( ID == '\0' ) continue;
		if ( (ID == 'C') && (useppclist & (1 << (sx->ID[2] - 'A'))) ) continue;

		if ( mode == GetPPcList_Path ){
			if ( (ID != 'C') || (sx->ID[1] != '_') ) continue;
			if ( th != NULL ){
				ThAddString(th, EscapeMacrochar(sx->path, buf1));
			}
			thprintf(buf1, TSIZEOF(buf1), T("%c&%c: %s"),
					(sx->hWnd == Sm->ppc.hLastFocusWnd) ? '*' : ' ',
					sx->ID[2], sx->path);
		}else{
			switch ( ID ){
				case 'B':
					name = T("PPb");
					break;
				case 'C':
					name = T("PPc");
					break;
				case 'V':
					name = T("PPv");
					break;
				case 'c':
					name = T("PPcust");
					break;
				default:
					continue;
			}
			if ( (ID == 'C') && (sx->ID[2] <= 'Z') ){
				thprintf(buf1, TSIZEOF(buf1), T("%s %c&%c: %s"), name,
						(sx->hWnd == Sm->ppc.hLastFocusWnd) ? '*' : ' ',
						sx->ID[2], sx->path);
			}else {
				thprintf(buf1, TSIZEOF(buf1), T("%s %c: & "), name, sx->ID[2]);
			}
		}
		for ( pos = minpos ; pos < (minpos + items) ; pos++ ){ // ȈՃ\[g
			GetMenuString(hPopupMenu, pos, buf2, TSIZEOF(buf2), MF_BYPOSITION);
				if ( tstrcmp(buf1, buf2) < 0 ) break;
		}
		if ( mode == GetPPxList_hWnd ){
			minfo.dwItemData = (ULONG_PTR)sx->hWnd;
		}else{
			if ( th != NULL ) switch ( mode ){
				case GetPPxList_Id:
					ThAddString(th, sx->ID);
					break;
				case GetPPxList_Select:
					thprintf(th, THP_ADD, T("*focus %s"), sx->ID);
					break;
			}
		}
		minfo.fMask = MIIM_STATE | MIIM_TYPE | MIIM_ID | MIIM_DATA;
		InsertMenuItem(hPopupMenu, pos, TRUE, &minfo);
		minfo.wID++;
		items++;
	}
	FreePPx();
	*menuid = minfo.wID;
	return items;
}

//****************************************************************************
//		Job Ǘ
//****************************************************************************
void JobListItemDraw(DRAWITEMSTRUCT *lpdis)
{
	TCHAR buf[CMDLINESIZE];
	int len;
	COLORREF backcolor = C_AUTO;
	HBRUSH hB;
	DWORD state = 0;
	int index, rate = 0, enable_input = 0, height, width;
	RECT box;

	if ( (int)lpdis->itemID >= 0 ){
		UsePPx();
		index = (int)lpdis->itemData;
		if ( (index >= 0) && (index < X_MaxJob) && (Sm->Job[index].ThreadID != 0) ){
			state = Sm->Job[index].state.dw;
			rate = Sm->Job[index].state.b.rate;
			enable_input = Sm->Job[index].hWnd != NULL;
		}
		FreePPx();

		// wiFE`
		if ( state & (JOBFLAG_WAITEXEC | JOBFLAG_WAITJOB | JOBFLAG_PAUSE | JOBFLAG_ERROR) ){
			COLORREF c;

			if ( backcolor == C_AUTO ) backcolor = GetBkColor(lpdis->hDC);
			if ( state & (JOBFLAG_ERROR | JOBFLAG_PAUSE) ){
				c = (state & JOBFLAG_ERROR) ? C_RED : C_YELLOW;
			}else{
				c = (state & JOBFLAG_WAITEXEC) ? C_GREEN : C_CYAN;
			}
			#define GetPointColor(bc, fc) (BYTE)(int)((int)bc + ((int)fc - (int)bc) / 4)
			backcolor = RGB(
				GetPointColor(GetRValue(backcolor), GetRValue(c)),
				GetPointColor(GetGValue(backcolor), GetGValue(c)),
				GetPointColor(GetBValue(backcolor), GetBValue(c)));
		}
		if ( backcolor != C_AUTO ){
			hB = CreateSolidBrush(backcolor);
			FillBox(lpdis->hDC, &lpdis->rcItem, hB);
			DeleteObject(hB);
			SetBkMode(lpdis->hDC, TRANSPARENT);
		}else{
			SetBkMode(lpdis->hDC, OPAQUE);
		}

		// Ot̕`
		height = lpdis->rcItem.bottom - lpdis->rcItem.top;
		width = lpdis->rcItem.right - lpdis->rcItem.left;
		if ( rate ){
			box.left = lpdis->rcItem.left;
			box.top = lpdis->rcItem.bottom - (height / 4);
			box.bottom = lpdis->rcItem.bottom - 1;
			box.right = lpdis->rcItem.left + (width * rate) / 100;
			FillBox(lpdis->hDC, &box, GetHighlightBackBrush());
			SetBkMode(lpdis->hDC, TRANSPARENT);
		}

		// }EXp{^̕`
		box = lpdis->rcItem;
		if ( enable_input && ((height * SHOWJOBBUTTON_MINRATE) < width) ){
			int ah;

			box.left = box.right - height;
			// tH[JXL
			if ( (jobselectmode == JOBSELECTMODE_PAUSE) &&
				 (lpdis->itemState & ODS_SELECTED) ){
				box.top++;
				box.bottom--;
				box.right--;
				FrameRect(lpdis->hDC, &box, GetStockObject(DKGRAY_BRUSH));
				box.right++;
				box.bottom++;
				box.top--;
			}
			ah = height / 4;
			box.top += ah;
			box.left += ah;
			box.right -= ah;
			box.bottom -= ah;
			if ( state & JOBFLAG_PAUSE ){ // fĐ{^\
				HGDIOBJ hOldBrush;
				POINT pos[3];

				hOldBrush = SelectObject(lpdis->hDC, GetStockObject(BLACK_BRUSH));
				pos[0].x = pos[2].x = box.left;
				pos[0].y = box.top;
				pos[1].x = box.right;
				pos[1].y = box.top + ah;
				pos[2].y = box.bottom;
				Polygon(lpdis->hDC, pos, 3);
				SelectObject(lpdis->hDC, hOldBrush);
			}else{ // ~{^
				FillBox(lpdis->hDC, &box, GetStockObject(BLACK_BRUSH));
			}
			box = lpdis->rcItem;
			box.right -= height;
		}

		// \`
		len = (int)SendMessage(lpdis->hwndItem, LB_GETTEXT, lpdis->itemID, (LPARAM)buf);
		DrawText(lpdis->hDC, buf, len, &box, DT_END_ELLIPSIS | DT_NOPREFIX);
		SetBkMode(lpdis->hDC, OPAQUE);
	}

	// tH[JXg`
	if ( lpdis->itemState & ODS_FOCUS ){
		FrameRect(lpdis->hDC, &lpdis->rcItem, GetStockObject(DKGRAY_BRUSH));
	}
}

void JobListSelect(HWND hWnd, int listindex, int mode)
{
	HWND hTargetWnd;
	int state;

	int index = (int)SendMessage(hWnd, LB_GETITEMDATA, (WPARAM)listindex, 0);
//	index = CallWindowProc(OldJobProc, hWnd, LB_GETITEMDATA, (WPARAM)listindex, 0); 炾ƎsB
	if ( (listindex < 0) && (listindex >= X_MaxJob) ) return;

	UsePPx();
	hTargetWnd = Sm->Job[index].hWnd;
	state = Sm->Job[index].state.dw;
	FreePPx();

	if ( hTargetWnd == NULL ){
		if ( (mode == JOBSELECTMODE_PAUSE) || (mode == JOBSELECTMODE_CLOSE) ){
			keybd_event(VK_PAUSE, 0, 0, 0);
			keybd_event(VK_PAUSE, 0, KEYEVENTF_KEYUP, 0);
		}
		return;
	}

	if ( !(GetWindowLongPtr(hTargetWnd, GWL_STYLE) & WS_VISIBLE) ){
		ShowWindow(hTargetWnd, SW_RESTORE);
	}

	if ( mode == JOBSELECTMODE_FOCUS ){
		ShowWindow(hTargetWnd, SW_SHOWNORMAL);
		SetForegroundWindow(hTargetWnd);
	}else{
		if ( state & JOBFLAG_ENABLEHIDE ){
			SendMessage(hTargetWnd, WM_COMMAND,
					(mode == JOBSELECTMODE_CLOSE) ? IDCANCEL : IDOK, 0);
		}else{
			PostMessage(hTargetWnd, WM_KEYDOWN, VK_PAUSE, 0);
		}
	}
}

void JobListButtonUp(HWND hWnd, LPARAM lParam)
{
	int index, height, mode = JOBSELECTMODE_FOCUS;
	RECT box;

	index = (int)CallWindowProc(OldJobProc, hWnd, LB_ITEMFROMPOINT, 0, lParam);
	if ( (index < 0) || HIWORD(index) ) return;

	CallWindowProc(OldJobProc, hWnd, LB_GETITEMRECT, 0, (LPARAM)&box);
	#pragma warning(suppress:6001) // O̍sŏ
	height = box.bottom - box.top;
	if ( (height * SHOWJOBBUTTON_MINRATE) < (box.right - box.left) ){
		int x = LOSHORTINT(lParam);

		x -= box.right - (height * 1);
		if ( x >= 0 ){
			mode = (x / height) + 1;
			x = x % height;
			if ( (x < 1) || (x >= (height - 1)) ){
				return; // {^炸Ă̂Ŗ
			}
		}
	}
	JobListSelect(hWnd, index, mode);
}

LRESULT CALLBACK JobListWndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch(iMsg){
		case WM_ERASEBKGND: {
			RECT box;

			GetClientRect(hWnd, &box);
			FillRect((HDC)wParam, &box, (HBRUSH)GetWindowLongPtr(GetParent(hWnd), GWLP_USERDATA));
			return 1;
		}

		case WM_KEYDOWN:
			if ( (wParam == VK_LEFT) || (wParam == VK_RIGHT) ){
				if ( wParam == VK_LEFT ){
					jobselectmode--;
					if ( jobselectmode < JOBSELECTMODE_FOCUS ){
//						jobselectmode = JOBSELECTMODE_CLOSE;
						jobselectmode = JOBSELECTMODE_PAUSE;
					}
				}else{
					jobselectmode++;
//					if ( jobselectmode > JOBSELECTMODE_CLOSE ){
					if ( jobselectmode > JOBSELECTMODE_PAUSE ){
						jobselectmode = JOBSELECTMODE_FOCUS;
					}
				}
				InvalidateRect(hWnd, NULL, TRUE);
				return 0;
			}

			if ( (wParam == VK_SPACE) || (wParam == VK_RETURN) ){
				int index = (int)CallWindowProc(OldJobProc, hWnd, LB_GETCURSEL, 0, 0);

				if ( index >= 0 ) JobListSelect(hWnd, index, jobselectmode);
				return 0;
			}
			if ( wParam == VK_ESCAPE ){
				HWND hPWnd = GetParent(hWnd);

				if ( Sm->JobList.showmode == JOBLIST_INNER ){
					SetFocus(GetParent(hPWnd));
				}else{
					PostMessage(hPWnd, WM_CLOSE, 0, 0);
				}
				return 0;
			}
			break;

		case WM_LBUTTONUP:
			JobListButtonUp(hWnd, lParam);
			break;
	}
	return CallWindowProc(OldJobProc, hWnd, iMsg, wParam, lParam);
}

void DestroyJobList(HWND hWnd)
{
	int index;
	JobX *job = Sm->Job;
	WINPOS WPos;
	WINDOWPLACEMENT wp;
	HFONT hMesFont;
	HBRUSH hJobBackBrush;

	for ( index = 0 ; index < X_MaxJob ; index++, job++ ){
		if ( job->ThreadID == 0 ) continue;
		if ( !(job->state.dw & JOBFLAG_ENABLEHIDE) ) continue;
		if ( !(GetWindowLongPtr(job->hWnd, GWL_STYLE) & WS_VISIBLE) ){
			ShowWindow(job->hWnd, SW_SHOWNOACTIVATE);
		}
	}
	Sm->JobList.hWnd = NULL;
	hMesFont = (HFONT)SendMessage(hWnd, WM_GETFONT, 0, 0);
	if ( hMesFont != NULL ) DeleteObject(hMesFont);

	hJobBackBrush = (HBRUSH)GetWindowLongPtr(hWnd, GWLP_USERDATA);
	if ( hJobBackBrush != NULL ) DeleteObject(hJobBackBrush);

	if ( Sm->JobList.showmode != JOBLIST_INNER ){
		wp.length = sizeof(wp);
		GetWindowPlacement(hWnd, &wp);
		if ( wp.showCmd == SW_SHOWNORMAL ){
			WPos.show = (BYTE)wp.showCmd;
			WPos.reserved = 0;
			GetWindowRect(hWnd, &WPos.pos);
			SetCustTable(T("_WinPos"), T("JobLst"), &WPos, sizeof(WPos));
		}
		PostQuitMessage(EXIT_SUCCESS);
	}
}

LRESULT CALLBACK JobListParentWndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch(iMsg){
		case WM_DRAWITEM:
			JobListItemDraw((DRAWITEMSTRUCT *)lParam);
			break;

		case WM_DESTROY:
			DestroyJobList(hWnd);
			break;

		case WM_CTLCOLORLISTBOX: {
			LRESULT hJobBackBrush = GetWindowLongPtr(hWnd, GWLP_USERDATA);

			if ( hJobBackBrush != 0 ){
				SetTextColor((HDC)wParam, CJ_log[0]);
				SetBkColor((HDC)wParam, CJ_log[1]);
				return hJobBackBrush;
			}
			return DefWindowProc(hWnd, iMsg, wParam, lParam);
		}
		case WM_SIZE:
			SetWindowPos(Sm->JobList.hWnd, NULL,
				0, 0, LOWORD(lParam), HIWORD(lParam),
				SWP_NOZORDER | SWP_NOMOVE | SWP_NOACTIVATE);
		// default 

		default:
			return DefWindowProc(hWnd, iMsg, wParam, lParam);
	}
	return 0;
}

#define JOBINFOTEXTSIZE (VFPS + 32)
void MakeJobInfoText(HWND hWnd, DWORD state, TCHAR *text)
{
	TCHAR *p;
	const TCHAR *sstr = NilStr;
	DWORD statetype;

	if ( state & (JOBFLAG_ERROR | JOBFLAG_PAUSE | JOBFLAG_WAITEXEC | JOBFLAG_WAITJOB) ){
		if ( state & (JOBFLAG_ERROR | JOBFLAG_PAUSE) ){
			sstr = (state & JOBFLAG_ERROR) ? MES_JLER : MES_JLPA;
		}else{
			sstr = (state & JOBFLAG_WAITEXEC) ? MES_JLEX : MES_JLWA;
		}
		sstr = MessageText(sstr);
	}
	statetype = state & JOBFLAG_NAMEMASK;
	if ( statetype >= JOBSTATE_MAX ) statetype = JOBSTATE_UNDEFINED;
	p = thprintf(text, CMDLINESIZE, T("%s%s:"), sstr, MessageText(JobTypeNames[statetype]) );
	if ( hWnd == NULL ){
		THREADSTRUCT *ts;

		UsePPx();
		ts = GetCurrentThreadInfo();
		if ( ts != NULL ) tstrcpy(p, ts->ThreadName);
		FreePPx();
	}else{
		GetWindowText(hWnd, p, JOBINFOTEXTSIZE - (p - text));
		if ( Isdigit(*p) ){
			TCHAR *p2;

			if ( (p2 = tstrchr(p, '/')) != NULL ){
				p2 += 1;
				memmove(p, p2, TSTRSIZE(p2));
			}
		}
	}
}

void USEFASTCALL AddJobListStr(int jobindex, const TCHAR *text, int posindex)
{
	int index;

	index = (int)SendMessage(Sm->JobList.hWnd, LB_INSERTSTRING, (WPARAM)posindex, (LPARAM)text);
	SendMessage(Sm->JobList.hWnd, LB_SETITEMDATA, (WPARAM)index, (LPARAM)jobindex);
}

void ShowJobListWnd(HWND hWnd)
{
	HWND hParent;
	RECT targetbox, box;

	if ( Sm->JobList.showmode == JOBLIST_INNER ) return;

	hParent = GetParent(Sm->JobList.hWnd);
	if ( X_jlst[0] != JOBLIST_FLOAT ){
		ShowWindow(hParent, SW_SHOWNOACTIVATE);
		return;
	}

	if ( hWnd == NULL ) hWnd = PPcGetWindow(0, CGETW_GETFOCUS);
	if ( hWnd == NULL ){
		hWnd = GetForegroundWindow();
	}else{
		HWND hWParent;

		for (;;){
			hWParent = GetParent(hWnd);
			if ( hWParent == NULL ) break;
			hWnd = hWParent;
		}
	}
	GetWindowRect(hWnd, &targetbox);
	GetWindowRect(hParent, &box);

	SetWindowPos(hParent, HWND_TOP,
			targetbox.right,
			targetbox.bottom - (box.bottom - box.top),
			0, 0, SWP_NOACTIVATE | SWP_SHOWWINDOW | SWP_NOSIZE);

	if ( SendMessage(Sm->JobList.hWnd, LB_GETCURSEL, 0, 0) == LB_ERR ){
		SendMessage(Sm->JobList.hWnd, LB_SETCURSEL, 0, 0);
	}
}

void InitJobListWindow(HWND hMainWnd)
{
	HWND hParentWnd;
	DWORD style;
	WINPOS WPos = {{0, 0, 200, 100}, 0, 0};

	if ( DLLWndClass.item.Joblist == 0 ){
		WNDCLASS wcClass;

		wcClass.style			= 0;
		wcClass.lpfnWndProc		= JobListParentWndProc;
		wcClass.cbClsExtra		= 0;
		wcClass.cbWndExtra		= 0;
		wcClass.hInstance		= DLLhInst;
		wcClass.hIcon			= LoadIcon(DLLhInst, MAKEINTRESOURCE(Ic_FOP));
		wcClass.hCursor			= LoadCursor(NULL, IDC_ARROW);
		wcClass.hbrBackground	= (HBRUSH)(LONG_PTR)(COLOR_WINDOW + 1);
		wcClass.lpszMenuName	= NULL;
		wcClass.lpszClassName	= T("Jobist");
		DLLWndClass.item.Joblist = RegisterClass(&wcClass);
	}

	if ( hMainWnd == NULL ){
		style = WS_OVERLAPPEDWINDOW;
	}else{
		style = WS_CHILD | WS_VISIBLE;
	}
	GetCustTable(T("_WinPos"), T("JobLst"), &WPos, sizeof(WPos));
	WPos.pos.right -= WPos.pos.left;
	if ( WPos.pos.right < 32 ) WPos.pos.right = 200;
	WPos.pos.bottom -= WPos.pos.top;
	if ( WPos.pos.bottom < 32 ) WPos.pos.bottom = 100;

	hParentWnd = CreateWindowEx(WS_EX_TOOLWINDOW, T("Jobist"), T("PPx job"),
			style, WPos.pos.left, WPos.pos.top,
			WPos.pos.right, WPos.pos.bottom, hMainWnd, NULL, DLLhInst, NULL);

	GetCustData(T("CC_log"), &CJ_log, sizeof(CJ_log));

	Sm->JobList.hWnd = CreateWindowEx(0, ListBoxClassName, NilStr,
			WS_CHILD | WS_VISIBLE | WS_VSCROLL | LBS_HASSTRINGS | LBS_OWNERDRAWFIXED | LBS_NOINTEGRALHEIGHT,
			0, 0, 200, 100, hParentWnd, CHILDWNDID(IDL_JOBLIST), DLLhInst, NULL);
	if ( Sm->JobList.hWnd != NULL ){
		HBRUSH hJobBackBrush = NULL;
		LOGFONTWITHDPI cursfont;

		OldJobProc = (WNDPROC)SetWindowLongPtr(
				Sm->JobList.hWnd, GWLP_WNDPROC, (LONG_PTR)JobListWndProc);

		LocalizeDialogText(Sm->JobList.hWnd, 0);
		GetPPxFont(PPXFONT_F_mes, GetMonitorDPI(hParentWnd), &cursfont);
		SendMessage(Sm->JobList.hWnd, WM_SETFONT, (WPARAM)
			CreateFontIndirect(&cursfont.font), TMAKELPARAM(TRUE, 0));
		if ( (CJ_log[0] != C_AUTO) || (CJ_log[1] != C_AUTO) || (X_uxt[0] >= UXT_MINPRESET) ){
			InitSysColors();
			CJ_log[0] = GetSchemeColor(CJ_log[0], C_WindowText);
			CJ_log[1] = GetSchemeColor(CJ_log[1], C_WindowBack);
			hJobBackBrush = CreateSolidBrush(CJ_log[1]);
		}
		SetWindowLongPtr(hParentWnd, GWLP_USERDATA, (LONG_PTR)hJobBackBrush);
		ShowJobListWnd(NULL);
	}
}

#pragma argsused
THREADEXRET THREADEXCALL JobListWindowThread(void *param)
{
	MSG msg;
	THREADSTRUCT threadstruct = {T("Job list"), XTHREAD_EXITENABLE | XTHREAD_TERMENABLE, NULL, 0, 0};
	UnUsedParam(param);

	PPxRegisterThread(&threadstruct);

	InitJobListWindow(NULL);

	if ( Sm->JobList.hWnd != NULL ){
		for ( ; ; ){
			if ( (int)GetMessage(&msg, NULL, 0, 0) <= 0 ) break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		Sm->JobList.hWnd = NULL;
	}
	PPxUnRegisterThread();
	t_endthreadex(0);
}

void CreateJobListWnd(void)
{
	DWORD tid;
	HWND hMainWnd = Sm->JobList.hWnd;

	X_jlst[0] = JOBLIST_OFF;
	GetCustData(T("X_jlst"), X_jlst, sizeof(X_jlst));

	Sm->JobList.hWnd = NULL;
	Sm->JobList.hidemode = X_jlst[1];
	if ( hMainWnd == NULL ){
		int i;

		CloseHandle(t_beginthreadex(NULL, 0,
				(THREADEXFUNC)JobListWindowThread, 0, 0, &tid));
		for ( i = 0 ; i < 60 ; i++ ){
			Sleep(50);
			if ( Sm->JobList.hWnd != NULL ) break;
		}
	}else{
		InitJobListWindow(hMainWnd);
	}
	if ( Sm->JobList.hWnd != NULL ){ // ̓eꊇo^
		int i;

		for ( i = 0 ; i < X_MaxJob ; i++ ){
			TCHAR buf[VFPS * 2];
			HWND hJobWnd;
			DWORD state;

			if ( Sm->Job[i].ThreadID == 0 ) continue;
			hJobWnd = Sm->Job[i].hWnd;
			state = Sm->Job[i].state.dw;
			MakeJobInfoText(hJobWnd, state, buf);
			AddJobListStr(i, buf, -1);
		}
	}
}

void CheckJobList(void)
{
	int i;
	JobX *job;

	job = Sm->Job;
	for ( i = 0 ; i < X_MaxJob ; i++, job++ ){
		if ( job->ThreadID &&
			 (job->hWnd != NULL) &&
			 (IsWindow(job->hWnd) == FALSE) ){
			job->ThreadID = 0;
		}
	}
}

void StartNextJobTask(void)
{
	int i, index C4701CHECK;
	HWND hNextJobWnd;

	if ( GetCustDword(T("X_fopw"), 0) != 2 ) return;

	for (;;){
		hNextJobWnd = NULL;
		UsePPx();
		for ( i = 0 ; i < X_MaxJob ; i++ ){
			if ( Sm->Job[i].ThreadID == 0 ) continue;
			// vZXI҂͑ΏۊO
			if ( Sm->Job[i].state.dw & JOBFLAG_WAITEXEC ) continue;

			if ( Sm->Job[i].state.dw & JOBFLAG_WAITJOB ){ // s҂ȂoĂ
				if ( (hNextJobWnd == NULL) && IsTrue(IsWindow(Sm->Job[i].hWnd)) ){
					index = i;
					hNextJobWnd = Sm->Job[i].hWnd;
#if JOBLOG
					XMessage(NULL, NULL, XM_DbgLOG, T("hNextJobWnd[%d]: %x"), index, hNextJobWnd);
#endif
				}
			}
		}
		FreePPx();

		if ( hNextJobWnd != NULL ){
			DWORD_PTR sendresult = 0;

			SendMessageTimeout(hNextJobWnd, WM_COMMAND, IDM_CONTINUE, 0, SMTO_ABORTIFHUNG, 2000, &sendresult);
			if ( sendresult != (DWORD_PTR)IDM_CONTINUE ){
				// ss
				UsePPx();
				if ( Sm->Job[index].hWnd == hNextJobWnd ){  // C4701ok
					resetflag(Sm->Job[index].state.dw, JOBFLAG_WAITJOB);
				}
				FreePPx();
#if JOBLOG
				XMessage(NULL, NULL, XM_DbgLOG, T("hNextJobWnd[%d]: %x start fault"), index, hNextJobWnd);
#endif
				CheckJobList();
				continue; // ʂjob
			}
#if JOBLOG
			XMessage(NULL, NULL, XM_DbgLOG, T("hNextJobWnd[%d]: %x start ok"), index, hNextJobWnd);
#endif
		}
		break;
	}
}

int USEFASTCALL FindJobListIndex(int i)
{
	int index = 0, li;

	for ( ; ; ){
		li = (int)SendMessage(Sm->JobList.hWnd, LB_GETITEMDATA, (WPARAM)index, 0);
		if ( li < 0 ) return -1;
		if ( li == i ) return index;
		index++;
	}
}

void DeleteJobTaskMain(int i)
{
	int index;

	if ( Sm->JobList.hWnd == NULL ) return;

	index = FindJobListIndex(i);
	if ( index < 0 ) return;

	SendMessage(Sm->JobList.hWnd, LB_DELETESTRING, (WPARAM)index, 0);
	if ( (Sm->JobList.showmode != JOBLIST_INNER) &&
		 ((int)SendMessage(Sm->JobList.hWnd, LB_GETCOUNT, 0, 0) <= 0) ){
		ShowWindow(GetParent(Sm->JobList.hWnd), SW_HIDE);
	}
}

BOOL SetJobTask(HWND hWnd, DWORD state)
{
	DWORD i, challenge, ThreadID;

	TCHAR buf[JOBINFOTEXTSIZE];

#if JOBLOG
	int statetype;

	statetype = state & JOBFLAG_NAMEMASK;
	if ( statetype >= JOBSTATE_MAX ) statetype = JOBSTATE_UNDEFINED;


	if ( state & JOBFLAG_REG ){
		XMessage(NULL, NULL, XM_DbgLOG, T("Job [Reg,%s] wnd:%x thread:%d flag %x"), JobTypeNames[statetype], hWnd, GetCurrentThreadId(), (state >> 8));
	}else if ( state & JOBFLAG_UNREG ){
		XMessage(NULL, NULL, XM_DbgLOG, T("Job [Free,%s] wnd:%x thread:%d flag %x"), JobTypeNames[statetype], hWnd, GetCurrentThreadId(), (state >> 8));
	}else{
		XMessage(NULL, NULL, XM_DbgLOG, T("Job [change,%s] wnd:%x thread:%d flag %x"), JobTypeNames[statetype], hWnd, GetCurrentThreadId(), (state >> 8));
	}
#endif
	if ( ((state & JOBFLAG_STATEMASK) == JOBSTATE_SETRATE) &&
		 (Sm->JobList.hWnd == NULL) ){
		return FALSE;
	}

	ThreadID = GetCurrentThreadId();
	UsePPx();
	// ̓o^邩
	for ( i = 0 ; i < X_MaxJob ; i++ ){
		JobX *jxp = &Sm->Job[i];

		if ( (jxp->ThreadID != ThreadID) || (jxp->hWnd != hWnd) ) continue;

		if ( state & (JOBFLAG_REG | JOBFLAG_UNREG) ){
			if ( state & JOBFLAG_UNREG ){ // In
				if ( !(state & JOBFLAG_CHANGESTATE) ) jxp->state.b.count--;
				resetflag(jxp->state.dw, state);
				if ( jxp->state.b.count == 0 ){ // Q0Ȃ폜
					FreePPx();
#if JOBLOG
					XMessage(NULL, NULL, XM_DbgLOG, T("remove job %d %x"), i, jxp->hWnd);
#endif
					jxp->ThreadID = 0;
					DeleteJobTaskMain(i);
					return TRUE;
				}
			}else{	// o^n JOBFLAG_REG
				jxp->hWnd = hWnd;
				setflag(jxp->state.dw, state);
				if ( !(state & JOBFLAG_CHANGESTATE) ) jxp->state.b.count++;
			}
			FreePPx();
			if ( Sm->JobList.hWnd != NULL ){ // ꗗ̓eXV
				int index = FindJobListIndex(i);
				int listindex = (int)SendMessage(Sm->JobList.hWnd, LB_GETCURSEL, 0, 0);

				MakeJobInfoText(hWnd, jxp->state.dw, buf);
				if ( index >= 0 ){
					SendMessage(Sm->JobList.hWnd, LB_DELETESTRING, (WPARAM)index, 0);
				}
				AddJobListStr(i, buf, index);
				if ( listindex == LB_ERR ) listindex = 0;
				SendMessage(Sm->JobList.hWnd, LB_SETCURSEL, listindex, 0);
				InvalidateRect(Sm->JobList.hWnd, NULL, TRUE);
			}
			return TRUE;
		}
		if ( (state & JOBFLAG_STATEMASK) == JOBFLAG_CHANGESTATE ){
			jxp->state.b.rate = (BYTE)state;
		}
		goto fin;
	}
	if ( !(state & JOBFLAG_REG) ){ // o^svȂ̂͂ŏI
		goto fin;
	}

	if ( X_jlst[0] < 0 ){
		X_jlst[0] = JOBLIST_OFF;
		GetCustData(T("X_jlst"), X_jlst, sizeof(X_jlst));
	}

	// VKo^ (xtȂ 30 b҂)
	for ( challenge = 30 * (1000 / 100) ; challenge ; challenge-- ){
		for ( i = 0 ; i < X_MaxJob ; i++ ){
			if ( Sm->Job[i].ThreadID != 0 ) continue;
#if JOBLOG
			XMessage(NULL, NULL, XM_DbgLOG, T("Store job %d %x"), i, hWnd);
#endif
			Sm->Job[i].ThreadID = ThreadID;
			Sm->Job[i].hWnd = hWnd;
			Sm->Job[i].state.dw = (state & JOBFLAG_CHANGESTATE) ? state :
					(state | 0x1000000); // JEg+1

			FreePPx();
			if ( Sm->JobList.hWnd == NULL ){
				if ( X_jlst[0] != JOBLIST_OFF ){
					Sm->JobList.showmode = 0;
					CreateJobListWnd();
				}
			}else{
				MakeJobInfoText(hWnd, state, buf);
				AddJobListStr(i, buf, -1);
				ShowJobListWnd(hWnd);
			}
			return TRUE;
		}
		CheckJobList();
		Sleep(100);
	}
	// o^łȂǗΏۊOƂĎs
fin:
	FreePPx();
	if ( Sm->JobList.hWnd != NULL ){
		InvalidateRect(Sm->JobList.hWnd, NULL, FALSE);
	}
	return FALSE;
}

void DeleteJobTask(void)
{
	int i;
	DWORD ThreadID;

	UsePPx();
	ThreadID = GetCurrentThreadId();
	for ( i = 0 ; i < X_MaxJob ; i++ ){
		if ( Sm->Job[i].ThreadID == ThreadID ){
#if JOBLOG
			XMessage(NULL, NULL, XM_DbgLOG, T("Job [Delete] wnd:%x thread:%d state %x"), Sm->Job[i].hWnd, Sm->Job[i].ThreadID, Sm->Job[i].state);
#endif
			Sm->Job[i].ThreadID = 0;
			DeleteJobTaskMain(i);
			goto fin;
		}
	}
fin:
	FreePPx();
	StartNextJobTask();
}

BOOL CheckJobWait(void)
{
	int i;

	if ( DOpenThread == INVALID_HANDLE_VALUE ){
		GETDLLPROC(hKernel32, OpenThread);
	}
	UsePPx();
	for ( i = 0 ; i < X_MaxJob ; i++ ){
		if ( Sm->Job[i].ThreadID == 0 ) continue; // o^
		if ( !(Sm->Job[i].state.dw & JOBFLAG_ENABLEWAIT) ){
			continue; // ҋ@ΏۊO
		}
		if ( Sm->Job[i].ThreadID == GetCurrentThreadId() ){
			continue; // g͑ΏۊO
		}
		if ( DOpenThread != NULL ){ // LȃXbhmF
			HANDLE hThread;

			hThread = DOpenThread(
					STANDARD_RIGHTS_REQUIRED | THREAD_TERMINATE,
					FALSE, Sm->Job[i].ThreadID);
			if ( hThread != NULL ){ // Xbh͗L
				CloseHandle(hThread);
			}else{ // XbhȂ̂Ŕj
				Sm->Job[i].ThreadID = 0;
				continue;
			}
		}
		if ( Sm->Job[i].state.dw & JOBFLAG_WAITJOB ){
			continue; // ҋ@Ȃ̂ŎsĂȂ
		}

		FreePPx();
#if JOBLOG
		XMessage(NULL,NULL,XM_DbgLOG,T("CheckJobWait - eq wait"));
#endif
		return TRUE; // ŝŁAmI
	}
	FreePPx();
#if JOBLOG
	XMessage(NULL,NULL,XM_DbgLOG,T("CheckJobWait - no job"));
#endif
	return FALSE; // ŝ̂͂Ȃ
}

BOOL JobListMenu(EXECSTRUCT *Z, TCHAR param) // *job
{
	int i = 0;

	if ( param == 's' ){ // start
		SetJobTask(Z->hWnd, JOBSTATE_STARTJOB | JOBSTATE_NORMAL);
		return TRUE;
	}

	if ( param == 'e' ){ // end
		SetJobTask(Z->hWnd, JOBSTATE_UNREGIST);
		return TRUE;
	}

	// ꗗ\ / cancel / last
	if ( param != '\0' ){ // Job ݂ĂȂȂI
		for ( ; i < X_MaxJob ; i++ ){
			if ( Sm->Job[i].ThreadID ) break;
		}
		if ( i == X_MaxJob ) return TRUE; // ݂Ȃ...㑱\
	}

	if ( param == 'l' ){ // last
		if ( (Sm->JobList.hWnd != NULL) && IsTrue(IsWindow(Sm->JobList.hWnd)) ){
			int listindex = (int)SendMessage(Sm->JobList.hWnd, LB_GETCOUNT, 0, 0);

			if ( listindex <= 0 ) return TRUE; // Y
			JobListSelect(Sm->JobList.hWnd, listindex - 1, JOBSELECTMODE_CLOSE);
		}else{
			HWND hTargetWnd;
			int state, li = i;

			for ( ; i < X_MaxJob ; i++ ){
				if ( Sm->Job[i].ThreadID ) li = i;
			}

			UsePPx();
			hTargetWnd = Sm->Job[li].hWnd;
			state = Sm->Job[li].state.dw;
			FreePPx();

			if ( hTargetWnd != NULL ){
				if ( state & JOBFLAG_ENABLEHIDE ){
					SendMessage(hTargetWnd, WM_COMMAND, IDCANCEL, 0);
				}else{
					PostMessage(hTargetWnd, WM_KEYDOWN, VK_PAUSE, 0);
				}
			}else{
				keybd_event(VK_PAUSE, 0, 0, 0);
				keybd_event(VK_PAUSE, 0, KEYEVENTF_KEYUP, 0);
			}
		}
		return TRUE;
	}

	if ( ConsoleMode == ConsoleMode_ConsoleOnly ){
		PrintToConsole(T("** joblist not support on console **\r\n"));
		return FALSE;
	}

	// ꗗ\
	jobselectmode = (param != '\0') ? JOBSELECTMODE_PAUSE : JOBSELECTMODE_FOCUS;
	if ( (Sm->JobList.hWnd != NULL) && IsTrue(IsWindow(Sm->JobList.hWnd)) ){
		ShowJobListWnd(Z->hWnd);
	}else{
		Sm->JobList.showmode = 0;
		CreateJobListWnd();
	}

	// ꗗ̕\҂
	for ( i = 0 ; i < 60 ; i ++ ){
		if ( Sm->JobList.hWnd != NULL ) {
			SetForegroundWindow(Sm->JobList.hWnd);
			SetFocus(Sm->JobList.hWnd);
			if ( SendMessage(Sm->JobList.hWnd, LB_GETCURSEL, 0, 0) == LB_ERR ){
				SendMessage(Sm->JobList.hWnd, LB_SETCURSEL, 0, 0);
			}
			return TRUE; // ꗗ\ɐ
		}
		Sleep(50);
	}
	return FALSE; // ꗗ\Ɏs...R}h㑱I
}
