/*-----------------------------------------------------------------------------
	Paper Plane xUI	 commom library			gGfBbg GfB^nR}h
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#define ONPPXDLL		// PPCOMMON.H  DLL `w
#include "PPX.H"
#include "VFS.H"
#include "PPD_DEF.H"
#include "PPD_EDL.H"
#pragma hdrstop

BOOL SjisToEUCjp(char **text, DWORD *size)
{
	BYTE *ptr, *maxptr;
	BYTE *bottom, *top;
	DWORD maxsize;

	maxptr = (BYTE *)(*text + *size);
	maxsize = *size + ThSTEP;
	top = bottom = HeapAlloc(DLLheap, 0, maxsize);
	if ( bottom == NULL ) return FALSE;
	ptr = (BYTE *)*text;
	while ( ptr < maxptr ){
		WORD code1;

		if ( (top + 0x8) > (bottom + maxsize) ){
			BYTE *newbottom;

			maxsize += ThNextAllocSizeM(maxsize);
			newbottom = HeapReAlloc(DLLheap, 0, bottom, maxsize);
			if ( newbottom == NULL ) break;
#pragma warning(suppress:6001) // TCYvẐ݂Ɏgp
			top = newbottom + (top - bottom);
			bottom = newbottom;
		}
		code1 = *ptr++;

		if ( code1 < 0x80 ){
			*top++ = (BYTE)code1;
			continue;
		}
		if ( IskanjiA(code1) ){
			BYTE code2;

			code2 = *ptr++;
			if ( code2 >= 0x9f ){
				code1 = (BYTE)(code1 * 2 - (code1 >= 0xe0 ? 0xe0 : 0x60));
				code2 += (BYTE)2;
			}else if (code2){
				code1 = (BYTE)(code1 * 2 - (code1 >= 0xe0 ? 0xe1 : 0x61));
				code2 += (BYTE)(0x60 + (code2 < 0x7f));
			}
			*top++ = (BYTE)code1;
			*top++ = (BYTE)code2;
		}else{
			*top++ = (BYTE)0x8e;
			*top++ = (BYTE)code1;
		}
	}
	HeapFree(ProcHeap, 0, *text);
	*text = (char *)bottom;
	*size = top - bottom;
	return TRUE;
}

void InitEditCharCode(PPxEDSTRUCT *PES)
{
	if ( PES->CharCP != 0 ) return;
	PES->CharCP = VTYPE_SYSTEMCP;
	GetCustData(T("X_newcp"), &PES->CharCP, sizeof(DWORD));
}

/*-----------------------------------------------------------------------------
	result	FALSE:cancel
-----------------------------------------------------------------------------*/
BOOL FileSave(PPxEDSTRUCT *PES, int mode)
{
	TCHAR filename[VFPS], newname[VFPS], savedir[VFPS];
	BOOL result = FALSE;

	InitEditCharCode(PES);

	savedir[0] = '\0';
	GetCustTable(StrCustOthers, T("SaveDir"), &savedir, sizeof(savedir));
	if ( savedir[0] == '\0' ){
		VFSGetRealPath(NULL, savedir, T("#5:\\"));
	}else if ( VFSGetDriveType(savedir, NULL, NULL) == NULL ){
		VFSFullPath(NULL, savedir, NULL);
	}

	ThGetString(&PES->LocalStringValue, LSV_filename, filename, VFPS);
	if ( filename[0] != '\0' ){
		VFSFullPath(newname, filename, savedir);
	}else{
		newname[0] = '\0';
		if ( PES->flags & PPXEDIT_TEXTEDIT ){
			GetWindowText(GetParentCaptionWindow(PES->hWnd), newname, TSIZEOF(newname));
		}
		if ( newname[0] <= ' ' ){
			GetCustTable(StrCustOthers, T("NewFile"), newname, TSTROFF(VFPS));
			if ( newname[0] != '\0' ){
				tstrcat(newname, T(".txt"));
				PP_ExtractMacro(PES->hWnd, NULL, NULL, newname, newname, XEO_EXTRACTEXEC);
			}
			if ( newname[0] <= ' ' ){
				tstrcpy(newname, T("edittext.txt"));
			}
			VFSFullPath(NULL, newname, savedir);
			GetUniqueEntryName(newname);
		}else{
			VFSFullPath(NULL, newname, savedir);
		}
	}

	while ( (!(mode & EDL_FILEMODE_DIALOG) &&
			  (mode & EDL_FILEMODE_NODIALOG) &&
			  (filename[0] != '\0') ) ||
			( tInput(PES->hWnd, (mode & EDL_FILEMODE_APPEND) ?
					MES_TAPN : MES_TSVN, newname, TSIZEOF(newname),
					PPXH_NAME_R, PPXH_PATH) > 0) ){
		HANDLE hFile;
		DWORD size;
		char *text;

		VFSFixPath(NULL, newname, savedir, VFSFIX_PATH);
		if ( !(mode & EDL_FILEMODE_APPEND) && tstricmp(newname, filename) ){
			hFile = CreateFileL(newname, GENERIC_READ,
					FILE_SHARE_WRITE | FILE_SHARE_READ, NULL,
					OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			if ( hFile != INVALID_HANDLE_VALUE ){	// t@C
				CloseHandle(hFile);
				if ( PMessageBox(PES->hWnd, MES_QSAM, T("File exist"),
							MB_APPLMODAL | MB_OKCANCEL |
							MB_DEFBUTTON1 | MB_ICONQUESTION) != IDOK ){
					resetflag(mode, EDL_FILEMODE_NODIALOG);
					continue;
				}
			}
		}
		hFile = CreateFileL(newname, GENERIC_WRITE,
				FILE_SHARE_WRITE | FILE_SHARE_READ, NULL,
				(mode & EDL_FILEMODE_APPEND) ? OPEN_ALWAYS : CREATE_ALWAYS,
				FILE_FLAG_SEQUENTIAL_SCAN, NULL);
		if ( hFile == INVALID_HANDLE_VALUE ){
			ErrorPathBox(PES->hWnd, T("File open error"), newname, PPERROR_GETLASTERROR);
			resetflag(mode, EDL_FILEMODE_NODIALOG);
			continue;
		}
		tstrcpy(filename, newname);
		ThSetString(&PES->LocalStringValue, LSV_filename, newname);

										// ݏ(eR[hϊ)
		#ifdef UNICODE	// UNICODEł͌ʂɏ
		if ( (PES->CharCP == VTYPE_UTF8) ||
			 (PES->CharCP == CP_UTF8) ||
			 (PES->CharCP == VTYPE_UNICODE) ||
			 (PES->CharCP == CP__UTF16L) ||
			 (PES->CharCP == VTYPE_UNICODEB) ||
			 (PES->CharCP == CP__UTF16B) ){
			int offset;

			size = GetWindowTextLengthW(PES->hWnd) + 1; // BOMZ
			text = HeapAlloc(ProcHeap, 0, TSTROFF(size + 1)); // '\0'Z
			if ( text == NULL ){
				ErrorPathBox(PES->hWnd, T("File write error"), newname, PPERROR_GETLASTERROR);
				return FALSE;
			}
			// BOM Ȃ
			if ( (PES->CharCP == CP_UTF8) ||
				 (PES->CharCP == CP__UTF16L) ||
				 (PES->CharCP == CP__UTF16B) ){
				offset = 0;
				size--; // BOM
			}else{ // VTYPE_UNICODE / VTYPE_UNICODEB / VTYPE_UTF8  BOM 
				*(WCHAR *)text = 0xfeff; // UCF2HEADER
				offset = 1;
			}

			GetWindowTextW(PES->hWnd, (WCHAR *)text + offset, size + 1);

			if ( PES->CrCode != VTYPE_CRLF ){
				WCHAR *src, *dst;
				WCHAR crcode;

				crcode = (WCHAR)((PES->CrCode == VTYPE_CR) ? '\r' : '\n');
				src = dst = (WCHAR *)text + 1;
				while ( *src ){
					if ( *src == '\r' ){
						src += 2; // '\r\n' 
						*dst++ = crcode;
						continue;
					}
					*dst++ = *src++;
				}
				size = dst - (WCHAR *)text;
			}
			// CP_UTF8 / VTYPE_UTF8 UCS-2  UTF-8 ϊ
			if ( (PES->CharCP == CP_UTF8) || (PES->CharCP == VTYPE_UTF8) ){
				int newsize;
				char *newtext;

				newsize = WideCharToMultiByteU8(CP_UTF8, 0, (WCHAR *)text, size, NULL, 0, NULL, NULL);
				newtext = HeapAlloc(ProcHeap, 0, newsize);
				if ( newtext == NULL ){
					HeapFree(ProcHeap, 0, text);
					ErrorPathBox(PES->hWnd, T("File write error"), newname, PPERROR_GETLASTERROR);
					return FALSE;
				}
				size = WideCharToMultiByteU8(CP_UTF8, 0, (WCHAR *)text, size, newtext, newsize, NULL, NULL);
				HeapFree(ProcHeap, 0, text);
				text = newtext;
			}else{ // CP__UTF16L / VTYPE_UNICODE / CP__UTF16B / VTYPE_UNICODEB
				size *= sizeof(WCHAR);
				if ( (PES->CharCP == VTYPE_UNICODEB) || (PES->CharCP == CP__UTF16B) ){
					// oCgI[_ϊ
					WCHAR *uptr;
					uptr = (WCHAR *)text;
					while ( *uptr ){
						WCHAR lc;

						lc = *uptr;
						*uptr++ = (WCHAR)((lc >> 8) | (lc << 8));
					}
				}
			}
		}else{
			if ( PES->CharCP == VTYPE_SYSTEMCP ){
				size = GetWindowTextLengthA(PES->hWnd);
				text = HeapAlloc(ProcHeap, 0, size + 1);
				if ( text == NULL ){
					ErrorPathBox(PES->hWnd, T("File write error"), newname, PPERROR_GETLASTERROR);
					return FALSE;
				}
				GetWindowTextA(PES->hWnd, text, size + 1);
			}else{
				UINT cp;
				int sizeW;
				WCHAR *textW;

				cp = (PES->CharCP < VTypeToCPlist_max) ? VTypeToCPlist[PES->CharCP] : PES->CharCP;
				sizeW = GetWindowTextLengthW(PES->hWnd) + 1; // '\0'Z
				textW = HeapAlloc(ProcHeap, 0, TSTROFF(sizeW));
				if ( textW == NULL ){
					ErrorPathBox(PES->hWnd, T("File write error"), newname, PPERROR_GETLASTERROR);
					return FALSE;
				}
				GetWindowTextW(PES->hWnd, textW, sizeW);

				size = WideCharToMultiByteU8(cp, 0, textW, sizeW, NULL, 0, NULL, NULL);
				text = HeapAlloc(ProcHeap, 0, size);
				if ( text == NULL ){
					HeapFree(ProcHeap, 0, textW);
					ErrorPathBox(PES->hWnd, T("File write error"), newname, PPERROR_GETLASTERROR);
					return FALSE;
				}
				WideCharToMultiByteU8(cp, 0, textW, sizeW, text, size, NULL, NULL);
				if ( size > 0 ) size--; // '\0'
				HeapFree(ProcHeap, 0, textW);
			}

			if ( PES->CrCode != VTYPE_CRLF ){
				char *src, *dst;
				char crcode;

				crcode = (char)((PES->CrCode == VTYPE_CR) ? '\r' : '\n');
				src = dst = text;
				while ( *src ){
					if ( *src == '\r' ){
						src += 2;
						*dst++ = crcode;
						continue;
					}
					*dst++ = *src++;
				}
				size = dst - text;
			}
		}
		#else	// ANSIł́AUNICODȄꍇAx܂Ƃ߂ď
		size = GetWindowTextLength(PES->hWnd);
		text = HeapAlloc(ProcHeap, 0, size + 1);
		if ( text == NULL ){
			ErrorPathBox(PES->hWnd, T("File write error"), newname, PPERROR_GETLASTERROR);
			return FALSE;
		}
		GetWindowText(PES->hWnd, text, size + 1);
		if ( PES->CrCode != VTYPE_CRLF ){
			char *src, *dst;
			char crcode;

			crcode = (char)((PES->CrCode == VTYPE_CR) ? '\r' : '\n');
			src = dst = text;
			while ( *src ){
				if ( *src == '\r' ){
					src += 2;
					*dst++ = crcode;
					continue;
				}
				*dst++ = *src++;
			}
			size = dst - text;
		}
		if ( PES->CharCP != VTYPE_SYSTEMCP ){
			UINT cp;
			WCHAR *newtext;

			cp = (PES->CharCP < VTypeToCPlist_max) ? VTypeToCPlist[PES->CharCP] : PES->CharCP;
			// U UNICODE 
			size = MultiByteToWideChar(CP_ACP, 0, text, -1, NULL, 0);
			newtext = HeapAlloc(ProcHeap, 0, size * sizeof(WCHAR));
			if ( newtext != NULL ){
				int offset;

				if ( (PES->CharCP == VTYPE_UTF8) ||
					 (PES->CharCP == VTYPE_UNICODE) ||
					 (PES->CharCP == VTYPE_UNICODEB) ){
					*newtext = 0xfeff; // UCF2HEADER
					offset = 1;
				}else{
					offset = 0;
				}
				size = MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED,
						text, -1, newtext + offset, size) + offset;
				HeapFree(ProcHeap, 0, text);
				text = (char *)newtext;
				if ( size ) size--; // '\0'
			}
			if ( (cp == CP__UTF16L) || (cp == CP__UTF16B) ){ // UNICODE ̎́Â܂
				if ( cp == CP__UTF16B ){ // oCgI[_ϊ
					WCHAR *uptr;
					DWORD left;
					uptr = (WCHAR *)text;
					left = size;
					while ( left-- ){
						WCHAR lc;

						lc = *uptr;
						*uptr++ = (WCHAR)((lc >> 8) | (lc << 8));
					}
				}
				size *= sizeof(WCHAR);
			}else{ // UNICODE Y codepage 
				int newsize;
				char *newtext;

				newsize = WideCharToMultiByteU8(cp, 0, (WCHAR *)text, size, NULL, 0, NULL, NULL);
				newtext = HeapAlloc(ProcHeap, 0, newsize);
				if ( newtext == NULL ){
					HeapFree(ProcHeap, 0, text);
					ErrorPathBox(PES->hWnd, T("File write error"), newname, PPERROR_GETLASTERROR);
					return FALSE;
				}
				size = WideCharToMultiByteU8(cp, 0, (WCHAR *)text, size, newtext, newsize, NULL, NULL);
				HeapFree(ProcHeap, 0, text);
				text = newtext;
			}
		}
		#endif
		if ( PES->CharCP == VTYPE_EUCJP ) SjisToEUCjp(&text, &size);
										// 
		if ( mode & EDL_FILEMODE_APPEND ){
			DWORD i = 0;

			SetFilePointer(hFile, 0, (PLONG)&i, FILE_END);
		}
		if ( WriteFile(hFile, text, size, (DWORD *)&size, NULL) == FALSE ){
			ErrorPathBox(PES->hWnd, T("File write error"), newname, PPERROR_GETLASTERROR);
		}else{
			result = TRUE;
			XEditClearModify(PES);
		}
		CloseHandle(hFile);

		HeapFree(ProcHeap, 0, text);
		if ( PES->flags & PPXEDIT_TEXTEDIT ){
			SetWindowText(GetParentCaptionWindow(PES->hWnd), newname);
		}
		if ( IsTrue(result) ) break;
	}
	return result;
}

void OpenMainFromMem(PPxEDSTRUCT *PES, int openmode, const TCHAR *filename, const TCHAR *textimage, DWORD memsize, UINT usecp)
{
	int crcode = VTYPE_CRLF, charcode;
	TCHAR *text;

	charcode = FixTextFileImage(filename, (const char *)textimage, memsize, &text, usecp);
	{									// sR[ȟ
		int size;
		TCHAR *ptr;

		for ( ptr = text, size = 0x1000 ; *ptr && size ; ptr++, size-- ){
			if ( *ptr == '\r' ){ // CR
				if ( *(ptr + 1) == '\n' ){ // LF
					break;	// CRLF
				}
				crcode = VTYPE_CR;
				break;
			}else if ( *ptr == '\n' ){ // LF
				crcode = VTYPE_LF;
				break;
			}
		}
	}
	if ( openmode != PPE_OPEN_MODE_INSERT ){
		PES->CharCP = (charcode >= 0) ? charcode : -charcode;
		PES->CrCode = crcode;
		if ( filename != NULL ){
			ThSetString(&PES->LocalStringValue, LSV_filename, filename);
			if ( PES->flags & PPXEDIT_TEXTEDIT ){
				SetWindowText(GetParentCaptionWindow(PES->hWnd), filename);
			}
		}
	}
										// sR[hɍ킹 SetText
	if ( crcode != VTYPE_CRLF ){
		TCHAR *p, code;

		if ( openmode != PPE_OPEN_MODE_INSERT ){ // ㏑
			SendMessage(PES->hWnd, EM_SETSEL, 0, EC_LAST);
		}
		p = text;
		code = (TCHAR)((crcode == VTYPE_CR) ? T('\r') : T('\n'));
		while ( *p != '\0' ){
			TCHAR *next;

			next = tstrchr(p, code);
			if ( next == NULL ){
				SendMessage(PES->hWnd, EM_REPLACESEL, 0, (LPARAM)p);
				break;
			}else{
				*next = '\0';
				SendMessage(PES->hWnd, EM_REPLACESEL, 0, (LPARAM)p);
				SendMessage(PES->hWnd, EM_SETSEL, EC_LAST, EC_LAST);
				SendMessage(PES->hWnd, EM_REPLACESEL, 0, (LPARAM)T("\r\n"));
				SendMessage(PES->hWnd, EM_SETSEL, EC_LAST, EC_LAST);
				p = next + 1;
			}
		}
		SendMessage(PES->hWnd, EM_SETSEL, EC_LAST, EC_LAST);
	}else{
		if ( openmode != PPE_OPEN_MODE_INSERT ){ // ㏑
			SetWindowText(PES->hWnd, text);
		}else{
			SendMessage(PES->hWnd, EM_REPLACESEL, 0, (LPARAM)text);
		}
	}
	if ( charcode < 0 ) HeapFree(DLLheap, 0, text);
}

void PPeWindowSizeFix(HWND hParentWnd, int changesize) // EBhETCY
{
	if ( hParentWnd == NULL ) return;

	if ( changesize == PPE_OPEN_MODE_EXCMDOPENnoSIZE ){
		MoveWindowByKey(hParentWnd, 0, 0);
	}else{ // PPE_OPEN_MODE_EXCMDOPENandSIZE
		FixEditWindowRect(hParentWnd);
	}
}

/*-----------------------------------------------------------------------------
	t@CJ
-----------------------------------------------------------------------------*/
BOOL OpenFromFile(PPxEDSTRUCT *PES, int openmode, const TCHAR *fname)
{
	BOOL newmode = FALSE;
	int changesize = 0;
	DWORD memsize;
	TCHAR filename[VFPS];
	TCHAR oldfilename[VFPS];
	TCHAR *textimage = NULL;
	EDITMODESTRUCT ems = { EDITMODESTRUCT_DEFAULT };

	const TCHAR *exec = NULL, *curdir = NULL;

	TCHAR buf[CMDLINESIZE], code, *more;

	ThGetString(&PES->LocalStringValue, LSV_filename, oldfilename, VFPS);

	if ( openmode >= PPE_OPEN_MODE_CMDOPEN ){

		if ( openmode >= PPE_OPEN_MODE_EXCMDOPEN ){
			curdir = ((PPE_CMDMODEDATA *)fname)->curdir;
			fname = ((PPE_CMDMODEDATA *)fname)->param;
			changesize = openmode;
			openmode = PPE_OPEN_MODE_OPENNEW;
		}else{
			openmode -= PPE_OPEN_MODE_CMDOPEN; // CMDxxx  xxx ɕϊ
		}

		filename[0] = '\0';
		for ( ;; ){
			code = GetOptionParameter(&fname, buf, &more);
			if ( code == '\0' ) break;
			if ( code != '-' ){
				if ( (curdir != NULL) || (oldfilename[0] == '\0') ){
					VFSFixPath(filename, buf, curdir, VFSFIX_FULLPATH | VFSFIX_REALPATH);
				}else{
					// JgfBNg𐶐
					VFSFullPath(filename, T(".."), oldfilename);
					VFSFixPath(filename, buf, filename, VFSFIX_FULLPATH | VFSFIX_REALPATH);
				}
			}else{
				if ( tstrcmp(buf + 1, T("NEW")) == 0 ){
					newmode = TRUE;
				}else if ( tstrcmp(buf + 1, T("K")) == 0 ){
					exec = fname;
					break;
				}else if ( EditModeParam(&ems, buf + 1, more) == FALSE ){
					XMessage(PES->hWnd, T("File open error"), XM_GrERRld, MES_EUOP, buf);
				}
			}
			NextParameter(&fname);
		}
	}else{
		tstrcpy(filename, fname);
	}
	if ( filename[0] != '\0' ){	// t@C̓ǂݍ
		ERRORCODE result;

		result = VFSLoadFileImage(filename, 0x40, (char **)&textimage, &memsize, NULL);
		if ( result != NO_ERROR ){
			if ( newmode == FALSE ){
				HWND hParentWnd;

				if ( oldfilename[0] == '\0' ){
					ThSetString(&PES->LocalStringValue, LSV_filename, filename);
					// ݒ菉1
					PPeSetTab(PES, ems.tabwidth);
					if ( ems.crcode >= 0 ) PES->CrCode = ems.crcode;
				}
				hParentWnd = GetParent(PES->hWnd);
				if ( changesize != 0 ){ // EBhETCY
					PPeWindowSizeFix(hParentWnd, changesize);
				}

				if ( openmode >= 0 ){ // PPE_OPEN_MODE_OPEN / PPE_OPEN_MODE_INSERT
					ErrorPathBox(PES->hWnd, NULL, filename, result);
				}else{ // PPE_OPEN_MODE_OPENNEW
					if ( hParentWnd != NULL ){
						SetWindowText(hParentWnd, filename);
					}
				}
				if ( hParentWnd != NULL ){
					SetMessageOnCaption(hParentWnd, MES_EOFI);
				}

				if ( exec != NULL ) EditExtractMacro(PES, exec, NULL, 0);
				return FALSE;
			}
		}
	}
	if ( (textimage == NULL) && (openmode != PPE_OPEN_MODE_INSERT) ){
		textimage = HeapAlloc(ProcHeap, HEAP_ZERO_MEMORY, 4);
		memsize = 4;
	}
	SendMessage(PES->hWnd, WM_SETREDRAW, FALSE, 0);
										// R[hʁϊ
	if ( textimage != NULL ){
		OpenMainFromMem(PES, openmode, filename, textimage, memsize, ems.codepage);
		HeapFree(ProcHeap, 0, textimage);
	}
	// ݒ菉2
	PPeSetTab(PES, ems.tabwidth);
	if ( ems.crcode >= 0 ) PES->CrCode = ems.crcode;

	if ( changesize != 0 ){ // EBhETCY
		PPeWindowSizeFix(GetParent(PES->hWnd), changesize);
	}

	SendMessage(PES->hWnd, EM_SCROLLCARET, 0, 0);
	if ( openmode == PPE_OPEN_MODE_INSERT ){
		XEditSetModify(PES);
	}else{
		XEditClearModify(PES);
	}

	SendMessage(PES->hWnd, WM_SETREDRAW, TRUE, 0);
	InvalidateRect(PES->hWnd, NULL, TRUE);

	SendMessage(PES->hWnd, WM_PPXCOMMAND, K_E_LOAD, 0);

	if ( exec != NULL ) EditExtractMacro(PES, exec, NULL, 0);
	return TRUE;
}


void FileOpen(PPxEDSTRUCT *PES, int mode)
{
	TCHAR name[VFPS], curdir[VFPS];

	name[0] = '\0';
	ThGetString(&PES->LocalStringValue, LSV_filename, name, VFPS);
	VFSFullPath(curdir, T(".."), name);
	if ( tInput(PES->hWnd,
			(mode == 0) ? T("Open Filename") : T("Insert Filename"),
			name, TSIZEOF(name), PPXH_NAME_R, PPXH_PATH) > 0 ){
		VFSFixPath(NULL, name, curdir, VFSFIX_FULLPATH);
		OpenFromFile(PES, mode, name);
	}
}

// wsփWv -----------------------------------------------------------
void JumptoLine(HWND hWnd, int line)
{
	DWORD wP, lP;
	int offset;

	SendMessage(hWnd, EM_GETSEL, (WPARAM)&wP, (WPARAM)&lP);
	offset = SendMessage(hWnd, EM_LINEINDEX, (WPARAM)-1, 0);
	wP -= offset;
	offset = SendMessage(hWnd, EM_LINEINDEX, (WPARAM)line, 0);
	if ( offset != -1 ){
		lP = SendMessage(hWnd, EM_LINELENGTH, (WPARAM)line, 0);
		if ( wP > lP ) wP = lP;
		wP += offset;
		SendMessage(hWnd, EM_SETSEL, wP, wP);
		SendMessage(hWnd, EM_SCROLLCARET, 0, 0);
	}
}
