/*-----------------------------------------------------------------------------
	Paper Plane cUI												SubThread

	celltmp ́ARs[ς(XbhZ[t) ENTRYCELL
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include <commctrl.h>
#include <shlobj.h>

#include "PPX.H"
#include "VFS.H"
#include "PPCUI.RH"
#include "PPC_STRU.H"
#include "PPC_FUNC.H"
#include "PPC_DD.H"
#include "PPCOMBO.H"
#include "PPC_SUBT.H"
#pragma hdrstop

void USEFASTCALL GetDirSizeCache(PPC_APPINFO *cinfo);
void GetColumnExtData(PPC_APPINFO *cinfo);
void USEFASTCALL FixThreads(PPC_APPINFO *cinfo, DWORD ThreadID);

typedef struct {
	struct {
		DWORD ThreadID; // mF̃XbhID
		DWORD Count;	// mFҋ@
	} FOPcheck;
	struct {
		int UpdateWaitCount;	// fBNg̍XVJn^C}
		int ForceUpdateCount;	// AoĂƂAJn邽߂̎
		DWORD detects;	// o
		DWORD firstTick;	// ovJn
	} DirCheck;
} SUBTHREADSTRUCT;

#if NODLL
#define DefineWinAPINoDLL(retvar, name, param) typedef retvar (WINAPI *imp ## name) param ; extern imp ## name D ## name
DefineWinAPINoDLL(HANDLE, OpenThread, (DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwThreadId));
#else
DefineWinAPI(HANDLE, OpenThread, (DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwThreadId)) = INVALID_VALUE(impOpenThread);
#endif
DefineWinAPI(BOOL, IsHungAppWindow, (HWND)) = INVALID_VALUE(impIsHungAppWindow);

const TCHAR SubThreadName[] = T("PPc sub");

//-----------------------------------------------------------------------------
void USEFASTCALL IObreak(PPC_APPINFO *cinfo)
{
	DWORD threadID = GetWindowThreadProcessId(cinfo->info.hWnd, NULL);
	HANDLE hThread;

	if ( (threadID == 0) || (DOpenThread == NULL) ) return;
	hThread = DOpenThread(STANDARD_RIGHTS_REQUIRED | THREAD_TERMINATE,
			FALSE, threadID);
	if ( hThread != NULL ){
		DefineWinAPI(BOOL, CancelSynchronousIo, (HANDLE hThread));

		GETDLLPROC(GetModuleHandle(StrKernel32DLL), CancelSynchronousIo);
		if ( DCancelSynchronousIo != NULL ){
			DCancelSynchronousIo(hThread);
		}
		CloseHandle(hThread);
	}
}

#ifndef _WIN64
#if !NODLL
DefineWinAPI(ULONG, SHChangeNotifyRegister, (HWND hwnd, int fSources, LONG fEvents, UINT wMsg, int cEntries, const SHChangeNotifyEntry *pshcne));
DefineWinAPI(BOOL, SHChangeNotifyDeregister, (unsigned long ulID));
DefineWinAPI(HANDLE, SHChangeNotification_Lock, (HANDLE hChange, DWORD dwProcId, LPITEMIDLIST **pppidl, LONG *plEvent));
DefineWinAPI(BOOL, SHChangeNotification_Unlock, (HANDLE hLock));

LOADWINAPISTRUCT SHChangeNotifyDLL[] = {
	LOADWINAPI1(SHChangeNotifyRegister),
	LOADWINAPI1(SHChangeNotifyDeregister),
	LOADWINAPI1(SHChangeNotification_Lock),
	LOADWINAPI1(SHChangeNotification_Unlock),
	{NULL, NULL}
};
#else
extern LOADWINAPISTRUCT SHChangeNotifyDLL[];
#endif
#endif

void SetShellChangeNotification(PPC_APPINFO *cinfo)
{
	SHChangeNotifyEntry req_entry;
	LPSHELLFOLDER pSF;

	#ifndef _WIN64
	if ( DSHChangeNotifyRegister == NULL ){
		LoadWinAPI("SHELL32.dll", NULL, SHChangeNotifyDLL, LOADWINAPI_GETMODULE);
	}
	if ( DSHChangeNotifyRegister == NULL ) return;
	#endif

	req_entry.pidl = NULL;
	pSF = VFPtoIShell(NULL, cinfo->path, (LPITEMIDLIST *)&req_entry.pidl);
	if ( pSF != NULL ){
		pSF->lpVtbl->Release(pSF);
		req_entry.fRecursive = FALSE;
		cinfo->ShNotifyID = DSHChangeNotifyRegister(cinfo->info.hWnd,
				SHCNRF_ShellLevel | SHCNRF_NewDelivery, // ς͕svAbZ[WMȂȂ̂ŕt^
				SHCNE_RENAMEITEM | SHCNE_CREATE | SHCNE_DELETE |
				SHCNE_MKDIR | SHCNE_RMDIR | SHCNE_UPDATEDIR |
				SHCNE_MEDIAINSERTED | SHCNE_MEDIAREMOVED |
				SHCNE_RENAMEFOLDER | SHCNE_DRIVEADD | SHCNE_DRIVEREMOVED,
				WM_PPCFOLDERCHANGE, 1, &req_entry);
		FreePIDL(req_entry.pidl);
	}
}

void USEFASTCALL StartReload(PPC_APPINFO *cinfo, int *UpdateWaitCount)
{
	cinfo->FDirWrite = FDW_SENDREQUEST;
	PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, K_SETGRAYSTATUS, 0);

	if ( cinfo->SlowMode == FALSE ){ // ᑬ[hłȂ΁AXV҂Ɉڍs
		*UpdateWaitCount = XC_rrt[
				(// (GetFocus() == cinfo->info.hWnd) || // ʃXbhȂ̂ŃtH[JXȂ
				 (GetForegroundWindow() == cinfo->info.hWnd)) ? 0 : 1];
		DEBUGLOGC("Subthred-UpdateWaitCount %d", *UpdateWaitCount);
	}
}

HWND hCancelWnd = NULL;

const TCHAR *FreezeTypes[FREEZE_TYPELAST] = { T("?"), T("read_entry"), T("CRMENU"), T("CRMENU_CELLLOOK"), T("CRMENU_SCMENU"), T("CRMENU_GetExtCommand") };


void USEFASTCALL IntervalSubThread(PPC_APPINFO *cinfo, SUBTHREADSTRUCT *sts)
{
	if ( OSver.dwMajorVersion >= 6 ){
		// Ԃ̌o
		if ( DIsHungAppWindow != NULL ){
			HWND hTargetWnd = cinfo->combo ? Combo.hWnd : cinfo->info.hWnd;
			if ( DIsHungAppWindow(hTargetWnd) == FALSE ){
				if ( hCancelWnd != NULL ){
					hCancelWnd = NULL;
				}
			}else{
				if ( hCancelWnd != hTargetWnd ){
					if ( cinfo->FreezeType < FREEZE_TYPELAST ){
						XMessage(NULL, NULL, XM_DbgLOG, T("Freeze %s: %s"),
							cinfo->RegCID, FreezeTypes[cinfo->FreezeType]);
					}else{
						XMessage(NULL, NULL, XM_DbgLOG, T("Freeze %s: key-%x"),
							cinfo->RegCID, cinfo->FreezeType);
					}
				}

				if ( hCancelWnd == NULL ){
					hCancelWnd = hTargetWnd;
				}
			}

		}
		// read_entry ̉o
		if ( cinfo->StateInfo.state != StateID_NoState ){
			DWORD tick = GetTickCount();
			if ( (tick - cinfo->StateInfo.tick) > 4000 ){
				int state = cinfo->StateInfo.state;

				cinfo->StateInfo.tick = tick;
				if ( state > StateID_MAX ) state = StateID_MAX;

				XMessage(NULL, NULL, XM_DbgLOG, T("ReadBUSY %s,readID:%d,%s"),
						cinfo->RegCID, cinfo->LoadCounter, StateText[state]);
			}
		}
	}

	// J[\EBhEOɂłƂɕ\XVKvȉӏ̏ -----------
	if ( (cinfo->HMpos >= 0) || (cinfo->e.cellPoint >= 0) ){
		POINT pos;
		int posType;

		GetCursorPos(&pos);
		ScreenToClient(cinfo->info.hWnd, &pos);
		posType = GetItemTypeFromPoint(cinfo, &pos, NULL);
		if ( (cinfo->e.cellPoint >= 0) &&
			 !( (posType == PPCR_CELLMARK) ||
			 	(posType == PPCR_CELLTEXT) ||
			 	(posType == PPCR_CELLTAIL) ) ){
			ENTRYINDEX oldn;

			oldn = cinfo->e.cellPoint;
			cinfo->e.cellPoint = -1;
			RefleshCell(cinfo, oldn);
			if ( cinfo->Tip.states & STIP_CMD_HOVER ){
				HideEntryTip(cinfo);
			}
		}
		if ( (cinfo->HMpos >= 0) && (posType != PPCR_HIDMENU) ){
			cinfo->HMpos = cinfo->DownHMpos = -1;
			InvalidateRect(cinfo->info.hWnd, &cinfo->BoxInfo, FALSE);	// XVw
		}
	}
	// PopMsg ̎ ------------------------------------------------------
	if ( cinfo->PopMsgTimer != 0 ){
		if ( --cinfo->PopMsgTimer == 0 ){
			StopPopMsg(cinfo, PMF_WAITTIMER);
		}
	}
	// fBNgXV̍ēǂݍݑ҂ -------------------------------------
	if ( cinfo->FDirWrite == FDW_REQUEST ){ // O[ς݂Ȃ̂ōXV
		if ( sts->DirCheck.UpdateWaitCount > 0 ){
			sts->DirCheck.UpdateWaitCount--;
		}
		if ( (sts->DirCheck.UpdateWaitCount <= 0) && !TinyCheckCellEdit(cinfo) ){
			DEBUGLOGC("Subthred-Reload Q", 0);
			cinfo->FDirWrite = FDW_REQUESTED;
			PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, K_raw | K_c | K_F5, 0);
		}
	}
	// ēǂݍ݂ɂāAǍ݊Jn܂łɂPbȏ]T
	if ( (cinfo->FDirWrite == FDW_WAITREQUEST) && !TinyCheckCellEdit(cinfo) ){
		DEBUGLOGC("Subthred-StartReload", 0);
		StartReload(cinfo, &sts->DirCheck.UpdateWaitCount);
	}
	// fileoperation thread ̃nOAbv`FbN(Win10O̎AWin11ł̓`FbNłȂ̂ōsȂ) ----------------------------
	if ( sts->FOPcheck.ThreadID == 0 ){ // ҋ@ΏۂT
		if ( cinfo->TerminateThreadID != 0 ){
			sts->FOPcheck.Count = 3;
			sts->FOPcheck.ThreadID = cinfo->TerminateThreadID;
			cinfo->TerminateThreadID = 0;
		}
	}else{ // mF
		if ( --sts->FOPcheck.Count == 0 ){
			FixThreads(cinfo, sts->FOPcheck.ThreadID);
			sts->FOPcheck.ThreadID = 0;
		}
	}
	// EBhEBĂ̂ɁATip 悤ƂĂꍇ͕
	if ( (cinfo->Tip.states & STIP_STATE_READYMASK) &&
		 !IsWindowVisible(cinfo->info.hWnd) ){
		EndEntryTip(cinfo);
	}
}

//-----------------------------------------------------------------------------
//	ʃXbh
//-----------------------------------------------------------------------------
THREADEXRET THREADEXCALL PPcSubThread(void *arglist)
{
	PPC_APPINFO *cinfo;
	SubThreadData ThreadData = {
		{{SubThreadName, XTHREAD_EXITENABLE | XTHREAD_RESTARTREQUEST, NULL, 0, 0}, NULL, K_THREADRESTART, 0}, // threeadinfo
		NULL // LayPtr
	};

	// SUBT_GETINFOICON
	HICON hInfoIcon = NULL;	//폜ׂACR

	// fBNgXV
	SUBTHREADSTRUCT sts;

	cinfo = (PPC_APPINFO *)arglist;
	PPcAppInfo_AddRef(cinfo);

	cinfo->SubThreadID = GetCurrentThreadId();
	ThreadData.threeadinfo.hParentWnd = cinfo->info.hWnd;
	PPxRegisterThread(&ThreadData.threeadinfo.threadinfo);

	(void)CoInitializeEx(NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE); // ACR擾Ɏgp
	PPxCommonExtCommand(K_IMEDISABLE, (WPARAM)0); // ̃XbhIME𖳌

	sts.FOPcheck.ThreadID = 0;
	sts.DirCheck.UpdateWaitCount = 0;
	sts.DirCheck.ForceUpdateCount = -1;

	if ( DOpenThread == INVALID_HANDLE_VALUE ){
		GETDLLPROC(GetModuleHandle(StrKernel32DLL), OpenThread);
	}
	if ( DIsHungAppWindow == INVALID_HANDLE_VALUE ){
		GETDLLPROC(GetModuleHandle(StrUser32DLL), IsHungAppWindow);
	}

	for ( ; ; ){
		DWORD result;

		result = WaitForMultipleObjects( (cinfo->SubT_dir != NULL) ?
					SubTs : SubTs - 1, cinfo->SubT, FALSE, 1000);
		ThreadData.threeadinfo.threadinfo.flag = (ThreadData.threeadinfo.threadinfo.flag & 0x7f) | ( (result & 0x1ff) << 7 ) | ((cinfo->SubTCmdFlags) << 16);
		switch (result){
			case WAIT_TIMEOUT:	// mF -----------------------------------
				IntervalSubThread(cinfo, &sts);
				continue;	// mFI

			case (WAIT_OBJECT_0 + 0):	// SubT_cmd wߔs ------------------
//			case (WAIT_ABANDONED_0 + 0):
				ResetEvent(cinfo->SubT_cmd);
										// I ===============================
				//  test byte [cinfo->SubTCmdFlags], SUBT_EXIT
				// je @@xxx
				// ̃R[hAs邱Ƃ悤
				// XbhsٗlɒxȂĂH
				//
				// _~[ B31 
				// test dword [cinfo->SubTCmdFlags], SUBT_EXIT or B31
				// Ƃ̂悢H
				if ( cinfo->SubTCmdFlags & SUBT_EXIT ){
//					resetflag(cinfo->SubTCmdFlags, SUBT_EXIT); p̂ŕsv
					CloseHandle(cinfo->SubT_cmd);
					if ( cinfo->SubT_dir != NULL ){
						FindCloseChangeNotification(cinfo->SubT_dir);
					}
					if ( cinfo->ShNotifyID != 0 ){
						DSHChangeNotifyDeregister(cinfo->ShNotifyID);
					}
					if ( hInfoIcon != NULL ) DestroyIcon(hInfoIcon);
					FreeOverlayClass(ThreadData.LayPtr);

					PPcAppInfo_Release(cinfo);
					PPxUnRegisterThread();
					CoUninitialize();
					t_endthreadex(0);
				}
										// s̃ACR擾 =======
				if ( cinfo->SubTCmdFlags & SUBT_GETINFOICON ){
					resetflag(cinfo->SubTCmdFlags, SUBT_GETINFOICON);
					DEBUGLOGC("Subthred-GETINFOICON start", 0);
#ifndef DEBUGICON
					GetInfoIcon(cinfo, &hInfoIcon, &ThreadData);
#endif
					DEBUGLOGC("Subthred-GETINFOICON end", 0);
				}
										// fBNgĎ~ ===========
				if ( cinfo->SubTCmdFlags & SUBT_STOPDIRCHECK ){
					DEBUGLOGC("Subthred-STOPDIRCHECK start", 0);
					resetflag(cinfo->SubTCmdFlags, SUBT_STOPDIRCHECK);
					sts.DirCheck.ForceUpdateCount = 0;
					if ( cinfo->SubT_dir != NULL ){
						FindCloseChangeNotification(cinfo->SubT_dir);
						cinfo->SubT_dir = NULL;
					}
					if ( cinfo->ShNotifyID != 0 ){
						DSHChangeNotifyDeregister(cinfo->ShNotifyID);
					}
					DEBUGLOGC("Subthred-STOPDIRCHECK end", 0);
				}
										// fBNgĎ ===========
				if ( cinfo->SubTCmdFlags & SUBT_INITDIRCHECK ){
					DEBUGLOGC("Subthred-DIRCHECK start", 0);
					resetflag(cinfo->SubTCmdFlags, SUBT_INITDIRCHECK);
					sts.DirCheck.ForceUpdateCount = -1;
					if ( cinfo->SubT_dir != NULL ){
						FindCloseChangeNotification(cinfo->SubT_dir);
					}
					if ( cinfo->ShNotifyID != 0 ){
						DSHChangeNotifyDeregister(cinfo->ShNotifyID);
					}
					if ( (cinfo->RealPath[0] == '?') ||
						((cinfo->e.Dtype.mode != VFSDT_PATH) &&
						 (cinfo->e.Dtype.mode != VFSDT_SHN)) ){
						cinfo->SubT_dir = NULL;
						if ( cinfo->e.Dtype.mode == VFSDT_SHN ){
							SetShellChangeNotification(cinfo);
						}
					}else{
						cinfo->SubT_dir = FindFirstChangeNotification(
							cinfo->RealPath, FALSE,
							FILE_NOTIFY_CHANGE_FILE_NAME |
							FILE_NOTIFY_CHANGE_DIR_NAME |
							FILE_NOTIFY_CHANGE_ATTRIBUTES |
							FILE_NOTIFY_CHANGE_SIZE |
							FILE_NOTIFY_CHANGE_LAST_WRITE);
						if ( cinfo->SubT_dir == INVALID_HANDLE_VALUE ){
							cinfo->SubT_dir = NULL;
						}
						sts.DirCheck.detects = 0;
						sts.DirCheck.firstTick = GetTickCount();
					}
					DEBUGLOGC("Subthred-DIRCHECK end", 0);
				}
										// Zɕ\ACR擾 =======
				if ( cinfo->SubTCmdFlags & SUBT_GETCELLICON ){
					resetflag(cinfo->SubTCmdFlags, SUBT_GETCELLICON);
#ifndef DEBUGICON
					DEBUGLOGC("Subthred-GETCELLICON start", 0);
					if ( cinfo->EntryIcons.hImage != NULL ){
						GetCellIcon(cinfo, &ThreadData);
						ThreadData.threeadinfo.threadinfo.ThreadName = SubThreadName;
					}
					DEBUGLOGC("Subthred-GETCELLICON end", 0);
#endif
				}
				// ԌoĂXV(UpdateEntryERROR_BUSYȂ̂ōĎs) ====
				if ( cinfo->SubTCmdFlags & SUBT_REQUESTRELOAD ){
					DEBUGLOGC("Subthred-REQUESTRELOAD", 0);
					resetflag(cinfo->SubTCmdFlags, SUBT_REQUESTRELOAD);
					if ( cinfo->FDirWrite == FDW_REQUESTED ){
						cinfo->FDirWrite = FDW_REQUEST;
						sts.DirCheck.UpdateWaitCount = XC_rrt[0]; // UpdateEntryς݂Ȃ̂ŒZ
					}
				}
										// fBNgTCỸLbV擾==
				if ( cinfo->SubTCmdFlags & SUBT_GETDIRSIZECACHE ){
					DEBUGLOGC("Subthred-SUBT_GETDIRSIZECACHE start", 0);
					resetflag(cinfo->SubTCmdFlags, SUBT_GETDIRSIZECACHE);
					GetDirSizeCache(cinfo);
					DEBUGLOGC("Subthred-SUBT_GETDIRSIZECACHE end", 0);
				}
										// Jge擾==================
				if ( cinfo->SubTCmdFlags & SUBT_GETCOLUMNEXT ){
					DEBUGLOGC("Subthred-SUBT_GETCOLUMNEXT start", 0);
					resetflag(cinfo->SubTCmdFlags, SUBT_GETCOLUMNEXT);
					GetColumnExtData(cinfo);
					DEBUGLOGC("Subthred-SUBT_GETCOLUMNEXT end", 0);
				}
										// 󂫗eʎ擾 =================
				if ( cinfo->SubTCmdFlags & SUBT_GETFREESPACE ){
					resetflag(cinfo->SubTCmdFlags, SUBT_GETFREESPACE);
					GetDirectoryFreeSpace(cinfo, TRUE);
				}
										// VFɂύXʒm ===============
				if ( cinfo->SubTCmdFlags & SUBT_FOLDERCHANGE ){
					resetflag(cinfo->SubTCmdFlags, SUBT_FOLDERCHANGE);
					if ( cinfo->FDirWrite == FDW_NORMAL ){ // ܂ȍ
						if ( !TinyCheckCellEdit(cinfo) ){
							StartReload(cinfo, &sts.DirCheck.UpdateWaitCount); // ɃO[
						}else{ // O[ҋ@
							cinfo->FDirWrite = FDW_WAITREQUEST;
						}
					}
				}
				continue;

			case (WAIT_OBJECT_0 + 1): {	// SubT_dir fBNg݊Ď --
				int OldFDirWrite = cinfo->FDirWrite;
				DEBUGLOGC("Subthred-Found Change start", 0);

				if ( cinfo->FDirWrite == FDW_NORMAL ){ // ܂ȍ
					if ( !TinyCheckCellEdit(cinfo) ){
						StartReload(cinfo, &sts.DirCheck.UpdateWaitCount); // ɃO[
					}else{ // O[ҋ@
						cinfo->FDirWrite = FDW_WAITREQUEST;
					}
					if ( sts.DirCheck.ForceUpdateCount < 0 ){
						sts.DirCheck.ForceUpdateCount = XC_rrt[2];
					}
				}else if ( sts.DirCheck.ForceUpdateCount > 0 ){
					sts.DirCheck.ForceUpdateCount--;
					if ( sts.DirCheck.ForceUpdateCount == 0 ){
						DEBUGLOGC("Subthred-Force Reload", 0);
						cinfo->FDirWrite = FDW_REQUESTED;
						PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, K_raw | K_c | K_F5, 0);
					}
				}
				// 2bȓ 2000 / 50 z錟oꍇ́A
				// ُ킩Ȃ̂ŁAoĐݒs킹
				#define DCHECK_WDOGTIME 2000
				#define DCHECK_WDOGRATE 50
				if ( ++sts.DirCheck.detects >= (DCHECK_WDOGTIME / DCHECK_WDOGRATE) ){
					DWORD tick = GetTickCount();
					if ( (tick - sts.DirCheck.firstTick) <= DCHECK_WDOGTIME ){
						FindCloseChangeNotification(cinfo->SubT_dir);
						cinfo->SubT_dir = NULL;
						setflag(cinfo->SubTCmdFlags, SUBT_INITDIRCHECK);
						SetEvent(cinfo->SubT_cmd);
						continue;
					}
					sts.DirCheck.firstTick = tick;
					sts.DirCheck.detects = 0;
				}

				if ( FindNextChangeNotification(cinfo->SubT_dir) == FALSE ){
					FindCloseChangeNotification(cinfo->SubT_dir);
					cinfo->SubT_dir = NULL;
				}

				if ( OldFDirWrite != FDW_NORMAL ){
					Sleep(10); // AȂ悤ɏҋ@
				}

				DEBUGLOGC("Subthred-Found Change end", 0);
				continue;
			}
			default: // ҋ@s(WAIT_FAILED) -------------------------------
												// IuWFNgč쐬
				CloseHandle(cinfo->SubT_cmd);
				cinfo->SubT_cmd = CreateEvent(NULL, TRUE, FALSE, NULL);
												// fBNgĎU
				if ( cinfo->SubT_dir != NULL ){
					FindCloseChangeNotification(cinfo->SubT_dir);
					cinfo->SubT_dir = NULL;
					setflag(cinfo->SubTCmdFlags, SUBT_INITDIRCHECK);
				}
				Sleep(10); // AȂ悤ɏҋ@
				continue;
		}
	}
	// ɂ͓BȂ
}

// qXgfBNgTCY擾Đݒ肷
void USEFASTCALL GetDirSizeCache(PPC_APPINFO *cinfo)
{
	int cnt, i, maxi;
	ENTRYCELL *cell;
	TCHAR path[VFPS];
	BYTE *hist;

	EnterCellEdit(cinfo);
	if ( TinyCheckCellEdit(cinfo) ){
		LeaveCellEdit(cinfo);
		return;
	}

	cnt = 30;	// PœǂݍރLbV
	maxi = cinfo->cellWMin + cinfo->cel.Area.cx * cinfo->cel.Area.cy * READCACHEPAGES;
	if ( maxi > cinfo->e.cellIMax ) maxi = cinfo->e.cellIMax;
	i = cinfo->cellWMin;

	for ( ; i < maxi ; i++ ){
		cell = &CEL(i);
		if ( !(cell->f.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) ||
			 (cell->attr & (ECA_DIRNOH | ECA_DIRC | ECA_PARENT)) ){
			continue;
		}

		UsePPx();
		VFSFullPath(path, cell->f.cFileName, cinfo->path);
		hist = (BYTE *)SearchHistory(PPXH_PPCPATH, path);
		if ( (hist != NULL) &&
			 (GetHistoryDataSize(hist) >= (sizeof(DWORD) * 4)) ){
			int *sizes;

			sizes = (int *)GetHistoryData(hist);
			if ( sizes[3] != -1 ){
				cell->f.nFileSizeLow = sizes[2];
				cell->f.nFileSizeHigh = sizes[3];
				setflag(cell->attr, ECA_DIRG | ECA_DIRC | ECA_DIRNOH);
				RefleshCell(cinfo, i);
			}else{
				setflag(cell->attr, ECA_DIRNOH); // `FbNς݂̈t
			}
		}else{
			setflag(cell->attr, ECA_DIRNOH); // `FbNς݂̈t
		}
		FreePPx();

		cnt--;
		if ( cnt == 0 ){
			setflag(cinfo->SubTCmdFlags, SUBT_GETDIRSIZECACHE);
			SetEvent(cinfo->SubT_cmd);
			break;
		}
	}
	LeaveCellEdit(cinfo);
}

void WINAPI ColumnCallback(TCHAR *dst, const TCHAR *src)
{
	tstplimcpy(dst, src, CMDLINESIZE);
}

// Jge擾
void GetColumnExtData(PPC_APPINFO *cinfo)
{
	int cnt, i, maxi;
	ENTRYCELL *cell;
	TCHAR path[VFPS], text[CMDLINESIZE];
	DWORD useLoadCounter;

	EnterCellEdit(cinfo);
	if ( TinyCheckCellEdit(cinfo) ){
		LeaveCellEdit(cinfo);
		return;
	}
	useLoadCounter = cinfo->LoadCounter;

	cnt = 30;	// PœǂݍރLbV
	maxi = cinfo->cellWMin + cinfo->cel.Area.cx * cinfo->cel.Area.cy * 2;
	if ( maxi > cinfo->e.cellIMax ) maxi = cinfo->e.cellIMax;
	i = cinfo->cellWMin;

	for ( ; i < maxi ; i++ ){
		BOOL refrash;
		int ptroffset;

		cell = &CEL(i);
		ptroffset = cell->cellcolumn;
/* sv
		if ( ptroffset < CCI_NOLOAD ) continue; // 
		if ( (cell->attr & (ECA_PARENT | ECA_THIS)) ||
			 (cell->state < ECS_NORMAL) ){
			cell->cellcolumn = CCI_NODATA;
			continue;
		}
*/
		if ( ptroffset < 0 ) continue; // 󗓁^܂\ĂȂ
		refrash = FALSE;
		for ( ; ; ){
			CELLEXTRASTRUCT *cdsptr;
			int nowptroffset;

			nowptroffset = ptroffset;
			if ( cinfo->e.CellExtra.bottom == NULL ) break;
			cdsptr = (CELLEXTRASTRUCT *)(BYTE *)(cinfo->e.CellExtra.bottom + ptroffset);
			ptroffset = cdsptr->nextoffset;
			if ( cdsptr->textoffset == 0 ){
				int itemindex;
				DWORD attributes;

				VFSFullPath(path, cell->f.cFileName, cinfo->RealPath);
				text[0] = '\0';
				itemindex = cdsptr->itemindex;
				attributes = cell->f.dwFileAttributes;
				LeaveCellEdit(cinfo);
				ExtGetData(&cinfo->ColumnExtDlls, itemindex, path, attributes, (GETINFOTIPCALLBACK)ColumnCallback, text);
				EnterCellEdit(cinfo);
				if ( (useLoadCounter != cinfo->LoadCounter) || (cinfo->e.CellExtra.bottom == NULL) ){
					LeaveCellEdit(cinfo);
					return;
				}
				// EnterCellEdit ̑O ColumnData.bottom ω鋰L
				cdsptr = (CELLEXTRASTRUCT *)(BYTE *)(cinfo->e.CellExtra.bottom + nowptroffset);
				cdsptr->textoffset = cinfo->e.CellExtra.top;
				cdsptr->size = 0;
				ThAppend(&cinfo->e.CellExtra, text, TSTRSIZE32(text));
				refrash = TRUE;
			}
			if ( ptroffset == 0 ) break; // 
		}
		if ( useLoadCounter != cinfo->LoadCounter ) break;

		if ( IsTrue(refrash) ){ // 擾L
			RefleshCell(cinfo, i);
		}else{ // 擾c
			continue;
		}
		cnt--;
		if ( cnt == 0 ){
			setflag(cinfo->SubTCmdFlags, SUBT_GETCOLUMNEXT);
			SetEvent(cinfo->SubT_cmd);
			break;
		}
	}
	LeaveCellEdit(cinfo);
}

void USEFASTCALL FixThreads(PPC_APPINFO *cinfo, DWORD ThreadID)
{
	HANDLE hThread;

	if ( DOpenThread == NULL ) return;
	hThread = DOpenThread(STANDARD_RIGHTS_REQUIRED | THREAD_TERMINATE,
			FALSE, ThreadID);
	if ( hThread == NULL ) return;

	PPxCommonExtCommand(K_THREADUNREG, ThreadID);
#pragma warning(suppress: 6258) // IӐ}
	TerminateThread(hThread, 0);
	CloseHandle(hThread);
	if ( FOPlocked ) return;
	FOPlocked = TRUE;
	PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, KC_POPTENDFIX, 0);
}
