/*-----------------------------------------------------------------------------
	Paper Plane basicUI			Main
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include <wincon.h>
#include <string.h>
#include "PPXVER.H"
#include "PPX.H"
#include "VFS.H"
#include "TCONSOLE.H"
#include "PPB.H"
#pragma hdrstop

HWND hBackWnd = NULL;	// ŏɖ߂ Window
int RegNo = -1;			// PPx Register ID
DWORD ExitCode = EXIT_SUCCESS; // svZX̏IR[h
TCHAR RegID[REGIDSIZE] = T("B_");	// PPx Register ID
TCHAR *CurrentPath;		// ݂̎spX(EditPath or ExtPath)
TCHAR PPxPath[VFPS];	// PPx {̂̂pX
TCHAR EditPath[VFPS];	// PPb command line ێpX
TCHAR ExtPathBuf[VFPS], *ExtPath;	// OsɎgppX
HANDLE hCommSendEvent = NULL; // ÕR}h󂯕tpCxg
							// signal:t\
HANDLE hCommIdleEvent = NULL; // ÕR}h󂯕tpCxg
							// signal:ƒ
ThSTRUCT LongParam = ThSTRUCT_InitData;	// R}hCp
ThSTRUCT ResultText = ThSTRUCT_InitData;	// %*extractp
DWORD BreakTick = 0, BreakCount = 0;

TCHAR WndTitle[WNDTITLESIZE] = T("PPB[a]");
TCHAR RegCID[REGIDSIZE - 1] = T("BA");

const TCHAR PPbMainThreadName[] = T("PPb main");
const TCHAR PPbOptionError[] = T("Bad option\r\n");
const TCHAR PPbMainTitle[] = T("PPbui V") T(FileProp_Version)
		T("(") RUNENVSTRINGS T(") ") TCopyright T("\n");

THREADSTRUCT threadstruct = {PPbMainThreadName, XTHREAD_ROOT, NULL, 0, 0};
PPXAPPINFO ppbappinfo = {(PPXAPPINFOFUNCTION)PPbInfoFunc, T("PPb"), RegID, NULL};

/*-----------------------------------------------------------------------------
	SetConsoleCtrlHandler œo^nh
-----------------------------------------------------------------------------*/
BOOL SysHotKey(DWORD dwCtrlType)
{
	switch (dwCtrlType){
		case CTRL_CLOSE_EVENT:				// I
		case CTRL_LOGOFF_EVENT:
		case CTRL_SHUTDOWN_EVENT:
			ReleasePPB();
			return FALSE; // ̃nhցcI
		case CTRL_BREAK_EVENT:				// ^BREAK
		case CTRL_C_EVENT: {				// ^C
			DWORD tick, delta;

			// A5񗈂A~mFs
			tick = GetTickCount();
			delta = tick - BreakTick;
			BreakTick = tick;
			if ( BreakCount < (5 - 1) ){
				if ( delta > 300 ){
					BreakCount = 0;
				}else{
					BreakCount++;
				}
			}else for (;;){
				DWORD oldinmode;
				int key;
				INPUT_RECORD cin;

				tputstr(T("** Quit PPb?[Y] **"));
				GetConsoleMode(hStdin, &oldinmode);
				SetConsoleMode(hStdin, CONSOLE_IN_FLAGS_KEYONLY | ENABLE_ECHO_INPUT);
				key = tgetc(&cin);
				SetConsoleMode(hStdin, oldinmode);
				if ( (key >= 0) && (cin.EventType == KEY_EVENT) ){
					if ( TinyCharUpper(key) == 'Y' ){
						ReleasePPB();
						return FALSE; // ̃nhցcI
					}
					if ( key & (K_s | K_c | K_a) ) continue;
					BreakCount = 0;
					break;
				}
			}
			return TRUE;
		}
	}
	return FALSE;
}

void CommandMacro(const TCHAR *param)
{
	ppbappinfo.Function = (PPXAPPINFOFUNCTION)PPbExecInfoFunc;
	hStdin	= GetStdHandle(STD_INPUT_HANDLE);
	hStdout = GetStdHandle(STD_OUTPUT_HANDLE);

	PP_ExtractMacro(NULL, &ppbappinfo, NULL, param, NULL,
			XEO_CONSOLE | XEO_NOUSEPPB);
}

const TCHAR *MoreParam(const TCHAR *param)
{
	TCHAR code;
	for (;;){
		code = *param;
		if ( Isalpha(code) ){
			param++;
			continue;
		}
		if ( (code == ' ') || (code == ':') ){
			param++;
			SkipSpace(&param);
			return param;
		}
		return NilStr;
	}
}

BOOL InitPPb(void)
{
	TCHAR buf[CMDLINESIZE * 2];
	const TCHAR *ptr;
	HWND hRwnd = BADHWND; // N̑ΏۃEBhE
	BOOL quiet = FALSE;
	int MultiBootMode = PPXREGIST_NORMAL;
	WINPOS WinPos;

	(void)CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
#if NODLL
	InitCommonDll(GetModuleHandle(NULL));
#endif
	PPxRegisterThread(&threadstruct);
	FixCharlengthTable(T_CHRTYPE);
	PPxCommonExtCommand(K_ConsoleMode, ConsoleMode_Console);
//------------------------------------- JgfBNgݒ
	ptr = GetCommandLine();
	GetLineParamS(&ptr, PPxPath, TSIZEOF(PPxPath));
										//---------------------------- PPxPath
	GetModuleFileName(NULL, PPxPath, TSIZEOF(PPxPath));
	*VFSFindLastEntry(PPxPath) = '\0';	// t@C
										//---------------------------- EditPath
	GetCurrentDirectory(TSIZEOF(EditPath), EditPath);
										//---------------------------- ExtPath
	ExtPath = ExtPathBuf;
	tstrcpy(ExtPath, EditPath);
										//-------- vZX̃JgύX
	SetCurrentDirectory(PPxPath);

	CurrentPath = EditPath;
	EditText = buf; // ݒ
	buf[0] = '\0';
	PPxRegGetIInfo(&ppbappinfo);

	for (;;){
		if ( *ptr == '\0' ) break;
		if ( *ptr <= ' ' ){
			ptr++;
			continue;
		}
										// IvV`FbN -----
		if ( (*ptr == '-') || (*ptr == '/') ){
			ptr++;
			switch ( TinyCharUpper(*ptr) ){
				case 'B': {
					const TCHAR *more;

					more = MoreParam(ptr);
					if ( Isalpha(*more) ){
						if ( (more > (ptr + 5)) &&
							 (TinyCharUpper(*(ptr + 4)) != 'M') ){ //"BOOTID:A-Z"
							MultiBootMode = PPXREGIST_IDASSIGN;
							if ( Isalpha(*(more + 1)) ){
								RegID[1] = TinyCharUpper(*more);
								RegID[2] = TinyCharUpper(*(more + 1));
							}else{
								RegID[2] = TinyCharUpper(*more);
							}
						}else{	//	"BOOTMAX:A-Z"
							MultiBootMode = PPXREGIST_MAX;
							RegID[2] = TinyCharUpper(*more);
						}
					}
					while ( (*more != '\0') && ((UTCHAR)*more > ' ') ) more++;
					ptr = more;
					break;
				}

				case 'K':
					ptr++;
					SkipSpace(&ptr);
					first_command = ptr;
					ptr = NilStr;
					// Q 
				case 'Q':
					quiet = TRUE;
					break;

				case 'F': {
					TCHAR *top = NULL, *text;

					ptr++;
					GetLineParamS(&ptr, buf, TSIZEOF(buf));
					if ( LoadTextImage(buf, &top, &text, NULL) == NO_ERROR ){
						CommandMacro(text);
						HeapFree(GetProcessHeap(), 0, top);
					}
					goto goexit; // EXIT_SUCCESS
				}
				case 'C':
					ptr++;
					SkipSpace(&ptr);	// 󔒍폜
					CommandMacro(ptr);
					goto goexit; // EXIT_SUCCESS

				case 'P':
					ptr++;
					GetLineParamS(&ptr, buf, TSIZEOF(buf));
					VFSFixPath(EditPath, buf, EditPath, VFSFIX_FULLPATH | VFSFIX_REALPATH | VFSFIX_NOFIXEDGE);
					break;

				case 'I':
					ptr++;
					if ( *ptr == 'R' ){
						ptr++;
						hRwnd = (HWND)GetNumber(&ptr);
						break;
					}
					// default 
				default:
					tputstr_noinit(PPbOptionError);
					ExitCode = EXIT_FAILURE;
					goto goexit;
			}
			continue;
		}
		GetLineParamS(&ptr, buf, TSIZEOF(buf));
	}
	//------------------------------------- 
	RegNo = PPxRegist(PPXREGIST_DUMMYHWND, RegID, MultiBootMode);
	if ( RegNo < 0 ){
		ExitCode = EXIT_FAILURE;
		goto goexit;
	}

	SetErrorMode(SEM_FAILCRITICALERRORS);	// vIG[擾\ɂ

	if ( tInitConsole() == FALSE ){
		tputstr_noinit(T("Can't execute PPb on this OS.\r\n"));
		ExitCode = EXIT_FAILURE;
		goto goexit;
	}
									// VXe֘ÃCxgǗnh̐ݒ
	SetConsoleCtrlHandler((PHANDLER_ROUTINE)SysHotKey, TRUE);
	if ( quiet == FALSE ) tputstr(PPbMainTitle);

	ppbappinfo.hWnd = hHostWnd;
										// PPCOMMON ɓo^
	PPxRegist(hHostWnd, RegID, PPXREGIST_SETHWND);
	RegCID[1] = RegID[2];
	WndTitle[4] = RegID[2];
	{
		const TCHAR *runasp;

		runasp = CheckRunAs();
		if ( runasp != NULL ){
			thprintf(WndTitle + 6, TSIZEOF(WndTitle) - 6, T("(%s)"), runasp);
		}
	}
										//  SendPPbLڂ̃t[ԍ
										// [1] vZXԒʐMpCxg̒`
	thprintf(buf, TSIZEOF(buf), T("%s%s"), PPxGetSyncTag(), RegID);

	hCommSendEvent = CreateEvent(NULL, TRUE, FALSE, buf); // nosignal
	tstrcat(buf, T("R"));
	hCommIdleEvent = CreateEvent(NULL, TRUE, FALSE, buf); // nosignal

	if ( hCommSendEvent == NULL ) tputstr(T("Event create error\n"));

											// EBhEʒuĐݒ
	if ( UseGUI &&
		(NO_ERROR == GetCustTable(T("_WinPos"), RegCID, &WinPos, sizeof(WinPos))) ){
		SetWindowPos(hHostWnd, NULL, WinPos.pos.left, WinPos.pos.top,
				WinPos.pos.right - WinPos.pos.left,
				WinPos.pos.bottom - WinPos.pos.top,
				SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);
	}
//------------------------------------- N
	if ( hRwnd != BADHWND ){
		HANDLE hRevent;

		thprintf(buf, TSIZEOF(buf), T(PPBBOOTSYNC) T("%x"), (DWORD)(DWORD_PTR)hRwnd);
		hRevent = OpenEvent(EVENT_ALL_ACCESS, FALSE, buf);
		if ( hRevent != NULL ){
			SetEvent(hRevent);
			CloseHandle(hRevent);
		}
	}
	return TRUE;
goexit:
	PPxUnRegisterThread();
	CoUninitialize();
	return FALSE;
}

/*-----------------------------------------------------------------------------
	Main Routine
-----------------------------------------------------------------------------*/
// X^[gAbvR[hȗɂ邽߁Avoid w
int USECDECL main(void)
{
	int breakflag = 0;		// 0:loop
	TCHAR Cparam[CMDLINESIZE]; // ͂ꂽR}hC
	TCHAR RecvParam[RECEIVESTRINGSLENGTH]; // MR}hC

	if ( InitPPb() == FALSE ) return ExitCode;
	PPxCommonExtCommand(K_UxTheme, KUT_INIT);
	ResettCInput(&tis, Cparam, TRUE);
	while ( breakflag >= 0 ){
											// JgfBNg̉
		CurrentPath = EditPath;
		SetCurrentDirectory(PPxPath);
		TitleDisp(NULL);
		SetEvent(hCommIdleEvent); // [2]t\
		switch( tCInput(Cparam, TSIZEOF(Cparam), PPXH_GENERAL_R) ){
			case TCI_RECV: {	// ÕR}hsA[4][5] eݒʒm
				int result;

				*(DWORD *)RecvParam = ExitCode;
				result = ReceiveStrings(RegID, RecvParam); // [6]e
				if ( result == 0 ){
					ResetEvent(hCommSendEvent);
					tFillSpace(0, screen.info.dwCursorPosition.Y,
							screen.info.dwSize.X - 1,
							screen.info.dwCursorPosition.Y);
					CurrentPath = ExtPath;
					PPbExecuteRecv(RecvParam); // [7]s
				}else{ // sM
					if ( result == 2 ){ // 炩f[^MKv
						if ( ResultText.size != 0 ){
							RecvParam[1] = 'r';
							if ( (ResultText.size - ResultText.top) < TSTROFF(CMDLINESIZE) ){
								RecvParam[2] = ' ';
								tstrcpy(RecvParam + 3, ThStrLastT(&ResultText) );
								ThFree(&ResultText);
							}else{
								RecvParam[2] = '+';
								tstrcpypart(RecvParam + 3, ThStrLastT(&ResultText), CMDLINESIZE - 1);
								ResultText.top += TSTROFF(CMDLINESIZE - 1);
							}
							ReceiveStrings(NULL, RecvParam);
						}
					}
					ResetEvent(hCommSendEvent); // [8] ԐM
				}
				break; // [9] Ďt
			}
			case TCI_EXECUTE: {	// CR s
				if ( Cparam[0] != '\0' ){
					ResetEvent(hCommIdleEvent); // 󂯕tɕύX [1]
					tputstr(T("\n"));
					WriteHistory(PPXH_COMMAND, Cparam, 0, NULL);
					breakflag = PPbExecuteInput(Cparam, tstrlen(Cparam));
					ResettCInput(&tis, Cparam, FALSE);
				}else{
					tstrcpy(Cparam, T("*menu")); // help
					TconCommonCommand(&tis, K_raw | K_c | 'A');
				}
				break;
			}
			case TCI_QUIT:		// ESC I
				tputstr(T("\n"));
				breakflag = -1;
				break;
		}
	}
	setflag(threadstruct.flag, XTHREAD_ROOT | XTHREAD_EXITENABLE);
	ReleasePPB();
	return EXIT_SUCCESS;
}
