/*-----------------------------------------------------------------------------
	Z	(c)TORO
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include "TOROWIN.H"
#include "CALC.H"

#define ONPPXDLL		// PPCOMMON.H  DLL `w
#include "PPCOMMON.H"

/* Calc_String(BYTE **param, int *result, int lv0, int para0)  lv0 ݒl

	lv	D揇ʕۑ
			LOWORD	QԂ̗D揇ʁA傫قǒᏇ
				0		ŏ(ʓ܂)̌Ăяo
				1	()	[]	->	::	.							E
				2	!	~	+	-	++	--	&	*	sizeof	new	delete
																E獶
				3	.* 	->*										E
				4	*	/	%									E
				5	+	-										E
				6	<<	>>										E
				7	<	<=	>	>=								E
				8	==	!=										E
				9	&											E
				10	^											E
				11	|											E
				12	&&											E
				13	||											E
				14	?:											E獶
				15	=	*=	/=	%=	+=	-=	&=	^=	|=	<<=	>>=	E獶 */
#define CALC_BRACKET	B30		// ʓ̎
#define CALC_USEPARAM0	B29		// para0 L
//-----------------------------------------------------------------------------
typedef enum {
	OPENONE, OPEMUL, OPEDIV, OPEPAR, OPEPLUS, OPEMINUS,
	OPESHL, OPESHR, OPELT, OPELE, OPEGT, OPEGE, OPEEQ, OPENE,
	OPEAND, OPEXOR, OPEOR, OPELAND, OPELOR
} OPTYPES;

struct opelevel {
	TCHAR	ope[2];	// Zq
	int		level;	// D揇
	OPTYPES type;	// Z@
} levels[] = {			// QZq̈ꗗ
	{ {'<', '<'},	6,	OPESHL},
	{ {'<', '='},	7,	OPELE},
	{ {'>', '>'},	6,	OPESHR},
	{ {'>', '='},	7,	OPEGE},
	{ {'=', '='},	8,	OPEEQ},
	{ {'!', '='},	8,	OPENE},
	{ {'&', '&'},	12,	OPELAND},
	{ {'|', '|'},	13,	OPELOR},
	{ {'*', '\0'},	4,	OPEMUL},
	{ {'/', '\0'},	4,	OPEDIV},
	{ {'%', '\0'},	4,	OPEPAR},
	{ {'+', '\0'},	5,	OPEPLUS},
	{ {'-', '\0'},	5,	OPEMINUS},
	{ {'<', '\0'},	7,	OPELT},
	{ {'>', '\0'},	7,	OPEGT},
	{ {'=', '\0'},	8,	OPEEQ},
	{ {'&', '\0'},	9,	OPEAND},
	{ {'^', '\0'},	10,	OPEXOR},
	{ {'|', '\0'},	11,	OPEOR},
	{ {'\0', '\0'},	0,	OPENONE}
};

const TCHAR *StringLast(const TCHAR *ptr)
{
	for (;;){
		TCHAR chr;

		chr = *ptr;
		if ( chr != '\"' ){
			if ( chr != '\0' ){
				ptr++;
				continue;
			}
			return NULL;
		}else{ // "
			if ( *(ptr + 1) != '\"' ) return ptr;
			ptr += 2;
			continue;
		}
	}
}

int Calc_CompareString(const TCHAR **param, int *result, int lv0)
{
	const TCHAR *ptr, *src, *dst;
	size_t src_size, dst_size;
	OPTYPES type = OPENONE;
	DWORD option = 0;
	int r;

	src = ptr = *param + 1; // u"v̎
	ptr = StringLast(ptr);
	if ( ptr == NULL ) return CALC_NUMERROR;
	src_size = ptr - src;
	ptr++;

	// Zq擾
	SkipSPC(ptr);
	if ( *ptr == '=' ){
		type = OPEEQ;
		if ( *(ptr + 1) == '=' ){
			ptr += 2;
		}else{
			ptr++;
		}
		SkipSPC(ptr);
	}else if ( *ptr == '!' ){
		if ( *(ptr + 1) == '=' ){
			ptr += 2;
			type = OPENE;
			SkipSPC(ptr);
		}
	}
	if ( type == OPENONE ) return CALC_OPEERROR;
	if ( *ptr == 'i' ){
		option = NORM_IGNORECASE;
		ptr++;
		SkipSPC(ptr);
	}else if ( *ptr == 'j' ){
		option = NORM_IGNORECASE | NORM_IGNOREKANATYPE | NORM_IGNOREWIDTH;
		ptr++;
		SkipSPC(ptr);
	}

	if ( *ptr != '\"' ) return CALC_NUMERROR;
	dst = ++ptr;
	ptr = StringLast(ptr);
	if ( ptr == NULL ) return CALC_NUMERROR;
	dst_size = ptr - dst;
	*param = ptr + 1;

	if ( lv0 & CALC_BRACKET ){ // ʕo
		ptr++;
		SkipSPC(ptr);
		if ( *ptr == ')' ) *param = ptr + 1;
	}

	if ( option ){
		r = CompareString(LOCALE_USER_DEFAULT, option,
				src, src_size, dst, dst_size) - 2;
	}else{
		if ( src_size != dst_size ){
			*result = (type == OPEEQ) ? 0 : 1;
			return CALC_NOERROR;
		}
		r = memcmp(src, dst, TSTROFF(src_size));
	}
	*result = (type == OPEEQ) ? (r == 0) : (r != 0);
	return CALC_NOERROR;
}


/*-----------------------------------------------------------------------------
	QZq̗D揇ʂ𒲂ׂ
-----------------------------------------------------------------------------*/
struct opelevel *GetCalcLevel(const TCHAR **ptr)
{
	struct opelevel *level;
	UTCHAR c0, c1;

	c0 = *(*ptr);
	c1 = *(*ptr + 1);
	for ( level = levels ; level->level ; level++ ){
		if ( c0 != level->ope[0] ) continue;
		if ( level->ope[1] != '\0' ){
			if ( c1 != level->ope[1] ) continue;
			(*ptr) += 2;
		}else{
			(*ptr)++;
		}
		break;
	}
	return level;
}
/*-----------------------------------------------------------------------------
	P𓾂
-----------------------------------------------------------------------------*/
int GetCalcItem(const TCHAR **param, int *result)
{
	const TCHAR *para;
	int status = CALC_NOERROR;

	para = *param;
	SkipSPC(para);
	switch ( *para ){
		case '(':
			para++;
			status = Calc_String(&para, result, CALC_BRACKET, 0);
			break;
		case '!':
			para++;
			status = GetCalcItem(&para, result);
			*result = !(*result);
			break;
		case '~':
			para++;
			status = GetCalcItem(&para, result);
			*result = ~(*result);
			break;
		case '+':
			para++;
			status = GetCalcItem(&para, result);
			break;
		case '-':
			para++;
			status = GetCalcItem(&para, result);
			*result = -(*result);
			break;

		default: {
			const TCHAR *p;
			p = para;
			*result = GetIntNumber(&para);
			if ( para == p ) status = CALC_NUMERROR;
		}
	}
	*param = para;
	return status;
}
/*-----------------------------------------------------------------------------
	d@\
-----------------------------------------------------------------------------*/
int Calc_String(const TCHAR **param, int *result, int lv0, int para0)
{
	struct opelevel *lv1, *lv2;
	int n; // P
	int m; // Q
	int status = CALC_NOERROR;
	const TCHAR *para, *p;

	para = *param;
	SkipSPC(para);
										// P̎擾 -----------------------
	if ( lv0 & CALC_USEPARAM0 ){	// Ɏ擾ς
		n = para0;
		resetflag(lv0, CALC_USEPARAM0);
	}else{
		if ( *para == '\"' ){ // r͒P
			*param = para;
			return Calc_CompareString(param, result, lv0);
		}
		status = GetCalcItem(&para, &n);
	}
										// Qȍ~ ---------------------------
	while ( status == CALC_NOERROR ){
		SkipSPC(para);
		if ( *para == '\0' ) break;	// P̂

		if ( HIWORD(lv0) && (*para == ')') ){
			para++;
			break;
		}
										// Zq̎擾 -----------------------
		p = para;
		lv1 = GetCalcLevel(&para);
		if ( lv1->level == 0 ){
			status = CALC_OPEERROR;
			break;
		}
		if ( LOWORD(lv0) && (LOWORD(lv0) <= lv1->level) ){
			para = p;
			break;
		}
										// Q̎擾 -----------------------
		status = GetCalcItem(&para, &m);
		if ( status != 0 ) break;
										// D揇ʂ̔ ---------------------
		SkipSPC(para);
		p = para;
		lv2 = GetCalcLevel(&p);
		if ( lv2->level && (lv1->level > lv2->level) ){	// E̕D悾
			status = Calc_String(&para, &m,
					(lv0 & CALC_BRACKET) | lv1->level | CALC_USEPARAM0, m);
			if ( status != 0 ) break;
		}
										// Z -------------------------------
		switch (lv1->type){
			case OPEMUL:
				n *= m;
				continue;
			case OPEDIV:
				if ( m ){
					n /= m;
					continue;
				}else{
					status = CALC_DIVERROR;
					break;
				}
			case OPEPAR:
				if ( m ){
					n %= m;
					continue;
				}else{
					status = CALC_DIVERROR;
					break;
				}
			case OPEPLUS:
				n += m;
				continue;
			case OPEMINUS:
				n -= m;
				continue;
			case OPESHL:
				n = n << m;
				continue;
			case OPESHR:
				n = n >> m;
				continue;
			case OPELT:
				n = n < m;
				continue;
			case OPELE:
				n = n <= m;
				continue;
			case OPEGT:
				n = n > m;
				continue;
			case OPEGE:
				n = n >= m;
				continue;
			case OPEEQ:
				n = n == m;
				continue;
			case OPENE:
				n = n != m;
				continue;
			case OPEAND:
				n &= m;
				continue;
			case OPEXOR:
				n ^= m;
				continue;
			case OPEOR:
				n |= m;
				continue;
			case OPELAND:
				n = n && m;
				continue;
			case OPELOR:
				n = n || m;
				continue;
			default:
				status = CALC_OPEERROR;
		}
	}
	*param = para;
	*result = n;
	return status;
}
