/*-----------------------------------------------------------------------------
	Paper Plane xUI	 Virtual File System						`
-----------------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif

#define MAX_PATH_EX 0x8000
#ifdef RELEASE
#define CHECKVFXEXNAME 0
#define UseExtraLongPath 0
#else
#define CHECKVFXEXNAME 0
#define UseExtraLongPath 0
extern TCHAR expathbuf[MAX_PATH_EX];
#endif

#define CP_PPX_UCF2 0xfffff // UCF2 w肷Ƃ̓R[h
#define VFS_FORCELOAD_PLUGIN B30 // ǂݍݗ}~ĂPluginǂݍ

typedef struct {
	DWORD l, h;
} DDWORD;

#define MAKEFLAG_EnumObjectsForFolder ((WinType >= WINTYPE_VISTA) ? ENUMOBJECTSFORFOLDERFLAG_VISTA : ENUMOBJECTSFORFOLDERFLAG_XP)

// FTP ֘A -------------------------------------------------------------------
#ifndef HINTERNET
#ifndef ERROR_INTERNET_EXTENDED_ERROR
#define ERROR_INTERNET_EXTENDED_ERROR 12003
#define ERROR_INTERNET_CANNOT_CONNECT 12029
#define ERROR_INTERNET_LOGIN_FAILURE  12015
#endif

#define INTERNET_OPEN_TYPE_PRECONFIG	0
#define INTERNET_OPEN_TYPE_DIRECT		1
#define INTERNET_DEFAULT_FTP_PORT		21
#define INTERNET_FLAG_RELOAD			0x80000000
#define INTERNET_FLAG_DONT_CACHE		0x04000000
#define INTERNET_FLAG_PASSIVE			0x08000000
#define INTERNET_SERVICE_FTP			1
typedef LPVOID HINTERNET;
typedef WORD INTERNET_PORT;

#define FTP_TRANSFER_TYPE_UNKNOWN   0x00000000
#define FTP_TRANSFER_TYPE_ASCII     0x00000001
#define FTP_TRANSFER_TYPE_BINARY    0x00000002
#endif

TypedefWinAPI(HINTERNET, InternetOpen, (LPCTSTR lpszAgent, DWORD dwAccessType, LPCTSTR lpszProxy, LPCTSTR lpszProxyBypass, DWORD dwFlags));
TypedefWinAPI(BOOL, InternetCloseHandle, (HINTERNET hInternet));
TypedefWinAPI(HINTERNET, InternetConnect, (HINTERNET hInternet, LPCTSTR lpszServerName, INTERNET_PORT nServerPort, LPCTSTR lpszUserName, LPCTSTR lpszPassword, DWORD dwService, DWORD dwFlags, DWORD *dwContext));
TypedefWinAPI(BOOL, FtpSetCurrentDirectory, (HINTERNET hConnect, LPCTSTR lpszDirectory));
TypedefWinAPI(BOOL, FtpGetCurrentDirectory, (HINTERNET hConnect, LPTSTR lpszCurrentDirectory, LPDWORD lpdwCurrentDirectory));
TypedefWinAPI(HINTERNET, FtpFindFirstFile, (HINTERNET hConnect, LPCTSTR lpszSearchFile, WIN32_FIND_DATA *lpFindFileData, DWORD dwFlags, DWORD *dwContext));
TypedefWinAPI(BOOL, InternetFindNextFile, (HINTERNET hFind, LPVOID lpvFindData));

TypedefWinAPI(BOOL, FtpGetFile, (HINTERNET hConnect, LPCTSTR lpszRemoteFile, LPCTSTR lpszNewFile, BOOL fFailIfExists, DWORD dwFlagsAndAttributes, DWORD dwFlags, DWORD dwContext));

TypedefWinAPI(BOOL, FtpPutFile, (HINTERNET hConnect, LPCTSTR lpszLocalFile, LPCTSTR lpszNewRemoteFile, DWORD dwFlags, DWORD dwContext));

TypedefWinAPI(BOOL, FtpRenameFile, (HINTERNET hConnect, LPCTSTR lpszExisting, LPCTSTR lpszNew));

TypedefWinAPI(BOOL, FtpDeleteFile, (HINTERNET hConnect, LPCTSTR lpszFileName));

TypedefWinAPI(BOOL, FtpCreateDirectory, (HINTERNET hConnect, LPCTSTR lpszDirectory));

TypedefWinAPI(BOOL, FtpRemoveDirectory, (HINTERNET hConnect, LPCTSTR lpszDirectory));

#define FTPINET 0
#define FTPHOST 1
extern DWORD OpenFtp(TCHAR *url, HANDLE *hFtp);
extern ERRORCODE MoveFtpFile(const TCHAR *ExistingFileName, const TCHAR *NewFileName);
extern ERRORCODE CreateFtpDirectory(const TCHAR *path);
extern ERRORCODE DeleteFtpEntry(const TCHAR *path, DWORD attributes);
extern ERRORCODE GetInetError(void);

// CD-ROM/FAT ֘A ------------------------------------------------------------
// FAT ********************************
#pragma pack(push, 1)
					// FATGg
typedef struct {
	char	name[8];
	char	ext[3];
	BYTE	atr;
	BYTE	vflag;
	BYTE	sum;
	WORD	Ctime;
	WORD	Cdate;
	WORD	Adate;
	WORD	clusterH;
	WORD	Wtime;
	WORD	Wdate;
	WORD	clusterL;
	DWORD	size;
} FATENTRY;
					// LFN ̃Gg
typedef struct {
	BYTE	ID;
	WORD	name1[5];
	BYTE	atr;
	BYTE	zero1;
	BYTE	sum;
	WORD	name2[6];
	WORD	zero2;
	WORD	name3[2];
} LFNENTRY;
					// X68000`̃Gg
typedef struct {
	char	name1[8];
	char	ext[3];
	BYTE	atr;
	char	name2[10];
	WORD	time;
	WORD	date;
	WORD	cluster;
	DWORD	size;
} XFATENTRY;
// CD-ROM ********************************
#define CDHEADEROFFSET1 0x8000
#define CDHEADEROFFSET2 0x9310
#define CDHEADEROFFSET3 0x9318
#define CDHEADEROFFSET4 0x53000
#define DVDHEADEROFFSET 0x80000

					// CD-ROM
typedef struct {
	BYTE	type;		// 1:PVD, 2:SVD
	char	ID[5];		// "CD001"
	BYTE	version;	// {[LqqŐ(1)
	BYTE	volumeflag;
	char	systenID[32];
	char	volumeID[32];
	char	reserved[8];
	DWORD	volumeSpaces[2];
	char	ESC[32];
	WORD	volumeBlocks[2];
	WORD	volumeSerial[2];
	WORD	SectorSize[2];
	DWORD	PathTableSize[2];
	DWORD	PathTable1LE;
	DWORD	PathTable2LE;
	DWORD	PathTable1BE;
	DWORD	PathTable2BE;
} PVDSTRUCT;

typedef struct {
	BYTE	len;		// O̒
	BYTE	extlen;		// g̒
	DWORD	extend;		// ̂ւ̃CfbNX
	WORD	parent;		// ẽpXCfbNX
	char	name[1];
} PATHRECORD;

typedef struct {
	BYTE year;	// (+1900)
	BYTE month;
	BYTE day;
	BYTE hour;
	BYTE minute;
	BYTE second;
	char UTC;	// x15min
} DATETIME;

#define CDATR_HIDDEN	B0
#define CDATR_DIRECTORY	B1
#define CDATR_RELAY		B2	// ֘At@C
#define CDATR_RECORD	B3
#define CDATR_PROTECTED	B4
#define CDATR_ENDMARK	B7	// ŏIGg̈

typedef struct {
	BYTE	next;		// ̍\̂̒
	BYTE	extlen;		// g̒
	DWORD	extend[2];	// ̂ւ̃CfbNX
	DWORD	size[2];	// t@CTCY
	DATETIME date;
	BYTE	flags;
	BYTE	fileunitsize;
	BYTE	interleave;
	WORD	serial[2];
	BYTE	len;		// O̒
	char	name[1];
} DIRECTORYRECORD;

// UDF ********************************
typedef struct {
	DWORD LBN; // p[e[VItZbg
	WORD PRN; // p[e[Vԍ
} UDFLBADDR;

typedef struct {	// 8 bytes
	DWORD size; // 傫
	DWORD loc;  // ZN^ԍ
} UDFEXTENTAD;

typedef struct {
	DWORD length; // 傫
	DWORD position;  // ZN^ԍ
} UDFSHORTAD;

typedef struct {	// 16bytes
	DWORD length; // 傫
	UDFLBADDR location;  // ZN^ԍ
	BYTE reserved[6];
} UDFLONGAD;

typedef struct {	// 16bytes
	WORD id, ver;
	BYTE checksum, reserved;
	WORD SN, crc, len;
	DWORD loc; // ݈ʒu
} UDFTAG;

typedef struct {	// 12bytes
	WORD tz, year;
	BYTE month, day, hour, minute, second, ssecond, msecond, csecond;
} UDFTIME;

typedef struct {	// 64bytes
	BYTE type, text[63];
} UDFCHARINFO;

typedef struct {
	BYTE data[32];
} UDFREGID;

typedef struct {	// 20bytes
	DWORD PRNDE;
	WORD ST;
	BYTE SP[2];
	WORD MNE;
	BYTE reserved;
	BYTE FT;
	UDFLBADDR ParentICB;
	WORD Flags;
} UDFICB;

#define UDF_FID_ID 257
typedef struct {
	UDFTAG tag;
	WORD FVN;
	BYTE FC;
	BYTE L_FI;
	UDFLONGAD ICB;
	WORD L_IU;
	BYTE IU[1];
} UDFFID;
#define UDFATR_HIDDEN	B0
#define UDFATR_DIRECTORY	B1
#define UDFATR_DELETED	B2
#define UDFATR_PARENT	B3

// Descriptor ֘A

typedef struct {
	UDFTAG tag;
	UDFEXTENTAD VDS, subVDS;
} UDF_AVDP;

//VDS***
// VDS ɔzue...PVD=1, IUVD=4, PD=5, LVD=6, USD=7, TD=8
#define UDF_PD_ID 5
typedef struct {
	UDFTAG tag;
	DWORD VDSN;
	WORD PF;
	WORD PD;
	UDFREGID PC;
	BYTE PCU[128];
	DWORD AT;
	DWORD PAL; // +0xbc p[e[V̐擪
	DWORD PL;
	UDFREGID II;
	BYTE IU[128];
	UDFEXTENTAD ISE;
} UDF_PD;

#define UDF_LVD_ID 6
typedef struct {
	UDFTAG tag;		// 00
	DWORD VDSN;		// 10
	UDFCHARINFO DCS; // 14
	BYTE LVI[128];	// 54
	DWORD LBS;		// D4
	UDFREGID DI;	// D8
	UDFLONGAD LVCU; // F8 FD
	DWORD MTL;		// 108
	DWORD NPM;		// 10C
	UDFREGID II;	// 110
	BYTE IU[128];	// 130
	UDFEXTENTAD ISE;
	BYTE PM[2]; // MTL 
} UDF_LVD;
//VDS end***

#define UDF_TD_ID 8

#define UDF_FSD_ID 256
typedef struct {
	UDFTAG tag;			// 00
	UDFTIME RDT;		// 10
	WORD IL;			// 1c
	WORD MIL;			// 1e
	DWORD CSL;			// 20
	DWORD MCSL;			// 24
	DWORD FSN;			// 28
	DWORD FSDN;			// 2c
	UDFCHARINFO LVIC;	// 30
	BYTE LVI[128];		// 70
	UDFCHARINFO FSCS;	// f0
	BYTE FSI[32];		// 130
	BYTE CFI[32];		// 150
	BYTE AFI[32];		// 170
	UDFLONGAD ROOTICB;	// 190
	UDFREGID DI;
	UDFLONGAD NE;
	UDFLONGAD SSDI;
} UDF_FSD;

#define UDF_FE_ID 261
typedef struct {
	UDFTAG tag;			// 00
	UDFICB ICB;			// 10
	DWORD UID;			// 24
	DWORD GID;			// 28
	DWORD Permissions;	// 2c
	WORD FLC;			// 30
	BYTE RF;
	BYTE RDA;
	DWORD RL;			// 34
	DDWORD IL;			// 38 // ܂ UDF_EFE Ƌ
	DDWORD LBR;			// 40
	UDFTIME ADT;		// 48
	UDFTIME MDT;		// 54
	UDFTIME ATRDT;		// 60
	DWORD checkpoint;	// 6c
	UDFLONGAD EAICB;	// 70
	UDFREGID II;		// 80
	DDWORD UI;			// a0
	DWORD L_EA;			// a8
	DWORD L_AD;			// ac
	BYTE EA[1];			// b0
} UDF_FE;

#define UDF_EFE_ID 266
typedef struct {
	UDFTAG tag;			// 00
	UDFICB ICB;			// 10
	DWORD UID;			// 24
	DWORD GID;			// 28
	DWORD Permissions;	// 2c
	WORD FLC;			// 30
	BYTE RF;
	BYTE RDA;
	DWORD RL;			// 34
	DDWORD IL;			// 38
	DDWORD OS;			// 40 +EFE
	DDWORD LBR;			// 48
	UDFTIME ADT;		// 50
	UDFTIME MDT;		// 5C
	UDFTIME CDT;		// 68 +EFE
	UDFTIME ATRDT;		// 74
	DWORD checkpoint;	// 80
	DWORD reserved;		// 84 +EFE
	UDFLONGAD EAICB;	// 88
	UDFLONGAD SDI;		// 98 +EFE
	UDFREGID II;		// a8
	DDWORD UI;			// c8
	DWORD L_EA;			// d0
	DWORD L_AD;			// d4
	BYTE EA[1];			// d8
} UDF_EFE;
#pragma pack(pop)
//-----------------------------------------------------------------------------
typedef struct {
					// t@Cp̏BVFSCheckFile ̓ʗpB
	int flags;			// B0=1:ɗĂtOȂɗĂ
						// B1=1:wb_
						// B4=1:啶E̋ʂȂ(B1=1̎͌ݖ)
	DWORD off;			// ʒu/͈
	DWORD hsize;		// wb_̑傫
	const char *header;	// wb_e
						// ڍ׎
							// fname	Ώۃt@C
							// fbottom	t@C擪
							// header	header ꏊ
							// result	ʂވʒu
							// ߂l 0: !0:s
	ERRORCODE (*mChk)(const TCHAR *fname, const char *image, DWORD size,
						const char *header, VFSFILETYPE *result);

					// ʗp
	const TCHAR *type;		// ޖ^O
	const TCHAR *typetext;	// ޖRg
	const TCHAR *ext;		// ʏpgq
	int dtype;		// (PPV) (LOWORD)eLXǧ` (HIWORD)ϊ@
} VFD_HEADERS;

typedef struct {
	DDWORD cluster;	// ݂̃NX^
	DDWORD clusterBase;	// NX^ubN̐擪
	DWORD left;		// cNX^
	BYTE *datas;	// ̃NX^ubN
} CLUSTERRINFO;

typedef struct {	// fBXNC[Wp
	DWORD	BpC;		// NX^̃oCg
} DCOMMONS;

typedef struct {	// NTFSp
	CLUSTERRINFO mft, readmft;
	CLUSTERRINFO entry;
	void *mftd;
} NTFSS;

typedef union {
	NTFSS n;
	DWORD e_useFAT; // exFAT, FATQƂ̕KvȂ 1
} FCOMMONS;
//------------------------------------- FAT
typedef struct {
	DCOMMONS c;			// p

	HANDLE	hFile;		// fBXNC[W̃t@Cnh
	DWORD	Offset;		// fBXNC[W̎̂̊Jnʒu

	DWORD	NowFAT;		// FAT̃ANZXꏊ(FAT32, exFATŎgp)
	BYTE	*FAT;		// FAT12/16:FATC[W  FAT32, exFAT:LbVFAT
	BYTE	*Buffer;	// obt@(PNX^)

	DWORD	BpS;		// ZN^̃oCg
	DWORD	roots;		// [gfBNg̃oCg(FAT12, 16)
	int		fattype;	// FAT ̎

	DWORD	FATOffset;	// FAT̃t@C̈ʒu
	DWORD	ROOT;		// [gfBNg̊Jnʒu(12/16)ZN^(32)
	DWORD	DATAOffset;	// f[^Jnt@C̈ʒu
	DWORD	current;	// JgfBNg̊JnZN^
							// FindFirst p
	int		nowroot;	/* 0:ȏ̓ǂݍݕs
							1ȏ:c胋[gZN^
							-1:TufBNg(̃NX^擾ς)
							-2:TufBNg(̃NX^擾) */
	DWORD	nowpointer;	// fBNg̎Qƒ̃ZN^/NX^
	DWORD	nowleft;	// cGg
	FATENTRY *nowentry;	// Qƒ̃Gg
	DWORD	entryindex;	// ̂index

	FCOMMONS d;			// FAT/NTFS ŗL
} FATSTRUCT;

extern const DWORD FDIoffset[];
//------------------------------------- CD
#define CD_ISO9660 0
#define CD_JULIET 1
#define CD_UDF 2

typedef union {
	BYTE *raw;
	PVDSTRUCT *pvd;
	UDF_AVDP *avdp;
	UDFTAG *udftag;
	UDF_PD *pd;
	UDF_LVD *lvd;
	UDF_FSD *fsd;
	UDF_FE *fe;
	UDF_EFE *efe;
} CDSBUFFER;

typedef struct {
	DCOMMONS c;			// p

	HANDLE	hFile;		// fBXNC[W̃t@Cnh
	DWORD	ReadBpS;	// fBXNC[W̃ZN^TCY
	DWORD	Offset;		// fBXNC[W̃ZN^̃f[^ItZbg

	CDSBUFFER Buffer;	// obt@(2ZN^)

	DWORD	PathTable;	// pXe[ũZN^/RootfBNgZN^

	int		nowleft;	// Gge[u̎c
	DWORD	nowdir;		// Qƒ̃ZN^/NX^
	BYTE	*nowentry;	// Qƒ̃Gg
	int		mode;		// CD_xxx
	DWORD	entryindex;	// ̂index 0:u.v 1:u..v
	DWORD	dataoffset;	// t@C̕ۑʒu(UDFFEɎ̂ƂɎgp)
	BOOL	ReadFileNext; // t@ĈQZN^ڈȍ~ǂݍݒ

	DWORD OffsetDelta; // UDF p
} CDS;

/*=============================================================================
						Plugin DLL ֘A̒` */
//-------------------------------------------------------------- OpenArchive n
//-------------------------------------- DLL 萔
#define ERROR_NOT_SUPPORT		0x8023
#define M_INIT_FILE_USE	0x00000001L	/* WXg̐ݒgp */

//==================================================================== Win32API
#ifdef _SHLOBJ_H_
typedef HRESULT (STDAPICALLTYPE * impOleLoadPicture)(LPSTREAM lpstream,
				LONG lSize, BOOL fRunmode, REFIID riid, LPVOID FAR* lplpvObj);
#endif
typedef ERRORCODE (APIENTRY *DWNETOPENENUM)(DWORD fdwScope, DWORD fdwType, DWORD fdwUsage, LPNETRESOURCE lpNetResource, LPHANDLE lphEnum);
typedef ERRORCODE (APIENTRY *DWNETENUMRESOURCE)(HANDLE hEnum, LPDWORD lpcEntries, LPVOID lpvBuffer, LPDWORD lpcbBuffer);
typedef ERRORCODE (APIENTRY *DWNETCLOSEENUM)(HANDLE hEnum);
typedef ERRORCODE (APIENTRY *DWNETADDCONNECTION3)(HWND hwndOwner, LPNETRESOURCE lpNetResource, LPTSTR lpPassword, LPTSTR lpUserName, DWORD fdwConnectio);
//typedef ERRORCODE (APIENTRY *DWNETCANCELCONNECTION2)(LPTSTR lpszName, DWORD fdwConnection, BOOL fForce);
//typedef ERRORCODE (APIENTRY *DWNETGETCONNECTION)(LPTSTR lpszLocalName, LPTSTR lpszRemoteName, DWORD *lpcchBuffer);

extern DWNETOPENENUM DWNetOpenEnum;
extern DWNETENUMRESOURCE DWNetEnumResource;
extern DWNETCLOSEENUM DWNetCloseEnum;
extern DWNETADDCONNECTION3 DWNetAddConnection3;
//extern DWNETCANCELCONNECTION2 DWNetCancelConnection2;
//extern DWNETGETCONNECTION DWNetGetConnection;
//===================================================================== Func
//------------------------------------------------------------------ vfs_main.c
extern void USEFASTCALL CleanUpVFS(void);

#define CHECKFAT_NONE 0
#define CHECKFAT_FIRST 1
#define CHECKFAT_FAT 1
#define CHECKFAT_EXFAT 2
#define CHECKFAT_NTFS 3
extern int USEFASTCALL CheckFATImage(const BYTE *image, const BYTE *max);

#define GIFA_EXTRACTFILE B0 // unarc / susie gps
#define GIFA_GETIMAGE B1
#define GIFA_IGNORE_ERROR B2
typedef struct {
	HWND hWnd;
	HANDLE hFile; // open ς݂̃t@Cnh
	const TCHAR *ArchiveName;
	const TCHAR *EntryName;
	DWORD *sizeL, *sizeH;
	HGLOBAL *hMap; // GlobalAlloc ̃nh
	BYTE **mem; // GlobalAlloc BGlobalLock ς
	DWORD flags;
} VFSGIFA;
extern ERRORCODE VFSGetArchiveItem(VFSGIFA *gifa);
extern ERRORCODE GetArchiveItemFromTempExtract(VFSGIFA *gifa, TCHAR *ExtractPath, const TCHAR *EntryName, BYTE **mem);

//------------------------------------------------------------------ vfs_arcd.c
extern BOOL CheckAndLoadSusiePlugin(SUSIE_DLL *su, const TCHAR *filename, THREADSTRUCT *ts, DWORD mode);

extern BOOL VFS_check_def(UN_DLL *uD, VUCHECKSTRUCT *vcs);
extern BOOL VFS_check_ARJ(UN_DLL *uD, VUCHECKSTRUCT *vcs);
extern BOOL VFS_check_LHA(UN_DLL *uD, VUCHECKSTRUCT *vcs);
extern BOOL VFS_check_TAR(UN_DLL *uD, VUCHECKSTRUCT *vcs);
extern BOOL VFS_check_CAB(UN_DLL *uD, VUCHECKSTRUCT *vcs);
extern BOOL VFS_check_Rar(UN_DLL *uD, VUCHECKSTRUCT *vcs);
extern BOOL VFS_check_GCA(UN_DLL *uD, VUCHECKSTRUCT *vcs);
extern BOOL VFS_check_ZIP(UN_DLL *uD, VUCHECKSTRUCT *vcs);
extern BOOL VFS_check_7Zip(UN_DLL *uD, VUCHECKSTRUCT *vcs);

#define IsZIPflderFile(header) ((header[0] == 'P') && (header[1] == 'K') && (header[2] < 6) && (header[2] == (header[3] - 1)))
#define IsLZHflderFile(header) ((header[2] == '-') && (header[3] == 'l') && (header[4] == 'h') && (IsdigitA(header[5]) || (header[5] == 'd')) && (header[6] == '-'))
#define IsCABflderFile(header) ((header[0] == 'M') && (header[1] == 'S') && (header[2] == 'C') && (header[3] == 'F') && (*(WORD *)(header + 18) < 0x10))
extern BOOL IsArcfolderFile(const TCHAR *filename, BYTE *header);

extern int DoUnarc(PPXAPPINFO *ppxa, const TCHAR *DllName, HWND hWnd, const TCHAR *param);
extern int UnArc_ExecMain(const UN_DLL *uD, HWND hWnd, const TCHAR *Cmd, PPXAPPINFO *loginfo, HGLOBAL *hMap);
extern int RunUnARCExec(PPXAPPINFO *loginfo, const void *dt_opt, TCHAR *param, const TCHAR *tmppath, HGLOBAL *hMap);

extern BOOL LoadUnDLL(UN_DLL *uD);
extern void GetPackMenu(HMENU hMenuDest, ThSTRUCT *thMenuData, DWORD *PopupID);
extern BOOL FindPackType(const TCHAR *dllname, TCHAR *arcname, TCHAR *arccommand);
extern BOOL UnArc_IsReady(const UN_DLL *uD);

//------------------------------------------------------------------ vfs_fchk.c
extern char *usertypes;

#define WinZipTag "_winzip_"
#define WinZipTagSize 8
#define WinZipTagOffset1 0x198
#define WinZipTagOffset2 0x1e8
#define WinZipTagOffsetMAX 0x200
#define ResZipCheckSize 0x300
extern DWORD CheckResZip(const BYTE *header);

//------------------------------------------------------------------ vfs_fop.c
extern TCHAR *MakeFOPlistFromPPx(PPXAPPINFO *info/*, int flag*/);
extern TCHAR *MakeFOPlistFromParam(const TCHAR *param, const TCHAR *path, DWORD *fopflags);

//------------------------------------------------------------------ vfs_ffp.c
extern BOOL LoadNetFunctions(void);
extern BOOL CheckComputerActive(const TCHAR *fname, size_t strsize);

//------------------------------------------------------------------ vfs_ffsh.c
#ifdef _SHLOBJ_H_
extern ERRORCODE VFPtoIShellSub(HWND hWnd, const TCHAR *vpath, int mode, LPSHELLFOLDER *nSF, LPITEMIDLIST *nIDL, DWORD *dirflags, LPMALLOC *nMA);
extern LPITEMIDLIST CatPidl(LPMALLOC piMalloc, LPCITEMIDLIST idl1, LPCITEMIDLIST idl2);
#endif
//------------------------------------------------------------------ vfs_lapi.c
extern BOOL CreateDirectoryExL(const TCHAR *FileName, const TCHAR *FileName2, LPSECURITY_ATTRIBUTES sa);

TypedefWinAPI(HANDLE, FindFirstFile, (const TCHAR *lpFileName, WIN32_FIND_DATA *FindFileData));
extern impFindFirstFile DFindFirstFile;
HANDLE WINAPI LoadFindFirstFile(const TCHAR *lpFileName, WIN32_FIND_DATA *FindFileData);

extern BOOL RemoveDirectoryExtra(const TCHAR *path);
extern BOOL DeleteFileExtra(const TCHAR *path);

//------------------------------------------------------------------ vfs_lf.c
extern void ReadFileTime(const TCHAR **ptr, FILETIME *ft);

//------------------------------------------------------------------ vfs_oimg.c
extern BOOL NotifyFileSize(HANDLE hFile, DWORD sizeL, DWORD sizeH);

//------------------------------------------------------------------ vfs_olnk.c
extern ERRORCODE FOPMakeShortCut(const TCHAR *src, TCHAR *dst, BOOL directory, BOOL test);

//------------------------------------------------------------------ vfs_path.c
extern BOOL IsRelativeDirectory(const TCHAR *path);
extern BOOL IsParentDirectory(const TCHAR *path);
extern TCHAR *FindLastEntryPoint(const TCHAR *src);
extern TCHAR *SplitAuxName(const TCHAR *AuxPath, TCHAR *dest);
#ifdef _SHLOBJ_H_
extern void GetIDLSub(TCHAR *path, LPSHELLFOLDER pSF, LPITEMIDLIST pSHidl);
#endif

//------------------------------------------------------------------ vfs_cd.c
extern BOOL OpenCDImage(CDS *cds, const TCHAR *fname, int offset);
extern BOOL FindEntryCDImage(CDS *cds, const TCHAR *fname, WIN32_FIND_DATA *ff);
extern void CloseCDImage(CDS *cds);
extern DWORD ReadCDCluster(CDS *cds, BYTE *dest, DWORD destsize);
extern BOOL SetCDNextCluster(CDS *cds);

//------------------------------------------------------------------ vfs_fat.c
extern BOOL OpenFATImage(FATSTRUCT *fats, const TCHAR *fname, int offset);
extern void CloseFATImage(FATSTRUCT *fats);
extern BOOL FindEntryFATImage(FATSTRUCT *fats, TCHAR *fname, WIN32_FIND_DATA *ff);
extern DWORD ReadFATCluster(FATSTRUCT *fats, BYTE *dest, DWORD destsize);
extern BOOL SetFATNextCluster(FATSTRUCT *fats);
extern DWORD GetPC9801FirstDriveSector(const BYTE *header);

//------------------------------------------------------------------ vfs_shn.c
#ifdef _SHLOBJ_H_
extern LPITEMIDLIST DupIdl(LPMALLOC pMA, LPCITEMIDLIST pIDL);
extern void FreePIDLS(LPITEMIDLIST *pidls, int cnt);
extern BOOL CopyToDropTarget(IDataObject *DataObject, IDropTarget *DropTarget, BOOL droptype, HWND hTargetWnd, DWORD alloweffect);
extern int MakePIDLTableFromFileZ(const TCHAR *srcdir, const TCHAR *fileZs, LPITEMIDLIST **pidls, LPSHELLFOLDER *pSF);
#endif

#define AUXOP_SYNC B0
#define AUXOP_ASYNC 0
extern ERRORCODE AuxOperation(PPXAPPINFO *ParentInfo, const TCHAR *id, TCHAR *AuxPath, const TCHAR *src, const TCHAR *dst, TCHAR *resulttext, int flags);
extern ERRORCODE AuxFileOperation(const TCHAR *id, const TCHAR *AuxPath, const TCHAR *src, const TCHAR *dst);
extern void FolderNotifyToShell(LONG id, const TCHAR *item1, const TCHAR *item2);

//---------------------------------------------------------------- vfs_shnp.cpp
#ifdef _SHLOBJ_H_
typedef struct {
	HMODULE hDLL;		// zipfldr.dll
	LPSTORAGE pST;
	LPSHELLFOLDER pSF;
	HRESULT ComInitResult;
} ZIPFOLDERSTRUCT;

extern ERRORCODE GetZipFolderItem(VFSGIFA *gifa, const TCHAR *ArchiveName, const TCHAR *EntryName, BYTE **mem, int type, int flags);

#endif

#ifndef __ITaskbarList3_INTERFACE_DEFINED__
typedef enum TBPFLAG {
	TBPF_NOPROGRESS	= 0,
	TBPF_INDETERMINATE	= 0x1,
	TBPF_NORMAL	= 0x2,
	TBPF_ERROR	= 0x4,
	TBPF_PAUSED	= 0x8
} TBPFLAG;
#endif

extern void SetTaskBarButtonProgress(HWND hWnd, int nowcount, int maxcount);
extern void InitTaskBarButtonIF(WPARAM wParam);
extern void * GetPathInterface(HWND hWnd, const TCHAR *name, REFIID riid, const TCHAR *path);
extern void SetTreeColor(HWND hTWnd);
//=============================================================================
#ifndef GLOBALDEFINE
	#define GVAR extern
	#define GPARAM(x)
#else
	#undef GVAR
	#undef GPARAM
	#define GVAR
	#define GPARAM(x) = x
#endif


GVAR int VfsMode GPARAM(0);	// VFS ̓
GVAR CRITICAL_SECTION ArchiveSection[2];	// A[JCõXbhZ[tp
										// 0:UnDLL , 1:Susie
GVAR volatile int ArchiverUse GPARAM(0);	// A[JCo̎gpmF

GVAR const TCHAR StrShellScheme[6+1] GPARAM(T("shell:"));
GVAR const TCHAR zipfldrName[] GPARAM(VFS_TYPEID_zipfldr); // CompressedFolder WinXP`
GVAR const TCHAR lzhfldrName[] GPARAM(VFS_TYPEID_lzhfldr); // LzhCompressedFolder2 Win7-10
GVAR const TCHAR cabfldrName[] GPARAM(VFS_TYPEID_cabfldr); // CABFolder WinXP`
#define arcfldrName zipfldrName // ArchiveFolder(zipfldr.dll + archiveint.dll) Win11
GVAR const TCHAR arcfolderID[] GPARAM(VFS_TYPEID_arcfolder); // arcfolderName ̒ڎwp
GVAR const TCHAR RPATHSTR[] GPARAM(T("RemotePath"));

//--------------------------------------------------------------------- UnDLL
GVAR BOOL useundll GPARAM(FALSE);
GVAR int undll_items GPARAM(0);			// 
GVAR UN_DLL *undll_list GPARAM(NULL);	// 
#ifdef UNICODE
GVAR UINT UnDllCodepage GPARAM(CP_ACP);
#endif
//--------------------------------------------------------------------- Susie
GVAR BOOL usesusie GPARAM(FALSE);
GVAR int susie_items GPARAM(0);		// SUSIE plug-in ̐
GVAR SUSIE_DLL *susie_list GPARAM(NULL);	// SUSIE plug-in 
GVAR TCHAR susiedir[VFPS];
GVAR ThSTRUCT Thsusie, Thsusie_str;

//---------------------------------------------------------------------
GVAR HMODULE hMPR	 GPARAM(NULL);
GVAR HMODULE hWininet GPARAM(NULL);

#ifdef _SHLOBJ_H_
GVAR HMODULE hOLEPRO32 GPARAM(NULL);
GVAR ValueWinAPI(OleLoadPicture) GPARAM(NULL);
#endif

GVAR ValueWinAPI(InternetCloseHandle);
GVAR ValueWinAPI(FtpGetFile);
GVAR ValueWinAPI(FtpPutFile);
GVAR ValueWinAPI(FtpCreateDirectory);
GVAR ValueWinAPI(FtpRemoveDirectory);
GVAR ValueWinAPI(FtpRenameFile);
GVAR ValueWinAPI(FtpDeleteFile);
GVAR ValueWinAPI(FtpFindFirstFile);
GVAR ValueWinAPI(InternetFindNextFile);
GVAR ValueWinAPI(FtpSetCurrentDirectory);

#ifdef __cplusplus
}
#endif
