/*-----------------------------------------------------------------------------
	Paper Plane xUI	 Virtual File System		t@C,OtB^
-----------------------------------------------------------------------------*/
#define ONVFSDLL		// VFS.H  DLL export w
#include "WINAPI.H"
#include "WINOLE.H"
#include "PPX.H"
#include "VFS.H"
#include "PPD_DEF.H"
#include "VFS_STRU.H"
#include "VFS_FOP.H"
#pragma hdrstop

const TCHAR TagStr[] = T("` ");
const TCHAR HeaderTagStr1[] = T("߰ ");
const TCHAR HeaderTagStr2[] = T("Rs[ ");
const TCHAR HeaderTagStr3[] = T("Copy of ");
const TCHAR FooterTagStr1[] = T(" - Rs[");

TCHAR *RenameFilter(TCHAR *dest, TCHAR *src, TCHAR *format, TCHAR *formatlast, BOOL *UseRenum)
{
	while ( format < formatlast ){
		switch( *format ){
			case '?':
				format++;
				if ( *src != '\0' ){
					#ifndef UNICODE
						if ( IskanjiA(*src) ) *dest++ = *src++;
					#endif
					*dest++ = *src++;
				}
				break;
			case '*':
				format++;
				while ( *src != '\0' ) *dest++ = *src++;
				break;
			case RENAME_NUMBERING:
				*UseRenum = TRUE;
				// break ȗ
			default:
				#ifndef UNICODE
					if ( IskanjiA(*format) ) *dest++ = *format++;
				#endif
				*dest++ = *format++;
				if ( *src != '\0' ){
					#ifndef UNICODE
					if ( IskanjiA(*src) ) src++;
					#endif
					src++;
				}
		}
	}
	return dest;
}

TCHAR *BktNum(TCHAR *srcptr, TCHAR bk_l, TCHAR bk_r)
{
	if ( *srcptr != bk_l ) return NULL;
	srcptr++;
	while ( Isdigit(*srcptr) ) srcptr++;
	if ( *srcptr != bk_r ) return NULL;
	return srcptr + 1;
}

int DeleteHeadTag(TCHAR *name, const TCHAR *tag, size_t taglen)
{
	TCHAR *src, *bkptr;

	if ( memcmp(name, tag, TSTROFF(taglen)) ) return 0;
	src = name + taglen;
	bkptr = BktNum(src, '(', ')');
	if ( (bkptr != NULL) && (*bkptr == ' ') ) src = bkptr + 1;
	if ( !memcmp(src, TagStr, SIZEOFTSTR(TagStr)) ) src += TSIZEOF(TagStr) - 1;
	tstrcpy(name, src);
	return 1;
}

int DeleteFootTag(TCHAR *name, const TCHAR *tag, size_t taglen)
{
	TCHAR *ptr;
	size_t len;

	len = tstrlen(name);
	if ( len <= taglen ) return 0;

	ptr = VFSFindLastEntry(name);
	ptr = tstrrchr(ptr, '.');
	if ( ptr == NULL ){
		ptr = name + len;
	}

	if ( memcmp((char *)(TCHAR *)(ptr - taglen), tag, TSTROFF(taglen)) ){
		return 0;
	}
	tstrcpy(ptr - taglen, ptr);
	return 1;
}

ERRORCODE LFNfilter(struct FopOption *opt, TCHAR *src, DWORD attributes)
{
	TCHAR *name, *extptr;
	TCHAR orgname[MAX_PATH], orgext[MAX_PATH];

	if ( opt->UseNameFilter & NameFilter_Use ){
		BOOL UseRenum = FALSE;

		name = FindLastEntryPoint(src);
		if ( attributes & FILE_ATTRIBUTE_DIRECTORY ){
			extptr = name + tstrlen(name);
		}else{
			extptr = name + FindExtSeparator(name);
		}
		tstrcpy(orgext, extptr);
		// Rename
		if ( opt->UseNameFilter & NameFilter_Rename ){
			if ( opt->rexps != NULL ){	// K\ɂH
				if ( opt->fop.filter & VFSFOP_FILTER_NOEXTFILTER ){
					*extptr = '\0';
				}
				if ( RegularExpressionReplace(opt->rexps, name, name, VFPS - (name - src) ) == NULL ){
					return ERROR_CANCELLED;
				}
				if ( opt->fop.filter & VFSFOP_FILTER_NOEXTFILTER ){
					tstrcat(name, orgext);
				}
				if ( FindPathSeparator(src) != NULL ) UseRenum = TRUE; // RENAME_NUMBERING
			}else if ( opt->UseNameFilter & NameFilter_ExtractName ){ // }NWJ
				FILENAMEINFOSTRUCT finfo;
				const TCHAR *format;

				if ( opt->fop.filter & VFSFOP_FILTER_NOEXTFILTER ){
					*extptr = '\0';
				}
				finfo.info.Function = (PPXAPPINFOFUNCTION)FilenameInfoFunc;
				finfo.info.Name = STR_FOP;
				finfo.info.RegID = NilStr;
				finfo.filename = src;
				format = opt->rename;
				if ( opt->rename[0] == RENAME_EXTRACTNAME ) format++;
				if ( NO_ERROR != PP_ExtractMacro(NULL, &finfo.info, NULL, format, name, XEO_NOEDIT | XEO_EXTRACTEXEC) ){
					return ERROR_CANCELLED;
				}
				if ( opt->fop.filter & VFSFOP_FILTER_NOEXTFILTER ){
					tstrcat(name, orgext);
				}
				if ( FindPathSeparator(src) != NULL ) UseRenum = TRUE; // RENAME_NUMBERING
			}else {	// ChJ[hɂH
				TCHAR *tailptr;
												// Split
				memcpy(orgname, name, TSTROFF(extptr - name));
				orgname[extptr - name] = '\0';

				// t@C
				extptr = opt->rename + FindExtSeparator(opt->rename);
				tailptr = RenameFilter(name, orgname, opt->rename, extptr, &UseRenum);
				// gq
				if ( *extptr != '\0' ){
					tailptr = RenameFilter(tailptr, orgext, extptr, extptr + tstrlen(extptr), &UseRenum);
					*tailptr = '\0';
				}else{
					tstrcpy(tailptr, orgext);
				}
			}
		}
		if ( opt->fop.delspc ){ // 󔒓폜
			TCHAR *ptr, *dest, chr;

			ptr = dest = name;
			for (;;){
				chr = *ptr;
				if ( chr == '\0' ) break;
				switch( chr ){
					case '\"':
					case '\'':
					case '*':
					case '/':
					case ':':
					case '<':
					case '>':
					case '?':
					case '\\':
					case '|':
						break;
					case ' ':
					case ',':
					case ';':
						if ( opt->fop.delspc < BST_INDETERMINATE ) break;
						// default 
					default:
						*dest++ = chr;
#ifndef UNICODE
						if ( IskanjiA(chr) ){
							chr = *(ptr + 1);
							if ( chr != '\0' ) *dest++ = chr;
						}
#endif
				}
				ptr++;
			}
			*dest = '\0';
		}
		if ( opt->fop.filter & VFSFOP_FILTER_DELNUM ){ // Aԍ폜
			int done = 0;

			for ( ; ; ){
				if ( DeleteHeadTag(name, HeaderTagStr1, TSIZEOF(HeaderTagStr1) - 1) ||
					 DeleteHeadTag(name, HeaderTagStr2, TSIZEOF(HeaderTagStr2) - 1) ||
					 DeleteHeadTag(name, HeaderTagStr3, TSIZEOF(HeaderTagStr3) - 1) ||
					 DeleteFootTag(name, FooterTagStr1, TSIZEOF(FooterTagStr1) - 1)){
					done = 1;
					continue;
				}
				break;
			}
			if ( !done ){
				TCHAR *orgext;
				TCHAR *p, *q C4701CHECK;
													// Split
				p = name;
				orgext = name + FindExtSeparator(name);
				while ( p < orgext ){
					if ( (*p == '-') || (*p == '_') ){
						q = p + 1;
						if ( Isdigit(*q) ){
							q++;
							while ( Isdigit(*q) ) q++;
							if ( q == orgext ){
								done = 1;
								break;
							}
						}
					}
					q = BktNum(p, '(', ')');
					if ( q == orgext ){
						done = 1;
						break;
					}
					q = BktNum(p, '[', ']');
					if ( q == orgext ){
						done = 1;
						break;
					}
				#ifdef UNICODE
					p++;
				#else
					p += Chrlen(*p);
				#endif
				}
				if ( done ){ // C4701ok
					while( *q ) *p++ = *q++;
					*p = 0;
				}
			}
		}

		if ( IsTrue(UseRenum) ){ // A
			TCHAR buf[VFPS], *bsrc, *dst, *p;
			int cy = 1;

			tstrcpy(buf, name);
			bsrc = buf;
			dst = name;
			for ( ; ; ){
				p = FindPathSeparator(bsrc); // RENAME_NUMBERING
				if ( p == NULL ){
					tstrcpy(dst, bsrc);
					break;
				}
				memcpy(dst, bsrc, TSTROFF(p - bsrc));
				dst += p - bsrc;
				bsrc = p + 1;
				tstrcpy(dst, opt->renum);
				dst += tstrlen(dst);
			}
												// Inc
			p = opt->renum + tstrlen(opt->renum);
			while ( p > opt->renum ){
				p--;
				*p += (TCHAR)cy;
				if ( (UTCHAR)*p > (UTCHAR)'9' ){
					*p = '0';
					cy = 1;
				}else{
					cy = 0;
				}
			}
			if ( cy ){
				memmove(opt->renum + 1, opt->renum, TSTRSIZE(opt->renum));
				opt->renum[0] = '1';
			}
		}

		if ( opt->fop.sfn ){ // 8.3
			TCHAR *p, *q;
			DWORD i, e;

			p = name;
			e = FindExtSeparator(p);			// t@C8
			q = p + e;
			if ( e <= 8 ){
				p = q;
			}else{
				i = 0;
				while( i < 8 ){
					#ifndef UNICODE
						if ( IskanjiA(*p++) ){
							if ( i >= 7 ){
								p--;
								break;
							}
							p++;
							i++;
						}
					#else
						p++;
					#endif
					i++;
				}
			}									// gq3(.܂߂4)
			e = tstrlen32(q);
			if ( e <= 4 ){
				tstrcpy(p, q);
			}else{
				i = 0;
				while( i < 4 ){
					#ifndef UNICODE
						if ( IskanjiA(*p++ = *q++) ){
							if ( i >= 3 ) break;
							*p++ = *q++;
							i++;
						}
					#else
						*p++ = *q++;
					#endif
					i++;
				}
				*p = '\0';
			}
		}
		if ( opt->fop.chrcase != 0 ){
			if ( opt->fop.chrcase == 1 ){
				CharUpper(src); // 啶
			}else{ // if ( opt->fop.chrcase == 2 )
				CharLower(src); // 
			}
		}
	}else{
		name = src;
	}
	// ̋󔒁EsIh
	{
		TCHAR *ptr;

		ptr = name + tstrlen(name);
		while ( ptr > name ){
			ptr--;
			if ( (*ptr != ' ') && (*ptr != '.') ) break;
			*ptr = '\0';
		}
	}
	return NO_ERROR;
}
