/*-----------------------------------------------------------------------------
	Paper Plane xUI									` PPc, PPvp `
-----------------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif

#define MOUSE_LONG_PUSH_TIME 1100

#define MOUSEBUTTONMASK 0xfff3
#define MOUSEMODE_PUSH 0
#define MOUSEMODE_DRAG 1
#define MOUSEMODE_NONE 2
#define MOUSEBUTTON_CANCEL_DOUBLE -1
#define MOUSEBUTTON_CANCEL 0
#define MOUSEBUTTON_L 1 // VK_LBUTTON
#define MOUSEBUTTON_R 2 // VK_RBUTTON
#define MOUSEBUTTON_M 3 // VK_MBUTTON - 1
#define MOUSEBUTTON_W 4
#define MOUSEBUTTON_X 5 // VK_XBUTTON
#define MOUSEBUTTON_Y 6 // VK_YBUTTON
#define MOUSEBUTTON_Z 7
#define MOUSEBUTTON_ETC 8

#define MBtoVK(button) ((button != MOUSEBUTTON_M) ? button : VK_MBUTTON)

#define MAXGESTURES	30	// WFX`[̍őR}h
#define GESTURETEXTSIZE	(MAXGESTURES * 2 + 32)

typedef struct {
	POINT PushScreenPoint;	// {^Ƃ̃XN[W
	POINT PushClientPoint;	// {^Ƃ̃NCAgW
	POINT MovedClientPoint;	// ŐṼhbÕNCAgW
	POINT MovedScreenPoint;	// ŐṼhbÕXN[W
	SIZE MovedOffset;		// ŐṼhbOړ
	RECT DDRect;			// hbOJno͈
	int mode;				// hbO/ MOUSEMODE_
	int PushButton;			// Lȃ{^ MOUSEBUTTON_
	DWORD PushTick;			// {^ƂTick
	int WheelDelta;			// zC[ړ
	struct {
		int count;	// ̓R}h
		TCHAR step[MAXGESTURES];	// R}h͈ꗗ
	} gesture;
} MOUSESTATE;

#define CF_DIBV5 17

typedef struct {
	HDC hOffScreenDC;  // zDC
	BYTE *DCBitsPtr;  // hOffScreenDC őIĂbitmapbits
	HBITMAP hOldBitmap; // hOffScreenDCɊ蓖ĂĂbitmap
	HTBMP X_WPbmp;
	int X_WallpaperType;
	DIRECTXDEFINE(DXBMPCACHE *WPbmpCache)
} BGSTRUCT;

typedef struct {
	int item;		// 
	int width;		// ڂ̕(ڊԂ̋󔒂P܂)
	char **data;	// e
} HIDDENMENUS;
extern void LoadHiddenMenu(HIDDENMENUS *hms, const TCHAR *name, HANDLE heap, COLORREF mes);
#define HiddenMenu_Color(base, name) (COLORREF *)(char *)((char *)(base) + (namelen) * sizeof(TCHAR) + sizeof(TCHAR))
#define HiddenMenu_ColorF 0
#define HiddenMenu_ColorB 1

extern const TCHAR DwmapiName[];
extern HMODULE hDwmapi;

extern BOOL X_awhel;

extern BOOL RecvExecuteByWMCopyData(PPXAPPINFO *info, COPYDATASTRUCT *copydata);
extern void AutoColor(const TCHAR *str, COLORREF *clr, int def);
// 񑀍
extern TCHAR USEFASTCALL upper(TCHAR c);
extern void GetClipboardTypeName(TCHAR *str, UINT cliptype);
// }EX
extern const TCHAR PPxMouseButtonChar[];
extern int CheckXMouseButton(WPARAM wParam);
extern void PPxInitMouseButton(MOUSESTATE *ms);
extern void PPxCancelMouseButton(MOUSESTATE *ms);
extern int PPxGetMouseButtonDownInfo(MOUSESTATE *ms, HWND hWnd, DWORD button, LPARAM lParam);
extern int PPxDownMouseButton(MOUSESTATE *ms, HWND hWnd, WPARAM wParam, LPARAM lParam);
extern int PPxUpMouseButton(MOUSESTATE *ms, WPARAM wParam);
extern int PPxDoubleClickMouseButton(MOUSESTATE *ms, HWND hWnd, WPARAM wParam, LPARAM lParam);
extern BOOL PPxMoveMouse(MOUSESTATE *ms, HWND hWnd, LPARAM lParam);
extern BOOL PPxCheckMouseGesture(MOUSESTATE *stat, TCHAR *textbuf, const TCHAR *keyname);

extern int PPxWheelMouse(MOUSESTATE *ms, HWND hWnd, WPARAM wParam, LPARAM lParam);
// L[
extern WORD FixCharKeycode(WORD key);

// wi摜
extern void LoadWallpaper(BGSTRUCT *bg, HWND hWnd, const TCHAR *regid);
extern void UnloadWallpaper(BGSTRUCT *bg);
extern void DrawWallPaper(DIRECTXARG(DXDRAWSTRUCT *DxDraw) BGSTRUCT *bg, HWND hWnd, PAINTSTRUCT *ps, int Areax);

extern void InitOffScreen(BGSTRUCT *bg, HDC hWndDC, SIZE *WndSize);
extern void OffScreenToScreen(BGSTRUCT *bg, HWND hWnd, HDC hWndDC, RECT *WndRect, SIZE *WndSize);
extern void FreeOffScreen(BGSTRUCT *bg);

extern int PreviewCommand(BGSTRUCT *bg, const TCHAR *param, const TCHAR *path);
extern DWORD CalcBmpHeaderSize(BITMAPINFOHEADER *dumpdata);

// j[
extern void USEFASTCALL AppendMenuString(HMENU hMenu, UINT id, const TCHAR *string);
extern void USEFASTCALL AppendMenuCheckString(HMENU hMenu, UINT id, const TCHAR *string, BOOL check);

// FillRect u
extern void FillBox(HDC hDC, const RECT *box, HBRUSH hbr);

extern int GetAndFixTextMetrics(HDC hDC, TEXTMETRIC *tm);

#ifdef __cplusplus
}
#endif
