/*-----------------------------------------------------------------------------
	Paper Plane vUI												Open
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include "PPX.H"
#include "WINAPIIO.H"
#include "VFS.H"
#include "PPX_64.H"
#include "PPV_STRU.H"
#include "PPV_FUNC.H"
#pragma hdrstop

#define COUNTREADTIME 0
#define FILEBUFMARGIN 1024

const DWORD Palette16[16] = { // Raw Image pftHgpbg
	0x000000, 0x800000, 0x008000, 0x808000,
	0x000080, 0x800080, 0x008080, 0x808080,
	0xc0c0c0, 0xff0000, 0x00ff00, 0xffff00,
	0x0000ff, 0xff00ff, 0x00ffff, 0xffffff
};

#pragma pack(push, 1)
// EMF/RawImage/OS/2p DIB(̂Imۂɂ)
struct {
	BITMAPINFOHEADER bmiHeader;
	DWORD bmiColors[256];
} temp_DIB;
#pragma pack(pop)
BITMAPINFOHEADER *temp_DIB_ptr = NULL;

// obNOEhsvZ ----------------------
#define READINTERVAL_FILEREAD  ((TIME_READLINE * 5) / 16)
#define READINTERVAL_LINECOUNT ((TIME_READLINE * 10) / 16)

int CountReadLines = READLINE_TIMER;
int ReadDisp = 0;
DWORD ReadStep;
int ReadEnter = 0;

const TCHAR *runasstate = NULL;
// ----------------------
int X_llsizTable[] = { 0, IDNO, IDYES, IDCANCEL };

void LoadEvent(void);
void CheckType(void);

BOOL ReadFileBreakCheck(void);
void CALLBACK AnimateProc(HWND hWnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime);

#if COUNTREADTIME
 DWORD readstartTick;
#endif

typedef struct {
	int page;	// \y[W
	DWORD timer;
	size_t headersize;
	size_t offset;
	size_t size;
	size_t optionoffset;
	POINT dispoffset;
	int trans;
} GETPAGESTRUCT;

// GIF ------------------------------------------------------------------------
#pragma pack(push, 1)
typedef struct {
	BYTE ID[6];			//+0 GID87a/GIF89a
	WORD width, height;	//+6, 8
	BYTE flag;		//+10 B7:Palette B6-4:Dot size B3:sort B2-0:Palette size
	BYTE Tindex;	//+11 F index
	BYTE aspect;	//+12 䗦
	BYTE palette[];	//+13 pbg
} GIFHEADER;

typedef struct {
	BYTE ID;			//+0 GIFHEADER_IMAGEBLOCKID
	WORD left, top;		//+1, 3
	WORD width, height;	//+5, 7
	BYTE flag;		//+9 B7:Palette B6:Interlace B5:sort B4-3:unuse B2-0:Palette size
	BYTE palette[];	//+10 pbg
//	BYTE LZHsize;
} GIFIMAGEHEADER;

typedef struct {
	BYTE size;			//+0   (4)
	BYTE flags;			//+1 GIFCONTROLHEADER_xxx
	WORD time;			//+2, 3
	BYTE trans;			//+4 ߐFpbg
} GIFCONTROLHEADER;
#pragma pack(pop)

#define GIFHEADER_FLAG_USEPALETTE B7
#define GIFHEADERGETPALETTE(flag) ((2 << (flag & 7)) * 3)
#define GIFHEADER_IMAGEBLOCKID 0x2c
#define GIFHEADER_EXTENSIONID 0x21
#define GIFHEADER_EXTENSION_CONTROL 0xf9
#define GIFHEADER_ENDID 0x3b
#define GIFCONTROLHEADER_TRANSPARENT B0
#define GIFCONTROLHEADER_USERINPUT B1
#define GIFCONTROLHEADER_DRAW_MASK (B2 | B3 | B4)
#define GIFCONTROLHEADER_DRAW_OVER B2
#define GIFCONTROLHEADER_DRAW_BG B3
#define GIFCONTROLHEADER_DRAW_BACK (B2 | B3)

// PNG ------------------------------------------------------------------------
#pragma pack(push, 1)
typedef struct {
	BYTE header[8]; // 0x89 PNG 0x0d 0x0a 0x1a 0x0a
	BYTE IHDR[8]; // 0 0 0 0x0d IHDR
	DWORD width;
	DWORD height;
	BYTE bits;
	BYTE colorflags;
	BYTE alg;
	BYTE filter;
	BYTE interla;
	DWORD CRC;
} PNGheader;

typedef struct {
	DWORD length;
	DWORD id;
} PNGchunk;

typedef struct {
	PNGchunk chunk;
	DWORD frames;
	DWORD loops;
} PNG_AnimationControl_chunk;

typedef struct {
	PNGchunk pc;
	DWORD sequence_number;
	DWORD width;
	DWORD height;
	DWORD x_offset;
	DWORD y_offset;
	WORD delay_num;
	WORD delay_den;
	BYTE dispose_op;
	BYTE blend_op;
} PNGFrameControlStruct;

typedef struct {
	PNGchunk pc;
	BYTE r1, red, g1, green, b1, blue;
} PNGBackGroundStruct;

#define SizeOfPNGcrc 4
#define SizeOfPNGframes 4
#define SizeOfPNGid 4
#define SizeOfPNGchunks (sizeof(PNGchunk) + SizeOfPNGcrc)
#define PNG_IDAT 0x54414449
#define PNG_tRNS 0x534e5274
#define PNG_bKGD 0x44474b62
#define PNG_acTL 0x4c546361
#define PNG_fdAT 0x54416466
#define PNG_fcTL 0x4c546366
#define APNG_DISPOSE_OP_NONE 0
#define APNG_DISPOSE_OP_BACKGROUND 1
#define APNG_DISPOSE_OP_PREVIOUS 2
#define APNG_BLEND_OP_SOURCE 0
#define APNG_BLEND_OP_OVER 1
#pragma pack(pop)

PreFrameInfoStruct PreFrameInfo = { PreFramePage_NoCheck , {0, 0} , {0, 0} , NULL, 0, 0 };

void SetAllTextCode(int codetype)
{
	VO_I[DISPT_HEX].textC = VO_I[DISPT_TEXT].textC = VO_I[DISPT_DOCUMENT].textC = codetype;
}

void SetOtherCodepage(UINT newcp)
{
	ChangeOtherCodepage(newcp);
	SetAllTextCode(VTYPE_OTHER);
}

void InitRawImageRectSize(void)
{
	vo_.bitmap.rawsize.cx = RawBmpWidth;
	if ( vo_.bitmap.rawsize.cx <= 0 ) vo_.bitmap.rawsize.cx = 1;
	vo_.bitmap.rawsize.cy = 1;
	if ( vo_.bitmap.ShowInfo->biBitCount ){
		DWORD imagesize = vo_.file.UseSize;
		DWORD linesize = DwordBitSize(vo_.bitmap.rawsize.cx * vo_.bitmap.ShowInfo->biBitCount);

		if ( linesize > imagesize ){
			vo_.bitmap.rawsize.cx = imagesize / vo_.bitmap.ShowInfo->biBitCount;
			linesize = DwordBitSize(vo_.bitmap.rawsize.cx * vo_.bitmap.ShowInfo->biBitCount);
		}
		if ( (RawBmpOffset < 0) || ((linesize + RawBmpOffset) > imagesize) ){
			RawBmpOffset = 0;
		}
		imagesize -= RawBmpOffset;
		vo_.bitmap.bits.ptr = vo_.file.image + RawBmpOffset;

		if ( imagesize < linesize ){ // 1sȂ
			vo_.bitmap.rawsize.cx = (vo_.bitmap.rawsize.cx * 8) / (vo_.bitmap.ShowInfo->biBitCount);
		}else{
			vo_.bitmap.rawsize.cy = imagesize / linesize;
		}
		vo_.bitmap.ShowInfo->biWidth = vo_.bitmap.rawsize.cx;
		vo_.bitmap.ShowInfo->biHeight = vo_.bitmap.rawsize.cy;
		vo_.bitmap.showsize = vo_.bitmap.rawsize;
		vo_.bitmap.info->biSizeImage = DwordBitSize(vo_.bitmap.rawsize.cx * vo_.bitmap.ShowInfo->biBitCount) * vo_.bitmap.rawsize.cy;
	}
	VOi->defwidth = vo_.bitmap.rawsize.cx;
}

// TIFF ----------------------------------------------------------------------
#pragma pack(push, 1)
typedef struct {
	WORD tag;
	WORD type;
	DWORD count, offset;
} IFD;
#pragma pack(pop)

// ------------------------------------------------------------------------

DWORD USEFASTCALL GetBigEndDWORD(void *ptr)
{
	DWORD value;

	value = *(DWORD *)ptr;
	return	(value << 24) |
			((value & 0xff00) << 8) |
			((value >> 8) & 0xff00) |
			(value >> 24);
}

DWORD USEFASTCALL GetLittleEndDWORD(void *ptr)
{
	return *(DWORD *)ptr;
}

typedef DWORD (USEFASTCALL * GetDWORDfunc)(void *ptr);

WORD USEFASTCALL GetBigEndWORD(void *ptr)
{
	WORD value;

	value = *(WORD *)ptr;
	return	(WORD)((WORD)(value >> 8) | (WORD)(value << 8));
}

WORD USEFASTCALL GetLittleEndWORD(void *ptr)
{
	return *(WORD *)ptr;
}

typedef WORD (USEFASTCALL * GetWORDfunc)(void *ptr);

void USEFASTCALL SetBigEndDWORD(BYTE *ptr, DWORD value)
{
	*(DWORD *)ptr =
		(value << 24) |
		((value & 0xff00) << 8) |
		((value & 0xff0000) >> 8) |
		(value >> 24);
}

void InitPNG(GETPAGESTRUCT *gpage)
{
	size_t offset = sizeof(PNGheader);
	int page = 0, frames = 0;
	BOOL findfcTL = FALSE;
	DWORD timer = 1000;

#ifdef _WIN64
	if ( vo_.file.UseSize > ((DWORD)3 * GB) ) return;
#endif
	if ( gpage != NULL ){
		gpage->headersize = offset;
		gpage->timer = 1000;
		gpage->dispoffset.x = 0;
		gpage->dispoffset.y = 0;
		gpage->trans = -1;
		gpage->offset = 0;
		gpage->optionoffset = 0;
		page = gpage->page;
	}

	while( vo_.file.UseSize > offset ){
		PNGchunk *pc;

		pc = (PNGchunk *)(vo_.file.image + offset);
		if ( pc->id == PNG_acTL ){ // acTL t[
			if ( gpage == NULL ){
				frames = GetBigEndDWORD(&((PNG_AnimationControl_chunk *)pc)->frames);
			}
		}else if ( pc->id == PNG_IDAT ){ // rbg}bv
			if ( gpage != NULL ){
				if ( gpage->offset == 0 ){
					gpage->offset = offset;

					if ( findfcTL == FALSE ){
						if ( page == 0 ) return;
						page--;
						findfcTL = TRUE;
					}
				}
			}else{
				if ( (findfcTL == FALSE) && frames ){
					frames++;
					findfcTL = TRUE;
				}
			}
		}else if ( pc->id == PNG_tRNS ){ // tRNS ߏ
			if ( ((PNGheader *)vo_.file.image)->colorflags == 3 ){
				int colorlen, colorindex;
				BYTE *alpha, alphamax;

				// ԓߓxႢpbg𓧖Fɂ
				alpha = (BYTE *)(pc + 1);
				alphamax = 0x40;
				colorlen = GetBigEndDWORD(&pc->length);
				for ( colorindex = 0 ; colorindex < colorlen ; colorindex++, alpha++){
					if ( *alpha < alphamax ){
						alphamax = *alpha;
						vo_.bitmap.transcolor = colorindex;
					}
				}
			}
		}else if ( pc->id == PNG_bKGD ){ // bKGD wiF
			if ( gpage != NULL ){
				gpage->trans = -2;
				if ( GetBigEndDWORD(&pc->length) == 6 ){ // full color
					gpage->trans = ((PNGBackGroundStruct *)pc)->blue + (((PNGBackGroundStruct *)pc)->green << 8) + (((PNGBackGroundStruct *)pc)->red << 16);
				}
			}
		}else if ( pc->id == PNG_fcTL ){ // fcTL t[
			findfcTL = TRUE;

			if ( page == 0 ){
				PNGFrameControlStruct *fcs;

				fcs = (PNGFrameControlStruct *)pc;

				timer = GetBigEndWORD(&fcs->delay_den);
				if ( timer == 0 ) timer = 100;
				timer = (GetBigEndWORD(&fcs->delay_num) * 1000) / timer;
				if ( timer == 0 ) timer = TIME_ANIMATE_MIN;

				if ( gpage != NULL ){
					if ( gpage->offset == 0 ) gpage->offset = offset;
					gpage->optionoffset = offset;
					gpage->timer = timer;
					gpage->dispoffset.x = GetBigEndDWORD(&fcs->x_offset);
					gpage->dispoffset.y = GetBigEndDWORD(&fcs->y_offset);
					return;
				}else{
					if ( (fcs->dispose_op == APNG_DISPOSE_OP_BACKGROUND) &&
						 (PreFrameInfo.page == PreFramePage_NoCheck) ){
						PreFrameInfo.page = PreFramePage_BG;
						PreFrameInfo.offset.x = PreFrameInfo.offset.y = 0;
						PreFrameInfo.size.cx = vo_.bitmap.info->biWidth;
						PreFrameInfo.size.cy = vo_.bitmap.info->biHeight;
						if ( PreFrameInfo.size.cy < 0 ) PreFrameInfo.size.cy = -PreFrameInfo.size.cy;
					}
					break;
				}
			}
			page--;
		}
		offset += GetBigEndDWORD(&pc->length) + SizeOfPNGchunks;
	}

	if ( frames ){
		if ( vo_.bitmap.page.max == 0 ){
			if ( vo_.bitmap.page.do_animate ){
				SetTimer(vinfo.info.hWnd, TIMERID_ANIMATE,
						timer ? timer : TIME_ANIMATE_MIN, AnimateProc);
			}else{
				SetPopMsg(POPMSG_NOLOGMSG, MES_IANI, PMF_DOCMSG);
			}
		}
		if ( gpage == NULL ){
			vo_.bitmap.page.max = frames;
			vo_.bitmap.page.type = PAGETYPE_APNG;
		}
	}
}

void InitGIF(GETPAGESTRUCT *gpage)
{
	size_t offset = sizeof(GIFHEADER);
	int imagecount = 0, firsttimer = 0;
	GIFHEADER *gh;

#ifdef _WIN64
	if ( vo_.file.UseSize > ((DWORD)3 * GB) ) return;
#endif
	gh = (GIFHEADER *)vo_.file.image;
	if ( gh->flag & GIFHEADER_FLAG_USEPALETTE ){
		offset += GIFHEADERGETPALETTE(gh->flag);
	}
	PreFrameInfo.fillcolor = gh->Tindex;
	if ( gpage != NULL ){
		gpage->headersize = offset;
		gpage->timer = 1000;
		gpage->dispoffset.x = 0;
		gpage->dispoffset.y = 0;
		gpage->trans = -1;
	}
	while( vo_.file.UseSize > offset ){
		switch ( *(vo_.file.image + offset) ){
			case GIFHEADER_IMAGEBLOCKID: {	// Image
				GIFIMAGEHEADER *gih;

				if ( vo_.file.UseSize <= (offset + sizeof(GIFIMAGEHEADER) + 1) ){
					break;
				}
				if ( gpage != NULL ) gpage->offset = offset;

				gih = (GIFIMAGEHEADER *)(vo_.file.image + offset);
				if ( gih->flag & GIFHEADER_FLAG_USEPALETTE ){
					offset += GIFHEADERGETPALETTE(gih->flag);
				}
				offset += sizeof(GIFIMAGEHEADER) + 1;
				while( vo_.file.UseSize >= (offset + 1) ){ // data block
					BYTE size;

					size = *(vo_.file.image + offset++);
					if ( size == 0 ) break;
					offset += size;
				}
				if ( gpage != NULL ){
					if ( imagecount == gpage->page ){
						gpage->dispoffset.x = gih->left;
						gpage->dispoffset.y = gih->top;
						gpage->size = offset - gpage->offset;
						offset = vo_.file.UseSize; // I
					}
				}else if ( (imagecount == 0) && (PreFrameInfo.page == PreFramePage_NoCheck) ){
					PreFrameInfo.offset.x = gih->left;
					PreFrameInfo.offset.y = gih->top;
				}
				imagecount++;
				break;
			}

			case GIFHEADER_EXTENSIONID: {	// Extension
				BYTE id;

				if ( vo_.file.UseSize <= (offset + 3) ) break;
				id = *(vo_.file.image + offset + 1);
				offset += 2;

				if ( (id == GIFHEADER_EXTENSION_CONTROL) &&
						(vo_.file.UseSize >= (offset + 5)) ){
					GIFCONTROLHEADER *gt;

					gt = (GIFCONTROLHEADER *)(vo_.file.image + offset);
					if ( gpage != NULL ){
						if ( imagecount == gpage->page ){
							gpage->timer = gt->time * 10;
							if ( gpage->timer == 0 ) gpage->timer = 40;

							if ( gt->flags & GIFCONTROLHEADER_TRANSPARENT ){
								PreFrameInfo.fillcolor = (BYTE)(gpage->trans = gt->trans);
							}
							if ( firsttimer == 0 ) firsttimer = gpage->timer;

							switch ( gt->flags & GIFCONTROLHEADER_DRAW_MASK ){
								case GIFCONTROLHEADER_DRAW_BG:
									PreFrameInfo.page = PreFramePage_BG;
									break;
								case GIFCONTROLHEADER_DRAW_BACK:
//									PreFrameInfo.page = PreFramePage_Restore;
									break;
							}
						}
					}else if ( (imagecount == 0) && (PreFrameInfo.page == PreFramePage_NoCheck) ){
						if ( gt->flags & GIFCONTROLHEADER_TRANSPARENT ){
							PreFrameInfo.fillcolor = (BYTE)(vo_.bitmap.transcolor = gt->trans);
						}
						if ( ((gt->flags & GIFCONTROLHEADER_DRAW_MASK) ==
							  GIFCONTROLHEADER_DRAW_BG) ){
							PreFrameInfo.page = PreFramePage_BG;
							PreFrameInfo.size.cx = vo_.bitmap.info->biWidth;
							PreFrameInfo.size.cy = vo_.bitmap.info->biHeight;
							if ( PreFrameInfo.size.cy < 0 ) PreFrameInfo.size.cy = -PreFrameInfo.size.cy;
						}
						//  GIFCONTROLHEADER_DRAW_BACK  Page0ł͖
					}
				}

				while( vo_.file.UseSize >= (offset + 1) ){ // data block
					BYTE size;

					size = *(vo_.file.image + offset++);
					if ( !size ) break;
					offset += size;
				}
				break;
			}

			case GIFHEADER_ENDID:	// end
			default:	// s
				offset = vo_.file.UseSize;
				break;
		}
	}
	if ( imagecount > 1 ){
		if ( vo_.bitmap.page.max == 0 ){
			if ( vo_.bitmap.page.do_animate ){
				SetTimer(vinfo.info.hWnd, TIMERID_ANIMATE,
						(firsttimer > 0) ? firsttimer : TIME_ANIMATE_DEFFIRST,
						AnimateProc);
			}else{
				SetPopMsg(POPMSG_NOLOGMSG, MES_IANI, PMF_DOCMSG);
			}
		}
		if ( gpage == NULL ){
			vo_.bitmap.page.max = imagecount;
			vo_.bitmap.page.type = PAGETYPE_GIF;
		}
	}
}

GetDWORDfunc InitTIFF(GETPAGESTRUCT *gpage)
{
	size_t offset = 4;
	int IFDcount = 0;
	GetWORDfunc GetWord;
	GetDWORDfunc GetDword;

#ifdef _WIN64
	if ( vo_.file.UseSize > ((DWORD)3 * GB) ) return NULL;
#endif
	if ( *vo_.file.image == 'M' ){
		GetDword = GetBigEndDWORD;
		GetWord = GetBigEndWORD;
	}else{
		GetDword = GetLittleEndDWORD;
		GetWord = GetLittleEndWORD;
	}

	if ( gpage != NULL ){
		gpage->headersize = 4;
		gpage->timer = 1000;
		gpage->dispoffset.x = 0;
		gpage->dispoffset.y = 0;
		gpage->trans = -1;
	}
	if ( gpage != NULL ) gpage->offset = 8;	// ̃ItZbgp
	while( vo_.file.UseSize > (offset + sizeof(DWORD)) ){
		int IFDdata;

		offset = GetDword(vo_.file.image + offset); // IFD ̏ꏊ擾
		if ( !offset || (vo_.file.UseSize <= (offset + sizeof(WORD))) ) break;
		if ( (gpage != NULL) && (IFDcount == gpage->page) ){
			gpage->offset = offset;
			break;
		}
		IFDdata = GetWord(vo_.file.image + offset);
		if ( IFDdata == 0 ) break;
		offset += sizeof(WORD) + IFDdata * sizeof(IFD);
		IFDcount++;
	}
	if ( IFDcount > 1 ){
		if ( vo_.bitmap.page.max == 0 ){
			KillTimer(vinfo.info.hWnd, TIMERID_ANIMATE);
			SetPopMsg(POPMSG_NOLOGMSG, MES_IPAG, PMF_DOCMSG);
		}
		if ( gpage == NULL ){
			vo_.bitmap.page.max = IFDcount;
			vo_.bitmap.page.type = PAGETYPE_TIFF;
		}
	}
	return GetDword;
}

BOOL AddHighlight(ThSTRUCT *mem, const TCHAR *keyword, COLORREF color, int extend)
{
	HILIGHTKEYWORD *hks;

	int sizeA, sizeW;
	size_t bsize;
#define HKEYMAX 100
#ifdef UNICODE
	#define strA bufA
	#define strW keyword
	char bufA[HKEYMAX];
#else
	#define strA keyword
	#define strW bufW
	WCHAR bufW[HKEYMAX];
#endif
									// R[hQp
#ifdef UNICODE
	UnicodeToAnsi(keyword, bufA, HKEYMAX);
	bufA[HKEYMAX - 1] = '\0';
	sizeA = strlen32(bufA) + 1;
	sizeW = (strlenW32(keyword) + 1) * sizeof(WCHAR);
#else
	AnsiToUnicode(keyword, bufW, HKEYMAX);
	bufW[HKEYMAX - 1] = '\0';
	sizeA = strlen(keyword) + 1;
	sizeW = (strlenW(bufW) + 1) * sizeof(WCHAR);
#endif
									// ۑ
	bsize = sizeof(HILIGHTKEYWORD) + sizeW + ((sizeA + 1) & 0xfffe);
	if ( ThSize(mem, bsize) != FALSE ){
		hks = (HILIGHTKEYWORD *)ThLast(mem);
		hks->next = (HILIGHTKEYWORD *)(LONG_PTR)bsize;
		hks->ascii = (const char *)(size_t)(sizeW);
		hks->wide = 0;
		hks->color = color;
		hks->extend = extend;
		memcpy((char *)(hks + 1) + sizeW, strA, sizeA);
		memcpy((char *)(hks + 1), strW, sizeW);
		mem->top += bsize;
		return TRUE;
	}else{ // mێs
		return FALSE;
	}
#undef strA
#undef strW
}

BOOL LoadDefaultHighlight(ThSTRUCT *mem, const TCHAR *filename, const TCHAR *ext)
{
	TCHAR tmp[0x1000];
	const TCHAR *tmpp;
	int count = 0;
	int check = 0;

	while( EnumCustTable(count, T("CV_hkey"), tmp, NULL, 0) >= 0 ){
		FN_REGEXP fn;

		if ( *tmp == '/' ){
			if ( filename != NULL ){
				MakeFN_REGEXP(&fn, tmp + 1);
				check = FilenameRegularExpression(filename, &fn);
				FreeFN_REGEXP(&fn);
			}
		}else{
			check = (tstricmp(ext, tmp) == 0);
		}
		if ( check ) break;
		count++;
	}
	if ( check == 0 ) return FALSE; // Y

	tmp[0] = '\0';
	EnumCustTable(count, T("CV_hkey"), tmp, tmp, sizeof(tmp));
	if ( tmp[0] == '\0' ) return FALSE; // g

	tmpp = tmp;
	for ( ;; ){
		TCHAR *nextp;
		COLORREF color;
		int extend;

		nextp = tstrchr(tmpp, '\n');
		if ( nextp != NULL ) *nextp++ = '\0';
		if ( *tmpp == '\0' ) break;

		extend = 0;
		if ( SkipSpace(&tmpp) == '<' ){
			tmpp++;
			extend = HILIGHTKEYWORD_T;
		}
		if ( *tmpp == '>' ){
			tmpp++;
			extend |= HILIGHTKEYWORD_B;
		}
		if ( *tmpp == '~' ){
			tmpp++;
			extend |= HILIGHTKEYWORD_R;
		}
		if ( SkipSpace(&tmpp) == ',' ) tmpp++;
									// F擾
		color = GetColor(&tmpp, TRUE);
		if ( SkipSpace(&tmpp) == ',' ) tmpp++;

		if ( AddHighlight(mem, tmpp, color, extend) == FALSE ) break;
		if ( nextp == NULL ) break;
		tmpp = nextp;
	}
	return TRUE;
}

void LoadHighlight(VFSFILETYPE *vft)
{
	const TCHAR *fname, *ext, *textp;
	ThSTRUCT mem;
	HILIGHTKEYWORD *hks;
	TCHAR buf[CMDLINESIZE];
	int colorcount = 0;

	if ( X_hkey != NULL ) HeapFree( PPvHeap, 0, X_hkey );
	X_hkey = NULL;
	ThInit(&mem);

	// ꎞnCCgݒ擾
	textp = ThGetString(NULL, T("Highlight"), NULL, 0);
	if ( textp != NULL ) while ( GetLineParamS(&textp, buf, TSIZEOF(buf)) >= ' ' ){
		COLORREF color;

		color = CV_hili[colorcount + 1];
		colorcount = (colorcount + 1) & 7;
		if ( AddHighlight(&mem, buf, color, HILIGHTKEYWORD_R) == FALSE ) break;
	}

	// ftHg̃nCCgݒ擾
	fname = VFSFindLastEntry(vo_.file.name);
	ext = fname + FindExtSeparator(fname);
	if ( *ext == '.' ) ext++;

	if ( LoadDefaultHighlight(&mem, fname, ext) == FALSE ){
		if ( (vft->type[0] == '\0') || (LoadDefaultHighlight(&mem, NULL, vft->type) == FALSE) ){
			LoadDefaultHighlight(&mem, NULL, T("*"));
		}
	}
	// nCCgŏI
	hks = (HILIGHTKEYWORD *)mem.bottom;
	if ( hks != NULL ){				// |C^𐳋K
		HILIGHTKEYWORD *hkslast;

		if ( mem.top < sizeof(HILIGHTKEYWORD) ){
			ThFree(&mem);
			return;
		}
		hkslast = (HILIGHTKEYWORD *)ThLast(&mem);
		X_hkey = hks;
		for ( ;; ){
			hks->wide = (const WCHAR *)(char *)((char *)hks + sizeof(HILIGHTKEYWORD));
			hks->ascii = (const char *)(char *)((char *)hks + sizeof(HILIGHTKEYWORD) + (size_t)hks->ascii);
			hks->next = (HILIGHTKEYWORD *)(char *)((char *)hks + (size_t)hks->next);
			if ( hks->next < hkslast ){
				hks = hks->next;
				continue;
			}
			hks->next = NULL;
			break;
		}
	}
}

void SetHighlight(PPV_APPINFO *vinfo, BOOL dialog)
{
	VFSFILETYPE vft;

	if ( dialog ){
		if ( PP_ExtractMacro(vinfo->info.hWnd, &vinfo->info, NULL, T("%\"") MES_THIL T("\"*string i,Highlight=%{%si\"Highlight\"%}"), NULL, 0) != NO_ERROR ){
			return;
		}
	}

	vft.flags = VFSFT_TYPE;
	if ( VFSGetFileType(vo_.file.name, (char *)vo_.file.image, vo_.file.UseSize, &vft) != NO_ERROR ){
		vft.type[0] = '\0';
	}
	LoadHighlight(&vft);
	InvalidateRect(vinfo->info.hWnd, NULL, TRUE);
}
#if 0
// eLXgCfbNX̕␳
//void FixTextIndex(VT_TABLE *ti, DWORD_PTR offset)
void FixTextIndex(DWORD_PTR offset)
{
	VT_TABLE *ti;
	int line, maxline;

	ti = VOi->ti;
	if ( ti == NULL ) return;

	maxline = VOi->cline;
	for ( line = 0 ; line < maxline ; line++ ){
		ti->ptr += offset;
		ti++;
	}
}
#endif
void ImageRealloc(DWORD reqsize)
{
	HGLOBAL mapH, newH;
	BYTE *newImage, *oldImage;
	DWORD asize;

	oldImage = vo_.file.image;
	mapH = vo_.file.mapH;
	GlobalUnlock(mapH);

	if ( reqsize >= 0x80000000 ){ // ől2G܂ł
		asize = 0x80000000;
	}else{
		asize = vo_.file.ImageSize * 2;
		while ( asize < reqsize ) asize *= 2;
	}
	newH = GlobalReAlloc(mapH, asize + FILEBUFMARGIN, GMEM_MOVEABLE);
	if ( newH != NULL ){ // g
		mapH = newH;
		vo_.file.ImageSize = asize;
	}
	#pragma warning(suppress:6001) // sΉς
	newImage = GlobalLock(mapH);
	if ( newImage != oldImage ){ // AhX̂ŁA␳
		vo_.file.image = newImage;
		VOi->img = newImage;
		vo_.file.mapH = mapH;
		VOi->line = vo_.text.cline = 0;

		if ( vo_.DModeType == DISPT_DOCUMENT ){
			// mtinfo.MemSize
			MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
		}else{
			mtinfo.MemSize = vo_.file.UseSize;
			MakeIndexTable(MIT_FIRST, MIT_PARAM_TEXT);
		}
	}
}

void BadRp(BYTE *rp, BOOL readend)
{
	TCHAR buf[0x400];

	thprintf(buf, TSIZEOF(buf), T("Rp:%u Size:%u/%u Type:%d End:%d"), (DWORD)(LONG_PTR)(rp - vo_.file.image), vo_.file.UseSize, vo_.file.ImageSize, ReadingStream, readend);
	PPxCommonExtCommand(K_SENDREPORT, (WPARAM)buf);

}

BOOL ReadData(DWORD starttime)
{
	DWORD endtime = 0;
	DWORD load = 0, loadsize;
	BYTE *rp;
	BOOL readend = FALSE;

	if ( ReadingStream != READ_STDIN ){	// t@C
		if ( (vo_.file.ImageSize - vo_.file.UseSize) < ReadStep ){
			ReadStep = vo_.file.ImageSize - vo_.file.UseSize;
		}
		if ( vo_.file.name[0] == '#' ){
			if ( ReadStep > 0x10000 ) ReadStep = 0x10000;
		}
	}else{	// READ_STDIN W
		if ( vo_.file.UseSize == 0 ){
			ReadStep = 100;
		}else{
			if ( PeekNamedPipe(hReadStream, NULL, 0, NULL, &ReadStep, NULL) == FALSE ){
				ReadStep = 0; // ǂݍݏI
			}else{
				if ( ReadStep == 0 ) return FALSE;
			}
			// Ċm
			if ( (ReadStep + vo_.file.UseSize) > vo_.file.ImageSize ){
				ImageRealloc(ReadStep + vo_.file.UseSize);

				// ŝߓǂ߂邾ǂłI
				if ( (ReadStep + vo_.file.UseSize) > vo_.file.ImageSize ){
					ReadStep = vo_.file.ImageSize - vo_.file.UseSize;
					readend = TRUE;
				}
			}
		}
	}
	loadsize = ReadStep;
	while( loadsize ){
		if ( ReadFile(hReadStream, vo_.file.image + vo_.file.UseSize,
				(loadsize > 0x10000 ? (loadsize / 16) : loadsize),
				&load, NULL) == FALSE ){
			load = 0;
		}else{
			vo_.file.UseSize += load;
			if ( ReadFileBreakCheck() != FALSE ){
				load = 0;
				SetPopMsg(POPMSG_NOLOGMSG, MES_BRAK, 0);
			}
			if ( (vo_.file.image == NULL) || (vo_.file.ImageSize == 0) || (vo_.file.ImageSize < vo_.file.UseSize) ){ // ReadFileBreakCheck Ńt@CƂ̕ی
				vo_.file.UseSize = vo_.file.ImageSize;
				load = 0;
				break;
			}
		}
		endtime = GetTickCount();
		if ( load == 0 ) break;
		loadsize -= load;
		if ( (endtime - starttime) >= READINTERVAL_FILEREAD ) break;
	}
	rp = vo_.file.image + vo_.file.UseSize;
	if ( (readend != FALSE) || (load == 0) ){ // t@Cread
		if ( (vo_.file.ImageSize != 0) && (vo_.file.ImageSize > vo_.file.UseSize) ){
			memset(rp, 0xaa, vo_.file.ImageSize - vo_.file.UseSize);
		}
		CloseHandle(hReadStream);
		hReadStream = NULL;
		ReadingStream = READ_NONE;
		readend = TRUE;
		rp = NULL;
	}
	if ( rp != NULL ){
		vo_.file.reading = TRUE;
		if ( IsBadReadPtr(rp, FILEBUFMARGIN) ){
			BadRp(rp, readend);
		}else{
			memset(rp, 0, FILEBUFMARGIN);
		}
		if ( ReadingStream != READ_STDIN ){	// t@C
			endtime = (endtime >= starttime) ?
					(endtime - starttime) : (starttime - endtime);
			if ( endtime < READINTERVAL_FILEREAD ){
				if ( ReadStep < 10 * MB ){
					if ( endtime < (READINTERVAL_FILEREAD / 3) ){
						ReadStep *= 2;
					}else{
						ReadStep += (ReadStep >= 0x20000) ? 0x20000 : 0x1000;
					}
				}
			}else{ // W READ_STDIN
				if ( endtime > (READINTERVAL_FILEREAD * 2) ){
					ReadStep /= 2;
				}else{
					ReadStep -= (ReadStep > 0x20000) ? 0x20000 : 0x1000;
				}
				if ( ReadStep < 0x4000 ) ReadStep = 0x4000;
			}
		}
	}
	return readend;
}

// ʃXbhɉƂ́A MakeIndexTable sȂ悤
// Kv
#pragma argsused
void CALLBACK BackReaderProc(HWND hWnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{
	DWORD starttime, endtime;
	MSG msgdata;
	UnUsedParam(uMsg);UnUsedParam(idEvent);UnUsedParam(dwTime);

	if ( ReadEnter ) return;
	ReadEnter++;
	starttime = GetTickCount();
	if ( ReadingStream != READ_NONE ){ // t@C̓ǂݍ
		if ( ReadData(starttime) == FALSE ){	// ǂݍݒ
			if ( (vo_.DModeType != DISPT_DOCUMENT) || (vo_.file.other.image == NULL) ){
				mtinfo.MemSize = vo_.file.UseSize;
			}
		}else{						// ǂݍ݊
			DWORD olddt;

			olddt = vo_.DModeType;
//XMessage(NULL, NULL, XM_DbgLOG, T("BackReaderProc 1 %d"),BackReader);
			CheckType();
			if ( vo_.DModeType != olddt ){
				VOi->img = NULL;
//XMessage(NULL, NULL, XM_DbgLOG, T("BackReaderProc 2 %d"),BackReader);
				CheckType();
			}
			SetScrollBar();
			if ( XV_tmod && (vo_.DModeBit & VO_dmode_SELECTABLE) ){
				InitCursorMode(hWnd, FALSE);
			}
			InvalidateRect(hWnd, NULL, FALSE);
		}
		if ( vo_.DModeBit & DOCMODE_HEX ){
			VOi->line = ((vo_.file.UseSize + 15) >> 4);
		}
	}

	if ( (vo_.file.reading != FALSE) && (vo_.file.UseSize > 0) ){ // svZ
		ReadDisp++;
		if ( !(vo_.DModeBit & DOCMODE_TEXT) ){
			vo_.file.reading = FALSE;
		}else{
			int readunit, readcount;

//XMessage(NULL, NULL, XM_DbgLOG, T("BackReaderProc %p %p %p"), vo_.file.image ,vo_.file.image + vo_.file.UseSize, vo_.file.ImageSize);

			readunit = (CountReadLines <= (READLINE_TIMERMIN * 8)) ?
					CountReadLines : (CountReadLines / 16);
			readcount = 0;
			for ( ;; ){
				MakeIndexTable(MIT_NEXT, readunit);
				if ( vo_.file.reading == FALSE ) break;
				if ( PeekMessage(&msgdata, NULL, 0, 0, PM_NOREMOVE) ){
					if ( msgdata.message != WM_TIMER ){
						goto fin;
					}
				}
				readcount += readunit;
				endtime = GetTickCount();
				endtime = (endtime >= starttime) ?
						(endtime - starttime) : (starttime - endtime);
				if ( endtime >= (READINTERVAL_FILEREAD + READINTERVAL_LINECOUNT) ){
					CountReadLines = readcount;
					break;
				}
			}

			if ( ReadingStream == READ_STDIN ){
				MoveCsr(0, VOi->line, FALSE);
				ReadDisp = READLINE_DISPS;
			}

			// Ỏs܂Ŋ߂
			{
				int count = 5;
				while ( (vo_.text.cline > 0) &&
						!(VOi->ti[vo_.text.cline].attrs & VTTF_TOP) ){
					vo_.text.cline--;
					count--;
					if ( count == 0 ) break;
				}
			}
		}
	}
	// t@Cǂݍ݂IƂAwsփWv
	if ( (vo_.file.reading == FALSE) && (ReadingStream == READ_NONE) ){
		KillTimer(vinfo.info.hWnd, TIMERID_READLINE);
		BackReader = FALSE;
		mtinfo.PresetPos = 0;
		MoveCsr(0, mtinfo.PresetY - VOi->offY, FALSE);
		if ( VOi->offY < mtinfo.PresetY ){
		// ړ؂ĂȂꍇ͂蒼
		//  MoveCsr  SetScrollBar  VO_maxY Đݒ肳邱Ƃ
			MoveCsr(0, mtinfo.PresetY - VOi->offY, FALSE);
		}
		mtinfo.OpenFlags = 0;
	}
	// t@Cǂݍ݁Aws\
	if ( (ReadDisp >= READLINE_DISPS) || (BackReader == FALSE) ){
		ReadDisp = 0;
		InvalidateRect(hWnd, NULL, FALSE);	// XVw
		SetScrollBar();
		LoadEvent();
		#if COUNTREADTIME
		{
			TCHAR buf[20];
			thprintf(buf, TSIZEOF(buf), T("Time:%d"), GetTickCount() - readstartTick);
			SetPopMsg(POPMSG_NOLOGMSG, buf, PMF_DOCMSG);
		}
		#endif
	}
fin:
	ReadEnter--;
}

//---------------------------------------------------------------- ŗL̏
int VD_emf(void)
{
	SetAllTextCode(VTYPE_SYSTEMCP);
	if ( vo_.eMetafile.handle != NULL ) return 0;
	vo_.eMetafile.handle = SetEnhMetaFileBits(vo_.file.UseSize, vo_.file.image);
	if ( vo_.eMetafile.handle != NULL ){
		ENHMETAHEADER metah;

		vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
		VOi->img = vo_.file.image;
		vo_.bitmap.ShowInfo = &temp_DIB.bmiHeader;
		vo_.bitmap.ShowInfo->biWidth = 100;
		vo_.bitmap.ShowInfo->biHeight = 100;
		if ( GetEnhMetaFileHeader(vo_.eMetafile.handle, sizeof(metah), &metah) ){
			vo_.bitmap.ShowInfo->biWidth = metah.rclBounds.right - metah.rclBounds.left;
			vo_.bitmap.ShowInfo->biHeight = metah.rclBounds.bottom - metah.rclBounds.top;

			vo_.bitmap.ShowInfo->biXPelsPerMeter = metah.rclBounds.left;
			vo_.bitmap.ShowInfo->biYPelsPerMeter = metah.rclBounds.top;

			VOi->width = metah.rclBounds.right / fontX + 1;
			VOi->line = metah.rclBounds.bottom / LineY + 1;

		}
		vo_.bitmap.rawsize.cx = vo_.bitmap.ShowInfo->biWidth;
		vo_.bitmap.rawsize.cy = vo_.bitmap.ShowInfo->biHeight;
		FixBitmapShowSize(&vo_);

		vo_.DocmodeType = DOCMODE_EMETA;
		if ( GetEnhMetaFilePaletteEntries(vo_.eMetafile.handle, 0, NULL) ){
			struct {
				WORD palVersion;
				WORD palNumEntries;
				PALETTEENTRY palPalEntry[256];
			} lPal;

			lPal.palVersion = 0x300;
			lPal.palNumEntries = (WORD)GetEnhMetaFilePaletteEntries(
					vo_.eMetafile.handle, 256, (PALETTEENTRY *)&lPal.palPalEntry);
			vo_.bitmap.hPal = CreatePalette((CONST LOGPALETTE *)&lPal);
		}
	}else{
		vo_.DModeType = DISPT_TEXT;
	}
	return 0;
}
//-------------------------------------
int VD_c(void)
{
	if ( VOi->tab == 8 ) VOi->tab = 4;
	return -1;
}
//-------------------------------------
int VD_systemcp(void)
{
	SetAllTextCode(VTYPE_SYSTEMCP);
	return -1;
}
//-------------------------------------
int VD_jis(void)
{
	VOi->width = 76;
	SetAllTextCode(VTYPE_JIS);
	return -1;
}
//-------------------------------------
int VD_unicode(void)
{
	SetAllTextCode(VTYPE_UNICODE);
	return -1;
}
//-------------------------------------
int VD_unicodeB(void)
{
	SetAllTextCode(VTYPE_UNICODEB);
	return -1;
}
//-------------------------------------
int VD_html(void)
{
	VO_Ttag = 1;
	return -1;
}
//-------------------------------------
int VD_xml(void)
{
	VO_Ttag = 2;
	return -1;
}
//-------------------------------------
int VD_officezip(void)
{
	SetAllTextCode(VTYPE_UTF8);
	VO_Ttag = 1;
	X_tlen = 1100;
	return -1;
}
//-------------------------------------
int VD_u_html(void)
{
	SetAllTextCode(VTYPE_UNICODE);
	VO_Ttag = 2;
	return -1;
}
//-------------------------------------
int VD_mail(void)
{
	VO_Tmime = 1;
	return -1;
}
//-------------------------------------
int VD_rtf(void)
{
	SetAllTextCode(VTYPE_RTF);
	return -1;
}
//-------------------------------------
int VD_word7(void)
{
	DWORD off;

	off = 0x200 + *(DWORD *)(vo_.file.image + 0x218);
	if ( off >= vo_.file.UseSize ) off = 0;

	vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
	SetAllTextCode(VTYPE_SJISB);
	VOi->img = vo_.file.image + off;

	if ( (off + 8) < vo_.file.UseSize ){
		if ( !memcmp(VOi->img, "\x79\x81\x91\x8f\xde\x97\xbc\x96", 8) ){
			VOi->width = 72;
		}
	}

	mtinfo.MemSize = vo_.file.UseSize - off;
	MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
	return 0;
}
//-------------------------------------
int VD_word8(void)
{
	int i, type = VTYPE_SYSTEMCP;
	DWORD off;
	BYTE *p;

	off = 0x200 + *(DWORD *)(vo_.file.image + 0x218);
	if ( off >= vo_.file.UseSize ) off = 0;
	if ( !*(DWORD *)(vo_.file.image + off) ) off += 0x200;

	p = vo_.file.image + off;
	for ( i = 0 ; i < 32 ; i++ ){
		if ( !*p || (*p & 0x80) ){
			type = VTYPE_UNICODE;
			break;
		}
		p++;
	}

	vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
	SetAllTextCode(type);
	VOi->img = vo_.file.image + off;

	mtinfo.MemSize = vo_.file.UseSize - off;
	MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
	return 0;
}
//-------------------------------------
int VD_wordx(void)
{
	if ( vo_.file.other.image == NULL ){
		TCHAR arcfile[VFPS], fname[VFPS];
		HANDLE hFile;
		HANDLE mapH;
		BYTE *image;

		tstrcpy(arcfile, vo_.file.name);
		tstrcpy(fname, T("\\word\\document.xml"));
		hFile = CreateFileL(arcfile, GENERIC_READ,
				FILE_SHARE_WRITE | FILE_SHARE_READ, NULL,
				OPEN_EXISTING,
				FILE_FLAG_SEQUENTIAL_SCAN,
				NULL);
		if ( hFile != INVALID_HANDLE_VALUE ){
			DWORD result, sizeL, sizeH;

			result = VFSGetArchivefileImage(vinfo.info.hWnd, hFile, arcfile,
					fname, &sizeL, &sizeH, &mapH, &image);
			if ( result == NO_ERROR ){
				vo_.file.other.type = 1;
				vo_.file.other.image = image;
				vo_.file.other.mapH = mapH;
				vo_.file.other.UseSize = vo_.file.other.ImageSize = sizeL;
			}
		}
	}
	if ( vo_.file.other.image != NULL ){
		vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
		VO_I[DISPT_DOCUMENT].textC = VTYPE_UTF8;
		VOi->img = vo_.file.other.image;
		VO_Tesc = 0;
		VO_Ttag = 1;

		mtinfo.MemSize = vo_.file.other.UseSize;
		MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
		return 0;
	}else{ // 擾s
		return -1;
	}
}
//-------------------------------------
int VD_sjis(void)
{
	if ( VO_textS[VTYPE_SYSTEMCP] == textcp_sjis ){
		SetAllTextCode(VTYPE_SYSTEMCP);
	}else{
		SetOtherCodepage(CP__SJIS);
	}
	return -1;
}

//-------------------------------------
int VD_oasys(void)
{
	BYTE *p;

	vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
	VD_sjis();
	VOi->MakeText = VD_oasys_mdt;

	if ( vo_.file.UseSize > 0x7d0 ){
		p = (BYTE *)vo_.file.image + 0x7d0;
	}else{
		p = (BYTE *)vo_.file.image;
	}
	for( ;; ){
		if ( *p++ == 0xf0 ){
			if ( *p++ == 0x04 ) break;
		}
	}
	VOi->img = p + 2;

	mtinfo.MemSize = vo_.file.UseSize - (VOi->img - vo_.file.image);
	MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
	return 0;
}
//-------------------------------------
int VD_unitext(void)
{
	vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
	SetAllTextCode(VTYPE_UNICODE);
	VOi->img = vo_.file.image + 2;

	mtinfo.MemSize = vo_.file.UseSize - 2;
	MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
	return 0;
}
//-------------------------------------
int VD_unitextB(void)
{
	vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
	SetAllTextCode(VTYPE_UNICODEB);
	VOi->img = vo_.file.image + 2;

	mtinfo.MemSize = vo_.file.UseSize - 2;
	MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
	return 0;
}
//-------------------------------------
int VD_utf8(void)
{
	vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
	SetAllTextCode(VTYPE_UTF8);
	VOi->img = vo_.file.image + 3;

	mtinfo.MemSize = vo_.file.UseSize - 3;
	MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
	return 0;
}
//-------------------------------------
int VD_text(void)
{
	return -1;
}

#define CODEFUNCMAX 21
typedef struct {
	int (*func)(void);
} VD_CODEFUNCINIT;

const VD_CODEFUNCINIT Vd_codefuncinit[CODEFUNCMAX] = {
	{VD_systemcp},	{VD_jis},		{VD_unicode},	{VD_html},
	{VD_rtf},		{VD_word7},		{VD_oasys},		{VD_unitext},
	{VD_unicodeB},	{VD_unitextB},	{VD_utf8},		{VD_c},
	{VD_emf},		{VD_word8},		{VD_mail},		{VD_xml},
	{VD_u_html},	{VD_officezip},	{VD_text},		{VD_wordx},
	{VD_sjis}
};

#if !NODLL
void GetDriveRawSize(HANDLE hFile, UINTHL *size)
{
	DISK_GEOMETRY diskinfo;
	xDISK_GEOMETRY_EX diskinfoex;
	DWORD tmp;

	// n߂CD-ROM`FbNADISK̃`FbN
	if ( FALSE != DeviceIoControl(hFile, IOCTL_DISK_GET_LENGTH_INFO,
			NULL, 0, size, sizeof(UINTHL), &tmp, NULL) ){
		return;
	}else if ( (FALSE != DeviceIoControl(hFile, IOCTL_CDROM_GET_DRIVE_GEOMETRY_EX,
			NULL, 0, &diskinfoex, sizeof(xDISK_GEOMETRY_EX), &tmp, NULL)) ||
		 (FALSE != DeviceIoControl(hFile, IOCTL_DISK_GET_DRIVE_GEOMETRY_EX,
			NULL, 0, &diskinfoex, sizeof(xDISK_GEOMETRY_EX), &tmp, NULL)) ){
		*size = diskinfoex.DiskSize;
	}else if (
		(FALSE != DeviceIoControl(hFile, IOCTL_CDROM_GET_DRIVE_GEOMETRY,
			NULL, 0, &diskinfo, sizeof(DISK_GEOMETRY), &tmp, NULL)) ||
		(FALSE != DeviceIoControl(hFile, IOCTL_DISK_GET_DRIVE_GEOMETRY,
			NULL, 0, &diskinfo, sizeof(DISK_GEOMETRY), &tmp, NULL)) ){
		DWORD tracksize, tmpL, tmpH;

		tracksize = diskinfo.TracksPerCylinder *
				diskinfo.SectorsPerTrack * diskinfo.BytesPerSector;

		DDmul(tracksize, diskinfo.Cylinders.u.LowPart,
				&size->s.L, &size->s.H);
		DDmul(tracksize, diskinfo.Cylinders.u.HighPart, &tmpL, &tmpH);
		size->s.H += tmpL;
	}else{
		size->s.L = 200 * MB;
		size->s.H = 0;
	}
}
#else
extern void GetDriveRawSize(HANDLE hFile, UINTHL *size);
#endif

// t@CC[W擾--------------------------------------------------
#define VOPENFILE_
HANDLE vOpenFile(const TCHAR *filename, const TCHAR **wp, const TCHAR **dllp)
{
	TCHAR buf[VFPS], *fp, *separator = NULL;
	HANDLE hFile;
	int openmode;
	BOOL rawsize = FALSE;
	TCHAR *vp, drive;
	int depth = 0;

	tstrcpy(buf, filename);
	vp = VFSGetDriveType(buf, &openmode, NULL);
	if ( vp == NULL ){		// ނȂΎw̉\Ή
		VFSFullPath(NULL, buf, NULL);
		vp = VFSGetDriveType(buf, &openmode, NULL);
		if ( vp == NULL ) goto patherror; // łނȂG[
	}
										// ޕʂ̏ -----------------------
	switch (openmode){
		case VFSPT_RAWDISK:		// "#A:"  "\\.\A:" ɕϊ
			vp -= 2;
			drive = *vp;
			thprintf(buf, TSIZEOF(buf), T("\\\\.\\%c:"), drive);
			rawsize = TRUE;
			break;

		case VFSPT_DRIVELIST:
			goto patherror;

		default:
			if ( (openmode == VFSPT_SHELLSCHEME) || (openmode <= VFSPT_SHN_DESK) ){
				if ( FALSE == VFSGetRealPath(vinfo.info.hWnd, buf, filename) ){
					tstrcpy(buf, filename);
				}
			}
			break;
	}

	for ( ;; ){
		DWORD attr;

		fp = VFSFindLastEntry(buf);
		if ( rawsize != FALSE ){
			attr = 0;
		}else{
			attr = GetFileAttributesL(buf);
		}
		if ( attr != BADATTR ){
			if ( attr & FILE_ATTRIBUTE_DIRECTORY ){
				if ( depth == 0 ){
					if ( *fp == '\\' ) fp++;
					thprintf(vo_.file.typeinfo, TSIZEOF(vo_.file.typeinfo), T("%s is directory."), fp);
					return NULL;
				}else{
					SetLastError(ERROR_FILE_NOT_FOUND);
				}
			}else{
				hFile = CreateFileL(buf, GENERIC_READ,
						FILE_SHARE_WRITE | FILE_SHARE_READ, NULL,
						OPEN_EXISTING,
						FILE_FLAG_SEQUENTIAL_SCAN,
// GENERIC_READ ̂Ƃ́AFILE_FLAG_POSIX_SEMANTICS ȂH
//						FileCase ?
//							(FILE_FLAG_SEQUENTIAL_SCAN | FILE_FLAG_POSIX_SEMANTICS) : FILE_FLAG_SEQUENTIAL_SCAN,
						NULL);
				if ( hFile != INVALID_HANDLE_VALUE ){
					if ( (separator != NULL) &&
						 (separator != INVALID_HANDLE_VALUE) &&
						 ((fp = FindPathSeparator(separator)) != NULL) ){
						*fp = '\0';
					}else{
						fp = buf + tstrlen(buf);
					}
					break;
				}
			}
			goto accesserror;
		}else{
			if ( separator == NULL ){
				separator = tstrrchr(buf, ':'); // "::" 
				if ( (separator != NULL) && (separator >= (buf + 2)) &&
					 (*(separator - 1) == ':') ){
					*(separator - 1) = '\0';
					*dllp = filename + (separator - buf) - 1;
					continue;
				}
			}
			separator = INVALID_HANDLE_VALUE;
			if ( (openmode == VFSPT_SHELLSCHEME) || (openmode <= VFSPT_SHN_DESK) ){
				ERRORCODE result;
				TCHAR *textimage = NULL;
				DWORD memsize;

				result = VFSLoadFileImage(buf , 0, (char **)&textimage, &memsize, NULL);
				if ( result == NO_ERROR ){
					if ( (vo_.file.mapH = GlobalAlloc(GMEM_MOVEABLE,
							memsize + FILEBUFMARGIN)) != NULL ){
						if ( (vo_.file.image = GlobalLock(vo_.file.mapH)) == NULL ){
							GlobalFree(vo_.file.mapH);
							VO_error(PPERROR_GETLASTERROR);
						}else{
							memcpy(vo_.file.image, textimage, memsize);
							memset(vo_.file.image + memsize, 0, FILEBUFMARGIN);
							tstrcpy(vo_.file.source, filename);
							vo_.file.sourcefrom = SOURCEFROM_FILENAME;
							FileDivideMode = FDM_FORCENODIV;

							vo_.file.ImageSize = memsize;
							FileRealSize.s.L = vo_.file.UseSize = memsize;
							FileRealSize.s.H = 0;
							return INVALID_HANDLE_VALUE;
						}
					}
				}
			}
		}
		if ( *fp == '\0' ) goto accesserror;
		*fp = '\0';
		depth++;
	}

	if ( rawsize ){	// #x: Ńt@CTCY߂Ȃ̂ŁAʂ̕@Ō
		*wp = filename + (vp - buf) + 2;
		GetDriveRawSize(hFile, &FileRealSize);
	}else{
		ERRORCODE result;

		*wp = filename + (fp - buf);
		FileRealSize.s.L = GetFileSize(hFile, &FileRealSize.s.H);
		if ( (FileRealSize.s.L == MAX32) && ((result = GetLastError()) != NO_ERROR) ){
			CloseHandle(hFile);
			VO_error(result);
			return NULL;
		}
		vo_.file.IsFile = 1;
	}
	vo_.file.UseSize = FileRealSize.s.L;
	return hFile;
patherror:
	VO_error(ERROR_BAD_PATHNAME);
	return NULL;
accesserror:
	VO_error(PPERROR_GETLASTERROR);
	return NULL;
}

BOOL ReadFileBreakCheck(void)
{
	MSG msgdata;

	if ( PeekMessage(&msgdata, NULL, 0, 0, PM_NOREMOVE) == FALSE ) return FALSE;
	if ( (msgdata.message == WM_QUIT) || (msgdata.message == WM_CLOSE) ){
		return TRUE;
	}
	if ( (msgdata.message == WM_RBUTTONUP) ||
		 ((msgdata.message == WM_KEYDOWN) &&
		  (((int)msgdata.wParam == VK_ESCAPE)||((int)msgdata.wParam == VK_PAUSE))) ){
		if ( PMessageBox(vinfo.info.hWnd, MES_AbortCheck, T("Break check"), MB_QYES) == IDOK ){
			return TRUE;
		}
	}
	return FALSE;
}

DWORD ReadAll(void)
{
	DWORD load, step = 1 * MB;
	BYTE *rp;

	if ( FileDivideMode >= FDM_DIV ) return 1; // ́ASēǂ߂Ȃ
	if ( ReadingStream == READ_NONE ) return vo_.file.UseSize;

	SetFilePointer(hReadStream, vo_.file.UseSize, NULL, FILE_BEGIN);
	for ( ;; ){
		if ( (vo_.file.ImageSize - vo_.file.UseSize) < step ){
			step = vo_.file.ImageSize - vo_.file.UseSize;
		}
		if ( ReadFile(hReadStream, vo_.file.image + vo_.file.UseSize, step, &load, NULL) == FALSE ){
			if ( ReadingStream == READ_STDIN ) break;
			PPErrorBox(vinfo.info.hWnd, NULL, PPERROR_GETLASTERROR);
			return 0;
		}
		if ( load == 0 ) break;
		vo_.file.UseSize += load;
		if ( ReadFileBreakCheck() != FALSE ){
			SetPopMsg(POPMSG_NOLOGMSG, MES_BRAK, 0);
			break;
		}
		if ( (vo_.file.image == NULL) || (vo_.file.ImageSize == 0) || (vo_.file.ImageSize < vo_.file.UseSize) ){ // ReadFileBreakCheck Ńt@CƂ̕ی
			vo_.file.UseSize = vo_.file.ImageSize;
			break;
		}
	}
	CloseHandle(hReadStream);

	// gp̈E\̈ fill
	if ( (vo_.file.image != NULL) && (vo_.file.ImageSize != 0) ){
		rp = vo_.file.image + vo_.file.UseSize;
		if ( vo_.file.ImageSize > vo_.file.UseSize ){
			memset(rp, 0xaa, vo_.file.ImageSize - vo_.file.UseSize);
		}
		memset(rp, 0, FILEBUFMARGIN);
	}
	hReadStream = NULL;
	ReadingStream = READ_NONE;
	return vo_.file.UseSize;
}

BOOL OpenViewHttp(const TCHAR *filename)
{
	ThSTRUCT th;
	char *bottom, *ptr;
	DWORD datasize;

	if ( GetImageByHttp(filename, &th) == FALSE ){
		VO_error(ERROR_MOD_NOT_FOUND);
		return FALSE;
	}
	bottom = th.bottom;
	datasize = th.top - 1;

	ptr = strstr(bottom, "\r\n\r\n");
	if ( (ptr != NULL) && (*(ptr + 4) != '\0') ){
		datasize -= ptr - bottom + 4;
		bottom = ptr + 4;
	}
	if ( (vo_.file.mapH = GlobalAlloc(GMEM_MOVEABLE, datasize + FILEBUFMARGIN)) == NULL ){
		VO_error(PPERROR_GETLASTERROR);
		return FALSE;
	}
	if ( (vo_.file.image = GlobalLock(vo_.file.mapH)) == NULL ){
		GlobalFree(vo_.file.mapH);
		VO_error(PPERROR_GETLASTERROR);
		return FALSE;
	}
	memcpy(vo_.file.image, bottom, datasize);
	*bottom = '\0';
	ThCatStringA(&vo_.memo, th.bottom);
	ThFree(&th);
	memset(vo_.file.image + datasize, 0, FILEBUFMARGIN);

	vo_.file.ImageSize = datasize;
	FileRealSize.s.L = vo_.file.UseSize = datasize;
	FileRealSize.s.H = 0;
	tstrcpy(vo_.file.source, filename);
	vo_.file.sourcefrom = SOURCEFROM_FILENAME;
	return TRUE;
}

// t@Cǂݍ݃C -----------------------------------------------------
BOOL OpenViewFile(const TCHAR *filename, int flags)
{
	HANDLE hFile;
	DWORD size;
	const TCHAR *wp, *dllp = NULL;
	DWORD starttime, tick;

	{
		TCHAR tmppath[VFPS], *p, *popt;

		p = VFSFindLastEntry(filename);
		popt = tstrstr(p, T("::"));
		if ( popt != NULL ){
			tstrcpy(tmppath, filename);
			tmppath[popt - filename] = '\0';
			filename = tmppath;
		}
	}

	if ( !memcmp(filename, httpstr, SIZEOFTSTR(httpstr)) ||
		 !memcmp(filename, httpsstr, SIZEOFTSTR(httpsstr)) ){
		return OpenViewHttp(filename);
	}
										// t@CJ
	hFile = vOpenFile(filename, &wp, &dllp);
	if ( hFile == NULL ) return FALSE;
	if ( hFile == INVALID_HANDLE_VALUE ) return TRUE; // shell: ̂Ƃ͓
	GetCustData(T("X_wsiz"), &X_wsiz, sizeof X_wsiz);
	if ( !(flags & PPV__reload) ){ // VKȂ番[h
		if ( (FileRealSize.s.H != 0) || (FileRealSize.s.L >= X_wsiz) ){
			const TCHAR *vp;

			UsePPx();
			vp = SearchHistory(PPXH_PPVNAME, filename);
			if ( vp != NULL ){
				int datasize = GetHistoryDataSize(vp) - sizeof(int) * 3;

				if ( datasize >= 10 ){
					const BYTE *bp;

					bp = (const BYTE *)GetHistoryData(vp) + sizeof(int) * 3;
					if ( (BYTE)*(bp + 1) == HISTOPTID_FileDIV ){
						FileDividePointer = *(UINTHL *)(bp + 2);
					}else if ( ((BYTE)*(bp + 1) == HISTOPTID_OLDTAIL) &&
							   (datasize >= HISTOPTSIZE_OLDTAIL_L) ){
						FileDividePointer = *(UINTHL *)(bp + 6);
					}
					if ( (FileDividePointer.s.H > FileRealSize.s.H) ||
						((FileDividePointer.s.H == FileRealSize.s.H) &&
						 (FileDividePointer.s.L >= FileRealSize.s.L) ) ){
						LetHL_0(FileDividePointer);
					}
				}
			}
			FreePPx();
		}
	}

	if ( (*wp != '\0') &&
		 !((*wp == '\\') && (*(wp + 1) == '\0')) ){
		TCHAR arcfile[VFPS];
		DWORD result;
		HWND hDWnd;
		DWORD X_llsiz = 2;
															// t@C
		tstrcpy(arcfile, filename);
		arcfile[wp - filename] = '\0';
		GetCustData(T("X_llsiz"), &X_llsiz, sizeof(X_llsiz));
		hDWnd = vinfo.info.hWnd;
		if ( (X_llsiz == 1) || (FileDivideMode == FDM_FORCENODIV) ){
			X_llsiz = 1;
			hDWnd = (HWND)LFI_ALWAYSLIMITLESS;
		}else if ( X_llsiz == 2 ){
			hDWnd = (HWND)LFI_ALWAYSLIMIT;
		}
		result = VFSGetArchivefileImage(hDWnd, hFile, arcfile, wp,
				&FileRealSize.s.L, &FileRealSize.s.H,
				&vo_.file.mapH, &vo_.file.image);
//		CloseHandle(hFile); // VFSGetArchivefileImage ŕĂ
		if ( result != NO_ERROR ){
			VO_error(result);
			return FALSE;
		}else{
			if ( (X_llsiz == 2) && (FileRealSize.s.L == X_wsiz) ){
				FileDivideMode = FDM_DIV;
			}
			vo_.file.UseSize = FileRealSize.s.L;
			return TRUE;
		}
	}
//------------------------------------- t@C̑傫𐧌
	vo_.file.UseSize = FileRealSize.s.L;
	if ( FileRealSize.s.H > 0 ){
		if ( FileDivideMode < FDM_NODIVMAX ) FileDivideMode = FDM_DIV;
		vo_.file.UseSize = MAX32;	// ۂߍ1
		if ( FileDividePointer.s.L | FileDividePointer.s.H ){
			FileDivideMode = FDM_DIV2ND;
		}
	}

	if ( flags & PPV_HEADVIEW ){
		DWORD X_svsz = DEF_X_svsz;

		GetCustData(T("X_svsz"), &X_svsz, sizeof(X_svsz));
		if ( vo_.file.UseSize > X_svsz ){
			vo_.file.UseSize = X_svsz;
			FileDivideMode = FDM_DIV;
		}
	}

	if ( vo_.file.UseSize > X_wsiz ){	// ۂߍ2
		int result;

		if ( FileDivideMode == FDM_NODIV ){
			FileDivideMode = FDM_DIV;
		}
		if ( FileDividePointer.s.L | FileDividePointer.s.H ){
			FileDivideMode = FDM_DIV2ND;
		}

		if ( (FileDivideMode >= FDM_DIV2ND) ||
			 FileRealSize.s.H ||
			 (FileRealSize.s.L >= PPV_MAX_VIEWSIZE) ){
			result = IDYES;
		}else if ( FileDivideMode == FDM_FORCENODIV ){
			result = IDNO;
		}else{
			HWND hOldFocusWnd;
			DWORD X_llsiz = 2;

			GetCustData(T("X_llsiz"), &X_llsiz, sizeof(X_llsiz));
			if ( X_llsiz <= 3 ){
				result = X_llsizTable[X_llsiz];
			}else{
				result = 0;
			}
			if ( result == 0 ){
				hOldFocusWnd = GetForegroundWindow();
				ForceSetForegroundWindow(vinfo.info.hWnd);
				result = PMessageBox(vinfo.info.hWnd, MES_QOSL, T("Warning"),
						MB_ICONEXCLAMATION | MB_YESNOCANCEL);
				if ( hOldFocusWnd != vinfo.info.hWnd ){
					ForceSetForegroundWindow(hOldFocusWnd);
				}
			}
		}
		if ( result == IDYES ){
			UINTHL temp;

			vo_.file.UseSize = X_wsiz; // 

			temp = FileRealSize;
			SubUHLHL(temp, FileDividePointer);
			if ( (temp.s.H == 0) && (temp.s.L < X_wsiz) ){
				vo_.file.UseSize = temp.s.L;
			}
		}else if ( result != IDNO ){ // ~
			VO_error(PPERROR_GETLASTERROR);
			CloseHandle(hFile);
			return FALSE;
		}else{
			FileDivideMode = FDM_NODIV;
			LetHL_0(FileDividePointer);
		}
	}

	if ( FileDivideMode >= FDM_DIV ){
		SetFilePointer(hFile, FileDividePointer.s.L, (LONG *)&FileDividePointer.s.H, FILE_BEGIN);
	}
	while ( (vo_.file.mapH = GlobalAlloc(GMEM_MOVEABLE, vo_.file.UseSize + FILEBUFMARGIN)) == NULL){
		if ( vo_.file.UseSize > 200 * MB ){
			vo_.file.UseSize = 200 * MB;
			continue;
		}
		if ( vo_.file.UseSize > 10 * MB ){
			vo_.file.UseSize = 10 * MB;
			continue;
		}
		VO_error(PPERROR_GETLASTERROR);
		CloseHandle(hFile);
		return FALSE;
	}
	if ( (vo_.file.image = GlobalLock(vo_.file.mapH)) == NULL ){
		VO_error(PPERROR_GETLASTERROR);
		CloseHandle(hFile);
		return FALSE;
	}
	// wb_擾
	memset( vo_.file.image + vo_.file.UseSize, 0, FILEBUFMARGIN);
	vo_.file.ImageSize = vo_.file.UseSize;
	size = min(vo_.file.UseSize, 0x1000);

	starttime = GetTickCount();
	if ( ReadFile(hFile, vo_.file.image, size, &vo_.file.UseSize, NULL) == FALSE ){
		VO_error(PPERROR_GETLASTERROR);
		CloseHandle(hFile);
		return FALSE;
	}
	if ( vo_.file.ImageSize > vo_.file.UseSize ){	// ŏ͑߂Ƀt@Cǂݍ
		tick = GetTickCount();
		ReadStep = 0x20000;
		ReadingStream = READ_FILE;
		hReadStream = hFile;
		ReadEnter++;
		if ( (tick - starttime) < READINTERVAL_FILEREAD ) ReadData(tick);
		ReadEnter--;
	}else{
		CloseHandle(hFile);
	}
	if ( vo_.file.image != NULL ){
		memset(vo_.file.image + vo_.file.UseSize, 0, FILEBUFMARGIN);
		return TRUE;
	}else{
		return FALSE;
	}
}
// qXgJ[\ʒuȂǂ擾 -----------------------------------------
void PPVGetHist(void)
{
	const TCHAR *vp;

	VOsel.now.y.line = -1; // w
	if ( IsTrue(vo_.file.memdata) ) return;

	UsePPx();
	vp = SearchHistory(PPXH_PPVNAME, vo_.file.name);
	if ( vp != NULL ){
		int datasize = GetHistoryDataSize(vp) - sizeof(int) * 3;
		if ( datasize >= 0 ){
			const BYTE *bp;

			bp = (const BYTE *)GetHistoryData(vp);
			if ( *bp == (BYTE)vo_.SupportTypeFlags ){ // \`vĂƎvȂ痘p
				vo_.DModeType = *(bp + 1);
				VOi = &VO_I[vo_.DModeType];
				if ( vo_.DModeType == DISPT_IMAGE ){
					vo_.bitmap.rotate = *(bp + 3);
				}else{
					BYTE bpflags;

					VOi->textC = *(bp + 2);
					bpflags = *(bp + 3);
					if ( bpflags & HISTOPT_TEXTOPT_MIME ){
						VO_Tmime = 1;
					}
					if ( bpflags & HISTOPT_TEXTOPT_ESC ){
						VO_Tesc = 0;
					}
					if ( bpflags & HISTOPT_TEXTOPT_TAGMASK ){
						VO_Ttag = (bpflags >> HISTOPT_TEXTOPT_TAGSHIFT) - 1;
					}
				}
				if ( !(mtinfo.OpenFlags & PPV__NoGetPosFromHist) ){
					VOi->offX = *(int *)(bp + 4);
					VOi->offY = *(int *)(bp + 8);
				}
				bp += sizeof(int) * 3;
				while ( datasize > 0 ){
					BYTE len;

					if ( (BYTE)*(bp + 1) <= (HISTOPTID_BookmarkMin + MaxBookmark) ){
						int bkindex = (BYTE)*(bp + 1) - HISTOPTID_BookmarkMin;
						if ( *bp == HISTOPTSIZE_Bookmark ){
							Bookmark[bkindex].pos = *(POINT *)(bp + 2);
						}else if ( *bp == HISTOPTSIZE_Bookmark_L ){
							Bookmark[bkindex] = *(BookmarkInfo *)(bp + 2);
						}
						setflag(ShowTextLineFlags, SHOWTEXTLINE_BOOKMARK);
					}else if ( (BYTE)*(bp + 1) == HISTOPTID_OLDTAIL ){
						TailModeFlags = 1;
						OldTailLine = *(int *)(bp + 2);
						setflag(ShowTextLineFlags, SHOWTEXTLINE_OLDTEXT);
					}else if ( (BYTE)*(bp + 1) == HISTOPTID_OTHERCP ){
						ChangeOtherCodepage(*(WORD *)(bp + 2));
					}else if ( (BYTE)*(bp + 1) == HISTOPTID_WIDTH ){
						VOi->width = *(int *)(bp + 2);
					}else if ( (BYTE)*(bp + 1) == HISTOPTID_CARET ){
						VOsel.now.x.offset = *(int *)(bp + 2);
						VOsel.now.y.line = *(int *)(bp + 6);
					}
					len = (BYTE)*bp;
					if ( len == 0 ) break;
					datasize -= len;
					bp += len;
				}
			}
		}
	}
	FreePPx();
	if ( !(mtinfo.OpenFlags & PPV__NoGetPosFromHist) ){
		mtinfo.PresetY = VOi->offY;
	}
}

void SetOpts(VIEWOPTIONS *viewopts)
{
	if ( viewopts->history >= 0 ) VO_history = viewopts->history;
	if ( viewopts->dtype == DISPT_DOCUMENT ){ // tB^̎s
		TCHAR cmd[CMDLINESIZE];
		TCHAR tempfile[VFPS];

		if ( vo_.file.other.image != NULL ){ // tB^sς
			vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
		}else{
			cmd[0] = '\0';
			ThGetString(NULL, StrDocFilterCmd, cmd, CMDLINESIZE);
			if ( cmd[0] != '\0' ){
				tstrcpy(tempfile, T("tempfile.txt"));
				MakeTempEntry(VFPS, tempfile, FILE_ATTRIBUTE_LABEL);
				ThSetString(NULL, T("TempFile"), tempfile);
				if ( PP_ExtractMacro(vinfo.info.hWnd, &vinfo.info, NULL, cmd, NULL, XEO_SEQUENTIAL) == NO_ERROR ){
					char *mem = NULL;
					SIZE32_T size;
					ERRORCODE result;

					result = LoadFileImage(tempfile, 0x40, &mem, &size, LFI_ALWAYSLIMITLESS);
					if ( result == NO_ERROR ){
						DeleteFileL(tempfile);
						vo_.file.other.UseSize = vo_.file.other.ImageSize = size;
						vo_.file.other.mapH = GlobalAlloc(GMEM_MOVEABLE, size);
						if ( vo_.file.other.mapH != NULL ){
							vo_.file.other.type = 0;
							VOi->img = vo_.file.other.image = (BYTE *)GlobalLock(vo_.file.other.mapH);
							memcpy(vo_.file.other.image, mem, vo_.file.other.ImageSize);
							vo_.SupportTypeFlags = VO_type_ALLDOCUMENT;
							mtinfo.MemSize = vo_.file.other.UseSize;

							if ( viewopts->T_code >= 0 ){
								VOi->textC = viewopts->T_code;
								if ( VOi->textC >= VTYPE_MAX ){
									SetOtherCodepage(VOi->textC);
								}
							}
							MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
						}
						HeapFree(GetProcessHeap(), 0, mem);
					}
				}
			}
		}
	}

	if ( (viewopts->dtype >= 0) &&
		 ((vo_.SupportTypeFlags >> (viewopts->dtype - 1)) & LSBIT) ){
		vo_.DModeType = viewopts->dtype;
		VOi = &VO_I[vo_.DModeType];

		if ( vo_.DModeType == DISPT_RAWIMAGE ){
			VOi->width = VOi->defwidth = -1;
			VOi->textC = 32; // 32bit (R10G10B10) / R5G6B5
		}
	}
	if ( viewopts->T_code >= 0 ){
		VOi->textC = viewopts->T_code;
		if ( VOi->textC >= VTYPE_MAX ){
			SetOtherCodepage(VOi->textC);
		}
	}
	if ( viewopts->T_siso >= 0 ) VO_Tmode = viewopts->T_siso;
	if ( viewopts->T_esc  >= 0 ) VO_Tesc = viewopts->T_esc;
	if ( viewopts->T_mime >= 0 ) VO_Tmime = viewopts->T_mime;
	if ( viewopts->T_tag  >= 0 ) VO_Ttag = viewopts->T_tag;
	if ( viewopts->T_show_css >= 0 ) VO_Tshow_css = viewopts->T_show_css;
	if ( viewopts->T_show_script >= 0 ) VO_Tshow_script = viewopts->T_show_script;
	if ( viewopts->T_tab  >= 1 ) VOi->tab = viewopts->T_tab;
	if ( viewopts->T_width >= 0 ){
		VOi->defwidth = viewopts->T_width - VIEWOPTIONS_WIDTHOFFSET;
		VOi->width = FixedWidthRange(VOi->defwidth);
	}
	if ( (viewopts->I_animate >= 0) && (vo_.bitmap.page.do_animate != viewopts->I_animate) ){
		vo_.bitmap.page.do_animate = viewopts->I_animate;
		if ( vo_.bitmap.page.do_animate == FALSE ){
			KillTimer(vinfo.info.hWnd, TIMERID_ANIMATE);
		}
	}
	if ( viewopts->tailflags >= 0 ){
		TailModeFlags = (DWORD)viewopts->tailflags;
	}

	if ( viewopts->linespace >= 0 ){
		LineY = fontY + viewopts->linespace;
		if ( LineY < 1 ) LineY = 1;
	}
}

int GetPPvTextCode(const BYTE *image, DWORD size)
{
	int textC;

	textC = GetFileCodeType(vo_.file.name, image, size);
	if ( textC >= VTYPE_MAX ){
		if ( textC == CP__UTF16L ){
			textC = VTYPE_UNICODE;
		}else if ( textC == CP__UTF16B ){
			textC = VTYPE_UNICODEB;
		}else if ( textC == CP_UTF8 ){
			textC = VTYPE_UTF8;
		}else{
			textC += VTYPE_MAX;
		}
	}
	return textC;
}

// \ -------------------------------------------------------------------
void InitViewObject(VIEWOPTIONS *viewopts, TCHAR *type)
{
	VOi = &VO_I[vo_.DModeType];
	vo_.file.reading = TRUE;
	VO_Tmode = VO_Tmodedef;
	if ( vo_.OtherCP.changed < CHANGECP_MANUAL ){
		vo_.OtherCP.changed = CHANGECP_SEARCH;
	}
	ScrollWidth = ScrollWidth_MIN;

	vo_.DModeBit = DOCMODE_NONE; // oOp
//	ThSetString(NULL, StrDocFilterCmd, NilStr);

	if ( type != NULL ){ // ߂Ă̓ǂݍ݂Ȃ̂Őݒ擾
		TCHAR optbuf[CMDLINESIZE];
		VIEWOPTIONS viewo;

		if ( NO_ERROR == GetCustTable(T("XV_opts"), type, &optbuf, sizeof(optbuf)) ){
			CheckParam(&viewo, optbuf, NULL);
//			XMessage(NULL, NULL, XM_DbgLOG, T("SetOpts - use XV_opts type"));
			SetOpts(&viewo);
		}else{
			TCHAR *ext;

			ext = VFSFindLastEntry(vo_.file.name);
			ext += FindExtSeparator(ext);
			if ( *ext != '\0' ) ext++;
			if ( NO_ERROR == GetCustTable(T("XV_opts"), ext, &optbuf, sizeof(optbuf)) ){
				CheckParam(&viewo, optbuf, NULL);
//				XMessage(NULL, NULL, XM_DbgLOG, T("SetOpts - use XV_opts ext"));
				SetOpts(&viewo);
			}
		}
	}
	if ( viewopts != NULL ){
//				XMessage(NULL, NULL, XM_DbgLOG, T("SetOpts - use viewopt"));
		SetOpts(viewopts);
	}

	switch( vo_.DModeType ){
		case DISPT_HEX: //-----------------------------------------------------
			vo_.DModeBit = DOCMODE_HEX;

			if ( VOi->img == NULL ){
				VOi->width = HEXWIDTH;
				VOi->line = ((vo_.file.UseSize + 15) >> 4);
				VOi->tab = 1;
				VOi->img = vo_.file.image;
			}
			if ( (VOi->textC < 0) || (VOi->textC >= VTYPE_MAX) ){
				VOi->textC = VTYPE_SYSTEMCP;
			}
			break;

		case DISPT_TEXT: //----------------------------------------------------
			vo_.DModeBit = DOCMODE_TEXT;

			if ( VOi->img == NULL ){
															// R[h 
				if ( (VOi->textC < 0) || (VOi->textC >= VTYPE_MAX) ){
					VOi->textC = GetPPvTextCode(vo_.file.image, vo_.file.UseSize);
					if ( VOi->textC >= VTYPE_MAX ){
						SetOtherCodepage(VOi->textC - VTYPE_MAX);
					}
				}
				VOi->img = vo_.file.image;
				mtinfo.MemSize = vo_.file.UseSize;
				MakeIndexTable(MIT_FIRST, MIT_PARAM_TEXT);
			}
			break;

		case DISPT_IMAGE: //------------------------------------------------
			vo_.DModeBit = DOCMODE_BMP;

			if ( !memcmp(vo_.file.image, "GIF8", 4) ){
				InitGIF(NULL);
			}else if ( !memcmp(vo_.file.image, "\x89PNG", 4) ){
				InitPNG(NULL);
			}else if ( !memcmp(vo_.file.image, "II*", 4) ||
					   !memcmp(vo_.file.image, "MM\0*", 4) ){
				InitTIFF(NULL);
			}else if ( (vo_.bitmap.page.type == PAGETYPE_PLUGIN) &&
				 (vo_.bitmap.page.animate_time > 0) ){
				if ( vo_.bitmap.page.do_animate ){
					SetTimer(vinfo.info.hWnd, TIMERID_ANIMATE,
							vo_.bitmap.page.animate_time, AnimateProc);
				} else{
					SetPopMsg(POPMSG_NOLOGMSG, MES_IANI, PMF_DOCMSG);
				}
			}

			if ( vo_.bitmap.ShowInfo == NULL ){
				vo_.bitmap.ShowInfo = vo_.bitmap.info;
				CreateDIBtoPalette(&vo_);
			}
			if ( vo_.bitmap.info->biBitCount == 32 ){
				if ( vo_.bitmap.info->biCompression != BI_BITFIELDS ){
					vo_.bitmap.transcolor = 0; // 񂪖Ƃ͏ɓ
				}else{
					if ( (vo_.bitmap.info->biSize >= (sizeof(BITMAPINFOHEADER) + sizeof(DWORD) * 4)) &&
						 (*(DWORD *)(BYTE *)((BYTE *)vo_.bitmap.info + sizeof(BITMAPINFOHEADER) + sizeof(DWORD) * 3) != 0) ){
						vo_.bitmap.transcolor = 0; // 񂪂
					}
				}
			}
			break;

		case DISPT_DOCUMENT: //------------------------------------------------
			if ( vo_.DocmodeType == DOCMODE_NONE ){
				vo_.DocmodeType = DOCMODE_TEXT;
			}
			if ( vo_.DocmodeType & VO_dmode_IMAGE ){
				vo_.DModeBit = vo_.DocmodeType;
			}else if ( VOi->img == NULL ){
				VOi->img = mtinfo.img;
				vo_.DModeBit = DOCMODE_TEXT;
				// mtinfo.MemSize
				MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
			}else{
				if ( vo_.file.other.image != NULL ){ // R[h(wordx)
					if ( vo_.file.other.image != mtinfo.img ){
						VOi->img = vo_.file.other.image;
						mtinfo.MemSize = vo_.file.other.UseSize;
						if ( vo_.file.other.type == 1 ){
							VO_Tesc = 0;
							VO_Ttag = 1;
						}
						MakeIndexTable(MIT_FIRST, MIT_PARAM_DOCUMENT);
					}
				}
				vo_.DModeBit = vo_.DocmodeType;
			}
			break;

		case DISPT_RAWIMAGE: //------------------------------------------------
			vo_.DModeBit = DOCMODE_RAWIMAGE;

			if ( RawBmpState == 0 ){
				RawBmpState = 1;
				VOi->textC = 24;
				if ( RawBmpWidth < 0 ){
					if ( XV.img.imgD[imdD_MAG] <= 0 ){
						RawBmpWidth = WndSize.cx;
					}else{
						RawBmpWidth = WndSize.cx * 100 / XV.img.imgD[imdD_MAG];
					}
				}
				SetPopMsg(POPMSG_NOLOGMSG, MES_NRGU, PMF_DOCMSG);
			}

			// TCY SetScrollBar() łȂ
			temp_DIB.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
			temp_DIB.bmiHeader.biWidth = 1; // 
			temp_DIB.bmiHeader.biHeight = 1; // 
			temp_DIB.bmiHeader.biPlanes = 1;
			temp_DIB.bmiHeader.biBitCount = (WORD)(VOi->textC & 0x3f);
			temp_DIB.bmiHeader.biSizeImage = 0; // FixOpenBmp ŏC
			temp_DIB.bmiHeader.biXPelsPerMeter = 0;
			temp_DIB.bmiHeader.biYPelsPerMeter = 0;

			if ( vo_.bitmap.hPal != NULL ){
				DeleteObject(vo_.bitmap.hPal);
				vo_.bitmap.hPal = NULL;
			}
			vo_.bitmap.ShowInfo = vo_.bitmap.info = &temp_DIB.bmiHeader;
			vo_.bitmap.bits.ptr = vo_.file.image;
									// pbg / rbgtB[h
			if ( VOi->textC >= 16 ){ // 16/24/32
				if ( VOi->textC != 24 ){
					temp_DIB.bmiHeader.biCompression = BI_BITFIELDS;
				}else{
					temp_DIB.bmiHeader.biCompression = BI_RGB;
				}
				temp_DIB.bmiHeader.biClrUsed = 0;
				temp_DIB.bmiHeader.biClrImportant = 0;
				temp_DIB.bmiColors[3] = 0;

				if ( temp_DIB.bmiHeader.biBitCount == 16 ){ // 16bit
					if ( VOi->textC & B6 ){ // R5G6B5
						temp_DIB.bmiColors[0] = 0xf800;
						temp_DIB.bmiColors[1] = 0x07e0;
						temp_DIB.bmiColors[2] = 0x001f;
						if ( VOi->textC & B7 ){ // т RGB
							temp_DIB.bmiColors[2] = 0xf800;
							temp_DIB.bmiColors[0] = 0x001f;
						}
					}else{ // R5G5B5
						temp_DIB.bmiColors[0] = 0x7c00;
						temp_DIB.bmiColors[1] = 0x03e0;
						temp_DIB.bmiColors[2] = 0x001f;
						if ( VOi->textC & B7 ){ // т RGB
							temp_DIB.bmiColors[0] = 0x001f;
							temp_DIB.bmiColors[2] = 0x7c00;
						}
					}
				}else if ( VOi->textC & B6 ){ // 32bit (R10G10B10)
					temp_DIB.bmiColors[0] = 0x3ff00000;
					temp_DIB.bmiColors[1] = 0x000ffc00;
					temp_DIB.bmiColors[2] = 0x000003ff;
					if ( VOi->textC & B7 ){ // т RGB
						temp_DIB.bmiColors[0] = 0x000003ff;
						temp_DIB.bmiColors[2] = 0x3ff00000;
					}
				}else{ // 24/32bit
					temp_DIB.bmiColors[0] = 0xff0000;
					temp_DIB.bmiColors[1] = 0x00ff00;
					temp_DIB.bmiColors[2] = 0x0000ff;
					if ( VOi->textC & B7 ){ // т RGB
						temp_DIB.bmiColors[0] = 0x0000ff;
						temp_DIB.bmiColors[2] = 0xff0000;
					}
					if ( temp_DIB.bmiHeader.biBitCount == 32 ){
						vo_.bitmap.transcolor = 0;
					}
				}
			}else{ // 1/4/8
				temp_DIB.bmiHeader.biCompression = BI_RGB;

				switch ( temp_DIB.bmiHeader.biBitCount ){
					case 1:
						temp_DIB.bmiColors[0] = 0x000000;
						temp_DIB.bmiColors[1] = 0xffffff;
						break;
					case 8: {
						int ci;
						for ( ci = 16; ci < 256; ci++){
							temp_DIB.bmiColors[ci] = ((ci & 0x7) << 5) | ((ci & 0x38) << 10) | ((ci & 0xc0) << 16);
						}
					}
//					case 4:
					default:
						memcpy(temp_DIB.bmiColors, Palette16, sizeof(Palette16));
						break;
				}
				// LOGPALETTE ̂ʓ|Ȃ̂ŁAtemp_DIB ܂킷
				temp_DIB.bmiHeader.biClrImportant =
					  /* palVersion */ 0x300
					+ /* palNumEntries */ (temp_DIB.bmiHeader.biClrUsed << 16);
				vo_.bitmap.hPal = CreatePalette((LOGPALETTE *)&temp_DIB.bmiHeader.biClrImportant);

				temp_DIB.bmiHeader.biClrImportant =
						temp_DIB.bmiHeader.biClrUsed = 1 << temp_DIB.bmiHeader.biBitCount;
			}
			InitRawImageRectSize();
			break;
	}
	if ( viewopt_opentime.dtype <= 0 ){
		viewopt_opentime.dtype = vo_.DModeType;
		viewopt_opentime.T_code = VOi->textC;
		viewopt_opentime.T_siso = VO_Tmode;
		viewopt_opentime.T_esc = VO_Tesc;
		viewopt_opentime.T_mime = VO_Tmime;
		viewopt_opentime.T_tag = VO_Ttag;
		viewopt_opentime.T_tab = -1;
		viewopt_opentime.T_width = VOi->width;
		viewopt_opentime.I_animate = vo_.bitmap.page.do_animate;
		viewopt_opentime.I_CheckeredPattern = viewopt_def.I_CheckeredPattern;
		viewopt_opentime.linespace = -1;
	}
	if ( vo_.DModeBit & DOCMODE_TEXT ){
		GetAsyncKeyState(VK_PAUSE); // ǂݎ̂(ŉbit΍)
		while ( vo_.file.reading != FALSE ){
			if ( (VOi->offY + READLINE_SUPP) < VOi->line ) break;
			MakeIndexTable(MIT_NEXT, READLINE_SUPP);
			if ( GetAsyncKeyState(VK_PAUSE) & KEYSTATE_FULLPUSH ) break;
		}
	}
	if ( (type == NULL) || (XV.img.imgD[imdD_MAG] > IMGD_WINDOWSIZE) ){
		SetScrollBar();
	}

	if ( (ReadingStream != READ_NONE) ||
		 ((vo_.DModeBit & VO_dmode_ENABLEBACKREAD) && (vo_.file.reading != FALSE) && (vo_.file.UseSize > 0)) ){
		BackReader = TRUE;
		SetTimer(vinfo.info.hWnd, TIMERID_READLINE, TIME_READLINE, BackReaderProc);
	}else{
		mtinfo.OpenFlags = 0;
	}
}

void SetTitle(const TCHAR *title, const TCHAR *ext)
{
	TCHAR buf[VFPS * 2];

	if ( runasstate == NULL ) runasstate = CheckRunAs();
	if ( runasstate != NULL ){
		thprintf(buf, TSIZEOF(buf), T("PPV[%c](%s)%s"), RegID[2], runasstate, title);
	}else{
		thprintf(buf, TSIZEOF(buf), T("PPV[%c]%s"), RegID[2], title);
	}
	if ( ext != NULL ){
		TCHAR extbuf[MAX_PATH];

		thprintf(extbuf, TSIZEOF(extbuf), T(".%s"), ext);
		tstrcat(buf, extbuf);
		tstrcat(vo_.file.name, extbuf);
	}
	SetWindowText(vinfo.info.hWnd, buf);
}

BOOL FixAspectRate(BITMAPINFOHEADER *bih)					// AXyNg䒲
{
	XV.img.AspectW = bih->biXPelsPerMeter / 39;
	XV.img.AspectH = bih->biYPelsPerMeter / 39;
	if ( XV.img.imgD[imdD_ASPACT] >= ASPECTMODE_AUTO ){ // ASPECTMODE_OFF
		XV.img.AspectRate = (bih->biYPelsPerMeter == 0) ? ASPACTX : ((bih->biXPelsPerMeter * ASPACTX) / bih->biYPelsPerMeter);

		if ( XV.img.AspectRate != ASPACTX ){
			if ( ( (XV.img.imgD[imdD_ASPACT] != ASPECTMODE_AUTO) &&
				   (XV.img.AspectRate > 0) ) ||
				 ( (XV.img.AspectRate <= (ASPACTX * 3)) &&
				   (XV.img.AspectRate >= (ASPACTX / 3)) &&
				   !((XV.img.AspectRate > (ASPACTX - (ASPACTX / 10))) &&
					 (XV.img.AspectRate < (ASPACTX + (ASPACTX / 10))))) ){
				return TRUE; // L
			}
		}
	}
	XV.img.AspectRate = 0;
	return FALSE; // sv
}

BOOL USEFASTCALL FixOpenBmp(BITMAPINFOHEADER *bih, VIEWOPTIONS *viewopt, size_t bits_size)
{
	XV.img.MonoStretchMode = 0;
	vo_.bitmap.rawsize.cx = bih->biWidth;
	vo_.bitmap.rawsize.cy = bih->biHeight;
	FixBitmapShowSize(&vo_);

	if ( (bih->biClrUsed == 0) && (bih->biBitCount <= 8) ){
		bih->biClrUsed = 1 << bih->biBitCount;
	}

	if ( (bih->biSize == BITMAPV4HEADERsize) ||
		 ((bih->biSize == BITMAPV5HEADERsize) && (((xBITMAPV5HEADER *)bih)->bV5ProfileSize > 0)) ){
		if ( viewopt_def.I_ColorProfile > 0 ){
			vo_.bitmap.UseICC = ICM_ON;
		}else{
			vo_.bitmap.UseICC = ICM_OFF;
			SetPopMsg(POPMSG_NOLOGMSG, MES_IICC, PMF_DOCMSG);
		}
	}
	if ( bih->biSizeImage == 0 ){ // TCY񖳂
		if ( (bih->biCompression == BI_RGB) || (bih->biCompression == BI_BITFIELDS) ){
			bih->biSizeImage = DwordBitSize(vo_.bitmap.rawsize.cx * bih->biBitCount) * vo_.bitmap.rawsize.cy;
		}else{
			return FALSE;
		}
	}

	if ( (size_t)bih->biSizeImage > bits_size ){ // wb_̃TCYrbg}bv傫
	#ifdef _WIN64
		if ( bits_size > MAX32 ) return FALSE; // C[W傫
	#endif
		bih->biSizeImage = (DWORD)bits_size;
		if ( (bih->biCompression == BI_RGB) || (bih->biCompression == BI_BITFIELDS) ){
			int newheight = bih->biSizeImage / DwordBitSize(vo_.bitmap.rawsize.cx * bih->biBitCount);

			bih->biHeight = (bih->biHeight >= 0) ? newheight : -newheight;
			if ( bih->biHeight == 0 ) return FALSE; // C[WPC
		}
	}
	if ( bih->biBitCount == 64 ){								// W
		WORD *ptr, *ptrmax;
		BYTE *destptr;

		bih->biBitCount = 32;
		ptr = (WORD *)vo_.bitmap.bits.ptr;
		ptrmax = (WORD *)(BYTE *)(vo_.bitmap.bits.ptr + bits_size - 1);
		destptr = vo_.bitmap.bits.ptr;
		for ( ;; ){ // 8bit ɔ[߂
			WORD pix;
			pix = (WORD)(*ptr++ >> 4);
			if ( pix >= 0x100 ) pix = 0xff;
			*destptr++ = (BYTE)pix;
			if ( ptr >= ptrmax ) break;
		}
	}

	if ( FixAspectRate(bih) ){
		TCHAR buf[64];

		thprintf(buf, TSIZEOF(buf), T("%s %d:%d"), MES_ASRA, XV.img.AspectW, XV.img.AspectH);
		SetPopMsg(POPMSG_NOLOGMSG, buf, PMF_DOCMSG);
	}

	PPVGetHist();
	InitViewObject(viewopt, NULL);

	if ( (viewopt != NULL) ? (viewopt->I_CheckeredPattern == 1) : (viewopt_def.I_CheckeredPattern == 1) ){
		if ( vo_.bitmap.transcolor >= 0 ) ModifyAlpha();
	}
	return TRUE;
}

BOOL OpenCursorIconObject(const TCHAR *filename, VIEWOPTIONS *viewopt)
{
	int offset;
	BITMAPINFOHEADER *bih, *tempbih;
	const TCHAR *imagetypename;

	if ( convert || (ReadAll() <= 0) ){
		VO_error(PPERROR_GETLASTERROR);
		return FALSE;
	}
	if ( vo_.file.UseSize < (0x16 /* ICONDIR + ICONDIRENTRY */ + sizeof(BITMAPINFOHEADER)) ) return FALSE;
										// ICONDIR.idEntries[0].dwImageOffset;
	tempbih = (BITMAPINFOHEADER *)((BYTE *)vo_.file.image + *(DWORD *)(vo_.file.image + 0x12));
	if ( (DWORD_PTR)(((BYTE *)tempbih - (BYTE *)vo_.file.image) + 0x10) > vo_.file.UseSize ) return FALSE;
	if ( tempbih->biSize != sizeof(BITMAPINFOHEADER) ) return FALSE;
	if ( *(vo_.file.image + 02) == '\1' ){
		imagetypename = T("ico");
		tstrcpy(vo_.file.typeinfo, T("icon"));
	}else{
		imagetypename = T("cur");
		tstrcpy(vo_.file.typeinfo, T("cursor"));
	}

	vo_.bitmap.info = tempbih;

	if ( IsTrue(vo_.file.memdata) ) SetTitle(filename, imagetypename);

	vo_.SupportTypeFlags = VO_type_ALLIMAGE;
	vo_.DModeType = DISPT_IMAGE;

	offset = CalcBmpHeaderSize(vo_.bitmap.info);
	vo_.bitmap.ShowInfo = (BITMAPINFOHEADER *)HeapAlloc(PPvHeap, 0, offset);
	if ( vo_.bitmap.ShowInfo == NULL ) return FALSE;
	bih = vo_.bitmap.ShowInfo;
	vo_.bitmap.AllocShowInfo = TRUE;

	memcpy(bih, vo_.bitmap.info, offset);

	bih->biHeight /= 2;

	vo_.bitmap.bits.ptr = (BYTE *)vo_.bitmap.info + offset;
	return FixOpenBmp(bih, viewopt, vo_.file.UseSize - offset );
}

BOOL OpenBmpObject(const TCHAR *filename, VIEWOPTIONS *viewopt)
{
	BITMAPINFOHEADER *bih;
	DWORD bmpoffset, offset;

	if ( convert || (ReadAll() <= 0) ){
		VO_error(PPERROR_GETLASTERROR);
		return FALSE;
	}

	if ( IsTrue(vo_.file.memdata) ) SetTitle(filename, T("bmp"));

	vo_.bitmap.info = (BITMAPINFOHEADER *)(vo_.file.image + sizeof(BITMAPFILEHEADER));
	bih = vo_.bitmap.info;

	switch ( vo_.bitmap.info->biSize ){
		case sizeof(BITMAPCOREHEADER):	// OS/2 ` 0x0c bcBitCount ܂
			if ( temp_DIB_ptr == NULL ){
				temp_DIB_ptr = LocalAlloc(LMEM_FIXED, sizeof(BITMAPINFOHEADER) + (0x100 * sizeof(RGBQUAD)));
				if ( temp_DIB_ptr == NULL ) return FALSE;
			}
			vo_.bitmap.ShowInfo = bih = temp_DIB_ptr;

			bih->biSize = sizeof(BITMAPINFOHEADER);
			bih->biWidth = ((BITMAPCOREHEADER *)vo_.bitmap.info)->bcWidth;
			bih->biHeight = ((BITMAPCOREHEADER *)vo_.bitmap.info)->bcHeight;
			if ( bih->biHeight & B15 ) bih->biHeight = -(0x10000 - bih->biHeight);
			bih->biPlanes = ((BITMAPCOREHEADER *)vo_.bitmap.info)->bcPlanes;
			bih->biBitCount = ((BITMAPCOREHEADER *)vo_.bitmap.info)->bcBitCount;
			bih->biSizeImage = 0; // FixOpenBmp ŏC
			bih->biCompression = BI_RGB;
			bih->biXPelsPerMeter = 3780;
			bih->biYPelsPerMeter = 3780;
			bih->biClrImportant = bih->biClrUsed = 0;
			tstrcpy(vo_.file.typeinfo, T("DIB(OS/2)"));
			if ( bih->biBitCount <= 8 ){
				DWORD c;
				DWORD *WinPal;
				RGBTRIPLE *OS2Pal;

				OS2Pal = (RGBTRIPLE *)((BYTE *)vo_.bitmap.info + vo_.bitmap.info->biSize);
				WinPal = (DWORD *)((BYTE *)bih + bih->biSize);
				bih->biClrImportant = bih->biClrUsed = 1 << bih->biBitCount;
				for ( c = 0 ; c < bih->biClrUsed ; c++ ){
					*WinPal++ = OS2Pal->rgbtBlue + (OS2Pal->rgbtGreen << 8) + (OS2Pal->rgbtRed << 16);
					OS2Pal++;
				}
			}
			break;

		case sizeof(BITMAPINFOHEADER): // 0x28
			tstrcpy(vo_.file.typeinfo, T("DIB"));
			break;

		case 0x40:	// OS/2 v2 `(OS22XBITMAPHEADER) 0x40
			// 0`0x28BITMAPINFOHEADERƓA0x28`0x40
			tstrcpy(vo_.file.typeinfo, T("DIB(OS/2v2)"));
			break;

		case 0x6c:
			tstrcpy(vo_.file.typeinfo, T("DIBv4"));
			break;

		case 0x7c:
			tstrcpy(vo_.file.typeinfo, T("DIBv5"));
			break;

		default:
			thprintf(vo_.file.typeinfo, TSIZEOF(vo_.file.typeinfo), T("DIB(undefined %xh)"), vo_.bitmap.info->biSize);
			if ( bih->biSize < sizeof(BITMAPINFOHEADER) ) return FALSE;
	}
	if ( (bih->biWidth == 0) || (bih->biWidth & B31) || (bih->biHeight == 0) ){
		return FALSE;
	}

	if ( bih->biPlanes >= 2 ) bih->biPlanes = 1; // ُf[^΍
	if ( bih->biClrUsed > 256 ) bih->biClrUsed = 0; // ُf[^΍


	offset = CalcBmpHeaderSize(vo_.bitmap.info);
	bmpoffset = ((BITMAPFILEHEADER *)vo_.file.image)->bfOffBits;
	if ( bmpoffset > offset ){
		vo_.bitmap.bits.ptr = vo_.file.image + bmpoffset;
	}else{
		vo_.bitmap.bits.ptr = (BYTE *)vo_.bitmap.info + offset;
	}

	vo_.DModeType = DISPT_IMAGE;
	vo_.SupportTypeFlags = VO_type_ALLIMAGE;

	if ( (bih->biCompression == BI_RLE4) || (bih->biCompression == BI_RLE8) ){
		BYTE *ptr, *maxptr;

		// f[^jĂȂ؂
		ptr = vo_.bitmap.bits.ptr;
		maxptr = vo_.file.image + vo_.file.UseSize;
		if ( bih->biCompression == BI_RLE8 ){
			if ( bih->biBitCount != 8 ) goto RleError; // Fsv
			for (;;){
				if ( ptr >= maxptr ) goto RleError;
				if ( *ptr == 0 ){ // escape
					BYTE second;

					second = *(ptr + 1);
					if ( second == 0 ){ // s
						ptr += 2;
						continue;
					}
					if ( second == 1 ){ // bmp
						if ( (ptr + 2) > maxptr ) goto RleError;
						break;
					}
					if ( second == 2 ){ // XLbv
						ptr += 4;
						continue;
					}
					// 3`255 Raw
					ptr += (DWORD)((DWORD)second + 1 + 2) & 0x1fe;
					continue;
				}
				// 1-255 packed
				ptr += 2;
				continue;
			}
		}else{ // BI_RLE4
			if ( bih->biBitCount != 4 ) goto RleError; // Fsv
			for (;;){
				if ( ptr >= maxptr ) goto RleError;
				if ( *ptr == 0 ){ // escape
					BYTE second;

					second = *(ptr + 1);
					if ( second == 0 ){ // s
						ptr += 2;
						continue;
					}
					if ( second == 1 ){ // bmp
						if ( (ptr + 2) > maxptr ) goto RleError;
						break;
					}
					if ( second == 2 ){ // XLbv
						ptr += 4;
						continue;
					}
					// 3`255 Raw
					ptr += (DWORD)((((DWORD)second + 1) / 2) + 1 + 2) & 0x1fe;
					continue;
				}
				// 1-255 packed
				ptr += 2;
				continue;
			}
		}
		tstrcat(vo_.file.typeinfo, T("(RLE)"));
	}

	return FixOpenBmp(bih, viewopt,
			vo_.file.UseSize - (vo_.bitmap.bits.ptr - vo_.file.image) );

RleError:
	vo_.DModeType = DISPT_TEXT;
	tstrcat(vo_.file.typeinfo, T("(RLE, broken bitmap)"));
	return FixOpenBmp(bih, viewopt,
			vo_.file.UseSize - (vo_.bitmap.bits.ptr - vo_.file.image) );
}

HGLOBAL OpenViewStdin(void)
{
	DWORD starttick, nowtick;
	HGLOBAL hMemblock;

	vo_.file.memdata = TRUE;
	vo_.file.ImageSize = 0x8000;
	hMemblock = GlobalAlloc(GMEM_MOVEABLE, vo_.file.ImageSize + FILEBUFMARGIN);
	if ( hMemblock == NULL ){
		VO_error(PPERROR_GETLASTERROR);
		return NULL;
	}
	if ( (vo_.file.image = GlobalLock(hMemblock)) == NULL ){
		GlobalFree(hMemblock);
		VO_error(PPERROR_GETLASTERROR);
		return NULL;
	}
	vo_.file.mapH = hMemblock;
	vo_.file.UseSize = 0;
	ReadingStream = READ_STDIN;
	hReadStream = GetStdHandle(STD_INPUT_HANDLE);
	ReadEnter++;

	starttick = nowtick = GetTickCount();
	for ( ;; ){
		if ( IsTrue(ReadData(nowtick)) ) break;
		nowtick = GetTickCount();
		if ( (nowtick - starttick) > 200 ) break;
		Sleep(0);
	}
	ReadEnter--;
	return hMemblock;
}

// t@CJ -------------------------------------------------------------
BOOL OpenViewObject(const TCHAR *filename, HGLOBAL hMemblock, VIEWOPTIONS *viewopt, int flags)
{
	if ( OpenEntryNow != 0 ) return FALSE;
	OpenEntryNow = 1;
	mtinfo.OpenFlags = flags;
#if COUNTREADTIME
	readstartTick = GetTickCount();
#endif
	vo_.file.memdata = FALSE;
	CloseViewObject();

	PreFrameInfo.page = PreFramePage_NoCheck;

	if ( viewopt != NULL ){
		VO_optdata = *viewopt;
		VO_opt = &VO_optdata;
	}else{
		VO_opt = NULL;
	}
	SetTitle(filename, NULL);
	tstrcpy(vo_.file.typeinfo, T("Loading file"));
	vo_.file.IsFile = 0;

	if ( ! (flags & PPV__reload) ){
		LetHL_0(FileDividePointer);
		FileDivideMode = FDM_NODIV;
	}
										// fileimage ǂݍ ---------------
	if ( hMemblock == NULL ){ // t@Cǂݍ
		if ( flags & PPV__stdin ){	// W
			hMemblock = OpenViewStdin();
			if ( hMemblock == NULL ) goto error;
		}else{
			if ( OpenViewFile(filename, flags) == FALSE ) goto error;
		}
		if ( vo_.file.image == NULL ) goto error; // 1.77+2 łĂȂNULLL邽߁A`FbN
	}else{	// GlobalAlloc
		vo_.file.memdata = TRUE;
		FileRealSize.s.L = vo_.file.UseSize = (DWORD)GlobalSize(hMemblock);
		if ( vo_.file.UseSize == 0 ){
			VO_error(PPERROR_GETLASTERROR);
			GlobalFree(hMemblock);
			goto error;
		}
		vo_.file.mapH = hMemblock;
		hMemblock = GlobalReAlloc(hMemblock, vo_.file.UseSize + FILEBUFMARGIN, 0);
		if ( hMemblock != NULL ) vo_.file.mapH = hMemblock;
		if ( (vo_.file.image = GlobalLock(vo_.file.mapH)) == NULL ){
			VO_error(PPERROR_GETLASTERROR);
			goto error;
		}
	}

	if ( (PopMsgFlag & PMF_DOCMSG) &&
		 (PopMsgFlag & (PMF_DISPLAYMASK & ~PMF_KEEP)) ){
		StopPopMsg(PMF_STOP);
	}

	tstrcpy(vo_.file.name, filename);
	if ( X_tray & X_tray_PPv ) ShowWindow(vinfo.info.hWnd, SW_RESTORE);
	HideCaret(vinfo.info.hWnd);
	InvalidateRect(vinfo.info.hWnd, &BoxStatus, TRUE);	// XVw
	UpdateWindow_Part(vinfo.info.hWnd);

	//--------------------------------------
	if ( memcmp(vo_.file.image, T("HTTP/1."), 7) == 0 ){
		BYTE *p, *maxptr;

		p = vo_.file.image + 7;
		maxptr = vo_.file.image + vo_.file.UseSize;
		for ( ; p < maxptr ; p++ ){
			if ( memcmp( p, "\r\n\r\n", 4) == 0 ){
				if ( IDOK != PMessageBox(vinfo.info.hWnd, T("HTTP decode?"), T("open"),
						MB_OKCANCEL | MB_SETFOREGROUND | MB_DEFBUTTON1 |
							MB_ICONQUESTION) ){
					 break;
				}
				ThAppend(&vo_.memo, vo_.file.image, (DWORD)(p + 4 - vo_.file.image));
				ThAddString(&vo_.memo, NilStr);
				vo_.file.image = p + 4;
				break;
			}
			if ( (*p == '\r') || (*p == '\n') ||
				  ((*p >= ' ') && (*p <= 'z')) ) continue;
			break;
		}
	}
										// e평 -------------------------
	{
		int count = 0;
		TCHAR keyword[CUST_NAME_LENGTH], param[VFPS], *extptr;
		FN_REGEXP fn;

		extptr = VFSFindLastEntry(vo_.file.name);
		while( EnumCustTable(count++,
				T("XV_tab"), keyword, param, sizeof(param)) >= 0 ){
			TCHAR *p;
			int tab;

			MakeFN_REGEXP(&fn, param);
			if ( FilenameRegularExpression(extptr, &fn) ){
				FreeFN_REGEXP(&fn);
				p = keyword;
				tab = GetIntNumber((const TCHAR **)&p);
				VO_I[DISPT_HEX].tab = VO_I[DISPT_TEXT].tab = VO_I[DISPT_DOCUMENT].tab = tab;
				break;
			}
			FreeFN_REGEXP(&fn);
		}
		count = 0;

		while( EnumCustTable(count++,
				T("XV_cols"), keyword, param, sizeof(param)) >= 0 ){
			TCHAR *p;
			int cols;

			MakeFN_REGEXP(&fn, param);
			if ( FilenameRegularExpression(extptr, &fn) ){
				FreeFN_REGEXP(&fn);
				p = keyword;
				cols = GetIntNumber((const TCHAR **)&p);
				VO_I[DISPT_TEXT].defwidth = VO_I[DISPT_DOCUMENT].defwidth = cols;

				VO_I[DISPT_TEXT].width = VO_I[DISPT_DOCUMENT].width = FixedWidthRange(cols);
				break;
			}
			FreeFN_REGEXP(&fn);
		}
	}
										//  -------------------------------
	if ( !(flags & PPV_HEADVIEW) ){
		int rr;
		VFSGetDibDelayParam ddp;

		ddp.header = VGDDP_HEADER;
		ddp.image = vo_.file.image;
		ddp.size = vo_.file.UseSize;
		ddp.page_number = vo_.bitmap.page.current;
		ddp.request_size.cx = BoxView.right;
		ddp.request_size.cy = BoxView.bottom;
										// susie plug-in 
		rr = VFSGetDibDelay(vo_.file.name, &ddp, sizeof(ddp),
				vo_.file.typeinfo,
				&vo_.bitmap.info_hlocal, &vo_.bitmap.bits.mapH, ReadAll);
		if ( rr < 0 ){ // Ă̂ŉ
			if ( flags & PPV__reload ){
				rr = 0; // ē̂ŃG[
			}else{
				FileDivideMode = FDM_FORCENODIV;
				OpenEntryNow = 0;
				return OpenViewObject(filename, hMemblock, viewopt, flags | PPV__reload);
			}
		}
		if ( ddp.all_pages > 1 ){
			vo_.bitmap.page.type = PAGETYPE_PLUGIN;
			vo_.bitmap.page.animate_time = 0;

			if ( memcmp(vo_.file.image, "GIF8", 4) ){ // gif ȊÔƂ
				if ( vo_.bitmap.page.max == 0 ){
					if ( ddp.state & SUSIE_DECODE_ANIMATION ){
						vo_.bitmap.page.animate_time = ddp.animate_time;

						if ( vo_.bitmap.page.animate_time <= 0 ){
							vo_.bitmap.page.animate_time = TIME_ANIMATE_MIN;
						}
						if ( vo_.bitmap.page.do_animate ){
							SetTimer(vinfo.info.hWnd, TIMERID_ANIMATE,
									vo_.bitmap.page.animate_time, AnimateProc);
						}
					}else{
						KillTimer(vinfo.info.hWnd, TIMERID_ANIMATE);
						SetPopMsg(POPMSG_NOLOGMSG, MES_IPAG, PMF_DOCMSG);
					}
				}
				vo_.bitmap.page.max = ddp.all_pages;
			}
		}

		if ( rr ){
			if ( vo_.bitmap.bits.mapH == NULL ){
				VO_error(ERROR_INVALID_DATA);
				goto error;
			}

			if ( convert ){
				VO_error(PPERROR_GETLASTERROR);
				goto error;
			}
			vo_.bitmap.bits.ptr = LocalLock(vo_.bitmap.bits.mapH);
			vo_.bitmap.info = LocalLock(vo_.bitmap.info_hlocal);
			if ( vo_.bitmap.info != NULL ){
				if ( (vo_.bitmap.info->biWidth != 0) && (vo_.bitmap.info->biHeight != 0) ){
					vo_.SupportTypeFlags = VO_type_ALLIMAGE;
					vo_.DModeType = DISPT_IMAGE;
					if ( X_swmt ) GetMemo();
					if ( FixOpenBmp(vo_.bitmap.info, viewopt,
							LocalSize(vo_.bitmap.bits.mapH)) ){
						goto success;
					}
				}
			}
		}

		if ( vo_.file.image == NULL ){
			VO_error(PPERROR_GETLASTERROR);
			goto error;
		}
										// CUR/ICO 
		if (	(*(vo_.file.image + 00) == '\0')	&&
				(*(vo_.file.image + 01) == '\0')	&&
				((*(vo_.file.image + 02) == '\1') || (*(vo_.file.image + 02) == '\2'))	&&
				(*(vo_.file.image + 03) == '\0') ){
			if ( OpenCursorIconObject(filename, viewopt) != FALSE ){
				goto success;
			}
		}else if ( (vo_.file.UseSize >= 0x16) && (*(DWORD *)(vo_.file.image + 10) < vo_.file.UseSize) &&
				(*(vo_.file.image +  0) == 'B')	&& // BMP 
				(*(vo_.file.image +  1) == 'M')	&&
				(*(vo_.file.image +  6) == 0)	&&
				(*(vo_.file.image +  7) == 0)	&&
				(*(vo_.file.image + 16) == 0)	){
			if ( FileDivideMode == FDM_DIV ){ // Ă̂ŉ
				if ( !(flags & PPV__reload) ){
					FileDivideMode = FDM_FORCENODIV;
					OpenEntryNow = 0;
					return OpenViewObject(filename, hMemblock, viewopt, flags | PPV__reload);
				}
			}else{
				if ( OpenBmpObject(filename, viewopt) != FALSE ) goto success;
			}
		}
	}

	VO_I[DISPT_HEX].textC = VO_I[DISPT_TEXT].textC = -1;
//XMessage(NULL, NULL, XM_DbgLOG, T("openview"));
	CheckType();
	if ( FileDivideMode == FDM_DIV ) SetPopMsg(POPMSG_NOLOGMSG, MES_IDIV, PMF_DOCMSG);

success:
	LoadEvent();
	if ( (vo_.DModeBit & DOCMODE_BMP) && vo_.bitmap.rotate ){ // ]L

//		XMessage(NULL, NULL, XM_DbgDIA, T("%x"),vo_.bitmap.rotate);

		if ( vo_.bitmap.rotate & RotateImage_RL ){
			Rotate(vinfo.info.hWnd, RotateImage_L90_nosave | RotateImage_nosave);
			Rotate(vinfo.info.hWnd, RotateImage_UD | RotateImage_nosave);
			Rotate(vinfo.info.hWnd, RotateImage_R90_nosave | RotateImage_nosave);
		}
		if ( vo_.bitmap.rotate & RotateImage_UD ){
			Rotate(vinfo.info.hWnd, RotateImage_UD | RotateImage_nosave);
		}
		switch (vo_.bitmap.rotate & RotateImage_r_mask){
			case RotateImage_R90:
				Rotate(vinfo.info.hWnd, RotateImage_R90_nosave);
				break;
			case RotateImage_R180:
				Rotate(vinfo.info.hWnd, RotateImage_R90_nosave);
				Rotate(vinfo.info.hWnd, RotateImage_R90_nosave);
				break;
			case RotateImage_R270:
				Rotate(vinfo.info.hWnd, RotateImage_L90_nosave);
				break;
		}
	}
	OpenEntryNow = 0;
	return TRUE;

error:
	OpenEntryNow = 0;
	return FALSE;
}

void LoadEvent(void)
{
	const TCHAR *extname;

	if ( BackReader ) return; //Ǎ/svZ

	if ( FirstCommand != NULL ){
		PostMessage(vinfo.info.hWnd, WM_PPXCOMMAND, K_FIRSTCMD, 0);
	}

	if ( vo_.DModeBit & VO_dmode_IMAGE ){
		extname = T("KV_img");
	}else{
		extname = (VOsel.cursor != FALSE) ? T("KV_crt") : T("KV_page");
	}
	if ( IsExistCustTable(extname, T("LOADEVENT")) ||
		 IsExistCustTable(T("KV_main"), T("LOADEVENT")) ){
		PostMessage(vinfo.info.hWnd, WM_PPXCOMMAND, K_E_LOAD, 0);
	}
}

void GetMemo(void)
{
	VFSFILETYPE vft;
										// t@Cʂ̔Ƃɂ鏉
	if ( vo_.memo.bottom != NULL ) return;
	vft.flags = VFSFT_INFO;

	if ( VFSGetFileType(vo_.file.name, (char *)vo_.file.image, vo_.file.UseSize, &vft) != NO_ERROR ){
		return;
	}

	if ( vft.info != NULL ){
		ThCatString(&vo_.memo, vft.info);
		HeapFree(PPvHeap, 0, vft.info);
	}
}

void CheckType(void)
{
	VFSFILETYPE vft;

//			XMessage(NULL, NULL, XM_DbgLOG, T("CheckType %d"),BackReader);

										// t@Cʂ̔Ƃɂ鏉
	vft.flags = VFSFT_TYPE | VFSFT_TYPETEXT | VFSFT_EXT;
	if ( X_swmt && (vo_.memo.bottom == NULL) ) setflag(vft.flags, VFSFT_INFO);
	if ( VFSGetFileType(vo_.file.name, (char *)vo_.file.image, vo_.file.UseSize, &vft) == NO_ERROR ){
		int codefunc;

		thprintf(vo_.file.typeinfo, TSIZEOF(vo_.file.typeinfo), T("%s(%s)"), vft.typetext, vft.type);
		if ( IsTrue(vo_.file.memdata) ) SetTitle(vo_.file.name, vft.ext);

		vo_.DModeType = LOWORD(vft.dtype); // DISPT_xxx
		VOi = &VO_I[vo_.DModeType];
/*
		if ( VOi->defwidth == WIDTH_AUTOFIX ){
			int newwidth = FixedWidthRange(VOi->defwidth);
			if ( newwidth != VOi->width ){
	VOi->img = NULL;
				VOi->width = newwidth;
				mtinfo.PresetY = VOi->offY; // ǂݍ݊̕\ʒuw(1.2xb)
				FixChangeMode(vinfo.info.hWnd);


			}
		}
*/
		codefunc = HIWORD(vft.dtype); // DT_xxx
		if ( codefunc < CODEFUNCMAX ){
			if ( Vd_codefuncinit[codefunc].func() ){
				vo_.SupportTypeFlags = VO_type_ALLTEXT;
			}
		}
		PPVGetHist();
		InitViewObject(VO_opt, vft.type);

		if ( X_swmt && (vft.info != NULL) ){
			ThCatString(&vo_.memo, vft.info);
			HeapFree(PPvHeap, 0, vft.info);
		}
	}else{		// seLXg
		vo_.SupportTypeFlags = VO_type_ALLTEXT;
		if ( vo_.DModeType != DISPT_HEX ){
			vo_.DModeType = DISPT_TEXT;
			VOi = &VO_I[DISPT_TEXT];
		}
		tstrcpy(vo_.file.typeinfo, T("Unknown"));
		PPVGetHist();
		InitViewObject(VO_opt, T("*"));
		vft.type[0] = '\0';
	}
	if ( vo_.DModeBit & VO_dmode_TEXTLIKE ) LoadHighlight(&vft);
}

void FollowOpenView(PPV_APPINFO *vinfo)
{
	OpenEntryNow = 1;
	if ( X_tray & X_tray_PPv ){
		SetWindowLongPtr(vinfo->info.hWnd, GWL_STYLE, GetWindowLongPtr(vinfo->info.hWnd, GWL_STYLE) & ~WS_MINIMIZE);
		ShowWindow(vinfo->info.hWnd, SW_SHOW);
	}
	if ( IsIconic(vinfo->info.hWnd) || !IsWindowVisible(vinfo->info.hWnd) ){
		SendMessage(vinfo->info.hWnd, WM_SYSCOMMAND, SC_RESTORE, 0xffff0000);
	}

	if ( TailModeFlags ){
		if ( OldTailLine >= 0 ){
			MoveCsr(0, (OldTailLine - 2) - VOi->offY, FALSE);
		}else{
			MoveCsr(0, VO_maxY, FALSE);
		}
	}

	InvalidateRect(vinfo->info.hWnd, NULL, TRUE);
	SetScrollBar();
	DxSetMotion(DxDraw, DXMOTION_NewWindow);
	if ( (XV.img.imgD[imdD_MAG] == IMGD_FIXFRAMESIZE) ||
		 (XV.img.imgD[imdD_MAG] == IMGD_AUTOFRAMESIZE) ){
		// ŏƂĂ瑋\߂܂ő҂
		if ( IsIconic(vinfo->info.hWnd) || !IsWindowVisible(vinfo->info.hWnd) ){
			MSG msgdata;
			DWORD tick = GetTickCount();

			while ( PeekMessage(&msgdata, vinfo->info.hWnd, 0, 0, PM_REMOVE) ){
				if ( msgdata.message == WM_QUIT ) break;
				TranslateMessage(&msgdata);
				DispatchMessage(&msgdata);

				if ( (GetTickCount() - tick) > 500 ) break;
			}
		}

		if ( vo_.DModeBit & VO_dmode_IMAGE ){
			FixWindowSize(vinfo->info.hWnd, 0, 0); // 摜ɍ킹Ē
		}else{ // eLXgp̑傫ɒ
			SetWindowPos(vinfo->info.hWnd, NULL, 0, 0,
					WinPos.pos.right - WinPos.pos.left,
					WinPos.pos.bottom - WinPos.pos.top,
					SWP_NOACTIVATE | SWP_NOCOPYBITS | SWP_NOMOVE | SWP_NOZORDER);
		}
	}

	if ( XV_tmod && (vo_.DModeBit & VO_dmode_SELECTABLE) ){
		InitCursorMode(vinfo->info.hWnd, FALSE);
	}else{
		HideCaret(vinfo->info.hWnd);
	}
	OpenEntryNow = 0;
}

void OpenAndFollowViewObject(PPV_APPINFO *vinfo, const TCHAR *filename, HGLOBAL mem, VIEWOPTIONS *viewopt, int flags)
{
	OpenViewObject(filename, mem, viewopt, flags);
	FollowOpenView(vinfo);
}

#if NODLL
extern DWORD crc32(const BYTE *bin , DWORD size, DWORD r);
#else
const LONG crc32_half[16] = {
	0x00000000, 0x1DB71064, 0x3B6E20C8, 0x26D930AC,
	0x76DC4190, 0x6B6B51F4, 0x4DB26158, 0x5005713C,
	0xEDB88320, 0xF00F9344, 0xD6D6A3E8, 0xCB61B38C,
	0x9B64C2B0, 0x86D3D2D4, 0xA00AE278, 0xBDBDF21C
};

DWORD crc32(const BYTE *bin, DWORD size, DWORD r)
{
	DWORD crc = ~r;
	const BYTE *ptr = bin;
	BYTE chr;

	if ( size == MAX32 ) size = TSTRLENGTH32((TCHAR *)bin);
	while ( size-- ){
		chr = *ptr++;
		crc = crc32_half[(crc ^  chr      ) & 0x0F] ^ (crc >> 4);
		crc = crc32_half[(crc ^ (chr >> 4)) & 0x0F] ^ (crc >> 4);
	}
	return ~crc;
}
#endif


#pragma argsused
void CALLBACK AnimateProc(HWND hWnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{
	UnUsedParam(hWnd);UnUsedParam(uMsg);UnUsedParam(idEvent);UnUsedParam(dwTime);
	KillTimer(hWnd, idEvent);
	if ( (vo_.bitmap.page.current + 1) >= vo_.bitmap.page.max ){
		vo_.bitmap.page.current = 0;
		ChangePage(0);
	}else{
		ChangePage(1);
	}
}

int USEFASTCALL dabs(int a)
{
	return a >= 0 ? a : -a;
}

int getdelta(DWORD d1, DWORD d2)
{
	return (dabs((int)(d1 & 0xff0000) - (int)(d2 & 0xff0000)) >> 16) +
		(dabs((int)(d1 & 0xff00) - (int)(d2 & 0xff00)) >> 8) +
		dabs((int)(d1 & 0xff) - (int)(d2 & 0xff));
}
enum {
	TMODE_NONE = 0,
	TMODE_GIF_2X, // 2l bit shift L
	TMODE_GIF_4,
	TMODE_GIF_8_2C, // 8bit / 2bit㏑
	TMODE_GIF_4to8, // 8bit  4bit
	TMODE_PNG_8,
	TMODE_PNG_24,
	TMODE_PNG_32,

	TMODE_GIFMODE = 16,
	TMODE_PNGMODE
};
#define BitSizeMacro(bits) (((bits) + 7) / 8)
#define BitPosMacro(bits) ((bits) / 8)

void ChangePage(int delta)
{
	GETPAGESTRUCT gpage;
	BYTE *tempimg;
	size_t tempsize;
	HLOCAL hHeader, hImage;
	BITMAPINFO *NewBMPinfo;
	BOOL tmode = TMODE_NONE;
	TCHAR *filename;
	BOOL nosupport = FALSE;
	int newpage;
	VFSGetDibDelayParam ddp;
	DWORD tick;

	tick = GetTickCount();

	ddp.header = VGDDP_HEADER;
	ddp.page_number = 0;

	KillTimer(vinfo.info.hWnd, TIMERID_ANIMATE);

	if ( vo_.bitmap.rotate != 0 ){
		vo_.bitmap.rotate = 0;
		SetPopMsg(POPMSG_NOLOGMSG, MES_ECPR, PMF_DOCMSG);
		PPvReload(&vinfo);
		return;
	}

	if ( !(vo_.DModeBit & DOCMODE_BMP) || (vo_.bitmap.page.max == 0) ) return;

	newpage = vo_.bitmap.page.current + delta;
	if ( (newpage < 0) || (newpage >= vo_.bitmap.page.max) ) return;
	gpage.page = newpage;
	filename = vo_.file.name;

	if ( (PreFrameInfo.page <= PreFramePage_BG) &&
		 ((delta == 1) || ((delta == 0) && (newpage == 0))) ){
		if ( PreFrameInfo.page == PreFramePage_BG ){
			PreFrameInfo.page = gpage.page;
		}
	}

	if ( PreFrameInfo.page == gpage.page ){ // Õt[Ŏwꂽs
		if ( PreFrameInfo.bitmapsize != 0 ){ // P܂ɖ߂
			memcpy(vo_.bitmap.bits.ptr, PreFrameInfo.bitmap, PreFrameInfo.bitmapsize);
		}else{ // hԂ	ǂݍݒ̃t[́AInitPNG(NULL) ̂PreFrameInfo ̐ݒ肪ĂȂ̂ŁAȂoOƂȂĂ
			int h, dstwidth, copywidth;
			BYTE *dst;

			dstwidth = DwordBitSize(vo_.bitmap.rawsize.cx * vo_.bitmap.info->biBitCount);
			copywidth = BitSizeMacro(PreFrameInfo.size.cx * vo_.bitmap.info->biBitCount);
			if ( PreFrameInfo.offset.x + PreFrameInfo.size.cx > vo_.bitmap.rawsize.cx ){
				PreFrameInfo.size.cx = vo_.bitmap.rawsize.cx - PreFrameInfo.offset.x;
			}
			if ( PreFrameInfo.offset.y + PreFrameInfo.size.cy > vo_.bitmap.rawsize.cy ){
				PreFrameInfo.size.cy = vo_.bitmap.rawsize.cy - PreFrameInfo.offset.y;
			}
			if ( vo_.bitmap.info->biBitCount == 4 ){
				PreFrameInfo.fillcolor = (BYTE)((PreFrameInfo.fillcolor & 0xf) | (PreFrameInfo.fillcolor << 4));
			}
			dst = vo_.bitmap.bits.ptr +
				  dstwidth * (vo_.bitmap.rawsize.cy - PreFrameInfo.offset.y - 1) +
				  BitSizeMacro(PreFrameInfo.offset.x * vo_.bitmap.info->biBitCount);
			for ( h = 1 ; h <= PreFrameInfo.size.cy ; h++ ){
				memset(dst, PreFrameInfo.fillcolor, copywidth);
				dst -= dstwidth;
			}
		}
	}

	switch ( vo_.bitmap.page.type ){
		case PAGETYPE_PLUGIN:
			gpage.trans = -1;
			tempimg = vo_.file.image;
			tempsize = vo_.file.UseSize;
			ddp.page_number = gpage.page;
			break;

		case PAGETYPE_GIF: {
			GIFIMAGEHEADER *gi;

			InitGIF(&gpage);
			tempsize = gpage.headersize + gpage.size + 1;
			tempimg = HeapAlloc(PPvHeap, 0, tempsize + FILEBUFMARGIN);
			if ( tempimg == NULL ) return;

			memcpy(tempimg, vo_.file.image, gpage.headersize);
			gi = (GIFIMAGEHEADER *)(tempimg + gpage.headersize);
			memcpy(gi, vo_.file.image + gpage.offset, gpage.size);
			memset(tempimg + tempsize - 1, GIFHEADER_ENDID, 1024);
			// W
			gi->left = 0;
			gi->top = 0;
			((GIFHEADER *)tempimg)->width  = gi->width;
			((GIFHEADER *)tempimg)->height = gi->height;
			tmode = TMODE_GIFMODE;
			break;
		}

		case PAGETYPE_TIFF: {
			GetDWORDfunc GetDWORD = InitTIFF(&gpage);

			if ( GetDWORD == NULL ) return;

			tempsize = vo_.file.UseSize;
			tempimg = HeapAlloc(PPvHeap, 0, tempsize + FILEBUFMARGIN);
			if ( tempimg == NULL ) return;

			memcpy(tempimg, vo_.file.image, vo_.file.UseSize);
			*(DWORD *)(tempimg + 4) = GetDWORD(&gpage.offset);
			break;
		}

		case PAGETYPE_APNG:
			InitPNG(&gpage);

			filename = T(":\\:.png");
			tempsize = vo_.file.UseSize;
			tempimg = HeapAlloc(PPvHeap, 0, tempsize + FILEBUFMARGIN);
			if ( tempimg == NULL ) return;

			if ( gpage.optionoffset == 0 ){
				memcpy(tempimg, vo_.file.image, tempsize);
			}else{
				size_t srcoffset, destoffset;
				PNGchunk *pc;
				PNGFrameControlStruct *fcs;

				// Yt[̒O܂ŃRs[
				srcoffset = destoffset = gpage.offset;
				memcpy(tempimg, vo_.file.image, srcoffset);
				while ( srcoffset < gpage.optionoffset ){
					DWORD csize;

					pc = (PNGchunk *)(vo_.file.image + srcoffset);
					csize = GetBigEndDWORD(&pc->length);
					if ( csize == 0 ) break;
					// IDAT  fdAT ̓Rs[Ȃ
					if ( (pc->id != PNG_IDAT) && (pc->id != PNG_fdAT) ){
						memcpy(tempimg + destoffset, vo_.file.image + srcoffset,
								csize + SizeOfPNGchunks);
						destoffset += csize + SizeOfPNGchunks;
					}
					srcoffset += csize + SizeOfPNGchunks;
				}

				// fcTL t[擾
				srcoffset = gpage.optionoffset;
				fcs = (PNGFrameControlStruct *)(vo_.file.image + srcoffset);
				*(DWORD *)(tempimg + 0x10) = fcs->width;
				*(DWORD *)(tempimg + 0x14) = fcs->height;
				srcoffset += GetBigEndDWORD(&fcs->pc.length) + SizeOfPNGchunks;

				// t[\̏
				if ( (fcs->dispose_op != APNG_DISPOSE_OP_NONE) &&
						 ((delta == 1) || ((delta == 0) && (newpage == 0))) ){
					if ( fcs->dispose_op == APNG_DISPOSE_OP_BACKGROUND ){
						PreFrameInfo.page = gpage.page + 1;
					}else if ( fcs->dispose_op == APNG_DISPOSE_OP_PREVIOUS ){
						if ( PreFrameInfo.bitmapsize == 0 ){
							DWORD bitmapsize;

							bitmapsize = DwordBitSize(vo_.bitmap.rawsize.cx * vo_.bitmap.ShowInfo->biBitCount) * vo_.bitmap.rawsize.cy;

							PreFrameInfo.bitmap = HeapAlloc(PPvHeap, 0, bitmapsize);
							if ( PreFrameInfo.bitmap != NULL ){
								PreFrameInfo.bitmapsize = bitmapsize;
							}
						}
						if ( PreFrameInfo.bitmapsize != 0 ){
							memcpy(PreFrameInfo.bitmap, vo_.bitmap.bits.ptr, PreFrameInfo.bitmapsize);
							PreFrameInfo.page = gpage.page + 1;
						}
					}else{
						nosupport = TRUE; // ΉĂȂ
					}
				}

				// @
				if ( fcs->blend_op == APNG_BLEND_OP_OVER ){
					tmode = TMODE_PNGMODE; // Kv
					if ( gpage.trans == -1 ) gpage.trans = 0;
				}else if ( fcs->blend_op >= 2 ){
					nosupport = TRUE; // ΉĂȂ
				}

				// t[eRs[
				while ( srcoffset < vo_.file.UseSize ){
					DWORD csize;

					pc = (PNGchunk *)(vo_.file.image + srcoffset);
					csize = GetBigEndDWORD(&pc->length);
					if ( csize == 0 ) break;
					if ( pc->id == PNG_fcTL ) break; // fcTL...̃t[ɓB

					if ( pc->id == PNG_fdAT ){
						PNGchunk *destpc;

						destpc = (PNGchunk *)(tempimg + destoffset);
						destpc->id = PNG_IDAT; // IDAT ɕύX
						SetBigEndDWORD((BYTE *)&destpc->length, csize - SizeOfPNGframes);
						memcpy(tempimg + destoffset + sizeof(PNGchunk),
								vo_.file.image + srcoffset + sizeof(PNGchunk) + SizeOfPNGframes,
								csize - SizeOfPNGframes);
						SetBigEndDWORD((BYTE *)destpc + sizeof(PNGchunk) + csize - SizeOfPNGframes,
								crc32((const BYTE *)&destpc->id, csize + SizeOfPNGid - SizeOfPNGframes, 0) );
						destoffset += csize + SizeOfPNGchunks - SizeOfPNGframes;
					}else{
						memcpy(tempimg + destoffset, vo_.file.image + srcoffset,
								csize + SizeOfPNGchunks);
						destoffset += csize + SizeOfPNGchunks;
					}
					srcoffset += csize + SizeOfPNGchunks;
				}
				// cRs[
				memcpy(tempimg + destoffset, vo_.file.image + srcoffset,
						vo_.file.UseSize - srcoffset);
				tempsize = destoffset + (vo_.file.UseSize - srcoffset);
			}
			break;

		default:
			return;
	}

	ddp.image = tempimg;
	ddp.size = tempsize;

	if ( VFSGetDibDelay(filename, &ddp, sizeof(ddp),
			vo_.file.typeinfo, &hHeader, &hImage, NULL) ){
		SIZE newsize;

		ClearBitmapModifyCache();
		NewBMPinfo = (BITMAPINFO *)LocalLock(hHeader);
		newsize.cx = NewBMPinfo->bmiHeader.biWidth;
		newsize.cy = NewBMPinfo->bmiHeader.biHeight;

		if ( newsize.cy < 0 ) newsize.cy = -newsize.cy; // gbv_E
		PreFrameInfo.size = newsize;
		PreFrameInfo.offset = gpage.dispoffset;

		// F[xႤꍇ͉HłȂ
		if ( (vo_.bitmap.info->biBitCount != NewBMPinfo->bmiHeader.biBitCount) &&
			 !((tmode == TMODE_GIFMODE) && (vo_.bitmap.info->biBitCount == 8)) ){
			// wL肩傫قȂĂ
			if ( (gpage.trans >= 0) ||
			  (vo_.bitmap.rawsize.cx != newsize.cx) || (vo_.bitmap.rawsize.cy != newsize.cy) ){
				nosupport = TRUE;
			}
		}

		if ( gpage.page &&
			(vo_.bitmap.page.type != PAGETYPE_PLUGIN) &&
			(vo_.bitmap.page.type != PAGETYPE_TIFF) &&
			((vo_.bitmap.info->biBitCount == NewBMPinfo->bmiHeader.biBitCount)||
			((tmode == TMODE_GIFMODE) && (vo_.bitmap.info->biBitCount == 8))) &&
			// 傫܂Ă
			(vo_.bitmap.rawsize.cy >= (gpage.dispoffset.y + newsize.cy)) &&
			(vo_.bitmap.rawsize.cx >= (gpage.dispoffset.x + newsize.cx)) &&
			// wL肩傫قȂĂ
			( (gpage.trans >= 0) ||
			  (vo_.bitmap.rawsize.cx != newsize.cx) || (vo_.bitmap.rawsize.cy != newsize.cy) ) ){
			// s
			BYTE *newimg, *src, *dst;
			int h, i, trans, srcwidth, dstwidth, dstoffset, copywidth;
			BOOL paletteFix = FALSE;
			BYTE fixpals[256];
			DWORD *newpal;

			if ( vo_.bitmap.info->biBitCount <= 8 ){
				DWORD *oldpal;

				oldpal = (DWORD *)((BYTE *)vo_.bitmap.info + vo_.bitmap.info->biSize);
				newpal = (DWORD *)((BYTE *)NewBMPinfo + NewBMPinfo->bmiHeader.biSize);

				if ( 0 != memcmp(oldpal, newpal,
					((size_t)1 << NewBMPinfo->bmiHeader.biBitCount) * sizeof(DWORD) ) ){
					paletteFix = TRUE;
					if ( tmode == TMODE_GIFMODE ){ // VpbgCfbNXpbgCfbNXɕϊ\쐬
						int ni, oi, newcols, oldcols;

						oldcols = 1 << vo_.bitmap.info->biBitCount;
						if ( (vo_.bitmap.info->biClrUsed != 0) && ((DWORD)oldcols > vo_.bitmap.info->biClrUsed) ){
							oldcols = vo_.bitmap.info->biClrUsed;
						}
						newcols = 1 << NewBMPinfo->bmiHeader.biBitCount;
						if ( (NewBMPinfo->bmiHeader.biClrUsed != 0) && ((DWORD)newcols > NewBMPinfo->bmiHeader.biClrUsed) ){
							newcols = NewBMPinfo->bmiHeader.biClrUsed;
						}
						for ( ni = 0 ; ni < newcols ; ni++ ){ // ԋ߂pbgI
							DWORD oldindex, newpald;
							int paldelta;

							paldelta = 0xfffff;
							oldindex = oldcols - 1;
							newpald = newpal[ni];
							for ( oi = 0 ; oi < oldcols ; oi++ ){
								int chkdelta;

								chkdelta = getdelta(newpald, oldpal[oi]);
								if ( chkdelta < paldelta ){
									paldelta = chkdelta;
									oldindex = oi;
									if ( paldelta == 0 ) break;
								}
							}
							fixpals[ni] = (BYTE)oldindex;
						}
					}
				}
			}

			newimg = (BYTE *)LocalLock(hImage);

			if ( tmode != TMODE_NONE ){
				if ( tmode == TMODE_GIFMODE ){
					if ( (vo_.bitmap.info->biBitCount == 1) &&
						 (gpage.dispoffset.x & 7) ){
						tmode = TMODE_GIF_2X;
					}else if ( vo_.bitmap.info->biBitCount == 4 ){
						tmode = TMODE_GIF_4;
					}else if ( (vo_.bitmap.info->biBitCount == 8) &&
						(NewBMPinfo->bmiHeader.biBitCount == 4) ){
						tmode = TMODE_GIF_4to8;
					}else{
						tmode = TMODE_GIF_8_2C;
					}
					nosupport = FALSE;
				}else if ( tmode == TMODE_PNGMODE ){
					if ( vo_.bitmap.info->biBitCount == 8 ){
						tmode = TMODE_PNG_8;
					}else if ( vo_.bitmap.info->biBitCount == 32 ){
						tmode = TMODE_PNG_32;
					}else if ( vo_.bitmap.info->biBitCount == 24 ){
						tmode = TMODE_PNG_24;
					}else{
						tmode = TMODE_NONE;
					}
				}
			}

			// 8bitJ[ȊO͓ߐFЂƂ܂oCgPʂ݂̂ň
			trans = gpage.trans;
			if ( (trans >= 0) && (vo_.bitmap.info->biBitCount < 8) ){
				if ( vo_.bitmap.info->biBitCount == 1 ){
					trans = -1;
				}else{
					trans = trans | (trans << 4);
				}
				if ( gpage.dispoffset.x & ((8 / NewBMPinfo->bmiHeader.biBitCount) - 1) ){
					nosupport = TRUE;
				}
			}

			srcwidth = DwordBitSize(newsize.cx * NewBMPinfo->bmiHeader.biBitCount);
			dstwidth = DwordBitSize(vo_.bitmap.rawsize.cx * vo_.bitmap.info->biBitCount);
			dstoffset = BitPosMacro(gpage.dispoffset.x * vo_.bitmap.info->biBitCount);
			copywidth = BitSizeMacro(newsize.cx * NewBMPinfo->bmiHeader.biBitCount);

			for ( h = 1 ; h <= newsize.cy ; h++ ){
				src = newimg + (newsize.cy - h) * srcwidth;
				dst = vo_.bitmap.bits.ptr
					+ (vo_.bitmap.rawsize.cy - gpage.dispoffset.y - h) * dstwidth
					+ dstoffset;

				switch ( tmode ){
					case TMODE_GIF_2X: {
						int bitx;

						bitx = gpage.dispoffset.x & 7;
						for ( i = copywidth ; i ; i--, src++, dst++ ){
							WORD srcdots, dstdots;

							srcdots = (WORD)((WORD)*src << (8 - bitx));
							dstdots = (WORD)(
								((((WORD)*dst << 8) | (WORD)*(dst + 1)) &
								 ~(0xff00 >> bitx)) | srcdots);
							*dst = (BYTE)(WORD)(dstdots >> 8);
							*(dst + 1) = (BYTE)dstdots;
						}
						continue;
					}
					case TMODE_GIF_4: {
						int skip_i;

						skip_i = (newsize.cx & 1) ? 1 : 0;
						if ( gpage.dispoffset.x & 1 ){ // 4bit 񂪕sv
							for ( i = copywidth ; i ; i--, src++, dst++ ){
								BYTE srcdots;

								srcdots = *src;
								if ( ((srcdots >> 4) != gpage.trans) &&
									 (i > skip_i) ){
									*dst = (BYTE)((*dst & 0xf0) |
											(paletteFix ?
											 fixpals[srcdots >> 4] : (srcdots >> 4)) );
								}
								if ( (srcdots & 0xf) != gpage.trans ){
									*(dst + 1) = (BYTE)((*(dst + 1) & 0xf) |
											(paletteFix ?
											 (fixpals[srcdots & 0xf] << 4) : (srcdots << 4)) );
								}
							}
						}else{	// 4bit 񂪈v
							for ( i = copywidth ; i ; i--, src++, dst++ ){
								BYTE srcdots, destdots, dot;

								srcdots = *src;
								destdots = *dst;

								dot = (BYTE)(srcdots & 0xf);
								if ( (dot != gpage.trans) && (i > skip_i) ){
									destdots = (BYTE)((destdots & 0xf0) |
											(paletteFix ? fixpals[dot] : dot) );
								}
								dot = (BYTE)(srcdots >> 4);
								if ( dot != gpage.trans ){
									destdots = (BYTE)((destdots & 0xf) |
											(paletteFix ? (fixpals[dot] << 4) : (dot << 4)) );
								}
								*dst = destdots;
							}
						}
						continue;
					}
					case TMODE_GIF_8_2C:
						for ( i = copywidth ; i ; i--, src++, dst++ ){
							if ( *src != trans ){
								if ( IsTrue(paletteFix) ){
									*dst = fixpals[*src];
								}else{
									*dst = *src;
								}
							}
						}
						continue;

					case TMODE_GIF_4to8: {
						int skip_i;

						skip_i = (newsize.cx & 1) ? 1 : 0;
						if ( gpage.dispoffset.x & 1 ){ // 4bit 񂪕sv
							for ( i = copywidth ; i ; i--, src++, dst+=2 ){
								BYTE srcdots, dot;

								srcdots = *src;
								dot = (BYTE)(srcdots >> 4);
								if ( (dot != gpage.trans) && (i > skip_i) ){
									*dst = paletteFix ? fixpals[dot] : dot;
								}
								dot = (BYTE)(srcdots & 0xf);
								if ( dot != gpage.trans ){
									*(dst + 1) = paletteFix ? fixpals[dot] : dot;
								}
							}
						}else{	// 4bit 񂪈v
							for ( i = copywidth ; i ; i--, src++, dst+=2 ){
								BYTE srcdots, dot;

								srcdots = *src;
								dot = (BYTE)(srcdots & 0xf);
								if ( (dot != gpage.trans) && (i > skip_i) ){
									*dst = paletteFix ? fixpals[dot] : dot;
								}
								dot = (BYTE)(srcdots & 0x4);
								if ( dot != gpage.trans ){
									*(dst + 1) = paletteFix ? fixpals[dot] : dot;
								}
							}
						}
						continue;
					}
					case TMODE_PNG_8:
						for ( i = copywidth ; i ; i--, src++, dst++ ){
							if ( newpal[*src] >= 0x60000000 ) *dst = *src;
						}
						continue;

					case TMODE_PNG_24:
						for ( i = copywidth ; i ; i -= 3, src+=3, dst+=3 ){
							DWORD color;

							color = *(DWORD *)src;
							if ( (color & 0xffffff) != (DWORD)trans ){
								*(WORD *)dst = (WORD)color;
								*(BYTE *)(dst + 2) = (BYTE)(color >> 16);
							}
						}
						continue;

					case TMODE_PNG_32:
						for ( i = copywidth ; i ; i -= 4, src+=4, dst+=4 ){
							if ( *(DWORD *)src >= 0x60000000 ){
								*(DWORD *)dst = *(DWORD*)src;
							}
						}
						continue;

					default:
						memcpy(dst, src, copywidth);
				}
			}

			LocalUnlock(hHeader);
			LocalFree(hHeader);

			LocalUnlock(hImage);
			LocalFree(hImage);
		}else{
			// s킸Aւ
			if ( vo_.bitmap.info_hlocal != NULL ){
				LocalUnlock(vo_.bitmap.info_hlocal);
				LocalFree(vo_.bitmap.info_hlocal);
			}
			if ( vo_.bitmap.bits.mapH != NULL ){
				LocalUnlock(vo_.bitmap.bits.mapH);
				LocalFree(vo_.bitmap.bits.mapH);
			}
			vo_.bitmap.info_hlocal = hHeader;
			vo_.bitmap.bits.mapH = hImage;

			vo_.bitmap.info = &NewBMPinfo->bmiHeader;
			vo_.bitmap.bits.ptr = LocalLock(hImage);

			FixAspectRate(vo_.bitmap.info);
		}
		if ( (vo_.bitmap.info->biClrUsed == 0) && (vo_.bitmap.info->biBitCount <= 8) ){
			vo_.bitmap.info->biClrUsed = 1 << vo_.bitmap.info->biBitCount;
		}

		vo_.bitmap.ShowInfo = vo_.bitmap.info;
		DIRECTXDEFINE(DxDrawFreeBMPCache(&vo_.bitmap.DxCache));
		if ( vo_.bitmap.hPal != NULL ) DeleteObject(vo_.bitmap.hPal);
		CreateDIBtoPalette(&vo_);

		vo_.SupportTypeFlags = VO_type_ALLIMAGE;
		vo_.DModeType = DISPT_IMAGE;
		FixChangeMode(vinfo.info.hWnd);

		vo_.bitmap.page.current = gpage.page;
		if ( vo_.bitmap.page.do_animate ){
			if ( vo_.bitmap.page.type == PAGETYPE_PLUGIN ){
				gpage.timer = ddp.animate_time;
			}

			tick = GetTickCount() - tick; // ǂݍ݁EHɊ|
			if ( tick & B31 ) tick = 0;

			gpage.timer -= tick;
			if ( (gpage.timer & B31) || (gpage.timer == 0) ){
				gpage.timer = TIME_ANIMATE_MIN;
			}

			SetTimer(vinfo.info.hWnd, TIMERID_ANIMATE, gpage.timer, AnimateProc);
		}

		if ( (viewopt_def.I_CheckeredPattern > 0) &&
			 !vo_.bitmap.page.do_animate &&
			 (vo_.bitmap.transcolor >= 0) ){
			ModifyAlpha();
		}

		if ( nosupport ){
			SetPopMsg(POPMSG_NOLOGMSG, MES_ECPS, PMF_DOCMSG);
		}
	}else{
		SetPopMsg(POPMSG_NOLOGMSG, MES_ECPL, PMF_DOCMSG);
	}
	if ( vo_.bitmap.page.type > PAGETYPE_PLUGIN ) HeapFree(PPvHeap, 0, tempimg);
}

void ReMakeIndexes(HWND hWnd)
{
	ScrollWidth = ScrollWidth_MIN;
	if ( vo_.DModeBit & DOCMODE_TEXT ){
		if ( VOsel.select != FALSE ) ResetSelect(TRUE); // I
		MakeIndexTable(MIT_REMAKE, VOi->offY);
		SetScrollBar();
		if ( mtinfo.PresetPos == 0 ){
			MoveCsr(0, mtinfo.PresetY - VOi->offY, FALSE);
		}
	}else{
		mtinfo.PresetY = VOi->offY; // ǂݍ݊̕\ʒuw(1.2xb)
		FixChangeMode(hWnd);
	}
}
