/*-----------------------------------------------------------------------------
	Paper Plane vUI													` Init `
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include "PPX.H"
#include "VFS.H"
#include "PPVUI.RH"
#include "PPV_STRU.H"
#include "PPV_FUNC.H"
#pragma hdrstop

void InitPPvWindow(void);
int MultiBootMode = PPXREGIST_NORMAL;
int EmbedCombo = 0;
BOOL X_vpos_custom = FALSE;

const TCHAR *OptionNames[] = {
									// S
	T("R"),				// ̍ėp
	T("PRINT"),			// 
	T("PRINTS"),		// ꊇ
									// \[h
	T("HEX"),			// 16i\
	T("TEXT"),			// eLXg\
	T("DOCUMENT"),		// \
	T("IMAGE"),			// 摜\
	T("RAWIMAGE"),		// x^摜\
									// eLXg\`
	T("IBM"),			// IBM PC font
	T("ANSI"),			// ANSI code set
//10
	T("JIS"),			// JIS
	T("SYSTEM"),		// system codepage
	T("EUC"),			// EUC
	T("UNICODE"),		// UNICODE
	T("UNICODEB"),		// UNICODE big endian
	T("SJISNEC"),		// S-JIS NEC PC-9801
	T("SJISB"),			// S-JIS big endian
	T("KANA"),			// KANA
	T("UTF8"),			// UTF-8
	T("UTF7"),			// UTF-7
//20
	T("RTF"),			// Rich text
	T("SISO"),
	T("ESC"),
	T("TAG"),
	T("BOOTID"),
	T("BOOTMAX"),
	T("CONVERT"),
	T("CONVERTSJIS"),
	T("CONVERTEUC"),
	T("FOCUS"),
//30
	T("K"),
	T("MIN"),
	T("MAX"),
	T("NOACTIVE"),
	T("WIDTH"),
	T("LINESPACE"),
	T("TAB"),
	T("ANIMATE"),
	T("CHECKEREDPATTERN"),
	T("CSS"),
//40
	T("SCRIPT"),
	T("TAIL"),
	T("CODEPAGE"),
	T("SJIS"),			// Shift_JIS
	T("US"),
	T("LATIN1"),
	T("UTF16"),
	T("UTF16BE"),
	T("PARENT"),
	T("POPUP"),
//50
	T("SETPARENT"),
	T("MIME"),
	T("SHOWSTYLE"),
	T("HISTORY"),
	T("COMBO"),
	T("COLORPROFILE"),
	NULL
};

const TCHAR *TagOffOn[] = { T("OFF"), T("ON"), T("TAG"), NULL };
const TCHAR *OffOn[] = { T("OFF"), T("ON"), NULL };
const TCHAR *AutoOffOn[] = { T("AUTO"), T("OFF"), T("ON"), NULL };
const TCHAR *ListStyle[] = { T("SDI"), T("ONPARENT"), T("ONPAIR"), T("ONMAINWND"), T("INPARENT"), T("INPAIR"), T("INMAINWND"), NULL };

const TCHAR *NameFirst = NULL, *NameLast = NULL;
const TCHAR DefCID[] = T("VA");

PPXINMENU barFile[] = {
	{K_c |      'O', T("&Open...\tCtrl+O")},
	{K_c |      'S', T("&Save...\tCtrl+S")},
	{'X', T("E&xecute\tX")},
	{'P'			, T("P&lay\tP")},
	{K_c |      'P', T("&Print\tCtrl+P")},
	{K_s | 'E'		, T("PP&e\tShift+E")},
	{PPXINMENY_SEPARATE, NULL},
	{K_c | 'U'		, T("print set &Up...")},
	{PPXINMENY_SEPARATE, NULL},
	{'Q', T("E&xit\tAlt+F4")},
	{0, NULL}
};
// Edit j[
PPXINMENU barEdit[] = {
	{K_c | 'C'		, T("&Copy\tCtrl+C")},
	{K_c | 'V'		, T("&Paste\tCtrl+V")},
	{K_c | K_s | 'V', T("Pa&ste type...\tCtrl+Shift+V")},
	{PPXINMENY_SEPARATE, NULL},
	{'F', T("Find &F...\tF")},
	{'B', T("Find &B...\tB")},
	{PPXINMENY_SEPARATE, NULL},
	{']', T("Find Next\t&]")},
	{'[', T("Find Prev\t&[")},
	{PPXINMENY_SEPARATE, NULL},
	{'J'		, T("&Jump to line\tJ")},
	{K_c | 'D'		, T("&Set bookmark\tCtrl+D")},
	{K_c | 'G'		, T("&Goto bookmark\tCtrl+G")},
	{0, NULL}
};
// View j[
PPXINMENU barView[] = {
	{K_layout, T("&Layout")},
	{'R', T("R&everse back\tR")},
//	{0x3e81, T("Task display")},		//܂ȂPPc̓ꏊɃ
	{K_c | K_Pup, T("Prev page\tCtrl+PageUp")},
	{K_c | K_Pdw, T("Next page\tCtrl+PageDown")},
	{'<'		, T("Prev Div page\t&<")},
	{'>'		, T("Next Div page\t&>")},
	{K_c | K_s | K_Pup, T("Top Div pa&ge")},
	{K_c | K_s | K_Pdw, T("Last Div pa&ge")},
	{'K'		, T("Rotate left\tK")},
	{'L'		, T("Rotate right\tL")},
	{PPXINMENY_SEPARATE, NULL},
	{':'		, T("&View mode...\t:")},
	{'@'		, T("&Text code...\t@")},
	{'W'		, T("Font &width\tW")},
	{'T'		, T("Line number mode\tT")},
	{'U'		, T("Line number\tU")},
	{'C'		, T("&Control code\tC")},
	{';'		, T("C&olumns\t;")},
	{K_s | 'F'	, T("string &Highlight\tCtrl+Shift+F")},
	{PPXINMENY_SEPARATE, NULL},
	{K_c | 'L', T("Re&draw\tCtrl+L")},
	{'.', T("&Reload\tF5")},
	{0, NULL}
};
// Tool j[
PPXINMENU barTool[] = {
	{KC_Tvfs	, T("&VFS switch")},
	{K_cust, T("&Customizer")},
	{0, NULL}
};
// Help j[
PPXINMENU barHelp[] = {
	{K_F1     , T("&Help\tF1")},
	{K_s | K_F1	, T("&Topic\tShift+F1")},
	{PPXINMENY_SEPARATE, NULL},
	{K_supot   , T("&Support")},
	{(DWORD_PTR)T("*checkupdate"), T("Check &Update")},
	{PPXINMENY_SEPARATE, NULL},
	{K_about   , T("&About")},
	{0, NULL}//T("&File")},
};

PPXINMENUBAR ppvbar[] = {
	{T("&File"), barFile},
	{T("&Edit"), barEdit},
	{T("&View"), barView},
	{T("&Tool"), barTool},
	{T("&Help"), barHelp},
	{NULL, NULL}
};

#if !NODLL
DefineWinAPI(HRESULT, DwmGetWindowAttribute, (HWND, DWORD, PVOID, DWORD)) = NULL;
#else
ExternWinAPI(HRESULT, DwmGetWindowAttribute, (HWND, DWORD, PVOID, DWORD));
#endif

int CheckSubParam(TCHAR *param, const TCHAR *list[], int defvalue)
{
	int i = 0;

	Strupr(param);
	for ( ;; ){
		if ( *list == NULL ){
			i = defvalue;
			break;
		}
		if ( tstrcmp( param, *list) == 0 ) break;
		i++;
		list++;
	}
	return i;
}

void InitViewOptions(VIEWOPTIONS *viewopts)
{
#if 1
	memset(viewopts, 0xff, sizeof(VIEWOPTIONS));
#else
	viewopts->dtype = -1;
	viewopts->history = -1;

	viewopts->T_code = -1;
	viewopts->T_siso = -1;
	viewopts->T_esc = -1;
	viewopts->T_mime = -1;
	viewopts->T_tag = -1;
	viewopts->T_show_css = -1;
	viewopts->T_show_script = -1;
	viewopts->T_tab = -1;
	viewopts->T_width = -1;
	viewopts->linespace = -1;
	viewopts->tailflags = -1;

	viewopts->I_animate = -1;
	viewopts->I_CheckeredPattern = -1;
	viewopts->I_ColorProfile = -1;
#endif
}

BOOL CheckParam(VIEWOPTIONS *viewopts, const TCHAR *param, TCHAR *filename)
{
	BOOL reuse = FALSE;
	TCHAR buf[CMDLINESIZE];

	ReqWndShow = -1;
	InitViewOptions(viewopts);
	if ( filename != NULL ) filename[0] = '\0';
	for ( ;; ){
		TCHAR *more; // IvṼp[^
		int id;
		UTCHAR code;
		const TCHAR *oldp;

		oldp = param;
		code = GetOptionParameter(&param, buf, &more);
		if ( code == '\0' ) break;
		if ( code != '-' ){ // Jt@C
			if ( filename != NULL ){
				NameFirst = oldp;
				NameLast = param;
				VFSFixPath(filename, buf, NULL, VFSFIX_PATH | VFSFIX_VREALPATH);
			}
			continue;
		}
			// "-Pn" : gݍݎ̐eEBhEw / XN[Z[o[w
		if ( (*(buf + 1) == 'P') && Isdigit(*(buf + 2)) ){
			TCHAR *ptr;

			ptr = buf + 2;
			hViewParentWnd = (HWND)GetNumber((const TCHAR **)&ptr);
			continue;
		}
		{								// x𒲂ׂ
			const TCHAR **label;

			label = OptionNames;
			id = 0;
			while ( *label ){
				if ( !tstrcmp( buf + 1, *label ) ) break;
				label++;
				id++;
			}
		}
		switch ( id ){
			case 0:				// R
				reuse = TRUE;
				break;
			case 1:				//	"PRINT",			// 
			case 2:				//	"PRINTS",			// ꊇ
				VO_PrintMode = (id - 1) + PRINTMODE_ONE;
				break;
								// \[h
			case 5:				//	"DOCUMENT",
				viewopts->dtype = DISPT_DOCUMENT;
				ThSetString(NULL, StrDocFilterCmd, more);
				break;

			case 3:				//	"HEX",
			case 4:				//	"TEXT",
//			case 5:				//	"DOCUMENT",
			case 6:				//	"IMAGE",
			case 7:				//	"RAWIMAGE",
				viewopts->dtype = id - OPTNAME_DTYPE + DISPT_HEX;
				break;
							// eLXg\`
			case 8:				//	"IBM"
			case 9:				//	"ANSI"
			case 10:			//	"JIS"
			case 11:			//	"SYSTEM"
			case 12:			//	"EUC"
			case 13:			//	"UNICODE"
			case 14:			//	"UNICODEB"
			case 15:			//	"SJISNEC"
			case 16:			//	"SJISB"
			case 17:			//	"KANA"
			case 18:			//	"UTF8"
			case 19:			//	"UTF7"
			case 20:			//	"RTF"
				viewopts->T_code = id - OPTNAME_TCODE;
				break;
			case 21:			//	"SISO:AUTO", "SISO:OFF", "SISO:ON",
				viewopts->T_siso = CheckSubParam(more, AutoOffOn, 2);
				break;
			case 22:			//	"ESC:OFF", "ESC:ON",
				viewopts->T_esc = CheckSubParam(more, OffOn, 1);
				break;
			case 23:			//	"TAG:OFF", "TAG:ON", "TAG:TAG"
				viewopts->T_tag = CheckSubParam(more, TagOffOn, 1);
				break;
			case 24:			//	"BOOTID:A-Z"
				if ( Isalpha(*more) ){
					MultiBootMode = PPXREGIST_IDASSIGN;
					if ( Isalpha(*(more + 1)) ){
						RegID[1] = upper(*more);
						RegID[2] = upper(*(more + 1));
					}else{
						RegID[2] = upper(*more);
					}
				}
				break;
			case 25:			//	"BOOTMAX:A-Z"
				if ( Isalpha(*more) ){
					MultiBootMode = PPXREGIST_MAX;
					RegID[2] = upper(*more);
				}
				break;
			case 26:			//	"CONVERT:filename"
			case 27:			//	"CONVERTSJIS:filename"
				convert = 1;
				more = *more ? more : T("con");
				convertname[0] = '\0';
				GetLineParamS((const TCHAR **)&more, convertname, TSIZEOF(convertname));
				break;
			case 28:			//	"CONVERTEUC:filename"
				convert = 2;
				more = *more ? more : T("con");
				convertname[0] = '\0';
				GetLineParamS((const TCHAR **)&more, convertname, TSIZEOF(convertname));
				break;
			case 29:			//	"focus:hwnd"
				hLastViewReqWnd = hViewReqWnd = (HWND)GetNumber((const TCHAR **)&more);
				break;
			case 30:			//	k
				FirstCommand = param;
				param = NilStr;
				break;
			case 31:			//	min
				ReqWndShow = WinPos.show = SW_SHOWMINNOACTIVE;
				break;
			case 32:			//	max
				ReqWndShow = WinPos.show = SW_SHOWMAXIMIZED;
				break;
			case 33:			//	noactive
				ReqWndShow = WinPos.show = SW_SHOWNOACTIVATE;
				break;
			case 34:			//	width
				viewopts->T_width = GetNumber((const TCHAR **)&more) + VIEWOPTIONS_WIDTHOFFSET;
				break;
			case 35:			//	linespace
				viewopts->linespace = GetNumber((const TCHAR **)&more);
				break;
			case 36:			//	tab
				viewopts->T_tab = GetNumber((const TCHAR **)&more);
				break;
			case 37:			//	"animate:OFF", "animate:ON",
				viewopts->I_animate = CheckSubParam(more, OffOn, 1);
				break;
			case 38:			//	"CheckeredPattern:OFF", "CheckeredPattern:ON"
				viewopts->I_CheckeredPattern = CheckSubParam(more, OffOn, 1);
				break;
			case 39:			//	css
				viewopts->T_show_css = CheckSubParam(more, OffOn, 1);
				break;
			case 40:			//	script
				viewopts->T_show_script = CheckSubParam(more, OffOn, 1);
				break;
			case 41:			//	tail
				viewopts->tailflags = CheckSubParam(more, OffOn, 1);
				break;

			case 42:			//	codepage
				viewopts->T_code = GetNumber((const TCHAR **)&more);
				if ( viewopts->T_code < VTYPE_MAX ){
					viewopts->T_code = VTYPE_SYSTEMCP;
				}
				break;
			case 43:			//	"SJIS"
				viewopts->T_code =
						( VO_textS[VTYPE_SYSTEMCP] == textcp_sjis ) ?
						VTYPE_SYSTEMCP : CP__SJIS;
				break;
			case 44:			//	"US"
				viewopts->T_code = VTYPE_IBM;
				break;
			case 45:			//	"LATIN1"
				viewopts->T_code = VTYPE_ANSI;
				break;
			case 46:			//	"UTF16"
				viewopts->T_code = VTYPE_UNICODE;
				break;
			case 47:			//	"UTF16BE"
				viewopts->T_code = VTYPE_UNICODEB;
				break;
			case 48:			//	"PARENT"
				hViewParentWnd = (HWND)GetNumber((const TCHAR **)&more);
				break;
			case 49:			//	"POPUP"
				ParentPopup = TRUE;
				hViewParentWnd = (HWND)GetNumber((const TCHAR **)&more);
				break;
			case 50:			//	"setparent:hwnd"
				hLastViewReqWnd = (HWND)GetNumber((const TCHAR **)&more);
				break;
			case 51:			//	"MIME:OFF", "MIME:ON",
				viewopts->T_mime = CheckSubParam(more, OffOn, 1);
				break;
			case 52:			//	"showstyle:sdi/onwnd/onmainwnd/inwnd/inmainwnd",
				if ( Isdigit(*more) ){
					X_vpos = GetNumber((const TCHAR **)&more);
				}else{
					X_vpos = CheckSubParam(more, ListStyle, 1);
				}
				X_vpos_custom = TRUE;
				break;
			case 53:			//	"history:OFF/ON"
				viewopts->history = CheckSubParam(more, OffOn, 1);
				break;
			case 54:			//	"combo:type"
				EmbedCombo = GetNumber((const TCHAR **)&more);
				break;
			case 55:			//	"ColorProfile:OFF", "ColorProfile:ON"
				viewopts->I_ColorProfile = CheckSubParam(more, OffOn, 1);
				break;
			default:
				XMessage(NULL, NULL, XM_GrERRld, MES_EUOP, buf);
		}
	}
	return reuse;
}

void InitGui(void)
{
	UINT ID = 0x1000;

	if ( hToolBarWnd != NULL ){
		CloseToolBar(hToolBarWnd);
		ThFree(&thGuiWork);
		hToolBarWnd = NULL;
	}
	if ( X_win & XWIN_TOOLBAR ){
		hToolBarWnd = CreateToolBar(&thGuiWork, vinfo.info. hWnd, &ID, T("B_vdef"), PPvPath, 0);
	}
}

BOOL InitializePPv(int *result)
{
	BOOL reuse;
	TCHAR name[VFPS];
	TCHAR cmd[CMDLINESIZE];
	const TCHAR *cmdptr;
	const TCHAR *lpszCmdLine;
	int viewflag; // reuse ̎gp
	int viewshow;
	DWORD X_iexo[3] = {0,0,0};

	PPxCommonExtCommand(K_CHECKUPDATE, 0);
	FixCharlengthTable(T_CHRTYPE);
	PPxCommonExtCommand(K_UxTheme, KUT_INIT);
	if ( GetACP() != CP__SJIS ) VO_textS[VTYPE_SYSTEMCP] = textcp_systemcp;

	GetModuleFileName(hInst, PPvPath, MAX_PATH);
	*VFSFindLastEntry(PPvPath) = '\0';

										// IvV ---------------------
	lpszCmdLine = GetCommandLine();
	GetLineParamS(&lpszCmdLine, name, TSIZEOF(name));
	reuse = CheckParam(&viewopt_def, lpszCmdLine, name);

	GetCustData(T("X_iexo"), &X_iexo, sizeof(X_iexo));
	if ( viewopt_def.I_animate < 0 ){
		viewopt_def.I_animate = X_iexo[0];
	}
	if ( viewopt_def.I_CheckeredPattern < 0 ){
		viewopt_def.I_CheckeredPattern = X_iexo[1];
	}
	if ( viewopt_def.I_ColorProfile < 0 ){
		viewopt_def.I_ColorProfile = X_iexo[2];
	}
										// -R  ----------------------------
	if ( reuse ){
		viewflag = ((WinPos.show == SW_SHOWNOACTIVATE) ||
				(WinPos.show == SW_SHOWMINNOACTIVE)) ?
				PPV_DISABLEBOOT | PPV_PARAM | PPV_NOFOREGROUND :
				PPV_DISABLEBOOT | PPV_PARAM;

		if ( NameFirst == NULL ){ // t@CwȂ
			cmdptr = lpszCmdLine;
		}else{ // t@CwL聨Kt@C}
			TCHAR *fptr;
			size_t size;

			size = NameFirst - lpszCmdLine;
			memcpy(cmd, lpszCmdLine, size * sizeof(TCHAR));
			fptr = cmd + size;
			*fptr++ = '\"';
			tstrcpy(fptr, name);
			fptr += tstrlen(fptr);
			*fptr++ = '\"';
			*fptr++ = ' ';
			tstrcpy(fptr, NameLast);
			cmdptr = cmd;
		}
		if ( MultiBootMode == PPXREGIST_IDASSIGN ){
			setflag(viewflag, PPV_BOOTID | ((int)RegID[2] << 24));
		}

		if ( (MultiBootMode == PPXREGIST_NORMAL) || (MultiBootMode == PPXREGIST_IDASSIGN) ){
			*result = 1;
			// Ăяo PPx ʒm̂߂ hLastViewReqWnd ݒ
			if ( PPxView(hLastViewReqWnd, cmdptr, viewflag) ){
				*result = 0;
				return FALSE;
			}
		}
	}
	if ( PPxRegist(PPXREGIST_DUMMYHWND, RegID, MultiBootMode) < 0 ){
		if ( hViewParentWnd == NULL ){
			*result = 1;
			if ( reuse ){
				if ( PPxView(NULL, cmd, viewflag) ) *result = 0;
			}else{
				SetForegroundWindow(PPxGetHWND(RegID));
				*result = 0;
			}
			return FALSE;
		}
	}

	InitPPvWindow();
	if ( vinfo.info.hWnd == NULL ) return FALSE;
	// ShowWindow ȑO WinPos.show ύX邱Ƃ邽߁Aŕۑ
	viewshow = (ReqWndShow < 0) ? WinPos.show : ReqWndShow;
										// R}hCwt@Cǂݍ
	if ( name[0] != '\0' ){
		WmWindowPosChanged(vinfo.info.hWnd); // ܂A񂪂ȂƂ
		OpenViewObject(name, NULL, &viewopt_def, 0);
		if ( vo_.DModeBit == DOCMODE_NONE ){
			*result = 0;
			if ( convert ) return FALSE;
		}else{
			if ( !convert ){ // ŕ\ȂƁAFollowOpenView   SC_RESTORE Ōxo
				ShowWindow(vinfo.info.hWnd, viewshow);
			}
			FollowOpenView(&vinfo);
			if ( VO_PrintMode == PRINTMODE_ONE ){
				PostMessage(vinfo.info.hWnd, WM_PPXCOMMAND, K_c | 'P', 0);
			}
			if ( hViewReqWnd != NULL ){
				PostMessage(vinfo.info.hWnd, WM_PPXCOMMAND, KV_FOCUS, 0);
			}
		}
	}else{
		DWORD type;

		type = GetFileType(GetStdHandle(STD_INPUT_HANDLE));
		if ( (type == FILE_TYPE_DISK) || (type == FILE_TYPE_PIPE) ){
			OpenViewObject(T("stdin"), NULL, &viewopt_def, PPV__stdin);
			if ( vo_.DModeBit == DOCMODE_NONE ){
				*result = 0;
				return FALSE;
			}
			if ( !convert ){ // ŕ\ȂƁAFollowOpenView   SC_RESTORE Ōxo
				ShowWindow(vinfo.info.hWnd, viewshow);
			}
			FollowOpenView(&vinfo);
		}
	}
	if ( convert ){
		ConvertMain();
		PostMessage(vinfo.info.hWnd, WM_CLOSE, 0, 0);
	}else{								// CEChE̕\XV -------
		SetMenu(vinfo.info.hWnd,
				(X_win & XWIN_MENUBAR) ? DynamicMenu.hMenuBarMenu : NULL);
		ShowWindow(vinfo.info.hWnd, viewshow);
		FixShowRectByShowStyle(NULL, hLastViewReqWnd);
		UpdateWindow(vinfo.info.hWnd);
		if ( X_IME == 1 ) PostMessage(vinfo.info.hWnd, WM_PPXCOMMAND, K_IMEOFF, 0);
		DragAcceptFiles(vinfo.info.hWnd, TRUE);
		// ߍݎgpAOʂɕ\
		if ( (hViewParentWnd != NULL) &&
			 (ReqWndShow < 0) &&
			 (viewshow == SW_SHOWNORMAL) ){
			SetWindowPos(vinfo.info.hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
		}
		SetCurrentDirectory(PPvPath);
	}
	return TRUE;
}

HFONT InitOtherFont(int mode)
{
	LOGFONT cursfont = {
/*Width, Height*/					0, 0, \
/*Escapement, Orientation, Weight*/	0, 0, FW_NORMAL, \
/*Italic, Underline, StrikeOut*/	FALSE, FALSE, FALSE, \
/*CharSet*/							SHIFTJIS_CHARSET, \
/*OutPrecision*/					OUT_DEFAULT_PRECIS, \
/*ClipPrecision*/					CLIP_DEFAULT_PRECIS, \
/*Quality*/							DEFAULT_QUALITY, \
/*PitchAndFamily*/					FIXED_PITCH | FF_MODERN,\
/*FaceName*/						T("Courier New")
	};

	cursfont.lfHeight	= fontY;
	cursfont.lfWidth	= fontX;
	switch (mode){
		case 0: // hANSIFont ANSItHg쐬
			cursfont.lfCharSet	= ANSI_CHARSET;
			break;

		case 1: // hIBMFont IBMtHg쐬
			cursfont.lfCharSet	= OEM_CHARSET;
			break;

		default: // hSYMFont LtHg쐬
			cursfont.lfWidth--; // fontX - 1;
			cursfont.lfCharSet	= SYMBOL_CHARSET;
			tstrcpy(cursfont.lfFaceName, T("Symbol"));
	}
	return CreateFontIndirect(&cursfont);
}

void InitSymbolFont(HDC hDC)
{
	TEXTMETRIC tm;
	HGDIOBJ hOldFont;

	if ( hSYMFont != INVALID_HANDLE_VALUE ) return;
	hSYMFont = InitOtherFont(2);
	hOldFont = SelectObject(hDC, hSYMFont);
	GetTextMetrics(hDC, &tm);
	fontSYMY = tm.tmHeight;
	SelectObject(hDC, hOldFont);
}

HFONT GetANSIFont(void)
{
	if ( hANSIFont != INVALID_HANDLE_VALUE ) return hANSIFont;
	return (hANSIFont = InitOtherFont(0));
}
HFONT GetIBMFont(void)
{
	if ( hIBMFont != INVALID_HANDLE_VALUE ) return hIBMFont;
	return (hIBMFont = InitOtherFont(1));
}

const TCHAR SampleHexFontText[] = T(" 0123456789ABCDEF");
#define SampleHexFontItems TSIZEOFSTR(SampleHexFontText)

void MakeFonts(HDC hDC, int mag)
{
	HGDIOBJ hOldFont;	//ꎞۑp
	TEXTMETRIC tm;
	LCID lcid;
	LOGFONTWITHDPI cursfont;
										// ėptHg쐬
	GetPPxFont(PPXFONT_F_fix, FontDPI, &cursfont);
	if ( mag != 100 ){
		cursfont.font.lfHeight = (cursfont.font.lfHeight * mag) / 100;
		cursfont.font.lfWidth  = (cursfont.font.lfWidth  * mag) / 100;
	}
	hBoxFont = CreateFontIndirect(&cursfont.font);

										// @/𑜓x
	hOldFont = SelectObject(hDC, hBoxFont);
	GetAndFixTextMetrics(hDC, &tm);
	fontX = tm.tmAveCharWidth;

	if ( !(tm.tmPitchAndFamily & TMPF_FIXED_PITCH) ){ // tHg
		fontSpcX = fontHexX = fontX;
		fontFix = TRUE;
	}else{
		int NumWidth[SampleHexFontItems], *Nptr, i, oldwidth, newwidth, width, result;
		SIZE textsize;

		fontFix = FALSE;
		GetTextExtentExPoint(hDC, SampleHexFontText, SampleHexFontItems, 0x7000, &result, NumWidth, &textsize);

		oldwidth = NumWidth[0];
		fontSpcX = max(fontX, NumWidth[0]);
		fontHexX = 0;
		for ( i = 1, Nptr = NumWidth + 1 ; i < SampleHexFontItems ; i++ ){
			newwidth = *Nptr++;
			width = newwidth - oldwidth;
			oldwidth = newwidth;
			if ( width > fontHexX ) fontHexX = width;
		}
	}

	GetCustData(T("X_ffix"), &X_ffix, sizeof(X_ffix));
	GetCustData(T("X_lspc"), &X_lspc, sizeof(X_lspc));
	fontY = tm.tmHeight;
	LineY = fontY + (((VO_opt != NULL) && (VO_opt->linespace >= 0)) ? VO_opt->linespace : X_lspc);
	if ( LineY < 1 ) LineY = 1;

	lcid = LOWORD(GetUserDefaultLCID());
	if ( lcid == LCID_JAPANESE ){ // Spp̂Q{ɂȂĂ邩`FbN
		SIZE ssize, dsize;		// WindowsXP OVerŋNꍇ

		GetTextExtentPoint32(hDC, T("0"), 1, &ssize);
		GetTextExtentPoint32(hDC, T(""), 2 / sizeof(TCHAR), &dsize);
		fontWW = ssize.cx * 2 - dsize.cx;
	}else{
		fontWW = 0;
	}
	SelectObject(hDC, hOldFont);

	#if DRAWMODE != DRAWMODE_GDI
	{
		int w = SetFontDxDraw(DxDraw, hBoxFont, 0);
		if ( w > fontX ) fontX = w;
	}
	#endif

	if ( XV_unff != FALSE ) MakeUnfixedFont();
}

void DeleteFonts(void)
{
	DeleteObject(hBoxFont);
	if ( hANSIFont != INVALID_HANDLE_VALUE ){
		DeleteObject(hANSIFont);
		hANSIFont = INVALID_HANDLE_VALUE;
	}
	if ( hIBMFont != INVALID_HANDLE_VALUE ){
		DeleteObject(hIBMFont);
		hIBMFont = INVALID_HANDLE_VALUE;
	}
	if ( hSYMFont != INVALID_HANDLE_VALUE ){
		DeleteObject(hSYMFont);
		hSYMFont = INVALID_HANDLE_VALUE;
	}
	if ( hUnfixedFont != NULL ){
		DeleteObject(hUnfixedFont);
		hUnfixedFont = NULL;
	}
}

void MakeUnfixedFont(void)
{
	LOGFONTWITHDPI cursfont;

	GetPPxFont(PPXFONT_F_unfix, 0, &cursfont);

	cursfont.font.lfHeight = fontY;
	cursfont.font.lfWidth = 0;
	hUnfixedFont = CreateFontIndirect(&cursfont.font);
	SetFontDxDraw(DxDraw, hUnfixedFont, 1);
}

int GetCustTableCID(const TCHAR *str, const TCHAR *sub, void *bin, size_t b_size)
{
	if ( NO_ERROR == GetCustTable(str, sub, bin, b_size) ) return NO_ERROR;
	return GetCustTable(str, (sub[1] == '\0') ? DefCID + 1 : DefCID, bin, b_size);
}

BOOL PPvSettingChange(HWND hWnd)
{
	int X_uxt;

	if ( PPxCommonExtCommand(K_UxTheme, KUT_SETTINGCHANGE) == FALSE ) return FALSE;

	X_uxt = PPxCommonExtCommand(K_UxTheme, KUT_LOADCUST);
	if ( X_uxt >= UXT_MINMODIFY ) LocalizeDialogText(hWnd, 0);
	return TRUE;
}

// JX^}CYe擾 -----------------------------------------------------
void PPvLoadCust(void)
{
	THEME_COLORS Theme_Color;
	int i;

	Theme_Color.ExtraDrawFlags = KUTS_COLORS;
	Theme_Color.c.FrameHighlight = sizeof(Theme_Color);
	PPxCommonExtCommand(K_UxTheme, (WPARAM)&Theme_Color);

	GetCustTable(T("X_win"),	T("V"), &X_win, sizeof(X_win));
	GetCustData(T("X_alt"),		&X_alt, sizeof(X_alt));
	GetCustData(T("X_iacc"),	&X_iacc, sizeof(X_iacc));
	GetCustData(T("X_hisr"), 	&X_hisr, sizeof(X_hisr));
	GetCustData(T("X_evoc"),	&X_evoc, sizeof(X_evoc));
	GetCustData(T("X_scrm"),	&X_scrm, sizeof(X_scrm));
	GetCustData(T("X_IME"),		&X_IME, sizeof(X_IME));
	GetCustData(T("X_swmt"),	&X_swmt, sizeof(X_swmt));
	if ( X_vpos_custom == FALSE ){
		GetCustData(T("X_vpos"),	&X_vpos, sizeof(X_vpos));
	}

	C_back = GetSchemeColor(C_S_BACK, 0);
	C_mes = GetSchemeColor(C_S_MES, 0);
	C_info = GetSchemeColor(C_S_INFO, 0);
	C_line = GetSchemeColor(C_S_LINE, 0);

	GetCustData(T("CV_boun"),	&CV_boun, sizeof(CV_boun));
	GetCustData(T("CV_ctrl"),	&CV_ctrl, sizeof(CV_ctrl));
	GetCustData(T("CV_lf"),		&CV_lf, sizeof(CV_lf));
	GetCustData(T("CV_tab"),	&CV_tab, sizeof(CV_tab));
	GetCustData(T("CV_spc"),	&CV_spc, sizeof(CV_spc));
	GetCustData(T("CV_link"),	&CV_link, sizeof(CV_link));
	GetCustData(T("CV_syn"),	&CV_syn, sizeof(CV_syn));
	GetCustData(T("CV_lbak"),	&CV_lbak, sizeof(CV_lbak));
	CV_char[CV__olddefback] = C_BLACK;
	CV_char[CV__olddeftext] = C_DWHITE;
	CV_char[CV__olddeftext + 1] = 0xe0e0e0e0; // = CV__defback
	GetCustData(T("CV_char"), CV_char, sizeof(CV_char));

	for ( i = 0; i < CV_CHAR_TOTAL; i++ ){
		if ( CV_char[i] >= C_Scheme1_MIN ){
			CV_char[i] = GetSchemeColor(CV_char[i], CV_char[i]);
		}
	}

	if ( CV_char[CV__olddeftext + 1] == 0xe0e0e0e0 ){
		CV_char[CV__defback] = CV_char[CV__olddefback];
		CV_char[CV__deftext] = CV_char[CV__olddeftext];
		CV_char[CV__olddefback] = C_DBLACK;
		CV_char[CV__olddeftext] = C_WHITE;
//		CV_char[CV__olddeftext + 1] = C_DBLACK;
		SetCustData (T("CV_char"), CV_char, sizeof(COLORREF) * 16);
	}

	GetCustData(T("CV_lnum"), CV_lnum, sizeof(CV_lnum));
	GetCustData(T("CV_hili"), &CV_hili, sizeof(CV_hili));
	CV_char[CV__highlight] = CV_hili[0];
	GetCustData(T("CV_lcsr"), &CV_lcsr, sizeof(CV_lcsr));

	XV.img.MagMode = IMGD_MM_FULLSCALE;
	XV.img.imgD[imdD_MAG] = IMGD_AUTOWINDOWSIZE;
	if ( hViewParentWnd == NULL ){
		GetCustTableCID(T("XV_imgD"), RegCID, &XV.img.imgD, sizeof(XV.img.imgD));
	}else{
		GetCustTable(T("XV_imgD"), StrRegEmbed, &XV.img.imgD, sizeof(XV.img.imgD));
	}
	XV.img.StretchMode = XV.img.imgD[imdD_MM] & STRETCH_APIMASK;
	XV.img.MoreStrech = (XV.img.imgD[imdD_MM] & STRETCH_PPVMASK) >> STRETCH_PPVSHIFT;

	GetCustData(T("XV_dds"), &X_dds, sizeof(X_dds));
	GetCustData(T("X_awhel"), &X_awhel, sizeof(X_awhel));
	GetCustData(T("XV_bctl"), &XV_bctl, sizeof(XV_bctl));
	if ( OSver.dwMajorVersion < 6 ){
		if ( XV_bctl[0] > 2 ) XV_bctl[0] = 1;
		if ( XV_bctl[1] > 2 ) XV_bctl[1] = 1;
	}
	GetCustData(T("XV_ctls"), &XV_ctls, sizeof(XV_ctls));
	GetCustData(T("XV_pctl"), &XV_pctl, sizeof(XV_pctl));
	GetCustData(T("XV_lnum"), &XV_lnum, sizeof(XV_lnum));
	GetCustData(T("XV_numt"), &XV_numt, sizeof(XV_numt));
	GetCustData(T("C_res"), &C_res, sizeof(C_res));
	GetCustData(T("X_tray"), &X_tray, sizeof(X_tray));
	GetCustData(T("X_fles"), &X_fles, sizeof(X_fles));
	GetCustData(T("XV_tmod"), &XV_tmod, sizeof(XV_tmod));
	GetCustData(T("X_vzs"), &X_vzs, sizeof(X_vzs));
	GetCustData(T("XV_drag"), &XV_drag, sizeof(XV_drag));
	GetCustData(T("XV_left"), &XV_left, sizeof(XV_left));
	GetCustData(T("XV_unff"), &XV_unff, sizeof(XV_unff));
	GetCustData(T("X_askp"), &X_askp, sizeof(X_askp));
	if ( C_res[0] == C_AUTO ) C_res[0] = Theme_Color.c.HighlightText;
	if ( C_res[1] == C_AUTO ) C_res[1] = Theme_Color.c.HighlightBack;
	if ( CV_char[CV__defback] == C_AUTO ) CV_char[CV__defback] = C_back;
	if ( CV_char[CV__deftext] == C_AUTO ){
		CV_char[CV__deftext] = Theme_Color.c.WindowText;
	}
	if ( CV_ctrl == C_AUTO ) CV_ctrl = CV_char[CV__deftext];
	PPvSettingChange(vinfo.info.hWnd);

	if ( X_win & XWIN_HIDETASK ) X_tray = 1;

	if ( OSver.dwMajorVersion >= 6 ){
		GetCustData(T("X_dss"), &X_dss, sizeof(X_dss));
	}
	GetCustTable(T("_others"), T("pppv"), &X_pppv, sizeof(X_pppv));

	StrLoading = MessageText(MES_FLOD);
	StrLoadingLength = tstrlen32(StrLoading);

	LoadHiddenMenu(&XV.HiddenMenu, T("HM_ppv"), PPvHeap, C_mes);

	UseActiveEvent = IsExistCustTable(T("KV_main"), T("ACTIVEEVENT")) ||
		IsExistCustTable(T("KV_img"), T("ACTIVEEVENT")) ||
		IsExistCustTable(T("KV_crt"), T("ACTIVEEVENT")) ||
		IsExistCustTable(T("KV_page"), T("ACTIVEEVENT"));

	X_uxt[0] = PPxCommonExtCommand(K_UxTheme, KUT_LOADCUST);
	GetCustData(T("X_pmc"), &X_pmc, sizeof(X_pmc));
	if ( X_pmc[pmc_mode] > 0 ) PPvEnterTabletMode(vinfo.info.hWnd);

#ifdef USEDIRECTX
	X_scrm = 0;
#endif
}
// JX^}CYeۑ -----------------------------------------------------
void PPvSaveCust(void)
{
	SetCustTable(T("_WinPos"), RegCID, &WinPos, sizeof(WinPos));
}
/*=============================================================================
	Close - ׂẴCX^XsI
=============================================================================*/
const EXECKEYCOMMANDSTRUCT PPvExecKeyMain =
	{(EXECKEYCOMMANDFUNCTION)PPvCommand, T("KV_main"), NULL};

void DestroyPPv(void)
{
	PPXMODULEPARAM pmp = {NULL};

	KillTimer(vinfo.info.hWnd, TIMERID_DRAGSCROLL);
	ExecKeyCommand(&PPvExecKeyMain, &vinfo.info, K_E_CLOSE);
	CallModule(&vinfo.info, PPXMEVENT_DESTROY, pmp, NULL);
	PPxRegist(vinfo.info.hWnd, RegID, PPXREGIST_FREE);

	CloseViewObject();
	vo_.file.name[0] = '\0';
	UnloadWallpaper(&BackScreen);

	if ( X_hkey != NULL ){
		HeapFree( PPvHeap, 0, X_hkey);
		X_hkey = NULL;
	}
	if ( convert == 0 ) PPvSaveCust();
	if ( XV.HiddenMenu.data ){
		HeapFree( PPvHeap, 0, XV.HiddenMenu.data);
		XV.HiddenMenu.data = NULL;
	}

	if ( X_win & XWIN_HIDETASK ){
		if ( hCommonWnd != NULL ){
			PostMessage(hCommonWnd, WM_PPXCOMMAND, KRN_freecwnd, 0);
		}
	}
	if ( !(X_win & XWIN_MENUBAR) ) DestroyMenu(DynamicMenu.hMenuBarMenu);

	CloseDxDraw(&DxDraw);
	FreeAccServer();
	FreeDynamicMenu(&DynamicMenu);

	DeleteFonts();
	DeleteObject(hStatusLine);
	VFSOff();
	FreeOffScreen(&BackScreen);
}

BOOL FixShowRectByShowStyle(RECT *openbox, HWND hParentTargetWnd)
{
	RECT wndbox, visiblebox;

	if ( X_vpos <= VSHOW_SDI ) return FALSE;
	if ( hParentTargetWnd == NULL ){
		if ( openbox != NULL ) return FALSE;
		hParentTargetWnd = (hViewReqWnd != NULL) ? hViewReqWnd : hViewParentWnd;
		if ( hParentTargetWnd == NULL ){
			hParentTargetWnd = PPcGetWindow(0, CGETW_GETFOCUS);
		}
		if ( hParentTargetWnd == NULL ) return FALSE;
	}

	if ( (X_vpos == VSHOW_ONPAIRWINDOW) || (X_vpos == VSHOW_INPAIRWINDOW) ){
		HWND hPairWnd;

		hPairWnd = (HWND)SendMessage(hParentTargetWnd, WM_PPXCOMMAND, KC_GETSITEHWND, (LPARAM)KC_GETSITEHWND_PAIR);
		if ( hPairWnd != NULL ) hParentTargetWnd = hPairWnd;
	}if ( (X_vpos == VSHOW_ONMAINWINDOW) || (X_vpos == VSHOW_INMAINWINDOW) ){
		for (;;){
			HWND hParentWnd;

			hParentWnd = GetParent(hParentTargetWnd);
			if ( hParentWnd == NULL ) break;
			hParentTargetWnd = hParentWnd;
		}
	}
	// hParentTargetWnd ݂Ȃ^\^ŏ̂Ƃ͏d˂Ȃ
	if ( IsWindow(hParentTargetWnd) == FALSE ) return FALSE;
	{
		HWND hCheckWnd;

		hCheckWnd = hParentTargetWnd;
		for (;;){
			if ( (IsWindowVisible(hCheckWnd) == FALSE) ||
				 (IsIconic(hCheckWnd) != FALSE) ){
				return FALSE;
			}
			// eWnd\^ŏmF
			hCheckWnd = GetParent(hCheckWnd);
			if ( hCheckWnd == NULL ) break;
		}
	}

	GetWindowRect(hParentTargetWnd, &wndbox);
	if ( openbox != NULL ){
		*openbox = wndbox;
	}else{
		if ( DDwmGetWindowAttribute == NULL ){
			HANDLE hDWMAPI = LoadSystemDLL(SYSTEMDLL_DWMAPI);

			if ( hDWMAPI != NULL ){
				GETDLLPROC(hDWMAPI, DwmGetWindowAttribute);
			}
			if ( DDwmGetWindowAttribute == NULL ){
				DDwmGetWindowAttribute = INVALID_VALUE(impDwmGetWindowAttribute);
			}
		}
		if ( (DDwmGetWindowAttribute != INVALID_VALUE(impDwmGetWindowAttribute)) &&
			SUCCEEDED(DDwmGetWindowAttribute(vinfo.info.hWnd, DWMWA_EXTENDED_FRAME_BOUNDS, &visiblebox, sizeof(visiblebox))) ){
			if ( visiblebox.left > winS.left ){ // ̘̂gEBhE̘g菬iWindows8/10j
				wndbox.left -= visiblebox.left - winS.left;
				wndbox.top -= visiblebox.top - winS.top;
				wndbox.right -= visiblebox.right - winS.right;
				wndbox.bottom -= visiblebox.bottom - winS.bottom;
			}
			SetWindowPos(vinfo.info.hWnd, NULL, wndbox.left, wndbox.top,
					wndbox.right - wndbox.left, wndbox.bottom - wndbox.top,
					SWP_NOACTIVATE | SWP_NOZORDER);
		}
	}
	return TRUE;
}

void InitPPvWindow(void)
{
	const TCHAR *p;
	WNDCLASS wcClass;
	HDC hDC;
	TCHAR buf[VFPS];
	DWORD style;
	HWND hUseParentWnd;

	vinfo.info.Function = (PPXAPPINFOFUNCTION)PPxGetIInfo;
	vinfo.info.Name = T("PPv");
	vinfo.info.RegID = RegID;
	vinfo.info.hWnd = NULL;

	WM_PPXCOMMAND = RegisterWindowMessage(T(PPXCOMMAND_WM));
	OSver.dwOSVersionInfoSize = sizeof(OSver);
	GetVersionEx(&OSver);

	memset(&vo_, 0, sizeof(vo_));
	ThInit(&vo_.memo);

	SetErrorMode(SEM_FAILCRITICALERRORS);	// vIG[擾\ɂ
	RegCID[1] = RegID[2];

	PPxInitMouseButton(&MouseStat);
	CloseViewObject();
										// WXg -----------
	{
		BYTE show;

		show = WinPos.show;
		if ( NO_ERROR != GetCustTable(T("_WinPos"), RegCID, &WinPos, sizeof(WinPos)) ){
			WinPos.pos.right += WinPos.pos.left;
			WinPos.pos.bottom += WinPos.pos.top;
		}
		if ( (show == SW_SHOWDEFAULT) || (show == SW_SHOWNORMAL) ){
			if ( (WinPos.show == SW_SHOWMINIMIZED) ||
				 (WinPos.show == SW_HIDE) ){
				WinPos.show = SW_SHOWNORMAL;
			}
		}else{
			WinPos.show = show;
		}
	}

	PPvLoadCust();

	if ( X_win & XWIN_HIDETASK ){
		int testtime = 200;

		hCommonWnd = PPxGetHWND(T(PPTRAY_REGID) T("A"));
		if ( hCommonWnd == NULL ) ComExec(NULL, T(PPTRAYEXE), PPvPath);
		while( (hCommonWnd == NULL) || (hCommonWnd == BADHWND) ){
			Sleep(50);
			hCommonWnd = PPxGetHWND(T(PPTRAY_REGID) T("A"));
			if ( --testtime == 0 ) break;
		}
		hCommonWnd = (HWND)SendMessage(hCommonWnd, WM_PPXCOMMAND, KRN_getcwnd, 0);
	}
	C_BackBrush = CreateSolidBrush(C_back);
	hStatusLine = CreateSolidBrush(C_line);
										// search Ăяo
	UsePPx();
	p = EnumHistory(PPXH_SEARCH, 0);
	if ( p ){
		tstrcpy(VOsel.VSstring, p);
		#ifdef UNICODE
			UnicodeToAnsi(VOsel.VSstringW, VOsel.VSstringA, VFPS);
		#else
			AnsiToUnicode(VOsel.VSstringA, VOsel.VSstringW, VFPS);
		#endif
	}
	FreePPx();
										// EChENX` ---------
	wcClass.style			= CS_DBLCLKS;
	wcClass.lpfnWndProc		= WndProc;
	wcClass.cbClsExtra		= 0;
	wcClass.cbWndExtra		= 0;
	wcClass.hInstance		= hInst;
	wcClass.hIcon			= LoadIcon(hInst, MAKEINTRESOURCE(Ic_PPV));
	wcClass.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wcClass.hbrBackground	= NULL;
	wcClass.lpszMenuName	= NULL;
	wcClass.lpszClassName	= T(PPVWinClass);
											// NXo^
	RegisterClass(&wcClass);
	InitDynamicMenu(&DynamicMenu, T("MV_menu"), ppvbar);
										// EBhE쐬 -------------------
	if ( hViewParentWnd == NULL ){
		style = (X_win & XWIN_NOTITLE) ? WS_NOTITLEOVERLAPPED : WS_OVERLAPPEDWINDOW;
		hUseParentWnd = hCommonWnd;
		if ( FixShowRectByShowStyle(&WinPos.pos, hLastViewReqWnd) ){
			if ( (WinPos.show == SW_SHOWMAXIMIZED) ||
				 (WinPos.show == SW_SHOWMINIMIZED) ){
				WinPos.show = SW_SHOWNORMAL;
			}
		}
	}else{
		if ( ParentPopup == FALSE ){ // -parent(previewpr)
			GetClientRect(hViewParentWnd, &WinPos.pos);
			WinPos.pos.right -= WinPos.pos.left;
			WinPos.pos.bottom -= WinPos.pos.top;
			WinPos.pos.left = WinPos.pos.top = 0;

			style = WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS;
			hUseParentWnd = hViewParentWnd;
			setflag(X_win, XWIN_HIDESCROLL);

			viewopt_def.I_animate = 1;
		}else{ // -popup(ߍݗpr)
			GetWindowRect(hViewParentWnd, &WinPos.pos);
			style = WS_POPUP | WS_BORDER | WS_CLIPCHILDREN;
			hUseParentWnd = hViewParentWnd;
		}
	}
	if ( WinPos.show == SW_SHOWMAXIMIZED ) setflag(style, WS_MAXIMIZE);

	vinfo.info.hWnd = CreateWindowEx(0, T(PPVWinClass), NilStr, style,
		WinPos.pos.left, WinPos.pos.top,
		WinPos.pos.right - WinPos.pos.left, WinPos.pos.bottom - WinPos.pos.top,
		hUseParentWnd, NULL, hInst, NULL);
	if ( vinfo.info.hWnd == NULL ) return; // 쐬s
	FixUxTheme(vinfo.info.hWnd, NULL);
	PPxRegist(vinfo.info.hWnd, RegID, PPXREGIST_SETHWND);
	thprintf(buf, TSIZEOF(buf), T("PPV[%c]"), RegID[2]);
	SetWindowText(vinfo.info.hWnd, buf);

	hDC = GetDC(vinfo.info.hWnd);
	CreateDxDraw(&DxDraw, vinfo.info.hWnd, DxRENDER_HWND);
	MakeFonts(hDC, X_textmag);
	VideoBits = GetDeviceCaps(hDC, BITSPIXEL);
	ReleaseDC(vinfo.info.hWnd, hDC);
	InitSystemDynamicMenu(&DynamicMenu, vinfo.info.hWnd);
	VFSOn(VFS_DIRECTORY | VFS_BMP);

	BackScreen.hOffScreenDC = NULL;
	BackScreen.X_WPbmp.DIB = NULL;
	LoadWallpaper(&BackScreen, vinfo.info.hWnd, RegCID);
	FullDraw = X_fles | BackScreen.X_WallpaperType;
	if ( BackScreen.X_WallpaperType ) X_scrm = 0;
	InitGui();

	if ( EmbedCombo ){
		DWORD command;

		command = (EmbedCombo == 1) ? KCW_capture : KCW_capture | KCW_entry_NOACTIVE | (PSPONE_PANE_PAIR + 1) * KCW_entry_DEFPANE;
		PostMessage(GetParent(hViewParentWnd), WM_PPXCOMMAND, (WPARAM)command, (LPARAM)vinfo.info.hWnd);
	}

	PPxRegGetIInfo(&vinfo.info);
}
