/*-----------------------------------------------------------------------------
	Paper Plane vUI											` Text(OASYS) `
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include "PPX.H"
#include "VFS.H"
#include "PPV_STRU.H"
#include "PPV_FUNC.H"
#pragma hdrstop

const unsigned char OasysCode[4][0xbd * 2 + 1] = {
/* ec40 */
"beN??????????????????mmcmkmc2m2"
"k2c3m3mgkgccdlklmsusnspsKBMBGBHPHzmb??ml??b_a`kmckg??"
"defjklihmbHznapbrmskohi??????c)????R)??"
"??????????????0.1.2.3.4.5.6.7.8.9.??1)2)3)4)5)6)7)8)9)1011121314"
"151617181920??@ABCDEFGHIJKLMNOPQRS21TUVW"
"XYZ[\]?????? 1 2 3 4 5 6 7 8 91022232425262728293031",
/* ed40*/
"a)b)c)d)e)f)g)h)i)j)k)l)m)n)o)p)q)r)s)t)u)v)w)x)y)z)????????????"
"??????????????里JЊĎwՌ????????"
"@JwЊĎ??????????"
"????????????????????????????????????????????????????????????????"
"??????????????????????????????????????????????????????????????"
"",
/* ee40 */
""
"??"
"??"
"????????????????????????????????????????????????????????????????"
"??????????????????????????????????????????????????????????????"
"",
/* ef40 */
"RBCDPQ[\]`abcdefghijklmnopqrstuv"
"wxyz@BDFHb????????"
"????[][]cdcc[][][][][]inin/2/4------[][][][]??"
"EE敔́Ɓ????PẂcϋϒSςQ"
"R΍sd~郋pSTggϋgFgggӂӓ]ъہH"
"[]uv\\|x[  [ [] ??????><~MAL|S" };

void Bufwrite(BYTE **buf,char *data,int *cnt)
{
	WORD size;

	size = (WORD)strlen(data);
	if ( size <= *cnt ){
		strcpy((char *)*buf,data);
		*buf += size;
		*cnt -= size;
	}
}
/*-------------------------------------
	Oasys -> HTML
-------------------------------------*/
BYTE *VD_oasys_mdt(MAKETEXTINFO *mti,VT_TABLE *tbl)
{
	BYTE *text;		// ǂݍ݈ʒu
	int cnt;
	WORD code,backup = 0;
	BYTE *dest = mti->destbuf, *dmax = mti->destbuf + mti->destsize;
	BYTE *srcmax = mti->srcmax;

	text = tbl->ptr;
	tbl->type = 3;

	*dest++ = 1;
	while( text < srcmax ){
		cnt = dmax - dest;
		if ( cnt <= 4 ) break;
		if ( backup == 0 ){
			code = *text++;
		}else{
			code = backup;
			backup = 0;
		}
		if ( code == 0xd ){
			if ( *text == 0xa ) text++;
			break;
		}
		if ( code == 0x1a ) break;
		if ( code < ' ' ) continue;
		if ( ((code >= 0x80)&&(code < 0xa0)) ||
			 ((code >= 0xe0)&&(code < 0x100)) ){
			 if ( (*text == 0xf0) && (*(text+1) < ' ') ) text += 4;
			 code = (WORD)((code << 8) + *text++);
		}
		switch(code){
			case 0xefa0:	/* LF */
				if ( (code == 0xefa0) && convert ){
					*dest++ = 0;
					*dest++ = VCODE_RETURN;
					*dest++ = 1;
					*dest++ = VCODE_ASCII;
					continue;
				}
				*dest++ = 0;
				*dest++ = VCODE_TAB;
				*dest++ = VCODE_ASCII;
				continue;
			case 0xefaf:	/* \? */
				text += 3;
				continue;
			case 0xefc0:	/*  */
				text++;
				break;
			case 0xf004:
				text += 2;
				continue;
			case 0xfcc7:
				Bufwrite(&dest," ",&cnt);
				continue;
			case 0xefa2:
			case 0xefa3:
				if ( convert ){
					text += 2;
					continue;
				}
			default:
				if ( (code >= 0xec40) && (code < 0xefbd )){
					int i,j;

					i = (((unsigned)code & 0xff) - 0x40) * 2;
					if ( i < (0xbd * 2) ){
						j = (code - 0xec00) >> 8;
						code = (WORD)((OasysCode[j][i] << 8) + (OasysCode[j][i+1] ));
					}
				}
				if ( code >= 0xf000 ) code = 0x8140;	/* sR[h͋󔒂*/
				if ( code > 0xff ){
					char tmp[3];
					tmp[0] = (BYTE)(code >> 8);
					tmp[1] = (BYTE)(code & 0xff);
					tmp[2] = 0;
					Bufwrite(&dest,tmp,&cnt);
				}else{
					char tmp[2];
					tmp[0] = (char)code;
					tmp[1] = 0;
					Bufwrite(&dest,tmp,&cnt);
				}
		}
	}
	cnt = (WORD)(dest - mti->destbuf);
	if ( cnt > VOi->width ) VOi->width = cnt;

	*dest++ = 0;
	*dest = 0;

	if ( mti->writetbl ){
		(tbl + 1)->Fclr	= tbl->Fclr;
		(tbl + 1)->Bclr	= tbl->Bclr;
		tbl++;
		tbl->ptr	= text;
		tbl->attrs	= 0;
		tbl->line	= (tbl - 1)->line + ((cnt < VOi->width) ? 1 : 0);
	}
	return text;
}
