/*-----------------------------------------------------------------------------
	Paper Plane xUI	customizer										Main
-----------------------------------------------------------------------------*/
#define ONPPXDLL		// PPCOMMON.H  DLL `w
#include "WINAPI.H"
#include "PPX.H"
#include "VFS.H"
#include "PPD_DEF.H"
#include "PPD_CUST.H"
#pragma hdrstop

#define MAXCUSTDATA 0x10000 // CustData ō쐬\ȍől

// SMes buf ̊mۃTCY
#define FIRSTDUMPSIZE 0x12000 // CD ŏo͂eLXg̏TCY
#define FIRSTSTORESIZE 0x800 // CS ŏo͂郍ȌTCY
#define SMESSIZE_MARGIN 64 // CheckSmes Ŏw肵TCYɑlBꕔ͂ݏo(̌̒ǉsƂ)
#define SMESSIZE_MES 200 // xG[bZ[W̗\TCY

const TCHAR DefCommentStr[] = T("\t** comment **");
const char Nilfmt[] = "";

typedef struct {	// GCAX ---------------------------------------------
	const TCHAR *str;	//	x
	int num;			//	l
} LABEL;

/*-----------------------------------------------------------------------------
								FGCAX
-----------------------------------------------------------------------------*/
LABEL ConColor[] = {
	{T("_BLA"), 0},
	{T("_BLU"), FOREGROUND_BLUE  | FOREGROUND_INTENSITY},
	{T("_RED"), FOREGROUND_RED   | FOREGROUND_INTENSITY},
	{T("_MAG"), FOREGROUND_BLUE  | FOREGROUND_RED | FOREGROUND_INTENSITY},

	{T("_GRE"), FOREGROUND_GREEN | FOREGROUND_INTENSITY},
	{T("_CYA"), FOREGROUND_BLUE  | FOREGROUND_GREEN | FOREGROUND_INTENSITY},
	{T("_BRO"), FOREGROUND_RED   | FOREGROUND_GREEN | FOREGROUND_INTENSITY},
	{T("_WHI"), FOREGROUND_BLUE  | FOREGROUND_GREEN | FOREGROUND_RED | FOREGROUND_INTENSITY},

	{T("_DBLA"), FOREGROUND_INTENSITY},
	{T("_DBLU"), FOREGROUND_BLUE},
	{T("_DRED"), FOREGROUND_RED},
	{T("_DMAG"), FOREGROUND_BLUE  | FOREGROUND_RED},

	{T("_DGRE"), FOREGROUND_GREEN},
	{T("_DCYA"), FOREGROUND_BLUE  | FOREGROUND_GREEN},
	{T("_DBRO"), FOREGROUND_RED   | FOREGROUND_GREEN},
	{T("_DWHI"), FOREGROUND_BLUE  | FOREGROUND_GREEN | FOREGROUND_RED},

	{T("R_BLA"), 0},
	{T("R_BLU"), BACKGROUND_BLUE  | BACKGROUND_INTENSITY},
	{T("R_RED"), BACKGROUND_RED   | BACKGROUND_INTENSITY},
	{T("R_MAG"), BACKGROUND_BLUE  | BACKGROUND_RED | BACKGROUND_INTENSITY},

	{T("R_GRE"), BACKGROUND_GREEN | BACKGROUND_INTENSITY},
	{T("R_CYA"), BACKGROUND_BLUE  | BACKGROUND_GREEN | BACKGROUND_INTENSITY},
	{T("R_BRO"), BACKGROUND_RED   | BACKGROUND_GREEN | BACKGROUND_INTENSITY},
	{T("R_WHI"), BACKGROUND_BLUE  | BACKGROUND_GREEN | BACKGROUND_RED | BACKGROUND_INTENSITY},

	{T("R_DBLA"), BACKGROUND_INTENSITY},
	{T("R_DBLU"), BACKGROUND_BLUE},
	{T("R_DRED"), BACKGROUND_RED},
	{T("R_DMAG"), BACKGROUND_BLUE  | BACKGROUND_RED},

	{T("R_DGRE"), BACKGROUND_GREEN},
	{T("R_DCYA"), BACKGROUND_BLUE  | BACKGROUND_GREEN},
	{T("R_DBRO"), BACKGROUND_RED   | BACKGROUND_GREEN},
	{T("R_DWHI"), BACKGROUND_BLUE  | BACKGROUND_GREEN | BACKGROUND_RED},

	{T("_TL"), 0x0400},	// 
	{T("_LL"), 0x0800},	// 
	{T("_RL"), 0x1000},	// E
	{T("_UL"), 0x8000},	// 
};
#define concolor_s 36

// [U`\ȍ
const CLABEL usermenu =	{NULL, f_POPMENU, "=M", NilStr};	// j[
const CLABEL userext =	{NULL, f_EXTRUN, "/X", NilStr};	// t@C
const CLABEL usermes =	{NULL, f_MSGS | fB, "=s", NilStr};	// bZ[W(=؂)
const CLABEL userlang =	{NULL, f_MSGS | fFill, "\ts", NilStr};	// (tab)
const CLABEL userbar =	{NULL, f_TOOLBAR, ",d4x", NilStr};	// c[o[
const CLABEL userkey =	{NULL, f_KEY, "/X", NilStr};	// L[
const CLABEL usersettings = {NULL, fT | fK_sep | fB, "=M", NilStr};	// CӐݒ

typedef struct {
	ThSTRUCT UsersIndex, UsersNames;
	DWORD *UsersIndexMin, *UsersIndexMax;
} USERCUSTNAMES;

// Smes ̋󂫗eʂ̒ ------------------------------------------------------
void CheckSmes(_Inout_ PPCUSTSTRUCT *PCS, size_t req_len)
{
	if ( (PCS->Smes + req_len + SMESSIZE_MARGIN) >= PCS->SmesLim ){
		TCHAR *newptr;
		size_t size;

		size = TSTROFF(PCS->SmesLim - PCS->SmesBuf + req_len);
		size += ThNextAllocSizeM(size);
		if ( PCS->Xmode == PPXCUSTMODE_DUMP_PART ){
			newptr = HeapAlloc(ProcHeap, 0, size + SMESSIZE_MARGIN);
			if ( newptr != NULL ){
				PCS->Xmode = PPXCUSTMODE_DUMP_ALL;
				tstrcpy(newptr, PCS->SmesBuf);
			}
		}else{
			newptr = HeapReAlloc(ProcHeap, 0, PCS->SmesBuf, size + SMESSIZE_MARGIN);
		}
		if ( newptr == NULL ){
			PCS->Smes = PCS->SmesBuf; // Ƃ肠ӂȂ悤ɂĂ
			XMessage(NULL, NULL, XM_FaERRd, MES_ECFL);
			return;
		}
		#pragma warning(suppress: 6001) // 댟o
		PCS->Smes = newptr + (PCS->Smes - PCS->SmesBuf);
		PCS->SmesBuf = newptr;
		PCS->SmesLim = newptr + size / sizeof(TCHAR);
	}
}

size_t StrCpyToSmes(PPCUSTSTRUCT *PCS, const TCHAR *text)
{
	size_t len = tstrlen(text);
	CheckSmes(PCS, len + 1);
	memcpy(PCS->Smes, text, TSTROFF(len + 1) );
	PCS->Smes += len;
	return len;
}

// Smes ɃG[ ----------------------------------------------------
TCHAR *GetNoSepMessage(BYTE *p, TCHAR code) // Zp[^Ȃ
{
	thprintf((TCHAR *)p, CMDLINESIZE, MessageText(MES_ENSP), code);
	return (TCHAR *)p;
}

void SetMes(PPCUSTSTRUCT *PCS, const TCHAR *mes, const TCHAR *type_text)
{
	CheckSmes(PCS, SMESSIZE_MES);
	PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s(%4d): %s")TNL,
			MessageText(type_text), PCS->Dnum, MessageText(mes));
}
void ErrorMes(PPCUSTSTRUCT *PCS, const TCHAR *mes)
{
	SetMes(PCS, mes, MES_LGER);
}
void WarningMes(PPCUSTSTRUCT *PCS, const TCHAR *mes)
{
	SetMes(PCS, mes, MES_LGWA);
}

void SetItemMes(PPCUSTSTRUCT *PCS, const TCHAR *mes, const TCHAR *kword, const TCHAR *sname, const TCHAR *type_text)
{
	CheckSmes(PCS, SMESSIZE_MES);
	if ( sname == NULL ){
		PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s(%4d): %s - %s")TNL,
				MessageText(type_text), PCS->Dnum, kword, MessageText(mes));
	}else{
		PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s(%4d): %s:%s - %s")TNL,
				MessageText(type_text), PCS->Dnum, kword, sname, MessageText(mes));
	}
}
void ErrorItemMes(PPCUSTSTRUCT *PCS, const TCHAR *mes, const TCHAR *kword, const TCHAR *sname)
{
	SetItemMes(PCS, mes, kword, sname, MES_LGER);
}
void WarningItemMes(PPCUSTSTRUCT *PCS, const TCHAR *mes, const TCHAR *kword, const TCHAR *sname)
{
	SetItemMes(PCS, mes, kword, sname, MES_LGWA);
}
//================================================================ JX^}CY
PPXDLL int PPXAPI CheckRegistKey(const TCHAR *src, TCHAR *dest, const TCHAR *custid)
{
	int key;

	key = GetKeyCode(&src);
	if ( key < 0 ) return CHECKREGISTKEY_BADNAME; // L[R[hȂ
	if ( (UTCHAR)*src > ' ' ) return CHECKREGISTKEY_BADNAME; // R[h(͂̕)

										// L[̃`FbN
	// KC_main / KV_main / KV_page / KV_crt / KV_img
	if ( ((*(custid + 1) == 'C') && (*(custid + 3) == 'm')) ||
		 (*(custid + 1) == 'V') ){
		// ' '/\' ' SPACE/\SPACE ɕϊ
		if ( (key == ' ') || (key == (K_s | ' ')) ){
			setflag(key, K_v);
		}
	}else{
		// EDITCONTROLn+PPbSPACE/\SPACE ' '/\' ' ɕϊ
		if ( ((key == K_space) || (key == (K_s | K_space))) &&
			 (!tstrcmp(custid, T("K_edit")) || !tstrcmp(custid, T("K_lied")) || !tstrcmp(custid, T("K_ppe")) || !tstrcmp(custid, T("KB_edit"))) ){
			resetflag(key, K_v);
		}
	}

	if ( IsupperA(key) && (key & K_c) && !(key & (K_a | K_internal)) ){ // Ctrl+p ́AK_v sv
		resetflag(key, K_v);
	}

	// ^J ^\J  zL[R[hɕϊ(^Enter  ^J o͂邽)KB_edit
	// ^ScrollLock  ^C ɂȂ邪A̓`FbNȗ
	if ( ((key & ~(K_s | K_e)) == (K_c | 'J')) &&
		 (*(custid + 1) != 'B') ){
		setflag(key, K_v);
	}

	PutKeyCode(dest, key);

	// EDITCONTROLnK_edit  \Enter, ^Enter ͋@\Ȃ̂Ōx
	if ( ((key == (K_s | K_cr)) || (key == (K_c | K_cr))) &&
		 (!tstrcmp(custid, T("K_edit")) || !tstrcmp(custid, T("K_lied")) || !tstrcmp(custid, T("K_ppe"))) ){
		return CHECKREGISTKEY_WARNKEY;
	}
	// L[́AShiftL CtrlzL[ ɂȂ̂Ōx
	if ( !(key & K_v) && Isdigit(key & 0xff) && (key & (K_s | K_c)) ){
		return CHECKREGISTKEY_WARNKEY;
	}

	// JX^}CYǂݍ݂KvȃL[
	if ( (key == K_E_LOAD) || (key == K_E_SELECT) ){
		return CHECKREGISTKEY_RELOADKEY;
	}

	return CHECKREGISTKEY_OK;
}
/*-----------------------------------------------------------------------------
	s擾
-----------------------------------------------------------------------------*/
_Ret_notnull_ TCHAR *GetConfigLine(_Inout_ PPCUSTSTRUCT *PCS,_Inout_ TCHAR **mem,_In_ TCHAR *max)
{
	TCHAR *p, *bottom;

	bottom = p = *mem;
	while ( p < max ){
		PCS->Dnum++;
#ifdef _WIN64				// CPU bit	;64; c x64bitŐpw
		if ( (*p == ';') && (*(p+1) == '6') &&
			(*(p+2) == '4') && (*(p+3) == '|') ){
			p += 4;
		}
#else						// ;32; c x32bitŐpw
		if ( (*p == ';') && (*(p+1) == '3') &&
			(*(p+2) == '2') && (*(p+3) == '|') ){
			p += 4;
		}
#endif
		bottom = p = SkipSpaceAndFix(p);
		if ( *p == '\0' ){		// s?
			p++;
			PCS->Dnum--;
			continue;
		}
		while( *p != '\0' ){		// Rg̏
			if ( *p == ';'){
				if ((bottom == p) || (*(p - 1) == ' ') || (*(p - 1) == '\t')){
					*p++ = '\0';
					continue;
				}
			}
			if ( (*p == '\r') || (*p == '\n') ){
				*p++ = '\0';
				if ( (*p == '\r') || (*p == '\n') ) p++;
				break;
			}
			p++;
		}
		break;
	}
	*mem = p;
	return bottom;
}
// s󔒂Q -----------------------------------------------------------
void DeleteEndspace(TCHAR *min, TCHAR *max)
{
	for( ; min < max ; max-- ){
		if ( (*(max-1) == ' ') || (*(max-1) == '\t') ) continue;
		break;
	}
	*max = 0;
}
/*
	u+-?^0.00|v`FbNB0:precodeȂ :v :ΏۊO
*/
int CheckPrecode(const TCHAR *ptr, TCHAR command, TCHAR **keyword, const TCHAR *CVer)
{
	TCHAR *sep, *verdest, ver[64];
										// 擪 command H
	if ( (*ptr != command) &&
		 ( (command != '+') || ((*ptr != '?') && (*ptr != '^'))) ){
		return 0;
	}
	ptr++;
										//  '|' H
	sep = tstrchr(ptr, '|');
	if ( sep == NULL ) return 0;
	if ( keyword != NULL ) *keyword = sep + 1;
										// o[W𒊏o & `FbN
	verdest = ver;
	while ( ptr < sep ){
		if ( (*ptr < '.') || (*ptr > '9') ) return 0;
		*verdest++ = *ptr++;
	}
	*verdest = '\0';
										// o[W`FbN
	if ( ver[0] == '\0' ) return 1;	// Ver w薳ɊY
	return tstrcmp(ver, CVer) | 1;
}

BYTE GetNumberWith(const TCHAR **line, BYTE def, DWORD maxnum)
{
	if ( Isdigit(**line) ){
		DWORD num;

		num = (DWORD)GetDigitNumber(line);
		if ( num > maxnum ) num = maxnum;
		return (BYTE)num;
	}else{
		return def;
	}
}

/*-----------------------------------------------------------------------------
	JX^}CY(i[)s͕

	TRUE	:I/~̕KvG[
	FALSE	:~KvG[
-----------------------------------------------------------------------------*/
#pragma warning(suppress:6262) // X^bNgA݂͖
BOOL CSline(PPCUSTSTRUCT *PCS, const TCHAR *kword, TCHAR *sname, TCHAR *line, DWORD flags, const char *fmt, TCHAR **mem, TCHAR *max)
{
	BYTE bin[0x10000];	// i[ě`ꏊ
	BYTE *destp;		// i[e̖

	// 폜̊mF
	if ( sname != NULL ){ // z
		TCHAR *sep;
		int vercmp;

		vercmp = CheckPrecode(sname, '-', &sname, PCS->CVer);
		if ( vercmp < 0 ) return TRUE;	// YȂ
							// kword ux|v폜
		sep = tstrchr(kword, '|');
		if ( sep != NULL ) kword = sep + 1;

		if ( vercmp > 0 ){
			if ( IsExistCustTable(kword, sname) ){
				CheckSmes(PCS, SMESSIZE_MES);
				PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s: %s:%s")TNL,
						MessageText(MES_LGDE), kword, sname);
				DeleteCustTable(kword, sname, 0);
				PCS->reloadflag &= flags;
			}
			return TRUE;
		}
	}else{ // P
		int vercmp;

		vercmp = CheckPrecode(kword, '-', &sname, PCS->CVer);
		if ( vercmp < 0 ) return TRUE;	// YȂ
		if ( vercmp > 0 ){
			if ( IsExistCustData(kword) ){
				CheckSmes(PCS, SMESSIZE_MES);
				PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s: %s")TNL,
						MessageText(MES_LGDE), kword);
				DeleteCustData(kword);
				PCS->reloadflag &= flags;
			}
			return TRUE;
		}
	}

	if ( flags & fOld ){
		if ( sname == NULL ){
			PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("Readonly item:%s")TNL, kword);
		}
		return TRUE;
	}

	destp = bin;
	/* if (!(flags & fC)) */ line = SkipSpaceAndFix(line);	// s󔒂폜
	if ( *line == '\0' ){
		if ( flags & fdelB ){
			if ( sname == NULL ){
				DeleteCustData(kword);
			}else{
				DeleteCustTable(kword, sname, 0);
			}
			PCS->reloadflag &= flags;
			return TRUE;
		}
		if ( !(flags & fB) ) return TRUE;
	}
	if ( *fmt != '\0' ) fmt++;						// Separetor ړ
//--------------------------------------------------------- Dump
	if ( *fmt == '\0' ){
		while( *line != '\0' ){
			int high, low;

			high = GetHexChar(&line);
			if ( high < 0 ) break;
			low = GetHexChar(&line);
			if ( low < 0 ){
				ErrorMes(PCS, T("Hex string"));
				return TRUE;
			}
			*destp++ = (BYTE)((high << 4) + low);
		}
//--------------------------------------------------------- Formats
	}else while( *fmt != '\0' ){
		switch(*fmt++){
//=============================================================================
// C:F -----------------------------------------------------------------------
case 'C':
	*(COLORREF *)destp = CS_color(&line, flags);
	destp += sizeof(COLORREF);
	break;

// c:F/console ---------------------------------------------------------------
case 'c':{
	TCHAR buf[100], *pt, *dst, data;
	int i, c = 0;

	for ( ; ; ){
										// L[[h𒊏o
		pt = line = SkipSpaceAndFix(line);
		dst = buf;
		while((UTCHAR)(data = *pt++) >= (UTCHAR)'A' )	*dst++ = data;
		*dst = 0;
										// `ςݎʎq𔻕
		for ( i = 0 ; i < concolor_s ; i++ ){
			if ( !tstrcmp(buf, ConColor[i].str) ){
				line = pt - 1;
				c |= ConColor[i].num;
				break;
			}
		}
		if ( i == concolor_s ){ // w
			c |= GetNumber((const TCHAR **)&line);
		}
		SkipSPC(line);
		if ( (*line == '+') || (*line == '|') ){
			line++;
			continue;
		}
		break;
	}
	*(WORD *)destp = (WORD)c;
	destp += 2;
	break;
}
// B:2iw ------------------------------------------------------------------
case 'B':
	while ( *fmt++ != '/' );			// \rbgwXLbv
// D:10iw ---------------------------------------------------------
case 'D':
// d:L10iw ---------------------------------------------------------
case 'd':

	*(int *)destp = GetIntNumber((const TCHAR **)&line);
	destp += (DWORD_PTR)((UTCHAR)*fmt++ - (UTCHAR)'0');
	SkipSPC(line);
	if ( (*fmt == ',') && (*line != ',') && ((UTCHAR)*line >= ' ') ){
		ErrorItemMes(PCS, GetNoSepMessage(destp, ','), kword, sname);
		return TRUE;
	}
	break;

// E:(PPC)Gg\ --------------------------------------------------------
case 'E':
	if ( CS_ppcdisp(PCS, &line, &destp) == FALSE ){
		return TRUE;
	}
	break;

// S: -------------------------------------------------------------------
case 's':
case 'S': {
	int binlen;
	TCHAR mode;
	int destlen, linelen;

	mode = *(fmt - 1);
	if ( *fmt == 'D' ){
		mode = 'D';
		fmt++;
	}

	destlen = linelen = tstrlen32(line);
	if ( !Isdigit(*fmt) ){				// wȂ
		binlen = 0;
	}else{								// w肠
		binlen = GetNumberA(&fmt);
	}
	if ( *fmt == ',' ){					// ̂̕ƂɂH
		if ( *line != '\"' ){ // " ŊĂȂ
			TCHAR *sep;

			sep = tstrchr(line, ',');
			if ( sep != NULL ) destlen = linelen = sep - line;
		}else{ // " ŊĂ遨GXP[vƂ
			TCHAR *linesrc, *linedst;

			linesrc = line + 1;
			linedst = line;
			for(;;){
				TCHAR c;

				c = *linesrc;
				if ( c == '\0' ) break;
				if ( c != '\"' ){
					*linedst++ = c;
					linesrc++;
					continue;
				}
				linesrc++;
				c = *linesrc;
				if ( c != '\"' ) break;
				// "" L
				*linedst++ = '\"';
				linesrc++;
				continue;
			}
			*linedst = '\0';
			linelen = linesrc - line;
			destlen = linedst - line;
		}
	}
	if ( binlen != 0 ){					// w肪Ȃ傫mF
		if ( binlen <= destlen ){
			ErrorItemMes(PCS, MES_EFLW, kword, sname);
			return TRUE;
		}
		destlen = binlen;
	}else{
		destlen = destlen + 1;
	}
	tstrcpy((TCHAR *)destp, line);
	*(TCHAR *)((TCHAR *)destp + linelen) = '\0';

	if ( mode == 'D' ){
		tstrreplace( (TCHAR *)destp, T("\""), NilStr);
		if ( (*line == '%') && (*(line + 1) == '0') ){
			int dellen = 2;

			if ( *(line + 2) == '\\' ){
				dellen = 3;
			}else if ( (*(line + 2) == '%') && (*(line + 3) == '\\') ){
				dellen = 4;
			}
			destlen -= dellen;
			memmove( destp , (TCHAR *)((TCHAR *)line + dellen), destlen * sizeof(TCHAR) );
			WarningItemMes(PCS, T("Replace %0 to relative path"), kword, sname);
		}
		if ( tstrchr( (TCHAR *)destp, '%') != NULL ){
			WarningItemMes(PCS, T("Macro character not support"), kword, sname);
		}
	}else if ( mode == 's' ){
		TCHAR *src, *dest;

		destlen = 1;
		dest = (TCHAR *)destp;
		for ( src = (TCHAR *)destp ; *src ; destlen++ ){
#ifndef UNICODE
			if ( IskanjiA(*src) ){
				*dest++ = *src++;
				if ( *src ){
					*dest++ = *src++;
					destlen++;
				}
				continue;
			}
#endif
			if ( *src == '\\' ){
				if ( *(src + 1) == 'n' ){
					*dest++ = '\n';
					src += 2;
					continue;
				}
				if ( *(src + 1) == 't' ){
					*dest++ = '\t';
					src += 2;
					continue;
				}
			}
			*dest++ = *src++;
		}
		*dest = '\0';
	}
	destp += TSTROFF(destlen);
	line += linelen;
	break;
}
// M;sL ---------------------------------------------------------------
case 'M':
case 'm':
	for ( ; ; ){
		int len;
		size_t size;

		len = tstrlen32(line);
		size = TSTROFF(len + 1);
		memcpy(destp, line, size);
		destp += size;
		line += len;

		if ( (**mem != ' ') && (**mem != '\t') ) break; // Ȃ̂ŏI
		line = GetConfigLine(PCS, mem, max);
		if ( *line == '\0' ) break;
		#ifdef UNICODE
			*(destp - 2) = (BYTE)((*(fmt - 1) == 'M') ? '\n' : '\0');
			*(destp - 1) = '\0';
		#else
			*(destp - 1) = (BYTE)((*(fmt - 1) == 'M') ? '\n' : '\0');
		#endif
	}
	if ( *(fmt - 1) == 'M' ) break;
	#ifdef UNICODE
		*destp = '\0';
		*(destp + 1) = '\0';
		destp += 2;
	#else
		*destp++ = '\0';
	#endif
	break;

// k;keys ---------------------------------------------------------------------
case 'k': {
	int i;
	i = MAX32;	// @ `FbNp
	for ( ; ; ){
		line = SkipSpaceAndFix(line);
		if ( !*line ) break;
		i = GetKeyCode((const TCHAR **)&line);
		if ( i < 0 ){
			ErrorItemMes(PCS, MES_EKFT, kword, sname);
			return TRUE;
		}
		*(WORD *)destp = (WORD)i;
		destp += 2;
	}
	// E:edit P:pack
	if ( !(i & (K_raw | K_ex)) && ((i & 0x1ff) != 'E')&&((i & 0x1ff) != 'P')){
											// 0.40 ܂ŁAK_rawȂ΍
		if ( (i == (K_c | K_s | K_F10)) || (i == (K_tab)) ){
			*(WORD *)(destp - 2) = (WORD)(i | K_raw);
		}else{ // L[Ă̎́AăGCAX̌xs
			if ( kword[0] == 'K' ) WarningItemMes(PCS, MES_WNOA, kword, sname);
		}
	}
	*(WORD *)destp = 0;
	destp += 2;
	break;
}
// K;key - PL[̂ݎw -----------------------------------------------------
case 'K': {
	int i;

	line = SkipSpaceAndFix(line);
	if ( !*line ) break;
	i = GetKeyCode((const TCHAR **)&line);
	if ( i < 0 ){
		ErrorItemMes(PCS, MES_EKFT, kword, sname);
		return TRUE;
	}
	*(WORD *)destp = (WORD)i;
	destp += 2;
	break;
}
// X:Exec/Keys  -----------------------------------------------------------
case 'x':
case 'X':
	line = SkipSpaceAndFix(line);
	if ( *line++ == '=' ){
		*destp = EXTCMD_KEY;
		fmt = "k";
	}else{
		line = SkipSpaceAndFix(line);
		*destp = EXTCMD_CMD;
		fmt = "M";
	}
	destp++;
	#ifdef UNICODE
	*destp++ = '\0';
	#endif
	continue;

// V:ID/Version ---------------------------------------------------------------
case 'V': {
	TCHAR *comment;
	int off;
										// o[W𒊏o -------------------
	comment = tstrchr(line, ',');
	if ( comment == NULL ) comment = line + tstrlen(line);
	off = comment - line;
	memcpy(destp, line, TSTROFF(off));
	destp += off * sizeof(TCHAR);
	*((TCHAR *)destp) = '\0';
	destp += sizeof(TCHAR);
	PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("File version : %s")TNL,
			(TCHAR *)(BYTE *)(destp - TSTROFF(off + 1)));
										// Rg/i[`FbN --------------
	if ( *comment == ',' ) comment++;
	if ( *comment == '\0' ) break;
	CheckSmes(PCS, tstrlen(comment));
	if ( *comment == '?' ){
		comment++;
		thprintf(PCS->Smes, CMDLINESIZE, T("File comment : %s") TNL
				T("Include this file?"), comment);
		if ( (PCS->Sure != NULL) && (PCS->Sure(PCS->Smes) != IDYES) ){
			return FALSE;
		}
	}else{
		PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("File comment : %s")TNL, comment);
	}
	break;
}
// sEZp[^ -----------------------------------------------------------
case ' ':
	continue;
default:
	line = SkipSpaceAndFix(line);
	if ( *line != *(fmt - 1) ){
		if ( (*(fmt - 1) != *fmt) && !(flags & fSwarn) ){
			WarningItemMes(PCS, GetNoSepMessage(destp, *(fmt-1)), kword, sname);
		}
		fmt = Nilfmt;
		break;
	}else{
		if ( *fmt == *(fmt - 1) ) fmt++;
	}
	line++;
	break;
//=============================================================================
		}
	}
	if ( sname != NULL ){	// z̍ڂۑ--------------------------
		TCHAR newSname[VFPS], sn;
		int pre;
		sn = *sname;
												// ڂ̋ǉ(updatê)
		pre = CheckPrecode(sname, '+', &sname, PCS->CVer);
				// (update) && (o^łȂ)  ʏ
		if ( (PCS->Xmode == PPXCUSTMODE_UPDATE) && !PCS->XupdateTbl ){
			if ( pre < 0 ) return TRUE;	// Yo[WłȂ߁AXVȂ
			if ( pre == 0 ){
				if ( flags & fFill ){
					 sn = '?';
				}else{
					return TRUE; // "+|" łȂo^
				}				 // "+|" 󋵃bZ[Wœo^
			}
			CheckSmes(PCS, SMESSIZE_MES);
			if ( IsExistCustTable(kword, sname) ){ // ڗL聨㏑
				if ( sn == '?' ) return TRUE; // "?|" ͏㏑Ȃ
				PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s: %s:%s")TNL,
						MessageText(MES_LGOW), kword, sname);
			}else{ // ږǉ
				PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s: %s:%s")TNL,
						MessageText(MES_LGCR), kword, sname);
			}
		}
		if ( flags & fK_Mouse ) tstrupr(sname);	// 啶
		if ( flags & fKeyFix ){				// L[R[h̐K -------------
			switch ( CheckRegistKey(sname, newSname, kword) ){
				case CHECKREGISTKEY_BADNAME:
					ErrorMes(PCS, MES_EKFT);
					return TRUE;
				case CHECKREGISTKEY_WARNKEY:
					WarningItemMes(PCS, MES_WKSI, kword, sname);
					break;
				case CHECKREGISTKEY_RELOADKEY:
					resetflag(PCS->reloadflag, fNoRelo); // JX^}CYǂݍ݂Kv
					break;
				// default:
			}
			sname = newSname;
		}else if ( flags & fK_HMenu ){ // Bj[pɉH ---------------
			tstrcpy(newSname, sname);
			#ifdef UNICODE
				if ( (newSname[1] == '\0') && ((UTCHAR)newSname[1] < 0x200) ){
					newSname[1] = ' ';
					newSname[2] = '\0';
				}
			#else
				if ( newSname[1] == '\0' ){
					newSname[1] = ' ';
					newSname[2] = '\0';
				}
			#endif
			sname = newSname;
		}else if ( flags & (fK_ExtWild | fK_PathWild) ){ // ChJ[ho
			const TCHAR *sp;

			if ( !((sname[0] == '*') && (sname[1] == '\0')) ){
				sp = sname;
				if ( flags & fK_ExtWild ){
					if ( *sp != ':' ){ // t@CʖȊOȂ烏ChJ[h`FbN
						for ( ; *sp ; sp++ ){
							if ( (*sp >= '!') && (*sp <= '?') ){
								if ( tstrchr(DetectWildcardLetter, *sp) != NULL ){
									newSname[0] = '/';
									tstrcpy(newSname + 1, sname);
									sname = newSname;
									break;
								}
							}
						}
					}
					if ( sname != newSname ) tstrupr(sname);
				}else{ // fK_PathWild
					if ( *sp != ':' ){ // pXw(/؂p)ȊOȂ烏ChJ[h`FbN
						if ( tstrchr(sp, '/') != NULL ){ // K\ ftp:/ n
							int drive;
							if ( VFSGetDriveType(sp, &drive, NULL) != NULL ){
								if ( drive >= VFSPT_FILESCHEME ){ // VFSPT_FTP, VFSPT_SHELLSCHEME, VFSPT_HTTP
									sp = NilStr;
								}
							}
						}
						for ( ; *sp ; sp++ ){
							if ( (*sp >= '!') && (*sp <= '?') ){
								if ( tstrchr(DetectPathWildcardLetter, *sp) != NULL ){
									newSname[0] = '/';
									tstrcpy(newSname + 1, sname);
									sname = newSname;
									break;
								}
							}
						}
					}
				}
			}
		}
		if ( (flags & fK_sep) && // j[̋؂蕶̎́AioOȂ
			 (sname[2] == '\0') &&
			 ( ((sname[0] == '-') && (sname[1] == '-')) ||
			   ((sname[0] == '|') && (sname[1] == '|'))) ){
			int num = 1;

			for(;;){
				thprintf(sname + 2, 12, T(".%d"), num);
				if ( !IsExistCustTable(kword, sname) ) break;
				num++;
			}
		}
		if ( NO_ERROR != SetCustTable(kword, sname, bin, destp - bin) ){
			goto noareaerror;
		}
	}else{					// Pڂ̕ۑ ---------------------------------
		TCHAR sn;
		int pre;
		sn = *kword;

		if ( (sn == '^') && (*(kword + 1) == '|') ){ // ڂ̈ꕔǉ
			int size;

			kword += 2;
			if ( PCS->Xmode == PPXCUSTMODE_UPDATE ){
				size = GetCustDataSize(kword);
				if ( size >= 0 ){
					if ( (destp - bin) > size ){ // ڂȂ
						CheckSmes(PCS, SMESSIZE_MES);
						PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
								T("%s: %s")TNL, MessageText(MES_LGAP), kword);
						GetCustData(kword, bin, sizeof(bin));
					}else{ // ڐɖȂ
						return TRUE;
					}
				}
			}
		}else{
															// ڂ̋ǉ
			pre = CheckPrecode(kword, '+', (TCHAR **)&kword, PCS->CVer);
			if ( PCS->Xmode == PPXCUSTMODE_UPDATE ){	// update
				if ( pre < 0 ) return TRUE;	// Yo[WłȂ߁AXV
				if ( pre > 0 ){
					if ( sn == '?' ) return TRUE; // "?|" ͏㏑Ȃ
					if ( IsExistCustData(kword) ){
						// ㏑
						CheckSmes(PCS, SMESSIZE_MES);
						PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
								T("%s: %s")TNL, MessageText(MES_LGOW), kword);
					}
				}else{	// "+|" Ȃ	^ ɍڂȂۑȂ
					if ( IsExistCustData(kword) ) return TRUE;
					// VK
					CheckSmes(PCS, SMESSIZE_MES);
					PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
								T("%s: %s")TNL, MessageText(MES_LGCR), kword);
				}
			}
		}
		if ( NO_ERROR != SetCustData(kword, bin, destp - bin) ) goto noareaerror;
	}
	PCS->reloadflag &= flags;
	return TRUE;
noareaerror:
	ErrorMes(PCS, MES_ECFL);
	return FALSE;
}

int CSitem(PPCUSTSTRUCT *PCS, const CLABEL *, TCHAR, TCHAR *, TCHAR *, TCHAR **, TCHAR *memmax);

int CSlang(PPCUSTSTRUCT *PCS,
		TCHAR *kword,	// Keyword
		TCHAR *ptr,		// ͈ʒu
		TCHAR **mem,	// t@Cȅʒu
		TCHAR *memmax)		// t@Ce̖[
{
	if ( *ptr != '#' ){	// ʏ cfg 
		return CSitem(PCS, &usermes, '=', kword, ptr, mem, memmax);
	}else{ // t@C
		if ( PCS->ModeFlags & PPXCUSTMODE_LANG_FILE ){
			const TCHAR *kptr;
			TCHAR *kwordp;
			DWORD X_LANG;

			kwordp = tstrchr(kword, '|');
			kwordp = (kwordp == NULL) ? kword : kwordp + 1;

			// kword  MesXXXX Ȃ̂ŌߑłAMeHXXXX ɏ
			kptr = kwordp + 2;
			kwordp[2] = 'H';
			X_LANG = GetNumber(&kptr);
			SetCustData(T("X_LANG"), &X_LANG, sizeof(X_LANG));
			kwordp[2] = 's';
		}
		return CSitem(PCS, &userlang, '=', kword, ptr + 1, mem, memmax);
	}
}
/*-----------------------------------------------------------------------------
	JX^}CY(i[)ڏ
-----------------------------------------------------------------------------*/
int CSitem(PPCUSTSTRUCT *PCS,
		const CLABEL *clbl,	// Form
		TCHAR sepC,		// Separator LN^
		TCHAR *kword,	// Keyword
		TCHAR *ptr,		// ͈ʒu
		TCHAR **mem,	// t@Cȅʒu
		TCHAR *max)		// t@Ce̖[
{
	if ( !(clbl->flags & fT) ){		// P -----------------------------------
		if ( *clbl->fmt != sepC ){
			ErrorItemMes(PCS, MES_ESEP, kword, NULL);
			return TRUE;
		}
		return CSline(PCS, kword, NULL, ptr, clbl->flags, clbl->fmt, mem, max);
	}else{							// z -----------------------------------
		if ( sepC != '=' ){
			ErrorItemMes(PCS, MES_ESEP, kword, NULL);
			return TRUE;
		}
		ptr = SkipSpaceAndFix(ptr);
		if ( *ptr++ != '{' ){
			ErrorItemMes(PCS, MES_EBRK, kword, NULL);
			return TRUE;
		}

		if ( clbl->flags & fOld ){
			PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("Readonly item:%s")TNL, kword);
		}else{
			TCHAR *p;

			if ( PCS->Xmode == PPXCUSTMODE_UPDATE ){
				int pre;

				p = kword;
				pre = CheckPrecode(kword, '+', &p, PCS->CVer);
				if ( !IsExistCustData(p) ){	// TablêŐVK
					PCS->XupdateTbl = 1;
					CheckSmes(PCS, SMESSIZE_MES);
					PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
							T("%s: %s")TNL, MessageText(MES_LGCR), p);
				}else{
					if ( pre > 0 ){ // TableASXV
						PCS->XupdateTbl = 1;
						CheckSmes(PCS, SMESSIZE_MES);
						PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
								T("%s: %s")TNL, MessageText(MES_LGOW), p);
					}else{ // TableAʂɍXV
						PCS->XupdateTbl = 0;
					}
				}
			}
			if ( PCS->Xmode == PPXCUSTMODE_STORE ){
				DeleteCustData(kword); // 
				p = ptr;
				while ( (*p == ' ') || (*p == '\t') ) p++;
				if ( ((UTCHAR)*p > ' ') && (tstrcmp(DefCommentStr + 1, p) != 0) ){
					int len;

					len = tstrlen32(ptr);
					if ( len >= MAX_PATH ){
						len = MAX_PATH - 1;
						*(ptr + len) = '\0';
					}
					SetCustTable(T("#Comment"), kword, ptr, TSTROFF(len + 1));
				}else if ( *clbl->comment == '\0' ){
					DeleteCustTable(T("#Comment"), kword, 0);
				}
			}
		}
		while( *mem < max ){
			TCHAR *p;
			TCHAR kwordbuf[0x80];

			p = GetConfigLine(PCS, mem, max);
			if ( *p == '\0' ) continue;
			if ( *p == '}' ) break;
												// Zp[^̎ ----------
			ptr = p;
			while( *ptr ){
				if ( *ptr == '\'' ){
					ptr++;
					if ( !*ptr ) break;
					ptr = tstrchr(ptr + 1, '\'');
					if ( ptr == NULL ) break;
				}else if ( *clbl->fmt != '/' ){	// ʏ̃Zp[^
					if ( *ptr == *clbl->fmt ) break;
				}else{							// ؑ֎
					if ( *ptr == '=' ) break;
					if ( *ptr == ',' ) break;
				}
				ptr++;
			}
			if ( (ptr == NULL) || (*ptr == '\0') ){
				ErrorMes(PCS, MES_ESEP);
				continue;
			}
												//  ----------------------
			if ( *clbl->fmt == '/' ){
				if ( (size_t)(ptr - p) > (TSIZEOF(kwordbuf) - 2) ){
					ErrorMes(PCS, MES_ESEP);
					continue;
				}
				memcpy(kwordbuf, p, TSTROFF(ptr - p));
				DeleteEndspace(kwordbuf, kwordbuf + (ptr - p));
				p = kwordbuf;
			}else{
				DeleteEndspace(p, ptr);
			}
			if ( *clbl->fmt != '/' ) ptr++;
			DeleteEndspace(ptr, ptr + tstrlen(ptr));
			if ( !CSline(PCS, kword, p, ptr, clbl->flags, clbl->fmt, mem, max) ){
				return FALSE;
			}
		}
		return TRUE;
	}
}

/*-----------------------------------------------------------------------------
	JX^}CY(i[){
-----------------------------------------------------------------------------*/
PPXDLL int PPXAPI PPcustCStore(TCHAR *mem, TCHAR *memmax, int appendmode, TCHAR **log, int (USECDECL * Sure)(const TCHAR *message))
{
	PPCUSTSTRUCT PCS;
	TCHAR *kword, *ck;				// ږ
	TCHAR *p, sepC;
	const CLABEL *clbl;
	BOOL result = TRUE;

	PCS.Smes = PCS.SmesBuf = HeapAlloc(ProcHeap, 0, FIRSTSTORESIZE + SMESSIZE_MARGIN);
	PCS.SmesLim = PCS.Smes + FIRSTSTORESIZE / sizeof(TCHAR);
	PCS.ModeFlags = appendmode;
	PCS.comment = DUMP_COMMENT;
	PCS.Dnum = 0;
	PCS.Xmode = LOWORD(appendmode);
	PCS.Sure = Sure;
	PCS.reloadflag = fNoRelo | fReSta;

	tstrcpy(PCS.CVer, T("0.00"));
	GetCustData(T("PPxCFG"), &PCS.CVer, sizeof(PCS.CVer));

										// ͏ ---------------------------
	while( (mem < memmax) && result ){
		int pre;
		TCHAR *ne;
										// Keyword ̒o ----------
		kword = GetConfigLine(&PCS, &mem, memmax);
		if ( *kword == '\0' ) continue;
		p = tstrchr(kword, '=');
		if ( p == NULL ) p = tstrrchr(kword, ':');
		if ( (p == NULL) || (p == kword) ){
			ErrorMes(&PCS, MES_EKNF);
			continue;
		}
		DeleteEndspace(kword, p);
		sepC = *p++;
		DeleteEndspace(p, p + tstrlen(p));
										// Keyword ̉ ----------
		ck = kword;

		CheckPrecode(ck, '+', &ck, NilStr);	// '+'͂ł͖
		clbl = Ctbl;
		while( clbl->name != NULL ){
			if ( tstricmp(ck, clbl->name) == 0 ){
				result = CSitem(&PCS, clbl, sepC, kword, p, &mem, memmax);
				break;
			}
			clbl++;
		}
		if ( clbl->name == NULL ){	//  Keyword ̉ ==============
			if ( sepC == ':' ){			// dump ` ----------------
				result = CSline(&PCS, kword, NULL, p, clbl->flags, clbl->fmt, &mem, memmax);
										// [U`j[ --------
			}else if ( (ck[0] == 'M') && (ck[1] == '_') ){
				result = CSitem(&PCS, &usermenu, sepC, kword, p, &mem, memmax);
										// [U`gq --------
			}else if ( (ck[0] == 'E') && (ck[1] == '_') ){
				result = CSitem(&PCS, &userext, sepC, kword, p, &mem, memmax);
										// bZ[W --------
			}else if ( !memcmp(ck, T("Mes"), TSTROFF(3)) && (tstrlen(ck) == 7) ){
				result = CSlang(&PCS, kword, p, &mem, memmax);
										// [U`c[o[ --------
			}else if ( (ck[0] == 'B') && (ck[1] == '_') ){
				result = CSitem(&PCS, &userbar, sepC, kword, p, &mem, memmax);
										// [U`L[ --------
			}else if ( (ck[0] == 'K') && (ck[1] == '_') ){
				result = CSitem(&PCS, &userkey, sepC, kword, p, &mem, memmax);
										// CӐݒ --------
			}else if ( (ck[0] == 'S') && (ck[1] == '_') ){
				result = CSitem(&PCS, &usersettings, sepC, kword, p, &mem, memmax);
										// 폜 ------------------------
			}else{
											// update͌Âo[WΏ
				pre = CheckPrecode(kword, '-', &ne, PCS.CVer);
				if ( pre < 0 ) continue;

				if ( pre > 0 ){
					kword = ne;
					if ( IsExistCustData(kword) ){
						PCS.Smes = thprintf(PCS.Smes, CMDLINESIZE,
								T("%s: %s")TNL, MessageText(MES_LGDE), kword);
						DeleteCustData(kword);
					}
				}else{						// š` ----------------
					if ( sepC == '=' ){
						p = SkipSpaceAndFix(p);
						if ( *p++ == '{' ){
							while ( mem < memmax ){
								p = GetConfigLine(&PCS, &mem, memmax);
								if ( *p == '\0' ) continue;
								if ( *p == '}' ) break;
							}
						}
						ErrorMes(&PCS, MES_EUKW);
					}else{
						ErrorMes(&PCS, MES_ESEP);
					}
				}
			}
		}
	}
	PCS.Smes = thprintf(PCS.Smes, 4, TNL);
	if ( log != NULL ){
		*log = PCS.SmesBuf;
	}else{
		HeapFree(ProcHeap, 0, PCS.SmesBuf);
	}
	return result ? (PCS.reloadflag | 1) : 0;
}
/*-----------------------------------------------------------------------------
	JX^}CY(o)o͕
-----------------------------------------------------------------------------*/
void CDsub(PPCUSTSTRUCT *PCS, const TCHAR *name, BYTE *bin, int size, DWORD flags, const char *fmt)
{
	BYTE *binend;
											// L[[h/Zp[^\
	CheckSmes(PCS, SMESSIZE_MES); // name + 
	switch (*fmt){
		case '/':
			break;

		case '\0':
		case ':': {
			int i;
			CheckSmes(PCS, size * 2);
			PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s\t:"), name);
			for ( i = 0 ; i < size ; i++ ){
				PCS->Smes = thprintf(PCS->Smes, 4, T("%02x"), bin[i]);
			}
			return;
		}
		default:
			if ( flags & (fK_ExtWild | fK_PathWild) ){ // ChJ[hL
				if ( *name == '/' ) name++;
			}
			PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s\t%c "), name, *fmt);
	}
	fmt++;
	binend = bin + size;
											// p[^\
	while( *fmt ){
		if ( bin >= binend ) break;
		if ( (PCS->Smes + SMESSIZE_MARGIN) >= PCS->SmesLim ) CheckSmes(PCS, 0);
		switch( *fmt++ ){
			// C:F -----------------------------------------------------------
			case 'C':
				PCS->Smes = CD_color(PCS->Smes, *(COLORREF *)bin, flags);
				bin += sizeof(COLORREF);
				break;

			// c:console F ---------------------------------------------------
			case 'c': {
				int c, i;

				c = (int)(*(WORD *)bin);
				bin += 2;
											// OiF -------------------
				for ( i = 0 ; i <= 15 ; i++ ){
					if ( (c & 0x0f) == ConColor[i].num ){
						PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
								T("%s"), ConColor[i].str);
						break;
					}
				}
											// wiF -------------------
				for ( i = 16 ; i <= 31 ; i++ ){
					if ( (c & 0xf0) == ConColor[i].num ){
						PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
								T("+%s"), ConColor[i].str);
						break;
					}
				}
											// ̑ -------------------
				for ( i = 32 ; i <= 35 ; i++ ){
					if ( c & ConColor[i].num ){
						PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
								T("+%s"), ConColor[i].str);
					}
				}
				break;
			}
			// B:2i\-------------------------------------------------------
			case 'B': {
				int bits, i;
				DWORD data;

				bits = GetNumberA(&fmt);
				data = *(DWORD *)bin;
				if ( *(fmt + 1) <= 2 ) data &= 0xffff;
				// wrbg傫lȂrbgg
				while ( -(1 << bits) & data && (bits < 32) ) bits++;
				*PCS->Smes++ = 'B';
				for ( i = 1 ; i <= bits ; i++ ){
					*PCS->Smes++ = (TCHAR)((data & (1 << (bits - i))) ? '1':'0');
				}
				bin += *(fmt + 1) - '0'; // byte
				fmt += 2; // /  byteXLbv
				break;
			}
			// D:10i\----------------------------------------------
			case 'D':
				switch(*fmt++){
					case '1':
						PCS->Smes = Numer32ToString(PCS->Smes, *(BYTE *)bin);
						bin++;
						break;
					case '2':
						PCS->Smes = Numer32ToString(PCS->Smes, *(WORD *)bin);
						bin += 2;
						break;
					case '4':
						PCS->Smes = Numer32ToString(PCS->Smes, *(DWORD *)bin);
						bin += 4;
						break;
				}
				break;
			// D:L10i\----------------------------------------------
			case 'd':
				switch(*fmt++){
					case '1':
						PCS->Smes = Int32ToString(PCS->Smes, *(char *)bin);
						bin++;
						break;
					case '2':
						PCS->Smes = Int32ToString(PCS->Smes, *(short *)bin);
						bin += 2;
						break;
					case '4':
						PCS->Smes = Int32ToString(PCS->Smes, *(long *)bin);
						bin += 4;
						break;
				}
				break;
			// E:(PPC)Gg\-----------------------------------------
			case 'E':
			// CheckSmes
				CD_ppcdisp(PCS, &bin, binend);
				break;

			// V:ID/Version ---------------------------------------------------
			case 'V': {
				size_t smeslen;

				smeslen = StrCpyToSmes(PCS, (TCHAR *)bin);
				bin += TSTROFF(smeslen + 1);
				if ( PCS->Xmode == PPXCUSTMODE_DUMP_ALL ){
					CheckSmes(PCS, 0x200);
					PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE,
#ifdef UNICODE
							 TNL T(";charset=cp1200  "));
#else
							 TNL T(";charset=cp%d    "), GetACP());
#endif
					if ( PCS->comment != DUMP_COMMENT ){
						PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, TNL T("%s"), ConfigTitle);
					}
				}
				break;
			}
			// S:\----------------------------------------------------
			case 'S': {
				size_t binlen = 0, smeslen;

				if ( *fmt == 'D' ) fmt++;
				if ( Isdigit(*fmt) ) binlen = GetNumberA(&fmt);
				// , ؂̂ƂɁA, ܂܂ĂƂ́A" Ŋ
				if ( (*fmt == ',') &&
					 ( (*(TCHAR *)bin == '\"') || (tstrchr((TCHAR *)bin, ',') != NULL)) ){
					smeslen = tstrlen((TCHAR *)bin);
					CheckSmes(PCS, smeslen * 2);
					*PCS->Smes++ = '\"';
					memcpy(PCS->Smes, (TCHAR *)bin, TSTROFF(smeslen + 1) );
					tstrreplace( PCS->Smes, T("\""), T("\"\""));
					PCS->Smes += tstrlen(PCS->Smes);
					*PCS->Smes++ = '\"';
				}else{
					smeslen = StrCpyToSmes(PCS, (TCHAR *)bin);
				}
				bin += binlen ? TSTROFF(binlen) : TSTROFF(smeslen + 1);
				break;
			}
			// s:\----------------------------------------------------
			case 's': {
				TCHAR *last;

				last = (TCHAR *)bin + tstrlen((TCHAR *)bin);
				CheckSmes(PCS, last - (TCHAR *)bin + 1);
				if ( Isdigit(*fmt) ) GetNumberA(&fmt);	// wXLbv
				for ( ; *(TCHAR *)bin != '\0' ; bin += TSTROFF(1) ){
					if ( *(TCHAR *)bin == '\t' ){
						CheckSmes(PCS, last - (TCHAR *)bin + 2);
						*PCS->Smes++ = '\\';
						*PCS->Smes++ = 't';
						continue;
					}
					if ( *(TCHAR *)bin == '\n' ){
						CheckSmes(PCS, last - (TCHAR *)bin + 2);
						*PCS->Smes++ = '\\';
						*PCS->Smes++ = 'n';
						continue;
					}
					*PCS->Smes++ = *(TCHAR *)bin;
				}
				*PCS->Smes = '\0';
				bin += TSTROFF(1);
				break;
			}
			case 'M': {
				TCHAR *nl, *bp;

				fmt = Nilfmt;
				bp = (TCHAR *)bin;
				while( (nl = tstrchr(bp, '\n')) != NULL ){
					*nl = '\0';
					CheckSmes(PCS, nl - bp + 4); // bp \r \n \t \0
					PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s") TNL T("\t"), bp);
					bp = nl + 1;
				}
				bin = (BYTE *)(TCHAR *)(bp + StrCpyToSmes(PCS, bp) + 1);
				break;
			}

			case 'm': {
				TCHAR *bp;
				size_t smeslen;

				fmt = Nilfmt;
				bp = (TCHAR *)bin;
				for (;;){
					smeslen = StrCpyToSmes(PCS, bp);
					bp += smeslen + 1;
					if ( *bp == '\0' ) break;
					PCS->Smes = tstpcpy(PCS->Smes, TNL T("\t"));
				}
				bin = (BYTE *)(TCHAR *)(bp + 1);
				break;
			}
			// k:keys ---------------------------------------------------------
			case 'k':
				if ( *(WORD *)bin ){
					while ( bin < binend ){
						TCHAR buf[100];

						// CheckSmes
						PutKeyCode(buf, *(WORD *)bin);
						PCS->Smes = thprintf(PCS->Smes, TSIZEOF(buf), T("%s"), buf);
						bin += 2;
						if ( *(WORD *)bin == 0 ) break;
						*PCS->Smes++ = ' ';
					}
				}
				bin += 2;
				break;
			// K:key ----------------------------------------------------------
			case 'K':
				PutKeyCode(PCS->Smes, *(WORD *)bin);
				PCS->Smes += tstrlen(PCS->Smes);
				bin += 2;
				break;
			// X:Exec/keys ----------------------------------------------------
			case 'X':
				if ( flags & fK_ExtWild ){ // ChJ[hL
					if ( *name == '/' ) name++;
				}

				if ( *bin == EXTCMD_CMD ){
					bin += TSTROFF(1);
					PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s\t,"), name);
					fmt = "M";
					continue;
				}else{
					if ( *bin == EXTCMD_KEY ) bin += TSTROFF(1);
					PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s\t= "), name);
					fmt = "k";
					continue;
				}
			case 'x':
				if ( *bin == EXTCMD_CMD ){
					bin += TSTROFF(1);
					PCS->Smes = tstpcpy(PCS->Smes, T(" , "));
					fmt = "S";
					continue;
				}else{
					if ( *bin == EXTCMD_KEY ) bin += TSTROFF(1);
					PCS->Smes = tstpcpy(PCS->Smes, T(" = "));
					fmt = "k";
					continue;
				}
			case ',':
				if ( *fmt == ',' ) fmt++;
			// ?:̂܂ܕ\--------------------------------------------------
			default:
				*PCS->Smes++ = *(fmt - 1);
				break;
		}
	}
}
/*-----------------------------------------------------------------------------
	JX^}CY(o)ڏ
-----------------------------------------------------------------------------*/
void AddCommentText(PPCUSTSTRUCT *PCS, const TCHAR *comment, const TCHAR *tail)
{
	TCHAR *Smes, *SmesLim;

	if ( PCS->comment != DUMP_COMMENT ) comment = NilStr;
	SmesLim = PCS->SmesLim;
	Smes = PCS->Smes;
	for (;;){
		TCHAR c;

		c = *comment;
		if ( c != '\0' ){
			*Smes++ = c;
			comment++;
			if ( (Smes + SMESSIZE_MARGIN) < SmesLim ) continue;
			PCS->Smes = Smes;
			CheckSmes(PCS, 0);
			SmesLim = PCS->SmesLim;
			Smes = PCS->Smes;
		} else { // c == '\0'
			if ( tail == NULL ) break;
			comment = tail;
			tail = NULL;
		}
	}
	*Smes = '\0';
	PCS->Smes = Smes;
}

#pragma warning(suppress:6262) // X^bNgA݂͖
void CDitem(PPCUSTSTRUCT *PCS, const CLABEL *clbl)
{
	TCHAR sname[CUST_NAME_LENGTH];
	BYTE bin[MAXCUSTDATA];
	int datasize;

	datasize = GetCustDataSize(clbl->name);
	if ( datasize < 0 ){							// o^ ---------
		if ( clbl->flags & (fInternal | fHide | fOld) ) return; // oȂ
		if ( !(clbl->flags & fT) ){		// P
			PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s\t= "), clbl->name);
			AddCommentText(PCS, clbl->comment, TNL);
		}else{							// z
			sname[0] = '\0';
			GetCustTable(T("#Comment"), clbl->name, sname, TSTROFF(MAX_PATH));
			sname[MAX_PATH - 1] = '\0';
			if ( (sname[0] == '\0') && (*clbl->comment == '\0') ){
				tstrcpy(sname, DefCommentStr);
			}
			PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s\t= {%s"), clbl->name, sname);
			AddCommentText(PCS, clbl->comment, TNL T("}") TNL );
		}
	}else{											// o^ς -------
		if ( (clbl->flags & fInternal) &&
			 !(PCS->ModeFlags & PPXCUSTMODE_DUMP_DISCOVER) ){
			return;	 // oȂ
		}

		if ( !(clbl->flags & fT) ){		// P
			GetCustData(clbl->name, bin, sizeof(bin));
			CDsub(PCS, clbl->name, bin, datasize, clbl->flags, clbl->fmt);
			AddCommentText(PCS, clbl->comment, TNL);
		}else{							// z
			int scnt;

			scnt = 0;
			sname[0] = '\0';
			GetCustTable(T("#Comment"), clbl->name, sname, TSTROFF(MAX_PATH));
			sname[MAX_PATH - 1] = '\0';
			if ( (sname[0] == '\0') && (*clbl->comment == '\0') ){
				tstrcpy(sname, DefCommentStr);
			}
			PCS->Smes = thprintf(PCS->Smes, CMDLINESIZE, T("%s\t= {%s"), clbl->name, sname);
			AddCommentText(PCS, clbl->comment, TNL);
			for ( ; ; ){
				int size;

				size = EnumCustTable(scnt, clbl->name, sname, bin, sizeof(bin));
				if ( 0 > size ) break;
				CDsub(PCS, sname, bin, size, clbl->flags, clbl->fmt);
				PCS->Smes = tstpcpy(PCS->Smes, TNL);
				scnt++;
			}
			PCS->Smes = tstpcpy(PCS->Smes, T("}")TNL);
		}
	}
}

void MakeUserCustNames(USERCUSTNAMES *ucndata)
{
	USERCUSTNAMES *ucn;
	BYTE bin[4]; // gȂ̂ōŏ
	TCHAR name[CUST_NAME_LENGTH];

	int count = 0;
	const CLABEL *lbl;

	ucn = ucndata;

	ThInit(&ucn->UsersIndex);
	ThInit(&ucn->UsersNames);

	for ( ; ; ){
		if ( EnumCustData(count++, name, bin, 0) < 0 ) break;
		if ( memcmp(name, T("Mes"), TSTROFF(3)) &&
			((name[1] != '_') ||
			 !((name[0] == 'M') || (name[0] == 'E') || (name[0] == 'S') ||
			   (name[0] == 'B') || (name[0] == 'K')) ) ){
			continue;
		}
		lbl = Ctbl;
		while( lbl->name ){
			if ( !tstricmp(name, lbl->name) ) break;
			lbl++;
		}
		if ( lbl->name == NULL ){
			DWORD offset;
			DWORD *index;
			DWORD mini, maxi, midi, indexmax;

			offset = ucn->UsersNames.top;
			ThAddString(&ucn->UsersNames, name);
			ThAppend(&ucn->UsersIndex, &offset, sizeof(offset));
			index = POINTERCAST(DWORD *, ucn->UsersIndex.bottom);

			mini = midi = 0;
			maxi = indexmax = (ucn->UsersIndex.top / sizeof(DWORD)) - 1;
			while ( mini < maxi ){ // oCiT[`Ō
				int result;

				midi = (mini + maxi) / 2;
				result = tstricmp(name,
					(TCHAR *)(BYTE *)(ucn->UsersNames.bottom + *(index + midi)));
				if ( result < 0 ){
					maxi = midi;
				}else{
					midi++;
					if ( result > 0 ){
						mini = midi;
					}else{
						break;
					}
				}
			}
			if ( midi < indexmax ){
				index += midi;
				memmove(index + 1, index, (indexmax - midi) * sizeof(DWORD));
				*index = offset;
			}
		}
	}
	ucn->UsersIndexMin = POINTERCAST(DWORD *, ucn->UsersIndex.bottom);
	ucn->UsersIndexMax = ucn->UsersIndexMin + (ucn->UsersIndex.top / sizeof(DWORD));
/*
		{
			DWORD usercount, *index;
			usercount = ucn->UsersIndex.top / sizeof(DWORD);
			index = POINTERCAST(DWORD *, ucn->UsersIndex.bottom);
			XMessage(NULL, NULL, XM_DbgLOG, T("count %d"), usercount);
			while ( usercount-- ){
				XMessage(NULL, NULL, XM_DbgLOG, T("X: %s"), (TCHAR *)(BYTE *)(ucn->UsersNames.bottom + *index));
				index++;

			}
		}
*/
}

/*-----------------------------------------------------------------------------
	JX^}CY(o){
-----------------------------------------------------------------------------*/
void DumpUserCusts(PPCUSTSTRUCT *PCS, USERCUSTNAMES *ucndata, const CLABEL *clbl, const TCHAR *chars)
{
	DWORD *index;
	TCHAR *name, char1, char2;
	USERCUSTNAMES *ucn;
	CLABEL clblbuf = *clbl;

	char1 = chars[0];
	char2 = chars[1];
	ucn = ucndata;
	for ( index = ucn->UsersIndexMin; index < ucn->UsersIndexMax ; index++ ){
		name = (TCHAR *)(BYTE *)(ucn->UsersNames.bottom + *index);
		if ( (name[0] != char1) || (name[1] != char2) ) continue;
		clblbuf.name = name;
		CDitem(PCS, &clblbuf);
	}
}

#pragma warning(suppress:6262) // X^bNgA݂͖
TCHAR * PPcustCDumpMain(int ModeFlags)
{
	PPCUSTSTRUCT PCS;
	BYTE bin[MAXCUSTDATA];
	const CLABEL *clbl;
	int count, size;
	TCHAR name[CUST_NAME_LENGTH];
	USERCUSTNAMES ucn;

	PCS.Smes = PCS.SmesBuf = HeapAlloc(ProcHeap, 0, FIRSTDUMPSIZE + SMESSIZE_MARGIN);
	PCS.SmesLim = PCS.Smes + FIRSTDUMPSIZE / sizeof(TCHAR);
	PCS.Dnum = 0;
	PCS.Xmode = PPXCUSTMODE_DUMP_ALL;
#ifdef UNICODE
	*PCS.Smes++ = 0xfeff;	// UCF2HEADER ݒ
#endif
	PCS.ModeFlags = ModeFlags;
	PCS.comment = (ModeFlags & PPXCUSTMODE_DUMP_NO_COMMENT) ? 0 : DUMP_COMMENT;

	MakeUserCustNames(&ucn);
//--------------------------------------------------------- `ςݓȅo
	clbl = Ctbl;
	while ( clbl->name ){
		switch ( *clbl->name ){
			case 0:						// Comment ----------------------------
				if ( PCS.comment == DUMP_COMMENT ){
					AddCommentText(&PCS, clbl->comment, TNL);
				}
				break;

			case fUser_Menu:			// [Uj[ ---------------------
				DumpUserCusts(&PCS, &ucn, &usermenu, T("M_"));
				break;

			case fUser_Ext:				// [Ut@C -----------------
				DumpUserCusts(&PCS, &ucn, &userext, T("E_"));
				break;

			case fUser_Lang:			//  ---------------------------
				DumpUserCusts(&PCS, &ucn, &usermes, T("Me"));
				break;

			case fUser_Bar:				// c[o[ -----------------
				DumpUserCusts(&PCS, &ucn, &userbar, T("B_"));
				break;

			case fUser_Key:				// L[ -----------------
				DumpUserCusts(&PCS, &ucn, &userkey, T("K_"));
				break;

			case fUser_Settings:		// CӐݒ -----------------
				DumpUserCusts(&PCS, &ucn, &usersettings, T("S_"));
				break;

			default:					// { -------------------------------
				if ( (clbl->flags & fSort) && !(ModeFlags & PPXCUSTMODE_DUMP_NO_SORT) ){
					SortCustTable(clbl->name, NULL);
				}
				CDitem(&PCS, clbl);
		}
		clbl++;
	}
//--------------------------------------------------------- `ȅo
	if ( ModeFlags & PPXCUSTMODE_DUMP_DISCOVER ) for ( count = 0 ; ; count++ ){
		size = EnumCustData(count, name, bin, 0);
		if ( size < 0 ) break;

		if ( name[1] == '_' ){
			if ( (name[0] == 'M') || (name[0] == 'E') || (name[0] == 'B') || (name[0] == 'K') || (name[0] == 'S') ){
				continue;
			}
		}
		if ( !memcmp(name, T("Mes"), TSTROFF(3)) ) continue;

		clbl = Ctbl;
		while( clbl->name ){
			if ( !tstricmp(name, clbl->name) ) break;
			clbl++;
		}
		if ( clbl->name == NULL ){
			CDsub(&PCS, name, bin, size, clbl->flags, clbl->fmt);
			PCS.Smes = tstpcpy(PCS.Smes, TNL);
		}
	}
	*PCS.Smes = '\0';
	return PCS.SmesBuf;
}

PPXDLL TCHAR * PPXAPI PPcustCDump(void)
{
	return PPcustCDumpMain(PPXCUSTMODE_DUMP_ALL);
}

#pragma warning(suppress:6262) // X^bNgA݂͖
void PPcustCDumpPart(PPCUSTSTRUCT *PCS, const TCHAR *str, const TCHAR *sub, BOOL idname)
{
	const CLABEL *clbl = NULL;
	BYTE bin[MAXCUSTDATA];
	int size;

	if ( str[1] == '_' ){
		switch ( str[0] ){
			case 'M': // [Uj[ -------
				clbl = &usermenu;
				break;

			case 'S': // [UXg -------
				clbl = &usersettings;
				break;

			case 'K': // [UL[ -------
				clbl = &userkey;
				break;

			case 'E': // [Ut@C -------
				clbl = &userext;
				break;

			case 'B': // c[o[ -------
				clbl = &userbar;
				break;
		}
	}else if ( !memcmp(str, T("Mes"), TSTROFF(3)) ){
		clbl = &usermes;
	}
	if ( clbl == NULL ){ // `ς
		clbl = Ctbl;
		for (;;){
			if ( !tstricmp(clbl->name, str) ) break;
			clbl++;
			if ( clbl->name != NULL ) continue;
			clbl = NULL;
			break;
		}
	}
	if ( clbl != NULL ){
		if ( sub == NULL ){
			if ( clbl->flags & fT ){ // zS
				CLABEL clblbuf = *clbl;

				clblbuf.name = str;
				CDitem(PCS, &clblbuf);
			}else{ // P
				size = GetCustDataSize(str);
				if ( size > 0 ){
					GetCustData(str, bin, sizeof(bin));
					CDsub(PCS, idname ? str : NilStr, bin, size, clbl->flags, clbl->fmt);
				}
			}
		}else{					// z񍀖
			size = GetCustTableSize(str, sub);
			if ( size > 0 ){
				GetCustTable(str, sub, bin, sizeof(bin));
				CDsub(PCS, idname ? str : NilStr, bin, size, clbl->flags, clbl->fmt);
			}
		}
	}
}

void PPcustCDumpWildCard(PPCUSTSTRUCT *PCS, const TCHAR *wildcard)
{
	FN_REGEXP fn;
	int count, size;
	TCHAR name[CUST_NAME_LENGTH];
	BYTE bin[4]; // gȂ̂ōŏ

	if ( PCS->comment & PPXCUSTMODE_DUMP_NO_COMMENT ) PCS->comment = 0;
	PCS->comment = LOWORD(PCS->comment);

	MakeFN_REGEXP(&fn, wildcard);
	for( count = 0 ; ; count++ ){
		size = EnumCustData(count, name, bin, 0);
		if ( size < 0 ) break;
		if ( FilenameRegularExpression(name, &fn) ){
			PPcustCDumpPart(PCS, name, NULL, TRUE);
			PCS->Smes = tstpcpy(PCS->Smes, TNL);
		}
	}
	FreeFN_REGEXP(&fn);
}

void PPcustCDumpText(const TCHAR *str, const TCHAR *sub, TCHAR **result)
{
	PPCUSTSTRUCT PCS;

	PCS.Smes = PCS.SmesBuf = *result;
	PCS.SmesLim = PCS.Smes + CMDLINESIZE - SMESSIZE_MARGIN;
	PCS.ModeFlags = PPXCUSTMODE_DUMP_NO_COMMENT;
	PCS.comment = 0;
	PCS.Dnum = 0;
	PCS.Xmode = PPXCUSTMODE_DUMP_PART;
	*PCS.Smes = '\0';

	if ( *str == '#' ){
		PPcustCDumpWildCard(&PCS, str + 1);
	}else{
		PPcustCDumpPart(&PCS, str, sub, FALSE);
	}
	*PCS.Smes = '\0';
	*result = PCS.SmesBuf;
}

PPXDLL TCHAR * PPXAPI PPcust(int ModeFlags, const TCHAR *param)
{
	PPCUSTSTRUCT PCS;

	if ( ModeFlags & B31 ) ModeFlags = LOWORD(ModeFlags); // ݊mۗp
	if ( LOWORD(GetUserDefaultLCID()) != LCID_JAPANESE ){ // {ȊO̓Rg
		if ( ModeFlags & PPXCUSTMODE_DUMP_NO_COMMENT ){
			setflag(ModeFlags, PPXCUSTMODE_DUMP_NO_COMMENT | PPXCUSTMODE_DUMP_TITLE);
		}
	}

	switch ( LOWORD(ModeFlags) ){
		case PPXCUSTMODE_DUMP_ALL:
			return PPcustCDumpMain(ModeFlags);

		case PPXCUSTMODE_DUMP_PART:
		case PPXCUSTMODE_DUMP_PART_NOBOM: {
			PCS.comment = (ModeFlags & PPXCUSTMODE_DUMP_NO_COMMENT) ? 0 : DUMP_COMMENT;
			PCS.Dnum = 0;
			PCS.ModeFlags = ModeFlags;

			PCS.Smes = PCS.SmesBuf = HeapAlloc(ProcHeap, 0, FIRSTDUMPSIZE + SMESSIZE_MARGIN);
			PCS.SmesLim = PCS.Smes + FIRSTDUMPSIZE / sizeof(TCHAR);
			PCS.Xmode = PPXCUSTMODE_DUMP_PART;
#ifdef UNICODE
			if ( LOWORD(ModeFlags) == PPXCUSTMODE_DUMP_PART ){
				*PCS.Smes++ = 0xfeff;	// UCF2HEADER ݒ
			}
#endif
			*PCS.Smes = '\0';

			PPcustCDumpWildCard(&PCS, param);
			return PCS.SmesBuf;
		}

		default:
			return NULL;
	}
}
