/*-----------------------------------------------------------------------------
	Paper Plane xUI	 commom library						}Ns
-----------------------------------------------------------------------------*/
#define ONPPXDLL		// PPCOMMON.H  DLL `w
#include "WINAPI.H"
#include <shlobj.h>
#include "PPX.H"
#include "VFS.H"
#include "VFS_STRU.H"
#include "PPCOMMON.RH"
#include "PPD_DEF.H"
#include "CALC.H"
#pragma hdrstop
#define DEFCMDNAME
#include "PPXCMDS.C"

#define ISCMDNULREQUEIERSIZE TSTROFF(2)

#ifndef SC_MONITORPOWER
#define SC_MONITORPOWER 0xF170
#endif

BOOL EditExtractText(EXECSTRUCT *Z);
void EnumEntries(EXECSTRUCT *Z);
void ZInitSentence(EXECSTRUCT *Z);
void Freeoldsrc(EXECSTRUCT *Z);

#define ZMC_BREAK	FALSE
#define ZMC_CONTINUE	TRUE
BOOL ZMacroCharacter(EXECSTRUCT *Z);

#define HistType_GENERAL 0 // g 
#define HistType_PATHFIX 5 // f 

const TCHAR ExecuteDefaultTitle[] = MES_TEXE;
const TCHAR Title_ValueName[] = T(StringVariable_Command_Title);
const TCHAR ResponseName_ValueName[] = T(StringVariable_Command_Response);

#define GetDestOffset(Z) (((Z)->ExtendDst.top / sizeof(TCHAR)) + ((Z)->dst - (Z)->DstBuf))

#ifndef GW_ENABLEDPOPUP
#define GW_ENABLEDPOPUP 6
#endif

typedef struct {
	HWND hFoundWnd;
	const TCHAR *caption;
} SEARCHWINDOW;

void CmdSkip(EXECSTRUCT *Z) // *skip
{
	for (;;){
		TCHAR chr;
		chr = *Z->src;
		if ( chr == '\0' ) break;
		if ( ((chr == '\n') || (chr == '\r')) && !(Z->flags & XEO_INRETURN) ){
			do {
				Z->src++;
			} while ( (*Z->src == '\n') || (*Z->src == '\r') );
			ZInitSentence(Z);
			return;
		}
		Z->src++;
	}
	Z->command = CID_FILE_EXEC;
}

TCHAR *SearchLabel(const TCHAR *text, const TCHAR *key, size_t keylen)
{
	TCHAR *ptr, chr;

	for (;;){
		ptr = tstrstr(text, key);
		if ( ptr != NULL ){
			chr = ptr[keylen];
			if ( ((UTCHAR)chr <= ' ') || (chr == '%') ) break;
			text = ptr + keylen;
			continue;
		}else{
			break;
		}
	}
	return ptr;
}

BOOL CmdGoto(EXECSTRUCT *Z, const TCHAR *param) // *goto
{
	TCHAR *ptr;
	size_t keylen;

	ZInitSentence(Z);
	if ( GetAsyncKeyState(VK_PAUSE) & KEYSTATE_FULLPUSH ){ // f`FbN
		if ( PMessageBox(Z->hWnd, MES_AbortCheck, NULL, MB_QYES) == IDOK ){
			BreakAction(Z);
			return FALSE;
		}
	}

	SkipSpace(&Z->src);
	ptr = Z->dst + 2;
	for (;;){
		TCHAR chr;

		chr = *Z->src;
		if ( ((UTCHAR)chr <= ' ') || (chr == '%') ) break;
		*ptr++ = chr;
		Z->src++;
		if ( ptr > (Z->dst + 128) ) break;
	}
	keylen = ptr - Z->dst;
	*ptr = '\0';
	if ( Z->dst[2] == '\0' ){
		Z->dst[0] = '\0';
	}else{
		Z->dst[0] = '%';
		Z->dst[1] = 'm';
	}
	ptr = SearchLabel(Z->src, Z->dst, keylen); // ݂ src őO
	if ( ptr != NULL ){
		Z->src = ptr;
		return TRUE;
	}

	if ( Z->oldsrc != NULL ){ // } src Ō
		ptr = SearchLabel((TCHAR *)(&Z->oldsrc[1]), Z->dst, keylen);
		if ( ptr != NULL ){
			Z->src = ptr;
			return TRUE;
		}
	}

	ptr = SearchLabel(param, Z->dst, keylen); // R}hCŌ
	if ( ptr != NULL ){
		Z->src = ptr;
		Freeoldsrc(Z);
		return TRUE;
	}
	XMessage(NULL, NULL, XM_GrERRld, T("*goto: %s not found."), Z->dst);
	Z->result = ERROR_INVALID_PARAMETER;
	return FALSE;
}

PPXDLL WORD PPXAPI GetHistoryType(const TCHAR **param)
{
	const TCHAR *ptr;
	WORD historytype = 0;

	for ( ;; ){
		TCHAR code;

		code = **param;
		if (((UTCHAR)code < 'a') ||((ptr = tstrchr(HistTypes, code)) == NULL)){
			return historytype;
		}
		historytype |= HistWriteTypeflag[ptr - HistTypes];
		(*param)++;
	}
}

// "  "" ɉH(DstBufp)
void ZQuotationDoubler_Buf(EXECSTRUCT *Z)
{
	TCHAR *src_q;
	DWORD top, count; // u"v̐
	int dstlen;

	src_q = tstrchr(Z->dst, '\"');
	if ( src_q == NULL ) return;

	// " ɂۑ̈̑Zo
	count = 1;
	for (;;){
		src_q = tstrchr(src_q + 1, '\"');
		if ( src_q == NULL ) break;
		count++;
	}
	dstlen = tstrlen(Z->dst);
	if ( Z->dst != Z->DstBuf ){ // Z->DstBuf ɔ[܂邩mF
		if ( (Z->dst + dstlen + count) <= (Z->DstBuf + CMDLINESIZE - 2) ){
			tstrreplace(Z->dst, T("\""), T("\"\""));
			return;
		}
	}
	Z->dst += dstlen;

	// ExtendDst gł邩mF
	if ( StoreLongParam(Z, 0) == FALSE ){
		Z->result = RPC_S_STRING_TOO_LONG;
		return;
	}

	top = Z->ExtendDst.top;
	if ( ThSize(&Z->ExtendDst, (count + 1) * sizeof(TCHAR) ) == FALSE ){
		Z->result = RPC_S_STRING_TOO_LONG;
		return;
	}

	// g
	tstrreplace(ThPointerT(&Z->ExtendDst, top) - dstlen, T("\""), T("\"\""));
	Z->ExtendDst.top += count * sizeof(TCHAR);
}

// "  "" ɉH(ExtendDst p)
void ZQuotationDoubler_Ext(EXECSTRUCT *Z)
{
	TCHAR *src, *src_q;
	DWORD top, count; // u"v̐
	int dstlen;

	top = Z->ExtendDst.top;
	src = ThPointerT(&Z->ExtendDst, top);
	dstlen = tstrlen(src);

	if ( !Z->func.quotation ){
		Z->ExtendDst.top += dstlen * sizeof(TCHAR);
		return;
	}

	src_q = tstrchr(src, '\"');
	if ( src_q == NULL ){
		Z->ExtendDst.top += dstlen * sizeof(TCHAR);
		return;
	}

	// " ɂۑ̈̑Zo
	count = 1;
	for (;;){
		src_q = tstrchr(src_q + 1, '\"');
		if ( src_q == NULL ) break;
		count++;
	}

	// ExtendDst gł邩mF
	if ( ThSize(&Z->ExtendDst, (dstlen + count + 1) * sizeof(TCHAR) ) == FALSE ){
		Z->result = RPC_S_STRING_TOO_LONG;
		return;
	}

	// g
	tstrreplace(ThPointerT(&Z->ExtendDst, top), T("\""), T("\"\""));
	Z->ExtendDst.top += (dstlen + count) * sizeof(TCHAR);
}

void SetLongDestMain(EXECSTRUCT *Z, const TCHAR *text, int length)
{
	if ( IsTrue(StoreLongParam(Z, length)) ){
		if ( Z->func.quotation ){
			DWORD oldtop;

			oldtop = Z->ExtendDst.top;
			ThCatString(&Z->ExtendDst, text);
			Z->ExtendDst.top = oldtop;;
			ZQuotationDoubler_Ext(Z);
		}else{
			ThCatString(&Z->ExtendDst, text);
		}
	}else{
		Z->result = RPC_S_STRING_TOO_LONG;
	}
}

void SetLongDest(EXECSTRUCT *Z, const TCHAR *text, int length)
{
	if ( length < 0 ) length = tstrlen(text);

	if ( length < CMDLINESIZE ){
		if ( !Z->func.quotation ){
			Z->dst = tstpcpy(Z->dst, text);
		}else{
			tstrcpy(Z->dst, text);
			ZQuotationDoubler_Buf(Z);
			Z->dst += tstrlen(Z->dst);
		}
	}else{
		SetLongDestMain(Z, text, length);
	}
}

/*-----------------------------------------------------------------------------
	p[^֐̒`
-----------------------------------------------------------------------------*/
PPXDLL void PPXAPI PPxRegGetIInfo(PPXAPPINFO *ptr)
{
	PPxDefAppInfo = ptr;
	if ( ptr != NULL ){
		PPxDefInfo.Name = ptr->Name;
		PPxDefInfo.RegID = ptr->RegID;
		PPxDefInfo.hWnd = ptr->hWnd;
	}
}
#pragma argsused
DWORD_PTR USECDECL PPxDefInfoFunc(PPXAPPINFO *ppxa, DWORD cmdID, PPXAPPINFOUNION *uptr)
{
	if ( PPxDefAppInfo != NULL ){
		DWORD_PTR result = PPxDefAppInfo->Function(PPxDefAppInfo, cmdID, uptr);
		if ( result != PPXA_INVALID_FUNCTION ) return result;
	}

	switch (cmdID){
		case '0': {	// gւ̃pX
			TCHAR *p;

			GetModuleFileName(NULL, uptr->enums.buffer, MAX_PATH);
			p = FindLastEntryPoint(uptr->enums.buffer);
			*p = '\0';
			return PPXA_NO_ERROR;
		}

		case '1':
			GetCurrentDirectory(VFPS, uptr->enums.buffer);
			return PPXA_NO_ERROR;
	}

	if ( cmdID <= PPXCMDID_FILL ) *uptr->enums.buffer = '\0';
	return PPXA_INVALID_FUNCTION;
}
//-----------------------------------------------------------------------------
BOOL GetEditMode(const TCHAR **param, TINPUT_EDIT_OPTIONS *options)
{
	const TCHAR *ptr;
	TCHAR chr;
	WORD rhistflags = 0;

	// _CAO
	options->flags = 0;
	switch ( **param ){ // HistTypes Ƃ̏Փ˂ɒ
		case 'R':
			options->flags = TINPUT_EDIT_OPTIONS_use_refline;
			(*param)++;
			break;

		case 'O':
			options->flags = TINPUT_EDIT_OPTIONS_use_optionbutton;
			(*param)++;
			break;

		case 'E':
			options->flags = TINPUT_EDIT_OPTIONS_use_refext;
			(*param)++;
			break;
	}
	if ( **param == 'S' ){
		setflag(options->flags, TINPUT_EDIT_OPTIONS_single_param);
		(*param)++;
	}

	// ݃qXg
	ptr = tstrchr(HistTypes, **param);
	if ( (ptr == NULL) || (*ptr == '\0') ){
		PPErrorBox(NULL, NULL, ERROR_INVALID_PARAMETER);
		return FALSE;
	}
	//  %eg ̏ꍇ́A0 c w薳ɂȂ
	options->hist_writetype = (BYTE)(ptr - HistTypes);
	(*param)++;


	// ǂݍ݃qXg
	chr = SkipSpace(param);
	if ( chr != ',' ){ // w薳
		if ( !Isalpha(chr) ){
			rhistflags = HistReadTypeflag[ptr - HistTypes];
		}else{
			PPErrorBox(NULL, NULL, ERROR_INVALID_PARAMETER);
			return FALSE;
		}
	}else{
		for ( ;; ){
			(*param)++;
			ptr = tstrchr(HistTypes, **param);
			if ( (ptr == NULL) || (*ptr == '\0') ) break;
			setflag(rhistflags, HistWriteTypeflag[ptr - HistTypes]);
		}
	}
	options->hist_readflags = rhistflags;
	return TRUE;
}

void SetEditMode(EXECSTRUCT *Z)
{
	resetflag(Z->status, ST_EDITHIST);
	if ( IsTrue(GetEditMode(&Z->src, &Z->edit.options)) ){
		setflag(Z->status, ST_EDITHIST);
	}else{
		Z->result = ERROR_INVALID_PARAMETER;
	}
}

void SetTInputOptionFlags(TINPUT *tinput, TINPUT_EDIT_OPTIONS *options)
{
	if ( options->flags & TINPUT_EDIT_OPTIONS_UI_mask ){
		if ( options->flags & TINPUT_EDIT_OPTIONS_use_optionbutton ){
			setflag(tinput->flag, TIEX_USEOPTBTN);
		}else{ // use_refline / use_refext
			if ( options->flags & TINPUT_EDIT_OPTIONS_use_refext ){
				setflag(tinput->flag, TIEX_REFEXT);
			}
			setflag(tinput->flag, TIEX_USEREFLINE);
		}
	}
	if ( options->flags & TINPUT_EDIT_OPTIONS_single_param ){
		setflag(tinput->flag, TIEX_SINGLEREF);
	}
}

void LineEscape_charcode(EXECSTRUCT *Z, INT_PTR code)
{
	if ( code == 0 ) return;

#ifdef UNICODE
	if ( code < 0x10000 ){
		*Z->dst++ = (WORD)code;
	}else{
		*Z->dst++ = (WORD)(DWORD)((code >> 10) + (0xd800 - (0x10000 >> 10)));
		*Z->dst++ = (WORD)(DWORD)((code & 0x3ff) | 0xdc00);
	}
#else
	*Z->dst++ = (char)(unsigned char)code;
#endif
	if ( *Z->src == ';' ) Z->src++;
}

void LineEscape(EXECSTRUCT *Z) // %b sGXP[vE}
{
	TCHAR c;

	c = *Z->src;
	switch ( c ){
		case '\r':
		case '\n':
			for (;;){
				*Z->dst++ = c;
				c = *(++Z->src);
				if ( (c != '\r') && (c != '\n') ) break;
			}
			break;

		case 'n':
			*Z->dst++ = '\r';
		case 'l':
			*Z->dst++ = '\n';
			Z->src++;
			break;

		case 'r':
			*Z->dst++ = '\r';
			Z->src++;
			break;

		case 't':
			Z->src++;
			*Z->dst++ = '\t';
			break;

		case 'h':
		case 'x':
			Z->src++;
			LineEscape_charcode(Z, GetHexNumber(&Z->src));
			break;
#if 0
		case '\"':
			*Z->dst++ = '\"';
		case '@':
			if ( Z->flags & XEO_INRETURN ) {
				setflag(Z->flags, XEO_INRETURN);
			}else{
				resetflag(Z->flags, XEO_INRETURN);
			}
			Z->src++;
			break;

		case '\'':
			Z->src++;
			for (;;){
				c = *Z->src;
				if ( c == '\0' ) break;
				if ( (c == '%') && (Z->src[1] == 'b') && (Z->src[2] == '\'')){
					Z->src += 3;
					break;
				}
				*Z->dst++ = c;
				Z->src++;

				if ( (Z->dst - Z->DstBuf) >= (CMDLINESIZE - 1) ){ // 
					if ( StoreLongParam(Z, 0) == FALSE ){
						Z->result = RPC_S_STRING_TOO_LONG;
						break;
					}
				}
			}
			break;
#endif
		default:
			LineEscape_charcode(Z, GetNumber(&Z->src));
			break;
	}
}

// extract Ɍʂۑ
void SetLongParamToParam(EXECSTRUCT *Z, LONGEXTRACTPARAM *extract)
{
	if ( (Z->flags & XEO_EXTRACTLONG) &&
		 (extract->longtext.id == extract) ){ // ۑ\
		ThCatString(&Z->ExtendDst, Z->DstBuf);
		extract->longtext.th = Z->ExtendDst;
		Z->ExtendDst.bottom = NULL; // Ăяoŉ
		Z->result = ERROR_PARTIAL_COPY;
	}else{ // ۑłȂ̂Ő擪B
		Z->result = RPC_S_STRING_TOO_LONG;
		tstplimcpy(extract->text, (Z->ExtendDst.top != 0) ?
				(TCHAR *)Z->ExtendDst.bottom : Z->DstBuf, CMDLINESIZE);
	}
}

void ZErrorFix(EXECSTRUCT *Z)
{
	if ( Z->extract == NULL ) return;
	if ( Z->result != ERROR_EX_RETURN ){
		*Z->extract = '\0';
		return;
	}
	if ( (Z->ExtendDst.top != 0) ||
		 ((Z->dst - Z->DstBuf) >= (CMDLINESIZE - 1)) ){ // 
		SetLongParamToParam(Z, (LONGEXTRACTPARAM *)Z->extract);
	}else{
		tstrcpy(Z->extract, Z->DstBuf);
	}
}

BOOL USEFASTCALL ZExecAndCheckError(EXECSTRUCT *Z) // %&
{
	setflag(Z->flags, XEO_SEQUENTIAL);
	if ( Z->flags & XEO_DISPONLY ){		// \̂
		*Z->dst++ = ':';
		return ZMC_CONTINUE;
	}				// s
	ZExec(Z);
	if ( Z->result != NO_ERROR ){
		ZErrorFix(Z); // *return xxx %& ͑ΉĂȂ
		return ZMC_BREAK;
	}
	if ( Z->ExitCode != 0 ){
		Z->result = ERROR_CANCELLED;
		return ZMC_BREAK;
	}
	ZInitSentence(Z);
	return ZMC_CONTINUE;
}

void USEFASTCALL ZStringOnDir(EXECSTRUCT *Z) // %S
{
	if ( !(Z->status & ST_CHKSDIRREF) ){ // ĂȂȂ炱ŁB
		if ( PPxEnumInfoFunc(Z->Info, PPXCMDID_ENUMATTR, Z->dst, &Z->EnumInfo) &&
			(*(DWORD *)Z->dst & FILE_ATTRIBUTE_DIRECTORY) ){
			setflag(Z->status, ST_SDIRREF | ST_CHKSDIRREF);
		}else{
			setflag(Z->status, ST_CHKSDIRREF);
		}
	}

	if ( SkipSpace(&Z->src) == '\"' ) Z->src++;
	while ( *Z->src && (*Z->src != '\"') ){
		if ( Z->status & ST_SDIRREF ){ // TufBNgƂ
			*Z->dst++ = *Z->src++;
		}else{
			Z->src++;
		}
	}
	if ( *Z->src == '\"' ) Z->src++;
}

void USEFASTCALL ZAddSeparator(EXECSTRUCT *Z){	// "%\"
	TCHAR *buftop;
	UTCHAR c;

	setflag(Z->status, ST_PATHITEM);
	buftop = Z->DstBuf;
#ifndef UNICODE
	if ( (Z->command >= CID_USERNAME) || (Z->func.off != 0) ){
		buftop = Z->dst;
		while ( buftop > Z->DstBuf ){
			if ( *(buftop - 1) == '\0' ) break;
			buftop--;
		}
	}
#endif
	if ( Z->dst > buftop ){
		c = (UTCHAR)*(Z->dst - 1);
#ifndef UNICODE
		if ( (c  > ' ') && (c != '\"') ){
			CatPath(NULL, buftop, NilStr);
			Z->dst += tstrlen(Z->dst);
		}
		return;
#endif
	}else if ( Z->ExtendDst.top > 0 ){
		c = (UTCHAR)*(TCHAR *)(ThStrLastT(&Z->ExtendDst) - 1);
#ifndef UNICODE
		if ( (c  > ' ') && (c != '\"') ){
			if ( ThSize(&Z->ExtendDst, 1 * sizeof(TCHAR) ) == FALSE ){
				Z->result = RPC_S_STRING_TOO_LONG;
				return;
			}
			CatPath(NULL, (TCHAR *)Z->ExtendDst.bottom , NilStr);
			if ( (UTCHAR)*(TCHAR *)(ThStrLastT(&Z->ExtendDst) - 1) != '\0' ){
				Z->ExtendDst.top += sizeof(TCHAR);
			}
		}
		return;
#endif
	}else{
		return;
	}
#ifdef UNICODE
	if ( (c  > ' ') && (c != '\"') && (c != '\\') ){
		*Z->dst++ = '\\';
	}
#endif
}

void USEFASTCALL SetTitleMacro(EXECSTRUCT *Z)
{
	TCHAR *maxp, *titlep;

	titlep = ThAllocString(&Z->StringVariable, Title_ValueName, VFPS);
	maxp = titlep + VFPS - 1;
	for (;;){
		UTCHAR c;

		c = *Z->src;
		if ( c < ' ' ) break;
		Z->src++;
		if ( c == '\"' ) break;
		if ( titlep < maxp ) *titlep++ = c;
	}
	*titlep = '\0';
}

TCHAR * USEFASTCALL GetZCurDir(EXECSTRUCT *Z)
{
	if ( Z->curdir[0] == '\0' ){
		if ( !PPxEnumInfoFunc(Z->Info, '1', Z->curdir, &Z->EnumInfo) ){
			GetCurrentDirectory(VFPS, Z->curdir);
		}
	}
	return Z->curdir;
}

DWORD GetFmacroOption(const TCHAR **string)
{
	DWORD flags = 0;
	const TCHAR *p;
	TCHAR c;

	p = *string;
	for ( ;; p++ ){
		c = *p;
		if ( (c < 'B') || (c > 'X') ) break;
		switch ( c ){
//			case 'A': setflag(flags, FMOPT_EX_FILEATTR);	continue;
			case 'B': setflag(flags, FMOPT_BLANKET);	continue;
			case 'C': setflag(flags, FMOPT_FILENAME);	continue;
			case 'D': setflag(flags, FMOPT_DIR);		continue;
			case 'H': setflag(flags, FMOPT_DRIVE);		continue;
//			case 'I': setflag(flags, FMOPT_IDL);		continue;
			case 'K': setflag(flags, FMOPT_SEP_BACKSLASH); continue;
			case 'L': setflag(flags, FMOPT_SEP_SLASH);	continue;
			case 'M': setflag(flags, FMOPT_MARK);		continue;
			case 'N': setflag(flags, FMOPT_NOBLANKET);	continue;
			case 'P': setflag(flags, FMOPT_LASTSEPARATOR); continue;
			case 'R': setflag(flags, FMOPT_REALPATH);	continue;
			case 'S': setflag(flags, FMOPT_USESFN);		continue;
			case 'T': setflag(flags, FMOPT_FILEEXT);	continue;
			case 'U': setflag(flags, FMOPT_UNIQUE);		continue;
			case 'V': setflag(flags, FMOPT_ENABLEVFS);	continue;
//			case 'W': setflag(flags, FMOPT_EX_WRITEDATE);	continue;
			case 'X': setflag(flags, FMOPT_FILENAME | FMOPT_FILENOEXT); continue;
//			case 'Z': setflag(flags, FMOPT_EX_FILESIZE);	continue;
		}
		break;
	}
	*string = p;
	return flags;
}

void GetFmacroString(DWORD flag, TCHAR *src, TCHAR *dest)
{
	DWORD attr;

	if ( flag & FMOPT_USESFN ) GetShortPathName(src, src, VFPS);
	if ( flag & (FMOPT_FILEEXT | FMOPT_FILENOEXT) ){
		attr = GetFileAttributesL(src); // P dir ɂgq邩ǂ
	}
	if ( (flag & (FMOPT_FILENAME | FMOPT_DIR)) !=
			(FMOPT_FILENAME | FMOPT_DIR) ){ // tpXłȂƂ̏

		if ( flag & (FMOPT_DRIVE | FMOPT_FILEEXT) ){

			if ( flag & FMOPT_FILEEXT ){	// gq
				TCHAR *p;

				p = VFSFindLastEntry(src);
				#pragma warning(suppress: 4701) // ́A"flag & FMOPT_FILEEXT"̂߁AKPς
				if ( (attr == BADATTR) || !(attr & FILE_ATTRIBUTE_DIRECTORY) ||
						GetCustDword(T("XC_sdir"), 0) ){
					if ( *p != '\0' ) p++;
					p = tstrrchr(p, '.');
					if ( p == NULL ){
						*src = '\0';
					}else{
						tstrcpy(src, p + 1);
					}
				}else{
					*src = '\0';
				}
			}else{							// hCu
				TCHAR *p, *q, *r;
				int mode;

				p = VFSGetDriveType(src, &mode, NULL);
				if ( p != NULL ){
					if ( mode == VFSPT_DRIVE ){
						*p = '\0';
					}else if ( mode == VFSPT_UNC ){
						q = FindPathSeparator(p);
						if ( q != NULL ){
							r = FindPathSeparator(q + 1);
							if ( r != NULL ) *r = '\0';
						}
					}
				}
			}
		}else{ // t@C or fBNg
			TCHAR *xp, xpc;

			xp = VFSFindLastEntry(src);
			if ( xp != src ){
				if ( flag & FMOPT_DIR ){ // fBNg
					*xp = '\0';
				}else{ // t@C
					xpc = *xp;
					tstrcpy(src, (xpc == '\\') || (xpc == '/') ? xp + 1 : xp);
				}
			}
		}
	}
	if ( flag & FMOPT_FILENOEXT ){
		#pragma warning(suppress: 6001) // GetFileAttributesgpς
		if ( (attr == BADATTR) || !(attr & FILE_ATTRIBUTE_DIRECTORY) ||
				GetCustDword(T("XC_sdir"), 0) ){
			TCHAR *lastentry;

			lastentry = VFSFindLastEntry(src);
			*(lastentry + FindExtSeparator(lastentry)) = '\0';
		}
	}
	if ( flag & FMOPT_LASTSEPARATOR ) CatPath(NULL, src, NilStr);

	if ( !(flag & FMOPT_NOBLANKET) &&
		 ((flag & FMOPT_BLANKET) || tstrchr(src, ' ') || tstrchr(src, ',')) ){
		thprintf(dest, CMDLINESIZE, T("\"%s\""), src);
	}else{
		tstrcpy(dest, src);
	}
}

void GetPopupPoint(EXECSTRUCT *Z, POINT *pos)
{
	if ( Z->posptr == NULL ){
		if ( PPxInfoFunc(Z->Info, PPXCMDID_POPUPPOS, pos) ) return;
		if ( (Z->hWnd != NULL) && IsWindowVisible(Z->hWnd) ){
			pos->x = 0;
			pos->y = 0;
			ClientToScreen(Z->hWnd, pos);
		}else{
			GetCursorPos(pos);
		}
	}else{
		*pos = *Z->posptr;
	}
}

BOOL infoExtCheck(EXECSTRUCT *Z)
{
	TCHAR buf[64];

	if ( (PPxEnumInfoFunc(Z->Info, PPXCMDID_ENUMATTR, buf, &Z->EnumInfo) == 0) ||
		!(*(DWORD *)buf & FILE_ATTRIBUTE_DIRECTORY) ||
		GetCustDword(T("XC_sdir"), 0) ){
		return TRUE; // gq舵
	}
	return FALSE;
}

void DefaultCmd(EXECSTRUCT *Z, DWORD cmdID, TCHAR *dest)
{
	TCHAR buf[VFPS];

	switch( cmdID ){
		case '1':
			GetCurrentDirectory(VFPS, dest);
			break;

		case '0': {	// gւ̃pX
			TCHAR *p;

			GetModuleFileName(NULL, dest, MAX_PATH);
			p = FindLastEntryPoint(dest);
			*p = '\0';
			break;
		}

//		case 'C':
		case 'R':
			PPxEnumInfoFunc(Z->Info, 'C', dest, &Z->EnumInfo);
			break;

		case 'X':
			// 'Y' 
		case 'Y': {
			TCHAR *p;

			PPxEnumInfoFunc(Z->Info, 'C', dest, &Z->EnumInfo);
			if ( infoExtCheck(Z) ){
				p = VFSFindLastEntry(dest);
				if ( *p != '\0' ) p++;
				p = tstrrchr(p, '.');
				if ( p != NULL ) *p = '\0';
			}
			break;
		}

		case 'T':
			// 'T' 
		case 't': {
			TCHAR *p;

			if ( !infoExtCheck(Z) ){
				dest[0] = '\0';
				break;
			}

			PPxEnumInfoFunc(Z->Info, 'C', buf, &Z->EnumInfo);
			p = VFSFindLastEntry(buf);
			if ( *p != '\0' ) p++;
			p = tstrrchr(p, '.');
			if ( p == NULL ){
				dest[0] = '\0';
			}else{
				tstrcpy(dest, p + 1);
			}
			break;
		}
	}
	return;
}

// %F
void Get_F_MacroData(PPXAPPINFO *info, PPXCMD_F *fbuf, PPXCMDENUMSTRUCT *work)
{
	DWORD flags;
	const TCHAR *p;
	TCHAR buf[VFPS];

	p = fbuf->source;
	if ( PPxEnumInfoFunc(info, 'F', (TCHAR *)fbuf, work) ) return;

	flags = GetFmacroOption(&p);
	fbuf->source = p;
	if ( !PPxEnumInfoFunc(info, '1', fbuf->dest, work) ){
		GetCurrentDirectory(VFPS, fbuf->dest);
	}
	PPxEnumInfoFunc(info, 'C', buf, work);
	if ( buf[0] == '\0' ){
		if ( flags & (FMOPT_FILENAME | FMOPT_USESFN | FMOPT_FILEEXT) ){
			fbuf->dest[0] = '\0';
			return;
		}
		buf[0] = '?';
		buf[1] = '\0';
	}
	VFSFullPath(NULL, buf, fbuf->dest);
	GetFmacroString(flags, buf, fbuf->dest);
}

// %M[$][&][@][:][<header>][[?[?]]name][,[!]shortcut]
// // $ :}NWJ (CmdPack Ŏgp)
// & : ϐ %s"Menu_Index" ɓeۑ (CmdPack Ŏgp)
// @ : pjumppǉ (PPC_PathJump Ŏgp)
// ? : Ij[w    ?? : Ij[}
// : : %M:M_pjump A}NWJ
// ! : j[\őI
BOOL USEFASTCALL MenuCmd(EXECSTRUCT *Z)
{
	TCHAR cid[MAX_PATH], *ptr;
	TCHAR param[CMDLINESIZE];
	TCHAR def[VFPS], buf[MAX_PATH], c;
	int flags = 0;

	if ( Z->flags & XEO_DISPONLY ){
		*Z->dst++ = '%';
		*Z->dst++ = *(Z->src - 1);
		return FALSE;
	}
	/*
	if ( *Z->src == '$' ){
		Z->src++;
		flags = MENUFLAG_NOEXTACT;
	}
	*/
	if ( *Z->src == '&' ){
		Z->src++;
		setflag(flags, MENUFLAG_SETINDEX);
	}else if ( flags == 0 ){
		Z->src--;
	}
	ptr = cid;
	while( (UTCHAR)(c = *Z->src) >= (UTCHAR)'0' ){ // "  '  , ܂߂Ȃ
		*ptr++ = c;
		Z->src++;
	}
	*ptr = '\0';
	def[0] = '\0';
	if ( *Z->src == ',' ){
		Z->src++;
		if ( *Z->src == '!' ){
			Z->src++;
			setflag(flags, MENUFLAG_SELECT);
		}
		GetLineParamS(&Z->src, def, TSIZEOF(def));
	}
	if ( cid[1] != 'E' ){				// j[ ...........................
		if ( MenuCommand(Z, cid, def, flags) == FALSE ) return TRUE;
		if ( Z->result != NO_ERROR ) return TRUE;
	}else{								// gq .........................
		TCHAR *TypeName = NULL;

		if ( def[0] == '\0' ){ // shortcut w薳
			PPxEnumInfoFunc(Z->Info, 'C', buf, &Z->EnumInfo);
			if ( buf[0] == '\0' ){
				Z->result = ERROR_NO_MORE_ITEMS;
				return TRUE;
			}
			CatPath(def, GetZCurDir(Z), buf);

			if ( PPxEnumInfoFunc(Z->Info, PPXCMDID_ENUMATTR, buf, &Z->EnumInfo) && (*(DWORD *)buf & FILE_ATTRIBUTE_DIRECTORY) ){
				TypeName = (TCHAR *)FILE_ATTRIBUTE_DIRECTORY;
			}
		}

		if ( (*(cid + 2) != ':') ?
				(PP_GetExtCommand(def, cid + 1, param, TypeName) == PPEXTRESULT_FILE)
			  : (NO_ERROR == GetCustTable(cid + 3, def, param, TSTROFF(CMDLINESIZE)))
		){
			const TCHAR *newsrc;

			newsrc = param;
			if ( (UTCHAR)*newsrc == EXTCMD_CMD ){
				newsrc++;
			}else{
				if ( (UTCHAR)*newsrc == EXTCMD_KEY ) newsrc++;
				while( *((WORD *)newsrc) ){
					ERRORCODE result;

					result = (ERRORCODE)PPxInfoFunc(Z->Info, PPXCMDID_PPXCOMMAD, (void *)newsrc);
					if ( result > 1 ){ // NO_ERROR, ERROR_INVALID_FUNCTION ȊO̓G[
						if ( (result == ERROR_CANCELLED) || !(Z->flags & XEO_IGNOREERR) ){
							break;
						}
					}
					newsrc += sizeof(WORD) / sizeof(TCHAR);
				}
			}
			InsertSrc(Z, newsrc);
		}else{
			Z->result = ERROR_NO_MORE_ITEMS;
		}
		return TRUE;
	}
	return FALSE;
}

#define ERROR_EXTRACT_LONG RPC_S_STRING_TOO_LONG
#define OFFSET_EXTRACT_LONG 16
PPXDLL LRESULT PPXAPI AnswerExtractCall(PPXAPPINFO *info, WPARAM wParam, LPARAM lParam)
{
	TCHAR *mapptr, *cmdptr, extractbuf[CMDLINESIZE];
	ERRORCODE result;
	DWORD dstlen = CMDLINESIZE;
	ERRORCODE recvresult = NO_ERROR;

	mapptr = MapViewOfFile((HANDLE)lParam, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	if ( mapptr == NULL ) return NO_ERROR;
	if ( HIWORD(wParam) == (sizeof(DWORD) / sizeof(TCHAR)) ){
		dstlen = *(DWORD *)mapptr;
		cmdptr = mapptr + sizeof(DWORD) / sizeof(TCHAR);
	}else{
		cmdptr = mapptr;
	}
	PP_InitLongParam(extractbuf);
	result = PP_ExtractMacro(info->hWnd, info, NULL, cmdptr, extractbuf, XEO_EXTRACTEXEC | XEO_EXTRACTLONG);

	if ( result == ERROR_PARTIAL_COPY ){
		TCHAR *longresult = PP_GetLongParamRAW(extractbuf);
		size_t resultlen = tstrlen(longresult);

		if ( resultlen >= dstlen ){
			HANDLE hFile;

			tstrcpy(mapptr, T("<length over>"));
			MakeTempEntry(MAX_PATH, mapptr + OFFSET_EXTRACT_LONG, FILE_ATTRIBUTE_NORMAL);
			hFile = CreateFileL(mapptr + OFFSET_EXTRACT_LONG, GENERIC_WRITE,
					FILE_SHARE_WRITE | FILE_SHARE_READ, NULL, CREATE_ALWAYS,
					FILE_ATTRIBUTE_TEMPORARY | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
			if ( hFile != INVALID_HANDLE_VALUE ){
				DWORD wsize;

				if ( IsTrue(WriteFile(hFile, longresult, resultlen * sizeof(TCHAR), &wsize, NULL)) ){
					recvresult = ERROR_EXTRACT_LONG;
				}
				CloseHandle(hFile);
			}
		}else{
			tstrcpy(mapptr, PP_GetLongParamRAW(extractbuf));
		}
		PP_FreeLongParamRAW(extractbuf);
	}else{
		tstrcpy(mapptr, extractbuf);
	}

	UnmapViewOfFile(mapptr);
	CloseHandle((HANDLE)lParam);
	return recvresult;
}

TCHAR *RecvLongExtract(TCHAR *mapptr)
{
	HANDLE hFile;
	TCHAR *buf = NULL;

	hFile = CreateFileL(mapptr + OFFSET_EXTRACT_LONG, GENERIC_READ,
			FILE_SHARE_WRITE | FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if ( hFile != INVALID_HANDLE_VALUE ){
		DWORD size;

		size = GetFileSize(hFile, NULL);
		buf = HeapAlloc(ProcHeap, 0, size + sizeof(TCHAR));
		if ( buf != NULL ){
			if ( ReadFile(hFile, buf, size, &size, NULL) == FALSE ) size = 0;
			buf[size / sizeof(TCHAR)] = '\0';
		}
		CloseHandle(hFile);
	}
	DeleteFileL(mapptr + OFFSET_EXTRACT_LONG);
	return buf;
}

PPXDLL const TCHAR * PPXAPI SendExtractCall(HWND hTargetWnd, const TCHAR *src)
{
	DWORD pid;
	HANDLE hMap, hSendMap, hProcess;
	TCHAR *mapptr, *recvptr;
	DWORD srclen, dstlen, mapsize, offlen;
	LRESULT sendresult;
	TCHAR *buf;

	srclen = tstrlen32(src) + 1;
	dstlen = CMDLINESIZE;
	offlen = 0;
	srclen += offlen;
	mapsize = max(srclen, dstlen) * sizeof(TCHAR);
	if ( mapsize < TSTROFF(CMDLINESIZE) ) mapsize = TSTROFF(CMDLINESIZE);

	hMap = CreateFileMapping(INVALID_HANDLE_VALUE,
			NULL, PAGE_READWRITE, 0, mapsize, NULL);
	if ( hMap == NULL ){
		PPErrorBox(NULL, NULL, PPERROR_GETLASTERROR);
		return NULL;
	}
	mapptr = MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS, 0, 0, mapsize);
	if ( mapptr == NULL ){
		PPErrorBox(NULL, NULL, PPERROR_GETLASTERROR);
		CloseHandle(hMap);
		return NULL;
	}
	GetWindowThreadProcessId(hTargetWnd, &pid);
	hProcess = OpenProcess(PROCESS_DUP_HANDLE, FALSE, pid);
	DuplicateHandle(GetCurrentProcess(), hMap,
			hProcess, &hSendMap, 0, FALSE, DUPLICATE_SAME_ACCESS);
	tstrcpy(mapptr + offlen, src);
	sendresult = SendMessage(hTargetWnd, WM_PPXCOMMAND, TMAKEWPARAM(K_EXTRACT, offlen), (LPARAM)hSendMap);
	CloseHandle(hSendMap);
	CloseHandle(hProcess);

	recvptr = NULL;
	if ( sendresult == ERROR_EXTRACT_LONG ){
		buf = RecvLongExtract(mapptr);
		if ( buf != NULL ) recvptr = buf;
	}else{
		buf = HeapAlloc(ProcHeap, 0, CMDLINESIZE * sizeof(TCHAR));
		if ( buf != NULL ){
			tstrcpy(buf, mapptr);
			recvptr = buf;
		}
	}
	UnmapViewOfFile(mapptr);
	CloseHandle(hMap);
	return recvptr;
}

void ExtractPPxCall(HWND hTargetWnd, EXECSTRUCT *Z, const TCHAR *macroparam)
{
	DWORD pid;
	HANDLE hMap, hSendMap, hProcess;
	TCHAR *mapptr, *recvptr;
	DWORD srclen, dstlen, mapsize, offlen;
	LRESULT sendresult;

	srclen = tstrlen32(macroparam) + 1;
	dstlen = 4 * KB / sizeof(TCHAR);
	offlen = sizeof(DWORD) / sizeof(TCHAR);

	srclen += offlen;
	mapsize = max(srclen, dstlen) * sizeof(TCHAR);
//	if ( mapsize < TSTROFF(CMDLINESIZE) ) mapsize = TSTROFF(CMDLINESIZE);

	hMap = CreateFileMapping(INVALID_HANDLE_VALUE,
			NULL, PAGE_READWRITE, 0, mapsize, NULL);
	if ( hMap == NULL ){
		PPErrorBox(Z->hWnd, NULL, PPERROR_GETLASTERROR);
		return;
	}
	mapptr = MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS, 0, 0, mapsize);
	if ( mapptr == NULL ){
		CloseHandle(hMap);
		PPErrorBox(Z->hWnd, NULL, PPERROR_GETLASTERROR);
		return;
	}
	GetWindowThreadProcessId(hTargetWnd, &pid);
	hProcess = OpenProcess(PROCESS_DUP_HANDLE, FALSE, pid);
	DuplicateHandle(GetCurrentProcess(), hMap,
			hProcess, &hSendMap, 0, FALSE, DUPLICATE_SAME_ACCESS);
	*(DWORD *)mapptr = dstlen;

	tstrcpy(mapptr + offlen, macroparam);
	sendresult = SendMessage(hTargetWnd, WM_PPXCOMMAND, TMAKEWPARAM(K_EXTRACT, offlen), (LPARAM)hSendMap);
	CloseHandle(hSendMap);
	CloseHandle(hProcess);

	recvptr = mapptr;
	if ( sendresult == ERROR_EXTRACT_LONG ){
		TCHAR *buf = RecvLongExtract(mapptr);

		if ( buf != NULL ) recvptr = buf;
	}
	SetLongDest(Z, recvptr, -1);
	if ( recvptr != mapptr ) HeapFree(ProcHeap, 0, recvptr);
	UnmapViewOfFile(mapptr);
	CloseHandle(hMap);
	return;
}

void GetValue(EXECSTRUCT *Z, DWORD cmdID, TCHAR *dest)
{
	if ( PPxEnumInfoFunc(Z->Info, cmdID, dest, &Z->EnumInfo) ) return;
	DefaultCmd(Z, cmdID, dest);
}

void ZGetName(EXECSTRUCT *Z, TCHAR *dest, TCHAR cmd)
{
	TCHAR buf[VFPS + sizeof(TCHAR) * 2];

	if ( cmd == '\0' ) cmd = *(Z->src - 1);
	switch ( cmd ){
		case 'F': { // %F
			((PPXCMD_F *)buf)->source = Z->src;
			((PPXCMD_F *)buf)->dest[0] = '\0';

			Get_F_MacroData(Z->Info, (PPXCMD_F *)buf, &Z->EnumInfo);

			if ( Z->src < ((PPXCMD_F *)buf)->source ){
				while( Z->src < ((PPXCMD_F *)buf)->source ){
					if ( (*Z->src == 'C') || (*Z->src == 'X') ){
						setflag(Z->flags, XEO_EXECMARK);
					}
					Z->src++;
				}
			}else{
				while( Isalpha(*Z->src) ){
					if ( (*Z->src == 'C') || (*Z->src == 'X') ){
						setflag(Z->flags, XEO_EXECMARK);
					}
					Z->src++;
				}
			}
			tstrcpy(dest, ((PPXCMD_F *)buf)->dest);
			break;
		}
		case 'C': // %C
		case 'X': // %X
			setflag(Z->status, ST_PATHITEM);
		// %T 
		case 'T': // %T
								// Jg̃t@C̑
			GetValue(Z, cmd, dest);
			if ( PPxEnumInfoFunc(Z->Info, PPXCMDID_ENUMATTR, buf, &Z->EnumInfo) &&
					(*(DWORD *)buf & FILE_ATTRIBUTE_DIRECTORY) ){
				if ( (Z->flags & XEO_DIRWILD) && ( cmd == 'C' ) ){
					CatPath(NULL, dest, T("*.*"));
				}
				setflag(Z->status, ST_SDIRREF | ST_CHKSDIRREF);
			}else{
				setflag(Z->status, ST_CHKSDIRREF);
			}
			setflag(Z->flags, XEO_EXECMARK);
			break;

		default: // ͖̑`
			*dest = '\0';
	}
}

void USEFASTCALL convertslash(EXECSTRUCT *Z, TCHAR *path)
{
	if ( !(Z->flags & (XEO_PATHSLASH | XEO_PATHESCAPE)) ) return;

	while ( *path ){
		if ( Ismulti(*path) ){
			path++;
			if ( *path == '\0' ) break;
		}else{
			switch ( *path ){
				case '\\':
					*path = '/';
					break;

				case '[':
				case ']':
					if ( !(Z->flags & XEO_PATHESCAPE) ) break;
					memmove(path + 1, path, TSTRSIZE(path));
					*path++ = '\\';
					break;
			}
		}
		path++;
	}
}

BOOL CreateResponseFile(EXECSTRUCT *Z)
{
	TCHAR atr[16], *p, buf[VFPS + 4]; // +4 ́Au""v + 
	const TCHAR *oldsrc = NULL; // w
	HANDLE hFile;
	DWORD size;
	BOOL addall = TRUE;
	BOOL writebom = FALSE;
	#ifdef UNICODE
	char bufA[VFPS * 3 + 4];
	#endif
	UINT codepage = CP_ACP;

	if ( Z->flags & XEO_DISPONLY ){		// \̂
		tstrcpy(Z->dst, T("ResFile"));
		Z->dst += 7;
		return TRUE;
	}

	if ( *Z->src == '*' ){
		Z->src++;
		addall = FALSE;
	}
	if ( *Z->src == '8' ){
		Z->src++;
		codepage = CP_UTF8;
	}
	if ( *Z->src == 'U' ){
		Z->src++;
		codepage = CP_PPX_UCF2;
	}
	if ( *Z->src == 'B' ){
		Z->src++;
		writebom = TRUE;
	}

	if ( ThGetString(&Z->StringVariable, ResponseName_ValueName, Z->dst, VFPS) != NULL ){ // s(쐬ς)
		Z->dst += tstrlen(Z->dst);
		while ( Isalpha(*Z->src) ) Z->src++; // ݒXLbv
		return TRUE;
	}

	#ifdef UNICODE
	if ( (Z->command == 'u') && (codepage == CP_ACP) ){ // %u ̏ꍇ́AR[h␳Kv
		UN_DLL *uD;
		int i;

		p = Z->DstBuf;
		GetCommandParameter((const TCHAR **)&p, buf, TSIZEOF(buf));

		uD = undll_list;
		for ( i = 0 ; i < undll_items ; i++, uD++ ){
			if ( tstricmp(uD->DllName, buf) ) continue;

			if ( uD->hadd == NULL ){
				if ( LoadUnDLL(uD) == FALSE ) break;
			}

			if ( uD->UnarcW != NULL ){
				if ( uD->flags & UNDLLFLAG_RESPONSE_UTF8 ){
					codepage = CP_UTF8;
				}else{
					codepage = CP_PPX_UCF2;
				}
			}else if ( uD->SetUnicodeMode(TRUE) ){
				uD->SetUnicodeMode(FALSE);
				codepage = CP_UTF8;
			}
			if ( codepage != CP_ACP ){
				p = tstrchr(Z->DstBuf, ',');
				if ( p != NULL ){
					p++;
					memmove(p + 2, p, TSTRSIZE(p));
					Z->dst += 2;
					p[0] = '!';
					p[1] = (TCHAR)((codepage == CP_PPX_UCF2) ? '2' : '8');
				}
			}
			break;
		}
	}
	#endif

	if ( Isalpha(*Z->src) ) oldsrc = Z->src + 1;

										// s(VK쐬)
	MakeTempEntry(MAX_PATH, Z->dst, FILE_ATTRIBUTE_NORMAL);
	hFile = CreateFileL(Z->dst, GENERIC_WRITE,
			FILE_SHARE_WRITE | FILE_SHARE_READ, NULL, CREATE_ALWAYS,
			FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	if ( hFile == INVALID_HANDLE_VALUE ){
		Z->result = GetLastError();
		return FALSE;
	}
	PPxInfoFunc(Z->Info, PPXCMDID_GETTMPFILENAME, Z->dst);
	ThSetString(&Z->StringVariable, ResponseName_ValueName, Z->dst);
	if ( tstrchr(Z->dst, ' ') == NULL ){
		Z->dst += tstrlen(Z->dst);
	}else{
		Z->dst = thprintf(Z->dst, CMDLINESIZE, T("\"%s\""), ThGetString(&Z->StringVariable, ResponseName_ValueName, NULL, 0));
	}
	buf[0] = '\"';

	setflag(Z->status, ST_CHKSDIRREF);

	if ( writebom ){
		if ( codepage == CP_PPX_UCF2 ){
			WriteFile(hFile, UCF2HEADER, UCF2HEADERSIZE, &size, NULL);
		}else{
			WriteFile(hFile, UTF8HEADER, UTF8HEADERSIZE, &size, NULL);
		}
	}

	for ( ; ; ){
		if ( oldsrc != NULL ){ // wL
			Z->src = oldsrc;
			ZGetName(Z, buf, '\0');
			// ֑R[h
//			if ( !buf[0] || ((buf[0] == '\"') && (buf[1] == '\"')) ){ // 
//				break;
//			}
			convertslash(Z, buf);
			p = buf;
		}else{ // w薳c%C
			GetValue(Z, 'C', buf + 1);
			if ( buf[1] == '\0' ) break;
			convertslash(Z, buf + 1);
							// 󔒂 Ȃu"vŊ
			if ( tstrchr(buf + 1, ' ') ){
				p = buf;
				tstrcat(p, T("\""));
			}else{
				p = buf + 1;
			}
		}
		if ( PPxEnumInfoFunc(Z->Info, PPXCMDID_ENUMATTR, atr, &Z->EnumInfo) &&
					(*(DWORD *)atr & FILE_ATTRIBUTE_DIRECTORY) ){
			if ( addall ){
				if ( *p == '\"' ){
					*(p + tstrlen(p) - 1) = '\0';
					CatPath(NULL, p, T("*\""));
				}else{
					CatPath(NULL, p, WildCard_All);
				}
			}
			setflag(Z->status, ST_SDIRREF);
		}
		#ifdef UNICODE
			if ( codepage != CP_PPX_UCF2 ){
				if ( 0 >= WideCharToMultiByteU8(codepage, 0, p, -1, bufA, sizeof(bufA), NULL, NULL) ){
					strcpy(bufA, "<long>");
				}
				if ( WriteFile(hFile, bufA, strlen32(bufA), &size, NULL) == FALSE ) break;
				if ( WriteFile(hFile, "\r\n", 2, &size, NULL) == FALSE ) break;
			}else{
				if ( WriteFile(hFile, p, TSTRLENGTH32(p), &size, NULL) == FALSE ) break;
				if ( WriteFile(hFile, L"\r\n", 4, &size, NULL) == FALSE ) break;
			}
		#else
			if ( codepage == CP_UTF8 ){
				WCHAR bufW[VFPS];

				AnsiToUnicode(p, bufW, TSIZEOF(bufW));
				if ( 0 >= WideCharToMultiByteU8(codepage, 0, bufW, -1, buf + 1, sizeof(buf) - 2, NULL, NULL) ){
					strcpy(buf + 1, "<long>");
				}
				p = buf + 1;
			}
			if ( WriteFile(hFile, p, strlen(p), &size, NULL) == FALSE ) break;
			if ( WriteFile(hFile, "\r\n", 2, &size, NULL) == FALSE ) break;
		#endif
		if ( PPxEnumInfoFunc(Z->Info, PPXCMDID_NEXTENUM, buf + 1, &Z->EnumInfo)== 0){
			setflag(Z->status, ST_LOOPEND);
			break;
		}
	}
	CloseHandle(hFile);
	return TRUE;
}


const TCHAR *ZGetTitleName(EXECSTRUCT *Z)
{
	const TCHAR *title;

	title = ThGetString(&Z->StringVariable, Title_ValueName, NULL, 0);
	if ( title == NULL ) title = MessageText(ExecuteDefaultTitle);
	return title;
}


BOOL ZTinput(EXECSTRUCT *Z, TINPUT *tinput)
{
	int inputtype;
	WORD rhisttype;

	if ( !(tinput->flag & TIEX_Z_HIST_SETTINGED) ){
		if ( Z->status & ST_EDITHIST ){ //  %eg ̏ꍇ 0cw薳ɂȂ
			inputtype = Z->edit.options.hist_writetype;
			rhisttype = Z->edit.options.hist_readflags;

			SetTInputOptionFlags(tinput, &Z->edit.options);
		}else if ( Z->status & ST_PATHITEM ){
			inputtype = HistType_PATHFIX;
			rhisttype = PPXH_NAME_R;
		}else{
			inputtype = HistType_GENERAL;
			rhisttype = PPXH_GENERAL_R;
		}
		tinput->hRtype = rhisttype;
		tinput->hWtype = HistWriteTypeflag[inputtype];
		setflag(tinput->flag, TinputTypeflags[inputtype]);
	}
	tinput->hOwnerWnd = Z->hWnd;
	tinput->info = Z->Info;

	if ( tInputEx(tinput) <= 0 ){
		Z->result = ERROR_CANCELLED;
		return FALSE;
	}
	return TRUE;
}

HWND GetPPcPairWindow(PPXAPPINFO *ppxa)
{
	HWND hWnd;
	int i;

	if ( ppxa != NULL ){
		hWnd = (HWND)PPxInfoFunc(ppxa, PPXCMDID_PAIRWINDOW, &i);
		if ( hWnd != NULL ) return hWnd;
	}

	// ȂcANeBu PPc T
	UsePPx();
	i = Sm->ppc.LastFocusID;
	if ( CheckPPcID(i) == FALSE ){
		for ( i = 0 ; i < X_Mtask ; i++ ){
			if ( IsTrue(CheckPPcID(i)) ) break;
		}
	}
	if ( i < X_Mtask ) hWnd = Sm->P[i].hWnd;
	FreePPx(); // UAL
	if ( i >= X_Mtask ) return NULL;
	return (HWND)SendMessage(hWnd, WM_PPXCOMMAND, KC_GETSITEHWND, (LPARAM)KC_GETSITEHWND_PAIR);
}

int GetPPxRegID(const TCHAR **src)
{
	int IDindex; // 0`X_Mtask ȂLȒl
	TCHAR *bufp, buf[REGEXTIDSIZE];
	int offset;

	// A_BCDEF `pӂ
	bufp = buf;
	offset = 1; // Isalpha(**src)==FALSÊƂ͒lsvAł
	if ( Isalpha(**src) ){ // 1
		*bufp++ = TinyCharUpper(*((*src)++));
		// 2('X_X'̂Ƃ)
		if ( **src == '_' ){
			*bufp++ = '_';
			(*src)++;
			offset++;
		}
		for ( ; offset < (REGEXTIDSIZE - 1) ; offset++ ){ // cID𒊏o
			if ( !Isalpha(**src) ) break;
			*bufp++ = TinyCharUpper(*((*src)++));
		}
	}
	*bufp = '\0';

	if ( Isalpha(**src) ){ // ]ȕ
		while ( Isalpha(**src) ) (*src)++;
		return -1;
	}

	if ( buf[0] == '\0' ) return -1;
	UsePPx();
	if ( (buf[0] == 'C') && (buf[1] == '\0') ){ // 1w PPc
/*
		HWND hFocusWnd = Sm->ppc.hLastFocusWnd;

		if ( (hFocusWnd != NULL) && IsWindow(hFocusWnd) ){
			FreePPx();
			return hFocusWnd;
		}
*/
		IDindex = Sm->ppc.LastFocusID;
		if ( CheckPPcID(IDindex) == FALSE ){
			for ( IDindex = 0 ; IDindex < X_Mtask ; IDindex++ ){
				if ( IsTrue(CheckPPcID(IDindex)) ) break;
			}
		}
	}else if ( buf[1] == '\0' ){ // e1w
		for ( IDindex = 0 ; IDindex < X_Mtask ; IDindex++ ){ // gpłPPx
			if ( (Sm->P[IDindex].ID[0] == buf[0]) && (Sm->P[IDindex].ID[1] == '_') ){
				break;
			}
		}
	}else{
		IDindex = SearchPPx(buf);
		if ( IDindex < 0 ){
			buf[3] = '\0';
			buf[2] = buf[1];
			buf[1] = '_';
			IDindex = SearchPPx(buf);
		}
	}

	if ( (IDindex < 0) || (IDindex >= X_Mtask) ){
		IDindex = -1;
	}
	FreePPx();
	return IDindex;
}

// BADHWND ... YEBhEȂ
// NULL ... IDw肪ĂȂ
PPXDLL HWND PPXAPI GetPPxhWndFromID(PPXAPPINFO *ppxa, const TCHAR **src, TCHAR *path)
{
	int IDindex; // 0`X_Mtask ȂLȒl
	TCHAR *bufp, buf[REGEXTIDSIZE], code;
	int combosite = -2, offset;
	HWND hComboWnd;

	code = **src;
	if ( code == '~' ){ // Α
		HWND hPairWnd;

		(*src)++;
		hPairWnd = GetPPcPairWindow(ppxa);
		if ( hPairWnd == NULL ) return BADHWND;
		return hPairWnd;
	}

	if ( !Isalpha(code) ){
		if ( code == '-' ){ // 
			(*src)++;
		}else{
			return NULL; // wȂ
		}
	}

	// A_BCDEF `pӂ
	bufp = buf;
	offset = 1; // Isalpha(**src)==FALSÊƂ͒lsvAł
	if ( Isalpha(**src) ){ // 1
		*bufp++ = TinyCharUpper(*((*src)++));
		// 2('X_X'̂Ƃ)
		if ( **src == '_' ){
			*bufp++ = '_';
			(*src)++;
			offset++;
		}
		for ( ; offset < (REGEXTIDSIZE - 1) ; offset++ ){ // cID𒊏o
			if ( !Isalpha(**src) ) break;
			*bufp++ = TinyCharUpper(*((*src)++));
		}
	}
	*bufp = '\0';

	if ( code == '-' ){ // 
		if ( ppxa != NULL ){
			HWND hWnd = (HWND)PPxInfoFunc(ppxa, PPXCMDID_GETREQHWND, buf);
			if ( hWnd != NULL ) return hWnd;
		}
		if ( buf[0] != 'C' ) return BADHWND;
		// -C  C ŎQƂ
	}

	if ( offset >= REGIDSIZE ){ // C_Zxyy `H
		HWND hWnd;

		if ( buf[1] == '_' ){
			buf[1] = buf[0];
			bufp = buf + 1;
		}else{
			bufp = buf;
		}
		hWnd = Sm->ppc.hComboWnd[bufp[2] - 'A'];
		if ( (hWnd == hProcessComboWnd) && (ppxa != NULL) ){
			HWND hGetWnd = (HWND)PPxInfoFunc(ppxa, PPXCMDID_COMBOGETHWNDEX, bufp);
			if ( hGetWnd != NULL ) return hGetWnd;
		}
		{
			LPARAM lParam;

			if ( (hWnd == NULL) || (hWnd == BADHWND) ) return BADHWND;
			// Cza[aaa][]GR[h.ȂĂ \0 ̂ ok
			lParam = (DWORD)(BYTE)bufp[3] |
					((DWORD)(BYTE)bufp[4] << 8) |
					((DWORD)(BYTE)bufp[5] << 16) |
					((DWORD)(BYTE)bufp[6] << 24);
			hWnd = (HWND)SendMessage(hWnd, WM_PPXCOMMAND, KCW_GetIDWnd, lParam);
		}
		if ( hWnd == NULL ) return BADHWND;
		return hWnd;
	}

	if ( **src == '#' ){ // ̉w
		TCHAR c;

		if ( buf[0] != 'C' ) return BADHWND;

		if ( (buf[1] == 'B') && Isalpha(buf[2]) ){ // Cӂcombo 'CBX'
			hComboWnd = Sm->ppc.hComboWnd[buf[2] - 'A'];
		}else{ // default
			hComboWnd = hProcessComboWnd;
			if ( hComboWnd == NULL ) hComboWnd = Sm->ppc.hComboWnd[0];
		}
		if ( (hComboWnd == NULL) || (hComboWnd == BADHWND) ) return BADHWND;

		(*src)++;
		c = upper(**src);
		if ( c == 'C' ){ // ݑ
			(*src)++;
			combosite = KC_GETSITEHWND_CURRENT;
		}else if ( c == 'L' ){ // 
			(*src)++;
			combosite = KC_GETSITEHWND_LEFT;
		}else if ( c == 'R' ){ // E
			(*src)++;
			combosite = KC_GETSITEHWND_RIGHT;
		}else if ( c == '~' ){ // Α
			(*src)++;
			combosite = KC_GETSITEHWND_PAIR;
		}else if ( Isdigit(c) ){ // ̃yCʒu
			combosite = KC_GETSITEHWND_LEFTENUM + (int)GetDigitNumber(src);
		}else{
			combosite = KC_GETSITEHWND_BASEWND;
		}
	}

	if ( Isalpha(**src) ){ // ]ȕ
		while ( Isalpha(**src) ) (*src)++;
		return BADHWND;
	}

	if ( combosite != -2 ){ // ̉֘A擾
		HWND hWnd;

		hWnd = (HWND)SendMessage(hComboWnd, WM_PPXCOMMAND, KC_GETSITEHWND, (LPARAM)combosite);
		if ( hWnd == NULL ) return BADHWND;
		if ( path == NULL ) return hWnd;

		UsePPx();
		if ( hWnd == NULL ){
			IDindex = -1;
		}else{
			for ( IDindex = 0 ; IDindex < X_Mtask ; IDindex++ ){
				if ( Sm->P[IDindex].hWnd == hWnd ) break;
			}
		}
	}else{ // ʏ푋擾
		if ( buf[0] == '\0' ) return NULL;
		UsePPx();
		if ( (buf[0] == 'C') && (buf[1] == '\0') ){ // 1w PPc
			HWND hFocusWnd = Sm->ppc.hLastFocusWnd;

			if ( (hFocusWnd != NULL) && IsWindow(hFocusWnd) ){
				FreePPx();
				return hFocusWnd;
			}

			IDindex = Sm->ppc.LastFocusID;
			if ( CheckPPcID(IDindex) == FALSE ){
				for ( IDindex = 0 ; IDindex < X_Mtask ; IDindex++ ){
					if ( IsTrue(CheckPPcID(IDindex)) ) break;
				}
			}
		}else if ( buf[1] == '\0' ){ // e1w
			for ( IDindex = 0 ; IDindex < X_Mtask ; IDindex++ ){ // gpłPPx
				if ( (Sm->P[IDindex].ID[0] == buf[0]) && (Sm->P[IDindex].ID[1] == '_') ){
					break;
				}
			}
		}else{
			IDindex = SearchPPx(buf);
			if ( IDindex < 0 ){
				buf[3] = '\0';
				buf[2] = buf[1];
				buf[1] = '_';
				IDindex = SearchPPx(buf);
			}
		}
	}

	if ( (IDindex >= 0) && (IDindex < X_Mtask) ){
		HWND hWnd = Sm->P[IDindex].hWnd;

		if ( path != NULL ) tstrcpy(path, Sm->P[IDindex].path);
		FreePPx();
		return hWnd;
	}
	FreePPx();
	return BADHWND;
}

PPXDLL void PPXAPI ForceSetForegroundWindow(HWND hWnd)
{
	DWORD inactiveTID, activeTID;
	HWND hTargetWnd, hParentWnd;

	// ANeBułtH[JXύX\ȏԂɂ
	inactiveTID	= GetCurrentThreadId();
	activeTID	= GetWindowThreadProcessId(GetForegroundWindow(), NULL);
	AttachThreadInput(inactiveTID, activeTID, TRUE);
	if ( WinType >= WINTYPE_2000 ){ // _CAO΁AΏۂ
		if ( IsWindowEnabled(hWnd) == FALSE ){ // qEBhEȂƁAʂ̃EBhÊŁA΍
			hWnd = GetWindow(hWnd, GW_ENABLEDPOPUP);
		}
	}
	// eŏE\ɂȂĂꍇ͌ɖ߂
	hTargetWnd = hWnd;
	while ( (hParentWnd = GetParent(hTargetWnd)) != NULL ){
		hTargetWnd = hParentWnd;
	}
	if ( IsIconic(hTargetWnd) || !IsWindowVisible(hTargetWnd) ){
		DWORD_PTR sendresult;

		SendMessageTimeout(hTargetWnd, WM_SYSCOMMAND, SC_RESTORE, 0xffff0000,
				SMTO_ABORTIFHUNG, 300, &sendresult);
	}
	// ANeBu
	SetForegroundWindow(hWnd);
	AttachThreadInput(inactiveTID, activeTID, FALSE);
}

void USEFASTCALL ZGetPPvCursorPos(EXECSTRUCT *Z)
{
	DWORD cmdid = *(Z->src - 1);

	switch ( *Z->src ){
		case 'H': // %lH %LH
			cmdid += 0x100;
			// 'V'
		case 'V': // %lV %LV
			Z->src++;
			break;
		//default:
	}
	PPxEnumInfoFunc(Z->Info, cmdid, Z->dst, &Z->EnumInfo);
	Z->dst += tstrlen(Z->dst);
}

void USEFASTCALL ZGetWndCaptionMacro(EXECSTRUCT *Z)
{
	HWND nhWnd;
	int len;

	nhWnd = GetCaptionWindow(Z->hWnd);
	*Z->dst = '\0';
	len = (int)SendMessage(nhWnd, WM_GETTEXT, VFPS, (LPARAM)Z->dst); // ʃvZXQƂ\
	Z->dst[len] = '\0';
	if ( Z->func.quotation ) ZQuotationDoubler_Buf(Z);
	Z->dst += tstrlen(Z->dst);
}

// *string / %s ϐ
BOOL ZStringVariable(EXECSTRUCT *Z, const TCHAR **src, int mode)
{
	TCHAR *name, namebuf[CMDLINESIZE], *str;
	ThSTRUCT *thStringValue = &ProcessStringValue;

	for (;;){
		switch ( *(*src)++ ){
			case 'g': // WJ
				mode = StringVariable_extract;
				continue;

			case 'p': // vZX
				break;

			case 'i': {// ID
				ThSTRUCT *thWndSV = (ThSTRUCT *)PPxInfoFunc(Z->Info, PPXCMDID_GETWNDVARIABLESTRUCT, NULL);
				if ( thWndSV != NULL ) thStringValue = thWndSV;
				break;
			}
/*
			case 'r': {// eR}hC
				ThSTRUCT *thParentSV = (ThSTRUCT *)PPxInfoFunc(Z->Info, PPXCMDID_GETEXTRACTVARIABLESTRUCT, NULL);
				if ( thParentSV != NULL ) thStringValue = thParentSV;
				break;
			}
*/
			case 'e': {// Edit/TreeRg[
				ThSTRUCT *thEditSV = (ThSTRUCT *)PPxInfoFunc(Z->Info, PPXCMDID_GETCONTROLVARIABLESTRUCT, NULL);
				if ( thEditSV != NULL ) thStringValue = thEditSV;
				break;
			}

//			case 'c': // Z
//				break;

			case 'o': // R}hC(R}hC[J)
				thStringValue = &Z->StringVariable;
				break;

			case 'v': {// R}hC(R}hCO[o)
				DWORD_PTR result;

				result = Z->Info->Function(Z->Info, PPXCMDID_GETEXTRACTVARIABLESTRUCT, NULL);
				thStringValue = (result != PPXA_INVALID_FUNCTION) ?
						(ThSTRUCT *)result : &Z->StringVariable;
				break;
			}

			case 'u': // _User 
				thStringValue = NULL;
				break;

			default: { // ftHg
				ThSTRUCT *thSV = (ThSTRUCT *)PPxInfoFunc(Z->Info, PPXCMDID_GETCONTROLVARIABLESTRUCT, NULL);
				if ( thSV != NULL ){
					thStringValue = thSV;
				}else{
					thSV = (ThSTRUCT *)PPxInfoFunc(Z->Info, PPXCMDID_GETWNDVARIABLESTRUCT, NULL);
					if ( thSV != NULL ) thStringValue = thSV;
				}
				(*src)--;
				break;
			}

		}
		break;
	}
	if ( SkipSpace(src) == ',' ) (*src)++;
	if ( SkipSpace(src) == '\0' ){
		HMENU hPopupMenu;
		int index = 0;

		hPopupMenu = CreatePopupMenu();
		for (;;){
			if ( thStringValue != NULL ){
				if ( FALSE == ThEnumString(thStringValue, index++, Z->dst, namebuf, TSIZEOF(namebuf)) ){
					break;
				}
			}else{
				if ( EnumCustTable(index++, T("_User"), Z->dst, namebuf, TSIZEOF(namebuf)) <= 0 ){
					break;
				}
			}
			namebuf[1000] = '\0';
			thprintf(Z->dst + tstrlen(Z->dst), CMDLINESIZE, T("=%s"), namebuf);
			AppendMenuString(hPopupMenu, index + 1, Z->dst);
		}
		*Z->dst = '\0';
		index = TTrackPopupMenu(Z, hPopupMenu, NULL);
		if ( index ){
			GetMenuString(hPopupMenu, index, Z->dst, CMDLINESIZE, MF_BYCOMMAND);
			Z->dst += tstrlen(Z->dst);
		}else{
			Z->result = ERROR_CANCELLED;
		}
		DestroyMenu(hPopupMenu);
		return index ? ZMC_CONTINUE : ZMC_BREAK;
	}
	if ( mode == StringVariable_command ){
		name = (TCHAR *)*src; // const TCHAR *  TCHAR * ɋϊ
	}else{
		TCHAR sep;

		name = namebuf;
		sep = **src;
		if ( (sep != '\"') && (sep != '\'') ){
			GetCommandParameter(src, name, TSIZEOF(namebuf));
		}else{
			TCHAR *dest = name;

			(*src)++;
			while ( (UTCHAR)**src >= ' ' ){
				if ( **src == sep ){
					(*src)++;
					break;
				}
				*dest++ = *(*src)++;
			}
			*dest = '\0';
		}
	}
	str = tstrchr(name, '=');
	if ( str == NULL ){ // read
		const TCHAR *getptr;

		*Z->dst = '\0';
		Z->dst[CMDLINESIZE - 2] = '\0';
		if ( thStringValue != NULL ){
			getptr = ThGetString(thStringValue, name, Z->dst, CMDLINESIZE);
		}else{
			GetCustTable(T("_User"), name, Z->dst, TSTROFF(CMDLINESIZE));
		}
		if ( Z->dst[CMDLINESIZE - 2] == '\0' ){ // short ver.
			if ( Z->func.quotation ) ZQuotationDoubler_Buf(Z);
		}else{ // long ver.
			if ( thStringValue != NULL ){
				SetLongDestMain(Z, getptr, 0);
			}else{
				if ( IsTrue(StoreLongParam(Z, 0)) ){
					int newsize;

					newsize = GetCustTableSize(T("_User"), name);
					if ( ThSize(&Z->ExtendDst, newsize) == FALSE ){
						Z->result = RPC_S_STRING_TOO_LONG;
					}else{
						GetCustTable(T("_User"), name, ThStrLastT(&Z->ExtendDst), newsize);
						ZQuotationDoubler_Ext(Z);
					}
				}
			}
		}
		if ( mode == StringVariable_extract ){
			TCHAR *longdst;

			PP_InitLongParam(namebuf);
			Z->result = PP_ExtractMacro(Z->hWnd, Z->Info, NULL, Z->dst, namebuf, XEO_EXTRACTLONG);
			if ( Z->result == ERROR_PARTIAL_COPY ){
				Z->result = NO_ERROR;
				longdst = PP_GetLongParamRAW(namebuf);
				SetLongDestMain(Z, longdst, 0);
				PP_FreeLongParamRAW(namebuf);
			}else{
				Z->dst = tstpcpy(Z->dst, namebuf);
			}
		}else{
			Z->dst += tstrlen(Z->dst);
		}
	}else{ // store
		const TCHAR *value;

		value = str + 1;
		while ( (str > name) && (*(str - 1) == ' ') ) str--;
		*str = '\0';
		if ( thStringValue != NULL ){
			ThSetString(thStringValue, name, value);
		}else{
			SetCustTable(T("_User"), name, value, TSTRSIZE(value));
		}
	}
	return ZMC_CONTINUE;
}

BOOL CALLBACK SearchWindowProc(HWND hWnd, LPARAM lParam)
{
	TCHAR caption[CMDLINESIZE];

	if ( GetWindowText(hWnd, caption, TSIZEOF(caption) - 1) == 0 ) return TRUE;
	if ( tstrstr(caption, ((SEARCHWINDOW *)lParam)->caption) != NULL ){
		((SEARCHWINDOW *)lParam)->hFoundWnd = hWnd;
		return FALSE;
	}
	return TRUE;
}

PPXDLL HWND PPXAPI GetWindowHandleByText(PPXAPPINFO *ppxa, const TCHAR *param)
{
	HWND hTargetWnd;
	SEARCHWINDOW sw;
	const TCHAR *ptr;
	TCHAR letter1, letter2;
									// PPx w肠H
	ptr = param;
	hTargetWnd = GetPPxhWndFromID(ppxa, &ptr, NULL);
	if ( (hTargetWnd != NULL) && (hTargetWnd != BADHWND) ){
		return hTargetWnd;
	}
	letter1 = upper(*param);
	letter2 = *(param + 1);
	if ( letter1 == '#' ){ // #l ɂnhw
		ptr = param + 1;
		hTargetWnd = (HWND)GetDigitNumber(&ptr);
		if ( (hTargetWnd != NULL) && (*ptr == '\0') ) return hTargetWnd;
	}else if ( ((letter1 == 'C') || (letter1 == 'V')) &&
				((Isalpha(letter2) && ((*(param + 2) == '\0'))) || (letter2 == '\0')) ){
		return NULL;
	}
									// EBhET[`
	sw.hFoundWnd = NULL;
	sw.caption = param;
	EnumWindows(SearchWindowProc, (LPARAM)&sw);
	return sw.hFoundWnd;
}

// IvV擾 -----------------------------------------------------------
void ZReadOption(EXECSTRUCT *Z)
{
	TCHAR c;
	int i;

	while ( (c = *Z->src) != '\0' ){
		Z->src++;
		if ( c == ',' ) break;
		for ( i = 0 ; i < XEO_STRLENGTH ; i++ ){
			if ( c == XEO_OptionString[i] ){
				c = *Z->src;
				switch(c){
					case '-':
						Z->src++;
						resetflag(Z->flags, 1 << i);
						break;
					case '+':
						Z->src++;
					default:
						setflag(Z->flags, 1 << i);
						break;
				}
				break;
			}
		}
		if ( i >= XEO_STRLENGTH ){
			Z->src--;
			break;
		}
	}
}

void InsertSrc(EXECSTRUCT *Z, const TCHAR *newsrc)
{
	OLDSRCSTRUCT *next;
	int length;

	SkipSpace(&newsrc);
	if ( *newsrc == '\0' ) return;

	if ( Z->func.quotation ){
		const TCHAR *srcptr;

		length = 1;
		srcptr = newsrc;
		for (;;){
			TCHAR code;
			code = *srcptr++;
			if ( code == '\0' ) break;
			if ( code == '\"' ){
				length += 2;
			}else{
				length++;
			}
		}
	}else{
		length = tstrlen(newsrc) + 1;
	}

	next = HeapAlloc(DLLheap, 0, sizeof(OLDSRCSTRUCT) + TSTROFF(length));
	if ( next == NULL ) return;
	next->src = Z->src;
	next->backptr = Z->oldsrc;
	Z->oldsrc = next;
	Z->src = (TCHAR *)&next[1];
	memcpy((TCHAR *)&next[1], newsrc, TSTROFF(length));
	if ( Z->func.quotation ) tstrreplace((TCHAR *)&next[1], T("\""), T("\"\""));
}

void Freeoldsrc(EXECSTRUCT *Z)
{
	while ( Z->oldsrc != NULL ){
		OLDSRCSTRUCT *back;

		back = Z->oldsrc;
		Z->oldsrc = back->backptr;
		HeapFree(DLLheap, 0, back);
	}
}

void LoadHistory(EXECSTRUCT *Z, WORD historytype) // %H
{
	const TCHAR *ptr;
	WORD tmphistorytype;

	tmphistorytype = GetHistoryType(&Z->src);
	if ( tmphistorytype != 0 ) historytype = tmphistorytype;

	UsePPx();
	ptr = EnumHistory(historytype, (int)GetDigitNumber(&Z->src));
	if ( ptr != NULL ){
		tstrcpy(Z->dst, ptr);
		if ( Z->func.quotation ) ZQuotationDoubler_Buf(Z);
		Z->dst += tstrlen(Z->dst);
	}
	FreePPx();
	return;
}

void ZGetMessageText(EXECSTRUCT *Z)
{
	const TCHAR *srcp;
	TCHAR *dstp, *maxdst;

	if ( *Z->src == '\"' ) Z->src++;

	srcp = MessageText(Z->src);
	dstp = Z->dst;
	maxdst = Z->DstBuf + CMDLINESIZE - 1;

	if ( (srcp == Z->src) || (srcp == (Z->src + MESTEXTIDLEN + 1)) ){
		for (;;){
			TCHAR c;

			c = *srcp;
			if ( c == '\0' ) break;
			srcp++;
			if ( c == '\"' ) break;
			if ( dstp >= maxdst ) break;
			*dstp++ = c;
		}
		Z->src = srcp;
	}else{
		for (;;){
			TCHAR c;

			c = *srcp;
			if ( c == '\0' ) break;
			srcp++;
			if ( dstp >= maxdst ) break;
			*dstp++ = c;
		}
		for (;;){
			TCHAR c;

			c = *Z->src;
			if ( c == '\0' ) break;
			Z->src++;
			if ( c == '\"' ) break;
		}
	}

	*dstp = '\0';
	Z->dst = dstp;
}

void ZExpandAliasWithExtract(EXECSTRUCT *Z)
{
	TCHAR buf[CMDLINESIZE];
	TCHAR *ptr;
	TCHAR *longdst;
	DWORD size;
	int flags = 0;

	ptr = buf;
	if ( *Z->src == '\'' ) Z->src++;
	while ( ((UTCHAR)*Z->src >= ' ') && (*Z->src != '\'') ) *ptr++ = *Z->src++;
	if ( *Z->src == '\'' ) Z->src++;
	*ptr = '\0';

	size = (DWORD)(CMDLINESIZE - (Z->dst - Z->DstBuf));
	if ( GetCustTable(T("A_exec"), buf, Z->dst, TSTROFF(size)) < 0 ){
		if ( GetEnvironmentVariable(buf, Z->dst, (DWORD)CMDLINESIZE) == 0 ){
			*Z->dst = '\0';
		}
	}
/*
	if ( (*Z->dst == '*') &&
		 (Z->dst == Z->DstBuf) && (Z->ExtendDst.top == 0) &&
		 (Z->command == CID_FILE_EXEC) &&
		 !(Z->flags & XEO_DISPONLY) ){
		flags = XEO_EXTRACTEXEC;
	}
*/
	PP_InitLongParam(buf);
	Z->result = PP_ExtractMacro(Z->hWnd, Z->Info, NULL, Z->dst, buf, flags | XEO_EXTRACTLONG);
	if ( Z->result == ERROR_PARTIAL_COPY ){
		Z->result = NO_ERROR;
		longdst = PP_GetLongParamRAW(buf);
		SetLongDestMain(Z, longdst, 0);
		PP_FreeLongParamRAW(buf);
	}else{
		Z->dst = tstpcpy(Z->dst, buf);
	}
}

void ZExpandAlias(EXECSTRUCT *Z)
{
	TCHAR name[CMDLINESIZE], *namep;
	LONG_PTR leftlen;

	namep = name;
	while ( ((UTCHAR)*Z->src >= ' ') && (*Z->src != '\'') ) *namep++ = *Z->src++;
	if ( *Z->src == '\'' ) Z->src++;
	*namep = '\0';

	leftlen = CMDLINESIZE - (Z->dst - Z->DstBuf);
	if ( leftlen <= 0 ) leftlen = 1;
	Z->dst[leftlen - 1] = '\0'; // ڈ
	if ( NO_ERROR != GetCustTable(T("A_exec"), name, Z->dst, TSTROFF(leftlen)) ){
		int envlen;

		envlen = GetEnvironmentVariable(name, Z->dst, (DWORD)leftlen);
		if ( envlen >= leftlen ){
			if ( StoreLongParam(Z, envlen) == FALSE ) return;
			if ( ThSize(&Z->ExtendDst, TSTROFF(envlen)) == FALSE ){
				Z->result = RPC_S_STRING_TOO_LONG;
				return;
			}
			GetEnvironmentVariable(name, ThStrLastT(&Z->ExtendDst), envlen);
			ZQuotationDoubler_Ext(Z);
		}else{
			if ( Z->func.quotation ) ZQuotationDoubler_Buf(Z);
		}
	}else if ( Z->dst[leftlen - 1] != '\0' ){ // ڈjȂ
		int newsize;

		newsize = GetCustTableSize(T("A_exec"), name);
		if ( StoreLongParam(Z, newsize) == FALSE ) return;
		if ( ThSize(&Z->ExtendDst, newsize) == FALSE ){
			Z->result = RPC_S_STRING_TOO_LONG;
			return;
		}
		GetCustTable(T("A_exec"), name, ThStrLastT(&Z->ExtendDst), newsize);
		ZQuotationDoubler_Ext(Z);
	}else{
		if ( Z->func.quotation ) ZQuotationDoubler_Buf(Z);
	}
	Z->dst += tstrlen(Z->dst);
}

void GetPPxHWND(EXECSTRUCT *Z) // %N
{
	HWND hWnd;

	if ( *Z->src == '.' ){
		Z->src++;
		hWnd = GetParent(Z->hWnd);
	}else{
		hWnd = GetPPxhWndFromID(Z->Info, &Z->src, NULL);
		if ( hWnd == BADHWND ) return; // Y
		if ( hWnd == NULL ) hWnd = Z->hWnd; // IDw薳
	}
	if ( hWnd != NULL ) Z->dst = Numer32ToString(Z->dst, (DWORD)(DWORD_PTR)hWnd);
	return;
}

void GetPPxID(EXECSTRUCT *Z) // %n
{
	int len;

	if ( *Z->src != '#' ){ // eID
		// ̉ CZabc `
		if ( (Z->Info->RegID[0] == 'C') && (Z->Info->RegID[2] == 'Z') ){
			*Z->dst = '\0';
			PPxInfoFunc(Z->Info, PPXCMDID_GETSUBID, Z->dst);
			if ( Z->dst[0] != '\0' ){
				Z->dst += tstrlen(Z->dst);
				return;
			}
		}
		// C_A  CA
		len = tstpcpy(Z->dst, Z->Info->RegID) - Z->dst;
		if ( Z->dst[1] == '_' ){
			Z->dst[1] = Z->dst[2];
			len--;
		}
	}else{ // ̉
		Z->src++;
		if ( PPxInfoFunc(Z->Info, PPXCMDID_COMBOIDNAME, Z->dst) == 0 ) return;
		len = tstrlen32(Z->dst);
	}

	Z->dst += len;
	*Z->dst = '\0';
}

void GetPPxPath(EXECSTRUCT *Z) // %D
{
	HWND hWnd;

	*Z->dst = '\0';
	hWnd = GetPPxhWndFromID(Z->Info, &Z->src, Z->dst); // Z->dst  path ۑ

	if ( hWnd == NULL ){ // ftHgw
		tstrcpy(Z->dst, GetZCurDir(Z));
	}else if ( hWnd == BADHWND ){ // Y
		return;
	}else if ( *Z->dst == '\0' ){
		ExtractPPxCall(hWnd, Z, T("%1"));
	}
	Z->dst += tstrlen(Z->dst);
	return;
}

int FindSearch(const TCHAR *structs[], int structmax, const TCHAR *str)
{
	int mini, maxi;

	mini = 0;
	maxi = structmax;
	while ( mini < maxi ){
		int mid, result;

		mid = (mini + maxi) / 2;
		result = tstrcmp(structs[mid], str);
		if ( result < 0 ){
			mini = mid + 1;
		}else if ( result > 0 ){
			maxi = mid;
		}else{
			return mid;
		}
	}
	return -1;
}

void GetCursorFileName(EXECSTRUCT *Z) // %R, %Y, %t
{
	DWORD attr;

	GetValue(Z, *(Z->src - 1), Z->dst);
								// J[\Gg̃t@C̑
	if ( PPxEnumInfoFunc(Z->Info, PPXCMDID_CSRATTR, (TCHAR *)&attr, &Z->EnumInfo) && (attr & FILE_ATTRIBUTE_DIRECTORY) ){
		setflag(Z->status, ST_SDIRREF | ST_CHKSDIRREF);
	}else{
		setflag(Z->status, ST_CHKSDIRREF);
	}
	Z->dst += tstrlen(Z->dst);
}

DWORD USEFASTCALL GetLongParamMaxLen(EXECSTRUCT *Z)
{
	if ( Z->status & ST_LONGRESULT ){
		return Z->LongResultLen;
	}else if ( ((Z->command == CID_FILE_EXEC) || // s(CID_FILE_EXEC) ̂Ƃ
			(Z->command == CID_RUN) ||
			(Z->command == CID_LAUNCH) ) &&
		 !(Z->flags & (XEO_DISPONLY | XEO_NOEDIT)) ){
		return CMDEXE_LENGTH;
	}else if ( (Z->command == CID_SET) || // ϐ 32K-1 ől
			(Z->command == CID_LINECUST) ||
			(Z->command == CID_CUSTOMIZE) ||
			(Z->command == CID_SETCUST) ){
		return 0x7fc0; // 32k
	}else if ( (Z->flags & XEO_EXTRACTLONG) ||
			(Z->command == 'I') ||
			(Z->command == 'Q') ||
			(Z->command == CID_MSGBOX) ||
			(Z->command == CID_MESSAGEBOX) ||
			(Z->command == CID_INSERT) ||
			(Z->command == CID_INSERTSEL) ||
			(Z->command == CID_REPLACE) ||
			(Z->command == CID_STRING) ||
			(Z->command == CID_LINEMESSAGE) ||
			(Z->command == CID_CLIPTEXT) ){
		return 0x6fffffff;
	}else{
		return CMDLINESIZE;
	}
}

BOOL StoreLongParam(EXECSTRUCT *Z, DWORD addlen)
{
	DWORD size;

	if ( (Z->ExtendDst.top + (Z->dst - Z->DstBuf) + addlen) >= GetLongParamMaxLen(Z) ){
		return FALSE;
	}

	setflag(Z->status, ST_EXTENDDST);
	// p[^ɑΉĂ̂ŁAۑ
	*Z->dst = '\0';
	size = TSTROFF32(Z->dst - Z->DstBuf + 1);
	ThAppend(&Z->ExtendDst, Z->DstBuf, size);
	Z->ExtendDst.top -= TSTROFF(1); // '\0' 炷
	Z->dst = Z->DstBuf;
	*Z->dst = '\0';
	return TRUE;
}

DWORD GetModuleNameHash(const TCHAR *src, TCHAR *dest)
{
	DWORD hash = 0;

	while( *src != '\0' ){
		TCHAR c;

		c = upper(*src++);
		*dest++ = c;
		hash = (DWORD)(hash << 6) | (DWORD)(hash >> (32 - 6)) | (DWORD)c;
	}
	*dest = '\0';
	return hash | CID_USERNAME;
}

void ZMemo(EXECSTRUCT *Z) // %m
{
	if ( *Z->src == '\"' ){
		Z->src++;
		for (;;){
			UTCHAR c;

			c = (UTCHAR)*Z->src;
			if ( c < ' ' ) break;
			Z->src++;
			if ( c == '\"' ) break;
		}
	}else{
		while ( (UTCHAR)(*Z->src) > ' ' ) Z->src++;
	}
}

void GetPairMacro(EXECSTRUCT *Z) // %~
{
	TCHAR *dstp;
	HWND hPairWnd;

	dstp = Z->dst;
	*dstp++ = '%';
	while ( Isalnum(*Z->src) || (*Z->src == '#') ) *dstp++ = *Z->src++;
	*dstp = '\0';
	hPairWnd = GetPPcPairWindow(Z->Info);
	if ( hPairWnd != NULL ) ExtractPPxCall(hPairWnd, Z, Z->dst);
}

void RestoreSrc(EXECSTRUCT *Z)
{
	OLDSRCSTRUCT *back;

	back = Z->oldsrc;
	Z->src = back->src;
	Z->oldsrc = back->backptr;
	HeapFree(DLLheap, 0, back);
}

#define GCS_NOCMD 0
#define GCS_CMD 1
#define GCS_GOTO 2
int GetCommandString(EXECSTRUCT *Z)
{
	TCHAR cmdname[CmdFuncMaxLen], *dest, firstchar;
	const TCHAR *src;
	int i;
									// R}h؂o
	dest = cmdname;
	firstchar = SkipSpace(&Z->src);
	src = Z->src;
	if ( firstchar == '*' ){
		*dest++ = firstchar;
		src++;
	}
	for ( i = 0 ; i < (int)(TSIZEOF(cmdname) - 1) ; i++ ){
		if ( !Isalnum(*src) ) break;
		*dest++ = *src++;
	}
	*dest = '\0';
									// *tR}h
	if ( cmdname[0] == '*' ){
		DWORD namehash;
		int cmdid;

		if ( dest == (cmdname + 1) ) return GCS_NOCMD; // 񖳂
		SkipSpace(&src);
		Z->src = src;

		namehash = GetModuleNameHash(cmdname + 1, cmdname + 1);
		cmdid = FindSearch(CmdName, CID_COUNTS, cmdname + 1);
		if ( cmdid >= 0 ){
			if ( cmdid == (CID_GOTO - CID_MINID) ) return GCS_GOTO;
			if ( cmdid != (CID_SKIP - CID_MINID) ){
				Z->command = cmdid + CID_MINID;
			}else{
				CmdSkip(Z);
			}
		}else{
			Z->command = namehash;
			tstrcpy(Z->dst, cmdname + 1);
			// tstrlen(cmdname + 1) + 1 ̍œKʁ
			Z->dst += tstrlen(cmdname);
			*Z->dst = '\0';
		}
		return GCS_CMD;
	}
									// LނtR}hłȂ
	if ( dest == cmdname ) return GCS_NOCMD; // 񖳂
	if ( (UTCHAR)*src <= ' ' ){
		if ( NO_ERROR == GetCustTable(T("A_exec"), cmdname, Z->dst,
				TSTROFF(CMDLINESIZE) - TSTROFF(Z->dst - Z->DstBuf)) ){ // GCAXL
			Z->src = src;
			InsertSrc(Z, Z->dst);
			return GCS_CMD;
		}
	}
	return GCS_NOCMD;
}

#if 0
int ZGetOneParameter(EXECSTRUCT *Z, TCHAR separator)
{
	int stringoff;
	BOOL quotation = FALSE;
	const TCHAR *src;

	if ( Z->ExtendDst.top != 0 ) StoreLongParam(Z, 0);
	stringoff = Z->ExtendDst.top + (Z->dst - Z->DstBuf) * sizeof(TCHAR);

	src = Z->src;
	SkipSpace(&Z->src);
	for (;;){
		TCHAR code;
		BOOL result;

		code = *src;
		if ( code == '\0' ){ // src  nested ߂ / ֐̓rȂ̂ŃG[
			if ( Z->oldsrc == NULL ){
				if ( !(Z->flags & XEO_DISPONLY) ){
					XMessage(NULL, NULL, XM_GrERRld, MES_EFUT);
				}
				Z->result = ERROR_INVALID_FUNCTION;
				break;
			}
			RestoreSrc(Z);
			src = Z->src;
			continue;
		}

		if ( (Z->dst - Z->DstBuf) >= (CMDLINESIZE - 1) ){ // 
			if ( StoreLongParam(Z, 0) == FALSE ){
				Z->result = RPC_S_STRING_TOO_LONG;
				break;
			}
		}

		if ( code == '\"' ){ // " `FbN
			src++;
			if ( quotation ){
				if ( *src != '\"' ){
					quotation = FALSE;
					SkipSpace(&src);
				}else{ // ""  " ɒu
					*Z->dst++ = '\"';
					src++;
				}
			}else{
				quotation = TRUE;
			}
			continue;
		}

		if ( quotation == FALSE ){
			if ( code == ')' ) break; // ֐[
			if ( code == separator ) break; // ؂
		}

		// s̓p[^Ɋ܂߂
		if ( code != '%' ){				// '%' ȊO͂̂܂ܕ
			*Z->dst++ = code;
			src++;
			continue;
		}
		Z->src = src;
		result = ZMacroCharacter(Z);
		src = Z->src;
		if ( (result == ZMC_BREAK) || (Z->result != NO_ERROR) ) break;
	}
	Z->src = src;
	*Z->dst++ = '\0';
	return (Z->result == NO_ERROR) ? stringoff : -1;
}

ERRORCODE ZFunctionRegExp(EXECSTRUCT *Z)
{
	const TCHAR *long_result;
	TCHAR *src, *pattern;
	PXREGEXPS *rexps;
	int stringoff, regexpoff;
	EXECFUNC oldfunc;

	oldfunc = Z->func;

	if ( SkipSpace(&Z->src) != '(' ) goto error; // ʖ
	Z->src++;
	Z->func.quotation = FALSE;

	stringoff = ZGetOneParameter(Z, ',');
	if ( stringoff < 0 ) goto error;
	if ( *Z->src != ',' ) goto error_1;
	Z->src++;
	regexpoff = ZGetOneParameter(Z, ')');
	if ( (regexpoff < 0) || (*Z->src != ')') ) goto error;
	Z->src++;

	if ( Z->ExtendDst.top == 0 ){
		src = Z->DstBuf + stringoff / sizeof(TCHAR);
		pattern = Z->DstBuf + regexpoff / sizeof(TCHAR);
	}else{
		if ( StoreLongParam(Z, 0) == FALSE ){
			Z->result = RPC_S_STRING_TOO_LONG;
			return Z->result;
		}
		src = (TCHAR *)(Z->ExtendDst.bottom + stringoff);
		pattern = (TCHAR *)(Z->ExtendDst.bottom + regexpoff);
	}

	if ( FALSE == InitRegularExpression(&rexps, pattern, SLASH_REQUIRE) ){
		goto error;
	}
	Z->dst = src;
	long_result = RegularExpressionReplace(rexps, src, Z->dst, CMDLINESIZE);
	if ( long_result != NULL ){
		if ( long_result == Z->dst ){
			Z->dst += tstrlen(Z->dst);
		}else{
			if ( IsTrue(StoreLongParam(Z, 0)) ){
				ThCatString(&Z->ExtendDst, long_result);
			}
		}
	}
	FreeRegularExpression(rexps);
	Z->func = oldfunc;
	return NO_ERROR;

error_1:
	if ( Z->ExtendDst.top == 0 ){
		src = Z->DstBuf + stringoff / sizeof(TCHAR);
	}else{
		if ( StoreLongParam(Z, 0) == FALSE ){
			Z->result = RPC_S_STRING_TOO_LONG;
			return Z->result;
		}
		src = (TCHAR *)(Z->ExtendDst.bottom + stringoff);
	}
	if ( *src == '?' ){
		if ( *Z->src == ')' ) Z->src++;
		Z->dst = GetRegularExpressionName(src);
		return NO_ERROR;
	}
error:
	XMessage(NULL, NULL, XM_GrERRld, T("%*regexp(src,regexp)"));
	Z->result = ERROR_INVALID_PARAMETER;
	Z->func = oldfunc;
	return ERROR_INVALID_PARAMETER;
}
#endif

ERRORCODE ZFunction(EXECSTRUCT *Z)
{
	TCHAR *dst;
	const TCHAR *olds;
	EXECFUNC oldfunc;

	for ( dst = Z->dst ; Isalnum(*Z->src) ; ) *dst++ = *Z->src++;
	*dst++ = '\0'; // ֐[
	*dst = '\0'; // p[^[

//	if ( tstrcmp(Z->dst, T("re")) == 0 ) return ZFunctionRegExp(Z);

	oldfunc = Z->func;
	Z->func.off = Z->ExtendDst.top + (Z->dst - Z->DstBuf) * sizeof(TCHAR) + 1;
	Z->dst = dst;

	olds = Z->src;
	if ( SkipSpace(&Z->src) != '(' ){ // ʖ
		Z->src = olds;
		ExecuteFunction(Z);
		Z->func.off = oldfunc.off;
		return Z->result;
	}

	// ʗL
	Z->func.quotation = FALSE;
	Z->src++;

	for (;;){
		if ( *Z->src == '\0' ){ // src  nested ߂
			if ( Z->oldsrc == NULL ){
				if ( !(Z->flags & XEO_DISPONLY) ){
					XMessage(NULL, NULL, XM_GrERRld, MES_EFUT);
				}
				Z->result = ERROR_INVALID_FUNCTION;
				break;
			}
			RestoreSrc(Z);
			continue;
		}

		if ( (Z->dst - Z->DstBuf) >= (CMDLINESIZE - 1) ){ // 
			if ( StoreLongParam(Z, 0) == FALSE ){
				Z->result = RPC_S_STRING_TOO_LONG;
				break;
			}
		}

		// ֐
		if ( *Z->src == '\"' ){ // " `FbN
			*Z->dst++ = *Z->src++;
			if ( Z->func.quotation ){
				if ( *Z->src != '\"' ){
					Z->func.quotation = FALSE;
				}else{ // ""  " ɒu
					*Z->dst++ = '\"';
					Z->src++;
					continue;
				}
			}else{
				Z->func.quotation = TRUE;
				continue;
			}
		}
		if ( (*Z->src == ')') && (Z->func.quotation == FALSE) ){ // ֐[
			Z->src++;
			Z->func.quotation = oldfunc.quotation;
			ExecuteFunction(Z);
			break;
		}

		// s̓p[^Ɋ܂߂

		if ( *Z->src != '%' ){				// '%' ȊO͂̂܂ܕ
			*Z->dst++ = *Z->src++;
			continue;
		}
		if ( ZMacroCharacter(Z) == ZMC_BREAK ) break;
		if ( Z->result != NO_ERROR ) break;
	}
	Z->func = oldfunc;
	return Z->result;
}

void ZBlockEscape(EXECSTRUCT *Z)
{
	TCHAR code;
	int count = 0;

	Z->src++;
	for (;;){
		code = *Z->src;
		if ( code == '\0' ){ // src  nested ߂
			if ( Z->oldsrc == NULL ) break;
			RestoreSrc(Z);
			continue;
		}
		if ( (Z->dst - Z->DstBuf) >= (CMDLINESIZE - 1) ){ // 
			if ( StoreLongParam(Z, 0) == FALSE ){
				Z->result = RPC_S_STRING_TOO_LONG;
				return;
			}
		}
		if ( code == '\"' ){
			if ( Z->func.quotation ) *Z->dst++ = '\"';
		}
		if ( code != '%' ){				// '%' ȊO͂̂܂ܕ
			*Z->dst++ = code;
			Z->src++;
			continue;
		}
		code = *(Z->src + 1);
		Z->src += 2;
		if ( code == ')' ){
			if ( count <= 0 ) return;
			count--;
		}
		*Z->dst++ = '%';
		*Z->dst++ = code;
		if ( code == '(' ) count++;
		continue;
	}
}

// TRUE:ߌpAFALSE:ߏI
BOOL ZMacroCharacter(EXECSTRUCT *Z)	// }N % 
{
	Z->src++;
	if ( *Z->src == '(' ){	// % WJ}
		ZBlockEscape(Z);
		return ZMC_CONTINUE;
	}
	if ( *Z->src == ')' ){	// % WJ}
		if ( !(Z->flags & XEO_DISPONLY) ){
			XMessage(NULL, NULL, XM_GrERRld, MES_EFUT);
		}
		return ZMC_BREAK;
	}
	Z->edit.EdOffset = -1;
	resetflag(Z->status, ST_PATHITEM | ST_PATHFIX);
	if ( *Z->src == '!' ){		// %!	ҏW ------------------
		Z->edit.EdOffset = GetDestOffset(Z);
		Z->src++;
	}else if ( *Z->src == '$' ){	// %$	LbVtҏW ---
		setflag(Z->status, ST_USECACHE);
		Z->edit.EdOffset = GetDestOffset(Z);
		Z->src++;
		Z->edit.cache.srcptr = Z->src;
	}
	*Z->dst = '\0';
	switch( *Z->src++ ){
						//----- NULL	 --------------------------
		case '\0':
			Z->src--;
			break;
						//----- %"		^CgύX ------------------
		case '\"':
			SetTitleMacro(Z);
			break;
						//----- %#		Ώۃt@C ----------------
		case '#':
			EnumEntries(Z);
			break;
						//----- %'		A_exec / ϐQ ---------
		case '\'':
			ZExpandAlias(Z);
			break;
						//----- %*		֐E֐W[
		case '*':
			if ( ZFunction(Z) == NO_ERROR ) break;
			return ZMC_BREAK;

		case '0':		//----- %0		PPx fBNg --------------
		case '1':			//	%1	J[\ʒũfBNg
		case '2':			//	%2	J[\̔ΈʒufBNg
		case '3':			//	%3	*pack Ŏgp
		case '4':			//	%4	*pack Ŏgp
			setflag(Z->status, ST_PATHITEM);
			GetValue(Z, *(Z->src - 1), Z->dst);
			Z->dst += tstrlen(Z->dst);
			break;
						//----- %&	IR[hŔf ----------------
		case '&':
			return ZExecAndCheckError(Z);
						//----- %:		R}h؂ ----------------
		case ':':
			if ( Z->flags & XEO_DISPONLY ){		// \̂
				*Z->dst++ = ':';
				break;
			}else{					// s
				ZExec(Z);
				if ( Z->result != NO_ERROR ) { ZErrorFix(Z); return ZMC_BREAK; }
				ZInitSentence(Z);
				return ZMC_CONTINUE;
			}

		case 'C':		// %C		Ώۃt@C ------------
		case 'X':		// %X	Ώۃt@CgqȂ --------
		case 'T':		// %T	Ώۃt@Cgq̂ --------
			ZGetName(Z, Z->dst, '\0');
			Z->dst += tstrlen(Z->dst);
			break;
						//----- %D		PPx̃pX擾 ------------
		case 'D':
			GetPPxPath(Z);
			break;
						//----- %E		p[^ ----------------
		case 'E':
			Z->edit.EdOffset = GetDestOffset(Z);
			break;
						//----- %F		 ----------------
		case 'F':
			ZGetName(Z, Z->dst, '\0');
			if ( Z->func.quotation ) ZQuotationDoubler_Buf(Z);
			Z->dst += tstrlen(Z->dst);
			break;
						//----- %G		 ----------------
		case 'G':
			ZGetMessageText(Z);
			break;
						//----- %H		qXg[Ăяo ------------
		case 'H':
			LoadHistory(Z, PPXH_GENERAL | PPXH_COMMAND);
			break;

		case 'I':		//	%I	񃁃bZ[W{bNX
		case 'J':		//	%J	Ggړ
		case 'K':		//	%K	R}h
		case 'Q':		//	%Q	mFbZ[W{bNX
		case 'Z':		//	%Z	ShellExecute Ŏs
		case 'j':		//	%j	pXWv
		case 'k':		//	%k	R}h
		case 'v':		//	%v	PPV ŕ\
		case 'z':		//	%z	ShellContextMenu Ŏs
			if ( Z->flags & XEO_DISPONLY ){	// \
				*Z->dst++ = '%';
				*Z->dst++ = *(Z->src - 1);
			}else{
				ZExec(Z);
				if ( Z->result != NO_ERROR ) { ZErrorFix(Z); return ZMC_BREAK; }
				ZInitSentence(Z);
				Z->command = *(Z->src - 1);
				SkipSpace(&Z->src);
			}
			break;

		case 'L':		//	%Ln	PPv ̘_s ----------------
		case 'l':		//	%ln	PPv ̕\s ----------------
			ZGetPPvCursorPos(Z);
			break;
						//----- %M		⏕j[^gq ------
		case 'M':
			if ( MenuCmd(Z) ) return ZMC_CONTINUE;
			break;
						//----- %N		PPxHWND擾 ------------
		case 'N':
			GetPPxHWND(Z);
			break;
						//----- %O		IvVĐݒ --------------
		case 'O':
			ZReadOption(Z);
			break;
						//----- %P		pXEt@C ----------
		case 'P':
			setflag(Z->status, ST_PATHITEM | ST_PATHFIX);
			Z->edit.EdOffset = GetDestOffset(Z);
			break;

		case 'R':		//----- %R		J[\ʒut@C --------
		case 'Y':			//	%Y	J[\ʒůgqȂ ------
			setflag(Z->status, ST_PATHITEM);
			// %t 
		case 't':			//	%t	J[\ʒůgq̂ ------
			GetCursorFileName(Z);
			break;
						//------ %S		fBNgꍇ̕-
		case 'S':
			ZStringOnDir(Z);
			break;
						//----- %W		Window Caption擾 ------------
		case 'W':
			ZGetWndCaptionMacro(Z);
			break;
						//----- %\		\ ̕t ----------------------
		case '\\':
			ZAddSeparator(Z);
			break;
						//----- %@		X|Xt@C Ή %C ----
		case '@':
			*Z->dst++ = '@';
			// %a 
		case 'a':		//----- %a		X|Xt@C Ή %C ----
			setflag(Z->status, ST_PATHITEM);
			if ( CreateResponseFile(Z) == FALSE ) return ZMC_BREAK;
			break;
						//----- %b		sGXP[vE} ------
		case 'b':
			LineEscape(Z);
			break;
						//----- %e		sҏW̐ݒύX ------------
		case 'e':
			SetEditMode(Z);
			break;
						//----- %g		A_execWJ
		case 'g':
			ZExpandAliasWithExtract(Z);
			break;
						//----- %h		qXg[Ăяo ------------
		case 'h':
			LoadHistory(Z, PPXH_PPCPATH);
			break;
						//----- %m		ǉ(Ȃ) ----------
		case 'm':
			ZMemo(Z);
			return ZMC_CONTINUE;
						//----- %n		RegID 擾 ------------
		case 'n':
			GetPPxID(Z);
			break;
						//----- %s		ϐ
		case 's':
			return ZStringVariable(Z, &Z->src, StringVariable_function);
						//----- %u	UnXXX s ------------------
		case 'u':
			if ( Z->flags & XEO_DISPONLY ){	// \
				*Z->dst++ = '%';
				*Z->dst++ = 'u';
			}else{
				ZExec(Z);
				if ( Z->result != NO_ERROR ){
					ZErrorFix(Z);
					return ZMC_BREAK;
				}
				ZInitSentence(Z);
				Z->command = 'u';
			}
			break;
						//----- %{		ҏWwJn --------------
		case '{':
			Z->edit.EdOffset = -1; // %$ ł̕ҏW𖳌ɂ
			Z->edit.EdPartStart = GetDestOffset(Z);
			Z->edit.CsrStart = 0;
			Z->edit.CsrEnd = -1;
			break;
						//----- %|		J[\ʒuw --------------
		case '|':
			if ( Z->edit.CsrEnd == -1 ){	// 1st:wʒuɃJ[\
				Z->edit.CsrStart = Z->edit.CsrEnd = GetDestOffset(Z) - Z->edit.EdPartStart;
			}else{					// 2nd:w͈͂I
				Z->edit.CsrStart = Z->edit.CsrEnd;
				Z->edit.CsrEnd = GetDestOffset(Z) - Z->edit.EdPartStart;
			}
			break;
						//----- %}		ҏWwI --------------
		case '}':
			Z->edit.EdOffset = Z->edit.EdPartStart;
			break;
						//----- %~		Αe擾 ----------------
		case '~':
			GetPairMacro(Z);
			break;
						//----- `	̕g ------------------
		default:
			*Z->dst++ = *(Z->src - 1);
	}

	if ( (Z->edit.EdOffset >= 0) && !(Z->flags & (XEO_DISPONLY | XEO_NOEDIT)) ){
		if ( EditExtractText(Z) == FALSE ) return ZMC_BREAK; // %!x ҏW
	}
	return ZMC_CONTINUE;
}

// Z ̏ -----------------------------------------------------------------
void ZInitSentence(EXECSTRUCT *Z)
{
	Z->command = CID_FILE_EXEC;
	Z->dst = Z->DstBuf;
	Z->edit.EdPartStart = 0;
	Z->edit.CsrStart = 0;
	Z->edit.CsrEnd = -1;
	Z->func.off = 0;
	Z->func.quotation = FALSE;
}

/*-----------------------------------------------------------------------------
	hWnd		eEBhE
	pos			EBhE\鎞ɗpXN[WBNULLȂhWnd(0, 0)
	param		p[^(ASCIIZ)
	extract		WJBKvȂ NULL ł悢B
	flag		eݒ
	߂l		NO_ERROR:I
				259(ERROR_NO_MORE_ITEMS):󗓏I
				ERROR_CANCELLED :LZ
-----------------------------------------------------------------------------*/
PPXDLL ERRORCODE PPXAPI PP_ExtractMacro(HWND hWnd, PPXAPPINFO *ParentInfo, POINT *pos, const TCHAR *param, TCHAR *extract, int flags)
{
	EXECSTRUCT Z;
										// ŏ̏ -----------------------
	ThInit(&Z.ExtendDst);
	ThInit(&Z.ExpandCache);
	ThInit(&Z.StringVariable);
	Z.hWnd = hWnd;
	Z.posptr = pos;
	Z.Info = (ParentInfo != NULL) ? ParentInfo : &PPxDefInfo;
	Z.oldsrc = NULL;
	Z.extract = extract;
	Z.status = 0;
	Z.result = NO_ERROR;
	Z.curdir[0] = '\0';
	Z.useppb = -1;
	Z.edit.cache.hash = MAX32;

	PPxEnumInfoFunc(Z.Info, PPXCMDID_STARTENUM, Z.DstBuf, &Z.EnumInfo);
#ifdef WINEGCC
	setflag(flags, XEO_NOUSEPPB);
#endif
	for (;;){		// R}hC ----------------
		Z.flags = flags;
		Z.status = Z.status & ST_MASK_FIRSTCMDLINE;
		Z.src = param;
		Z.ExtendDst.top = 0;
		ZInitSentence(&Z);
										// 1̓ : ͊Jn -----------------
		for (;;){
			if ( *Z.src == '\0' ){ // src  nested ߂
				if ( Z.oldsrc == NULL ) break;
				RestoreSrc(&Z);
				continue;
			}
											// *R}h / A_exec R}h
			if ( (Z.dst == Z.DstBuf) &&
				 (Z.ExtendDst.top == 0) &&
				 (Z.command == CID_FILE_EXEC) &&
				 !(Z.flags & XEO_DISPONLY) &&
				 ((extract == NULL) || (Z.flags & XEO_EXTRACTEXEC)) ){
				int cmdr = GetCommandString(&Z);
				if ( cmdr != GCS_NOCMD ){
					if ( cmdr == GCS_GOTO ){
						if ( CmdGoto(&Z, param) == FALSE ) break;
					}
					continue;
				}
			}else if ( (Z.dst - Z.DstBuf) >= (CMDLINESIZE - 1) ){ // 
				if ( StoreLongParam(&Z, 0) == FALSE ){
					Z.result = RPC_S_STRING_TOO_LONG;
					PPErrorBox(Z.hWnd, NULL, RPC_S_STRING_TOO_LONG);
					break;
				}
			}

			if ( *Z.src == '\"' ) Z.func.quotation = !Z.func.quotation;

			if ( ((UTCHAR)(*Z.src) < ' ') &&			// s
				 ((*Z.src == '\n') || (*Z.src == '\r')) &&
				 !(Z.flags & XEO_INRETURN) ){
				do {
					Z.src++;
				} while ( (*Z.src == '\n') || (*Z.src == '\r') );
				if ( Z.flags & XEO_DISPONLY ){		// \̂
					*Z.dst++ = ':';
				}else{					// s
					*Z.dst = '\0';
					ZExec(&Z);
					if ( Z.result != NO_ERROR ) {
						ZErrorFix(&Z);
						goto execbreak;
					}
					ZInitSentence(&Z);
				}
				continue;
			}

			if ( *Z.src != '%' ){				// '%' ȊO͂̂܂ܕ
				*Z.dst++ = *Z.src++;
				continue;
			}
			if ( ZMacroCharacter(&Z) == ZMC_BREAK ) break;
			if ( Z.result == NO_ERROR ) continue;
			if ( extract != NULL ) *extract = '\0';
			goto execbreak;
		} // S̓WJ
		*Z.dst = '\0';

		if ( extract != NULL ){	// WJ
			if ( Z.result != NO_ERROR ){
				*extract = '\0';
				break; // G[L
			}
			if ( (Z.ExtendDst.top != 0) ||
				 ((Z.dst - Z.DstBuf) >= CMDLINESIZE) ){ // 
				SetLongParamToParam(&Z, (LONGEXTRACTPARAM *)extract);
			}else{
				memcpy(extract, Z.DstBuf, (Z.dst - Z.DstBuf + 1) * sizeof(TCHAR) );
			}
			break;
		}						// s
		if ( Z.result != NO_ERROR ) break; // G[L
		ZExec(&Z);
		if ( Z.result != NO_ERROR ) break; // ZErrorFix sv (*returnsv)

		// ̃}[N邩f
		if ( (Z.flags & XEO_EXECMARK) && !(Z.flags & XEO_NOEXECMARK) ){
			if ( !(Z.status & (ST_NO_NEXTENUM | ST_LOOPEND)) ){
				if ( PPxEnumInfoFunc(Z.Info, PPXCMDID_NEXTENUM, Z.DstBuf, &Z.EnumInfo) == 0 ){
					break;
				}
			}else{ // %#, %@ ͊ PPXCMDID_NEXTENUM sς
				if ( Z.status & ST_LOOPEND ) break;
			}
			// }[N̂ōēxR}hC
			setflag(Z.status, ST_2ndLOOP);
			Freeoldsrc(&Z);

			if ( Z.result == NO_ERROR ) continue;
			if ( Z.result == RPC_S_STRING_TOO_LONG ){
				PPErrorBox(Z.hWnd, NULL, RPC_S_STRING_TOO_LONG);
			}
		}
		break;
	}
execbreak:
	PPxEnumInfoFunc(Z.Info, PPXCMDID_ENDENUM, Z.DstBuf, &Z.EnumInfo);

	if ( Z.flags & (XEO_DELTEMP | XEO_DOWNCSR) ){
		if ( (extract == NULL) && (Z.flags & XEO_DELTEMP) ){
			const TCHAR *ResName;

			ResName = ThGetString(&Z.StringVariable, ResponseName_ValueName, NULL, 0);
			if ( ResName != NULL ) DeleteFileL(ResName);
		}
		if ( (Z.flags & XEO_DOWNCSR) && (Z.result == NO_ERROR) ){
			PostMessage(Z.hWnd, WM_PPXCOMMAND, K_raw | K_dw, 0);
		}
	}

	ThFree(&Z.StringVariable);
	ThFree(&Z.ExpandCache); // %M ̃LbV
	ThFree(&Z.ExtendDst);
	Freeoldsrc(&Z);
	if ( Z.useppb != -1 ) FreePPb(Z.hWnd, Z.useppb);
	return Z.result;
}
/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
BOOL IsCmdNul(TCHAR *cmdbuf)
{
	if ( cmdbuf[0] == '\0' ) return TRUE;
	if ( cmdbuf[1] == '\0' ){
		if ( ((UTCHAR)cmdbuf[0] == EXTCMD_CMD) ||
			 ((UTCHAR)cmdbuf[0] == EXTCMD_KEY) ){
			return TRUE;
		}
	}
	return FALSE;
}

PPXDLL int PPXAPI PP_GetExtCommand(const TCHAR *src, const TCHAR *ID, TCHAR *cmdbuf, TCHAR *TypeName)
{
	VFSFILETYPE vft;
	int count = 0;
	TCHAR kword[CUST_NAME_LENGTH], name[VFPS];
	BYTE *filebuf;
	const TCHAR *namep, *extp;
	DWORD hsize = 0;
	HANDLE hFile;
	FN_REGEXP fn;
	int result = PPEXTRESULT_FILE;
	BOOL dir = FALSE;
	ERRORCODE errresult;

	cmdbuf[0] = '\0';
	filebuf = HeapAlloc(DLLheap, 0, VFS_check_size);
	if ( filebuf == NULL ) return PPEXTRESULT_NONE;

										// t@C̓eŔ ---------------
	vft.flags = VFSFT_TYPE | VFSFT_STRICT;
	vft.type[0] = '\0';

	if ( TypeName != NULL ){
		if ( TypeName == (TCHAR *)FILE_ATTRIBUTE_DIRECTORY ){
			TypeName = NULL;
			dir = TRUE;
		}else if ( tstrstr(src, T(".{")) != NULL ){
			result = PPEXTRESULT_CLSID;
		}
	}

	hFile = CreateFileL(src, GENERIC_READ,
			FILE_SHARE_WRITE | FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if ( hFile != INVALID_HANDLE_VALUE ){
		hsize = ReadFileHeader(hFile, filebuf, VFS_check_size);
		CloseHandle(hFile);

		if ( (hsize != 0) && (TypeName != NULL) ){ // t@CȂfBNgǂ̒s
			if ( (hsize > 100) && (*filebuf == 0x4c) &&
					(*(filebuf + 1) == 0) && (*(filebuf + 2) == 0) ){
				result = PPEXTRESULT_LINK;
			}else{
				tstrcpy(name, src);

				if ( VFSCheckDir(name, filebuf, hsize, NULL) ){
					result = PPEXTRESULT_VFSDIR;
				}
			}
		}
	}

	errresult = VFSGetFileType(src, (char *)filebuf, hsize, &vft);
	HeapFree(DLLheap, 0, filebuf);

	namep = FindLastEntryPoint(src);
	extp = namep + FindExtSeparator(namep);

	if ( errresult == NO_ERROR ){
		if ( TypeName != NULL ) tstrcpy(TypeName, vft.type);

		if ( GetCustDword(T("X_exts"), 0) == 0 ){
			if ( *extp == '.' ){				// gq
				thprintf(name, TSIZEOF(name), T("%s%s"), vft.type, extp);
				if ( NO_ERROR == GetCustTable(ID, name, cmdbuf, TSTROFF(CMDLINESIZE)) ){
					if ( !IsCmdNul(cmdbuf) ) return result; // 󗓂Ȃȍ~̖Oʂ
				}
			}

			if ( NO_ERROR == GetCustTable(ID, vft.type, cmdbuf, TSTROFF(CMDLINESIZE)) ){
				if ( !IsCmdNul(cmdbuf) ) return result; // 󗓂Ȃȍ~̖Oʂ
			}
			vft.type[0] = '\0'; // eʂłȂ̂ŖOʂ
		}
	}
										// t@CEgq̒o -----------
	if ( *extp == '.' ){				// gq
		extp++;
		if ( TypeName != NULL ) tstrcpy(TypeName, extp);
	}else{								// gqȂ
		tstrcpy(name, namep);
		tstrcat(name, T("."));
		namep = name;
		if ( TypeName != NULL ) tstrcpy(TypeName, name);
	}
										// t@CŔ -------------------
	for ( ; EnumCustTable(count, ID, kword, cmdbuf, ISCMDNULREQUEIERSIZE) >= 0 ; count++ ){ // 
		if ( kword[0] == ':' ){ // t@Ceʂ
							// ʂŔς or ʖȂ̂Ŏ
			if ( vft.type[0] == '\0' ) continue;
			if ( !IsCmdNul(cmdbuf) && !tstricmp(kword, vft.type) ) goto enumhit;
		}else if ( kword[0] == '/' ){ // ChJ[hw
			int fnresult;

			MakeFN_REGEXP(&fn, kword + 1);
			fnresult = FilenameRegularExpression(namep, &fn);
			FreeFN_REGEXP(&fn);
			if ( fnresult ) goto enumhit;
		}
		if ( tstrchr(kword, '.') ){			// OŔ
			if ( !tstricmp(kword, namep) ) goto enumhit;
		}else{								// gqŔ
			if ( !tstricmp(kword, extp) ) goto enumhit;
		}
	}
	if ( (*extp == '\0') &&
		 (NO_ERROR == GetCustTable(ID, T("."), cmdbuf, TSTROFF(CMDLINESIZE))) ){
		return result;
	}
	if ( dir && (NO_ERROR == GetCustTable(ID, T(":DIR"), cmdbuf, TSTROFF(CMDLINESIZE))) ){
		return result;
	}
	if ( NO_ERROR == GetCustTable(ID, WildCard_All, cmdbuf, TSTROFF(CMDLINESIZE)) ){
		return result;
	}
	if ( result != PPEXTRESULT_FILE ) return -result;
	return PPEXTRESULT_NONE;

enumhit:
	EnumCustTable(count, ID, kword, cmdbuf, TSTROFF(CMDLINESIZE));
	return result;
}

// %# {
void EnumEntries(EXECSTRUCT *Z)
{
	BOOL useopt = FALSE;
	const TCHAR *oldsrc;
	const TCHAR *ptr;
	TCHAR separator = ' ', buf[VFPS];
	int maxentries = 0xfffffff;
	DWORD maxlen;

	oldsrc = Z->src;
	if ( Isdigit(*oldsrc) ) maxentries = GetDigitNumber(&oldsrc);

	if ( (UTCHAR)*oldsrc > ' ' ){
		if ( !Isalnum(*oldsrc) ){
			separator = *oldsrc++;
		}else if ( *oldsrc == 'n' ){
			separator = '\n';
			oldsrc++;
			setflag(Z->flags, XEO_INRETURN);
		}
	}
	if ( (UTCHAR)*oldsrc > ' ' ){
		useopt = TRUE;
		oldsrc++;
	}
											// ő咷߂
	maxlen = GetLongParamMaxLen(Z) - (1 + 3);
	// i̕񂪎c悤ɖ
	ptr = Z->src;
	while ( ((UTCHAR)(*ptr) >= ' ') || ((*ptr != '\n') && (*ptr == '\r')) ){ // sȊO
		if ( *ptr == '%' ){
			if ( *(ptr + 1) == '%' ){
				ptr++;
			}else if ( *(ptr + 1) == ':' ){
				break; // R}h؂
			}else {
				DWORD dstlength;

				maxlen -= 100; // ̊mە
				dstlength = Z->dst - Z->DstBuf;
				if ( maxlen < dstlength ){
					maxlen = dstlength;
					break;
				}
			}
		}
		ptr++;
		maxlen--;
	}
	setflag(Z->status, ST_CHKSDIRREF);
	for ( ; ; ){
		size_t len;
		size_t dstlen;

		Z->src = oldsrc;
		if ( IsTrue(useopt) ){
			if ( (*(oldsrc - 1) == 'F') &&
				 PPxEnumInfoFunc(Z->Info, PPXCMDID_ENUMATTR, buf, &Z->EnumInfo) &&
				 (*(DWORD *)buf & FILE_ATTRIBUTE_DIRECTORY) ){
				setflag(Z->status, ST_SDIRREF);
			}
			ZGetName(Z, buf, '\0'); // ST_SDIRREF ́A%F ̂Ƃɂ͂Ȃ
			if ( Z->func.quotation != FALSE ) tstrreplace(buf, T("\""), T("\"\""));
		}else{
			ZGetName(Z, buf, 'C'); // ST_SDIRREF 
		}

		len = tstrlen32(buf);
		dstlen = (Z->dst - Z->DstBuf) + len;
		if ( (Z->ExtendDst.top + dstlen ) >= maxlen ) break; // 傫z
		if ( dstlen >= CMDLINESIZE ){
			if ( StoreLongParam(Z, 0) == FALSE ) break; // ȏWJȂ
		}
		if ( (buf[0] != '\"') && (tstrchr(buf, separator)) != NULL ){
			Z->dst = thprintf(Z->dst, CMDLINESIZE, T("\"%s\""), buf);
		}else{
			tstrcpy(Z->dst, buf);
			Z->dst += len;
		}
		if ( PPxEnumInfoFunc(Z->Info, PPXCMDID_NEXTENUM, buf, &Z->EnumInfo) == 0 ){
			setflag(Z->status, ST_LOOPEND);
			break;
		}
		if ( --maxentries == 0 ) break;
		if ( separator == '\n' ){
			*Z->dst++ = '\r';
			*Z->dst++ = '\n';
		}else{
			*Z->dst++ = separator;
		}
		*Z->dst = '\0';
	}
	setflag(Z->status, ST_NO_NEXTENUM);
}

DWORD GetCacheHash(EXECSTRUCT *Z)
{
	const TCHAR *plast, *srcptr;
	DWORD hash = 0;

	srcptr = Z->edit.cache.srcptr;
	plast = Z->src;
	if ( (plast - srcptr) > CMDLINESIZE ){
		size_t len = tstrlen(srcptr);
		if ( len < (size_t)(plast - srcptr) ){
			plast = srcptr + len;
		}
	}
	for ( ; srcptr < plast ; srcptr++ ) hash += *srcptr;
	return hash;
}

// ҏWs
BOOL EditExtractText(EXECSTRUCT *Z)
{
	TINPUT tinput;
	DWORD hash C4701CHECK;

	if ( Z->ExtendDst.top == 0 ){
		*Z->dst = '\0';
		tinput.buff = Z->DstBuf + Z->edit.EdOffset;
		tinput.size = CMDLINESIZE - ToSIZE32_T(Z->dst - Z->DstBuf) - 1;
	}else{
		if ( StoreLongParam(Z, 0) == FALSE ) return FALSE;
		tinput.size = Z->ExtendDst.size / sizeof(TCHAR) - Z->edit.EdOffset;
		if ( tinput.size >= 0x8000 ) tinput.size = 0x7fff;
		tinput.buff = (TCHAR *)Z->ExtendDst.bottom + Z->edit.EdOffset;
	}

	if ( (Z->status & ST_USECACHE) &&
		 (Z->edit.cache.hash == (hash = GetCacheHash(Z))) ){
		// LbVgpł
		ThGetString(&Z->StringVariable, EditCache_ValueName, tinput.buff, tinput.size);
	}else{
		tinput.title	= ZGetTitleName(Z);
		tinput.flag		= TIEX_USESELECT | TIEX_USEINFO;
		tinput.firstC	= Z->edit.CsrStart;
		tinput.lastC	= Z->edit.CsrEnd;
		if ( ZTinput(Z, &tinput) == FALSE ) return FALSE;
		// 1.79+1  ST_PATHFIX  ST_PATHFIX / ST_PATHITEM ɕĂ݂
		if ( Z->status & ST_PATHFIX ){
			VFSFixPath(NULL, tinput.buff, GetZCurDir(Z), VFSFIX_VFPS);
		}

		if ( Z->status & ST_USECACHE ){
			Z->edit.cache.hash = hash; // C4701ok
			ThSetString(&Z->StringVariable, EditCache_ValueName, tinput.buff);
		}
	}
	if ( Z->ExtendDst.top != 0 ){
		Z->ExtendDst.top = (Z->edit.EdOffset + tstrlen(tinput.buff)) * sizeof(TCHAR);
	}else{
		Z->dst = tinput.buff + tstrlen(tinput.buff);
	}
	resetflag(Z->status, ST_USECACHE);
	Z->edit.EdPartStart = GetDestOffset(Z);
	Z->edit.CsrStart = 0;
	Z->edit.CsrEnd = -1;
	return TRUE;
}
