/*-----------------------------------------------------------------------------
	Paper Plane cUI					Directoryǂݍ - 񓯊ǂݍ
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include <commctrl.h>
#include "PPX.H"
#include "VFS.H"
#include "PPC_STRU.H"
#include "PPC_FUNC.H"
#include "PPCOMBO.H"
#include "FATTIME.H"
#pragma hdrstop

/*
	dirty == TRUE Ȃ玩p
	result == NO_ERROR Ȃf[^L
*/
#define SAVE_REPORT RENTRYI_CACHE // ʒmflag(ǂݍ݊ɒʒm)
#define SAVE_DUMP RENTRYI_SAVECACHE // ۑflag(fBXNۑ)
#define SAVE_REFRESHCACHE RENTRYI_REFRESHCACHE // XVflag(ǂݍ݊ɕۑ)

#define FFASTATE_COMPLETE B0 // ǂݍ݊
#define FFASTATE_CACHE B1 // Pxgpς݁BLbVp
#define FFASTATE_ENABLEFREE B2 // FreeFfa ŔpĂ悢(ǂݍ݊痧)
#define USEMEMCACHETIME 40 // LbVɕۑƂ̔fɎgms

const TCHAR FindFirstAsyncThreadName[] = T("Async dir read");

typedef struct tagFindFirstAsync{
	struct tagFindFirstAsync *next;	// `F[p
	ERRORCODE result;		// 
	volatile int ref;		// QƐ
	volatile int save;		// SAVE_xxx
	volatile BOOL dirty;	// ɌÂeɂȂ
	DWORD state;			// FFASTATE_
	DWORD count;			// ǂݍݍς݂̃Gg
	HANDLE hFind;			// VFSFindFirst ̃nh(ListFilêƂɎgp)
	TM_struct files;		// ǂݍ񂾓e
	TCHAR path[VFPS];		// TfBNg

	HWND hWnd;				// ʒm NULL == ΏۂȂ
	LPARAM lParam;			// ʒm惁bZ[W(cinfo->LoadCounter)
	DWORD LastTick;			// ǂݍ݊̎(pp)
	DWORD ReadTick;			// ǂݍ݂Ɋ|(pfp)

	VFSDIRTYPEINFO Dtype;
} FINDFIRSTASYNC;

typedef struct {
  FINDFIRSTASYNC *ffa;
  WIN32_FIND_DATA *read;
  DWORD count;
} FINDFIRSTASYNCHEAP;

FINDFIRSTASYNC *FindFirstAsyncList = NULL;

const TCHAR GetCache_PathStr[] = T("%s\\%08X");
const char  GetCache_CacheStrA[] = LHEADER ";Base=";
#define GetCache_CacheStrASize (sizeof(GetCache_CacheStrA) - 1)

const WCHAR GetCache_CacheStrW[] = UNICODESTR(LHEADER) L";Base=";
#define GetCache_CacheStrWSize (sizeof(GetCache_CacheStrW) - sizeof(WCHAR))

// *cache task {
void DirTaskCommand(PPC_APPINFO *cinfo)
{
	HMENU hMenu;
	TCHAR buf[VFPS * 2];
	FINDFIRSTASYNC *sffa;

	int count = 0;

	hMenu = CreatePopupMenu();

	EnterCriticalSection(&FindFirstAsyncSection);
	sffa = FindFirstAsyncList;
	while ( sffa != NULL ){
		thprintf(buf, TSIZEOF(buf), T("%d:%d %dentries(%d) %dms ref:%d%s%s%s %s"),
			sffa->LastTick, sffa->result, // ID: result
			sffa->count, sffa->files.s, // entries (size)
			sffa->ReadTick,
			sffa->ref,
			(sffa->state & FFASTATE_COMPLETE) ? NilStr : T("(read)"),
			(sffa->state & FFASTATE_CACHE) ? T("(cache)") : NilStr,
//			(sffa->hWnd != NULL) ? T("(used)") : NilStr,
			IsTrue(sffa->dirty) ? T("(dirty)") : NilStr,
			sffa->path);

		AppendMenuString(hMenu, ++count, buf);

		sffa = sffa->next;
	}
	LeaveCriticalSection(&FindFirstAsyncSection);

	if ( count == 0 ) AppendMenuString(hMenu, 0, T("No task"));

	PPcTrackPopupMenu(cinfo, hMenu);
	DestroyMenu(hMenu);
}

BOOL GetCache_Path(TCHAR *filename, const TCHAR *dpath, int *type)
{
	TCHAR basedir[VFPS], *tail, dirpath[VFPS];
	HANDLE hFile;
	int subid = 0;

	tstrcpy(dirpath, dpath);
	tail = tstrchr(dirpath, '*');
	if ( tail != NULL ) *(tail - 1) = '\0';

	basedir[0] = '\0';
	GetCustData(T("X_cache"), basedir, VFPS);
	if ( basedir[0] == '\0' ){
		MakeTempEntry(VFPS, basedir, 0);
		tstrcat(basedir, T("cache"));
		MakeDirectories(basedir, NULL);
	}else{
		VFSFixPath(NULL, basedir, PPcPath, VFSFIX_FULLPATH | VFSFIX_REALPATH);
	}
	tail = thprintf(filename, VFPS, GetCache_PathStr, basedir, crc32((const BYTE *)dirpath, MAX32, 0));
	tstrcpy(tail, T(".txt"));
	for ( ; ; ){				// base vt@C߂
		DWORD size;
		BYTE temp[VFPS * sizeof(WCHAR) + sizeof(GetCache_CacheStrW)];
		TCHAR text[VFPS + 100], *basepath;

		hFile = CreateFileL(filename, GENERIC_READ,
				FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
				OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
		if ( hFile == INVALID_HANDLE_VALUE ) return FALSE;
		if ( FALSE == ReadFile(hFile, temp, sizeof(temp)-2, &size, NULL) ) size = 0;
		temp[size] = 0;
		temp[size + 1] = 0;
		CloseHandle(hFile);
		#pragma warning(suppress: 6385) // 0 ݂Ō듮h~ς
		if ( !memcmp(temp, GetCache_CacheStrA, GetCache_CacheStrASize) ){
#ifdef UNICODE
			AnsiToUnicode((char *)(temp + GetCache_CacheStrASize), text, VFPS);
			text[VFPS - 1] = '\0';
			basepath = text;
#else
			basepath = (char *)(temp + GetCache_CacheStrASize);
#endif
		}else if ( !memcmp(temp + 2, GetCache_CacheStrW, GetCache_CacheStrWSize) ){
#ifdef UNICODE
			basepath = (WCHAR *)(temp + 2 + GetCache_CacheStrWSize);
#else
			UnicodeToAnsi((WCHAR *)(temp + 2 + GetCache_CacheStrWSize), text, VFPS);
			text[VFPS - 1] = '\0';
			basepath = text;
#endif
		}else{
			basepath = NULL;
		}
		if ( basepath != NULL ){
			TCHAR *typeptr = NULL, *ptr;

			// ;Base= path|type  |type  SearchVLINE ֘A
			ptr = basepath;
			for ( ;; ){
				TCHAR type;

				type = *ptr;
				if ( (type == '\0') || (type == '\r') || (type == '\n') ){
					break;
				}
				if ( type != '|' ){
					#ifdef UNICODE
						ptr++;
					#else
						ptr += (char)Chrlen(type);
					#endif
					continue;
				}else{
					typeptr = ptr++;
				}
			}
			if ( typeptr != NULL ){
				*typeptr++= '\0';
				if ( tstrcmp(basepath, dirpath) == 0 ){
					if ( type != NULL ) *type = GetIntNumber((const TCHAR **)&typeptr);
					return TRUE;
				}
			}
		}
		// ̃t@CłȂ̂Ŏɂ
		thprintf(tail, 20, T("%d.txt"), subid++);
	}
}

// LbVv(񓯊) && ȃfBNgȊOȂ
// LbVۑB
void DumpCache(FINDFIRSTASYNC *ffa)
{
	HANDLE hFile;
	TCHAR name[VFPS];
	int trycounter = 10;

	if ( !(ffa->save & SAVE_DUMP) ) return;	// ۑKvȂ
	// hCuXgAXgt@C͕ۑ̑ΏۊO
	if ( (ffa->Dtype.mode == VFSDT_DLIST) ||
		 (ffa->Dtype.mode == VFSDT_LFILE) ){
		return;
	}
	GetCache_Path(name, ffa->path, NULL);
	for ( ; ; ){ // ERROR_SHARING_VIOLATION ̂Ƃ͏҂Ă݂
		ERRORCODE error;

		hFile = CreateFileL(name, GENERIC_WRITE,
				FILE_SHARE_WRITE | FILE_SHARE_READ, NULL, CREATE_ALWAYS,
				FILE_FLAG_SEQUENTIAL_SCAN, NULL);
		if ( hFile != INVALID_HANDLE_VALUE ) break;
		error = GetLastError();
		if ( error != ERROR_SHARING_VIOLATION ){
			PPErrorBox(NULL, CacheErrorTitle, error);
			break;
		}
		if ( trycounter-- == 0 ) break;
		Sleep(50);
	}
	if ( hFile != INVALID_HANDLE_VALUE ){
		DWORD size;
		WIN32_FIND_DATA *ff;
		int count;
		TCHAR bb[32];
#ifdef UNICODE
		WriteFile(hFile, UCF2HEADER, UCF2HEADERSIZE, &size, NULL);
		WriteFile(hFile, GetCache_CacheStrW, GetCache_CacheStrWSize, &size, NULL);
#else
		WriteFile(hFile, GetCache_CacheStrA, GetCache_CacheStrASize, &size, NULL);
#endif
		WriteFile(hFile, ffa->path, TSTRLENGTH32(ffa->path), &size, NULL);
		size = thprintf(bb, TSIZEOF(bb), T("|%d\r\n"), ffa->Dtype.mode) - bb;

		WriteFile(hFile, bb, TSTROFF32(size), &size, NULL);

		ff = (WIN32_FIND_DATA *)ffa->files.p;
		count = ffa->count;
		while ( count ){
			if ( !IsRelativeDir(ff->cFileName) ){
				WriteFF(hFile, ff, ff->cFileName);
			}
			ff++;
			count--;
		}
		CloseHandle(hFile);
	}
}

void FreeFfa(FINDFIRSTASYNC *ffa)
{
	EnterCriticalSection(&FindFirstAsyncSection);

	if ( (ffa->state & FFASTATE_ENABLEFREE) && (ffa->ref <= 0) ){
		if ( FindFirstAsyncList != NULL ){ // N̒
			if ( FindFirstAsyncList == ffa ){
				FindFirstAsyncList = ffa->next;
			}else{
				FINDFIRSTASYNC *ffalink;

				ffalink = FindFirstAsyncList;
				for (;;){
					if ( ffalink->next == NULL ) break; // XgɓĂȂ̂ł̂܂܍폜
					if ( ffalink->next == ffa ){
						ffalink->next = ffa->next; // ؂藣
						break;
					}
					ffalink = ffalink->next;
				}
			}
		}
		if ( ffa->hFind != NULL ) VFSFindClose(ffa->hFind);
		TM_kill(&ffa->files);
		PPcHeapFree(ffa);

	}else{ // Xbh܂Ă̂Ŕpw
		ffa->hWnd = NULL; // ʒm~
		ffa->path[0] = '\0'; // ΏۊO
		ffa->dirty = TRUE; // pw
	}

	LeaveCriticalSection(&FindFirstAsyncSection);
}

void USEFASTCALL GetDtypeInfo(HANDLE hFind, VFSDIRTYPEINFO *Dtype)
{
	VFSGetFFInfo(hFind, &Dtype->mode, Dtype->Name, &Dtype->ExtData);
}

void MakeAuxFFPath(TCHAR *maked, const TCHAR *src, HWND hWnd)
{
	TCHAR *dest;
	PPC_APPINFO *cinfo;

	CatPath(maked, (TCHAR *)src, NilStr);
	dest = maked + tstrlen(maked);

	cinfo = (PPC_APPINFO *)GetWindowLongPtr(hWnd, GWLP_USERDATA);
	if ( cinfo == NULL ){ // ɃEBhEH
		dest[0] = '*';
		dest[1] = '\0';
	}else{
		thprintf(dest, 64, T("r%s,w%d"), cinfo->RegSubCID, hWnd);
	}
}

#define MakeFindFirstPath(maked, src, hWnd) \
	if ( (src[0] == 'a') && (src[1] == 'u') && (src[2] == 'x') && (src[3] == ':') ){ \
		MakeAuxFFPath(maked, src, hWnd); \
	}else{ \
		CatPath(maked, (TCHAR *)src, T("*")); \
	}

DWORD WINAPI FindFirstAsyncThread(FINDFIRSTASYNC *ffa)
{
	THREADSTRUCT threadstruct = {FindFirstAsyncThreadName, XTHREAD_EXITENABLE | XTHREAD_TERMENABLE, NULL, 0, 0};
	HANDLE hFind = NULL;
	ULONG_PTR structsize;
	TCHAR dirpath[VFPS + 32];

	(void)CoInitializeEx(NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE);
	PPxRegisterThread(&threadstruct);
	if ( TM_check(&ffa->files, sizeof(ENTRYCELL) * 3) == FALSE ){
		ffa->result = ERROR_NOT_ENOUGH_MEMORY;
		hFind = INVALID_HANDLE_VALUE;
	}else if ( VFSArchiveSection(VFSAS_CHECK, NULL) == 0 ){
		ffa->result = VFSTryDirectory(ffa->hWnd, ffa->path, TRYDIR_SPEEDCHECK);
		if ( (ffa->result != NO_ERROR) &&
			 (ffa->result != ERROR_INVALID_PARAMETER) &&
			 (ffa->result != ERROR_DIRECTORY) &&
			 (ffa->result != ERROR_FILE_NOT_FOUND) &&
			 (ffa->result != ERROR_PATH_NOT_FOUND) &&
			 (ffa->result != ERROR_FILE_EXISTS) ){
			hFind = INVALID_HANDLE_VALUE;
		}
	}

	if ( hFind == NULL ){									// ʏǍ
		MakeFindFirstPath(dirpath, ffa->path, ffa->hWnd);
		hFind = VFSFindFirst(dirpath, (WIN32_FIND_DATA *)ffa->files.p);

		if ( hFind == INVALID_HANDLE_VALUE ){	// s
			ffa->result = GetLastError();
		}else{
			DWORD tick = ffa->LastTick; // CreateThread tick擾

			GetDtypeInfo(hFind, &ffa->Dtype);
			ffa->count++;
			if ( ffa->Dtype.mode == VFSDT_LFILE ){
				resetflag(ffa->save, SAVE_DUMP | SAVE_REFRESHCACHE);
				ffa->hFind = hFind;
			}else{
				structsize = sizeof(WIN32_FIND_DATA);
				for ( ; ; ){
					DWORD newtick;

					if ( FALSE == VFSFindNext(hFind, (WIN32_FIND_DATA *)
							((BYTE *)ffa->files.p + structsize)) ){
						ERRORCODE error;

						error = GetLastError();
						if ( error == ERROR_MORE_DATA ){
							int chance;

							chance = 10;
							for ( ; ; ){
								Sleep(100);
								if ( FALSE != VFSFindNext(hFind, (WIN32_FIND_DATA *)
										((BYTE *)ffa->files.p + structsize)) ){
									error = NO_ERROR;
									break;
								}
								error = GetLastError();

								if ( error != ERROR_MORE_DATA ) break;
								chance--;
								if ( !chance ) break;
							}
							if ( error != NO_ERROR ) break;
						}else{
							break;
						}
					}
					if ( IsTrue(ffa->dirty) ){ // dirtyf[^Ȃ̂ŕۑEʒmȂ
						ffa->save = 0;
						break;
					}
					structsize += sizeof(WIN32_FIND_DATA);
					if ( TM_check(&ffa->files, structsize +
							sizeof(WIN32_FIND_DATA)) == FALSE ){
						break;
					}
					ffa->count++;
					newtick = GetTickCount();
					if ( (newtick - tick) >= 100 ){		// oߕ
						tick = newtick;
						if ( (ffa->save & SAVE_REPORT) && (ffa->hWnd != NULL) ){
							PostMessage(ffa->hWnd, WM_PPXCOMMAND, TMAKELPARAM
									(KC_RELOAD, min(ffa->count, 0xffff)),
									ffa->lParam);
						}
					}
				}
				VFSFindClose(hFind);
			}
			threadstruct.flag = 0;	// I֎~
			ffa->result = NO_ERROR;
			DumpCache(ffa);
		}
	}
	if ( VFSArchiveSection(VFSAS_CHECK, NULL) == 0 ){
		SetCurrentDirectory(PPcPath);
	}
	if ( ffa->dirty == FALSE ){
		DWORD ntick = GetTickCount();

		if ( ffa->result == NO_ERROR ) ffa->ReadTick = ntick - ffa->LastTick;
		ffa->LastTick = ntick;
		if ( (ffa->save & SAVE_REPORT) && (ffa->hWnd != NULL) ){
			PostMessage(ffa->hWnd, WM_PPXCOMMAND, KC_RELOAD, ffa->lParam);
		}
		setflag(ffa->state, FFASTATE_COMPLETE | FFASTATE_ENABLEFREE);
	}else{
		setflag(ffa->state, FFASTATE_ENABLEFREE);
		FreeFfa(ffa); // dirty Ȃ̂Ŕp
	}
	CoUninitialize();
	PPxUnRegisterThread();
	return 0;
}

void FindCloseAsync(HANDLE hFind, int flags)
{
	FINDFIRSTASYNC *ffa;

	if ( !(flags & RENTRYI_ASYNCREAD) ){
		VFSFindClose(hFind);
		return;
	}

	ffa = ((FINDFIRSTASYNCHEAP *)hFind)->ffa;
	if ( ffa->ReadTick < USEMEMCACHETIME ){
		EnterCriticalSection(&FindFirstAsyncSection);
		if ( ffa->ref > 0 ) ffa->ref--;
		LeaveCriticalSection(&FindFirstAsyncSection);
		FreeFfa(ffa);
	}else{
		BOOL listed = FALSE;

		EnterCriticalSection(&FindFirstAsyncSection);
		if ( FindFirstAsyncList != NULL ){ // Xgɓo^Ă邩mF
			if ( FindFirstAsyncList == ffa ){
				listed = TRUE;
			}else{
				FINDFIRSTASYNC *ffalink;

				ffalink = FindFirstAsyncList;
				while ( ffalink->next != NULL ){
					if ( ffalink->next == ffa ){
						listed = TRUE;
						break;
					}
					ffalink = ffalink->next;
				}
			}
		}
		if ( ffa->ref > 0 ) ffa->ref--;
		LeaveCriticalSection(&FindFirstAsyncSection);
		if ( listed == FALSE ) FreeFfa(ffa); // XgOȂ
	}

	PPcHeapFree((FINDFIRSTASYNCHEAP *)hFind);
}

BOOL FindNextAsync(HANDLE hFind, WIN32_FIND_DATA *ff, int flags)
{
	FINDFIRSTASYNCHEAP *ffah;

	if ( !(flags & RENTRYI_ASYNCREAD) ) return VFSFindNext(hFind, ff);

	ffah = (FINDFIRSTASYNCHEAP *)hFind;
	if ( ffah->count == 0 ){
		SetLastError(ERROR_NO_MORE_FILES);
		return FALSE;
	}
	*ff = *ffah->read++;
	ffah->count--;
	return TRUE;
}

BOOL FindOptionDataAsync(HANDLE hFind, DWORD optionID, void *data, int flags)
{
	if ( flags & RENTRYI_ASYNCREAD ) return FALSE;
	return VFSFindOptionData(hFind, optionID, data);
}

HANDLE FindFirstAsyncReadStart(FINDFIRSTASYNC *ffa, WIN32_FIND_DATA *ff, VFSDIRTYPEINFO *Dtype, int *flags)
{
	FINDFIRSTASYNCHEAP *ffah;

	if ( (ffa->result == NO_ERROR) && (ffa->count == 0) ){	// GgȂƂ
		ffa->result = ERROR_NO_MORE_FILES;
	}
	if ( ffa->result != NO_ERROR ){
		ERRORCODE result = ffa->result;

		FreeFfa(ffa);
		SetLastError(result);
		return INVALID_HANDLE_VALUE;
	}
	setflag(ffa->state, FFASTATE_CACHE); // LbVpL

	if ( Dtype != NULL ) *Dtype = ffa->Dtype;

	if ( ffa->hFind != NULL ){ // FindFirst 𒼐ڎgp邽߁Affa 
		HANDLE hFind = ffa->hFind;

		resetflag(*flags, RENTRYI_ASYNCREAD);
		ffa->hFind = NULL;
		*ff = *((WIN32_FIND_DATA *)ffa->files.p);
		FreeFfa(ffa);
		return hFind;
	}
	ffa->ref++;

	ffah = PPcHeapAlloc(sizeof(FINDFIRSTASYNCHEAP));
	ffah->ffa = ffa;
	ffah->read = ffa->files.p;
	ffah->count = ffa->count;

	FindNextAsync((HANDLE)ffah, ff, RENTRYI_ASYNCREAD);
	return (HANDLE)ffah;
}

#define TIMEOUTCHECKSW 0

#if TIMEOUTCHECKSW
	void TimeOutCheck(const TCHAR *path, const TCHAR *str, DWORD tick)
	{
		DWORD rtick = GetTickCount() - tick;
		if ( rtick < 10 ) return;
		XMessage(NULL, NULL, XM_DbgLOG, T("FindFirstAsync %s(Tick:%d)%s"), str, rtick, path);
	}
#else
	#define TimeOutCheck(path, str, tick)
#endif

/*	lParam	cinfo->LoadCounter
*/
HANDLE FindFirstAsync(HWND hWnd, LPARAM lParam, const TCHAR *path, WIN32_FIND_DATA *ff, VFSDIRTYPEINFO *Dtype, int *flags)
{
	FINDFIRSTASYNC *useffa = NULL, *sffa, *MemCacheFfa = NULL;
	DWORD tick;
	TCHAR name[VFPS + 32];
	int sizecount = 0;

	if ( !(*flags & RENTRYI_ASYNCREAD) ){ // 񓯊sȂ̂ŒʏǍs
		HANDLE hFind;

#if TIMEOUTCHECKSW
		tick = GetTickCount();
#endif
		MakeFindFirstPath(name, path, hWnd);
		hFind = VFSFindFirst(name, ff);

		TimeOutCheck(path, T("SyncRead-FF"), tick);

		if ( (hFind != INVALID_HANDLE_VALUE) && (Dtype != NULL) ){
			GetDtypeInfo(hFind, Dtype);
		}
		return hFind;
	}
		// XgɊYpX邩ׂ
	EnterCriticalSection(&FindFirstAsyncSection);
	sffa = FindFirstAsyncList;
	tick = GetTickCount();
	while ( sffa != NULL ){
		if ( sffa->dirty != FALSE ){ // dirty ̂ƂAp\Ȃp
			FINDFIRSTASYNC *nextffa;

			nextffa = sffa->next;
			FreeFfa(sffa);
			sffa = nextffa;
			continue;
		}else if ( !tstrcmp(path, sffa->path) ){ // fBNg
			if ( *flags & RENTRY_MODIFYUP ){	// XVǍȂAp
				FINDFIRSTASYNC *nextffa;

				nextffa = sffa->next;
				FreeFfa(sffa);
				sffa = nextffa;
				continue;
												 // ʏǍ
			}else if ( sffa->state & FFASTATE_COMPLETE ){ // Ǎ->p
				if ( sffa->state & FFASTATE_CACHE ){ // LbVp𔭌
					// pX̌ÂLbV̂Ŕp
					if ( MemCacheFfa != NULL ){
						MemCacheFfa->ref--;
						FreeFfa(MemCacheFfa);
					}
					// LbVp\ƂċL
					sffa->lParam = lParam;
					MemCacheFfa = sffa;
					MemCacheFfa->ref++;
				}else{
					HANDLE hFF;
					// pX̌ÂLbV̂Ŕp
					if ( MemCacheFfa != NULL ){
						MemCacheFfa->ref--;
						FreeFfa(MemCacheFfa);
//						MemCacheFfa = NULL;
					}
					hFF = FindFirstAsyncReadStart(sffa, ff, Dtype, flags);
					LeaveCriticalSection(&FindFirstAsyncSection);
					return hFF;
				}
			}else{ // ǂݍݒ
				// ǂݍݒȂ̂ŁAMemCache dǂݍ݂ɂ
				//   ł΁Aɒ񋟂ł悤ɂ
				if ( sffa->hWnd == hWnd ){
					useffa = sffa; // ̓ǍȂ̂ŃLbVǂݍ݂
				}
			}
		}

		// ǂݍݒ̓esvɂȂ̂Ńt[ɂ
		if ( (sffa->hWnd == hWnd) && (sffa->lParam != lParam) ){
			setflag(sffa->state, FFASTATE_CACHE);
			sffa->hWnd = NULL; // ʒm off
		}
		sizecount += sffa->files.s;

		sffa = sffa->next;
	}
#if 1
	if ( sizecount > X_ardir[1] ){ // LbV̂ŁAȂp
		int usesize;

		sffa = FindFirstAsyncList;
		usesize = X_ardir[1] + (X_ardir[1] / 8);
		while ( sffa != NULL ){
			// t[Ŕj\ȕp
			if ( (sffa != useffa) && (sffa != MemCacheFfa) &&
				 (sffa->ref <= 0) && (sffa->state & FFASTATE_ENABLEFREE) ){
				FINDFIRSTASYNC *targetffa;

				sizecount -= sffa->files.s;
				targetffa = sffa;
				sffa = sffa->next;
				FreeFfa(targetffa); // dirty `FbN
				if ( sizecount < usesize ) break;
			}else{
				sffa = sffa->next;
			}
		}
#ifndef RELEASE
		XMessage(NULL, NULL, XM_DbgLOG, T("Async FreeCache:%d"), sizecount);
#endif
	}
#endif
	LeaveCriticalSection(&FindFirstAsyncSection);

		// XgɊYȂ߁Aǂݍ݃XbhVK쐬
	if ( useffa == NULL ){ // useffa != NULL ... ǂݍݒXbhL
		HANDLE hComplete;
		DWORD tid;

		useffa = PPcHeapAlloc(sizeof(FINDFIRSTASYNC));
		useffa->next = NULL;
		useffa->result = ERROR_BUSY;
		useffa->ref = 0;
		useffa->save = *flags & (SAVE_DUMP | SAVE_REFRESHCACHE);
		useffa->dirty = FALSE;
		useffa->state = 0;
		useffa->count = 0;
		useffa->hFind = NULL;
		useffa->files.p = NULL;
		useffa->files.s = 0;
		useffa->files.h = NULL;

		useffa->hWnd = hWnd;
		useffa->lParam = lParam;
		useffa->LastTick = tick;
		useffa->ReadTick = 0;

		tstrcpy(useffa->path, path);
		useffa->Dtype.mode = 0;
		useffa->Dtype.Name[0] = '\0';
		useffa->Dtype.BasePath[0] = '\0';

		if ( X_ardir[0] < 0 ) setflag(useffa->save, SAVE_REFRESHCACHE);

		hComplete = CreateThread(NULL, 0,
				(LPTHREAD_START_ROUTINE)FindFirstAsyncThread, useffa, 0, &tid);
		if ( hComplete == NULL ) return INVALID_HANDLE_VALUE;
#if 1
		TimeOutCheck(path, T("ASync-CreateThread"), tick);
		if ( X_ardir[0] >= 0 ){
			DWORD result = WaitForSingleObject(hComplete,
					((*flags & RENTRY_UPDATE) || (X_ardir[0] == 0)) ?
							30 : X_ardir[0] * 100);

			TimeOutCheck(path, T("ASync-Wait"), tick);

			if ( result == WAIT_OBJECT_0 ){	// ǂݍݐ
				CloseHandle(hComplete);
				// pX̃LbV΁Ap
				if ( MemCacheFfa != NULL ){
					EnterCriticalSection(&FindFirstAsyncSection);
					MemCacheFfa->ref--;
					FreeFfa(MemCacheFfa);
					LeaveCriticalSection(&FindFirstAsyncSection);
				}
				return FindFirstAsyncReadStart(useffa, ff, Dtype, flags);
			}

			// Ԃo߁ASɂȂȂ悤XbhDx
			SetThreadPriority(hComplete, THREAD_PRIORITY_BELOW_NORMAL);
		}
#endif
		CloseHandle(hComplete);
		useffa->save |= SAVE_REPORT; // ʒmL

										// FindFirstAsyncList ɓo^
		EnterCriticalSection(&FindFirstAsyncSection);
		if ( FindFirstAsyncList == NULL ){
			FindFirstAsyncList = useffa;
		}else{
			FINDFIRSTASYNC *ffalink;

			ffalink = FindFirstAsyncList;
			while ( ffalink->next ) ffalink = ffalink->next;
			ffalink->next = useffa;
		}
		LeaveCriticalSection(&FindFirstAsyncSection);
	}

	if ( !(*flags & RENTRY_UPDATE) ){ // Ԃo߃LbVǂݍ
									 // XV[h́ALbVgȂ
		if ( MemCacheFfa != NULL ){
			HANDLE hFF;

			EnterCriticalSection(&FindFirstAsyncSection);
			hFF = FindFirstAsyncReadStart(MemCacheFfa, ff, Dtype, flags);
			MemCacheFfa->ref--; // {֐̎QƂ
			LeaveCriticalSection(&FindFirstAsyncSection);
			return hFF;
		}

		#if TIMEOUTCHECKSW
			tick = GetTickCount();
		#endif
		if ( IsTrue(GetCache_Path(name, path, &Dtype->mode)) ){ // t@CLbVL
			HANDLE hFind;

			resetflag(*flags, RENTRYI_ASYNCREAD);
			tstrcat(name, T("\\*"));
			hFind = VFSFindFirst(name, ff);
			Dtype->ExtData = INVALID_HANDLE_VALUE;
			tstrcpy(Dtype->Name, T("??? "));

			TimeOutCheck(path, T("Cache read"), tick);
			return hFind;
		}
		// LbVt@CLbVȂ̂ busy

	}else{ // XVAǂݍ݊ĂȂ̂ busy
		if ( MemCacheFfa != NULL ){ // LbVΐL
			EnterCriticalSection(&FindFirstAsyncSection);
			MemCacheFfa->ref--; // {֐̎QƂ
			LeaveCriticalSection(&FindFirstAsyncSection);
		}
	}

	// YLbVȂ/LbVgp
	SetLastError(ERROR_BUSY);
	return INVALID_HANDLE_VALUE;	// ݓǂݍݒ
}
