/*-----------------------------------------------------------------------------
	Paper Plane cUI											[Enter] R}h
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include <shlobj.h>
#include "PPX.H"
#include "VFS.H"
#include "PPC_STRU.H"
#include "PPC_FUNC.H"
#include "PPCOMBO.H"
#pragma hdrstop

ThSTRUCT CrMenuBmpCache = ThSTRUCT_InitData;

void RegisterAction(PPC_APPINFO *cinfo, HMENU hMenu, PPCMENUINFO *cminfo, BOOL always);

const TCHAR RegFileExtsPath[] = T("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\%s");
const TCHAR RegApplicationName[] = T("Application");
const TCHAR RegPerceivedText[] = T("PerceivedType");
const TCHAR RegFA[] = T("SystemFileAssociations\\%s\\OpenWithList");
const TCHAR RegOpenWithList[] = T("\\OpenWithList");
const TCHAR RegOpenWithProgids[] = T("\\OpenWithProgids");
const TCHAR DirName[] = T("Dir"); // M_CcrDir p
const TCHAR NoextName[] = T("NoExt"); // M_CcrNoExt p
const TCHAR SaveSettingsStr[] = MES_CRSS;
const TCHAR menuidstr[] = T("%M_Ccr,");
const TCHAR ExtTableID[] = T("E_cr");

const TCHAR CcrEditParam[] = T("%Ob *ppcust /:M_Ccr");
const TCHAR strMES_MCRC[] = MES_MCRC;
const TCHAR strMES_MCRD[] = MES_MCRD;
const TCHAR strMES_MCRE[] = MES_MCRE;
const TCHAR strMES_MCRX[] = MES_MCRX;
const TCHAR strMES_MEMD[] = MES_MEMD;
CRMENUSTACKCHECK DummyCrmCheck;

#define CRMOM_DEFAULTSELECT 1
#define CRMOM_DEFAULTEXECUTE 2
#define CRMOM_ADDEXTITEM 3
#define CRMOM_ADDCOMMONITEM 4
#define CRMOM_MODIFYITEM 5

// DelayMenus
#define DelayMenus_SENDTO	0
#define DelayMenus_DIRTYPE	1
#define DelayMenus_MAX 3 // Ō NULL ܂߂

// VK̏ꍇ͖[ɓo^
int ReplaceCustTable(const TCHAR *str, const TCHAR *sub, const void *bin, size_t b_size)
{
	if ( !IsExistCustTable(str, sub) ){ // VKo^
		return InsertCustTable(str, sub, 0, bin, b_size);
	}else{
		return SetCustTable(str, sub, bin, b_size);
	}
}

BOOL ShellExecEntriesSub(PPC_APPINFO *cinfo, const TCHAR *command, const TCHAR *csrentry, const TCHAR *path, const TCHAR *execpath, BOOL archivemode, DWORD runflag)
{
	const TCHAR *paramPtr;
	TCHAR name[VFPS], errmsg[VFPS * 2], param[VFPS * 2];
	HANDLE hProcess;
	int mode;

	if ( (command != NULL) && (command[0] == '*') ) command = NULL;

	if ( IsTrue(archivemode) ){
		csrentry = FindLastEntryPoint(csrentry);
	}
	VFSFullPath(name, (TCHAR *)csrentry, path);
	if ( VFSGetDriveType(name, &mode, NULL) != NULL ){
		if ( (mode <= VFSPT_SHN_DESK) || (mode == VFSPT_SHELLSCHEME) ){
			VFSGetRealPath(NULL, name, name);
		}
	}
	if ( execpath == NULL ){ // csrentry ̂܂܎s
		paramPtr = NilStr;
	}else{ // csrentry p[^ɂ execpath s
		tstrcpy(param, execpath);
		tstrreplace(param, T("%1"), name);
		tstrreplace(param, T("%I"), T(":0"));
		tstrreplace(param, T("%L"), name);
		tstrreplace(param, T("%V"), name);
		tstrreplace(param, T("%W"), path);
		paramPtr = param;
		GetLineParamS(&paramPtr, name, TSIZEOF(name)); // st@Cƃp[^Ƃ؂藣
	}
	hProcess = PPxShellExecute(cinfo->info.hWnd, command, name, paramPtr, path, runflag, errmsg);
	if ( hProcess == NULL ){
		SetPopMsg(cinfo, POPMSG_MSG, errmsg);
		return FALSE;
	}
	if ( XC_exem && cinfo->e.markC ) for ( ;; ){
		DWORD result;

		result = WaitForInputIdle(hProcess, 100);
		if ( result != WAIT_TIMEOUT ) break;
		if ( (GetAsyncKeyState(VK_ESCAPE) | GetAsyncKeyState(VK_PAUSE)) & KEYSTATE_PUSH ){
			if ( PMessageBox(cinfo->info.hWnd, MES_AbortCheck, NULL, MB_QYES) == IDOK ){
				return FALSE;
			}
		}
	}
	CloseHandle(hProcess);
	return TRUE;
}

BOOL ShellExecEntries(PPC_APPINFO *cinfo, const TCHAR *command, const TCHAR *csrentry, const TCHAR *path, const TCHAR *execpath, BOOL archivemode)
{
	if ( !XC_exem || !cinfo->e.markC ){	// J[\ʒûݎs
		return ShellExecEntriesSub(cinfo, command,
					csrentry, path, execpath, archivemode, 0);
	}else{					// Y}[NɂĎs
		int work;
		ENTRYCELL *cell;

		InitEnumMarkCell(cinfo, &work);
		cell = EnumMarkCell(cinfo, &work);
		while ( cell != NULL ){
			csrentry = cell->f.cFileName;
			if ( ShellExecEntriesSub(cinfo, command,
					csrentry, path, execpath, archivemode, XEO_WAITIDLE) == FALSE ){
				return FALSE;
			}
			cell = EnumMarkCell(cinfo, &work);
		}
	}
	return TRUE;
}


typedef struct
{
	UINT cbSize;
	UINT fMask;
	UINT fType;
	UINT fState;
	UINT wID;
	HMENU hSubMenu;
	HBITMAP hbmpChecked;
	HBITMAP hbmpUnchecked;
	ULONG_PTR dwItemData;
	LPTSTR dwTypeData;
	UINT cch;
	HBITMAP hbmpItem;
} xMENUITEMINFO;
#ifndef MIIM_BITMAP
	#define MIIM_BITMAP      0x00000080
#endif

void SetMenuBmp(HMENU hMenu, HICON hIcon, DWORD id)
{
	HBITMAP hbmp, hOldBmp;
	BITMAPINFOHEADER bmiHeader;
	LPVOID lpBits;

	memset(&bmiHeader, 0, sizeof(bmiHeader));
	bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmiHeader.biWidth = bmiHeader.biHeight = GetSystemMetrics(SM_CYSMICON);
	bmiHeader.biPlanes = 1;
	bmiHeader.biBitCount = 32;

	hbmp = CreateDIBSection(NULL, (LPBITMAPINFO)&bmiHeader, DIB_RGB_COLORS, &lpBits, NULL, 0);
	if ( hbmp != NULL ){
		HDC hMemDC;
		xMENUITEMINFO mii;

		hMemDC = CreateCompatibleDC(NULL);
		hOldBmp = (HBITMAP)SelectObject(hMemDC, hbmp);
		DrawIconEx(hMemDC, 0, 0, hIcon, bmiHeader.biWidth, bmiHeader.biWidth, 0, NULL, DI_NORMAL);
		SelectObject(hMemDC, hOldBmp);
		DeleteDC(hMemDC);

		mii.cbSize = sizeof(xMENUITEMINFO);
		mii.fMask = MIIM_BITMAP;
		mii.hbmpItem = hbmp;
		SetMenuItemInfo(hMenu, id, FALSE, (MENUITEMINFO *)&mii);
		ThAppend(&CrMenuBmpCache, &hbmp, sizeof(hbmp));
	}
}

void SetMenuBmpIdl(HMENU hMenu, LPSHELLFOLDER pSF, LPITEMIDLIST idl, DWORD id)
{
	XLPEXTRACTICON pEI;
	int iconsize;
	HICON hIcon = NULL;
	TCHAR iconname[MAX_PATH];
	int index;
	UINT flags;

	if ( FAILED(pSF->lpVtbl->GetUIObjectOf(pSF, NULL, 1, (LPCITEMIDLIST *)&idl, &IID_IExtractIcon, NULL, (void **)&pEI)) ){
		return;
	}
	iconsize = ( GetSystemMetrics(SM_CYMENUCHECK) > 16 ) ? 32 : 16;
	pEI->lpVtbl->GetIconLocation(pEI, 0, iconname, MAX_PATH, &index, &flags);
	if ( flags & GIL_NOTFILENAME ){
		//  : Win2000 ȑOł NULL s
		pEI->lpVtbl->Extract(pEI, iconname, index, &hIcon, NULL, iconsize);
	}else{
		hIcon = LoadIconDx(iconname, index, iconsize);
	}
	pEI->lpVtbl->Release( pEI );
	if ( hIcon != NULL ){
		SetMenuBmp(hMenu, hIcon, id);
		DestroyIcon(hIcon);
	}
}

void AppendMenuNoDbl(HMENU hMenu, DWORD ID, const TCHAR *str)
{
	TCHAR menustr[CMDLINESIZE];
	DWORD i;

	for ( i = CRID_OPENWITH ; i < ID ; i++ ){
		GetMenuString(hMenu, i, menustr, TSIZEOF(menustr), MF_BYCOMMAND);
		if ( tstricmp(str, menustr) == 0 ) return;
	}
// HKEY_CURRENT_USER\Software\Classes\Local Settings\Software\Microsoft\Windows\Shell\MuiCache ̖O̗pĂ悢
	AppendMenuString(hMenu, ID, str);

	if ( OSver.dwMajorVersion >= 6 ){
		HICON hIcon;

		thprintf(menustr, TSIZEOF(menustr), T("Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\%s"), str);
		if (GetRegString(HKEY_CURRENT_USER, menustr, NilStr, menustr, MAX_PATH) ||
			GetRegString(HKEY_LOCAL_MACHINE, menustr, NilStr, menustr, MAX_PATH) ){
			VFSFixPath(NULL, menustr, NULL, 0);
			str = menustr;
		}
//		hIcon = LoadIconDx(str, LIDX_FILE, 32); // LIDX_FILE  EXEƂ͕s
		hIcon = ExtractIcon(hInst, str, 0);
		if ( hIcon != NULL ){
			SetMenuBmp(hMenu, hIcon, ID);
			DestroyIcon(hIcon);
		}
	}
}

//-----------------------------------------------------------------------------
// OpenWithList 𒲍(Windows2000p)
DWORD OpenWith2000(HMENU hMenu, const TCHAR *ext, HKEY hRegKey, DWORD IDmin)
{
	DWORD ID = IDmin;
	DWORD Rtyp;				// WXg̎
	DWORD keyS, appS;

	TCHAR rpath[MAX_PATH];	// AvP[ṼL[
	TCHAR keyN[MAX_PATH];	// WXg̃L[
	TCHAR defN[MAX_PATH];	// ftHg̃ANV
	TCHAR appN[MAX_PATH];	// ftHg̃ANV
	HKEY hAP;

	int cnt = 0;

	thprintf(rpath, TSIZEOF(rpath), RegFileExtsPath, ext);

	defN[0] = '\0';
	GetRegString(hRegKey, rpath, RegApplicationName, defN, TSIZEOF(defN));

	tstrcat(rpath, RegOpenWithList);

	// Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\[ext]\OpenWithList 璊o
	if ( ERROR_SUCCESS == RegOpenKeyEx(hRegKey, rpath, 0, KEY_READ, &hAP) ){
		for ( ; ; ){					// ݒo ---------------------
			keyS = TSIZEOF(keyN);
			appS = TSIZEOF(appN);
			if ( ERROR_SUCCESS != RegEnumValue(hAP, cnt, keyN, &keyS, NULL,
					&Rtyp, (BYTE *)appN, &appS) ){
				break;
			}
			if ( keyN[1] == '\0' ){
				HKEY hTest;

				thprintf(rpath, TSIZEOF(rpath), T("Applications\\%s\\shell\\Open"), appN);
				if ( ERROR_SUCCESS == RegOpenKeyEx(HKEY_CLASSES_ROOT,
						rpath, 0, KEY_READ, &hTest) ){
					RegCloseKey(hTest);
					AppendMenuNoDbl(hMenu, ID, appN);
					ID++;
					if ( ID >= CRID_OPENWITH_MAX ) break;
				}
			}
			cnt++;
		}
	}
	RegCloseKey(hAP);
	// Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\[ext]\Application 璊o
	if ( (ID == CRID_OPENWITH) && defN[0] ) AppendMenuString(hMenu, ID++, defN);
	return ID;
}

void EnumOpenWithList(HMENU hMenu, DWORD *ID, const TCHAR *rpath)
{
	HKEY hAP;
	int cnt = 0;
	DWORD keyS;
	TCHAR keyN[MAX_PATH];	// WXg̃L[

	if ( ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, rpath, 0, KEY_READ, &hAP)){
		return;
	}
	for ( ; ; ){					// ݒo ---------------------
		keyS = TSIZEOF(keyN);
		if ( ERROR_SUCCESS !=
				RegEnumKeyEx(hAP, cnt, keyN, &keyS, NULL, NULL, NULL, NULL) ){
			break;
		}
		if ( tstrchr(keyN, '.') != NULL ){
			AppendMenuNoDbl(hMenu, *ID, keyN);
			(*ID)++;
			if ( *ID >= CRID_OPENWITH_MAX ) break;
		}
		cnt++;
	}
	RegCloseKey(hAP);
}

void EnumOpenWithProgids(HMENU hMenu, DWORD *ID, const TCHAR *rpath)
{
	HKEY hAP;
	int cnt = 0;
	DWORD keyS;
	TCHAR keyN[MAX_PATH];	// WXg̃L[
	TCHAR buf[VFPS];

	if ( ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, rpath, 0, KEY_READ, &hAP)){
		return;
	}
	for ( ; ; ){					// ݒo ---------------------
		keyS = TSIZEOF(keyN);
		if ( ERROR_SUCCESS !=
				RegEnumValue(hAP, cnt, keyN, &keyS, NULL, NULL, NULL, NULL) ){
			break;
		}
		thprintf(buf, TSIZEOF(buf), T("%s\\shell\\open\\command"), keyN);
		keyN[0] = '\0';
		GetRegString(HKEY_CLASSES_ROOT, buf, NilStr, keyN, TSIZEOF(keyN));
		if ( keyN[0] != '\0' ){
			TCHAR *ptr;

			ptr = keyN;
			GetLineParamS((const TCHAR **)&ptr, buf, TSIZEOF(buf));
			ptr = VFSFindLastEntry(buf);
			if ( *ptr == '\\' ) ptr++;
			if ( tstricmp(ptr, T("LaunchWinApp.exe")) != 0 ){
				AppendMenuNoDbl(hMenu, *ID, ptr);
				(*ID)++;
				if ( *ID >= CRID_OPENWITH_MAX ) break;
			}
		}

		cnt++;
	}
	RegCloseKey(hAP);
}

// OpenWithList 𒲍(WindowsXPȍ~p)
DWORD OpenWithXP(HMENU hMenu, const TCHAR *ext)
{
	DWORD ID = CRID_OPENWITH;
	TCHAR rpath[MAX_PATH];	// AvP[ṼL[
	TCHAR header[MAX_PATH];

	// CLASSES_ROOT\SystemFileAssociations\[ext]\OpenWithList 璊o
	thprintf(rpath, TSIZEOF(rpath), RegFA, ext);
	EnumOpenWithList(hMenu, &ID, rpath);

	// CLASSES_ROOT\[ext]\PerceivedType ɋLڂꂽ CLASSES_ROOT\SystemFileAssociations\[PerceivedType]\OpenWithList 璊o
	header[0] = '\0';
	GetRegString(HKEY_CLASSES_ROOT, ext, RegPerceivedText, header, TSIZEOF(header));
	if ( header[0] ){
		thprintf(rpath, TSIZEOF(rpath), RegFA, header);
		EnumOpenWithList(hMenu, &ID, rpath);
	}
	// CLASSES_ROOT\[ext]\OpenWithList 璊o
	tstrcpy(rpath, ext);
	tstrcat(rpath, RegOpenWithList);
	EnumOpenWithList(hMenu, &ID, rpath);
	tstrcpy(rpath, ext);
	tstrcat(rpath, RegOpenWithProgids);
	EnumOpenWithProgids(hMenu, &ID, rpath);
	return ID;
}

BOOL RPIDL2DisplayNameOf(TCHAR *name, LPSHELLFOLDER sfolder, LPCITEMIDLIST pidl)
{
	return PIDL2DisplayName(name, sfolder, pidl, SHGDN_INFOLDER | SHGDN_FORPARSING);
}

void FreeCrMenuBmpCache(void)
{
	if ( CrMenuBmpCache.bottom != NULL ){ // Ogj[rbg}bvp
		int size;
		HGDIOBJ *hObj;

		size = CrMenuBmpCache.top / sizeof(HGDIOBJ);
		hObj = (HGDIOBJ *)CrMenuBmpCache.bottom;
		for (; size > 0; size--){
			DeleteObject(*hObj++);
		}
		ThFree(&CrMenuBmpCache);
	}
}

void WINAPI CRmenuDelayLoad(DelayLoadMenuStruct *DelayMenus)
{
	DWORD ID = CRID_OPENWITH;
	HMENU hMenu;
	TCHAR path[VFPS];

	FreeCrMenuBmpCache();
	// vOÏꗗ
	hMenu = DelayMenus->hMenu;
	if ( (OSver.dwMajorVersion > 5) ||
		 ((OSver.dwMajorVersion == 5) && OSver.dwMinorVersion) ){
		ID = OpenWithXP(hMenu, (const TCHAR *)DelayMenus->lParam);
	}
	ID = OpenWith2000(hMenu, (const TCHAR *)DelayMenus->lParam, HKEY_CURRENT_USER, ID);
	ID = OpenWith2000(hMenu, (const TCHAR *)DelayMenus->lParam, HKEY_LOCAL_MACHINE, ID);
	if ( ID > CRID_OPENWITH ) AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

	// SendTöꗗ
	{
		LPITEMIDLIST idl;
		LPSHELLFOLDER pSF;
		LPENUMIDLIST pEID;
		LPMALLOC pMA;

		pSF = VFPtoIShell(NULL, T("#9:\\"), NULL);
		if ( pSF != NULL ){
			(void)SHGetMalloc(&pMA);

			if ( S_OK == pSF->lpVtbl->EnumObjects(pSF, NULL,
					(OSver.dwMajorVersion >= 6) ?
					ENUMOBJECTSFORFOLDERFLAG_VISTA : ENUMOBJECTSFORFOLDERFLAG_XP,
					&pEID) ){ // S_FALSE ̂Ƃ́ApEID = NULL
				for ( ; ; ){
					DWORD getsi;

					if ( pEID->lpVtbl->Next(pEID, 1, &idl, &getsi) != S_OK ){
						break;
					}
					if ( getsi == 0 ) break;

					if ( IsTrue(PIDL2DisplayNameOf(path, pSF, idl)) ){
						AppendMenuString(hMenu, DelayMenus->ID, path);
						if ( OSver.dwMajorVersion >= 6 ){
							SetMenuBmpIdl(hMenu, pSF, idl, DelayMenus->ID);
						}
						DelayMenus->ID++;

						RPIDL2DisplayNameOf(path, pSF, idl);
						thprintf(DelayMenus->thMenuStr, THP_ADD, T("*sendto \"%s"), path);
					}
					pMA->lpVtbl->Free(pMA, idl);
				}
				pEID->lpVtbl->Release(pEID);
			}
			pMA->lpVtbl->Release(pMA);
			pSF->lpVtbl->Release(pSF);
		}
		AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
	}
	AppendMenuString(hMenu, CRID_LISTSTART, MES_ASTL);
	AppendMenuString(hMenu, CRID_SELECTEXE, MES_REGP);

	DelayMenus->hMenu = INVALID_HANDLE_VALUE; // ēxĂ΂Ȃ悤ɂ
}

BOOL IsArcInArc(PPC_APPINFO *cinfo)
{
	TCHAR *fp, *ep;
	BOOL arcmode = FALSE;
	TCHAR ParamHeader[8];

	fp = FindLastEntryPoint(CEL(cinfo->e.cellN).f.cFileName);
	ep = fp + FindExtSeparator(fp);
	if ( *ep == '.' ){				// gq
		ep++;
		if ( NO_ERROR == GetCustTable(ExtTableID, ep, ParamHeader, sizeof(ParamHeader)) ){
			if ( ((UTCHAR)ParamHeader[0] == EXTCMD_KEY) &&
				 (*(WORD *)(ParamHeader + 1) == (WORD)KC_Edir) ){
				arcmode = TRUE;
			}
		}
	}
	if ( arcmode == FALSE ){
		FN_REGEXP fn;

		MakeFN_REGEXP(&fn, T(".lzh;.zip;.cab;.rar;.7z"));
		arcmode = FilenameRegularExpression(fp, &fn);
		FreeFN_REGEXP(&fn);
	}
	return arcmode;
}

void WINAPI DirTypeDelayLoad(DelayLoadMenuStruct *DelayMenus)
{
	PPC_APPINFO *cinfo;

	cinfo = (PPC_APPINFO *)DelayMenus->lParam;

	IsFileDir(cinfo, CEL(cinfo->e.cellN).f.cFileName, NULL, NULL, DelayMenus->hMenu);

	if ( CEL(cinfo->e.cellN).f.dwFileAttributes & FILE_ATTRIBUTE_REPARSE_POINT ){
		AppendMenuString(DelayMenus->hMenu, CRID_DIRTYPE_JUNCTION, MES_JNJL);
		AppendMenuString(DelayMenus->hMenu, CRID_DIRTYPE_JUNCTION_PAIR, MES_JPJL);
	}

	if ( cinfo->e.Dtype.mode == VFSDT_LFILE ){
		AppendMenuString(DelayMenus->hMenu, K_M | KC_JMPE, MES_DDJP);
	}

	if ( (Combo.hWnd != NULL) &&
		 ( (CEL(cinfo->e.cellN).f.dwFileAttributes &
				(FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTEX_FOLDER)) ||
		   IsArcInArc(cinfo) ) ){
		AppendMenuString(DelayMenus->hMenu, CRID_NEWTAB, MES_TABN);
		AppendMenuString(DelayMenus->hMenu, CRID_NEWPANE, MES_TABP);
	}

	if ( cinfo->e.Dtype.mode == VFSDT_SHN ){
		AppendMenuString(DelayMenus->hMenu, CRID_REALPATH, MES_JNRP);
	}

	if ( GetMenuItemCount(DelayMenus->hMenu) <= 0 ){
		AppendMenu(DelayMenus->hMenu, MF_GS, 0, T("none"));
	}
	DelayMenus->hMenu = INVALID_HANDLE_VALUE; // ēxĂ΂Ȃ悤ɂ
}

UINT FindMenuID(HMENU hMenu, PPXMENUDATAINFO *pmdi, TCHAR *param, int *menupos, int *exec, TCHAR *Kword)
{
	TCHAR *destptr, *paramptr;
										// L[[h𒊏o -----------------
	paramptr = param + TSIZEOF(menuidstr) - 1;
	SkipSpace((const TCHAR **)&paramptr);
	if ( *paramptr == '!' ){
		if ( exec != NULL ) *exec = 1;
		paramptr++;
		SkipSpace((const TCHAR **)&paramptr);
	}
	destptr = Kword;
	if ( *paramptr == '\"' ){
		paramptr++;
		while ( *paramptr && (*paramptr != '\"') ) *destptr++ = *paramptr++;
	}else{
		while ( *paramptr && ((UTCHAR)*paramptr >' ') ) *destptr++ = *paramptr++;
	}
	*destptr = '\0';
										// L[[h -----------------
	if ( pmdi->th.top != 0 ){
		const TCHAR *action;
		DWORD id, pos;

		action = (const TCHAR *)pmdi->th.bottom;
		id = pmdi->id - CRID_EXTCMD;
		for ( pos = 0 ; pos < id ; pos++ ){
			if ( tstricmp(Kword, action) == 0 ){
				if ( menupos != NULL ) *menupos = pos;
				return id + CRID_EXTCMD;
			}
			action += tstrlen(action) + 1;
		}
	}
	return FindMenuItem(hMenu, Kword, menupos);
}

int reglist(PPC_APPINFO *cinfo, HMENU hMenu, PPCMENUINFO *cminfo, PPXMENUDATAINFO *pmdi, int TypeFlag, DelayLoadMenuStruct *DelayMenus)
{
	int cnt;
	DWORD ID;
	HMENU hSubMenu;
	TCHAR buf[VFPS];
	const TCHAR *extid;

	// OS ̊gqʂ̊{j[
	TCHAR LinkTarget[VFPS];
	const TCHAR *regext;

	regext = cminfo->regext;
	if ( tstricmp(regext, StrShortcutExt) == 0 ){
		if ( SUCCEEDED(GetLink(cinfo->info.hWnd, cminfo->PathName, LinkTarget)) && LinkTarget[0] ){
			DWORD attr;

			attr = GetFileAttributesL(LinkTarget);
			if ( attr != BADATTR ){
				if ( attr & FILE_ATTRIBUTE_DIRECTORY ){
					regext = StrRegFolder;
				}else{
//					regext = NilStr;
				}
			}
		}
	}

	pmdi->id = CRID_EXTCMD;
	cnt = GetExtentionMenu(hMenu, regext, pmdi);
	AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

	// Send To & OS ̊gqʂ̃vOj[
	hSubMenu = CreatePopupMenu();
	AppendMenu(hMenu, MF_EPOP, (UINT_PTR)hSubMenu, MessageText(MES_OWIT));
	DelayMenus[DelayMenus_SENDTO].hMenu = hSubMenu;
	DelayMenus[DelayMenus_SENDTO].lParam = (LPARAM)cminfo->regext;

	// VFReLXgj[
	AppendMenuString(hMenu, K_Mc | K_s | K_F10, MES_SHCM);
	if ( CEL(cinfo->e.cellN).f.dwFileAttributes &
			(FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTEX_FOLDER) ){
		TypeFlag = PPEXTRESULT_DIR;
	}else if ( (TypeFlag < PPEXTRESULT_NONE) || (TypeFlag > PPEXTRESULT_FILE) ){
		if ( (TypeFlag == PPEXTRESULT_VFSDIR) ||
			 (TypeFlag == -PPEXTRESULT_VFSDIR) ||
			 IsFileDir(cinfo, CEL(cinfo->e.cellN).f.cFileName, NULL, NULL, NULL) ){
			TypeFlag = PPEXTRESULT_DIR;
		}else{
			TypeFlag = PPEXTRESULT_FILE;
		}
	}else{
		TypeFlag = PPEXTRESULT_FILE;
	}

	// fBNgړ
	if ( (TypeFlag != PPEXTRESULT_FILE) || IsArcInArc(cinfo) ){
		AppendMenuString(hMenu, K_M | KC_Edir, MES_DREN);
		if ( Combo.hWnd != NULL ){
			AppendMenuString(hMenu, CRID_NEWTAB, MES_TABN);
		}
	}
	// ̑̃fBNgړ
	hSubMenu = CreatePopupMenu();
	AppendMenu(hMenu, MF_EPOP, (UINT_PTR)hSubMenu, MessageText(MES_OWDT));
	DelayMenus[DelayMenus_DIRTYPE].hMenu = hSubMenu;
	DelayMenus[DelayMenus_DIRTYPE].lParam = (LPARAM)cinfo;

	// ListFileFYGgړ^Gg
	if ( cinfo->e.Dtype.mode == VFSDT_LFILE ){
		AppendMenuString(hMenu, K_M | KC_JMPE, MES_DDJP);
		AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
		AppendMenuString(hMenu, K_Mc | K_s | 'D', MES_ELST);
		AppendMenuString(hMenu, K_M | KC_UpdateEntryData, MES_UDED);
	}

	AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

	// gqʃj[
	extid = cminfo->regext;
	if ( *extid == '\0' ) extid = NoextName;
	if ( extid == StrRegFolder ) extid = DirName;
	thprintf(buf, TSIZEOF(buf), T("M_Ccr%s"), extid);

	ID = CRID_EXTMENU;
	PP_AddMenu(&cinfo->info, cinfo->info.hWnd, hMenu, &ID, buf, &cminfo->x.th);
	if ( ID != CRID_EXTMENU ) AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
	cminfo->comID = ID;

	// {j[
	if ( cinfo->e.pathtype == VFSPT_AUXOP ){
		PP_AddMenu(&cinfo->info, cinfo->info.hWnd, hMenu, &ID, T("??auxccr"), &cminfo->x.th);
	}else{
		PP_AddMenu(&cinfo->info, cinfo->info.hWnd, hMenu, &ID, T("M_Ccr"), &cminfo->x.th);
	}

	DelayMenus[DelayMenus_SENDTO].ID = cminfo->extitemID = ID;
	DelayMenus[DelayMenus_SENDTO].thMenuStr = &cminfo->x.th;
	return cnt;
}

void CrMenu(PPC_APPINFO *cinfo, BOOL ShowMenu)
{
	TCHAR Param[CMDLINESIZE], Kword[MAX_PATH];
	HMENU hMenu;
	int TypeFlag; // PPEXTRESULT_xxx
	PPCMENUINFO cminfo;
	PPXMENUDATAINFO pmdi;
	POINT pos;
	BOOL popmode, LongParam = FALSE;
	DelayLoadMenuStruct *OldDelayMenus, DelayMenus[DelayMenus_MAX];

	CRMENUSTACKCHECK *CrmCheck; // X^bNُ퓙̌op

	cinfo->FreezeType = FREEZE_CRMENU;
	cinfo->StateInfo.state = StateID_Crmenu;
	cinfo->StateInfo.tick = GetTickCount();

	CrmCheck = (CRMENUSTACKCHECK *)PPxCommonExtCommand(KC_GETCRCHECK, 0);
	if ( CrmCheck == (CRMENUSTACKCHECK *)(LONG_PTR)ERROR_INVALID_FUNCTION ){
		CrmCheck = &DummyCrmCheck;
	}

	ThInit(&cminfo.x.th);
	ThInit(&pmdi.th);
	memset(DelayMenus, 0, sizeof(DelayMenus));
										// SHN p ----------------------------
	if ( (cinfo->RealPath[0] == '?') ||
		 (CEL(cinfo->e.cellN).f.dwFileAttributes & FILE_ATTRIBUTEX_VIRTUAL) ){
		cinfo->StateInfo.state = StateID_Celllook;
		cinfo->FreezeType = FREEZE_CRMENU_CELLLOOK;
		if ( !ShowMenu && IsTrue(CellLook(cinfo, CellLook_AUTO)) ){
			cinfo->FreezeType = FREEZE_NONE;
			cinfo->StateInfo.state = StateID_NoState;
			return;
		}
		cinfo->FreezeType = FREEZE_CRMENU_SCMENU;
		cinfo->StateInfo.state = StateID_Scmenu;
		SCmenu(cinfo, NULL);
		cinfo->FreezeType = FREEZE_NONE;
		cinfo->StateInfo.state = StateID_NoState;
		return;
	}
	cminfo.comID = CRID_EXTMENU;
	cminfo.cellindex = cinfo->e.cellN;
	if ( XC_exem && cinfo->e.markC ){ // Y}[NɂĎsȂPڂݒ
		ENTRYINDEX newindex;

		newindex = GetFirstMarkCell(cinfo);
		if ( newindex >= 0 ) cminfo.cellindex = newindex;
	}

	if ( VFSFullPath(cminfo.PathName, CEL(cminfo.cellindex).f.cFileName, cinfo->RealPath) == NULL ){
		SetPopMsg(cinfo, ERROR_PATH_NOT_FOUND, NULL);
		cinfo->FreezeType = FREEZE_NONE;
		cinfo->StateInfo.state = StateID_NoState;
		return;
	}
	if ( !ShowMenu ){ // fBNgړ
		if ( (X_ChooseMode == CHOOSEMODE_NONE) || (cinfo->e.markC == 0) ){
			if ( CEL(cinfo->e.cellN).attr & ECA_THIS ){	// "." ----------------
				if ( X_ChooseMode == CHOOSEMODE_NONE ){
					PPC_RootDir(cinfo);
					cinfo->StateInfo.state = StateID_NoState;
					cinfo->FreezeType = FREEZE_NONE;
					return;
				}
			}else if ( CEL(cinfo->e.cellN).attr & ECA_PARENT ){ // ".." -------
				PPC_UpDir(cinfo);
				cinfo->FreezeType = FREEZE_NONE;
				cinfo->StateInfo.state = StateID_NoState;
				return;
														// <dir> --------------
			}else if ( CEL(cinfo->e.cellN).f.dwFileAttributes &
						(FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTEX_FOLDER) ){
				if ( (X_ChooseMode != CHOOSEMODE_NONE) ||
					 !IsExistCustTable(ExtTableID, T(":DIR")) ){
					cinfo->FreezeType = FREEZE_CRMENU_CELLLOOK;
					if ( IsTrue(CellLook(cinfo, CellLook_AUTO)) ){
						cinfo->FreezeType = FREEZE_NONE;
						cinfo->StateInfo.state = StateID_NoState;
						return;
					}
					cinfo->FreezeType = FREEZE_CRMENU;
				}
			}
		}
		if ( X_ChooseMode != CHOOSEMODE_NONE ){ // Choose Mode ̊m菈
			DoChooseResult(cinfo, Param);
			cinfo->StateInfo.state = StateID_NoState;
			cinfo->FreezeType = FREEZE_NONE;
			return;
		}
	}
	CrmCheck->enter++;
										// gqݒ擾 ---------------
	Param[CMDLINESIZE - 1] = '\0';
	if ( CEL(cinfo->e.cellN).f.dwFileAttributes &
			(FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTEX_FOLDER) ){
		tstrcpy(cminfo.TypeName, T(":DIR"));
		TypeFlag = (GetCustTable(ExtTableID, T(":DIR"), Param, sizeof(Param)) == NO_ERROR) ? PPEXTRESULT_FILE : PPEXTRESULT_NONE;
	}else{
		cinfo->FreezeType = FREEZE_CRMENU_GetExtCommand;
		cinfo->StateInfo.state = StateID_GetExtCommand;
		TypeFlag = PP_GetExtCommand(cminfo.PathName, ExtTableID, Param, cminfo.TypeName);
		cinfo->FreezeType = FREEZE_CRMENU;
	}
	cinfo->StateInfo.state = StateID_NoState;
	if ( Param[CMDLINESIZE - 1] != '\0' ){
		LongParam = TRUE;
		Param[CMDLINESIZE - 1] = '\0';
	}

	if ( tstrcmp(cminfo.TypeName, T(":DIR")) != 0 ){
		cminfo.regext = CEL(cminfo.cellindex).f.cFileName + CEL(cminfo.cellindex).ext;
		if ( *cminfo.regext == '\0' ){
			const TCHAR *name;

			name = FindLastEntryPoint(CEL(cminfo.cellindex).f.cFileName);
			if ( *name != '\0' ){
				cminfo.regext = (TCHAR *)name + FindExtSeparator(name);
			}else{
				tstrcpy(cminfo.TypeName, T(":DIR"));
				cminfo.regext = DirName;
			}
		}
	}else{
		cminfo.regext = StrRegFolder;
	}

	if ( !ShowMenu && (TypeFlag >= PPEXTRESULT_FILE) ){ // `ςݓL
		TCHAR *ptr;

		ptr = Param;
		if ( (UTCHAR)*ptr == EXTCMD_KEY ){	// Key macro
			WORD *keyp;

			keyp = (WORD *)(ptr + 1);
			while ( *keyp != 0 ){
#ifndef _WIN64
				// 0.40-0.41ōoO΍
				if ( (*keyp & (K_ex | K_raw)) == (K_ex | K_raw) ){
					DeleteCustTable(ExtTableID, cminfo.TypeName, 0);
					break;
				}
#endif
				CrmCheck->exectype = *keyp;
				if ( (CrmCheck->exectype == (K_raw | K_cr)) &&
					 (CrmCheck->enter > 30) ){
					thprintf(Param, TSIZEOF(Param), T("E_cr:%s ̃L[ĂɂčēigsjNĂ鋰ꂪ邽߁A𒆒f܂B"), cminfo.TypeName);
					SetPopMsg(cinfo, POPMSG_MSG, Param);
					break;
				}else{
					PPcCommand(cinfo, *keyp++);
				}
			}
			CrmCheck->enter--;
			cinfo->FreezeType = FREEZE_NONE;
			return;
		}
		if ( (UTCHAR)*ptr == EXTCMD_CMD ) ptr++;

		SkipSpace((const TCHAR **)&ptr);
		if ( memcmp(ptr, menuidstr, TSIZEOF(menuidstr) - 1) == 0 ){
			int exec = 0;
			int menupos;
			UINT menuID;
										// L[[hɊY鍀ڂ -----

			hMenu = CreatePopupMenu();
			reglist(cinfo, hMenu, &cminfo, &pmdi, TypeFlag, DelayMenus);

			menuID = FindMenuID(hMenu, &pmdi, ptr, &menupos, &exec, Kword);
			if ( menuID != 0 ){
				if ( exec && !ShowMenu && (menuID <= CRID_MAX) ){ // ڎs
					CrmCheck->exectype = 0x10;
					DoActionMenu(cinfo, hMenu, menuID, cminfo.cellindex, &cminfo.x.th, &pmdi, cminfo.comID);
					goto menufreefin;
				}else{ // J[\ړ
					for ( ; menupos >= 0 ; menupos-- ){
						PostMessage(cinfo->info.hWnd, WM_KEYDOWN, VK_DOWN, 0);
						PostMessage(cinfo->info.hWnd, WM_KEYUP, VK_DOWN, 0);
					}
				}
			}else{
				thprintf(Param, TSIZEOF(Param), MessageText(MES_EECR), Kword, cminfo.TypeName);
				SetPopMsg(cinfo, POPMSG_MSG, Param);
				TypeFlag = PPEXTRESULT_NONE; // o^\ɂ
			}
		}else{
			CrmCheck->exectype = 0x11;
			if ( LongParam == FALSE ){
				PP_ExtractMacro(cinfo->info.hWnd, &cinfo->info, NULL, ptr, NULL, 0);
			}else{
				DWORD size;
				TCHAR *LongParamPtr = GetCustValue(ExtTableID, cminfo.TypeName, &size, 0);

				if ( LongParamPtr != NULL ){
					PP_ExtractMacro(cinfo->info.hWnd, &cinfo->info, NULL,
							LongParamPtr + (ptr - Param), NULL, 0);
					ProcHeapFree(LongParamPtr);
				}
			}
			goto freefin;
		}
	}else{						// 펞j[\ or YȂ̏ꍇ
		TCHAR *ptr = Param;
		UINT menuID;

		// fBNgړs
		if ( !ShowMenu && IsTrue(CellLook(cinfo, TypeFlag)) ) goto freefin;

		// j[쐬
		hMenu = CreatePopupMenu();

		if ( !reglist(cinfo, hMenu, &cminfo, &pmdi, TypeFlag, DelayMenus) && !ShowMenu ){
			VFSFullPath(cminfo.PathName, CEL(cminfo.cellindex).f.cFileName, cinfo->path);
			CrmCheck->exectype = 0x12;
			// ɓ̃fBNgƎvGg͕\Ȃ
			if ( ((cinfo->e.Dtype.mode != VFSDT_UN) &&
				  (cinfo->e.Dtype.mode != VFSDT_SUSIE)) ||
				 ((CEL(cminfo.cellindex).f.nFileSizeHigh == 0) &&
				  (CEL(cminfo.cellindex).f.nFileSizeLow != 0)) ){
				CrmCheck->exectype = 0x13;
				PPxView(cinfo->info.hWnd, cminfo.PathName, cinfo->NormalViewFlag);
			}
			goto menufreefin;
		}

		// ftHgڂċ\
		if ( (UTCHAR)*ptr == EXTCMD_KEY ){
			menuID = *(WORD *)(ptr + 1) | K_M;
		}else{
			if ( (UTCHAR)*ptr == EXTCMD_CMD ) ptr++;
			SkipSpace((const TCHAR **)&ptr);
			if ( memcmp(ptr, menuidstr, TSIZEOF(menuidstr) - 1) == 0 ){
				menuID = FindMenuID(hMenu, &pmdi, ptr, NULL, NULL, Kword);
			}else{
				menuID = 0;
			}
		}
		if ( menuID != 0 ){
			MENUITEMINFO minfo;

			minfo.cbSize = sizeof(minfo);
			minfo.fMask = MIIM_STATE;
			minfo.fState = MFS_ENABLED | MFS_DEFAULT;
			SetMenuItemInfo(hMenu, menuID, MF_BYCOMMAND, &minfo);
		}
	}
										// j[\
	DelayMenus[DelayMenus_SENDTO].initfunc = CRmenuDelayLoad;
	DelayMenus[DelayMenus_DIRTYPE].initfunc = DirTypeDelayLoad;

	cminfo.x.info = &cinfo->info;
	cminfo.x.commandID = PPXCMDID_MENUONMENU;
	GetPopupPosition(cinfo, &pos);
	popmode = PPxSetMenuInfo(hMenu, &cminfo.x);

	OldDelayMenus = cinfo->DelayMenus;
	cinfo->DelayMenus = DelayMenus;
	RemoveControlKeydown(cinfo->info.hWnd);
	cminfo.x.index = TrackPopupMenu(hMenu,
		popmode ? TPM_LEFTALIGN | TPM_RETURNCMD | TPM_RECURSE : TPM_TDEFAULT,
		pos.x, pos.y, 0, cinfo->info.hWnd, NULL);
	cinfo->DelayMenus = OldDelayMenus;
	CrmCheck->exectype = 0x14;

	FreeCrMenuBmpCache();

	if ( cminfo.x.Command != NULL ){
		CrmCheck->exectype = 0x15;
		PP_ExtractMacro(cinfo->info.hWnd, &cinfo->info, NULL, cminfo.x.Command, NULL, 0);
		PPcHeapFree(cminfo.x.Command);
	}

	if ( cminfo.x.index ){
		CrmCheck->exectype = 0x16;
										// t@C̓eŔ ---------------
		if ( GetShiftKey() & K_c ){
			RegisterAction(cinfo, hMenu, &cminfo, FALSE);
		}else if ( IsTrue(X_acr[0]) && (TypeFlag < PPEXTRESULT_FILE) ){ // Io^
			const TCHAR *extp;

			// gq(ext/:type.ext)Ȃo^/gq(name.)͓o^Ȃ
			extp = cminfo.TypeName + FindExtSeparator(cminfo.TypeName);
			if ( (*extp == '\0') || (*(extp + 1) != '\0') ){ // '.' [ȊO?
				RegisterAction(cinfo, hMenu, &cminfo, TRUE);
			}
		}
		DoActionMenu(cinfo, hMenu, cminfo.x.index, cminfo.cellindex, &cminfo.x.th, &pmdi, cminfo.comID);
	}
menufreefin:
	DestroyMenu(hMenu);
freefin:
	ThFree(&cminfo.x.th);
	ThFree(&pmdi.th);
	if ( IsTrue(cinfo->UnpackFix) ) OffArcPathMode(cinfo);
	CrmCheck->enter--;
	cinfo->FreezeType = FREEZE_NONE;
}

void RegisterAction(PPC_APPINFO *cinfo, HMENU hMenu, PPCMENUINFO *cminfo, BOOL always)
{
	TCHAR param[VFPS], TypeText[MAX_PATH];
	const TCHAR *TypeName;
	VFSFILETYPE vft;
	const TCHAR *ext;

	if ( cminfo->x.index >= CRID_SELECTEXE ) return; // vOIsID͉Ȃ
	if ( (cminfo->x.index >= CRID_COMMENT) && (cminfo->x.index < CRID_OPENWITH) ){ // sID͉Ȃ
		return;
	}

	ext = GetPathExt(cminfo->PathName);

	TypeName = cminfo->TypeName;
	vft.flags = VFSFT_TYPE | VFSFT_STRICT;
	if ( VFSGetFileType(cminfo->PathName, NULL, 0, &vft) == NO_ERROR ){
		if ( IsExistCustTable(ExtTableID, vft.type) ){
			// ޖɂ̂Ŋgqtɂ
			thprintf(TypeText, TSIZEOF(TypeText), T("%s%s"), vft.type, ext);
			TypeName = TypeText;
		}else{
			// ޖɂȂ̂Ŏޖœo^
			TypeName = vft.type;
		}
	}
	always |= GetShiftKey() & K_s;

	// I̕ۑ =====================================================
	// j[Î or CRID_EXTMENU / CRID_OPENWITH / CRID_NEWENTRY / CRID_EXTCMD
	if ( !always || (cminfo->x.index >= CRID_EXTMENU) ){
		const TCHAR *cmdp;
		TCHAR *dest;

		// ̓@\͎o^Ȃ
		GetMenuDataMacro2(cmdp, &cminfo->x.th, cminfo->x.index - CRID_EXTMENU);
		if ( cmdp != NULL ){
			if ( (*cmdp == '%') && (*(cmdp + 1) == 'K') ){ // %K
				// \@K
				if ( (*(cmdp + 3) == '\\') && (*(cmdp + 4) == '@') && (*(cmdp + 5) == 'D')){
					return;
				}
				// @^X @^C @C @M @D @R
				if ( *(cmdp + 3) == '@' ){
					if ( (*(cmdp + 4) == '^') && ((*(cmdp + 5) == 'X') || (*(cmdp + 5) == 'C') || (*(cmdp + 5) == 'V')) ){
						return;
					}
					if ( tstrchr(T("CMDR"), *(cmdp + 4)) != NULL ) return;
				}
			}
			if ( memcmp(cmdp + 1, T("*sendto"), 7 * sizeof(TCHAR)) == 0 ) return;
		}

		param[0] = EXTCMD_CMD;
		tstrcpy(param + 1, always ? T("%M_Ccr,!\"") : T("%M_Ccr,\""));
		dest = param + tstrlen(param);

		*dest = '\0';
		GetMenuString(hMenu, cminfo->x.index, dest, VFPS - 20, MF_BYCOMMAND);
		if ( *dest == '\0' ) return;
		if ( tstrchr(dest, '\t') ){
			const TCHAR *p;

			dest--;	// " 
			p = tstrchr(dest, '&');
			if ( p != NULL ){	// V[gJbgL
				dest[0] = *(p + 1);
				dest[1] = '\0';
			}else{
				#ifdef UNICODE
				dest[0] = dest[1];
				dest[1] = '\0';
				#else
				dest[1] = dest[2];
				dest[0] = dest[1];
				dest[Chrlen(*dest)] = '\0';
				#endif
			}
		}else{
			tstrcat(param, T("\""));
		}
		ReplaceCustTable(ExtTableID, TypeName, param, TSTRSIZE(param));
	}else if ( cminfo->x.index >= K_M ){	// R}h
		int key;

		key = cminfo->x.index & ~K_M;
		if ( !(key & K_ex) ) key |= K_raw;
		#ifdef UNICODE
			param[0] = EXTCMD_KEY;
			param[1] = (WORD)key;
			param[2] = 0;
			ReplaceCustTable(ExtTableID, TypeName, param, TSTROFF(3));
			// gqłɓo^
			if ( (*ext == '.') && !IsExistCustTable(ExtTableID, ext + 1) ){
				ReplaceCustTable(ExtTableID, ext + 1, param, TSTROFF(3));
			}
		#else
			param[0] = EXTCMD_KEY;
			*(WORD *)(param + 1) = (WORD)key;
			*(WORD *)(param + 3) = 0;
			ReplaceCustTable(ExtTableID, TypeName, param, 5);
			// gqłɓo^
			if ( (*ext == '.') && !IsExistCustTable(ExtTableID, ext + 1) ){
				ReplaceCustTable(ExtTableID, ext + 1, param, 5);
			}
		#endif
	}else{ // sID͉Ȃ
		return;
	}
	thprintf(param, TSIZEOF(param), T("%s(%s)"), MessageText(SaveSettingsStr), TypeName);
	SetPopMsg(cinfo, POPMSG_MSG, param);
}

void GetCcrID(PPC_APPINFO *cinfo, ENTRYINDEX cellindex, TCHAR *result)
{
	const TCHAR *ext;

	if ( CEL(cellindex).f.dwFileAttributes &
			(FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTEX_FOLDER) ){
		ext = DirName;
	}else{
		ext = CEL(cellindex).f.cFileName + CEL(cellindex).ext;
	}
	if ( *ext == '\0' ) ext = NoextName;
	thprintf(result, 100, T("M_Ccr%s"), ext);
}

void AddProgToExtMenu(PPC_APPINFO *cinfo, ENTRYINDEX cellindex, const TCHAR *cmd, TCHAR *param)
{
	TCHAR typename[MAX_PATH];
	TCHAR keyname[MAX_PATH];

	tstrcpy(keyname, cmd);
	{
		TCHAR *p = keyname + FindExtSeparator(keyname);
		*p = '\0';
	}

	GetCcrID(cinfo, cellindex, typename);
	if ( !IsExistCustTable(typename, keyname) ){ // o^Ȃ̂ŐVKo^
		tstrreplace(param, T("%1"), T("%FNDC"));
		tstrreplace(param, T("%I"), T(":0"));
		tstrreplace(param, T("%L"), T("%FNDC"));
		tstrreplace(param, T("%V"), T("%FNDC"));
		tstrreplace(param, T("%W"), T("%1"));
		InsertCustTable(typename, keyname, 0, param, TSTRSIZE(param));
	}
}

void DoActionMenu_NewTab(PPC_APPINFO *cinfo, ENTRYINDEX cellindex)
{
	TCHAR param[CMDLINESIZE];

	VFSFullPath(tstpcpy(param, T("*pane newtab \"")),
			CEL(cellindex).f.cFileName, cinfo->path);
	PP_ExtractMacro(cinfo->info.hWnd, &cinfo->info, NULL, param, NULL, 0);
}

void DoActionMenu_NewPane(PPC_APPINFO *cinfo, ENTRYINDEX cellindex)
{
	TCHAR param[CMDLINESIZE];

	param[0] = '\"';
	VFSFullPath(param + 1, CEL(cellindex).f.cFileName, cinfo->path);
	CreateNewPane(param);
}

void DoActionMenu_AddStartList(PPC_APPINFO *cinfo, ENTRYINDEX cellindex)
{
	TCHAR param[CMDLINESIZE], buf[CMDLINESIZE];

	VFSFullPath(buf, CEL(cellindex).f.cFileName, cinfo->RealPath);
	thprintf(param, TSIZEOF(param), T("*file !copy,\"%s\",\"#11:\\\",-mode:3"), buf);
	PP_ExtractMacro(cinfo->info.hWnd, &cinfo->info, NULL, param, NULL, 0);
}

void DoActionMenu_SelectExe(PPC_APPINFO *cinfo, ENTRYINDEX cellindex)
{
	TCHAR param[CMDLINESIZE], buf[CMDLINESIZE];
	TCHAR cmd[VFPS];

	GetCcrID(cinfo, cellindex, buf);
	thprintf(cmd, TSIZEOF(cmd), MessageText(MES_SSRP), buf);
	param[1] = '\0';

	if ( PPctInput(cinfo, cmd, param + 1, TSIZEOF(param) - 1,
			PPXH_NAME_R, PPXH_FILENAME) > 0 ){
		TCHAR *p;

		p = FindLastEntryPoint(param + 1);
		tstrcpy(cmd, p); // t@C擾
		p = tstrchr(cmd, '\"'); // Zp[^
		if ( p != NULL ) *p = '\0';
		*(cmd + FindExtSeparator(cmd)) = '\0'; // gq

		if ( (*(param + 1) != '\"') && tstrchr(param + 1, ' ') ){
			*param = '\"';
			tstrcat(param, T("\""));
			p = param;
		}else{
			p = param + 1;
		}
		tstrcat(p, T(" %FDC"));

		ReplaceCustTable(buf, cmd, p, TSTRSIZE(p));
		PP_ExtractMacro(cinfo->info.hWnd, &cinfo->info, NULL, p, NULL, 0);
	}
}

BOOL HardLinksJumpMenu(PPC_APPINFO *cinfo, TCHAR *newpath)
{
	HANDLE hFile;
	BOOL result = FALSE;

	hFile = CreateFileL(newpath, GENERIC_READ, FILE_SHARE_READ, NULL,
				OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if ( hFile != INVALID_HANDLE_VALUE ){
		DefineWinAPI(HANDLE, FindFirstFileNameW, (LPCWSTR lpFileName, DWORD dwFlags, LPDWORD StringLength, PWCHAR LinkName));
		DefineWinAPI(BOOL, FindNextFileNameW, (HANDLE hFindStream, LPDWORD StringLength, PWCHAR LinkName));
		HMODULE hKernel32 = GetModuleHandle(StrKernel32DLL);

		GETDLLPROC(hKernel32, FindFirstFileNameW);
		GETDLLPROC(hKernel32, FindNextFileNameW);
		if ( DFindFirstFileNameW != NULL ){
			HANDLE hFFFN;
			WCHAR linknameW[VFPS];
			DWORD len;
			HMENU hPopupMenu;
			int id = 1;
			#ifdef UNICODE
				#define nameW newpath
			#else
				char nameT[VFPS];
				WCHAR nameW[VFPS];

				AnsiToUnicode(newpath, nameW, VFPS);
			#endif

			hPopupMenu = CreatePopupMenu();

			len = VFPS;
			hFFFN = DFindFirstFileNameW(nameW, 0, &len, linknameW);
			if ( hFFFN != INVALID_HANDLE_VALUE ) for(;;){
				#ifdef UNICODE
					#define nameT linknameW
				#else
					UnicodeToAnsi(linknameW, nameT, VFPS);
				#endif
				VFSFullPath(NULL, nameT, cinfo->RealPath);
				AppendMenuString(hPopupMenu, id++, nameT);
				if ( FALSE == DFindNextFileNameW(hFFFN, &len, linknameW) ){
					FindClose(hFFFN);
					break;
				}
			}
			id = PPcTrackPopupMenu(cinfo, hPopupMenu);
			if ( id > 0 ){
				TCHAR *ptr;

				GetMenuString(hPopupMenu, id, newpath, VFPS, MF_BYCOMMAND);

				ptr = VFSFindLastEntry(newpath);
				tstrcpy(cinfo->Jfname, (*ptr == '\\') ? ptr + 1 : ptr);
				*ptr = '\0';

				result = TRUE;
			}
			DestroyMenu(hPopupMenu);
		}
	}
	return result;
}

void DoActionMenu_OpenWith(PPC_APPINFO *cinfo, HMENU hMenu, UINT crID, ENTRYINDEX cellindex, PPXMENUDATAINFO *pmdi)
{
	TCHAR withparam[CMDLINESIZE], buf[CMDLINESIZE];
	TCHAR cmd[VFPS], newpath[VFPS];
	const TCHAR *cfilename;
	BOOL archivemode;

	tstrcpy( newpath, cinfo->RealPath );

	cfilename = CEL(cellindex).f.cFileName;
	if ( IsTrue(cinfo->UnpackFix) ){
		archivemode = FALSE;
	}else{
		archivemode = PPcUnpackForAction(cinfo, newpath, UFA_ALL);
	}
	if ( IsTrue(archivemode) ){
		cfilename = FindLastEntryPoint(cfilename);
	}
	if ( hMenu != NULL ){
		GetMenuString(hMenu, crID, cmd, TSIZEOF(cmd), MF_BYCOMMAND);
	}else{
		cmd[0] = '\0';
	}

	if ( crID >= CRID_EXTCMD ){ // CRID_EXTCMD ... Open
		const TCHAR *action;

		action = (const TCHAR *)pmdi->th.bottom;
		if ( action != NULL ){
			crID -= CRID_EXTCMD;
			while ( crID-- ) action += tstrlen(action) + 1;
		}
		ShellExecEntries(cinfo, action, cfilename, newpath, NULL, archivemode);
		return;
	}

	if ( crID >= CRID_DIRTYPE ){ // CRID_DIRTYPE
		VFSFullPath(newpath, (TCHAR *)cfilename, cinfo->path);
		cinfo->Jfname[0] = '\0';

		switch ( crID ){
			case CRID_DIRTYPE_PAIR:
				if ( !(CEL(cellindex).f.dwFileAttributes &
					(FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTEX_FOLDER)) ){
					tstrcpy(newpath, cinfo->path);
					tstrcpy(cinfo->Jfname, cfilename);
				}
				break;

			case CRID_DIRTYPE_CLSID:
			case CRID_DIRTYPE_CLSID_PAIR:
			case CRID_DIRTYPE_SHORTCUT:
			case CRID_DIRTYPE_SHORTCUT_PAIR:
				IsFileDir(cinfo, newpath, newpath, cinfo->Jfname, NULL);
				break;

			case CRID_DIRTYPE_JUNCTION:
			case CRID_DIRTYPE_JUNCTION_PAIR:
				GetReparsePath(newpath, cmd);
				if ( cmd[0] != '\0' ) tstrcpy(newpath, cmd);
				if ( !(CEL(cellindex).f.dwFileAttributes &
					(FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTEX_FOLDER)) ){
					TCHAR *p = VFSFindLastEntry(newpath);

					if ( *p != '\0' ) tstrcpy(cinfo->Jfname, p + 1);
					*p = '\0';
				}
				break;

			case CRID_DIRTYPE_HARDLINKS:
			case CRID_DIRTYPE_HARDLINKS_PAIR:
				if ( HardLinksJumpMenu(cinfo, newpath) == FALSE ) return;
				break;

			case CRID_DIRTYPE_STREAM:
			case CRID_DIRTYPE_STREAM_PAIR:
				tstrcat(newpath, T("::") VFS_TYPEID_STREAM);
				break;

			default: // CRID_DIRTYPE`CRID_DIRTYPE_STREAM 
				if ( cmd[0] != ':' ){
					if ( (cinfo->e.Dtype.mode == VFSDT_ZIPFOLDER) ||
						 (cinfo->e.Dtype.mode == VFSDT_UN) ||
						 (cinfo->e.Dtype.mode == VFSDT_SUSIE) ){
						if ( IsTrue(CellLook(cinfo, CellLook_ARCHIVE)) ) return;
					}
					tstrcat(newpath, T("::"));
				}
				tstrcat(newpath, cmd);
				break;
		}
		if ( (crID >= CRID_DIRTYPE_PAIR) || (GetShiftKey() & K_s) ){
			SetPairPath(cinfo, newpath, cinfo->Jfname);
			return;
		}

		if ( IsTrue(cinfo->ChdirLock) ){
			PPCuiWithPathForLock(cinfo, newpath);
		}else{
			SetPPcDirPos(cinfo);
			ChangePath(cinfo, newpath, CHGPATH_SETABSPATH);
			read_entry(cinfo, cinfo->Jfname[0] ? (RENTRY_READ | RENTRY_JUMPNAME) : RENTRY_READ);
		}
		return;
	}

	{					// Open With(CRID_OPENWITH)
		// p[^擾(Windows2000̂)
		thprintf(buf, TSIZEOF(buf), T("Applications\\%s\\shell\\Open\\Command"), cmd);
		if ( !GetRegString(HKEY_CLASSES_ROOT, buf, NilStr, withparam, TSIZEOF(withparam)) ){
			thprintf(withparam, TSIZEOF(withparam), T("%s %%1"), cmd); // Ȃꍇ͏ݒ(XPȂ)
		}
		ShellExecEntries(cinfo, NULL, cfilename, newpath, withparam, archivemode);
		AddProgToExtMenu(cinfo, cellindex, cmd, withparam);
	}
}

void DoActionMenu(PPC_APPINFO *cinfo, HMENU hMenu, UINT crID, ENTRYINDEX cellindex, ThSTRUCT *THmenu, PPXMENUDATAINFO *pmdi, DWORD extmenuID)
{
	if ( crID > CRID_MAX ) return;
	if ( crID == CRID_NEWTAB ){	// VK^u
		DoActionMenu_NewTab(cinfo, cellindex);
		return;
	}
	if ( crID == CRID_NEWPANE ){	// VKyC
		DoActionMenu_NewPane(cinfo, cellindex);
		return;
	}
	if ( crID == CRID_SELECTEXE ){	// vOI
		DoActionMenu_SelectExe(cinfo, cellindex);
		return;
	}
	if ( crID == CRID_LISTSTART ){	// X^[gj[^ʂ̈ꗗɓo^
		DoActionMenu_AddStartList(cinfo, cellindex);
		return;
	}
	if ( crID == CRID_REALPATH ){	// #:  x: Ɏ̉
		TCHAR path[VFPS];

		VFSFixPath(path, CEL(cellindex).f.cFileName, cinfo->path, VFSFIX_FULLPATH | VFSFIX_REALPATH);
		if ( tstrcmp(path, cinfo->path) == 0 ) return;

		ChangePath(cinfo, path, CHGPATH_SETABSPATH);
		DxSetMotion(cinfo->DxDraw, DXMOTION_DownDir);
		read_entry(cinfo, RENTRY_READ | RENTRY_ENTERSUB);
		return;
	}
	DxSetMotion(cinfo->DxDraw, DXMOTION_Launch);
	if ( crID >= CRID_OPENWITH ){
		DoActionMenu_OpenWith(cinfo, hMenu, crID, cellindex, pmdi);
		return;
	}
	if ( crID >= CRID_EXTMENU ){ // CRID_EXTMENU `  gqʃj[ ======
		const TCHAR *menucmd;

		GetMenuDataMacro2(menucmd, THmenu, crID - CRID_EXTMENU);
		if ( menucmd != NULL ){
			if ( crID < extmenuID ){
				UnpackExec(cinfo, menucmd);
			}else{
				PP_ExtractMacro(cinfo->info.hWnd, &cinfo->info, NULL, menucmd, NULL, 0);
			}
		}
		return;
	}
	if ( crID >= K_M ){	// R}h
		PPcCommand(cinfo, (WORD)((crID - K_M) | K_raw));
		return;
	}
	SetPopMsg(cinfo, POPMSG_MSG, T("action id error"));
}

void ExecMenuCust(PPCMENUINFO *cminfo, const TCHAR *param)
{
	cminfo->x.Command = PPcHeapAllocT(CMDLINESIZE);
	if ( cminfo->x.Command == NULL ) return;
	tstrcpy(cminfo->x.Command, param);
	PostMessage(cminfo->x.info->hWnd, WM_CHAR, 0x1f, 0); // j[
}

void PPcCRMenuOnMenu(PPC_APPINFO *cinfo, PPCMENUINFO *cminfo)
{
	HMENU hMenu;
	int index;
	POINT pos;
	TCHAR param[CMDLINESIZE];

	thprintf(param, TSIZEOF(param), T("%s %s"), cminfo->regext, cminfo->TypeName);
	SetPopMsg(cinfo, POPMSG_NOLOGMSG, param);

	hMenu = CreatePopupMenu();
	if ( ((DWORD)cminfo->x.index < cminfo->extitemID) ||
		 ((cminfo->x.index >= CRID_EXTCMD) && (cminfo->x.index < CRID_NEWTAB))){
		AppendMenuString(hMenu, CRMOM_DEFAULTSELECT, strMES_MCRD);
		AppendMenuString(hMenu, CRMOM_DEFAULTEXECUTE, strMES_MCRE);

		if ( (cminfo->x.index >= CRID_EXTMENU) &&
			 ((DWORD)cminfo->x.index < cminfo->extitemID) ){
			AppendMenuString(hMenu, CRMOM_MODIFYITEM, strMES_MEMD);
		}
		AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
	}

	AppendMenuString(hMenu, CRMOM_ADDEXTITEM, strMES_MCRX);
	AppendMenuString(hMenu, CRMOM_ADDCOMMONITEM, strMES_MCRC);
	RemoveControlKeydown(cinfo->info.hWnd);
	TinyGetMenuPopPos(FindWindow(T(WNDCLASS_POPUPMENU), NULL), &pos);
	index = TrackPopupMenu(hMenu, TPM_TDEFAULT | TPM_RECURSE,
			pos.x, pos.y, 0, cinfo->info.hWnd, NULL);

	DestroyMenu(hMenu);
	switch (index){
		case CRMOM_DEFAULTSELECT:
		case CRMOM_DEFAULTEXECUTE:
			RegisterAction(cinfo, cminfo->x.hMenu, cminfo, (index == CRMOM_DEFAULTEXECUTE) );
			break;

		case CRMOM_ADDCOMMONITEM:
			ExecMenuCust(cminfo, CcrEditParam);
			break;

		case CRMOM_ADDEXTITEM: {
			const TCHAR *regext;

			tstrcpy(param, CcrEditParam);
			regext = cminfo->regext;
			if ( *regext == '\0' ) regext = NoextName;
			if ( regext == StrRegFolder ) regext = DirName;
			tstrcat(param, regext);
			ExecMenuCust(cminfo, param);
			break;
		}

		case CRMOM_MODIFYITEM: {
			TCHAR *dst = tstpcpy(param, CcrEditParam);
			if ( (DWORD)cminfo->x.index < cminfo->comID ){
				GetCcrID(cinfo, cminfo->cellindex, param + CMDLINESIZE / 2);
				thprintf(dst, CMDLINESIZE / 2 - 5, T("%s:#%d"),
					param + CMDLINESIZE / 2 + 5, cminfo->x.index - CRID_EXTMENU);
			}else{
				thprintf(dst, CMDLINESIZE / 2 - 5, T(":#%d"), cminfo->x.index - cminfo->comID);
			}
			PP_ExtractMacro(cinfo->info.hWnd, &cinfo->info, NULL, param, NULL, 0);
			break;
		}
	}
}
