/*-----------------------------------------------------------------------------
	Paper Plane commandUI												Main
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include <shlobj.h>
#include "PPX.H"
#include "VFS.H"
#include "PPC_STRU.H"
#include "PPC_FUNC.H"
#include "PPC_DD.H"
#include "PPCOMBO.H"
#pragma hdrstop
#include "PPC_GVAR.C"	// O[o̎̒`

int runcheck = 0;
BOOL ComboFix(PPCSTARTPARAM *psp);

const TCHAR RunAlone[] = T("-alone");

#define H_GestureConfig_count 4
GESTURECONFIG H_GestureConfig[] = {
	{ GID_ZOOM, GC_ZOOM, 0 },
	{ GID_PAN, GC_PAN_WITH_SINGLE_FINGER_HORIZONTALLY /* | GC_PAN_WITH_INTERTIA */, GC_PAN_WITH_SINGLE_FINGER_VERTICALLY},
//	{ GID_ROTATE, GC_ROTATE, 0},
	{ GID_TWOFINGERTAP, GC_TWOFINGERTAP, 0},
	{ GID_PRESSANDTAP, GC_PRESSANDTAP, 0},
};

#pragma warning(suppress: 28251) // SDK ɂ hPrevInstance ̑قȂ
#pragma argsused
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	int result;
	PPCSTARTPARAM psp;
	UnUsedParam(hPrevInstance);UnUsedParam(lpCmdLine);

									// O[o
	hInst = hInstance;
	MainThreadID = GetCurrentThreadId();
	(void)CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
	InitPPcGlobal();
	psp.show = nShowCmd;
	#ifdef UNICODE
	if ( LoadParam(&psp, NULL, TRUE) == FALSE ){
		result = EXIT_FAILURE;
		goto fin;
	}
	#else
	if ( LoadParam(&psp, lpCmdLine, TRUE) == FALSE ){
		result = EXIT_FAILURE;
		goto fin;
	}
	#endif
#if 0
	XMessage(NULL, NULL, XM_DbgLOG, T("PSP SingleProcess:%d Reuse:%d UseCmd:%d AllocCmd:%d alone:%d show:%d Focus:%c"),
		psp.SingleProcess, psp.Reuse, psp.UseCmd, psp.AllocCmd, psp.alone, psp.show, psp.Focus);
	{
		PSPONE *next;

		next = psp.next;
		while ( next != NULL ){
			if ( next->id.RegID[0] == '\0' ) break;
			XMessage(NULL, NULL, XM_DbgLOG, T("PSPone RegID:%s RegMode:%d Pair:%d Combo:%d Lock:%d Pane:%d Path:%s"),
				next->id.RegID, next->id.RegMode, next->id.Pair,
				next->combo.use, next->combo.dirlock, next->combo.pane,
				next->path);
			next = PSPONE_next(next);
		}
	}
#endif

	if ( X_ChooseMode != CHOOSEMODE_NONE ){
		runcheck = 1;
		X_sps = psp.SingleProcess = FALSE;
	}else{
		runcheck = 2;
		if ( X_combo != COMBO_OFF ){
			X_sps = psp.SingleProcess = TRUE;
			runcheck = 3;
			if ( ComboFix(&psp) == FALSE ){
				result = EXIT_SUCCESS;
				goto fin;
			}
			runcheck = 4;
		}

		 if ( IsTrue(psp.SingleProcess) ){
			if ( psp.ComboID == '\0' ){
				runcheck = 5;
				if ( IsTrue(CallPPc(&psp, NULL)) ){
					result = EXIT_SUCCESS;
					goto fin;
				}
			}
		}
	}
	runcheck = 7;
	if ( IsTrue(psp.Reuse) ) ReuseFix(&psp);
	runcheck = 10;

	PreloadMigemo();

	result = PPcMain(&psp);
	// ȍ~̓bZ[W{bNX\邱ƂłȂ
fin:
	runcheck = 11;
#ifndef RELEASE
//	XMessage(NULL, NULL, XM_DbgLOG, T("Main Msg Loop quit"));
#endif
	PPxWaitExitThread();	// /spsw莞Aőҋ@
	runcheck = 12;
#ifndef RELEASE
//	XMessage(NULL, NULL, XM_DbgLOG, T("PPxWaitExitThread end"));
#endif
									// I
	if ( hPreviewWnd != NULL ) DestroyWindow(hPreviewWnd);

	if ( Combo.Report.hBrush != NULL ) DeleteObject(Combo.Report.hBrush);
	if ( CacheIcon.hImage != NULL ){
		DImageList_Destroy(CacheIcon.hImage);
	}
	FreeOverlayCom();
	DeleteCriticalSection(&SHGetFileInfoSection);
	DeleteCriticalSection(&FindFirstAsyncSection);
	PPxCommonCommand(NULL, 0, K_CLEANUP);
	CoUninitialize();
#ifndef RELEASE
//	XMessage(NULL, NULL, XM_DbgLOG, T("Return WinMain"));
#endif
	return result;
}

TCHAR *SetTabGroupToPsp(PPCSTARTPARAM *psp, int showpane, TCHAR *listptr)
{
	PSPONE newpspo;
	TCHAR *dest;

	tstrcpy(newpspo.id.RegID, T("GRP"));
	newpspo.id.RegMode = PPXREGIST_IDASSIGN;
	newpspo.id.SubID = 0;
	newpspo.id.Pair = FALSE;
	newpspo.combo.use = X_combo;
	newpspo.combo.dirlock = 0;
	newpspo.combo.pane = showpane;

	dest = newpspo.path;
	for (;;){
		TCHAR chr;

		chr = *listptr;
		if ( (UTCHAR)chr < ' ' ) return NULL;
		if ( chr == '?' ){
			listptr++;
			break;
		}
		if ( dest < (newpspo.path + VFPS - 1) ){
			if ( chr == '%' ){
				chr = *(++listptr);
				if ( chr == '%' ){

				}else if ( chr == '&' ){
					chr = '?';
				}else if ( Islower(chr) ){
					chr = TinyCharUpper(chr);
				}
				#ifndef UNICODE
				else if ( Isdigit(chr) ){
					chr -= (TCHAR)'0';
					for (;;){
						TCHAR chr2;
						chr2 = *(listptr + 1);
						if ( !Isdigit(chr2) ){
							if ( Islower(chr2) ){
								*dest++ = chr;
								chr = TinyCharUpper(chr2);
								listptr++;
							}else{
								if ( (UTCHAR)chr2 < ' ' ) return NULL;
								chr = chr2;
							}
							break;
						}
						chr = (TCHAR)((chr * 10) + (chr2 - '0'));
						listptr++;
					}
				}
				#endif
			}
			*dest++ = chr;
		}
		listptr++;
	}
	*dest = '\0';
	if ( newpspo.path[0] == '\0' ) tstrcpy(newpspo.path, T("?"));
	if ( !Isupper(*listptr) ) return listptr; // ̃O[vIDȂ̂ō쐬sv

	if ( psp->next != NULL ){
		psp->th.top -= TSTROFF(1); // [
	}

	ThAppend(&psp->th, &newpspo, PSPONE_size(&newpspo));
	ThAppend(&psp->th, NilStr, TSTROFF(1));

	psp->next = (PSPONE *)psp->th.bottom;
	return listptr;
}

void FindParamComboTarget(PPCSTARTPARAM *psp, TCHAR ID, int subid, int dirlock, int showpane)
{
	PSPONE newpspo, *pspo, *foundPspo = NULL;

	pspo = psp->next;
	if ( pspo != NULL ){
		while ( pspo->id.RegID[0] != '\0' ){
			if ( pspo->id.RegMode == PPXREGIST_IDASSIGN ){
				if ( (pspo->id.RegID[2] == ID) &&
					  ((ID != 'Z') || (pspo->id.SubID == subid)) ){	// ɓIDŵ遨ɐݒ肷邱Ɩ
					if ( pspo->combo.dirlock == 0 ){
						pspo->combo.dirlock = dirlock;
					}
					return;
				}
			}else{ // `ID̑Ηp
				if ( pspo->combo.use != 0 ){
					foundPspo = pspo;
					// PPXREGIST_IDASSIGN ŵL邩Ȃ̂ős
				}
			}
			pspo = PSPONE_next(pspo);
		}
		if ( foundPspo != NULL ){
			foundPspo->id.RegID[0] = 'C';
			foundPspo->id.RegID[1] = '_';
			foundPspo->id.RegID[2] = ID;
			foundPspo->id.RegID[3] = '\0';
			foundPspo->id.RegMode = PPXREGIST_IDASSIGN;
			foundPspo->id.SubID = subid;
			if ( foundPspo->combo.dirlock == 0 ){
				foundPspo->combo.dirlock = dirlock;
			}
			return;
		}
		psp->th.top -= TSTROFF(1); // [
	}
	// YȂ̂Œǉo^
	// pspone Zbg*
	newpspo.id.RegID[0] = 'C';
	newpspo.id.RegID[1] = '_';
	newpspo.id.RegID[2] = ID;
	newpspo.id.RegID[3] = '\0';
	newpspo.id.RegMode = PPXREGIST_IDASSIGN;
	newpspo.id.SubID = subid;
	newpspo.id.Pair = FALSE;
	newpspo.combo.use = X_combo;
	newpspo.combo.dirlock = dirlock;
	newpspo.combo.pane = showpane;
	newpspo.path[0] = '\0';
	ThAppend(&psp->th, &newpspo, ToSIZE32_T((char *)&newpspo.path[0] - (char *)&newpspo.id.RegID + sizeof(TCHAR)));
	ThAppend(&psp->th, NilStr, TSTROFF(1));

	psp->next = (PSPONE *)psp->th.bottom;
}

BOOL ComboFix(PPCSTARTPARAM *psp)
{
	TCHAR comboid[] = T("CBA");
	TCHAR *listptr;
	int showpane = PSPONE_PANE_DEFAULT;
	HWND hComboWnd;
	DWORD size;

	if ( psp->ComboID != '\0' ){
		comboid[2] = (TCHAR)psp->ComboID;
		if ( comboid[2] == '@' ){
			// ID mۂȂAgp ID 𓾂
			PPxRegist(NULL, comboid, PPXREGIST_COMBO_IDASSIGN);
			psp->ComboID = comboid[2];
			hComboWnd = NULL;
		}else{
			hComboWnd = PPcGetWindow(psp->ComboID - 'A', CGETW_GETCOMBOHWND);
		}
		//  Combo L
		if ( hComboWnd != NULL ){
			CallPPc(psp, hComboWnd);
			if ( (psp->show != SW_SHOWNOACTIVATE) &&
				 (psp->show != SW_SHOWMINNOACTIVE) ){
				SetForegroundWindow(hComboWnd);
			}
			return FALSE;
		}
	}else if ( PPxCombo(BADHWND) != NULL ){
		// ʂ̈̉ŁAɈ̉Ƃ́A
		// ̉ւ̒ǉȂ̂ŉȂ
		return TRUE;
	}else if ( IsTrue(psp->Reuse) ){
		// -r AɕʂPPcȂACallPPc 
		if ( PPcGetWindow(0, CGETW_GETFOCUS) != NULL ) return TRUE;
	}

	if ( psp->RestoreTab != 0 ){
		if ( psp->RestoreTab < 0 ) return TRUE;
	}else{
		if ( X_combos[1] & CMBS1_NORESTORETAB ) return TRUE;
		if ( psp->usealone ) return TRUE; // alone ̓yC̍ČsȂ
	}

	if ( IsTrue(psp->UseCmd) && (psp->next == NULL) ) psp->UseCmd = 2;

	// ̏Ԃ擾
	ComboPaneLayout = GetCustValue(T("_Path"), comboid, &size, 0);
	if ( ComboPaneLayout == NULL ) return TRUE;
	if ( (size == 0) ||
		 (ComboPaneLayout[0] == '\0') ){
		ProcHeapFree(ComboPaneLayout);
		ComboPaneLayout = NULL;
		return TRUE;
	}
	// yC̏
	if ( Isupper(ComboPaneLayout[0]) ) psp->Focus = ComboPaneLayout[0];
	listptr = ComboPaneLayout + 1;
	while ( Islower(*listptr) ) listptr++; // ZXLbv

	// EyC̏
	if ( *listptr == '?' ){
		listptr++;
	}else{
		if ( Isupper(*listptr) ) listptr++;
		while ( Islower(*listptr) ) listptr++; // ZXLbv
	}
	// listptr ́AyCE^uт̐擪

	{ // Z ꍇAɂ
		TCHAR *Zfirst = tstrchr(listptr, 'Z');

		if ( Zfirst != NULL ){
			TCHAR *Znext;

			Znext = Zfirst;
			for ( ;; ) {
				int i;

				Znext = tstrchr(Znext + 1, 'Z');
				if ( Znext == NULL ) break;
				for ( i = 1 ; ; i++ ){
					if ( Islower(*(Zfirst + i)) ){
						if ( *(Zfirst + i) == *(Znext + i) ){
							continue; // subid...p
						}else{ // subid...
							break;
						}
					}else{
						if ( !Islower(*(Znext + i)) ){
							*Znext = ' '; // ɏI... dȂ̂Ŗ
							break;
						}else{ // subid...
							break;
						}
					}
				}
			}
		}
	}
	// CMBS_TABEACHITEM ̎ "-" tĂ邩mFBΐݒj
	if ( X_combos[0] & CMBS_TABEACHITEM ){
		showpane = PSPONE_PANE_SETPANE; // 1
		if ( *listptr == '-' ){ // CMBS_TABEACHITEM p̈𔭌
			listptr++;
		}else{ // CMBS_TABEACHITEM p̐ݒłȂ̂ŕяp
			*listptr = '\0';
		}
	}else{
		if ( *listptr == '-' ){ // CMBS_TABEACHITEM p̐ݒȂ̂ŕяp
			*listptr = '\0';
		}
	}

	if ( psp->next != NULL ){ // IDUĂȂR}hCp[^ID蓖Ă
		int sindex = 0;
		TCHAR *tmplist;
		PSPONE *pspo = psp->next;

		while ( pspo->id.RegID[0] != '\0' ){
			if ( (pspo->id.RegMode <= PPXREGIST_IDASSIGN) &&
				 (pspo->id.RegID[2] == '\0') ){ // ID UĂȂ
				tmplist = listptr;
				for ( ; *tmplist != '\0' ; ){
					TCHAR ID;
					int panesubid;

					ID = *tmplist++;
					if ( !Isupper(ID) ) continue;

					if ( Islower(*tmplist) ){ // subid(ComboID)L
						panesubid = 0;
						tmplist++; // ComboID skip
						while ( Islower(*tmplist) ){
							panesubid = (panesubid * 26) + (*tmplist++ - 'a');
						}
					}else{
						panesubid = -1;
					}

					if ( *tmplist == '$' ) tmplist++;

					if ( Isdigit(*tmplist) ){
						int showid;

						showid = 0;
						while ( Isdigit(*tmplist) ){
							showid = (showid * 10) + (*tmplist++ - '0');
						}
						if ( sindex == showid ){
							pspo->id.RegID[2] = ID;
							pspo->id.RegID[3] = '\0';
							pspo->id.SubID = panesubid;
							pspo->id.RegMode = PPXREGIST_IDASSIGN;
							break;
						}
					}
					while ( *tmplist && !Isupper(*tmplist) ) tmplist++;
				}
				sindex++;
			}
			pspo = PSPONE_next(pspo);
		}
	}

	// ̏ԂČׂ̈ꗗ쐬
	for ( ; *listptr != '\0' ; ){
		TCHAR ID;
		int dirlock;
		int panesubid;

		ID = *listptr++;

		if ( ID == '?' ){
			listptr = SetTabGroupToPsp(psp, showpane, listptr);
			if ( listptr == NULL ) break;
			continue;
		}

		if ( !Isupper(ID) ) continue; // FłȂeXLbv

		if ( Islower(*listptr) ){ // subidL
			panesubid = 0;
			listptr++; // ComboIDXLbv
			while ( Islower(*listptr) ){
				panesubid = (panesubid * 26) + (*listptr++ - 'a');
			}
		}else{
			panesubid = -1;
		}

		if ( *listptr == '$' ){
			listptr++;
			dirlock = 1;
		}else{
			dirlock = 0;
		}
		while ( Isdigit(*listptr) ) listptr++;

		FindParamComboTarget(psp, ID, panesubid, dirlock, showpane);

		if ( *listptr == '-' ){
			listptr++;
			if ( X_combos[0] & CMBS_TABEACHITEM ) showpane++; // 1 Q
		}
	}
#if 0 // `ς PSPONEꗗ\
	{
		PSPONE *pspo;
		int sindex;

		pspo = psp->next;
		sindex = 0;
		while ( (pspo != NULL) && pspo->id.RegID[0] ){
			XMessage(NULL, NULL, XM_DbgLOG, T("index=%d ID=%s.%d Pane=%d path:%s"), sindex++, pspo->id.RegID, pspo->id.SubID, pspo->combo.pane, pspo->path);
			pspo = PSPONE_next(pspo);
		}
	}
#endif
	return TRUE;
}

void USEFASTCALL PPCuiWithPathForLock(PPC_APPINFO *cinfo, const TCHAR *path)
{
	TCHAR cmdline[CMDLINESIZE];

	if ( X_combos[0] & CMBS_REUSETLOCK ){
		if ( SendMessage(cinfo->hComboWnd, WM_PPXCOMMAND, KCW_pathfocus, (LPARAM)path) == (SENDCOMBO_OK + 1) ){
			return;
		}
	}

	if ( cinfo->combo ){
		if ( cinfo->info.hWnd != hComboFocusWnd ){
			thprintf(cmdline, TSIZEOF(cmdline), T("\"%s\" -noactive"), path);
		}else{
			thprintf(cmdline, TSIZEOF(cmdline), T("\"%s\""), path);
		}
		CallPPcParam(Combo.hWnd, cmdline);
		return;
	}
	PPCuiWithPath(cinfo->info.hWnd, path);
}

void RunNewPPc(PPCSTARTPARAM *psp, MAINWINDOWSTRUCT *mws)
{
	DWORD tmp;

#ifndef _WIN64 // [UԂȂx(Win64ł̓[UԂWin8:8T/Win8.1:128TȂ̂Ŏxsv)
	MEMORYSTATUS mstate;

	mstate.dwLength = sizeof(MEMORYSTATUS);
	GlobalMemoryStatus(&mstate);

	if ( mstate.dwAvailVirtual < (500 * MB) ){
		XMessage(NULL, NULL, XM_ImWRNld, MemWarnStr);
	}
#endif
	if ( X_MultiThread == 0 ){
		if ( IsTrue(PPxRegisterThread(NULL)) ){
			CreatePPcWindow(psp, mws);
			return;
		}
		{
		// PPcMain ʂɏĂԁH 폜\B
			TCHAR buf[100];

			thprintf(buf, TSIZEOF(buf), T("New PPc before initialize %d %d %d"),runcheck, MainThreadID, GetCurrentThreadId());
			PPxCommonExtCommand(K_SENDREPORT, (WPARAM)buf);
		}
		return;
	}

	CloseHandle(CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)PPcMain, psp, 0, &tmp));
}

int GetPPcSubID(const TCHAR *idstr, TCHAR *dest)
{
	const TCHAR *strptr;

	strptr = idstr;
	if ( Isupper(*strptr) ){
		*dest++ = *strptr++;
		while ( Islower(*strptr) ) *dest++ = *strptr++;
	}
	*dest = '\0';
	return strptr - idstr;
}

#if DRAWMODE == DRAWMODE_GDI
	#define FirstReadEntry(cinfo) read_entry(cinfo, RENTRY_READ)
#else
	void FirstReadEntry(PPC_APPINFO *cinfo)
	{
		read_entry(cinfo, RENTRY_READ);
		if ( ((cinfo->cel.Area.cx * cinfo->cel.Area.cy) < cinfo->e.cellIMax) &&
			 !(cinfo->X_win & XWIN_HIDESCROLL) ){
			SetWindowPos(cinfo->hScrollBarWnd, HWND_TOP, 0, 0, 0, 0,
					SWP_SHOWWINDOW | SWP_NOACTIVATE);
		}
	}
#endif


BOOL CreatePPcWindow(PPCSTARTPARAM *psp, MAINWINDOWSTRUCT *mws)
{
	static int firstfocus = 0; // R{ÑtH[JX̎wʒu
	BOOL usepath = FALSE;
	DWORD tmp;
	TCHAR focusID[REGEXTIDSIZE];
	BOOL lastinit = TRUE;
	PPC_APPINFO *cinfo;
	int showpane = PSPONE_PANE_DEFAULT;
	int select = FALSE;
	HMODULE hUser32;

	hUser32 = GetModuleHandle(StrUser32DLL);

	focusID[0] = '\0';
	if ( (psp != NULL) && (psp->next != NULL) ){
		showpane = psp->next->combo.pane;
		select = psp->next->combo.select;
	}

	cinfo = (PPC_APPINFO *)HeapAlloc(hProcessHeap, HEAP_ZERO_MEMORY, sizeof(PPC_APPINFO));
	if ( cinfo == NULL ){
		XMessage(NULL, NULL, XM_GrERRld, T("mem alloc error"));
		return FALSE;
	}
	// cinfo  0 fill ς
	if ( psp != NULL ){
		cinfo->combo = ( psp->next != NULL ) ? psp->next->combo.use : X_combo;
		cinfo->WinPos.show = (BYTE)psp->show;
	}else{
		cinfo->combo = X_combo;
		cinfo->WinPos.show = SW_SHOWDEFAULT;
	}

	if ( cinfo->combo ){
		cinfo->combo = -1; // Size ύXʒm𖳌ɂ
		if ( Combo.hWnd == NULL ){ // Combo VKN[tH[JXw
			firstfocus = 1;
		}
		cinfo->hComboWnd = InitCombo(psp);
		if ( cinfo->hComboWnd == NULL ) return FALSE;
	}

	//********** RegisterID  psp->next ͎ pspo 悤ɂȂ
	if ( RegisterID(cinfo, psp, &usepath) == FALSE ){
		ProcHeapFree(cinfo);
		return FALSE;
	}

	InitPPcWindow(cinfo, usepath);
	if ( cinfo->swin & SWIN_WBOOT ){
		if ( !(psp && psp->next && psp->next->id.RegID[0]) ){
			// 㑱̎w肪΁AAΏۂJ
			BootPairPPc(cinfo);
		}
	}
	InitCli(cinfo);

	if ( cinfo->combo == 0 ){
		if ( cinfo->WinPos.pos.left == (int)CW_USEDEFAULT ){ // `Ȃ璲
			// ShowWindow OɎw肷KvL
			PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, K_raw | K_a | K_F6, 0);
		}
		ShowWindow(cinfo->info.hWnd, cinfo->WinPos.show);
		FirstReadEntry(cinfo);
	}
	// X_IME == 1 ̂Ƃ́AWM_SETFOCUS  IMEOFF
	if ( X_IME == 2 ) PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, K_IMEOFF, 0);
										// CEChE̕\XV -------
	PPxRegist(cinfo->info.hWnd, cinfo->RegID, PPXREGIST_SETHWND);	// o^

	cinfo->hSubThread = CreateThread(NULL, 0,
			(LPTHREAD_START_ROUTINE)SubThread, cinfo, 0, &tmp);

	dd_init(cinfo);
										// tH[JX̍Đݒ
	if ( cinfo->combo ){
	// ̎
		WPARAM keycmd;

		if ( cinfo->ChdirLock < 0 ){ //  off
			cinfo->ChdirLock = 0;
		}else if ( (X_combos[0] & CMBS_DEFAULTLOCK) && (ComboInit == 0) ){
			cinfo->ChdirLock = 1;
		}

		keycmd = ((cinfo->WinPos.show != SW_SHOWNOACTIVATE) ?
						KCW_entry : (KCW_entry + KCW_entry_NOACTIVE)) +
				(showpane + 1) * KCW_entry_DEFPANE;
		if ( select ) setflag(keycmd, KCW_entry_SELECTNA);

		//Qڈȍ~͌vZĂȂƂ̂ő΍
		WmWindowPosChanged(cinfo);
		SendMessage(cinfo->hComboWnd, WM_PPXCOMMAND,
				keycmd, (LPARAM)cinfo->info.hWnd); // FocuŝSend
	}else{
		// off𔽉f
		if ( cinfo->ChdirLock < 0 ) cinfo->ChdirLock = 0;

		if ( (cinfo->swin & SWIN_WBOOT) && (cinfo->WinPos.show != SW_SHOWNOACTIVATE) ){ // A
			HWND PairHWnd;
			DWORD flag;

			flag = (cinfo->swin & SWIN_BFOCUES) | (cinfo->RegID[2] & PAIRBIT);
			// ANeBuA..B/ANeBuB..A Ȃ甽΂
			if ( (flag == 0) || (flag == (PAIRBIT | SWIN_BFOCUES)) ){
				PairHWnd = GetJoinWnd(cinfo);
				if ( PairHWnd != NULL ) ForceSetForegroundWindow(PairHWnd);
			}else{
				ForceSetForegroundWindow(cinfo->info.hWnd);
			}
		}
	}
										// ̂FixL
	resetflag(cinfo->swin, SWIN_BUSY);
	IOX_win(cinfo, TRUE);

	if ( (!cinfo->combo || !(X_combos[0] & CMBS_COMMONTREE)) && cinfo->XC_tree.mode ){
		PPC_Tree(cinfo, cinfo->XC_tree.mode, FALSE);
	}

	if ( !(psp && psp->next && psp->next->id.RegID[0]) && // ʂ̂ĂяoȂ
			(cinfo->swin & SWIN_JOIN) && CheckReady(cinfo) ){	// A
		if ( GetJoinWnd(cinfo) != NULL ) JoinWindow(cinfo);
	}
	// PPcN / psp 
	if ( psp != NULL ){
		if ( psp->Focus != 0 ){
			focusID[0] = 'C';
			if ( ComboPaneLayout == NULL ){
				focusID[1] = psp->Focus;
				focusID[2] = '\0';
			}else{
				GetPPcSubID(ComboPaneLayout, focusID + 1);
			}
		}
		if ( psp->next != NULL ){
			if ( psp->next->id.RegID[0] ){	// N
				lastinit = FALSE;
				RunNewPPc(psp, mws);
			}else{ // I / cmd p̃mۂĂȂ΂ŉ
				psp->next = NULL;
				if ( psp->AllocCmd == FALSE ){ // cmd ͐ÓIȂ̂ PSPONE 
					ThFree(&psp->th);
				}
			}
		}
	}
	// ȍ~ psp ̎gp֎~ **********************************************
	if ( (cinfo->docks.t.hWnd != NULL) ||
		 (cinfo->docks.b.hWnd != NULL) ||
		 (cinfo->hHeaderWnd != NULL) /*|| (cinfo.hToolBarWnd != NULL)*/ ){
		WmWindowPosChanged(cinfo); // ʒuĒ
	}

	if ( cinfo->combo ){	// ̉ǂݍ݂܂ʂ
		FirstReadEntry(cinfo);
	}

	if ( CountCustTable(T("_Delayed")) > 0 ){
		PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, KC_DODO, 0);
	}
	if ( cinfo->FirstCommand != NULL ){
		PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, K_FIRSTCMD, 0);
	}
	if ( IsExistCustTable(StrKC_main, T("FIRSTEVENT")) ){
		PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, K_E_FIRST, 0);
	}
	if ( lastinit && firstinit ){
		if ( cinfo->combo && (ComboThreadID != 0) ){
			if ( Combo.BaseCount < X_mpane.first ){
				MorePPc(NULL, &cinfo->mws);
			}else{
				HWND hWnd;

				hWnd = firstfocus ? NULL : cinfo->info.hWnd;
				firstfocus = 0;
				firstinit = 0;
				if ( focusID[0] != '\0' ){
					HWND hFocusWnd;

					hFocusWnd = GetHwndFromIDCombo(focusID);
					if ( hFocusWnd != NULL ) hWnd = hFocusWnd;
				}
				PostMessage(cinfo->hComboWnd, WM_PPXCOMMAND, KCW_ready, (LPARAM)hWnd);
			}
		}
	}

	cinfo->mws.ThreadID = GetCurrentThreadId();
	cinfo->mws.state = MWS_STATE_WORK;
	cinfo->mws.cinfo = cinfo;
	cinfo->mws.type = cinfo->combo ? MWS_TYPE_COMBOCHILD : MWS_TYPE_SINGLE;
	UsePPx();
	cinfo->mws.next = mws->next;
	mws->next = &cinfo->mws;
	FreePPx();
	DxSetMotion(cinfo->DxDraw, DXMOTION_NewWindow);

#if XTOUCH
	{
		GETDLLPROC(hUser32, RegisterTouchWindow);
		if ( DRegisterTouchWindow != NULL ){
			if ( DRegisterTouchWindow(cinfo->info.hWnd, 0) ){
				SetPopMsg(cinfo, POPMSG_MSG, MES_TOCH);
			}
			GETDLLPROC(hUser32, GetTouchInputInfo);
			GETDLLPROC(hUser32, CloseTouchInputHandle);
		}
	}
#endif
	GETDLLPROC(hUser32, GetGestureInfo);

	if ( !cinfo->list.scroll ){
		GETDLLPROC(hUser32, SetGestureConfig);
		if ( DSetGestureConfig != NULL ){
			DSetGestureConfig(cinfo->info.hWnd, 0, H_GestureConfig_count, H_GestureConfig, sizeof(GESTURECONFIG));
		}
	}

	if ( cinfo->combo ){ // TCYʒmLɂ
		PostMessage(cinfo->info.hWnd, WM_PPXCOMMAND, KCW_ready, 0);
	}
	return TRUE;
}

void PPCui(HWND hWnd, const TCHAR *cmdline)
{
	TCHAR param[CMDLINESIZE], dir[VFPS];
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	if ( cmdline != RunAlone ){
		if ( X_sps || (X_combo != COMBO_OFF) ){
			MorePPc(cmdline, &MainWindows);
			return;
		}
	}

	si.cb			= sizeof(si);
	si.lpReserved	= NULL;
	si.lpDesktop	= NULL;
	si.lpTitle		= NULL;
	si.dwFlags		= 0;
	si.cbReserved2	= 0;
	si.lpReserved2	= NULL;

	GetModuleFileName(hInst, dir, VFPS);
#ifdef WINEGCC
	tstrcpy(tstrrchr(dir, '\\') + 1, T(PPCEXE)); //Z:\...\PPC.EXE  Z:\...\ppc ɏC
#endif
	if ( cmdline ){
		thprintf(param, TSIZEOF(param), T("\"%s\" %s"), dir, cmdline);
	}else{
		thprintf(param, TSIZEOF(param), T("\"%s\""), dir);
	}
											// JgfBNg쐬
	*tstrrchr(dir, '\\') = '\0'; // Ṓu\PPC.EXEvȂ̂ŁA΍􂹂

	if ( IsTrue(CreateProcess(NULL, param, NULL, NULL, FALSE,
			CREATE_DEFAULT_ERROR_MODE, NULL, dir, &si, &pi)) ){
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}else{
		PPErrorBox(hWnd, dir, PPERROR_GETLASTERROR);
	}
}

void MorePPc(const TCHAR *cmdline, MAINWINDOWSTRUCT *mws)
{
	DWORD nexttop C4701CHECK, cmdtop C4701CHECK;
	PPCSTARTPARAM *psp = NULL, defpsp;
	ThSTRUCT th;

	if ( (cmdline == NULL) && (X_combo != COMBO_OFF) && (X_combos[0] & CMBS_TABMAXALONE) && (Combo.ShowCount >= X_mpane.limit) ){
		PPCui(NULL, RunAlone);
		return;
	}

	if ( cmdline != NULL ){
		defpsp.show = SW_SHOW;

		LoadParam(&defpsp, cmdline, FALSE);

//		if ( defpsp.alone ){ // VKvZXKvȃIvV
//			return FALSE;
//		}

		ThInit(&th);
		ThAppend(&th, &defpsp, sizeof(PPCSTARTPARAM));
		if ( defpsp.next != NULL ){
			nexttop = th.top;
			ThAppend(&th, defpsp.next, defpsp.th.top);
			ThFree(&defpsp.th);
		}
		if ( IsTrue(defpsp.UseCmd) ){
			cmdtop = th.top;
			((PPCSTARTPARAM *)th.bottom)->AllocCmd = TRUE;
			((PPCSTARTPARAM *)th.bottom)->cmd = (const TCHAR *)(DWORD_PTR)th.top;
			ThAddString(&th, defpsp.cmd);
		}
		psp = (PPCSTARTPARAM *)th.bottom;
		psp->th = th;
		if ( defpsp.next != NULL ){
			psp->next = (PSPONE *)ThPointer(&th, nexttop);  // C4701ok
		}
		if ( IsTrue(defpsp.UseCmd) ){
			psp->cmd = ThPointerT(&th, cmdtop);  // C4701ok
		}
	}
	RunNewPPc(psp, mws);
}

// WM_COPYDATA oR PPc s
void SendCallPPc(COPYDATASTRUCT *copydata)
{
#define PSP ((PPCSTARTPARAM *)th.bottom)
	ThSTRUCT th;

	ThInit(&th);
	ThAppend(&th, copydata->lpData, copydata->cbData);
	ReplyMessage(TRUE);

	PSP->th = th;
	// |C^ItZbgۂ̒lɕϊ
	if ( IsTrue(PSP->UseCmd) ){
		PSP->AllocCmd = TRUE;
		PSP->cmd = ThPointerT(&th, (size_t)(PSP->cmd));
	}
	if ( PSP->next != NULL ){
		PSP->next = (PSPONE *)ThPointer(&th, sizeof(PPCSTARTPARAM));
		if ( IsTrue(PSP->Reuse) ) ReuseFix(PSP); // /R Ȃ ID
	}
	RunNewPPc(PSP, &MainWindows);
#undef PSP
}
