/*-----------------------------------------------------------------------------
	Paper Plane xUI	 Virtual File System				` FindFirst/Next `
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#define ONVFSDLL		// VFS.H  DLL export w
#include <shlobj.h>
#include "PPX.H"
#include "PPD_DEF.H"
#include "PPX_64.H"
#include "VFS.H"
#include "VFS_STRU.H"
#define DefxIShellFolder2
#include "VFS_FF.H"
#pragma hdrstop

const DWORD CDoffset[] = { CDHEADEROFFSET1, CDHEADEROFFSET2, CDHEADEROFFSET3, MAX32 };

#define TypeName_Normal NilStr
const TCHAR TypeName_stream[] = VFSFFTYPENAME_STREAM;
const TCHAR TypeName_HTML[] = VFSFFTYPENAME_HTML;
const TCHAR TypeName_FAT[] = VFSFFTYPENAME_FAT;
const TCHAR TypeName_CD[] = VFSFFTYPENAME_CD;
const TCHAR TypeName_ZIPfolder[] = VFSFFTYPENAME_ZIPfolder;
const TCHAR TypeName_LHAfolder[] = VFSFFTYPENAME_LHAfolder;
const TCHAR TypeName_CABfolder[] = VFSFFTYPENAME_CABfolder;
const TCHAR TypeName_ARCfolder[] = VFSFFTYPENAME_ARCfolder;
const TCHAR TypeName_DriveList[] = VFSFFTYPENAME_DriveList;
const TCHAR TypeName_FTP[] = VFSFFTYPENAME_FTP;
const TCHAR TypeName_root[] = VFSFFTYPENAME_root;
const TCHAR TypeName_Network[] = VFSFFTYPENAME_Network;
const TCHAR TypeName_LongPath[] = VFSFFTYPENAME_LongPath;
const TCHAR TypeName_SHN[] = VFSFFTYPENAME_SHN;

const TCHAR *TypeName_Disk[] = { TypeName_FAT, VFSFFTYPENAME_exFAT, VFSFFTYPENAME_NTFS };

HANDLE AuxOpFF(TCHAR *Fname, TCHAR *Fwild, WIN32_FIND_DATA *findfile)
{
	ERRORCODE result;
	TCHAR cmdstr[CMDLINESIZE];
	HANDLE hFF;
	PPXAPPINFO info;

	info.Function = (PPXAPPINFOFUNCTION)PPxDefInfoFunc;
	info.Name = T("aux-list");
	info.RegID = T("###");
	info.hWnd = NULL;
	if ( *Fwild == 'r' ){
		info.RegID = ++Fwild;
		for (;;){
			if ( *Fwild == '\0' ) break;
			if ( *Fwild != ',' ){
				Fwild++;
				continue;
			}
			*Fwild++ = '\0';
			if ( *Fwild == 'w' ){
				Fwild++;
				info.hWnd = (HWND)GetDigitNumber((const TCHAR **)&Fwild);
			}
		}
	}

	for (;;){
		result = AuxOperation(&info, T("list"), Fname + 4 /* aux: */, NilStr, NilStr, cmdstr, AUXOP_ASYNC);
		if ( result != NO_ERROR ){
			SetLastError(result);
			return INVALID_HANDLE_VALUE;
		}

		if ( cmdstr[0] == '\0' ){
			SetLastError(ERROR_INVALID_DRIVE);
			return INVALID_HANDLE_VALUE;
		}
		CatPath(NULL, cmdstr, T("*"));
		hFF = VFSFindFirst(cmdstr, findfile);
		if ( hFF != INVALID_HANDLE_VALUE ) return hFF;
		result = GetLastError();
		if ( (result == ERROR_INVALID_PASSWORD) && (AuthHostCache[0] != '\0') ){
			AuthHostCache[0] = '\1';
			AuthHostCache[1] = '\0';
			continue;
		}
		return INVALID_HANDLE_VALUE;
	}
}

#define CP_UNDLL 0x106ffff
BOOL FFCheckUndll(VFSFINDFIRST *VFF, VUCHECKSTRUCT *vcs, int floatheader, const TCHAR *DllName)
{
	UN_DLL *uD;
	int i;

	vcs->floatheader = floatheader;
	vcs->header += floatheader; // float ̏ꍇ́A납猟
	uD = undll_list;
	for ( i = 0 ; i < undll_items ; i++, uD++ ){
		if ( uD->flags & UNDLLFLAG_DISABLE_DIR ) continue;
		if ( (DllName != NULL) && tstricmp(uD->DllName, DllName) ) continue;
 		if ( uD->VUCheck(uD, vcs) == FALSE ) continue;
		if ( UnArc_IsReady(uD) == FALSE ) break;

		VFF->v.UN.uD = uD;
		#ifdef UNICODE
		if ( (uD->UnOpenArchiveW != NULL) && (UnDllCodepage == CP_ACP) ){
			VFF->v.UN.Ha =
				uD->UnOpenArchiveW(GetFocus(), vcs->filenameW, M_INIT_FILE_USE);
			if ( VFF->v.UN.Ha == NULL ) continue;
			uD->codepage = CP_UNDLL;
		}else{
			const char *name;

			if ( uD->SetUnicodeMode(TRUE) && (UnDllCodepage == CP_ACP) ){
				uD->codepage = CP_UTF8;
				name = vcs->filename8;
			}else{
				uD->codepage = UnDllCodepage;
				name = vcs->filename;
			}
			VFF->v.UN.Ha = uD->UnOpenArchive(GetFocus(), name, M_INIT_FILE_USE);
			if ( VFF->v.UN.Ha == NULL ){
				VFF->v.UN.uD->SetUnicodeMode(FALSE);
				continue;
			}
		}
		#else
			VFF->v.UN.Ha =
				uD->UnOpenArchive(GetFocus(), vcs->filename, M_INIT_FILE_USE);
			if ( VFF->v.UN.Ha == NULL ) continue;
		#endif
		return TRUE;
	}
	return FALSE;
}

void USEFASTCALL SetDummyFindData(WIN32_FIND_DATA *findfile)
{
	findfile->ftCreationTime.dwLowDateTime		= 0;
	findfile->ftCreationTime.dwHighDateTime		= 0;
	findfile->ftLastAccessTime.dwLowDateTime	= 0;
	findfile->ftLastAccessTime.dwHighDateTime	= 0;
	findfile->ftLastWriteTime.dwLowDateTime		= 0;
	findfile->ftLastWriteTime.dwHighDateTime	= 0;
	findfile->nFileSizeHigh	= 0;
	findfile->nFileSizeLow	= 0;
	findfile->cAlternateFileName[0] = '\0';
}

void USEFASTCALL SetDummydir(WIN32_FIND_DATA *findfile, const TCHAR *name)
{
	SetDummyFindData(findfile);
	findfile->dwFileAttributes = FILE_ATTRIBUTE_DIRECTORY;
	tstrcpy(findfile->cFileName, name);
}

int USEFASTCALL FFStepInfo(WIN32_FIND_DATA *findfile, int *step)
{
	if ( *step >= FFSTEP_ENTRY ) return -1;
	if ( *step <= FFSTEP_NOMORE ){
		SetLastError(ERROR_NO_MORE_FILES);
		return 0;
	}
	SetDummydir(findfile, (*step == FFSTEP_THIS) ? T(".") : T("..") );
	(*step)++;
	return 1;
}

void AddDriveList(ThSTRUCT *dirs, const TCHAR *name)
{
	const TCHAR *lp;
												// _uȂ
	lp = (const TCHAR *)dirs->bottom;
	while ( *lp != '\0' ){
		if ( tstricmp(name, lp) == 0 ) break;
		lp += tstrlen(lp) + 1;
	}
	if ( *lp != '\0' ) return;
											// ۑ
	ThAddString(dirs, name);
}

/*-----------------------------------------------------------------------------
char	*FindPathS(char *src)

	擪ŏɌu\v̈ʒum点B
	Ȃ當̖

	src			n߂ʒu

߂l
	(char *)	u\vANULL ^[~l[^̈ʒu
-----------------------------------------------------------------------------*/
char *FindPathS(char *src)
{
	while ( (*src) && (*src != '\\') ){
		#ifndef UNICODE
			if (IskanjiA(*src++)){
				if ( *src ) src++;
			}
		#else
			src++;
		#endif
	}
	return src;
}
/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
VFSFINDFIRST * USEFASTCALL IsVFSFINDFIRST(HANDLE hFF)
{
	VFSFINDFIRST *VFF;

	VFF = (VFSFINDFIRST *)hFF;
//	if ( IsTrue(IsBadReadPtr(VFF, sizeof(VFSFINDFIRST))) ) return NULL;
	if ( VFF->ID != VFSFINDFIRSTID ) return NULL;
	return VFF;
}
/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
VFSDLL void PPXAPI VFSGetFFInfo(HANDLE hFF, int *mode, TCHAR *type, void **dt_opt)
{
	VFSFINDFIRST *VFF;
	TCHAR *p;

	VFF = IsVFSFINDFIRST(hFF);

	if ( (DWORD_PTR)mode <= VFSGETFFINFOMODE_IDMAX ){
		if ( VFF->mode == VFSDT_LFILE ){
			if ( VFF->mode == VFSGETFFINFOMODE_LF_BASE ){
				GetOptionData_ListFile(VFF); // ǉ̊mF
				tstplimcpy(type, VFF->v.LFILE.base, VFPS);
			}else{
				*type = '\0';
			}
		}
		return;
	}

	switch( VFF->mode ){
		case VFSDT_LFILE:
			*dt_opt = VFF->v.LFILE.readptr; // VFSGETFFINFOMODE_LF_READPTR
			break;
		case VFSDT_SUSIE:
			*dt_opt = (void *)(size_t)(VFF->v.SU.su - susie_list + 1);
			break;
		case VFSDT_UN:
			*dt_opt = (void *)(size_t)(VFF->v.UN.uD - undll_list + 1);
			break;
		default:
			*dt_opt = NULL;
	}
	*mode = VFF->mode;

	p = tstplimcpy(type, VFF->TypeName, VFSGETFFINFO_TYPESIZE - 1);
	if ( p != type ){
		*p = ' ';
		*(p + 1) = '\0';
	}
}

const TCHAR FDResPubString[] = T("FDResPub");

FF_MC *InitMCsubdir(VFSFINDFIRST *VFF)
{
	FF_MC *mc;

	VFF->mode = VFSDT_DLIST;
	mc = &VFF->v.MC;
	ThInit(&mc->dirs);
	ThInit(&mc->files);
	mc->f_off = 0;
	mc->d_off = 0;
	ThAddString(&mc->dirs, T("."));
	ThAddString(&mc->dirs, T(".."));
	return mc;
}

// Vista ȍ~ PC ꗗ( \\ )
ERRORCODE FindUncPClist(VFSFINDFIRST *VFF, WIN32_FIND_DATA *findfile)
{
	FF_MC *mc;
	TCHAR textbuf[VFPS];
	int index = 0;

	// lbg[NTL𔻒f
	SC_HANDLE hService;
	SC_HANDLE hSCManager;
	SERVICE_STATUS fdinfo;

	fdinfo.dwCurrentState = SERVICE_RUNNING;
	hSCManager = OpenSCManager(NULL, NULL, GENERIC_READ);
	if ( hSCManager != NULL ){
		hService = OpenService(hSCManager, FDResPubString, SERVICE_QUERY_STATUS);
		if ( hService != NULL ){
			QueryServiceStatus(hService, &fdinfo);
			CloseServiceHandle(hService);
		}
		CloseServiceHandle(hSCManager);
	}
	// L
	if ( fdinfo.dwCurrentState != SERVICE_STOPPED ) return ERROR_DIRECTORY;

	// lbg[NTȂ̂œƎ
	mc = InitMCsubdir(VFF);
	VFF->TypeName = TypeName_Network;

	ThAddString(&mc->dirs, T("+"));	// g PC ꗗ

	((DWORD *)textbuf)[3] = 0;
	GetCustData(StrX_dlf, textbuf, sizeof(DWORD) * 4);
	if ( !(((DWORD *)textbuf)[3] & XDLF_NODISPSHARE) ){
									// qXgPC𒊏o
		UsePPx();
		for ( ; ; ){
			const TCHAR *hisp;
			TCHAR *p;
			int mode;

			hisp = EnumHistory(PPXH_PPCPATH, index++);
			if ( hisp == NULL ) break;

			p = VFSGetDriveType(hisp, &mode, NULL);
			// UNC ȊO / u\\v͖
			if ( (p == NULL) || (mode != VFSPT_UNC) || (*p == '\0') ) continue;

			tstrcpy(textbuf, hisp + 2); // u\\vXLbv
			p = FindPathSeparator(p);
			if ( p != NULL ){
				p = textbuf + (p - (hisp + 2));
				*p = '\0';
			}
			AddDriveList(&mc->dirs, textbuf);
		}
		FreePPx();
	}

	ThAddString(&mc->files, NilStr);

	VFSFindNext((HANDLE)VFF, findfile);
	return NO_ERROR;
}

// 24H2 : 7z bz2 gz rar tar tbz2 tgz txz tzst xz zst
BOOL IsArcfolderFile(const TCHAR *filename, BYTE *header)
{
	if (
		((header[0] == '7') && (header[1] == 'z') && (header[2] == (BYTE)'\xbc')) || // 7z
		((header[0] == 'B') && (header[1] == 'Z') && (header[2] == 'h')) || // bz2 tbz2
		((header[0] == '\x1f') && (header[1] == (BYTE)'\x82')) || // gz tgz
		((header[0] == 'R') && (header[1] == 'a') && (header[3] == '!')) || // rar
		(tstrstr(filename, T(".tar")) != NULL) ||
		(tstrstr(filename, T(".tzst")) != NULL) ||
		((header[0] == '7') && (header[1] == 'z') && (header[2] == 'X')) || // xz
		(tstrstr(filename, T(".zst")) != NULL)
	){
		return TRUE;
	}else{
		return FALSE;
	}
}

#define FDHEADERSIZE	VFS_check_size
#define FDHEADERMARGIN	0x100

// fBNgt@C ----
// ERROR_BAD_PATHNAME	t@CłȂ
// ERROR_FILE_EXISTS	`ǁASłȂt@C
// ERROR_INVALID_DRIVE	`Ȃt@C
ERRORCODE FileDirectory(TCHAR *fname, VFSFINDFIRST *VFF, WIN32_FIND_DATA *findfile, const TCHAR *fwild, TCHAR *DllName)
{
	HANDLE hFile;
	BYTE header[FDHEADERSIZE + FDHEADERMARGIN];
	DWORD hsize;
	TCHAR dir[VFPS], *subdir = T("");

	hFile = CreateFileL(fname, GENERIC_READ,
			FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	if ( hFile == INVALID_HANDLE_VALUE ){
		for ( ; ; ){				// 
			tstrcpy(dir, fname);
			subdir = tstrchr(dir, '.');
			if ( subdir == NULL ) break;
			subdir = VFSFindLastEntry(subdir);
			if ( *subdir != '\\' ) break;
			*subdir = '\0';
			subdir++;
			hFile = CreateFileL(dir, GENERIC_READ,
					FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING,
					FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
			break;
		}
		if ( hFile == INVALID_HANDLE_VALUE ){	// S
			tstrcpy(dir, fname);
			for ( ; ; ){
				subdir = VFSFindLastEntry(dir);
				if ( *subdir == '\0' ) return ERROR_BAD_PATHNAME; // t@CłȂ
				*subdir = '\0';
				hFile = CreateFileL(dir, GENERIC_READ,
						FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
				if ( hFile != INVALID_HANDLE_VALUE ) break;
			}
			subdir = fname + (subdir - dir);
			if ( *subdir == '\\' ) subdir++;
		}
		fname = dir;
	}
	if ( DllName != NULL ){
		subdir = FindPathSeparator(DllName);
		if ( subdir != NULL ){
			*subdir++ = '\0';
		}else{
			subdir = T("");
		}

		if ( tstrcmp(DllName, VFS_TYPEID_STREAM) == 0 ){
			FindFirstStream(hFile, &VFF->v.STREAM, fname);
			VFF->mode = VFSDT_STREAM;
			VFF->TypeName = TypeName_stream;
			VFSFindNext((HANDLE)VFF, findfile);
			return NO_ERROR;
		}
	}
	hsize = ReadFileHeader(hFile, header, FDHEADERSIZE);
	CloseHandle(hFile); // lbg[NƁAŎԂ|邱Ƃ
										// List File --------------------------
	{
		BYTE *nobom;

		nobom = memcmp(header, UTF8HEADER, sizeof(UTF8HEADER) - 1) ?
				header : header + sizeof(UTF8HEADER) - 1;
		if ( !memcmp(nobom, LHEADER, sizeof(LHEADER) - 1) ||
			 !memcmp(header + 2, L";ListFile\r\n",
				sizeof(L";ListFile\r\n") - sizeof(WCHAR)) ){
			if ( *subdir != '\0' ) return ERROR_INVALID_DRIVE;
			return InitFindFirstListFile(VFF, fname, findfile, FALSE);
		}
		if ( !memcmp(header, LHEADERJSONO, sizeof(LHEADERJSONO) - 1) ||
			 !memcmp(header, LHEADERJSONT, sizeof(LHEADERJSONT) - 1) ){
			if ( *subdir != '\0' ) return ERROR_INVALID_DRIVE;
			return InitFindFirstListFile(VFF, fname, findfile, TRUE);
		}
	}
										// html File --------------------------
	if ( *header == '<' ){
		BYTE *p;
		DWORD i;

		p = header + 1;
		for ( i = 0 ; i < min(1000, hsize) ; i++, p++ ){
			if ( (*p < 0x20) || (*p > 0x7f) ) break;
			if ( *p == '>' ){
				if ( MakeWebList(&VFF->v.MC, fname, TRUE) != NO_ERROR ){
					return ERROR_FILE_EXISTS;
				}
				VFF->mode = VFSDT_HTTP;
				VFF->TypeName = TypeName_HTML;
				VFSFindNext((HANDLE)VFF, findfile);
				return NO_ERROR;
			}
		}
	}
									// FAT Image ------------------------------
	if ( (DllName == NULL) || (tstrcmp(DllName, VFS_TYPEID_DISK) == 0) ){
		const DWORD *o;
		DWORD pc9801drive;

		// wildcard̏ڍ׎w͖T|[g
		if ( (*fwild != '\0') && (*fwild != '*') ) return ERROR_FILE_NOT_FOUND;

		for ( o = FDIoffset ; *o != MAX32 ; o++ ){
			int fatresult;

			fatresult = CheckFATImage(header + *o, header + hsize);
			if ( fatresult == CHECKFAT_NONE ) continue;
			VFF->TypeName = TypeName_Disk[fatresult - CHECKFAT_FIRST];
			VFF->mode = VFSDT_FATIMG;

			if ( OpenFATImage(&VFF->v.FAT.fats, fname, *o) == FALSE ){
				return ERROR_NO_MORE_FILES;
			}

			if ( FindEntryFATImage(&VFF->v.FAT.fats, subdir, findfile) == FALSE ){
				CloseFATImage(&VFF->v.FAT.fats);
				return ERROR_NO_MORE_FILES;
			}
			return NO_ERROR;
		}
		if ( (hsize >= 0x2000) && ((pc9801drive = GetPC9801FirstDriveSector(header)) != 0) ){
			VFF->TypeName = TypeName_FAT;
			VFF->mode = VFSDT_FATIMG;
			if ( OpenFATImage(&VFF->v.FAT.fats, fname, pc9801drive) == FALSE ){
				return ERROR_NO_MORE_FILES;
			}

			if ( FindEntryFATImage(&VFF->v.FAT.fats, subdir, findfile) == FALSE ){
				CloseFATImage(&VFF->v.FAT.fats);
				return ERROR_NO_MORE_FILES;
			}
			return NO_ERROR;
		}
	}
									// CD Image ------------------------------
	if ( ((DllName == NULL) || (tstrcmp(DllName, TypeName_CD) == 0)) && (hsize > 38 * 1024) ){
		const DWORD *o;

		for ( o = CDoffset ; *o != MAX32 ; o++ ){
			if ( memcmp( (char *)header + *o, StrISO9660, CDHEADERSIZE) &&
				 memcmp( (char *)header + *o, StrUDF, CDHEADERSIZE) ) continue;
			if ( OpenCDImage(&VFF->v.CD.cds, fname, *o) == FALSE ){
				continue;
			}
			VFF->mode = VFSDT_CDIMG;
			VFF->TypeName = TypeName_CD;
			if ( FindEntryCDImage(&VFF->v.CD.cds, subdir, findfile) == FALSE ){
				CloseCDImage(&VFF->v.CD.cds);
				return ERROR_NO_MORE_FILES;
			}
			if ( (*fwild != '\0') && (*fwild != '*') ) for (;;){
				if ( IsTrue(FindEntryCDImage(&VFF->v.CD.cds, NULL, findfile)) ){
					if ( tstricmp(findfile->cFileName, fwild) == 0 ) break;
				}else{
					CloseCDImage(&VFF->v.CD.cds);
					return ERROR_NO_MORE_FILES;
				}
			}
			return NO_ERROR;
		}
	}
	if ( *subdir == '\0' ){ // ȉATufBNgȂƂDLL
										// UnDll ------------------------------
		VUCHECKSTRUCT vcs;

		#ifdef UNICODE
			char UTemp[VFPS];
			#define TFILENAME UTemp
			vcs.filenameW = fname;
			UnicodeToAnsi(fname, UTemp, VFPS);
			WideCharToMultiByteU8(CP_UTF8, 0, fname, -1, vcs.filename8, VFPS, NULL, NULL);
		#else
			#define TFILENAME fname
		#endif

		vcs.filename = TFILENAME;
		vcs.header = header;
		vcs.fsize = hsize;
		#undef TFILENAME

		if ( IsTrue(FFCheckUndll(VFF, &vcs, 0, DllName)) ||
			 IsTrue(FFCheckUndll(VFF, &vcs, 1, DllName)) ){
			VFF->mode = VFSDT_UN;
			VFF->TypeName = VFF->TypeNameBuf;
			#ifdef UNICODE
				if ( VFF->v.UN.uD->UnFindFirstW != NULL ){
					strcpyW(VFF->v.UN.wild, fwild);
				}else{
					UnicodeToAnsi(fwild, (char *)VFF->v.UN.wild, sizeof(VFF->v.UN.wild));
				}
			#else
				strcpy(VFF->v.UN.wild, fwild);
			#endif
			tstplimcpy(VFF->TypeNameBuf, VFF->v.UN.uD->DllName, VFSGETFFINFO_TYPESIZE - 1);
			VFF->v.UN.step = FFSTEP_THIS;
			FFStepInfo(findfile, &VFF->v.UN.step);
			return NO_ERROR;
		}
										// Susie ------------------------------
		{
			THREADSTRUCT *ts;
			const TCHAR *OldTname;
			TCHAR *fp;
			SUSIE_DLL *sudll;
			int i;
			#ifdef UNICODE
				char STemp[VFPS];
				#define TFILENAME STemp
				UnicodeToAnsi(fname, STemp, VFPS);
			#else
				#define TFILENAME fname
			#endif

			ts = GetCurrentThreadInfo();
			if ( ts != NULL ) OldTname = ts->ThreadName;

			fp = FindLastEntryPoint(fname);
			sudll = susie_list;
			for ( i = 0 ; i < susie_items ; i++, sudll++ ){
				int s;

				if ( DllName == NULL ){
					if ( (sudll->flags & (VFSSUSIE_ARC | VFSSUSIE_NOAUTODETECT)) !=
						VFSSUSIE_ARC ){
						continue;
					}
				}else if ( !(sudll->flags & VFSSUSIE_ARC) ||
					tstricmp((TCHAR *)(Thsusie_str.bottom + sudll->DllNameOffset), DllName) ){
					continue;
				}
				if ( CheckAndLoadSusiePlugin(sudll, fp, ts, VFS_DIRECTORY) == FALSE){
					continue;
				}
				#ifdef UNICODE
					if ( sudll->IsSupportedW != NULL ){
						if ( !sudll->IsSupportedW(fname, header) ) continue;
					}else{
						if ( !sudll->IsSupported(TFILENAME, header) ) continue;
					}
					VFF->v.SU.finfoW = NULL;
				#else
					if ( !sudll->IsSupported(TFILENAME, header) ) continue;
				#endif

				#ifdef UNICODE
					if ( sudll->GetArchiveInfoW != NULL ){
						s = sudll->GetArchiveInfoW(fname, 0, SUSIE_SOURCE_DISK, (HLOCAL *)&VFF->v.SU.fiH);
						if ( (s != SUSIEERROR_NOERROR) || (VFF->v.SU.fiH == NULL) ){
							continue;
						}

						VFF->v.SU.finfo = NULL;
						VFF->v.SU.finfoW = LocalLock(VFF->v.SU.fiH);
						VFF->v.SU.finfomaxW = (SUSIE_FINFOW *)(BYTE *)((BYTE *)VFF->v.SU.finfoW + LocalSize(VFF->v.SU.fiH));
					}
					if ( VFF->v.SU.finfoW == NULL )
				#endif
				{
					s = sudll->GetArchiveInfo(TFILENAME, 0, SUSIE_SOURCE_DISK, (HLOCAL *)&VFF->v.SU.fiH);
					if ( (s != SUSIEERROR_NOERROR) && (s != SUSIEERROR_UNKNOWNFORMAT) ){
						continue; //SUSIEERROR_UNKNOWNFORMAT(2) LHASAD.SPIł̐l
					}
					if ( VFF->v.SU.fiH == NULL ) continue;
					VFF->v.SU.finfo = LocalLock(VFF->v.SU.fiH);
					if ( VFF->v.SU.finfo == NULL ) continue;
					VFF->v.SU.finfomax = (SUSIE_FINFO *)(BYTE *)((BYTE *)VFF->v.SU.finfo + LocalSize(VFF->v.SU.fiH));
				}

				VFF->mode = VFSDT_SUSIE;
				VFF->v.SU.su = sudll;

				VFF->TypeName = VFF->TypeNameBuf;
				#ifdef UNICODE
					stplimcpyW(VFF->TypeNameBuf, (WCHAR *)(Thsusie_str.bottom + sudll->DllNameOffset), VFSGETFFINFO_TYPESIZE - 1);
				#else
					stplimcpy(VFF->TypeNameBuf, Thsusie_str.bottom + sudll->DllNameOffset, VFSGETFFINFO_TYPESIZE - 1);
				#endif

				VFF->v.SU.step = FFSTEP_THIS;
				FFStepInfo(findfile, &VFF->v.SU.step);

				if ( ts != NULL ) ts->ThreadName = OldTname;
				return NO_ERROR;
			}
			if ( ts != NULL ) ts->ThreadName = OldTname;
			#undef TFILENAME
		}
	}
									// ZIP (zipflder.dll) ---------------------
	if ( (DllName == NULL) ?
			IsZIPflderFile(header) : (tstrcmp(DllName, zipfldrName) == 0) ){
		if ( IsTrue(ZipFolderFF(&VFF->v.ZIPO, fname, subdir, findfile, 0)) ){
			VFF->mode = VFSDT_ZIPFOLDER;
			VFF->TypeName = TypeName_ZIPfolder;
			return NO_ERROR;
		}
	}
									// LZH (lzhfldr2.dll) ---------------------
	if ( (DllName == NULL) ?
			IsLZHflderFile(header) : (tstrcmp(DllName, lzhfldrName) == 0) ){
		if ( IsTrue(ZipFolderFF(&VFF->v.ZIPO, fname, subdir, findfile, 1)) ){
			VFF->mode = VFSDT_LZHFOLDER;
			VFF->TypeName = TypeName_LHAfolder;
			return NO_ERROR;
		}
	}
									// CAB (cabview.dll) ---------------------
	if ( (DllName == NULL) ?
			IsCABflderFile(header) : (tstrcmp(DllName, cabfldrName) == 0) ){
		if ( IsTrue(ZipFolderFF(&VFF->v.ZIPO, fname, subdir, findfile, 2)) ){
			VFF->mode = VFSDT_CABFOLDER;
			VFF->TypeName = TypeName_CABfolder;
			return NO_ERROR;
		}
	}
	// 7z, bz2, gz, rar, tar, tbz2, tgz, txz, tzst, xz, zst (zipflder.dll) ----
	if ( (DllName == NULL) ?
			IsArcfolderFile(fname, header) : (tstrcmp(DllName, arcfolderID) == 0) ){
		if ( IsTrue(ZipFolderFF(&VFF->v.ZIPO, fname, subdir, findfile, 3)) ){
			VFF->mode = VFSDT_ARCFOLDER;
			VFF->TypeName = TypeName_ARCfolder;
			return NO_ERROR;
		}
	}
									// CD/DVD Image --------------------------
	if ( ((DllName == NULL) || (tstrcmp(DllName, TypeName_CD) == 0)) && (hsize > 38 * 1024) && (*(DWORD *)header == 0) ){
		hFile = CreateFileL(fname, GENERIC_READ,
				FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
				OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if ( MAX32 == SetFilePointer(hFile, CDHEADEROFFSET4, NULL, FILE_BEGIN) ){
			CloseHandle(hFile);
		}else{
			CloseHandle(hFile);

			if ( OpenCDImage(&VFF->v.CD.cds, fname, CDHEADEROFFSET4) == FALSE ){
				return ERROR_NO_MORE_FILES;
			}
			VFF->mode = VFSDT_CDIMG;
			VFF->TypeName = TypeName_CD;
			if ( FindEntryCDImage(&VFF->v.CD.cds, subdir, findfile)==FALSE){
				CloseCDImage(&VFF->v.CD.cds);
				return ERROR_NO_MORE_FILES;
			}
			return NO_ERROR;
		}
	}
	return ERROR_INVALID_DRIVE;
}

#if UseExtraLongPath
HANDLE VFSFindFirstLong(const TCHAR *dir, WIN32_FIND_DATA *findfile)
{
	TCHAR Fname[MAX_PATH_EX + 0x100], *dest = Fname + 7;

	if ( expathbuf[0] == '\0' ){
		SetLastError(ERROR_FILENAME_EXCED_RANGE);
		return INVALID_HANDLE_VALUE;
	}

	Fname[0] = ':';
	Fname[1] = '?';
	Fname[2] = ':';
	Fname[3] = '\\';
	Fname[4] = '\\';
	Fname[5] = '?';
	Fname[6] = '\\';
	if ( dir[3] == '\\' ){
		Fname[7] = 'U';
		Fname[8] = 'N';
		Fname[9] = 'C';
		dest += 3;
		dir++;
	}
	dest = tstplimcpy(dest, expathbuf, MAX_PATH_EX + 0x100 - 1);
	tstrlimcpy(dest, dir + 2, MAX_PATH_EX + 0x100 - 1 - (dest - Fname));
	XMessage(NULL, NULL, XM_DbgLOG, "long %d",tstrlen(Fname));
	XMessage(NULL, NULL, XM_DbgLOG, "%s",expathbuf);
	XMessage(NULL, NULL, XM_DbgLOG, "%s",Fname);
	return VFSFindFirst(Fname, findfile);
}
#else
#define VFSFindFirstLong(dir, findfile) _VFSFindFirstLong()
HANDLE _VFSFindFirstLong(void)
{
	SetLastError(ERROR_FILENAME_EXCED_RANGE);
	return INVALID_HANDLE_VALUE;
}
#endif

/*-----------------------------------------------------------------------------

-----------------------------------------------------------------------------*/
VFSDLL HANDLE PPXAPI VFSFindFirst(const TCHAR *dir, WIN32_FIND_DATA *findfile)
{
	VFSFINDFIRST *VFF;
	ERRORCODE errorcode;
	ERRORCODE realerror = NO_ERROR; // GNC/UNC\:NO_ERROR / ̌
	// ERROR_BADKEY : FindFirstFile ASHN 𒼐ڎgp (ʏłȂG[𗘗pĂ)
	TCHAR *Fname, FnameBuf[VFPS], *Fwild;
	int mode, force;
	TCHAR *vp;
										// Ώۂ̎ނ𔻕 ---------------
	if ( (dir[0] == ':') && (dir[1] == '?') ){
		if ( dir[2] == ':' ){
			Fname = (TCHAR *)(dir + 3); //  const  ( VFSFindFirstLong oR̂ )
		}else{
			return VFSFindFirstLong(dir, findfile);
		}
	}else{
		tstrcpy(FnameBuf, dir);
		Fname = FnameBuf;
	}
	vp = VFSGetDriveType(Fname, &mode, &force);
	if ( vp == NULL ){		// ނȂΎw̉\Ή
		VFSFullPath(Fname, (TCHAR *)dir, NULL);
		vp = VFSGetDriveType(Fname, &mode, &force);
		if ( vp == NULL ){	// łނȂG[
			errorcode = ERROR_BAD_PATHNAME;
			goto error_nofree;
		}
	}
										// pnh쐬 ---------------
	VFF = HeapAlloc(DLLheap, 0, sizeof(VFSFINDFIRST) );
	if ( VFF == NULL ){
		errorcode = ERROR_NOT_ENOUGH_MEMORY;
		goto error_nofree;
	}
	VFF->ID = VFSFINDFIRSTID;
	VFF->cb = NULL;
										// t@C}XN𕪗 ---------------
	Fwild = FindPathSeparator(Fname);
	if ( Fwild == NULL ) Fwild = Fname;
	for ( ; ; ){
		TCHAR *p;

		p = FindPathSeparator(Fwild + 1);
		if ( p == NULL ) break;
		Fwild = p;
	}
	*Fwild++ = '\0';
										// ޕʂ̏ -----------------------
	switch (mode){
		case VFSPT_RAWDISK: {	// "#A:"  "\\.\A:" ɕϊ
			TCHAR readdrive[8];

			thprintf(readdrive, TSIZEOF(readdrive), T("\\\\.\\%c:"), *(vp - 2));
			if ( IsTrue(OpenFATImage(&VFF->v.FAT.fats, readdrive, 0)) ){
				VFF->mode = VFSDT_FATDISK;
				VFF->TypeName = TypeName_FAT;
				while ( *vp == '\\' ) vp++;
				if ( FindEntryFATImage(&VFF->v.FAT.fats, vp, findfile) == FALSE ){
					errorcode = *vp ? ERROR_PATH_NOT_FOUND : ERROR_FILE_NOT_FOUND;
					CloseFATImage(&VFF->v.FAT.fats);
					goto error;
				}
				return (HANDLE)VFF;
			}
			if ( IsTrue(OpenCDImage(&VFF->v.CD.cds, readdrive, CDHEADEROFFSET1)) ){
				VFF->mode = VFSDT_CDDISK;
				VFF->TypeName = TypeName_CD;
				while ( *vp == '\\' ) vp++;
				if ( FindEntryCDImage(&VFF->v.CD.cds, vp, findfile) == FALSE){
					errorcode = *vp ? ERROR_PATH_NOT_FOUND : ERROR_FILE_NOT_FOUND;
					CloseCDImage(&VFF->v.CD.cds);
					goto error;
				}
				return (HANDLE)VFF;
			}
			errorcode = ERROR_NO_MORE_FILES;
			goto error;
		}

		case VFSPT_DRIVELIST:
			VFF->mode = VFSDT_DLIST;
			VFF->TypeName = TypeName_DriveList;
			MakeDriveList(&VFF->v.MC);
			VFSFindNext((HANDLE)VFF, findfile);
			return (HANDLE)VFF;

		case VFSPT_HTTP:
			VFF->mode = VFSDT_HTTP;
			VFF->TypeName = TypeName_HTML;
			errorcode = MakeWebList(&VFF->v.MC, Fname, FALSE);
			if ( errorcode != NO_ERROR ) goto error;
			VFSFindNext((HANDLE)VFF, findfile);
			return (HANDLE)VFF;

		case VFSPT_AUXOP:
			HeapFree( DLLheap, 0, VFF );
			return AuxOpFF(Fname, Fwild, findfile);

		case VFSPT_FTP:
			VFF->mode = VFSDT_FTP;
			VFF->TypeName = TypeName_FTP;
			errorcode = FTPff(&VFF->v.FTP, dir, findfile);
			if ( errorcode != NO_ERROR ) goto error;
			return (HANDLE)VFF;
#ifdef USESLASHPATH
		case VFSPT_SLASH:
			VFF->mode = VFSDT_SLASH;
			VFF->TypeName = TypeName_root;
#ifdef WINEGCC
			errorcode = FirstSlashDir(&VFF->v.SLASH, Fname, findfile);
#else
			errorcode = FirstSlashDir(&VFF->v.SLASH, dir, findfile);
#endif
			if ( errorcode != NO_ERROR ) goto error;
			return (HANDLE)VFF;
#endif
		case VFSPT_DRIVE:
#ifdef USESLASHPATH
#ifdef WINEGCC
			if ( (*(vp - 2) == 'Z') || (*(vp - 2) == 'z') ){
				TCHAR *ps;

				VFF->mode = VFSDT_SLASH;
				VFF->TypeName = TypeName_root;
				if ( *vp == '\0' ){
					*vp = '/';
					*(vp + 1) = '\0';
				}else{
					ps = vp;
					while ( (ps = FindPathSeparator(ps)) != NULL) *ps++ = '/';
				}
				errorcode = FirstSlashDir(&VFF->v.SLASH, vp, findfile);
				if ( errorcode == NO_ERROR ) return (HANDLE)VFF;
				if ( errorcode != ERROR_DIRECTORY ) goto error;
			}
#endif
#endif
			if ( force != VFSPTF_SHN ){
				vp -= 2;
				break;
			}
										// ux:\...v idl 肷
			if ( *vp == '\0' ){	// rootu\vȂǉ
				*vp = '\\';
				*(vp + 1) = '\0';
			}
			vp -= 2;
			realerror = ERROR_BADKEY; // FindFirstFile ̃gCXLbv
			break;

		case VFSPT_UNC:
									// u\\v PCꗗ
			if ( Fwild <= vp ){
				if ( WinType >= WINTYPE_VISTA ){
					errorcode = FindUncPClist(VFF, findfile);
					if ( errorcode == NO_ERROR ) return (HANDLE)VFF;
					if ( errorcode != ERROR_DIRECTORY ) goto error;
				}
				memcpy(Fname, T("\\\\\0*.*"), TSTROFF(7));
				vp = Fname;
				Fwild = Fname + 3;
				realerror = ERROR_BADKEY; // FindFirstFile ̃gCXLbv
				break;
			}
			if ( (Fname[2] == '?') && (Fname[3] == '\\') ){ // \\?\x:\ `
				vp = Fname;
								// u\\xxxvPC\[Xꗗ / u\\+vg PC ꗗ
			}else if ( FindPathSeparator(vp) == NULL ){
				if ( (*vp == '+') && (*(vp + 1) == '\0') ){ // g PC ꗗ
					FF_MC *mc;

					mc = InitMCsubdir(VFF);
					VFF->TypeName = TypeName_Network;

					EnumNetServer(&mc->dirs, TRUE);

					ThAddString(&mc->files, NilStr);
					VFSFindNext((HANDLE)VFF, findfile);
					return (HANDLE)VFF;
				}
				// \[Xꗗ (SHNpX̏ꍇLbVƐb҂)
				errorcode = MakeComputerResourceList(&VFF->v.MC, vp - 2);
				if ( errorcode == NO_ERROR ){
					VFF->mode = VFSDT_DLIST;
					VFF->TypeName = TypeName_Network;
					VFSFindNext((HANDLE)VFF, findfile);
					return (HANDLE)VFF;
				}else{
					goto error;
				}
			}else{									// u\\xxx\xxx\v 
				vp -= 2;
			}
			if ( force == VFSPTF_SHN ) realerror = ERROR_BADKEY;
			break;

		case VFSPT_SHELLSCHEME:
			realerror = ERROR_BADKEY; // FindFirstFile ̃gCXLbv
			vp = Fname;
			if ( (*vp == '+') || (*vp == '-') ) vp++;
			break;

		default:
			errorcode = ERROR_BAD_PATHNAME;
			if ( mode >= 0 ) goto error;
										// Shell's Namespace ------------------
			realerror = ERROR_BADKEY; // FindFirstFile ̃gCXLbv
	}
	if ( realerror == NO_ERROR ){		// GNC/UNC ----------------------------
		*(Fwild - 1) = '\\';
		VFF->mode = VFSDT_PATH;
		VFF->v.FFF.hFF = DFindFirstFile(vp, findfile);
		if ( VFF->v.FFF.hFF != INVALID_HANDLE_VALUE ){	// 
			VFF->TypeName = TypeName_Normal;
			return (HANDLE)VFF;
		}
		errorcode = GetLastError();
		if ((errorcode == ERROR_FILENAME_EXCED_RANGE) ||
		   // OAsIh(ʏ툵ȂO)
		   ((errorcode == ERROR_PATH_NOT_FOUND) &&
				((tstrlen(vp) >= MAX_PATH) || (*(Fwild - 2) == '.'))) ){
			VFF->v.FFF.hFF = FindFirstFileLs(vp, findfile);
			if ( VFF->v.FFF.hFF != INVALID_HANDLE_VALUE ){	// 
				VFF->TypeName = TypeName_LongPath;
				return (HANDLE)VFF;
			}
			errorcode = GetLastError();
		}
		*(Fwild - 1) = '\0';

		if ((errorcode == ERROR_INVALID_PARAMETER) ||
			(errorcode == ERROR_DIRECTORY) ||
			(errorcode == ERROR_PATH_NOT_FOUND) ||
			(errorcode == ERROR_BAD_NETPATH) ||
			(errorcode == ERROR_INVALID_NAME) ){	// FF Ɏs t@CH
			ERRORCODE temperror;
			TCHAR *separator;
			TCHAR *DllName = NULL;

			separator = tstrrchr(vp, ':'); // "::" 
			if ( (separator != NULL) &&
				 (separator >= (vp + 2)) &&
				 (*(separator - 1) == ':') ){
				*(separator - 1) = '\0';
													// listfile ?
				if ( (memcmp((char *)(TCHAR *)(separator + 1), StrListFileID + 2, TSTROFF(8)) == 0) ||
					 (memcmp((char *)(TCHAR *)(separator + 1), VFS_TYPEID_JSON, TSTROFF(4)) == 0) ){
					ERRORCODE result;

					result = InitFindFirstListFile(VFF, vp, findfile, *(separator + 1) == 'J');
					if ( result != NO_ERROR ){
						errorcode = result;
						goto error;
					}
					return (HANDLE)VFF;
				}
				DllName = separator + 1;
				if ( errorcode == ERROR_INVALID_NAME ){
					errorcode = ERROR_DIRECTORY;
				}
			}
			// ERROR_INVALID_NAME  listfile`FbN̂
			if ( errorcode == ERROR_INVALID_NAME ) goto error;
			if ( tstrlen(Fname) >= VFPS ) goto error;
										// FileDirectory ?
			temperror = FileDirectory(Fname, VFF, findfile, Fwild, DllName);
			if ( temperror == NO_ERROR ) return (HANDLE)VFF;
			if ( temperror != ERROR_INVALID_DRIVE ){
				// temperror == ERROR_BAD_PATHNAME ́AeŏʊKwɈړ
				if ( temperror == ERROR_BAD_PATHNAME ){
					temperror = ERROR_PATH_NOT_FOUND;
				}
				errorcode = temperror;
				goto error;
			}
			// mode = VFSPT_UNKNOWN; SHNœǂ߂邩
		}

		if (	(errorcode != ERROR_BAD_NETPATH) &&
				(errorcode != ERROR_DIRECTORY ) &&
				(errorcode != ERROR_NETWORK_UNREACHABLE) ){
			goto error;
		}
		if ( mode == VFSPT_DRIVE ) goto error;
		realerror = errorcode;
							// s Shell's Namespace g邩
	}
	errorcode = VFSFF_SHN(vp, &VFF->v.SHN, findfile, mode);
	if ( errorcode == NO_ERROR ){
		VFF->mode = VFSDT_SHN;
		VFF->TypeName = TypeName_SHN;
		return (HANDLE)VFF;
	}else if ( (errorcode == ERROR_BAD_PATHNAME)
		&& ((mode < 0) || (mode == VFSDT_SHN)) ){
		TCHAR *p = tstrstr(Fname, T("::"));

		if ( (p != NULL) && (p != Fname) && (*(Fname - 1) != '\\') ){
			*p = '\0';
			if ( IsTrue(VFSGetRealPath(NULL, Fname, Fname)) ){
				p = tstrstr(dir, T("::"));
				if ( p != NULL ) tstrcat(Fname, p);
				HeapFree( DLLheap, 0, VFF );
				return VFSFindFirst(Fname, findfile);
			}
		}
	}
	if ( realerror != ERROR_BADKEY ) errorcode = realerror;
										// G[I ---------------------
error:
	HeapFree( DLLheap, 0, VFF );
error_nofree:
	SetLastError(errorcode);
	return INVALID_HANDLE_VALUE;
}

BOOL FindSusieNext(VFSFINDFIRST *VFF, WIN32_FIND_DATA *findfile)
{
	ULONG_PTR tmptime;

	/*
		finfo->path ͒ʏ path\ `
	*/

	if ( VFF->v.SU.step < FFSTEP_ENTRY ){
		return FFStepInfo(findfile, &VFF->v.SU.step);
	}
	#ifdef UNICODE
	if ( VFF->v.SU.finfo == NULL ){
		if ( (VFF->v.SU.finfoW >= VFF->v.SU.finfomaxW) || (VFF->v.SU.finfoW->method[0] == 0) ){
			SetLastError(ERROR_NO_MORE_FILES);
			return FALSE;
		}
		#ifdef _WIN64
			findfile->nFileSizeLow = (DWORD)VFF->v.SU.finfoW->filesize;
			findfile->nFileSizeHigh = (DWORD)(VFF->v.SU.finfoW->filesize >> 32);
		#else
			findfile->nFileSizeLow = VFF->v.SU.finfoW->filesize;
			findfile->nFileSizeHigh = 0;
		#endif
		CatPath(findfile->cFileName,
				VFF->v.SU.finfoW->path, VFF->v.SU.finfoW->filename);
		findfile->dwFileAttributes = (VFF->v.SU.finfoW->filename[0] != '\0') ? 0 : FILE_ATTRIBUTE_DIRECTORY;
		tmptime = VFF->v.SU.finfoW->timestamp;
		VFF->v.SU.finfoW++;
	}else
	#endif
	{
		if ( (VFF->v.SU.finfo >= VFF->v.SU.finfomax) || (VFF->v.SU.finfo->method[0] == 0) ){
			SetLastError(ERROR_NO_MORE_FILES);
			return FALSE;
		}
		#ifdef _WIN64
			findfile->nFileSizeLow = (DWORD)VFF->v.SU.finfo->filesize;
			findfile->nFileSizeHigh = (DWORD)(VFF->v.SU.finfo->filesize >> 32);
		#else
			findfile->nFileSizeLow = VFF->v.SU.finfo->filesize;
			findfile->nFileSizeHigh = 0;
		#endif
		#ifdef UNICODE
		{
			TCHAR Temp[VFPS];

			AnsiToUnicode(VFF->v.SU.finfo->path, findfile->cFileName, MAX_PATH);
			AnsiToUnicode(VFF->v.SU.finfo->filename, Temp, VFPS);
			CatPath(NULL, findfile->cFileName, Temp);
		}
		#else
			CatPath(findfile->cFileName, VFF->v.SU.finfo->path, VFF->v.SU.finfo->filename);
		#endif
		findfile->dwFileAttributes = (VFF->v.SU.finfo->filename[0] != '\0') ? 0 : FILE_ATTRIBUTE_DIRECTORY;
		tmptime = VFF->v.SU.finfo->timestamp;
		VFF->v.SU.finfo++;
	}
	#ifdef _WIN64
		// time_t64  FILETIME ɕϊ
		tmptime = (tmptime * 10000000) + 0x19db1ded53e8000;
		findfile->ftLastWriteTime.dwLowDateTime = (DWORD)tmptime;
		findfile->ftLastWriteTime.dwHighDateTime = (DWORD)(ULONG_PTR)(tmptime >> 32);
	#else
		// time_t32  FILETIME ɕϊ
		DDmul(tmptime, 10000000,
				&findfile->ftLastWriteTime.dwLowDateTime,
				&findfile->ftLastWriteTime.dwHighDateTime);
		AddDD(findfile->ftLastWriteTime.dwLowDateTime,
				findfile->ftLastWriteTime.dwHighDateTime,
				0xd53e8000, 0x19db1de);
		findfile->nFileSizeHigh = 0;
	#endif

	findfile->ftCreationTime.dwLowDateTime = 0;
	findfile->ftCreationTime.dwHighDateTime = 0;
	findfile->ftLastAccessTime.dwHighDateTime = 0;
	findfile->ftLastAccessTime.dwLowDateTime = 0;
	findfile->cAlternateFileName[0] = '\0';
	return TRUE;
}

#ifdef UNICODE
void SetVFFundllW(FF_UN *UN, WIN32_FIND_DATA *findfile, INDIVIDUALINFOW *arcinfo)
{
	FILETIME ftime;
	ARCSIZE64 s64;
	TCHAR *p;

	findfile->dwFileAttributes = 0;
	if ( ! ((UN->uD->UnGetWriteTimeEx != NULL) &&
			IsTrue(UN->uD->UnGetWriteTimeEx(UN->Ha, &findfile->ftLastWriteTime)) ) ){
		DosDateTimeToFileTime(arcinfo->wDate, arcinfo->wTime, &ftime);
		LocalFileTimeToFileTime(&ftime, &findfile->ftLastWriteTime);
	}
	if ( ! ((UN->uD->UnGetCreateTimeEx != NULL) &&
			IsTrue(UN->uD->UnGetCreateTimeEx(UN->Ha, &findfile->ftCreationTime)) ) ){
		findfile->ftCreationTime.dwLowDateTime = 0;
		findfile->ftCreationTime.dwHighDateTime = 0;
	}
	if ( ! ((UN->uD->UnGetAccessTimeEx != NULL) &&
			IsTrue(UN->uD->UnGetAccessTimeEx(UN->Ha, &findfile->ftLastAccessTime)) ) ){
		findfile->ftLastAccessTime.dwLowDateTime = 0;
		findfile->ftLastAccessTime.dwHighDateTime = 0;
	}
	if ( (UN->uD->UnGetOriginalSizeEx != NULL) &&
		 IsTrue(UN->uD->UnGetOriginalSizeEx(UN->Ha, &s64)) ){
		findfile->nFileSizeHigh = s64.h;
		findfile->nFileSizeLow = s64.l;
	}else{
		findfile->nFileSizeHigh = 0;
		findfile->nFileSizeLow = arcinfo->dwOriginalSize;
	}
	findfile->cAlternateFileName[0] = '\0';

	p = arcinfo->szFileName;
	p[MAX_PATH - 1] = '\0';		// 
	while ( (p = tstrchr(p, '/')) != NULL ) *p = '\\';

	tstrcpy(findfile->cFileName, arcinfo->szFileName);
//	tstplimcpy(findfile->cFileName, arcinfo->szFileName, MAX_PATH);
}
#endif
void SetVFFundllA(FF_UN *UN, WIN32_FIND_DATA *findfile, INDIVIDUALINFOA *arcinfo)
{
	FILETIME ftime;
	ARCSIZE64 s64;
	char *p;

	findfile->dwFileAttributes = 0;
	if ( ! ((UN->uD->UnGetWriteTimeEx != NULL) &&
			 IsTrue(UN->uD->UnGetWriteTimeEx(UN->Ha, &findfile->ftLastWriteTime)) ) ){
		DosDateTimeToFileTime(arcinfo->wDate, arcinfo->wTime, &ftime);
		LocalFileTimeToFileTime(&ftime, &findfile->ftLastWriteTime);
	}
	if ( ! ((UN->uD->UnGetCreateTimeEx != NULL) &&
			 IsTrue(UN->uD->UnGetCreateTimeEx(UN->Ha, &findfile->ftCreationTime)) ) ){
		findfile->ftCreationTime.dwLowDateTime = 0;
		findfile->ftCreationTime.dwHighDateTime = 0;
	}
	if ( ! ((UN->uD->UnGetAccessTimeEx != NULL) &&
			 IsTrue(UN->uD->UnGetAccessTimeEx(UN->Ha, &findfile->ftLastAccessTime)) ) ){
		findfile->ftLastAccessTime.dwLowDateTime = 0;
		findfile->ftLastAccessTime.dwHighDateTime = 0;
	}
	if ( (UN->uD->UnGetOriginalSizeEx != NULL) &&
		 IsTrue(UN->uD->UnGetOriginalSizeEx(UN->Ha, &s64)) ){
		findfile->nFileSizeHigh = s64.h;
		findfile->nFileSizeLow = s64.l;
	}else{
		findfile->nFileSizeHigh = 0;
		findfile->nFileSizeLow = arcinfo->dwOriginalSize;
	}
	findfile->cAlternateFileName[0] = '\0';

	p = arcinfo->szFileName;
	p[MAX_PATH - 1] = '\0';		// 
	while ( (p = strchr(p, '/')) != NULL ) *p = '\\';

	#ifdef UNICODE
		tstrcpy(findfile->cFileName, L"???");
		MultiByteToWideCharU8(UN->uD->codepage,
				(UN->uD->codepage >= CP__NOPREC) ? 0 : MB_PRECOMPOSED,
				arcinfo->szFileName, -1, findfile->cFileName, MAX_PATH);
	#else
		stplimcpy(findfile->cFileName, arcinfo->szFileName, MAX_PATH);
	#endif
}

BOOL FindUnxNext(VFSFINDFIRST *VFF, WIN32_FIND_DATA *findfile)
{
	union {
		INDIVIDUALINFOA A;
		#ifdef UNICODE
			INDIVIDUALINFOW W;
		#endif
	} arcinfo;

	#ifdef UNICODE
	if ( VFF->v.UN.uD->codepage == CP_UNDLL ){
		switch( VFF->v.UN.step ){
			case FFSTEP_ENTRYNEXT:
				if ( VFF->v.UN.uD->UnFindNextW(VFF->v.UN.Ha, &arcinfo.W) ){
					VFF->v.UN.step = FFSTEP_NOMORE;
					break;
				}
				SetVFFundllW(&VFF->v.UN, findfile, &arcinfo.W);
				return TRUE;

			case FFSTEP_ENTRY:
				if ( VFF->v.UN.uD->UnFindFirstW(
						VFF->v.UN.Ha, VFF->v.UN.wild, &arcinfo.W)){
					VFF->v.UN.step = FFSTEP_NOMORE;
					break;
				}
				VFF->v.UN.step++;
				SetVFFundllW(&VFF->v.UN, findfile, &arcinfo.W);
				return TRUE;
		}
	}else
	#endif
	{
		switch( VFF->v.UN.step ){
			case FFSTEP_ENTRYNEXT:
				if ( VFF->v.UN.uD->UnFindNext(VFF->v.UN.Ha, &arcinfo.A) ){
					VFF->v.UN.step = FFSTEP_NOMORE;
					break;
				}
				SetVFFundllA(&VFF->v.UN, findfile, &arcinfo.A);
				return TRUE;

			case FFSTEP_ENTRY:
				if ( VFF->v.UN.uD->UnFindFirst(
						VFF->v.UN.Ha, (char *)VFF->v.UN.wild, &arcinfo.A)){
					VFF->v.UN.step = FFSTEP_NOMORE;
					break;
				}
				VFF->v.UN.step++;
				SetVFFundllA(&VFF->v.UN, findfile, &arcinfo.A);
				return TRUE;
		}
	}
	return FFStepInfo(findfile, &VFF->v.UN.step);
}
/*-----------------------------------------------------------------------------
-----------------------------------------------------------------------------*/
VFSDLL BOOL PPXAPI VFSFindNext(HANDLE hFF, WIN32_FIND_DATA *findfile)
{
	VFSFINDFIRST *VFF;
	ERRORCODE errorcode;

	VFF = IsVFSFINDFIRST(hFF);
	if ( VFF == NULL ){
		errorcode = ERROR_INVALID_HANDLE;
		goto error;
	}

	switch( VFF->mode ){
		case VFSDT_PATH:				// GNC/UNC ----------------------------
#if 0
			return FindNextFile(VFF->v.FFF.hFF, findfile);
#else
		{ // 64bit ł nFileSizeLow  directory file ̃TCY悤
			BOOL result;

			result = FindNextFile(VFF->v.FFF.hFF, findfile);
			#ifdef WINEGCC
			if ( findfile->dwFileAttributes == BADATTR ){
				findfile->dwFileAttributes = FILE_ATTRIBUTE_DEVICE;
			}
			#endif
			if ( findfile->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ){
				findfile->nFileSizeLow = 0;
			}
			return result;
		}
#endif
		case VFSDT_FTP:					// ftp  -------------------------------
			return FTPnf(&VFF->v.FTP, findfile);

		case VFSDT_LFILE:					// ListFile -----------------------
			if ( VFF->v.LFILE.type == VFSDT_LFILE_TYPE_LIST ){
				return GetListLine(VFF, findfile);
			}
			// VFSDT_LFILE_TYPE_PARENT
			GetOptionData_ListFile(VFF);
			SetDummydir(findfile, T(".."));
			findfile->dwReserved0 = 0;
			findfile->dwReserved1 = 0;
			VFF->v.LFILE.type = VFSDT_LFILE_TYPE_LIST;
			return TRUE;

		case VFSDT_HTTP:					// http ---------------------------
		case VFSDT_DLIST: {					// Drive List ---------------------
			TCHAR *p;

			p = (TCHAR *)(VFF->v.MC.dirs.bottom + VFF->v.MC.d_off);
			if ( (p != NULL) && *p ){
				SetDummydir(findfile, p);
				VFF->v.MC.d_off += TSTRSIZE32(p);
				return TRUE;
			}
			p = (TCHAR *)(VFF->v.MC.files.bottom + VFF->v.MC.f_off);
			if ( (p != NULL) && *p ){
				findfile->dwFileAttributes = FILE_ATTRIBUTE_READONLY;
				SetDummyFindData(findfile);
				tstrcpy(findfile->cFileName, p);
				VFF->v.MC.f_off += TSTRSIZE32(p);
				return TRUE;
			}
			SetLastError(ERROR_NO_MORE_FILES);
			return FALSE;
		}

		case VFSDT_SHN:						// SHN ---------------------------
			return VFSFN_SHN(&VFF->v.SHN, findfile);

		case VFSDT_STREAM:					// stream -------------------------
			return FindNextStream(&VFF->v.STREAM, findfile);

		case VFSDT_FATIMG:					// FAT Image File ----------------
		case VFSDT_FATDISK:					// FAT Disk ----------------
			if ( IsTrue(FindEntryFATImage(&VFF->v.FAT.fats, NULL, findfile)) ){
				return TRUE;
			}
			SetLastError(ERROR_NO_MORE_FILES);
			return FALSE;

		case VFSDT_CDIMG:					// CD Image File ----------------
		case VFSDT_CDDISK:					// CD ----------------
			if ( IsTrue(FindEntryCDImage(&VFF->v.CD.cds, NULL, findfile)) ){
				return TRUE;
			}
			SetLastError(ERROR_NO_MORE_FILES);
			return FALSE;

		case VFSDT_ARCFOLDER:				// arc folder ----------------
		case VFSDT_CABFOLDER:				// cab folder ----------------
		case VFSDT_LZHFOLDER:				// lzh folder ----------------
		case VFSDT_ZIPFOLDER:				// zip folder ----------------
			if ( IsTrue(ZipFolderFN(&VFF->v.ZIPO, findfile)) ){
				return TRUE;
			}
			SetLastError(ERROR_NO_MORE_FILES);
			return FALSE;
#ifdef USESLASHPATH
		case VFSDT_SLASH:					// / directory ----------------
			if ( IsTrue(NextSlashDir(&VFF->v.SLASH, findfile)) ){
				return TRUE;
			}
			SetLastError(ERROR_NO_MORE_FILES);
			return FALSE;
#endif
		case VFSDT_SUSIE:					// SUSIE --------------------------
			return FindSusieNext(VFF, findfile);

		case VFSDT_UN:						// UNx --------------------------
			return FindUnxNext(VFF, findfile);

//		default: ł͏
	}
	errorcode = ERROR_INVALID_TARGET_HANDLE;
	// error: 
										// G[I ---------------------
error:
	SetLastError(errorcode);
	return FALSE;
}

VFSDLL BOOL PPXAPI VFSFindClose(HANDLE hFF)
{
	VFSFINDFIRST *VFF;

	VFF = IsVFSFINDFIRST(hFF);
	if ( VFF == NULL ){
		SetLastError(ERROR_INVALID_HANDLE);
		return FALSE;
	}

	switch (VFF->mode){
		case VFSDT_PATH:
			FindClose(VFF->v.FFF.hFF);
			break;
		case VFSDT_FTP:
			FTPclose(&VFF->v.FTP);
			break;
		case VFSDT_LFILE:
			HeapFree(DLLheap, 0, VFF->v.LFILE.mem);
			break;
		case VFSDT_HTTP:
		case VFSDT_DLIST:
			ThFree(&VFF->v.MC.dirs);
			ThFree(&VFF->v.MC.files);
			break;
		case VFSDT_SHN:
			if ( VFF->v.SHN.pSF != NULL ){
				VFF->v.SHN.pEID->lpVtbl->Release(VFF->v.SHN.pEID);
				VFF->v.SHN.pSF->lpVtbl->Release(VFF->v.SHN.pSF);
				VFF->v.SHN.pMA->lpVtbl->Release(VFF->v.SHN.pMA);
				if ( VFF->v.SHN.pSF2 != NULL ){
					VFF->v.SHN.pSF2->lpVtbl->Release(VFF->v.SHN.pSF2);
				}
			}
			ThFree(&VFF->v.SHN.dirs);
			break;
		case VFSDT_FATIMG:
		case VFSDT_FATDISK:
			CloseFATImage(&VFF->v.FAT.fats);
			break;
		case VFSDT_CDIMG:
		case VFSDT_CDDISK:
			CloseCDImage(&VFF->v.CD.cds);
			break;

		case VFSDT_STREAM:
			FindCloseStream(&VFF->v.STREAM);
			break;

		case VFSDT_SUSIE:
			LocalUnlock(VFF->v.SU.fiH);
			LocalFree(VFF->v.SU.fiH);
			break;
		case VFSDT_UN:
			#ifdef UNICODE
				VFF->v.UN.uD->SetUnicodeMode(FALSE);
			#endif
			VFF->v.UN.uD->UnCloseArchive(VFF->v.UN.Ha);
			break;
		case VFSDT_ARCFOLDER:
		case VFSDT_CABFOLDER:
		case VFSDT_LZHFOLDER:
		case VFSDT_ZIPFOLDER:
			ZipFolderFClose(&VFF->v.ZIPO);
			break;
#ifdef USESLASHPATH
		case VFSDT_SLASH:					// / directory ----------------
			CloseSlashDir(&VFF->v.SLASH);
			break;
#endif
	}
	HeapFree(DLLheap, 0, VFF);
	return TRUE;
}

VFSDLL BOOL PPXAPI VFSFindOptionData(HANDLE hFF, DWORD optionID, void *data)
{
	VFSFINDFIRST *VFF;

	VFF = IsVFSFINDFIRST(hFF);
	if ( VFF == NULL ){
		SetLastError(ERROR_INVALID_HANDLE);
		return FALSE;
	}

	if ( optionID == FINDOPTIONDATA_SETCALLBACK ){
		VFF->cb = (FOD_CALLBACK *)data;
		if ( (VFF->cb != NULL) && VFF->mode == VFSDT_LFILE ){
			return GetOptionData_ListFile(VFF);
		}
		return TRUE;
	}

	switch ( VFF->mode ){
		case VFSDT_LFILE:
			switch ( optionID ){
				case FINDOPTIONDATA_LONGNAME:
					if ( VFF->v.LFILE.longname == NULL ) break;
					tstplimcpy((TCHAR *)data, VFF->v.LFILE.longname, VFPS);
					return TRUE;

				case FINDOPTIONDATA_COMMENT: {
					const TCHAR *ptr;

					ptr = VFF->v.LFILE.comment;
					if ( ptr == NULL ) break;
					GetCommandParameter(&ptr, (TCHAR *)data, CMDLINESIZE);
					return TRUE;
				}
				case FINDOPTIONDATA_EXTRA:
					memcpy((char *)data, &VFF->v.LFILE.extra, min(sizeof(FOD_EXTRADATA), ((FOD_EXTRADATA *)data)->size));
					return TRUE;
			}
			break;
	}
	return FALSE;
}
