/*-----------------------------------------------------------------------------
	DirectX ɂ GDI `

	Wn:
		Z = 0 ̎A
		0 * D3D_ProjScaleX  X  NCAg * D3D_ProjScaleX
		0 * D3D_ProjScaleY  Y  NCAg * D3D_ProjScaleY
-----------------------------------------------------------------------------*/
#define DWMGLASS 0 // Vista/7 ̃KXʂɂ锼Lɂ

#if defined(USEDIRECTX) || defined(USEDIRECTWRITE)
#include "WINAPI.H"
#include <stdio.h>
#include <wchar.h>
#include <ole2.h>
#if DWMGLASS
  #include "Dwmapi.h"
  #pragma comment(lib, "Dwmapi.lib")
#endif
#define HMONITOR_DECLARED
#include "PPX.H"
#include "VFS.H"
#include "PPX_DRAW.H"
#undef HMONITOR_DECLARED

#if DWMGLASS
  #define RenderTargetProperties_OPTION(type) type, D2D1::PixelFormat(DXGI_FORMAT_B8G8R8A8_UNORM, D2D1_ALPHA_MODE_PREMULTIPLIED)
#else
  #define RenderTargetProperties_OPTION(type) type
#endif

#define DEFAULT_DPI 96.0f
extern "C" UINT WM_PPXCOMMAND;
extern "C" void FillBox(HDC hDC, const RECT *box, HBRUSH hbr);
// Direct Write  ------------------------------------------------------------
#if DRAWMODE == DRAWMODE_DW
#include <wincodec.h>
#include <wincodecsdk.h>
#include <d2d1.h>
#include <dwrite.h>

#ifndef _COM_Outptr_ // SAL [
#define _COM_Outptr_
#define _COM_Outptr_result_maybenull_
#define _Maybenull_
#define _Outptr_
#define _Out_writes_to_(a,b)
#define _Out_writes_to_opt_(a,b)
#define _Out_writes_(a)
#define _Out_writes_opt_(a)
#define _In_reads_opt_(a)
#endif
// Visual Studio 2008 ɂȂwb_
//   ŐV Windows Kit  dwrite_1.h / dwrite_2.h pӂ邱
#include <dwrite_2.h>

#ifndef D2D1_DRAW_TEXT_OPTIONS_ENABLE_COLOR_FONT
#define D2D1_DRAW_TEXT_OPTIONS_ENABLE_COLOR_FONT (D2D1_DRAW_TEXT_OPTIONS)0x00000004 // 8.1
#endif

#define DXBMPCACHEITEMS 8 // LbV\ȃrbg}bv̐
#define DEFATLASSIZE 0x800 // BmpAtlas Ɏgprbg}bv̕ӂ̒

BOOL DxEnableDLL = FALSE;
HMODULE hD2D1 = NULL;
HMODULE hDWRITE = NULL;

#define DWVER_10 0
#define DWVER_12 2
int DwVersion; // DirectWrite Version 0: 1.0(Vista)  2: 1.2(8) 3: 1.3(10)

DefineWinAPI(HRESULT, D2D1CreateFactory, (D2D1_FACTORY_TYPE, REFIID, CONST D2D1_FACTORY_OPTIONS *, IUnknown **));
DefineWinAPI(void, D2D1MakeRotateMatrix, (FLOAT, D2D1_POINT_2F, D2D1_MATRIX_3X2_F *));
DefineWinAPI(HRESULT, DWriteCreateFactory, (DWRITE_FACTORY_TYPE, REFIID, IUnknown **));

extern "C" UTCHAR GetCommandParameter(LPCTSTR *commandline, TCHAR *param, size_t paramlen);

D2D1_DRAW_TEXT_OPTIONS TextOption; // J[G̗Lݒ
DWRITE_PARAGRAPH_ALIGNMENT HeightAlignment; // ̕\ʒu

struct DXBRUSHSTRUCT {
	ID2D1SolidColorBrush *brush;
	COLORREF color;
};

extern "C" typedef struct tagDXDRAWSTRUCT {
	HWND hWnd;

	ID2D1Factory *d2dFactory;
	IWICImagingFactory *WicFactory;

	ID2D1HwndRenderTarget *HwndRenderTarget;
	int HwndRenderTargetCounter;
	D2D1_RENDER_TARGET_TYPE RenderTargetType;
	D2D1_MATRIX_3X2_F DefaultTransform;
	D2D1::Matrix3x2F HitPointTransform;
	D2D1::Matrix3x2F BMPTransform;

	D2D1_POINT_2F lastpos;
	COLORREF BackColor;
	DXBRUSHSTRUCT BackBrush;
	DXBRUSHSTRUCT SubBrush;
	D2D1_SIZE_U clientArea;
	RECT clientBox;

	int RotateAngle;
	FLOAT DotScaleRate; // (DWM)̉dpi̔䗦 t
	D2D1_POINT_2F DeskScale; // N(GDI)̉dpi
	D2D1_POINT_2F DeskScaleRate; // N(GDI)̉dpi t
	UINT32 MaxBitmapPixels; // bitmap̂Pӂ̍ől

	// `
	IDWriteFactory2 *dwFactory;
	IDWriteTextFormat *textFormat; // textFormatMain / textFormatSub 
	IDWriteTextFormat *textFormatMain; // CtHg
	IDWriteTextFormat *textFormatSub; // tHg(PPv:v|[Vi)
	DXBRUSHSTRUCT TextBrush; // `puV
	WCHAR fontName[LF_FACESIZE];
	WCHAR fontNameSub[LF_FACESIZE];
	float fontW, fontH;
	COLORREF BackTextColor;
	int BkMode;
	int ul_height;

	// rbg}bv
	ID2D1Bitmap *bmpCache[DXBMPCACHEITEMS];
	struct {
		ID2D1Bitmap *bmp;

		SIZE ItemSize; // Item ̑傫
		DWORD AtlasItems; // ۑ\
		DWORD AtlasCols;  // Ps̐

		DWORD IndexMin; // LIndex̍ŏlAől
		DWORD IndexNow; // 

		DWORD useIndex; // ǂݏIndex(-1:Y)
	} BmpAtlas;
} DXDRAWSTRUCT;

//const WCHAR strtailL[1] = {L'c'};
const WCHAR strtailS[1] = {L'.'};

BOOL CreateDxDraw(DXDRAWSTRUCT **DxDrawPtr, HWND hWnd)
{
	DXDRAWSTRUCT *DxDraw;

	*DxDrawPtr = NULL;
	if ( DxEnableDLL == FALSE ){
		if ( hD2D1 != NULL ) return FALSE;

		hD2D1 = LoadLibrary(T("d2d1.dll"));
		if ( hD2D1 == NULL ){
			hD2D1 = static_cast<HMODULE>(INVALID_HANDLE_VALUE);
			SendMessage(hWnd, WM_PPXCOMMAND, K_SETPOPLINENOLOG, (LPARAM)T("Force GDI mode"));
			return FALSE;
		}
		GETDLLPROC(hD2D1, D2D1CreateFactory);
		GETDLLPROC(hD2D1, D2D1MakeRotateMatrix);

		if ( hDWRITE != NULL ) return FALSE;

		hDWRITE = LoadLibrary(T("dwrite.dll"));
		if ( hDWRITE == NULL ){
			hDWRITE = static_cast<HMODULE>(INVALID_HANDLE_VALUE);
			SendMessage(hWnd, WM_PPXCOMMAND, K_SETPOPLINENOLOG, (LPARAM)T("Force GDI mode"));
			return FALSE;
		}
		GETDLLPROC(hDWRITE, DWriteCreateFactory);
		DxEnableDLL = TRUE;
	}

#if DWMGLASS
	MARGINS margins = { -1 };

	DwmExtendFrameIntoClientArea(hWnd, &margins);
#endif
	*DxDrawPtr = DxDraw = new DXDRAWSTRUCT;
	DxDraw->hWnd = hWnd;
	DxDraw->HwndRenderTarget = NULL;
	DxDraw->HwndRenderTargetCounter = 0;
	DxDraw->RenderTargetType = D2D1_RENDER_TARGET_TYPE_DEFAULT;
	memset(&DxDraw->bmpCache, 0, sizeof(DxDraw->bmpCache));
	DxDraw->BmpAtlas.bmp = NULL;
	DxDraw->BmpAtlas.IndexNow = 1;

	DxDraw->BackBrush.brush = NULL;
	DxDraw->SubBrush.brush = NULL;
	DxDraw->TextBrush.brush = NULL;
	DxDraw->textFormat = NULL;
	DxDraw->textFormatMain = NULL;
	DxDraw->textFormatSub = NULL;
	DxDraw->RotateAngle = 0;
	DxDraw->DotScaleRate = 1.0f;
	DxDraw->DefaultTransform = D2D1::Matrix3x2F::Identity();
	DxDraw->HitPointTransform = D2D1::Matrix3x2F::Identity();
//	DxDraw->BMPTransform = D2D1::Matrix3x2F::Identity();
	strcpyW(DxDraw->fontName, L"lr SVbN");
	strcpyW(DxDraw->fontNameSub, L"lr oSVbN");
	DxDraw->fontH = 12.0f;
	DxDraw->BkMode = OPAQUE;
	DxDraw->ul_height = 0;

	DxDraw->WicFactory = NULL;

#if 1
	if ( FAILED(DD2D1CreateFactory(/*D2D1_FACTORY_TYPE_MULTI_THREADED */ D2D1_FACTORY_TYPE_SINGLE_THREADED, __uuidof(*DxDraw->d2dFactory), NULL, reinterpret_cast<IUnknown**>(&DxDraw->d2dFactory))) )
#else
	D2D1_FACTORY_OPTIONS options;
	options.debugLevel = D2D1_DEBUG_LEVEL_INFORMATION;
	OutputDebugString(T("******************** D2D1CreateFactory *******************"));

	if ( FAILED(DD2D1CreateFactory(/*D2D1_FACTORY_TYPE_MULTI_THREADED */ D2D1_FACTORY_TYPE_SINGLE_THREADED, __uuidof(*DxDraw->d2dFactory), options, reinterpret_cast<IUnknown**>(&DxDraw->d2dFactory))) )
#endif
	{
		return FALSE;
	}
	if ( SUCCEEDED(DDWriteCreateFactory(DWRITE_FACTORY_TYPE_SHARED,
			__uuidof(IDWriteFactory2),
			reinterpret_cast<IUnknown**>(&DxDraw->dwFactory))) ){
		DwVersion = DWVER_12; // Win 8.1 ȍ~
		TextOption = D2D1_DRAW_TEXT_OPTIONS_ENABLE_COLOR_FONT;
	}else if ( SUCCEEDED(DDWriteCreateFactory(DWRITE_FACTORY_TYPE_SHARED,
			__uuidof(IDWriteFactory),
			reinterpret_cast<IUnknown**>(&DxDraw->dwFactory))) ){
		DwVersion = DWVER_10; // Win Vista ȍ~
		TextOption = D2D1_DRAW_TEXT_OPTIONS_NONE;
	}else{
		return FALSE;
	}

	// OItȂl͕ωȂ
	DxDraw->d2dFactory->GetDesktopDpi(&DxDraw->DeskScale.x, &DxDraw->DeskScale.y);
	DxDraw->DeskScaleRate.x = DEFAULT_DPI / DxDraw->DeskScale.x;
	DxDraw->DeskScaleRate.y = DEFAULT_DPI / DxDraw->DeskScale.y;
	if ( DxDraw->DeskScale.x != DEFAULT_DPI ){
		DxDraw->DefaultTransform._11 = DxDraw->DeskScaleRate.x;
		DxDraw->DefaultTransform._22 = DxDraw->DeskScaleRate.y;
	}

	return TRUE;
}

void ResetDxDraw(DXDRAWSTRUCT *DxDraw)
{
	if ( DxDraw == NULL ) return;

	if ( DxDraw->HwndRenderTarget != NULL ){
		ResetDxDrawAtlas(DxDraw);
		for ( int i = 0 ; i < DXBMPCACHEITEMS ; i++ ){
			if ( DxDraw->bmpCache[i] != NULL ){
				DxDraw->bmpCache[i]->Release();
				DxDraw->bmpCache[i] = NULL;
			}
		}
		if ( DxDraw->BackBrush.brush != NULL ){
			DxDraw->BackBrush.brush->Release();
			DxDraw->BackBrush.brush = NULL;
		}
		if ( DxDraw->SubBrush.brush != NULL ){
			DxDraw->SubBrush.brush->Release();
			DxDraw->SubBrush.brush = NULL;
		}
		if ( DxDraw->TextBrush.brush != NULL ){
			DxDraw->TextBrush.brush->Release();
			DxDraw->TextBrush.brush = NULL;
		}
		DxDraw->HwndRenderTarget->Release();
		DxDraw->HwndRenderTarget = NULL;
		DxDraw->HwndRenderTargetCounter++;
	}
}

BOOL CloseDxDraw(DXDRAWSTRUCT **DxDrawPtr)
{
	DXDRAWSTRUCT *DxDraw;

	DxDraw = *DxDrawPtr;
	if ( DxDraw == NULL ) return FALSE;

	ResetDxDraw(DxDraw);
	if ( DxDraw->textFormatMain != NULL )	DxDraw->textFormatMain->Release();
	if ( DxDraw->textFormatSub != NULL )	DxDraw->textFormatSub->Release();
	DxDraw->dwFactory->Release();
	DxDraw->d2dFactory->Release();
	if ( DxDraw->WicFactory != NULL ) DxDraw->WicFactory->Release();

	delete DxDraw;
	*DxDrawPtr = NULL;
	return TRUE;
}

BOOL InitRenderTarget(DXDRAWSTRUCT *DxDraw)
{
	// RenderTarget 
	GetClientRect(DxDraw->hWnd, &DxDraw->clientBox);
	DxDraw->clientArea.width  = DxDraw->clientBox.right;
	DxDraw->clientArea.height = DxDraw->clientBox.bottom;

	DxSetRotate(DxDraw, 0);
	if ( FAILED(DxDraw->d2dFactory->CreateHwndRenderTarget(
			D2D1::RenderTargetProperties(RenderTargetProperties_OPTION(DxDraw->RenderTargetType)),
			D2D1::HwndRenderTargetProperties(DxDraw->hWnd, DxDraw->clientArea),
			&DxDraw->HwndRenderTarget)) ){
		return FALSE;
	}
	DxDraw->MaxBitmapPixels = DxDraw->HwndRenderTarget->GetMaximumBitmapSize();

	// p[^ݒ
	TCHAR buf[0x400], param[0x100];
	const TCHAR *ptr, *pptr;
	int size;

	float Gamma, EnhancedContrast, GrayEhContrast, ClearTypeLevel;
	DWRITE_RENDERING_MODE RenderingMode;
	DWRITE_GRID_FIT_MODE gridFitMode = DWRITE_GRID_FIT_MODE_DEFAULT;

	IDWriteRenderingParams *OldRparams = NULL;

	DxDraw->dwFactory->CreateRenderingParams(&OldRparams);
	Gamma            = OldRparams->GetGamma();
	GrayEhContrast = EnhancedContrast = OldRparams->GetEnhancedContrast();
	ClearTypeLevel   = OldRparams->GetClearTypeLevel();
	RenderingMode    = OldRparams->GetRenderingMode();
	HeightAlignment  = DWRITE_PARAGRAPH_ALIGNMENT_NEAR;

	size = TSTROFF(thprintf(buf, TSIZEOF(buf), T("%d,%d,,%d,%d,,%d,%d"),
		static_cast<int>(Gamma * 100.0f),
		static_cast<int>(EnhancedContrast * 100.0f),
		/*GrayEhContrast, */
		static_cast<int>(ClearTypeLevel * 100.0f),
		RenderingMode,
		/* gridFitMode*/
		TextOption,
		HeightAlignment) + 1 - buf);
	SetCustTable(T("_others"), T("dwenv_def"), buf, size);

	buf[0] = '\0';
	if ( NO_ERROR != GetCustTable(T("_others"), T("dwenv"), buf, sizeof(buf)) ){
		tstrcpy(buf,T(",,,,5"));
	}
	ptr = buf;
	for (;;){
		// Gamma
		if ( GetCommandParameter(&ptr, param, TSIZEOF(param)) == '\0' ) break;
		if ( Isdigit(param[0]) ){
			pptr = param;
			Gamma = static_cast<float>(GetNumber(&pptr)) / 100.0f;
		}
		NextParameter(&ptr);
		// EnhancedContrast
		if ( GetCommandParameter(&ptr, param, TSIZEOF(param)) == '\0' ) break;
		if ( Isdigit(param[0]) ){
			pptr = param;
			EnhancedContrast = static_cast<float>(GetNumber(&pptr)) / 100.0f;
		}
		NextParameter(&ptr);
		// grayscaleEnhancedContrast // IDWriteFactory2
		if ( GetCommandParameter(&ptr, param, TSIZEOF(param)) == '\0' ) break;
		if ( Isdigit(param[0]) ){
			pptr = param;
			GrayEhContrast = static_cast<float>(GetNumber(&pptr)) / 100.0f;
		}
		NextParameter(&ptr);
		// ClearTypeLevel
		if ( GetCommandParameter(&ptr, param, TSIZEOF(param)) == '\0' ) break;
		if ( Isdigit(param[0]) ){
			pptr = param;
			ClearTypeLevel = static_cast<float>(GetNumber(&pptr)) / 100.0f;
		}
		NextParameter(&ptr);
		// RenderingMode
		if ( GetCommandParameter(&ptr, param, TSIZEOF(param)) == '\0' ) break;
		if ( Isdigit(param[0]) ){
			pptr = param;
			RenderingMode = static_cast<DWRITE_RENDERING_MODE>(GetNumber(&pptr));
		}
		NextParameter(&ptr);
		// gridFitMode // IDWriteFactory2 , Win8.1
		if ( GetCommandParameter(&ptr, param, TSIZEOF(param)) == '\0' ) break;
		if ( Isdigit(param[0]) ){
			pptr = param;
			gridFitMode = static_cast<DWRITE_GRID_FIT_MODE>(GetNumber(&pptr));
		}
		NextParameter(&ptr);
		// COLOR_FONT
		if ( GetCommandParameter(&ptr, param, TSIZEOF(param)) == '\0' ) break;
		if ( Isdigit(param[0]) ){
			if ( DwVersion >= DWVER_12 ){
				pptr = param;
				TextOption = static_cast<D2D1_DRAW_TEXT_OPTIONS>(GetNumber(&pptr));
				if ( TextOption == D2D1_DRAW_TEXT_OPTIONS_NO_SNAP ){
					TextOption = D2D1_DRAW_TEXT_OPTIONS_ENABLE_COLOR_FONT;
				}
			}else{
				TextOption = D2D1_DRAW_TEXT_OPTIONS_NONE;
			}
		}
		NextParameter(&ptr);
		// HeightAlignment
		if ( GetCommandParameter(&ptr, param, TSIZEOF(param)) == '\0' ) break;
		if ( Isdigit(param[0]) ){
			HeightAlignment = static_cast<DWRITE_PARAGRAPH_ALIGNMENT>(GetNumber(&pptr));
		}
		break;
	}

	if ( DwVersion >= DWVER_12 ){
		IDWriteRenderingParams2 *NewRparams = NULL;

		if ( SUCCEEDED(DxDraw->dwFactory->CreateCustomRenderingParams(
				Gamma, EnhancedContrast, GrayEhContrast, ClearTypeLevel,
				OldRparams->GetPixelGeometry(), RenderingMode, gridFitMode,
				&NewRparams)) ){
			DxDraw->HwndRenderTarget->SetTextRenderingParams(NewRparams);
			NewRparams->Release();
		}
	}else{
		IDWriteRenderingParams *NewRparams = NULL;

		if ( SUCCEEDED(DxDraw->dwFactory->CreateCustomRenderingParams(
				Gamma, EnhancedContrast, ClearTypeLevel,
				OldRparams->GetPixelGeometry(), RenderingMode, &NewRparams)) ){
			DxDraw->HwndRenderTarget->SetTextRenderingParams(NewRparams);
			NewRparams->Release();
		}
	}
	OldRparams->Release();
	return TRUE;
}

ID2D1SolidColorBrush *InitTextBrush(DXDRAWSTRUCT *DxDraw)
{
	// ̂ƂAANeBuɂPgpĂ
	DxDraw->HwndRenderTarget->CreateSolidColorBrush(
			D2D1::ColorF(D3DCOLORfromCOLORREF(DxDraw->TextBrush.color), 1.0f),
			&DxDraw->TextBrush.brush);
	return DxDraw->TextBrush.brush;
}


int BeginDxDraw(DXDRAWSTRUCT *DxDraw, PAINTSTRUCT *ps)
{
	if ( DxDraw == NULL ) return DXSTART_GDI;
	if ( GetKeyState(VK_SCROLL) & 1 ){
		BeginPaint(DxDraw->hWnd, ps);
		return DXSTART_GDI;
	}

	if ( DxDraw->HwndRenderTarget == NULL ){
		if ( InitRenderTarget(DxDraw) == FALSE ){
			BeginPaint(DxDraw->hWnd, ps);
			return DXSTART_GDI;
		}
	}

	if ( DxDraw->TextBrush.brush == NULL ){ // TextBrush  ĂȂp
		// ̂ƂAANeBuɂPgpĂ
		if ( InitTextBrush(DxDraw) == NULL ) return DXSTART_GDI;
	}

	if ( DxDraw->HwndRenderTarget->CheckWindowState() & D2D1_WINDOW_STATE_OCCLUDED ){
		ValidateRect(DxDraw->hWnd, NULL);
		return DXSTART_NODRAW; // `̕KvȂ & ŉ߂ĕ`悷
	}

	DxDraw->HwndRenderTarget->BeginDraw();
	DxDraw->HwndRenderTarget->SetTransform(DxDraw->DefaultTransform);

#if DWMGLASS
	DxDraw->HwndRenderTarget->Clear(D2D1::ColorF(0.0f, 0.0f, 0.0f, 0.0f));
#else
	DxDraw->HwndRenderTarget->Clear(D2D1::ColorF(D3DCOLORfromCOLORREF(DxDraw->BackBrush.color)));
#endif

	ps->hdc = static_cast<HDC>(DXMODEVALUE_DX);
	ps->fErase = FALSE;
	ps->rcPaint = DxDraw->clientBox;
	return DXSTART_DX;
}

BOOL EndDxDraw(DXDRAWSTRUCT *DxDraw)
{
	if ( DxDraw->HwndRenderTarget != NULL ){
		if ( DxDraw->HwndRenderTarget->EndDraw() == D2DERR_RECREATE_TARGET ){
			ResetDxDraw(DxDraw);
			Sleep(50);
			InvalidateRect(DxDraw->hWnd, NULL, TRUE);
			return TRUE;
		}
	}
	ValidateRect(DxDraw->hWnd, NULL);
	return TRUE;
}

void DxSetRotate(DXDRAWSTRUCT *DxDraw, int rel_angle)
{
	float height;
	D2D1_POINT_2F centerPoint;

	if ( DxDraw == NULL ) return;

	DxDraw->RotateAngle += rel_angle;
	while ( DxDraw->RotateAngle < 0 ) DxDraw->RotateAngle += 360;
	while ( DxDraw->RotateAngle >= 360 ) DxDraw->RotateAngle -= 360;

	height = static_cast<float>(DxDraw->clientArea.height) / 2.0f;
	centerPoint = D2D1::Point2F(0.0f, height / ((DxDraw->DeskScale.y / DEFAULT_DPI - 1.0f) / 2.0f + 1.0f));

	if ( DxDraw->RotateAngle == 0 ){ // DeskScaleRate
		DxDraw->DefaultTransform = D2D1::Matrix3x2F::Identity();
		DxDraw->DefaultTransform._11 = DxDraw->DeskScaleRate.x;
		DxDraw->DefaultTransform._22 = DxDraw->DeskScaleRate.y;

		// ㉺]
		DxDraw->BMPTransform = D2D1::Matrix3x2F::Scale(
				DxDraw->DeskScaleRate.x, -DxDraw->DeskScaleRate.y, centerPoint);
	}else{ // DotScaleRate
		float RotateAngle = static_cast<float>(DxDraw->RotateAngle);
		float width = static_cast<float>(DxDraw->clientArea.width) / 2.0f;

		DD2D1MakeRotateMatrix(RotateAngle,
				D2D1::Point2F(width, height), &DxDraw->DefaultTransform);
		DD2D1MakeRotateMatrix(-RotateAngle,
				D2D1::Point2F(width, height), &DxDraw->HitPointTransform);
		DxDraw->BMPTransform.SetProduct(
				D2D1::Matrix3x2F::Scale(
						DxDraw->DeskScaleRate.x, -DxDraw->DeskScaleRate.y,
						centerPoint),
				static_cast<const D2D1::Matrix3x2F &>(DxDraw->DefaultTransform));
	}
}

void DxTransformPoint(DXDRAWSTRUCT *DxDraw, LPARAM *lParam)
{
	if ( DxDraw == NULL ) return;
	if ( DxDraw->RotateAngle == 0 ) return;

	D2D1_POINT_2F pos = DxDraw->HitPointTransform.TransformPoint(D2D1::Point2F(
			static_cast<float>(static_cast<short>(LOWORD(*lParam))),
			static_cast<float>(static_cast<short>(HIWORD(*lParam)))));
#pragma warning(suppress:26451) // 32biť͈͓vZ
	*lParam = static_cast<WORD>(pos.x) + (static_cast<WORD>(pos.y) << 16);
}

HRESULT InitMainFont(DXDRAWSTRUCT *DxDraw)
{
	HRESULT result;

	if ( DxDraw->textFormatMain != NULL ){
		DxDraw->textFormatMain->Release();
		DxDraw->textFormatMain = NULL;
	}

	result = DxDraw->dwFactory->CreateTextFormat(DxDraw->fontName,
			NULL,
			DWRITE_FONT_WEIGHT_NORMAL, DWRITE_FONT_STYLE_NORMAL,
			DWRITE_FONT_STRETCH_NORMAL,
			DxDraw->fontH * DxDraw->DotScaleRate,
			L"",
			&DxDraw->textFormatMain);
	if ( SUCCEEDED(result) ){
		DxDraw->textFormatMain->SetWordWrapping(DWRITE_WORD_WRAPPING_NO_WRAP);
		DxDraw->textFormatMain->SetParagraphAlignment(HeightAlignment);
		DxDraw->textFormat = DxDraw->textFormatMain;
	}else{
		DxDraw->textFormatMain = NULL;
	}
	return result;
}

HRESULT InitSubFont(DXDRAWSTRUCT *DxDraw, int type)
{
	HRESULT result;

	if ( DxDraw->textFormatSub != NULL ){
		DxDraw->textFormatSub->Release();
		DxDraw->textFormatSub = NULL;
	}

	result = DxDraw->dwFactory->CreateTextFormat(
			(type != DXFONT_MAIN_RIGHT) ? DxDraw->fontNameSub : DxDraw->fontName,
			NULL,
			DWRITE_FONT_WEIGHT_NORMAL, DWRITE_FONT_STYLE_NORMAL,
			DWRITE_FONT_STRETCH_NORMAL,
			DxDraw->fontH * DxDraw->DotScaleRate,
			(type == DXFONT_EN_US) ? L"en-us" : L"",
			&DxDraw->textFormatSub);
	if ( SUCCEEDED(result) ){
		DxDraw->textFormatSub->SetWordWrapping(DWRITE_WORD_WRAPPING_NO_WRAP);
		if ( type == DXFONT_MAIN_RIGHT ){
			DxDraw->textFormatMain->SetParagraphAlignment(HeightAlignment);
			DxDraw->textFormatSub->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_TRAILING);
		}
	}else{
		DxDraw->textFormatSub = NULL;
	}
	return result;
}

void DxSelectFont(DXDRAWSTRUCT *DxDraw, int type)
{
	if ( DxDraw == NULL ) return;
	if ( type == 0 ){
		if ( DxDraw->textFormatMain == NULL ){ // ĂȂp
			if ( FAILED(InitMainFont(DxDraw)) ) return;
		}
		DxDraw->textFormat = DxDraw->textFormatMain;
	}else{ // 1:v|[Vi, 2:ANSI/IBM
		if ( DxDraw->textFormatSub == NULL ){ // ĂȂp
			if ( FAILED(InitSubFont(DxDraw, type)) ) return;
		}
		DxDraw->textFormat = DxDraw->textFormatSub;
	}
}

void SetToLogfont(LOGFONTW &lFont, IDWriteFont *WriteFont)
{
	IDWriteLocalizedStrings *LName;
	IDWriteFontFamily *FontFamily;

	if ( SUCCEEDED(WriteFont->GetFontFamily(&FontFamily)) ){
		if ( SUCCEEDED(FontFamily->GetFamilyNames(&LName)) ){
			LName->GetString(0, lFont.lfFaceName, LF_FACESIZE);
			LName->Release();
		}
		FontFamily->Release();
	}
}

void FixLogfontForDirectWrite(IDWriteFactory *Factory, LOGFONTW &lFont)
{
	IDWriteGdiInterop *GdiInterop;
	IDWriteFont *WriteFont;

	if ( FAILED(Factory->GetGdiInterop(&GdiInterop)) ) return;

	// Hł̃tHg
	if ( SUCCEEDED(GdiInterop->CreateFontFromLOGFONT(&lFont, &WriteFont)) ){
		SetToLogfont(lFont, WriteFont);
		WriteFont->Release();
	}else
#if 1
	{	// Ōオ font face ̃tHg
		WCHAR *FontFace = strrchrW(lFont.lfFaceName, ' ');
		if ( FontFace != NULL ){
			*FontFace = '\0';
			if ( SUCCEEDED(GdiInterop->CreateFontFromLOGFONT(&lFont, &WriteFont)) ){
				SetToLogfont(lFont, WriteFont);
				WriteFont->Release();
			}else{
				*FontFace = ' '; // ɖ߂
			}
		}
	}
#else
	{	// OSvȂtHg
		IDWriteFontCollection *FontCollection;
		if ( SUCCEEDED(Factory->GetSystemFontCollection(&FontCollection, FALSE)) ){
			int font_count = FontCollection->GetFontFamilyCount();

			for ( int i = 0; i < font_count; i++ ){
				WCHAR fontname[LF_FACESIZE * 2];
				IDWriteLocalizedStrings *names;
				IDWriteFontFamily *FontFamily;

				if ( SUCCEEDED(FontCollection->GetFontFamily(i, &FontFamily)) ){
					FontFamily->GetFamilyNames(&names);
					int name_count = names->GetCount();
					for ( int name_i = 0; name_i < name_count; name_i++ ){
						names->GetString(name_i, fontname, LF_FACESIZE * 2);
						if ( memcmp(fontname, lFont.lfFaceName, strlenW(fontname) * 2) == 0 ){
							strcpyW(lFont.lfFaceName, fontname);
						}
					}
					names->Release();
					FontFamily->Release();
				}
			}
			FontCollection->Release();
		}
	}
#endif
	GdiInterop->Release();
}

DWORD SetFontDxDraw(DXDRAWSTRUCT *DxDraw, HFONT hFont, int type)
{
	LOGFONTW lfont;

	if ( DxDraw == NULL ) return 0;
	if ( hFont == NULL ){
		if ( DxDraw->textFormatSub != NULL ){
			if ( DxDraw->textFormat == DxDraw->textFormatSub ){
				DxDraw->textFormat = NULL;
			}
			DxDraw->textFormatSub->Release();
			DxDraw->textFormatSub = NULL;
		}
		return 0;
	}

	HDC hDC;
	HGDIOBJ hOldGDI;

	hDC = GetDC(DxDraw->hWnd);
	hOldGDI = SelectObject(hDC, hFont);

	if ( type == 0 ){ // main font
		DxDraw->DotScaleRate = DEFAULT_DPI / static_cast<float>(PPxCommonExtCommand(K_GETDISPDPI, (WPARAM)DxDraw->hWnd));

		if ( DxDraw->textFormatMain != NULL ){
			DxDraw->textFormatMain->Release();
			DxDraw->textFormatMain = NULL;
			DxDraw->textFormat = NULL;
		}
		GetObjectW(hFont, sizeof(LOGFONTW), static_cast<LPVOID>(&lfont));
		FixLogfontForDirectWrite(DxDraw->dwFactory, lfont);
		strcpyW(DxDraw->fontName, lfont.lfFaceName);

		SelectObject(hDC, hOldGDI);
		ReleaseDC(DxDraw->hWnd, hDC);
	}else{ // sub font
		if ( DxDraw->textFormatSub != NULL ){
			if ( DxDraw->textFormat == DxDraw->textFormatSub ){
				DxDraw->textFormat = NULL;
			}
			DxDraw->textFormatSub->Release();
			DxDraw->textFormatSub = NULL;
		}
		GetObjectW(hFont, sizeof(LOGFONTW), static_cast<LPVOID>(&lfont));
		FixLogfontForDirectWrite(DxDraw->dwFactory, lfont);
		strcpyW(DxDraw->fontNameSub, lfont.lfFaceName);

		SelectObject(hDC, hOldGDI);
		ReleaseDC(DxDraw->hWnd, hDC);
		return 1;
	}

	DxDraw->fontH = static_cast<float>( (lfont.lfHeight >= 0) ?
			 lfont.lfHeight : -lfont.lfHeight) / DxDraw->DotScaleRate;

	if ( DxDraw->HwndRenderTarget == NULL ){
		if ( InitRenderTarget(DxDraw) == FALSE ) return 0;
	}

	if ( DxDraw->textFormat == NULL ){ // ĂȂp
		if ( FAILED(InitMainFont(DxDraw)) ) return 0;
	}

	WCHAR chr[11] = L"0123456789";
	DWRITE_TEXT_METRICS strMet;
	IDWriteTextLayout *dwLayout;

	#pragma warning(suppress:6387) // InitMainFontŏς
	if ( SUCCEEDED(DxDraw->dwFactory->CreateGdiCompatibleTextLayout(chr,
			TSIZEOFW(chr) - 1, DxDraw->textFormat, 32000, DxDraw->fontH,
			1.0f, NULL, TRUE, &dwLayout)) ){
		dwLayout->GetMetrics(&strMet);
		dwLayout->Release();

		DxDraw->fontW = (strMet.widthIncludingTrailingWhitespace) / static_cast<float>(TSIZEOFW(chr) - 1);
	}else{
		DxDraw->fontW = 8; // dummy
	}

	return static_cast<int>(DxDraw->fontW);
}

void USEFASTCALL DxMoveToEx(DXDRAWSTRUCT *DxDraw, HDC hDC, int x, int y)
{
	IfGDImode(hDC){
		MoveToEx(hDC, x, y, NULL);
		return;
	}
	DxDraw->lastpos.x = static_cast<float>(x);
	DxDraw->lastpos.y = static_cast<float>(y);
}

void USEFASTCALL DxGetCurrentPositionEx(DXDRAWSTRUCT *DxDraw, HDC hDC, POINT *lp)
{
	IfGDImode(hDC){
		GetCurrentPositionEx(hDC, lp);
		return;
	}
	lp->x = static_cast<LONG>(DxDraw->lastpos.x);
	lp->y = static_cast<LONG>(DxDraw->lastpos.y);
}

int DxSetBkMode(DXDRAWSTRUCT *DxDraw, HDC hDC, int mode)
{
	IfGDImode(hDC) return SetBkMode(hDC, mode);

	int oldmode = DxDraw->BkMode;
	DxDraw->BkMode = mode;
	return mode;
}

COLORREF DxSetBkColor(DXDRAWSTRUCT *DxDraw, HDC hDC, COLORREF color)
{
	IfGDImode(hDC) return SetBkColor(hDC, color);

	COLORREF oldcolor = DxDraw->BackTextColor;
	DxDraw->BackTextColor = color;
	return oldcolor;
}

COLORREF SetDxBrush(DXDRAWSTRUCT *DxDraw, DXBRUSHSTRUCT *brush, COLORREF color)
{
	COLORREF oldcolor = brush->color;

	if ( (color == oldcolor) && (brush->brush != NULL) ) return oldcolor;

	brush->color = color;
	if ( brush->brush != NULL ){
		brush->brush->Release();
		brush->brush = NULL;
	}
	DxDraw->HwndRenderTarget->CreateSolidColorBrush(
			D2D1::ColorF(D3DCOLORfromCOLORREF(color),
			static_cast<float>(color >> 24) / 255.0f),
			&brush->brush);
	return oldcolor;
}

COLORREF DxSetTextColor(DXDRAWSTRUCT *DxDraw, HDC hDC, COLORREF color)
{
	IfGDImode(hDC) return SetTextColor(hDC, color);
	return SetDxBrush(DxDraw, &DxDraw->TextBrush, color | 0xff000000);
}

ID2D1SolidColorBrush *GetDxBrush(DXDRAWSTRUCT *DxDraw, COLORREF color)
{
	if ( color == DxDraw->BackBrush.color ){
		SetDxBrush(DxDraw, &DxDraw->BackBrush, color);
		return DxDraw->BackBrush.brush;
	}else if ( color == DxDraw->TextBrush.color ){
		SetDxBrush(DxDraw, &DxDraw->TextBrush, color);
		return DxDraw->TextBrush.brush;
	}else{
		SetDxBrush(DxDraw, &DxDraw->SubBrush, color);
		return DxDraw->SubBrush.brush;
	}
}

void DxDrawBack(DXDRAWSTRUCT *DxDraw, HDC hDC, const RECT *box, COLORREF color)
{
	IfGDImode(hDC) return;

	D2D1_RECT_F d2box = {
			static_cast<float>(box->left),
			static_cast<float>(box->top),
			static_cast<float>(box->right),
			static_cast<float>(box->bottom) };
	DxDraw->HwndRenderTarget->FillRectangle(&d2box, GetDxBrush(DxDraw, color));
}

void DxDrawFrameRect(DXDRAWSTRUCT *DxDraw, HDC hDC, const RECT *box, COLORREF color)
{
	IfGDImode(hDC) return;

	D2D1_RECT_F d2box = {
			static_cast<float>(box->left),
			static_cast<float>(box->top),
			static_cast<float>(box->right),
			static_cast<float>(box->bottom) };
	DxDraw->HwndRenderTarget->DrawRectangle(&d2box, GetDxBrush(DxDraw, color | 0xff000000));
}

BOOL ChangeSizeDxDraw(DXDRAWSTRUCT *DxDraw, COLORREF backcolor)
{
	if ( DxDraw == NULL ) return FALSE;

	// RenderTarget 
	GetClientRect(DxDraw->hWnd, &DxDraw->clientBox);
	if ( (DxDraw->clientArea.width  != DxDraw->clientBox.right) ||
		 (DxDraw->clientArea.height != DxDraw->clientBox.bottom) ){
		DxDraw->clientArea.width  = DxDraw->clientBox.right;
		DxDraw->clientArea.height = DxDraw->clientBox.bottom;
		if ( DxDraw->HwndRenderTarget != NULL ){
			DxDraw->HwndRenderTarget->Resize(DxDraw->clientArea);
		}

		DxSetRotate(DxDraw, 0);
	}
	if ( DxDraw->BackBrush.color != backcolor ){
		DxDraw->BackColor = backcolor;
		DxDraw->BackBrush.color = backcolor | 0xff000000;
		if ( DxDraw->BackBrush.brush != NULL ){
			DxDraw->BackBrush.brush->Release();
			DxDraw->BackBrush.brush = NULL;
		}
	}
	return TRUE;
}

BOOL DxGetTextExtentExPoint(DXDRAWSTRUCT *DxDraw, HDC hDC, const TCHAR *str, int len, int maxwidth, int *fitlen, int *alptbl, SIZE *blksize)
{
	IDWriteTextLayout *dwLayout;

	IfGDImode(hDC){
		return GetTextExtentExPoint(hDC, str, len, maxwidth, fitlen, alptbl, blksize);
	}

	if ( DxDraw == NULL ){
		*fitlen = 0;
		return FALSE;
	}

	if ( DxDraw->textFormat == NULL ){ // ĂȂp
		*fitlen = 0;
		if ( FAILED(InitMainFont(DxDraw)) ) return FALSE;
	}


	for (;;){
	#ifdef UNICODE
		#define DRAWLEN len
		#define DRAWSTR str
	#else
		WCHAR DRAWSTR[0x200];
		int DRAWLEN;

		DRAWLEN = MultiByteToWideChar(CP_ACP, 0, str, len, DRAWSTR, TSIZEOFW(DRAWSTR));
	#endif

		#pragma warning(suppress:6387) // InitMainFontŏς
		if ( SUCCEEDED(DxDraw->dwFactory->CreateGdiCompatibleTextLayout(DRAWSTR, static_cast<UINT32>(DRAWLEN), DxDraw->textFormat, 32000, DxDraw->fontH, 1.0f, NULL, FALSE, &dwLayout)) ){
			#undef DRAWLEN
			#undef DRAWSTR

			DWRITE_TEXT_METRICS strMet;

			dwLayout->GetMetrics(&strMet);
			dwLayout->Release();
			blksize->cx = static_cast<int>(strMet.widthIncludingTrailingWhitespace);
			if ( blksize->cx <= maxwidth ) break;
			if ( len == 0 ) break;
			len--;
		} else {
			len = 0;
			break;
		}
	}
	*fitlen = len;
	return TRUE;
}

void DxDrawTextBack(DXDRAWSTRUCT *DxDraw, DWRITE_TEXT_METRICS &strMet)
{
	D2D1_RECT_F d2box = {
			DxDraw->lastpos.x,
			DxDraw->lastpos.y,
			DxDraw->lastpos.x + strMet.widthIncludingTrailingWhitespace,
			DxDraw->lastpos.y + strMet.height - DxDraw->ul_height };
	DxDraw->HwndRenderTarget->FillRectangle(&d2box, GetDxBrush(DxDraw, DxDraw->BackTextColor | 0xff000000));
}

void DxTextOutRel(DXDRAWSTRUCT *DxDraw, HDC hDC, const TCHAR *str, int len)
{
	IDWriteTextLayout *dwLayout;

	IfGDImode(hDC){
		TextOut(hDC, 0, 0, str, len);
		return;
	}
	if ( DxDraw == NULL ) return;

	if ( DxDraw->textFormat == NULL ){ // ĂȂp
		if ( FAILED(InitMainFont(DxDraw)) ) return;
	}

	#ifdef UNICODE
		#define DRAWLEN len
		#define DRAWSTR str
	#else
		WCHAR DRAWSTR[0x200];
		int DRAWLEN = MultiByteToWideChar(CP_ACP, 0, str, len, DRAWSTR, TSIZEOFW(DRAWSTR) );
	#endif
	#pragma warning(suppress:6387) // InitMainFontŏς
	if ( FAILED(DxDraw->dwFactory->CreateGdiCompatibleTextLayout(DRAWSTR, DRAWLEN, DxDraw->textFormat, 32000, DxDraw->fontH, 1.0f, NULL, FALSE, &dwLayout)) ){
		return;
	}

	DWRITE_TEXT_METRICS strMet;
	dwLayout->GetMetrics(&strMet);

	if ( DxDraw->BackTextColor != DxDraw->BackColor ){
		DxDrawTextBack(DxDraw, strMet);
	}
	if ( (DxDraw->TextBrush.brush != NULL) || (InitTextBrush(DxDraw) != NULL ) ){
		DxDraw->HwndRenderTarget->DrawTextLayout(DxDraw->lastpos, dwLayout, DxDraw->TextBrush.brush, TextOption);
	}
	dwLayout->Release();

	DxDraw->lastpos.x += strMet.widthIncludingTrailingWhitespace;
	#undef DRAWLEN
	#undef DRAWSTR
}

#ifndef UNICODE
void DxTextOutRelW(DXDRAWSTRUCT *DxDraw, HDC hDC, const WCHAR *str, int len)
{
	IDWriteTextLayout *dwLayout;

	IfGDImode(hDC){
		TextOutW(hDC, 0, 0, str, len);
		return;
	}
	if ( DxDraw == NULL ) return;

	#define DRAWLEN len
	#define DRAWSTR str

	DxDraw->dwFactory->CreateTextLayout(DRAWSTR, DRAWLEN, DxDraw->textFormat, 32000, DxDraw->fontH, &dwLayout);

	DWRITE_TEXT_METRICS strMet;
	dwLayout->GetMetrics(&strMet);

	if ( DxDraw->BackTextColor != DxDraw->BackColor ){
		DxDrawTextBack(DxDraw, strMet);
	}

	if ( (DxDraw->TextBrush.brush != NULL) || (InitTextBrush(DxDraw) != NULL ) ){
		DxDraw->HwndRenderTarget->DrawTextLayout(DxDraw->lastpos, dwLayout, DxDraw->TextBrush.brush, TextOption);
	}
	dwLayout->Release();
	DxDraw->lastpos.x += strMet.widthIncludingTrailingWhitespace;

	#undef DRAWLEN
	#undef DRAWSTR
}
#endif

void DxDrawText(DXDRAWSTRUCT *DxDraw, HDC hDC, const TCHAR *str, int len, RECT *box, DWORD flags)
{
	IDWriteTextLayout *dwLayout;
	float drawWidth, drawHeight;

	IfGDImode(hDC){
		if ( flags & DT_RIGHT ){
			SIZE fsize;
			int slen = len;
			const TCHAR *strp;

			strp = str;
			while ( (slen > 0) && (*strp == ' ') ){
				strp++;
				slen--;
			}
			GetTextExtentPoint32(hDC, strp, slen, &fsize);
			if ( fsize.cx < (box->right - box->left) ){
				RECT tmpbox;
				int drawX = box->right - fsize.cx;

				if ( GetBkMode(hDC) == OPAQUE ){
					HBRUSH hBackBrush;

					tmpbox = *box;
					tmpbox.right = drawX;
					hBackBrush = CreateSolidBrush(GetBkColor(hDC));
					::FillBox(hDC, &tmpbox, hBackBrush);
					DeleteObject(hBackBrush);
				}
				MoveToEx(hDC, drawX, box->top, NULL);
				TextOut(hDC, drawX, box->top, strp, slen);
				return;
			}
		}
		DrawText(hDC, str, len, box, flags);
		return;
	}
	if ( DxDraw == NULL ) return;

	if ( DxDraw->textFormat == NULL ){ // ĂȂp
		if ( FAILED(InitMainFont(DxDraw)) ) return;
	}

	#ifdef UNICODE
		#define DRAWLEN len
		#define DRAWSTR str

		if ( len < 0 ) len = strlenW(str);
	#else
		WCHAR DRAWSTR[0x200];
		int DRAWLEN = MultiByteToWideChar(CP_ACP, 0, str, len, DRAWSTR, TSIZEOFW(DRAWSTR) );
	#endif

	if ( flags & DT_WORDBREAK ){
		DxDraw->textFormat->SetWordWrapping(DWRITE_WORD_WRAPPING_WRAP);
	}

	drawWidth = static_cast<float>(box->right - box->left);
	drawHeight = static_cast<float>(box->bottom - box->top);
	#pragma warning(suppress:6387) // InitMainFontŏς
	if ( FAILED(DxDraw->dwFactory->CreateGdiCompatibleTextLayout(DRAWSTR,
			DRAWLEN, DxDraw->textFormat, drawWidth, drawHeight,
			1.0f, NULL, FALSE, &dwLayout)) ){
		return;
	}

	DWRITE_TEXT_METRICS strMet;
	dwLayout->GetMetrics(&strMet);

	if ( DxDraw->BackTextColor != DxDraw->BackColor ){ // wi`
		D2D1_RECT_F d2box = {
			DxDraw->lastpos.x,
			DxDraw->lastpos.y,
			DxDraw->lastpos.x + strMet.widthIncludingTrailingWhitespace,
			DxDraw->lastpos.y + strMet.height - DxDraw->ul_height };

		if ( strMet.height > drawHeight ){
			d2box.bottom -= strMet.height - drawHeight;
		}
		if ( strMet.widthIncludingTrailingWhitespace > drawWidth ){
			d2box.right = DxDraw->lastpos.x + drawWidth;
		}
		DxDraw->HwndRenderTarget->FillRectangle(&d2box, GetDxBrush(DxDraw, DxDraw->BackTextColor | 0xff000000));
	}

	// Ps̎́ANbsOĖucvɂ
	if ( (flags & DT_SINGLELINE) &&
		 (drawWidth < strMet.widthIncludingTrailingWhitespace) ){
		IDWriteTextLayout *dwTailLayout;
		DWRITE_TEXT_METRICS strMetTail;

		if ( flags & XDT_TOP_ELLIPSIS ){
			dwLayout->Release();
			if ( DxDraw->textFormatSub == NULL ){
				InitSubFont(DxDraw, DXFONT_MAIN_RIGHT);
			}
			DxDraw->dwFactory->CreateGdiCompatibleTextLayout(DRAWSTR + 1,
					DRAWLEN - 1, DxDraw->textFormatSub, drawWidth, drawHeight,
					1.0f, NULL, FALSE, &dwLayout);
		}

		strMet.widthIncludingTrailingWhitespace = drawWidth;
		#pragma warning(suppress:6387) // InitMainFontŏς
		DxDraw->dwFactory->CreateTextLayout(
				strtailS,
//				(drawWidth < 50) ? strtailS : strtailL,
				1, DxDraw->textFormat, 32000, drawHeight, &dwTailLayout);
		dwTailLayout->GetMetrics(&strMetTail);

		D2D1_POINT_2F pos;

		if ( flags & XDT_TOP_ELLIPSIS ){
			pos = DxDraw->lastpos;
		}else{
			pos.x = DxDraw->lastpos.x + drawWidth - strMetTail.widthIncludingTrailingWhitespace;
			pos.y = DxDraw->lastpos.y;
		}

		// ucv`
		DxDraw->HwndRenderTarget->DrawTextLayout(pos, dwTailLayout, DxDraw->TextBrush.brush, TextOption);
		dwTailLayout->Release();

		dwLayout->SetMaxWidth(drawWidth - strMetTail.widthIncludingTrailingWhitespace);
	}

	if ( flags & DT_RIGHT ){
		DxDraw->lastpos.x += drawWidth - strMet.widthIncludingTrailingWhitespace;
	}

	if ( (DxDraw->TextBrush.brush != NULL) || (InitTextBrush(DxDraw) != NULL ) ){
		DxDraw->HwndRenderTarget->DrawTextLayout(DxDraw->lastpos, dwLayout,
			DxDraw->TextBrush.brush, TextOption | D2D1_DRAW_TEXT_OPTIONS_CLIP);
	}
	dwLayout->Release();

	if ( flags & DT_WORDBREAK ){
		DxDraw->textFormat->SetWordWrapping(DWRITE_WORD_WRAPPING_NO_WRAP);
	}

	DxDraw->lastpos.x += strMet.widthIncludingTrailingWhitespace;
	#undef DRAWLEN
	#undef DRAWSTR
}

void DxSetUnderLineHeight(DXDRAWSTRUCT *DxDraw, int height)
{
	if ( DxDraw != NULL ) DxDraw->ul_height = height;
}


extern "C" typedef struct tagDXBMPCACHE {
	DXDRAWSTRUCT *DxDraw;
	D2D1_SIZE_U bmpsize;
	int cacheIndex, HwndRenderTargetCounter;
} DXBMPCACHE;

HBITMAP BmpColorConvert(BITMAPINFOHEADER *bmiHeader, LPVOID *lpBits)
{
	LPVOID TemplpBits;
	BITMAPINFO bmi;
	HDC hMDC;
	HBITMAP hConvertBmp;

	memset(&bmi.bmiHeader, 0, sizeof(BITMAPINFOHEADER));
	bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth = bmiHeader->biWidth;
	bmi.bmiHeader.biHeight = bmiHeader->biHeight;
	if ( bmi.bmiHeader.biHeight < 0 ){
		bmi.bmiHeader.biHeight = -bmi.bmiHeader.biHeight;
	}
	bmi.bmiHeader.biPlanes   = 1;
	bmi.bmiHeader.biBitCount = 32;

	hMDC = CreateCompatibleDC(NULL);
	hConvertBmp = CreateDIBSection(NULL, &bmi, DIB_RGB_COLORS, &TemplpBits, NULL, 0);
	if ( hConvertBmp != NULL ){
		HGDIOBJ hOldBmp;

		hOldBmp = SelectObject(hMDC, hConvertBmp);

		SetDIBitsToDevice(hMDC,
				0, 0, bmi.bmiHeader.biWidth, bmi.bmiHeader.biHeight,
				0, 0,  0, bmi.bmiHeader.biHeight,
				*lpBits, (BITMAPINFO *)bmiHeader, DIB_RGB_COLORS);

		SelectObject(hMDC, hOldBmp);
	}
	DeleteDC(hMDC);
	*lpBits = TemplpBits;
	return hConvertBmp;
}

BOOL DxDrawDIB(DXDRAWSTRUCT *DxDraw, BITMAPINFOHEADER *bmiHeader, LPVOID lpBits, const RECT *box, const RECT *clipArea, DXBMPCACHE **cache)
{
	ID2D1Bitmap *d2bmp;
	D2D1_SIZE_U bmpsize;

	bmpsize.height = (bmiHeader->biHeight >= 0) ? bmiHeader->biHeight : -bmiHeader->biHeight;

	// RenderTargetType  D2D1_RENDER_TARGET_TYPE_DEFAULT ̂Ƃ́A
	// 傫ĈȂƂ̂Ń\tg_Oɐ؂ւ
	if ( ((UINT32)bmiHeader->biWidth > DxDraw->MaxBitmapPixels) ||
		 ( (UINT32)bmpsize.height > DxDraw->MaxBitmapPixels) ){
		if ( DxDraw->RenderTargetType != D2D1_RENDER_TARGET_TYPE_SOFTWARE ){
			DxDraw->HwndRenderTarget->EndDraw(); // rłI
			ResetDxDraw(DxDraw); // ł܂܂ł̃_Oj

			DxDraw->RenderTargetType = D2D1_RENDER_TARGET_TYPE_SOFTWARE;
			Sleep(50);
			if ( InitRenderTarget(DxDraw) == FALSE ) return FALSE;
			// ă_Ow
			PostMessage(DxDraw->hWnd, WM_PPXCOMMAND,
				(LPARAM)(K_raw | K_c | 'L'), 0);
		}else{
			return FALSE;
		}
	}

	if ( (cache == NULL) || (*cache == NULL) ){ // LbV
		D2D1_BITMAP_PROPERTIES bmpprop;
		HBITMAP hConvertBmp = NULL;

		bmpsize.width = bmiHeader->biWidth;
		// ̂܂܈Ȃ̂ϊ(32bit, bottom-up, ʏbit-field ȊOϊ)
		if ( (bmiHeader->biBitCount != 32) ||
			 (bmiHeader->biHeight < 0) ||
			 ( (bmiHeader->biCompression == BI_BITFIELDS) ?
				((*(DWORD *)(BYTE *)((BYTE *)bmiHeader + sizeof(BITMAPINFOHEADER) ) != 0xff0000) ||
				 (*(DWORD *)(BYTE *)((BYTE *)bmiHeader + sizeof(BITMAPINFOHEADER) + sizeof(DWORD) ) != 0xff00) ||
				 (*(DWORD *)(BYTE *)((BYTE *)bmiHeader + sizeof(BITMAPINFOHEADER) + sizeof(DWORD) * 2) != 0xff)) :
			   (bmiHeader->biCompression != BI_RGB) ) ){
			hConvertBmp = BmpColorConvert(bmiHeader, &lpBits);
			if ( hConvertBmp == NULL ) return FALSE;
		// bmp ̑傫mF
		}else if ( (bmiHeader->biSizeImage > 0) &&
			 (bmiHeader->biSizeImage < (bmpsize.height * DwordBitSize(bmpsize.width * bmiHeader->biBitCount))) ){
			return FALSE;
		}

		bmpprop.dpiX = DxDraw->DeskScale.x;
		bmpprop.dpiY = DxDraw->DeskScale.y;
		bmpprop.pixelFormat = D2D1::PixelFormat(
				DXGI_FORMAT_B8G8R8A8_UNORM,
//				D2D1_ALPHA_MODE_STRAIGHT);
				D2D1_ALPHA_MODE_IGNORE);

		HRESULT hr = DxDraw->HwndRenderTarget->CreateBitmap(bmpsize, lpBits, bmpsize.width * 4/* Alignmentς*/ , bmpprop, &d2bmp);
		if ( hConvertBmp != NULL ) DeleteObject(hConvertBmp); // rbg}bṽ폜

		if ( SUCCEEDED(hr) ){
			if ( cache != NULL ){
				for ( int i = 0 ; i < DXBMPCACHEITEMS ; i++ ){
					if ( DxDraw->bmpCache[i] == NULL ){
						*cache = new DXBMPCACHE;
						DxDraw->bmpCache[i] = d2bmp;
						(*cache)->DxDraw = DxDraw;
						(*cache)->cacheIndex = i;
						(*cache)->bmpsize = bmpsize;
						(*cache)->HwndRenderTargetCounter = DxDraw->HwndRenderTargetCounter;
						break;
					}
				}
			}
		}else{
			return FALSE;
		}
	}else{
		d2bmp = DxDraw->bmpCache[(*cache)->cacheIndex];
		// LbVpH
		if ( ((*cache)->HwndRenderTargetCounter != DxDraw->HwndRenderTargetCounter) || (d2bmp == NULL) ){
			DxDrawFreeBMPCache(cache);
			return DxDrawDIB(DxDraw, bmiHeader, lpBits, box, clipArea, cache);
		}
		// LbVgp
		bmpsize = (*cache)->bmpsize;
	}

	if ( clipArea == NULL ) clipArea = &DxDraw->clientBox;

	D2D1_RECT_F d2bmpbox = {
		0.0f, 0.0f,
		static_cast<float>(bmpsize.width), static_cast<float>(bmpsize.height) };
	D2D1_RECT_F d2box = {
		static_cast<float>(box->left), 0.0f,
		static_cast<float>(box->left + box->right), 0.0f};

	d2box.top = static_cast<float>(static_cast<int>(DxDraw->clientArea.height) - (box->top + box->bottom));
	d2box.bottom = static_cast<float>(static_cast<int>(DxDraw->clientArea.height) - box->top);

	if ( box->top < clipArea->top ){ // (`͉)NbsO
		d2bmpbox.bottom -= static_cast<float>(clipArea->top - box->top) * static_cast<float>(bmpsize.height) / static_cast<float>(box->bottom);
		d2box.bottom = static_cast<float>(static_cast<int>(DxDraw->clientArea.height) - clipArea->top);
	}
	if ( (box->top + box->bottom) > clipArea->bottom ){ // (`͏)NbsO
		// d2bmpbox.top  0.0f ŒȂ̂ŉZȗ
		d2bmpbox.top = static_cast<float>((box->top + box->bottom) - clipArea->bottom) * static_cast<float>(bmpsize.height) / static_cast<float>(box->bottom) * DxDraw->DeskScaleRate.y;
		d2box.top = static_cast<float>(static_cast<int>(DxDraw->clientArea.height) - clipArea->bottom);
	}
	DxDraw->HwndRenderTarget->SetTransform(DxDraw->BMPTransform);

	if ( box->left < clipArea->left ){ // NbsO
		// d2bmpbox.left  0.0f ŒȂ̂ŉZȗ
		d2bmpbox.left = static_cast<float>(clipArea->left - box->left) * static_cast<float>(bmpsize.width) / static_cast<float>(box->right) * DxDraw->DeskScaleRate.x;
		d2box.left = static_cast<float>(clipArea->left);
	}
	if ( (box->left + box->right) > clipArea->right ){ // ENbsO
		d2bmpbox.right -= static_cast<float>((box->left + box->right) - clipArea->right) * static_cast<float>(bmpsize.width) / static_cast<float>(box->right);
		d2box.right = static_cast<float>(clipArea->right);
	}

	d2bmpbox.bottom *= DxDraw->DeskScaleRate.y;
	d2bmpbox.right *= DxDraw->DeskScaleRate.x;
	DxDraw->HwndRenderTarget->DrawBitmap(d2bmp, d2box , 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR, d2bmpbox );
	DxDraw->HwndRenderTarget->SetTransform(DxDraw->DefaultTransform);
	if ( (cache == NULL) || (*cache == NULL) ) d2bmp->Release();
	return TRUE;
}

void DxGDIDrawIcon(DXDRAWSTRUCT *DxDraw, HICON icon, const RECT *box, DXBMPCACHE **cache)
{
	BITMAPINFO bmi;
	LPVOID lpBits;
	HBITMAP hbmp;
	HGDIOBJ hOldBmp;
	HDC hDC;
	HBRUSH hBackBrush;

	memset(&bmi.bmiHeader, 0, sizeof(BITMAPINFOHEADER));
	bmi.bmiHeader.biSize     = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth    = 32;
	bmi.bmiHeader.biHeight   = 32;
	bmi.bmiHeader.biPlanes   = 1;
	bmi.bmiHeader.biBitCount = 32;
	hbmp = CreateDIBSection(NULL, (LPBITMAPINFO)&bmi, DIB_RGB_COLORS, &lpBits, NULL, 0);
	hDC = CreateCompatibleDC(NULL);
	hOldBmp = SelectObject(hDC, hbmp);
	hBackBrush = CreateSolidBrush(DxDraw->BackColor);
	DrawIconEx(hDC, 0, 0, icon, bmi.bmiHeader.biWidth, bmi.bmiHeader.biHeight, 0, hBackBrush, DI_NORMAL);
	DeleteObject(hBackBrush);
	SelectObject(hDC, hOldBmp);
	DeleteDC(hDC);

	DxDrawDIB(DxDraw, &bmi.bmiHeader, lpBits, box, NULL, cache);
	DeleteObject(hbmp); // rbg}bṽ폜
}

const IID IID_IWICImagingFactory = {0xec5ec8a9, 0xc395, 0x4314, {0x9c, 0x77, 0x54, 0xd7, 0xa9, 0x35, 0xff, 0x70}};

void DxDrawIcon(DXDRAWSTRUCT *DxDraw, HICON icon, const RECT *box, DXBMPCACHE **cache)
{
	if ( DxDraw == NULL ) return;

	if ( (cache == NULL) || (*cache == NULL) ||
	   ((*cache)->HwndRenderTargetCounter != DxDraw->HwndRenderTargetCounter) ||
	   (DxDraw->bmpCache[(*cache)->cacheIndex] == NULL) ){
		if ( (DxDraw->WicFactory != NULL) ||
			SUCCEEDED(::CoCreateInstance(CLSID_WICImagingFactory, NULL,
				CLSCTX_INPROC_SERVER, IID_IWICImagingFactory,
				reinterpret_cast<void**>(&DxDraw->WicFactory))) ){
			IWICBitmap *wicbmp;
			ID2D1Bitmap *d2bmp;
			D2D1_SIZE_U bmpsize;
			IWICFormatConverter *wicConverter;

			if ( SUCCEEDED(DxDraw->WicFactory->CreateBitmapFromHICON(
					icon, &wicbmp)) ){
				wicbmp->GetSize(&bmpsize.width, &bmpsize.height);

				DxDraw->WicFactory->CreateFormatConverter(&wicConverter);

				wicConverter->Initialize(wicbmp, GUID_WICPixelFormat32bppPBGRA, WICBitmapDitherTypeNone, NULL, 0, WICBitmapPaletteTypeMedianCut);

				if ( SUCCEEDED(DxDraw->HwndRenderTarget->
						CreateBitmapFromWicBitmap(wicConverter, &d2bmp)) ){
					BOOL destroy = TRUE;

					if ( cache != NULL ){
						for ( int i = 0 ; i < DXBMPCACHEITEMS ; i++ ){
							if ( DxDraw->bmpCache[i] == NULL ){
								*cache = new DXBMPCACHE;
								DxDraw->bmpCache[i] = d2bmp;
								(*cache)->DxDraw = DxDraw;
								(*cache)->cacheIndex = i;
								(*cache)->bmpsize = bmpsize;
								(*cache)->HwndRenderTargetCounter = DxDraw->HwndRenderTargetCounter;
								destroy = FALSE;
								break;
							}
						}
					}

					D2D1_RECT_F d2box = {
						static_cast<float>(box->left),
						static_cast<float>(box->top),
						static_cast<float>(box->left + box->right),
						static_cast<float>(box->top + box->bottom) };
					D2D1_RECT_F d2bmpbox = {
						0.0f, 0.0f,
						static_cast<float>(bmpsize.width),
						static_cast<float>(bmpsize.height) };

					DxDraw->HwndRenderTarget->DrawBitmap(d2bmp, d2box , 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR, d2bmpbox );
					if ( IsTrue(destroy) ) d2bmp->Release();
				}
				wicConverter->Release();
				wicbmp->Release();
			}
		}else{
			DxGDIDrawIcon(DxDraw, icon, box, cache);
		}
	// LbVgp悤Ǝ݂
	}else if ( DxDraw->WicFactory != NULL ){
		ID2D1Bitmap *d2bmp;

		d2bmp = DxDraw->bmpCache[(*cache)->cacheIndex];
		// LbVpH
		if ( ((*cache)->HwndRenderTargetCounter != DxDraw->HwndRenderTargetCounter) || (d2bmp == NULL) ){
			DxDrawFreeBMPCache(cache);
			DxDrawIcon(DxDraw, icon, box, cache);
			return;
		}
		// LbVgp
		D2D1_RECT_F d2box = {
			static_cast<float>(box->left),
			static_cast<float>(box->top),
			static_cast<float>(box->left + box->right),
			static_cast<float>(box->top + box->bottom) };
		D2D1_RECT_F d2bmpbox = {
			0.0f, 0.0f,
			static_cast<float>((*cache)->bmpsize.width),
			static_cast<float>((*cache)->bmpsize.height) };

		DxDraw->HwndRenderTarget->DrawBitmap(d2bmp, d2box , 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR, d2bmpbox );
	}else{ // GDI擾(㉺])
		DxDrawDIB(DxDraw, NULL, NULL, box, NULL, cache);
	}
}

void DxDrawFreeBMPCache(DXBMPCACHE **cache)
{
	if ( (cache == NULL) || (*cache == NULL) ) return;

	DXDRAWSTRUCT *DxDraw = (*cache)->DxDraw;
	ID2D1Bitmap **d2bmp = &DxDraw->bmpCache[(*cache)->cacheIndex];

	if ( ((*cache)->HwndRenderTargetCounter == DxDraw->HwndRenderTargetCounter) && (*d2bmp != NULL) ){
		(*d2bmp)->Release();
		(*d2bmp) = NULL;
	}
	delete *cache;
	*cache = NULL;
}

void ResetDxDrawAtlas(DXDRAWSTRUCT *DxDraw)
{
	if ( (DxDraw == NULL) || (DxDraw->BmpAtlas.bmp == NULL) ) return;

	DxDraw->BmpAtlas.bmp->Release();
	DxDraw->BmpAtlas.bmp = NULL;
}

BOOL DxDrawAtlas_Check(DXDRAWSTRUCT *DxDraw, DWORD *CacheID)
{
	DWORD id;

	if ( DxDraw == NULL ) return FALSE;
	if ( DxDraw->BmpAtlas.bmp == NULL ){
		*CacheID = DxDraw->BmpAtlas.IndexNow++;
		DxDraw->BmpAtlas.useIndex = *CacheID; // ̒l
		return FALSE;
	}

	if ( *CacheID != 0 ){ // CacheID LmF
		id = *CacheID - DxDraw->BmpAtlas.IndexMin;
		if ( id < DxDraw->BmpAtlas.AtlasItems ){ // ?
			DxDraw->BmpAtlas.useIndex = (*CacheID - 1) % DxDraw->BmpAtlas.AtlasItems;
			return TRUE;
		}
	}

	// CacheID VK
	//  *CacheID = 0 ̂Ƃ邪AɖɂȂ邽ߖȂ
	*CacheID = DxDraw->BmpAtlas.IndexNow++;
	DxDraw->BmpAtlas.useIndex = (*CacheID - 1) % DxDraw->BmpAtlas.AtlasItems;
	if ( (DxDraw->BmpAtlas.IndexNow - DxDraw->BmpAtlas.IndexMin) >=
			DxDraw->BmpAtlas.AtlasItems ){
		DxDraw->BmpAtlas.IndexMin++;
	}
	return FALSE;
}

void DxDrawAtlas(DXDRAWSTRUCT *DxDraw, BITMAPINFOHEADER *bmiHeader, LPVOID lpBits, const RECT *box)
{
	if ( DxDraw == NULL ) return;
	// ۑp bitmap p
	if ( (DxDraw->BmpAtlas.bmp == NULL) &&
		 (bmiHeader->biWidth <= DEFATLASSIZE) &&
		 (bmiHeader->biHeight <= DEFATLASSIZE) ){
		D2D1_SIZE_U atlassize = { DEFATLASSIZE, DEFATLASSIZE };
		D2D1_BITMAP_PROPERTIES bmpprop;

		bmpprop.dpiX = DxDraw->DeskScale.x;
		bmpprop.dpiY = DxDraw->DeskScale.y;
		bmpprop.pixelFormat = D2D1::PixelFormat(
				DXGI_FORMAT_B8G8R8A8_UNORM,
				D2D1_ALPHA_MODE_PREMULTIPLIED);

		if ( SUCCEEDED(DxDraw->HwndRenderTarget->CreateBitmap(atlassize, bmpprop, &DxDraw->BmpAtlas.bmp)) ){
			DxDraw->BmpAtlas.AtlasCols = (DEFATLASSIZE / bmiHeader->biWidth);
			DxDraw->BmpAtlas.AtlasItems =
					DxDraw->BmpAtlas.AtlasCols *
					(DEFATLASSIZE / bmiHeader->biHeight);
			DxDraw->BmpAtlas.ItemSize.cx = bmiHeader->biWidth;
			DxDraw->BmpAtlas.ItemSize.cy = bmiHeader->biHeight;

			DxDraw->BmpAtlas.IndexMin = DxDraw->BmpAtlas.IndexNow - 1;
			DxDraw->BmpAtlas.useIndex = (DxDraw->BmpAtlas.useIndex - 1) % DxDraw->BmpAtlas.AtlasItems; // ̒l琶
		}
	}
	D2D1_RECT_F d2bmpbox;
	D2D1_RECT_F d2box = {
			static_cast<float>(box->left),
			static_cast<float>(box->top),
			static_cast<float>(box->left + box->right),
			static_cast<float>(box->top + box->bottom) };

	if ( DxDraw->BmpAtlas.bmp != NULL ){
		if ( bmiHeader == NULL ){ // YLBLbV`
			d2bmpbox.left = static_cast<float>( (DxDraw->BmpAtlas.useIndex % DxDraw->BmpAtlas.AtlasCols) * DxDraw->BmpAtlas.ItemSize.cx ) * DxDraw->DeskScaleRate.x;
			d2bmpbox.top  = static_cast<float>( (DxDraw->BmpAtlas.useIndex / DxDraw->BmpAtlas.AtlasCols) * DxDraw->BmpAtlas.ItemSize.cy ) * DxDraw->DeskScaleRate.y;
			d2bmpbox.right  = d2bmpbox.left + static_cast<float>(DxDraw->BmpAtlas.ItemSize.cx) * DxDraw->DeskScaleRate.x;
			d2bmpbox.bottom = d2bmpbox.top  + static_cast<float>(DxDraw->BmpAtlas.ItemSize.cy) * DxDraw->DeskScaleRate.y;
		}else{ // LbVƂĕۑ`
			D2D1_RECT_U destbox;

			destbox.left = (DxDraw->BmpAtlas.useIndex % DxDraw->BmpAtlas.AtlasCols) * bmiHeader->biWidth;
			destbox.top  = (DxDraw->BmpAtlas.useIndex / DxDraw->BmpAtlas.AtlasCols) * bmiHeader->biHeight;
			destbox.right  = destbox.left + bmiHeader->biWidth;
			destbox.bottom = destbox.top + bmiHeader->biHeight;
			DxDraw->BmpAtlas.bmp->CopyFromMemory(&destbox, lpBits, bmiHeader->biWidth * sizeof(DWORD));

			d2bmpbox.left = static_cast<float>(destbox.left) * DxDraw->DeskScaleRate.x;
			d2bmpbox.top  = static_cast<float>(destbox.top) * DxDraw->DeskScaleRate.x;
			d2bmpbox.right  = static_cast<float>(destbox.right) * DxDraw->DeskScaleRate.x;
			d2bmpbox.bottom = static_cast<float>(destbox.bottom) * DxDraw->DeskScaleRate.x;
		}
		DxDraw->HwndRenderTarget->DrawBitmap(DxDraw->BmpAtlas.bmp, d2box , 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR, d2bmpbox );
		return;
	}else{ // LbVłȂ̂ŕ`݂̂
		ID2D1Bitmap *d2bmp;
		D2D1_SIZE_U bmpsize;
		D2D1_BITMAP_PROPERTIES bmpprop;

		bmpprop.dpiX = DxDraw->DeskScale.x;
		bmpprop.dpiY = DxDraw->DeskScale.y;
		bmpprop.pixelFormat = D2D1::PixelFormat(
				DXGI_FORMAT_B8G8R8A8_UNORM,
				D2D1_ALPHA_MODE_PREMULTIPLIED);
		bmpsize.width = bmiHeader->biWidth;
		bmpsize.height = bmiHeader->biHeight;

		if ( SUCCEEDED(DxDraw->HwndRenderTarget->CreateBitmap(bmpsize, lpBits, bmiHeader->biWidth * 4/* Alignmentς*/ , bmpprop, &d2bmp)) ){
			d2bmpbox.left = 0.0f;
			d2bmpbox.top  = 0.0f;
			d2bmpbox.right  = static_cast<float>(bmpsize.width);
			d2bmpbox.bottom = static_cast<float>(bmpsize.height);

			DxDraw->HwndRenderTarget->DrawBitmap(d2bmp, d2box, 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR, d2bmpbox);
			d2bmp->Release();
		}
	}
}

#endif
// DirectX 9  ---------------------------------------------------------------
#if DRAWMODE == DRAWMODE_3D
#include <d3d9.h>
#include <d3dx9.h>

#define USEDXTEXT 0

#define TEXSIZE 1024
#define FONTSIZEH 48
#define ROTATE180 D3DX_PI
#define ROTATE90	(D3DX_PI / 2.0f)
#define D3D_ProjScaleX (1.0f/4096.0f) // k(X)
#define D3D_ProjScaleY (-D3D_ProjScaleX) // k(Y)
#define D3D_CameraZrate -3.732050808f // -tan(M_PI - (M_PI / 6) / 2)

#define MAG2D 0.001822f
#define OF2D  0.134144f
float fixd = 0;

// ZW
#define ZPOS_MESH			0.02f	// 
#define ZPOS_CURSOR_FG		0.0005f	// J[\(O)
#define ZPOS_CURSOR_BACK	0.0001f	// J[\(w)
#define ZPOS_TEXT			0.0f	// ʂ̕

// J[\Of[V
#define CURSOR_G1_COLOR 0xc0c0c0
#define CURSOR_G2_COLOR 0x0
// J[\x
#define CURSOR_ALPHA 0x70000000

#ifndef SAFE_DELETE
#define SAFE_DELETE(val) { if (val){ delete val; val = NULL; }}
#endif
#ifndef SAFE_DELETE_ARRAY
#define SAFE_DELETE_ARRAY(tbl) { if (tbl){ delete[] tbl; tbl = NULL; }}
#endif
#ifndef SAFE_RELEASE
#define SAFE_RELEASE(ifptr) { if (ifptr){ ifptr->Release(); ifptr = NULL; }}
#endif

struct ScreenInfo {
	HWND hWnd;
	LPDIRECT3DDEVICE9 D3DDev;
	float ClientWidth, ClientHeight;
	int ClientWidthInt, ClientHeightInt;
	int fontH;
	COLORREF backgroundcolor;
	COLORREF TextColor, TextBackColor;
	IDirect3DVertexBuffer9 *PanelVertex;
	POINT lastpos;
	int BkMode;
};

D3DPRESENT_PARAMETERS defaultd3dpp = {0, 0, D3DFMT_UNKNOWN, 0,
		D3DMULTISAMPLE_NONE, 0,
		D3DSWAPEFFECT_DISCARD /*D3DSWAPEFFECT_FLIP*/,
		NULL, TRUE, TRUE, D3DFMT_D16, 0, 0, D3DPRESENT_INTERVAL_DEFAULT};

#define FVF_DEFFVF ( D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1 )
struct VEX_DEFFVF {
	float x, y, z; // _W
	D3DCOLOR color;
	float u, v; //@eNX`W
};

#define VFS_DEFPANEL 4
const VEX_DEFFVF vf_defpanel[VFS_DEFPANEL]= {
	{  1.0f,  0.0f, 0.0f, D3DCOLOR_RGBA(255, 255, 255, 255), 1.0f, 0.0f},
	{  1.0f,  1.0f, 0.0f, D3DCOLOR_RGBA(255, 255, 255, 255), 1.0f, 1.0f},
	{  0.0f,  0.0f, 0.0f, D3DCOLOR_RGBA(255, 255, 255, 255), 0.0f, 0.0f},
	{  0.0f,  1.0f, 0.0f, D3DCOLOR_RGBA(255, 255, 255, 255), 0.0f, 1.0f}
};

const D3DMATRIX IdentityMatrix = { // Pʍs
	{1.0f, 0.0f, 0.0f, 0.0f,
	 0.0f, 1.0f, 0.0f, 0.0f,
	 0.0f, 0.0f, 1.0f, 0.0f,
	 0.0f, 0.0f, 0.0f, 1.0f}
};

/* WvWFNgs
	#define D3D_Angle 0.523598667f // (M_PI / 6) = 30
	#include <stdlib.h>
	char a[300];

	D3DXMatrixPerspectiveFovLH(&matProj, D3D_Angle, 1.0f, 0.01f, 100.0f);
	sprintf(a, "%f %f %f %f / %f %f %f %f / %f %f %f %f / %f %f %f %f",
	matProj._11, matProj._12, matProj._13, matProj._14,
	matProj._21, matProj._22, matProj._23, matProj._24,
	matProj._31, matProj._32, matProj._33, matProj._34,
	matProj._41, matProj._42, matProj._43, matProj._44);
	XMessage(NULL, NULL, XM_DbgLOG, T("%s"), a);
*/
const D3DMATRIX DefProjMatrix = {
	{3.732051618f, 0.0f, 0.0f, 0.0f,
	 0.0f, 3.732051618f, 0.0f, 0.0f,
	 0.0f, 0.0f, 1.0001f, 1.0f,
	 0.0f, 0.0f, -0.010001f, 0.0f}
};

// 傫ƕsړ 2D Őݒ肷(]s)
#define SetMatrix2D_ST(mat, x, y, w, h) { mat._11 = w ; mat._22 = h ; mat._41 = x ;mat._42 = y; }

#define DEBUGMESSIZE 3000
TCHAR g_DebugMes[DEBUGMESSIZE];

#define usefloatlog 0
#if usefloatlog
void PutLog(const TCHAR *string, int, ...)
{
	t_va_list argptr;
	size_t len;

	len = tstrlen(g_DebugMes);
	if ( (len + (DEBUGMESSIZE / 10)) >= DEBUGMESSIZE ) return;
	t_va_start(argptr, string);
#ifdef UNICODE
	vswprintf(g_DebugMes + len, string, argptr);
#else
	vsprintf(g_DebugMes + len, string, argptr);
#endif
	t_va_end(argptr);
	tstrcat(g_DebugMes + len, T("\n"));
}
#else
#define PutLog thprintf
#endif

#define DDCI_ReturnLog(result, mes) {Release(); PutLog(mes, DEBUGMESSIZE); return result;}

void DrawDIB(ScreenInfo *sinfo, BITMAPINFOHEADER *bmiHeader, LPVOID lpBits, const RECT *box);
void DrawTex(ScreenInfo *sinfo, IDirect3DTexture9 *Tex, int left, int top, int width, int height);

enum D3DDC_STATE { D3DDC_DRAWING, D3DDC_ENABLE, D3DDC_REQDISABLE, D3DDC_DISABLE, D3DDC_INIT};

class D3DDeviceClass
{
private:
	ScreenInfo *m_sinfo;
	IDirect3D9 *m_D3D;
	D3DPRESENT_PARAMETERS m_d3dpp;
	D3DCOLOR m_BackColor;
#if USEDXTEXT
	ID3DXFont *MesFont;
#endif
	D3DDC_STATE m_State;
	DWORD m_ThreadID; //  D3DDeviceClass ғĂ Window  Thread

public:
	D3DDeviceClass()
	{
		m_D3D = NULL;
		m_State = D3DDC_INIT;
#if USEDXTEXT
		MesFont = NULL;
#endif
	}

	~D3DDeviceClass()
	{
		Release();
	}

	D3DXMATRIX MatView3D, MatView2D;

	BOOL Init(ScreenInfo *sinfo)
	{
		D3DDISPLAYMODE dmode;
		IDirect3DDevice9 *D3DDev;

		m_sinfo = sinfo;
		m_ThreadID = GetWindowThreadProcessId(m_sinfo->hWnd, NULL);
		m_sinfo->D3DDev = NULL;
		if ( m_ThreadID != GetCurrentThreadId() ){
		//	Message(T("D3DDevice->Init thread error!"));
			return FALSE;
		}

		// CoInitializeEx(NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE);
		m_D3D = Direct3DCreate9(D3D_SDK_VERSION);
		if ( m_D3D == NULL ){
			Release();
		//	Message(T("D3DDevice->Init Create9 error!"));
			return FALSE;
		}

		m_D3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &dmode);

		m_d3dpp = defaultd3dpp;
		m_d3dpp.hDeviceWindow = sinfo->hWnd;
		m_d3dpp.BackBufferFormat = dmode.Format;
		if ( FAILED(m_D3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL,
				sinfo->hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING,
				&m_d3dpp, &D3DDev)) ){
			if ( FAILED(m_D3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL,
					sinfo->hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING,
					&m_d3dpp, &D3DDev)) ){
				DDCI_ReturnLog(FALSE, T("CreateDevice error"));
			}
		}
		m_sinfo->D3DDev = D3DDev;
		m_BackColor = 0x00FFFFFF;

		// ėp_obt@쐬
		if ( FAILED(m_sinfo->D3DDev->CreateVertexBuffer(
				sizeof(VEX_DEFFVF) * VFS_DEFPANEL, D3DUSAGE_WRITEONLY,
				FVF_DEFFVF, D3DPOOL_MANAGED, &m_sinfo->PanelVertex, NULL))){
			return FALSE;
		}else{ // _̏
			void *pData;

			if ( FAILED(m_sinfo->PanelVertex->Lock(0,
					sizeof(VEX_DEFFVF) * VFS_DEFPANEL, (void**)&pData, 0)) ){
				return FALSE;
			}
			memcpy(pData, vf_defpanel, sizeof(vf_defpanel));
			m_sinfo->PanelVertex->Unlock();
		}
		InitDevice();
		return TRUE;
	}

	BOOL InitDevice(void)
	{
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		if ( m_ThreadID != GetCurrentThreadId() ){
		//	Message(T("D3DDevice->InitDevice thread error!"));
			return FALSE;
		}
#if USEDXTEXT
		if ( FAILED(D3DXCreateFontW(D3DDev, 10, 0, FW_BOLD, 0, FALSE,
				DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY,
				DEFAULT_PITCH | FF_DONTCARE, L"lr ", &MesFont)) ){
			DDCI_ReturnLog(FALSE, T("D3DXCreateFont error"));
		}
#endif
		D3DDev->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
		D3DDev->SetRenderState(D3DRS_ZENABLE, TRUE);

		D3DDev->SetRenderState(D3DRS_LIGHTING, FALSE);
		// AlphaBlend
		D3DDev->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
		D3DDev->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
		D3DDev->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

		D3DDev->SetRenderState(D3DRS_AMBIENT, 0x101010);

		D3DDev->SetRenderState(D3DRS_DITHERENABLE, TRUE);
//		D3DDev->SetRenderState(D3DRS_NORMALIZENORMALS, TRUE);

//		D3DDev->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_POINT);
//		D3DDev->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_POINT);
		D3DDev->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
		D3DDev->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);

		//	Z̕猴_
		float Aspect = (m_sinfo->ClientHeight / m_sinfo->ClientWidth);
		float CameraX = (m_sinfo->ClientWidth + 0.0f) * (D3D_ProjScaleX * 0.5f);
		float CameraY = (m_sinfo->ClientHeight + 0.0f) * (D3D_ProjScaleY * 0.5f);
		float CameraZ = D3D_CameraZrate * CameraX * Aspect;

		D3DXVECTOR3 vec3From(CameraX, CameraY, CameraZ);
		D3DXVECTOR3 vec3At(CameraX, CameraY, CameraZ + 1.0f);
		D3DXVECTOR3 vec3Up(0.0f, 1.0f, 0.0f);
		D3DXMatrixLookAtLH(&MatView3D, &vec3From, &vec3At, &vec3Up);

		D3DXMatrixOrthoLH(&MatView2D,
				MAG2D * m_sinfo->ClientHeight, MAG2D * m_sinfo->ClientHeight,
				-1.0f, 1.0f);
		D3DXMATRIX matD = IdentityMatrix;
		matD = IdentityMatrix;
		matD._41 -= OF2D / Aspect;
		matD._42 += OF2D;
		D3DXMatrixMultiply(&MatView2D, &MatView2D, &matD);

		D3DDev->SetTransform(D3DTS_VIEW, &MatView2D);

		//vWFNV
#if 1
		D3DMATRIX matProj = DefProjMatrix;

		matProj._11 *= m_sinfo->ClientHeight / m_sinfo->ClientWidth;
		D3DDev->SetTransform(D3DTS_PROJECTION, &matProj);
#else // 
		#define D3D_Angle 0.523598667f // (M_PI / 6) = 30
		D3DXMATRIX matProj;
		D3DXMatrixPerspectiveFovLH(&matProj, D3D_Angle,
				m_sinfo->ClientWidth / m_sinfo->ClientHeight,
				0.01f, 100.0f);
		D3DDev->SetTransform(D3DTS_PROJECTION, &matProj);
#endif
		m_State = D3DDC_ENABLE;
		return TRUE;
	}

	void SetBackColor(COLORREF backcolor)
	{
		m_BackColor = D3DCOLORfromCOLORREF(backcolor);
	}

	BOOL SetBenchmarkMode(BOOL mode)
	{
		DWORD newmode;

		newmode = mode ?
				D3DPRESENT_INTERVAL_IMMEDIATE : D3DPRESENT_INTERVAL_DEFAULT;
		if ( m_d3dpp.PresentationInterval != newmode ){
			m_d3dpp.PresentationInterval = newmode;
			return TRUE;
		}else{
			return FALSE;
		}
	}

	void Release(void)
	{
		if ( m_ThreadID != GetCurrentThreadId() ){
		//	Message(T("D3DDevice->Release thread error!"));
		}
#if USEDXTEXT
		SAFE_RELEASE(MesFont);
#endif
		SAFE_RELEASE(m_sinfo->PanelVertex);
		SAFE_RELEASE(m_sinfo->D3DDev);
		SAFE_RELEASE(m_D3D);
		// CoUninitialize();
	}

	void DrawIcon(HICON icon, const RECT *box)
	{
		LPVOID lpBits;
		BITMAPINFO bmi;
		BITMAPINFOHEADER bmiHeader;
		HBITMAP hbmp;
		HGDIOBJ hOldBmp;
		HDC hDC;

		memset(&bmiHeader, 0, sizeof(BITMAPINFOHEADER));
		bmiHeader.biSize      = sizeof(BITMAPINFOHEADER);
		bmiHeader.biWidth     = 32;
		bmiHeader.biHeight    = 32;
		bmiHeader.biPlanes    = 1;
		bmiHeader.biBitCount  = 32;
		bmi.bmiHeader = bmiHeader;
		hbmp = CreateDIBSection(NULL, (LPBITMAPINFO)&bmi, DIB_RGB_COLORS, &lpBits, NULL, 0);
		hDC = CreateCompatibleDC(NULL);
		hOldBmp = SelectObject(hDC, hbmp);
		DrawIconEx(hDC, 0, 0, icon, bmiHeader.biWidth, bmiHeader.biHeight, 0, NULL, DI_NORMAL);
		SelectObject(hDC, hOldBmp);
		DeleteDC(hDC);

		DrawDIB(m_sinfo, &bmiHeader, lpBits, box);

		DeleteObject(hbmp); // rbg}bṽ폜
	}

	BOOL BeginRender(void)
	{
		if ( m_State != D3DDC_ENABLE ) return FALSE;

		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		D3DDev->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER /*| D3DCLEAR_STENCIL*/, m_BackColor, 1.0f, 0);
		D3DDev->BeginScene();
		m_State = D3DDC_DRAWING;
		return TRUE;
	}

	BOOL EndRender(void)
	{
		if ( m_State != D3DDC_DRAWING ) return FALSE;
		m_State = D3DDC_ENABLE;

		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		D3DDev->EndScene();
		if ( D3DDev->Present(NULL, NULL, NULL, NULL) == D3DERR_DEVICELOST ){
			RequestReset();
			return FALSE;
		}
		return TRUE;
	}

	void RequestReset(void)
	{
		if ( m_State == D3DDC_ENABLE ) m_State = D3DDC_REQDISABLE;
	}

	BOOL DeviceCheck(void)
	{
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		if ( m_State == D3DDC_INIT ) return FALSE;
		if ( D3D_OK == D3DDev->TestCooperativeLevel() ){
			return TRUE;
		}
		return FALSE;
	}

	BOOL ResetDevice(void)
	{
		D3DDISPLAYMODE dmode;
		HRESULT hr;

		if ( m_ThreadID != GetCurrentThreadId() ){
		//	Message(T("D3DDevice->Reset thread error!"));
			return FALSE;
		}
		if ( m_State != D3DDC_DISABLE ){
			if ( m_State == D3DDC_INIT ) return FALSE;
			if ( m_State == D3DDC_ENABLE ){
#if USEDXTEXT
				SAFE_RELEASE(MesFont);
#endif
			}
			m_State = D3DDC_DISABLE;
		}
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		hr = D3DDev->TestCooperativeLevel();
		if ( (hr == D3DERR_DEVICELOST) || (hr == D3DERR_DRIVERINTERNALERROR ) ){
			return FALSE; // ܂ZbgłȂ
		}

		m_D3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &dmode);
		m_d3dpp.BackBufferWidth = 0;
		m_d3dpp.BackBufferHeight = 0;
		m_d3dpp.BackBufferFormat = dmode.Format;
		if ( D3DDev->Reset(&m_d3dpp) != D3D_OK ){
//			MessageA("Display Reset error");
			return FALSE;
		}else{
			InitDevice();
			return TRUE;
		}
	}
#if USEDXTEXT
	void DrawText(const TCHAR *str, RECT *box)
	{
		if ( box == NULL ){
			RECT dummybox = {0, 0, 800, 80};

			box = &dummybox;
		}
		if ( MesFont != NULL ){
			MesFont->DrawText(NULL, str, -1, box, DT_NOCLIP, D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f ));
		}
	}
#endif
};

struct FontInfoStruct {
	WORD dataX, dataY; // f[^̈ʒu
	WORD Xoffset; // \ʒuX
	WORD showW; // \
	WORD cellW; // ̕
};

const MAT2 GetFontBmpMat = {{0, 1}, {0, 0}, {0, 0}, {0, 1}};

class DxCellCursorClass
{
private:
	ScreenInfo *m_sinfo;
	D3DMATRIX m_ShowPosMat; // \ʒu߂s
	D3DMATRIX m_ShowBackPosMat; // \ʒu߂s
	IDirect3DTexture9 *m_Tex;
	int m_boxwidth, m_boxheight;

	void MakeTex(void)
	{
		LPVOID lpBits;
		BITMAPINFO bmi;
		BITMAPINFOHEADER bmiHeader;
		HBITMAP hbmp;
		HGDIOBJ hOldBmp;
		HDC hDC;
		TRIVERTEX vt[2];

		SAFE_RELEASE(m_Tex);
		memset(&bmiHeader, 0, sizeof(BITMAPINFOHEADER));
		bmiHeader.biSize      = sizeof(BITMAPINFOHEADER);
		bmiHeader.biWidth     = m_boxwidth;
		bmiHeader.biHeight    = m_boxheight;
		bmiHeader.biPlanes    = 1;
		bmiHeader.biBitCount  = 32;
		bmi.bmiHeader = bmiHeader;
		hbmp = CreateDIBSection(NULL, &bmi, DIB_RGB_COLORS, &lpBits, NULL, 0);
		hDC = CreateCompatibleDC(NULL);
		hOldBmp = SelectObject(hDC, hbmp);

		COLORREF c1 = CURSOR_G1_COLOR;
		COLORREF c2 = CURSOR_G2_COLOR;
		vt[0].x = 0;
		vt[0].y = 0;
		vt[0].Red = (COLOR16)(GetRValue(c1) * 0x100);
		vt[0].Green = (COLOR16)(GetGValue(c1) * 0x100);
		vt[0].Blue = (COLOR16)(GetBValue(c1) * 0x100);
		vt[0].Alpha = 0xffff;
		vt[1].x = bmiHeader.biWidth;
		vt[1].y = bmiHeader.biHeight;
		vt[1].Red = (COLOR16)(GetRValue(c2) * 0x100);
		vt[1].Green = (COLOR16)(GetGValue(c2) * 0x100);
		vt[1].Blue = (COLOR16)(GetBValue(c2) * 0x100);
		vt[1].Alpha = 0xffff;

		GRADIENT_RECT gr;
		gr.UpperLeft = 1;
		gr.LowerRight = 0;

		GradientFill(hDC, vt, 2, &gr, 1, GRADIENT_FILL_RECT_V);

		HGDIOBJ hOldPen = SelectObject(hDC, GetStockObject(WHITE_PEN));
		HGDIOBJ hOldBrush = SelectObject(hDC, GetStockObject(HOLLOW_BRUSH));

		RoundRect(hDC, 0, 0, bmiHeader.biWidth, bmiHeader.biHeight, bmiHeader.biHeight / 3, bmiHeader.biHeight / 3);

		SelectObject(hDC, hOldBrush);
		SelectObject(hDC, hOldPen);

		SelectObject(hDC, hOldBmp);
		DeleteDC(hDC);

		D3DLOCKED_RECT LockedRect;

		if ( SUCCEEDED(m_sinfo->D3DDev->CreateTexture(
				bmiHeader.biWidth, bmiHeader.biHeight, 1, D3DUSAGE_DYNAMIC,
				D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &m_Tex, NULL)) ){
			if ( SUCCEEDED(m_Tex->LockRect(0, &LockedRect, NULL, D3DLOCK_DISCARD)) ){
				DWORD blockW = bmiHeader.biWidth;

				for ( int y = bmiHeader.biHeight - 1 ; y >= 0 ; y-- ){
					const DWORD *src = (DWORD *)(BYTE *)lpBits + (bmiHeader.biHeight - 1 - y) * blockW;
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits + y * LockedRect.Pitch);
					for ( int x = 0 ; x < bmiHeader.biWidth ; x++ ){
						DWORD data = *src++;
						*dest++ = data | (data << 8);
					}
				}
				m_Tex->UnlockRect(0);
			}
		}
		DeleteObject(hbmp); // rbg}bṽ폜
	}

public:
	~DxCellCursorClass()
	{
		Free();
	}

	BOOL Init(ScreenInfo *sinfo)
	{
		m_sinfo = sinfo;
		m_Tex = NULL;
		m_boxwidth = -1;
		m_ShowPosMat = IdentityMatrix;
		m_ShowPosMat._43 = ZPOS_CURSOR_FG;
		m_ShowBackPosMat = IdentityMatrix;
		m_ShowBackPosMat._43 = ZPOS_CURSOR_BACK;
		return TRUE;
	}

	void Free(void)
	{
		SAFE_RELEASE(m_Tex);
	}

	int Draw(int x, int y, int width, int height, COLORREF color)
	{
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		if ( (m_Tex == NULL) || (width != m_boxwidth) || (height != m_boxheight) ){
			m_boxwidth = width;
			m_boxheight = height;
			MakeTex();
		}

		D3DDev->SetFVF(FVF_DEFFVF);
		D3DDev->SetTexture(0, m_Tex);
		D3DDev->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
		D3DDev->SetStreamSource(0, m_sinfo->PanelVertex, 0, sizeof(VEX_DEFFVF));

//		D3DDev->SetTextureStageState(0, D3DTSS_COLOROP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_COLOROP  , D3DTOP_MODULATE);
		D3DDev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
		D3DDev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_TFACTOR);

		D3DDev->SetRenderState(D3DRS_TEXTUREFACTOR, D3DCOLORfromCOLORREF(color));

		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAOP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

		SetMatrix2D_ST(m_ShowPosMat,
				(float)x * D3D_ProjScaleX,		(float)y * D3D_ProjScaleY,
				(float)width * D3D_ProjScaleX,	(float)height * D3D_ProjScaleY
		);
		D3DDev->SetTransform(D3DTS_WORLD, &m_ShowPosMat);

		D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
		return TRUE;
	}

	int DrawBack(int x, int y, int width, int height, COLORREF color)
	{
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		D3DDev->SetFVF(FVF_DEFFVF);

		D3DDev->SetStreamSource(0, m_sinfo->PanelVertex, 0, sizeof(VEX_DEFFVF));

		D3DDev->SetTextureStageState(0, D3DTSS_COLOROP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TFACTOR);
		D3DDev->SetRenderState(D3DRS_TEXTUREFACTOR, D3DCOLORfromCOLORREF(color) | CURSOR_ALPHA);

		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAOP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TFACTOR);

		SetMatrix2D_ST(m_ShowBackPosMat,
				(float)x * D3D_ProjScaleX,		(float)y * D3D_ProjScaleY,
				(float)width * D3D_ProjScaleX,	(float)height * D3D_ProjScaleY
		);
		D3DDev->SetTransform(D3DTS_WORLD, &m_ShowBackPosMat);

		D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
		return TRUE;
	}
};

#ifdef UNICODE
	#define GetCodeAndNext(text, max) *text++
#else
	#define GetCodeAndNext(text, max) GetCodeAndNextMain(&text, max)
	WORD USEFASTCALL GetCodeAndNextMain(const char **text, const char *max)
	{
		WORD code;

		code = (WORD)*(BYTE *)(*text)++;
		if ( Iskanji(code) && (*text < max) ){
			return (code << 8) | (WORD)*(BYTE *)(*text)++;
		}else{
			return code;
		}
	}
#endif

class DxTextClass
{
private:
	ScreenInfo *m_sinfo;
	IDirect3DTexture9 *m_Tex;
	D3DMATRIX m_TextureTransMat; // eNX`̕\͈͂߂s
	D3DMATRIX m_ShowPosMat; // \ʒu߂s
	D3DCOLOR m_textcolor;
	HFONT m_hFont;
	FontInfoStruct m_fontinfo[0x10000]; // ȅ index͕R[h
	struct {
		DWORD writeX, writeY; // ݈ʒu
		DWORD tmAveCharWidth, tmHeight;
		DWORD FixY; // rbg}bvނƂ̕␳l
	} m_make;
	DWORD m_omsize; // ȗ\

public:
	~DxTextClass()
	{
		Release();
	}

	BOOL Init(ScreenInfo *sinfo)
	{
		m_sinfo = sinfo;
		m_Tex = NULL;
		m_textcolor = 0xffffff;
		m_hFont = NULL;
		m_TextureTransMat = IdentityMatrix;
		m_ShowPosMat = IdentityMatrix;
		Free();
		return TRUE;
	}

	void Release(void)
	{
		SAFE_RELEASE(m_Tex);
	}

	void Free(void)
	{
		memset(m_fontinfo, 0, sizeof(m_fontinfo));
		SAFE_RELEASE(m_Tex);
	}

	void SetFontGlyph(WORD code, HDC hDC, D3DLOCKED_RECT LockedRect)
	{
		GLYPHMETRICS gm;
		BYTE fontbmp[FONTSIZEH * FONTSIZEH * 4];
		UINT mode = GGO_BITMAP;
//		UINT mode = GGO_GRAY8_BITMAP;

		if ( (GetGlyphOutline(hDC, code, mode, &gm, sizeof(fontbmp),
				&fontbmp, &GetFontBmpMat) == 0) || (gm.gmBlackBoxX == 0) ){
			gm.gmBlackBoxX = 0;
			gm.gmCellIncX = (WORD)m_make.tmAveCharWidth;
		}else{
			if ( (m_make.writeX + gm.gmBlackBoxX + 1) > TEXSIZE ){
				m_make.writeX = 1;
				if ( (m_make.writeY + m_make.tmHeight * 2) < TEXSIZE ){
					m_make.writeY += m_make.tmHeight;
				}
			}
			DWORD writeY = m_make.FixY - gm.gmptGlyphOrigin.y + m_make.writeY;

			if ( mode == GGO_GRAY8_BITMAP ){
				DWORD blockW = DwordAlignment(gm.gmBlackBoxX);
				for ( int y = gm.gmBlackBoxY ; y >= 0 ; y-- ){
					const BYTE *src = fontbmp + y * blockW;
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits +
							(writeY + y) * LockedRect.Pitch) + m_make.writeX;
					for ( UINT x = 0 ; x < gm.gmBlackBoxX ; x++ ){
						*dest++ = 0xffffff | (*src++ * (0xff000000 / 64));
					}
				}
			}else{
				DWORD blockW = DwordAlignment((gm.gmBlackBoxX + 7) / 8);
				for ( int y = gm.gmBlackBoxY ; y >= 0 ; y-- ){
					const BYTE *src = fontbmp + y * blockW;
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits +
							(writeY + y) * LockedRect.Pitch) + m_make.writeX;
					for ( int x = gm.gmBlackBoxX ; x >= 0 ; ){
						BYTE data = *src++;
						for ( UINT b = 0 ; b < 8 ; b++ ){
							*dest++ = (data & B7) ? 0xffffffff : 0;
							x--;
							if ( x < 0 ) break;
							data <<= 1;
						}
					}
				}
			}
		}
		m_fontinfo[code].dataX = (WORD)m_make.writeX;
		m_fontinfo[code].dataY = (WORD)m_make.writeY;
		m_fontinfo[code].Xoffset = (WORD)gm.gmptGlyphOrigin.x;
		m_fontinfo[code].showW = (WORD)gm.gmBlackBoxX;
		m_fontinfo[code].cellW = (WORD)gm.gmCellIncX;
//		XMessage(NULL, NULL, XM_DbgLOG, T("Code:%x (%d,%d) %d %d"), code, m_make.writeX, m_make.writeY, gm.gmBlackBoxX, gm.gmCellIncX);
		m_make.writeX += gm.gmBlackBoxX + 1; // אڂƃA`GCAXɂăS~̂ŌԂ󂯂
	}

	void MakeGlyph(const TCHAR *text, const TCHAR *max)
	{
		D3DLOCKED_RECT LockedRect;
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;
		WORD code;
		HDC hDC;
		HGDIOBJ hOldFont;

		if ( m_Tex == NULL ){ // eNX`쐬E
			TEXTMETRIC tm;
//A4R4G4B4
			if ( FAILED(D3DDev->CreateTexture(TEXSIZE, TEXSIZE, 1,
					D3DUSAGE_DYNAMIC, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT,
					&m_Tex, NULL)) ){
				m_Tex = NULL;
				return;
			}
			if ( FAILED(m_Tex->LockRect(0, &LockedRect, NULL, D3DLOCK_DISCARD)) ){
				return;
			}
			memset((BYTE *)LockedRect.pBits, 0, TEXSIZE * TEXSIZE * sizeof(DWORD));
			hDC = GetDC(m_sinfo->hWnd);
			hOldFont = SelectObject(hDC, m_hFont);

			GetAndFixTextMetrics(hDC, &tm);

			m_TextureTransMat._22 = (float)tm.tmHeight * (1.0f / (float)TEXSIZE); // height

			m_make.writeX = 1;
			m_make.writeY = 0;
			m_make.tmAveCharWidth = tm.tmAveCharWidth;
			m_make.tmHeight = tm.tmHeight;
			m_make.FixY = tm.tmAscent;

			for ( WORD code = 0 ; code <= 32 ; code++ ){ // R[hE
				m_fontinfo[code].dataX = 1;
				m_fontinfo[code].cellW = (WORD)tm.tmAveCharWidth;
			}

			for ( WORD code = 33 ; code < 127 ; code++ ){ // ASCII
				SetFontGlyph(code, hDC, LockedRect);
			}

			m_omsize = min((m_fontinfo['.'].showW + 1) * 3, tm.tmAveCharWidth);
		}else{
			// D3DLOCK_DISCARD Ǝs邱Ƃc
			if ( FAILED(m_Tex->LockRect(0, &LockedRect, NULL, 0)) ){
				return;
			}
			hDC = GetDC(m_sinfo->hWnd);
			hOldFont = SelectObject(hDC, m_hFont);
		}

		while ( text < max ){ // 쐬̕Cɍ쐬
			code = GetCodeAndNext(text, max);
			if ( m_fontinfo[code].dataX != 0 ) continue;
			SetFontGlyph(code, hDC, LockedRect);
		}
		SelectObject(hDC, hOldFont);
		ReleaseDC(m_sinfo->hWnd, hDC);
		m_Tex->UnlockRect(0);
	}

	void SetFont(HFONT hFont)
	{
		if ( m_hFont != hFont ){
			Free();
			m_hFont = hFont;
		}
	}

	void SetTextColor(COLORREF newcolor)
	{
		if ( newcolor != m_textcolor ) m_textcolor = D3DCOLORfromCOLORREF(newcolor);
	}

	void DrawTest(void)
	{
		if ( m_Tex != NULL ) ::DrawTex(m_sinfo, m_Tex, 0, 0, TEXSIZE, TEXSIZE);
	}

	int Draw(const TCHAR *text, int x, int y, int maxX, int len)
	{
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		if ( m_Tex == NULL ){ // eNX`쐬
			if ( m_hFont == NULL ) return x;
			MakeGlyph(text, text + len);
			if ( m_Tex == NULL ) return x;
		}
		D3DDev->SetFVF(FVF_DEFFVF);
		D3DDev->SetTexture(0, m_Tex);
		D3DDev->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2);
		D3DDev->SetStreamSource(0, m_sinfo->PanelVertex, 0, sizeof(VEX_DEFFVF));

		D3DDev->SetTextureStageState(0, D3DTSS_COLOROP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TFACTOR);
		D3DDev->SetRenderState(D3DRS_TEXTUREFACTOR, m_textcolor);

		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAOP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

		m_ShowPosMat._22 = (float)m_sinfo->fontH * D3D_ProjScaleY * 0.88f; // height
		m_ShowPosMat._42 = (float)y * D3D_ProjScaleY; // Y

		const TCHAR *max = text + len;
		int FmaxX = maxX - m_omsize;
		while ( text < max ){
			WORD code;
			const TCHAR *oldtext;

//			XMessage(NULL, NULL, XM_DbgLOG, T(">%d %d %s"), x, y, text);
			oldtext = text;
			code = GetCodeAndNext(text, max);
//			if ( code == '\0' ) return x;
			if ( m_fontinfo[code].dataX == 0 ){
				MakeGlyph(oldtext, max);
			}
			// \͈͂͂ݏoƂ́Adot \
			if ( ((x + m_fontinfo[code].cellW) > FmaxX) &&
				  !((text == max) && ((x + m_fontinfo[code].cellW) <= maxX)) ){
				int showW;

				showW = m_fontinfo['.'].showW;
				m_ShowPosMat._11 = (float)showW * D3D_ProjScaleX; // width
				m_TextureTransMat._11 = (float)showW * (1.0f / (float)TEXSIZE); // width
				m_TextureTransMat._31 = (float)m_fontinfo['.'].dataX * (1.0f / (float)TEXSIZE); // delta X
				m_TextureTransMat._32 = (float)m_fontinfo['.'].dataY * (1.0f / (float)TEXSIZE); // delta Y
				D3DDev->SetTransform(D3DTS_TEXTURE0, &m_TextureTransMat);

				while ( (x + showW) <= maxX ){
					m_ShowPosMat._41 = (float)x * D3D_ProjScaleX; // X
					D3DDev->SetTransform(D3DTS_WORLD, &m_ShowPosMat);
					D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
					x += showW + 1;
				}
				break;
			}

#define EXXF (1.0f * D3D_ProjScaleX)
			if ( m_fontinfo[code].showW != 0 ){
				m_TextureTransMat._11 = (float)m_fontinfo[code].showW * (1.0f / (float)TEXSIZE); // width
				m_TextureTransMat._31 = (float)m_fontinfo[code].dataX * (1.0f / (float)TEXSIZE); // delta X
				m_TextureTransMat._32 = (float)m_fontinfo[code].dataY * (1.0f / (float)TEXSIZE); // delta Y
				D3DDev->SetTransform(D3DTS_TEXTURE0, &m_TextureTransMat);
		#if 1
				m_ShowPosMat._41 = (float)(x + m_fontinfo[code].Xoffset) * D3D_ProjScaleX; // X
				m_ShowPosMat._11 = (float)m_fontinfo[code].showW * D3D_ProjScaleX; // width
				D3DDev->SetTransform(D3DTS_WORLD, &m_ShowPosMat);
				D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
		#else // et\
				m_ShowPosMat._41 = (float)(x + m_fontinfo[code].Xoffset) * D3D_ProjScaleX + EXXF; // X
				m_ShowPosMat._11 = (float)m_fontinfo[code].showW * D3D_ProjScaleX; // width


				D3DDev->SetRenderState(D3DRS_TEXTUREFACTOR, 0xffffff);
				m_ShowPosMat._42 -= EXXF; // Y
				m_ShowPosMat._43 += ZPOS_TEXT; // Z
				D3DDev->SetTransform(D3DTS_WORLD, &m_ShowPosMat);
				D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);


				D3DDev->SetRenderState(D3DRS_TEXTUREFACTOR, m_textcolor);
				m_ShowPosMat._41 -= EXXF; // X
				m_ShowPosMat._42 += EXXF; // Y
//				m_ShowPosMat._43 -= ZPOS_TEXT; // Z

				D3DDev->SetTransform(D3DTS_WORLD, &m_ShowPosMat);
				D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
		#endif

			}
			x += m_fontinfo[code].cellW;
		}
		return x;
	}

	int Calc(const TCHAR *text, int maxX, int &len)
	{
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		if ( m_Tex == NULL ){ // eNX`쐬
			if ( m_hFont == NULL ) return 0;
			MakeGlyph(text, text + len);
			if ( m_Tex == NULL ) return 0;
		}
		const TCHAR *textptr = text;
		const TCHAR *textmax = text + len;
		int FmaxX = maxX - m_omsize;
		int x = 0;
		while ( textptr < textmax ){
			WORD code;
			const TCHAR *oldtext;

			oldtext = textptr;
			code = GetCodeAndNext(textptr, textmax);
//			if ( code == '\0' ) return x;
			if ( m_fontinfo[code].dataX == 0 ){
				MakeGlyph(oldtext, textmax);
			}
			if ( ((x + m_fontinfo[code].cellW) > FmaxX) &&
				  !((textptr == textmax) && ((x + m_fontinfo[code].cellW) <= maxX)) ){
				int showW;

				showW = m_fontinfo['.'].showW;
				while ( (x + showW) <= maxX ){
					x += showW + 1;
				}
				break;
			}
			x += m_fontinfo[code].cellW;
		}
		len = textptr - text;
		return x;
	}
};

class DxMeshClass
{
private:
	ScreenInfo *m_sinfo;
// class
	ID3DXMesh *m_mesh;
	IDirect3DBaseTexture9 **m_Textures;
// struct/value
	D3DMATERIAL9 *m_Materials;
	D3DXMATRIXA16 m_MatCharFixPos; // @
	DWORD m_nummaterials;

	float m_r; // ]\ʒu
public:
	DxMeshClass()
	{
		m_mesh = NULL;
		m_Materials = NULL;
		m_Textures = NULL;

		m_r = 0.0f;
	}

	~DxMeshClass()
	{
		Release();
	}

	void Release(void)
	{
		if ( m_Textures != NULL ){
			for( UINT i = 0 ; i < m_nummaterials ; i++ ){
				SAFE_RELEASE( m_Textures[i] );
			}
		}
		SAFE_DELETE_ARRAY(m_Textures);
		SAFE_DELETE_ARRAY(m_Materials);
		SAFE_RELEASE(m_mesh);
	}

	BOOL Init(ScreenInfo *sinfo, const TCHAR *filename)
	{
		WCHAR path[MAX_PATH], *wp;
		LPD3DXBUFFER pAdjacencyBuffer;
		LPD3DXBUFFER objmaterials;
		IDirect3DDevice9 *D3DDev = sinfo->D3DDev;

		m_sinfo = sinfo;
		if ( FAILED(D3DXLoadMeshFromX(filename, D3DXMESH_MANAGED, D3DDev,
				&pAdjacencyBuffer, &objmaterials,
				NULL, &m_nummaterials, &m_mesh)) ){
			return FALSE;
		}
		m_mesh->OptimizeInplace(D3DXMESHOPT_COMPACT | D3DXMESHOPT_ATTRSORT |
				D3DXMESHOPT_VERTEXCACHE,
				(DWORD*)pAdjacencyBuffer->GetBufferPointer(), NULL, NULL, NULL);

		if ( !(m_mesh->GetFVF() & D3DFVF_NORMAL) ){ // @̕⊮
			ID3DXMesh* TempMesh;

			m_mesh->CloneMeshFVF(m_mesh->GetOptions(),
					m_mesh->GetFVF() | D3DFVF_NORMAL, D3DDev, &TempMesh );
			D3DXComputeNormals(TempMesh, NULL);
			SAFE_RELEASE(m_mesh);
			m_mesh = TempMesh;
		}
		strcpyToW(path, filename, MAX_PATH);
		wp = strchrW(path, '\\');
		if ( wp != NULL ){
			*(wp + 1) = '\0';
		}else{
			path[0] = '\0';
		}

		CreateMaterials(path, (D3DXMATERIAL*)objmaterials->GetBufferPointer());
		objmaterials->Release();

		// 傫s
		const float fRadius = 0.5f;
		D3DXMatrixScaling(&m_MatCharFixPos, fRadius, fRadius, fRadius);
		return TRUE;
	}

	HRESULT CreateMaterials(WCHAR *path, D3DXMATERIAL *d3dxMtrls)
	{
		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		if ( !d3dxMtrls || !m_nummaterials ) return S_OK;

		m_Materials = new D3DMATERIAL9[m_nummaterials];
		if ( m_Materials == NULL ) return E_OUTOFMEMORY;
		m_Textures = new LPDIRECT3DBASETEXTURE9[m_nummaterials];
		if ( m_Textures == NULL ) return E_OUTOFMEMORY;

		for( DWORD i = 0 ; i < m_nummaterials; i++ ){
			WCHAR TexName[MAX_PATH];
			WCHAR TexPath[MAX_PATH];
			D3DXIMAGE_INFO ImgInfo;

			m_Materials[i] = d3dxMtrls[i].MatD3D;
			m_Textures[i] = NULL;

			if ( d3dxMtrls[i].pTextureFilename == NULL ) continue;

			AnsiToUnicode(d3dxMtrls[i].pTextureFilename, TexName, MAX_PATH);
			strcpyW(TexPath, path);
			strcatW(TexPath, TexName);
			if ( FAILED( D3DXGetImageInfoFromFileW(TexPath, &ImgInfo) ) ){
				PutLog(T("Load Error %s"), DEBUGMESSIZE, TexPath);
				return E_OUTOFMEMORY;
			}
			switch( ImgInfo.ResourceType ){
				case D3DRTYPE_TEXTURE: {
					IDirect3DTexture9 *pTex;

					if ( SUCCEEDED( D3DXCreateTextureFromFileW(D3DDev, TexPath, &pTex) ) ){
						pTex->QueryInterface(IID_IDirect3DBaseTexture9, (LPVOID*)&m_Textures[i] );
						pTex->Release();
					}
					break;
				}
				case D3DRTYPE_CUBETEXTURE: {
					IDirect3DCubeTexture9 *pTex;

					if ( SUCCEEDED( D3DXCreateCubeTextureFromFileW(D3DDev, TexPath, &pTex ) ) ){
						pTex->QueryInterface(IID_IDirect3DBaseTexture9, (LPVOID*)&m_Textures[i] );
						pTex->Release();
					}
					break;
				}
				case D3DRTYPE_VOLUMETEXTURE: {
					IDirect3DVolumeTexture9 *pTex;

					if ( SUCCEEDED( D3DXCreateVolumeTextureFromFileW( D3DDev, TexPath, &pTex ) ) ){
						pTex->QueryInterface(IID_IDirect3DBaseTexture9, (LPVOID*)&m_Textures[i] );
						pTex->Release();
					}
					break;
				}
			}
		}
		return S_OK;
	}

	void Draw(float x, float y, float z, float rx, float ry, float rz)
	{
		if ( m_mesh == NULL ) return;

		D3DXMATRIXA16 matWorld, matRot, matSub, mxProj;
			// ]
		D3DXMatrixRotationYawPitchRoll(&matSub, ry + m_r, rx - 0.5f, rz);
		m_r += 0.03f;
		D3DXMatrixMultiply(&matWorld, &m_MatCharFixPos, &matSub);
			// ʒu
		D3DXMatrixTranslation(&matSub, x, y, z);
		D3DXMatrixMultiply(&matWorld, &matWorld, &matSub);

		IDirect3DDevice9 *D3DDev = m_sinfo->D3DDev;

		D3DDev->SetRenderState(D3DRS_LIGHTING, TRUE);

		D3DDev->SetTextureStageState(0, D3DTSS_COLOROP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_DIFFUSE);

		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAOP  , D3DTOP_MODULATE);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_TFACTOR);
		D3DDev->SetRenderState(D3DRS_TEXTUREFACTOR, 0x50606060);

		D3DDev->SetTransform(D3DTS_WORLD, &matWorld);
		for ( DWORD i = 0 ; i < m_nummaterials ; i++ ){
			D3DDev->SetMaterial(&m_Materials[i]);
			if ( m_Textures && m_Textures[i] ){
				D3DDev->SetTexture(0, m_Textures[i]);
			}
			m_mesh->DrawSubset(i);
		}

		D3DDev->SetRenderState(D3DRS_LIGHTING, FALSE);
	}
};

class DxCacheDIBClass
{
private:
	ScreenInfo *m_sinfo;
	IDirect3DTexture9 *m_Tex;
	DWORD m_CacheInfo;
	BITMAPINFOHEADER m_bmiHeader;
public:
	DxCacheDIBClass()
	{
		m_Tex = NULL;
		Free();
	}

	~DxCacheDIBClass()
	{
		Free();
	}

	void Free(void)
	{
		SAFE_RELEASE(m_Tex);
		m_CacheInfo = 0;
		m_bmiHeader.biWidth = 0xffffffff;
	}

	BOOL Init(ScreenInfo *sinfo)
	{
		m_CacheInfo = 0;
		m_sinfo = sinfo;
		return TRUE;
	}

	BOOL Check(DWORD *CacheID)
	{
		if ( (*CacheID == 0) || (m_CacheInfo != *CacheID) ){
			*CacheID = ++m_CacheInfo;
			return FALSE;
		}
		return TRUE;
	}

	void Draw(BITMAPINFOHEADER *bmiHeader, LPVOID lpBits, const RECT *box)
	{
		D3DLOCKED_RECT LockedRect;

		if ( (bmiHeader != NULL) &&
			((m_bmiHeader.biWidth != bmiHeader->biWidth) ||
			 (m_bmiHeader.biHeight != bmiHeader->biHeight)) ){
			Free();
			m_bmiHeader = *bmiHeader;

			m_sinfo->D3DDev->CreateTexture(
					m_bmiHeader.biWidth, m_bmiHeader.biHeight, 1,
					D3DUSAGE_DYNAMIC, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT,
					&m_Tex, NULL);
		}
		if ( m_Tex == NULL ) return;

		if ( lpBits != NULL ){
			if ( SUCCEEDED(m_Tex->LockRect(0, &LockedRect, NULL, D3DLOCK_DISCARD)) ){
				DWORD blockW = m_bmiHeader.biWidth;

				for ( int y = m_bmiHeader.biHeight - 1 ; y >= 0 ; y-- ){
					const DWORD *src = (DWORD *)(BYTE *)lpBits + (m_bmiHeader.biHeight - 1 - y) * blockW;
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits + y * LockedRect.Pitch);
					memcpy(dest, src, m_bmiHeader.biWidth * sizeof(DWORD));
				}
				m_Tex->UnlockRect(0);
			}
		}
		::DrawTex(m_sinfo, m_Tex, box->left, box->top, box->right, box->bottom);
	}
};

extern "C" typedef struct tagDXDRAWSTRUCT {
	ScreenInfo sinfo;
	D3DDeviceClass d3d;
	DxTextClass dxText; // \֘A
	DxCellCursorClass dxCursor;
	DxCacheDIBClass dxCacheDIB;

	DxMeshClass dxMesh; // ppc.x \p

	// ͉Kv
	IDirect3DTexture9 *SubGround; // 
	IDirect3DSurface9 *SubDepthStencilSurf; // 
	IDirect3DSurface9 *BackupSurf; // 
	IDirect3DSurface9 *BackupDepthStencilSurf; // 
	float MM_r;
	DWORD MM_c;

	// ܂

	BOOL CaptureMode;
	int MotionMode;
	DWORD MotionTick;
	int ul_height;
} DXDRAWSTRUCT;

void DrawTex(ScreenInfo *sinfo, IDirect3DTexture9 *Tex, int left, int top, int width, int height)
{
	IDirect3DDevice9 *D3DDev = sinfo->D3DDev;

	D3DDev->SetFVF(FVF_DEFFVF);
	D3DDev->SetTexture(0, Tex);
	D3DDev->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
	D3DDev->SetStreamSource(0, sinfo->PanelVertex, 0, sizeof(VEX_DEFFVF) );

	D3DDev->SetTextureStageState(0, D3DTSS_COLOROP  , D3DTOP_SELECTARG1);
	D3DDev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);

	D3DDev->SetTextureStageState(0, D3DTSS_ALPHAOP  , D3DTOP_SELECTARG1);
	D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TFACTOR);
	D3DDev->SetRenderState(D3DRS_TEXTUREFACTOR, 0xffc0c0c0);

	D3DMATRIX mat = IdentityMatrix;
	SetMatrix2D_ST(mat,
			(float)left * D3D_ProjScaleX,	(float)top * D3D_ProjScaleY,
			(float)width * D3D_ProjScaleX,	(float)height * D3D_ProjScaleY
	);
	D3DDev->SetTransform(D3DTS_WORLD, &mat);

	D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
}

BOOL DrawDIB(ScreenInfo *sinfo, BITMAPINFOHEADER *bmiHeader, LPVOID lpBits, const RECT *box)
{
	IDirect3DTexture9 *Tex;
	D3DLOCKED_RECT LockedRect;

	if ( FAILED(sinfo->D3DDev->CreateTexture(
			bmiHeader->biWidth, bmiHeader->biHeight, 1,
			D3DUSAGE_DYNAMIC, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &Tex, NULL)) ){
		return FALSE;
	}

	if ( SUCCEEDED(Tex->LockRect(0, &LockedRect, NULL, D3DLOCK_DISCARD)) ){
		switch (bmiHeader->biBitCount){
			case 1: {
				DWORD *palette;
				DWORD blockW = bmiHeader->biWidth;

				palette = (COLORREF *)(BYTE *)((BYTE *)bmiHeader + bmiHeader->biSize);
				for ( int y = bmiHeader->biHeight - 1 ; y >= 0 ; y-- ){
					const BYTE *src = (BYTE *)lpBits + (bmiHeader->biHeight - 1 - y) * DwordAlignment((blockW + 7) / 8);
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits + y * LockedRect.Pitch);
					int w;
					BYTE pixels;

					for ( w = blockW ; w >= 8 ; w -= 8 ){

						pixels = *src++;
						for ( int b = 0 ; b < 8 ; b++ ){
							*dest++ = palette[pixels >> 7] | 0xff000000;
							pixels <<= 1;
						}
					}
					pixels = *src;
					for ( ; w > 0 ; w-- ){
						*dest++ = palette[pixels >> 7] | 0xff000000;
						pixels <<= 1;
					}
				}
				break;
			}

			case 4: {
				DWORD *palette;
				DWORD blockW = bmiHeader->biWidth;

				palette = (COLORREF *)(BYTE *)((BYTE *)bmiHeader + bmiHeader->biSize);
				for ( int y = bmiHeader->biHeight - 1 ; y >= 0 ; y-- ){
					const BYTE *src = (BYTE *)lpBits + (bmiHeader->biHeight - 1 - y) * DwordAlignment((blockW + 1) / 2);
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits + y * LockedRect.Pitch);
					int w;
					for ( w = blockW ; w >= 2 ; w -= 2 ){
						BYTE pixels;

						pixels = *src++;
						*dest++ = palette[pixels >> 4] | 0xff000000;
						*dest++ = palette[pixels & 0xf] | 0xff000000;
					}
					if ( w > 1 ){
						*dest++ = palette[*src >> 4] | 0xff000000;
					}
				}
				break;
			}

			case 8: {
				DWORD *palette;
				DWORD blockW = bmiHeader->biWidth;

				palette = (COLORREF *)(BYTE *)((BYTE *)bmiHeader + bmiHeader->biSize);
				for ( int y = bmiHeader->biHeight - 1 ; y >= 0 ; y-- ){
					const BYTE *src = (BYTE *)lpBits + (bmiHeader->biHeight - 1 - y) * DwordAlignment(blockW);
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits + y * LockedRect.Pitch);
					for ( int w = blockW ; w > 0 ; w-- ){
						*dest++ = palette[*src++] | 0xff000000;
					}
				}
				break;
			}

			case 24: {
				DWORD blockW = bmiHeader->biWidth;

				for ( int y = bmiHeader->biHeight - 1 ; y >= 0 ; y-- ){
					const BYTE *src = (BYTE *)lpBits + (bmiHeader->biHeight - 1 - y) * DwordAlignment(blockW * 3);
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits + y * LockedRect.Pitch);
					for ( int w = blockW ; w > 0 ; w-- ){
						*dest++ = *(DWORD *)src;
						src += 3;
					}
				}
				break;
			}

			case 32: {
				DWORD blockW = bmiHeader->biWidth;

				for ( int y = bmiHeader->biHeight - 1 ; y >= 0 ; y-- ){
					const DWORD *src = (DWORD *)(BYTE *)lpBits + (bmiHeader->biHeight - 1 - y) * blockW;
					DWORD *dest = (DWORD *)(BYTE *)((BYTE *)LockedRect.pBits + y * LockedRect.Pitch);
					memcpy(dest, src, blockW * sizeof(DWORD));
				}
				break;
			}

			default:
//				Messagef("Bad format %d", bmiHeader->biBitCount);
				break;
		}
		Tex->UnlockRect(0);
		DrawTex(sinfo, Tex, box->left, box->top, box->right, box->bottom);
	}
	Tex->Release();
	return TRUE;
}

void EndMotion(DXDRAWSTRUCT *DxDraw)
{
	SAFE_RELEASE(DxDraw->SubDepthStencilSurf);
	SAFE_RELEASE(DxDraw->SubGround);
	DxDraw->MotionMode = 0;
}

void USEFASTCALL FreeDxObject(DXDRAWSTRUCT *DxDraw)
{
	int MotionMode = DxDraw->MotionMode;

	DxDraw->dxCursor.Free();
	DxDraw->dxText.Free();
	DxDraw->dxCacheDIB.Free();

	EndMotion(DxDraw);
	if ( MotionMode ){ // MotionȂAsł悤ɂ
		DxDraw->MotionMode = MotionMode;
		DxDraw->CaptureMode = TRUE;
	}
}

BOOL CreateDxDraw(DXDRAWSTRUCT **DxDrawPtr, HWND hWnd)
{
	DXDRAWSTRUCT *DxDraw;
	TCHAR path[MAX_PATH];

	*DxDrawPtr = DxDraw = new DXDRAWSTRUCT;
	DxDraw->sinfo.hWnd = hWnd;

	if ( DxDraw->d3d.Init(&DxDraw->sinfo) == FALSE ){
	//	Message(g_DebugMes);
		delete DxDraw;
		*DxDrawPtr = NULL;
		return FALSE;
	}
	DxDraw->dxText.Init(&DxDraw->sinfo);
	DxDraw->dxCursor.Init(&DxDraw->sinfo);
	DxDraw->dxCacheDIB.Init(&DxDraw->sinfo);

	GetModuleFileName(NULL, path, MAX_PATH);
	tstrcpy(tstrrchr(path, '\\'), T("\\ppc.x"));
	DxDraw->dxMesh.Init(&DxDraw->sinfo, path);

	DxDraw->SubGround = NULL;
	DxDraw->SubDepthStencilSurf = NULL;

	DxDraw->CaptureMode = FALSE;
	DxDraw->MotionMode = 0;
	DxDraw->ul_height = 0;
	return TRUE;
}

BOOL CloseDxDraw(DXDRAWSTRUCT **DxDrawPtr)
{
	if ( (*DxDrawPtr) == NULL ) return FALSE;

	FreeDxObject(*DxDrawPtr);

	delete (*DxDrawPtr);
	*DxDrawPtr = NULL;
	return TRUE;
}

int BeginDxDraw(DXDRAWSTRUCT *DxDraw, PAINTSTRUCT *ps)
{
	int result;

	if ( DxDraw == NULL ) return DXSTART_GDI;
	if ( GetKeyState(VK_SCROLL) & 1 ){
		BeginPaint(DxDraw->sinfo.hWnd, ps);
		return DXSTART_GDI;
	}

	result = DxDraw->d3d.BeginRender();
	if ( result == FALSE ){
		FreeDxObject(DxDraw);

		DxDraw->d3d.ResetDevice();
		DxDraw->d3d.SetBackColor(DxDraw->sinfo.backgroundcolor);
		result = DxDraw->d3d.BeginRender();
	}
	if ( result == FALSE ){
		ValidateRect(DxDraw->sinfo.hWnd, NULL);
		return DXSTART_NODRAW;
	}

	if ( IsTrue(DxDraw->CaptureMode) ){
		if ( DxDraw->SubGround == NULL ){
			if ( FAILED(DxDraw->sinfo.D3DDev->CreateTexture(
					DxDraw->sinfo.ClientWidthInt, DxDraw->sinfo.ClientHeightInt,
					1, D3DUSAGE_RENDERTARGET, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT,
					&DxDraw->SubGround, NULL)) ){
				DxDraw->SubGround = NULL;
			}else{
				DxDraw->sinfo.D3DDev->CreateDepthStencilSurface(
						DxDraw->sinfo.ClientWidthInt,
						DxDraw->sinfo.ClientHeightInt,
						D3DFMT_D16, D3DMULTISAMPLE_NONE, 0, FALSE,
						&DxDraw->SubDepthStencilSurf, NULL);
			}
		}
		if ( DxDraw->SubGround != NULL ){
			// AddRef邱Ƃɒ
			DxDraw->sinfo.D3DDev->GetRenderTarget(0, &DxDraw->BackupSurf);
			DxDraw->sinfo.D3DDev->GetDepthStencilSurface(&DxDraw->BackupDepthStencilSurf);

			IDirect3DSurface9 *pSurf = NULL;
			DxDraw->SubGround->GetSurfaceLevel(0, &pSurf);
			DxDraw->sinfo.D3DDev->SetRenderTarget(0, pSurf);
			DxDraw->sinfo.D3DDev->SetDepthStencilSurface(DxDraw->SubDepthStencilSurf);
			pSurf->Release();
			DxDraw->sinfo.D3DDev->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER /*| D3DCLEAR_STENCIL*/, 0x00FFFFFF, 1.0f, 0);

		}
	}
	ps->hdc = static_cast<HDC>(DXMODEVALUE_DX);
	ps->fErase = FALSE;
	ps->rcPaint.left = ps->rcPaint.top = 0;
	ps->rcPaint.right  = DxDraw->sinfo.ClientWidthInt;
	ps->rcPaint.bottom = DxDraw->sinfo.ClientHeightInt;

	DxExtDraw(DxDraw, &ps->rcPaint);
	return DXSTART_DX;
}


BOOL EndDxDraw(DXDRAWSTRUCT *DxDraw)
{
	RECT box = {0, 0, 800, 80};

	if ( DxDraw == NULL ) return FALSE;
	ValidateRect(DxDraw->sinfo.hWnd, NULL);

	if ( DxDraw->SubGround != NULL ){
		if ( IsTrue(DxDraw->CaptureMode) ){
			DxDraw->sinfo.D3DDev->SetRenderTarget(0, DxDraw->BackupSurf);
			DxDraw->BackupSurf->Release();
			DxDraw->sinfo.D3DDev->SetDepthStencilSurface(DxDraw->BackupDepthStencilSurf);
			DxDraw->BackupDepthStencilSurf->Release();
		}
		IDirect3DDevice9 *D3DDev = DxDraw->sinfo.D3DDev;

		D3DDev->SetFVF(FVF_DEFFVF);
		D3DDev->SetTexture(0, DxDraw->SubGround);
		D3DDev->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
		D3DDev->SetStreamSource(0, DxDraw->sinfo.PanelVertex, 0, sizeof(VEX_DEFFVF) );
		D3DDev->SetTextureStageState(0, D3DTSS_COLOROP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);

		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAOP  , D3DTOP_SELECTARG1);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

		D3DXMATRIXA16 mat = IdentityMatrix;

		SetMatrix2D_ST(mat,
				0.0f , 0.0f , //0 * D3D_ProjScaleX,	(float)0 * D3D_ProjScaleY,
				DxDraw->sinfo.ClientWidth * D3D_ProjScaleX,	DxDraw->sinfo.ClientHeight * D3D_ProjScaleY
		);

		if ( IsTrue(DxDraw->CaptureMode) ){
			D3DDev->SetTransform(D3DTS_WORLD, &mat);
			D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
			DxDraw->CaptureMode = FALSE;
		}

		// 
		D3DXMATRIXA16 matV = IdentityMatrix;

		switch ( DxDraw->MotionMode ){
			case DXMOTION_Launch:
				SetMatrix2D_ST(matV, -DxDraw->MM_r / 10.0f, DxDraw->MM_r / 10.0f, DxDraw->MM_r + 1.0f, DxDraw->MM_r + 1.0f);
				break;

			case DXMOTION_Root: {
				float mag = 1.0f - (DxDraw->MM_r / (D3D_ProjScaleX * DxDraw->sinfo.ClientWidth)) * 0.4f;
				SetMatrix2D_ST(matV, DxDraw->MM_r, 0.0f, mag, mag);
				break;
			}

			case DXMOTION_NewWindow:
			case DXMOTION_ChangePath:

			case DXMOTION_ChangeDrive:
				SetMatrix2D_ST(matV, DxDraw->MM_r, 0.0f, 1.0f, 1.0f);
				break;

			case DXMOTION_UpDir:
			case DXMOTION_DownDir:
				SetMatrix2D_ST(matV, 0.0f, DxDraw->MM_r, 1.0f, 1.0f);
				break;

			case DXMOTION_Busy:
				D3DXMatrixRotationYawPitchRoll(&matV, 0.0f + DxDraw->MM_r, 0.0f - 0.5f, 0.0f);
				break;
		}

		D3DXMatrixMultiply(&mat, &mat, &matV);

		// Ύeŕ`
		D3DDev->SetTransform(D3DTS_VIEW, &DxDraw->d3d.MatView3D);
		D3DDev->SetTransform(D3DTS_WORLD, &mat);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAOP  , D3DTOP_MODULATE);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TFACTOR);
		D3DDev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_TEXTURE);
		D3DDev->SetRenderState(D3DRS_TEXTUREFACTOR, DxDraw->MM_c);
		D3DDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
		D3DDev->SetTransform(D3DTS_VIEW, &DxDraw->d3d.MatView2D);

		#define MM_STEP 10
		#define MM_WAIT 20
		if ( DxDraw->MotionMode ){
			DWORD tick = GetTickCount(), oldtick;

			oldtick = DxDraw->MotionTick;
			if ( (tick - oldtick) > MM_WAIT ){
				DxDraw->MotionTick = tick;
				tick -= oldtick;
				if ( tick > 1000 ) tick = 1000;
				for ( ; tick <= 1000 ; tick -= MM_WAIT ) switch ( DxDraw->MotionMode ){
					case DXMOTION_Busy:
						DxDraw->MM_r += 0.5f;
						break;

					case DXMOTION_NewWindow:
						DxDraw->MM_r -= D3D_ProjScaleX * (DxDraw->sinfo.ClientWidth / MM_STEP);
						DxDraw->MM_c += ((0xff000000 / MM_STEP) & 0xff000000);

						if ( DxDraw->MM_r <= 0.0f ) EndMotion(DxDraw);
						break;

					case DXMOTION_Root:
					case DXMOTION_ChangePath:
					case DXMOTION_Launch:

					case DXMOTION_ChangeDrive:
						DxDraw->MM_r += D3D_ProjScaleX * (DxDraw->sinfo.ClientWidth / MM_STEP);
						DxDraw->MM_c -= ((0xff000000 / MM_STEP) & 0xff000000);

						if ( DxDraw->MM_r > (DxDraw->sinfo.ClientWidth * D3D_ProjScaleX) ){
							EndMotion(DxDraw);
						}
						break;

					case DXMOTION_UpDir:
						DxDraw->MM_r += D3D_ProjScaleY * (DxDraw->sinfo.ClientHeight / MM_STEP);
						DxDraw->MM_c -= ((0xff000000 / MM_STEP) & 0xff000000);

						if ( DxDraw->MM_r < (DxDraw->sinfo.ClientHeight * D3D_ProjScaleY) ){
							EndMotion(DxDraw);
						}
						break;

					case DXMOTION_DownDir:
						DxDraw->MM_r -= D3D_ProjScaleY * (DxDraw->sinfo.ClientHeight / MM_STEP);
						DxDraw->MM_c -= ((0xff000000 / MM_STEP) & 0xff000000);

						if ( DxDraw->MM_r >= 0.0f ) EndMotion(DxDraw);
						break;
				}
			}
		}
	}

	if ( g_DebugMes[0] ){
#if USEDXTEXT
		DxDraw->d3d.DrawText(g_DebugMes, &box);
#else
		DxDraw->sinfo.lastpos.x = 0;
		DxDraw->sinfo.lastpos.y = 0;
		DxDraw->dxText.Draw(g_DebugMes, 0, 0, 0x10000, tstrlen(g_DebugMes));
#endif
	}
	DxDraw->d3d.EndRender();
	return TRUE;
}


BOOL ChangeSizeDxDraw(DXDRAWSTRUCT *DxDraw, COLORREF backcolor)
{
	RECT ClientBox;

	if ( DxDraw == NULL ) return FALSE;
	DxDraw->sinfo.backgroundcolor = backcolor;
	GetClientRect(DxDraw->sinfo.hWnd, &ClientBox);
	if ( (ClientBox.right > 0) && (ClientBox.bottom > 0) &&
		((DxDraw->sinfo.ClientWidthInt != ClientBox.right) ||
		(DxDraw->sinfo.ClientHeightInt != ClientBox.bottom))
	){
		DxDraw->sinfo.ClientWidth = static_cast<float>(ClientBox.right);
		DxDraw->sinfo.ClientHeight = static_cast<float>(ClientBox.bottom);
		DxDraw->sinfo.ClientWidthInt = ClientBox.right;
		DxDraw->sinfo.ClientHeightInt = ClientBox.bottom;
		if ( IsTrue(DxDraw->d3d.DeviceCheck()) ){
			FreeDxObject(DxDraw);
//			DxDraw->d3d.RequestReset();
			DxDraw->d3d.ResetDevice();
			DxDraw->d3d.SetBackColor(backcolor);
		}
	}
	return TRUE;
}

DWORD SetFontDxDraw(DXDRAWSTRUCT *DxDraw, HFONT hFont, int type)
{
	LOGFONT lfont;

	if ( DxDraw == NULL ) return 0;
	DxDraw->dxText.SetFont(hFont);

	if ( type == 0 ){
		GetObject(hFont, sizeof(LOGFONT), static_cast<LPVOID>(&lfont));
		DxDraw->sinfo.fontH =
				(lfont.lfHeight >= 0) ? lfont.lfHeight : -lfont.lfHeight;
	}
	return 1;
}

void USEFASTCALL DxMoveToEx(DXDRAWSTRUCT *DxDraw, HDC hDC, int x, int y)
{
	IfGDImode(hDC){
		MoveToEx(hDC, x, y, NULL);
		return;
	}
	DxDraw->sinfo.lastpos.x = x;
	DxDraw->sinfo.lastpos.y = y;
}

void USEFASTCALL DxGetCurrentPositionEx(DXDRAWSTRUCT *DxDraw, HDC hDC, POINT *lp)
{
	IfGDImode(hDC){
		GetCurrentPositionEx(hDC, lp);
		return;
	}
	*lp = DxDraw->sinfo.lastpos;
}

void DxTextOutRel(DXDRAWSTRUCT *DxDraw, HDC hDC, const TCHAR *str, int len)
{
	IfGDImode(hDC){
		TextOut(hDC, 0, 0, str, len);
		return;
	}
	DxDraw->sinfo.lastpos.x = DxDraw->dxText.Draw(str, DxDraw->sinfo.lastpos.x, DxDraw->sinfo.lastpos.y, 0xffffff, len);
}

void DxTextOutBack(DXDRAWSTRUCT *DxDraw, HDC hDC, const TCHAR *str, int len)
{
	IfGDImode(hDC){
		TextOut(hDC, 0, 0, str, len);
		return;
	}
	int width = DxDraw->dxText.Calc(str, 0x70ffffff, len);
	DxDraw->dxCursor.DrawBack(DxDraw->sinfo.lastpos.x, DxDraw->sinfo.lastpos.y,
			width, DxDraw->sinfo.fontH - DxDraw->ul_height, DxDraw->sinfo.TextBackColor);
	DxDraw->sinfo.lastpos.x = DxDraw->dxText.Draw(str, DxDraw->sinfo.lastpos.x, DxDraw->sinfo.lastpos.y, 0x70ffffff, len);
}

void DxGetTextExtentExPoint(DXDRAWSTRUCT *DxDraw, HDC hDC, const TCHAR *str, int len, int maxwidth, int *fitlen, int *alptbl, SIZE *blksize)
{
	IfGDImode(hDC){
		return GetTextExtentExPoint(hDC, str, len, maxwidth, fitlen, alptbl, blksize);
	}
	*fitlen = len;
	blksize->cx = DxDraw->dxText.Calc(str, maxwidth, *fitlen);
	return TRUE;
}

void DxDrawCursor(DXDRAWSTRUCT *DxDraw, HDC hDC, const RECT *box, COLORREF color)
{
	IfGDImode(hDC) return;
	DxDraw->dxCursor.Draw(box->left, box->top, box->right - box->left, box->bottom - box->top, color);
}

void DxDrawBack(DXDRAWSTRUCT *DxDraw, HDC hDC, const RECT *box, COLORREF color)
{
	IfGDImode(hDC) return;
	DxDraw->dxCursor.DrawBack(box->left, box->top, box->right - box->left, box->bottom - box->top, color);
}

BOOL DxDrawAtlas_Check(DXDRAWSTRUCT *DxDraw, DWORD *CacheID)
{
	return DxDraw->dxCacheDIB.Check(CacheID);
}

void DxDrawAtlas(DXDRAWSTRUCT *DxDraw, BITMAPINFOHEADER *bmiHeader, LPVOID lpBits, const RECT *box)
{
	DxDraw->dxCacheDIB.Draw(bmiHeader, lpBits, box);
}

BOOL DxDrawDIB(DXDRAWSTRUCT *DxDraw, BITMAPINFOHEADER *bmiHeader, LPVOID lpBits, const RECT *box, const RECT *, DXBMPCACHE **)
{
	return DrawDIB(&DxDraw->sinfo, bmiHeader, lpBits, box);
}

void DxDrawIcon(DXDRAWSTRUCT *DxDraw, HICON icon, const RECT *box, DXBMPCACHE **)
{
	if ( DxDraw == NULL ) return;
	DxDraw->d3d.DrawIcon(icon, box);
}

void DxDrawFreeBMPCache(DXBMPCACHE **)
{
}

void DxDrawText(DXDRAWSTRUCT *DxDraw, HDC hDC, const TCHAR *str, int len, const RECT *box, DWORD flags)
{
	IfGDImode(hDC){
		DrawText(hDC, str, len, (LPRECT)box, flags);
		return;
	}
	if ( len < 0 ) len = tstrlen(str);
	DxDraw->sinfo.lastpos.x = DxDraw->dxText.Draw(str, box->left, box->top, box->right, len);
}

COLORREF DxSetTextColor(DXDRAWSTRUCT *DxDraw, HDC hDC, COLORREF color)
{
	COLORREF oldcolor;

	IfGDImode(hDC) return SetTextColor(hDC, color);

	DxDraw->dxText.SetTextColor(color);
	oldcolor = DxDraw->sinfo.TextColor;
	DxDraw->sinfo.TextColor = color;
	return oldcolor;
}

COLORREF USEFASTCALL DxGetTextColor(DXDRAWSTRUCT *DxDraw, HDC hDC)
{
	IfGDImode(hDC) return GetTextColor(hDC);

	return DxDraw->sinfo.TextColor;
}

COLORREF DxSetBkColor(DXDRAWSTRUCT *DxDraw, HDC hDC, COLORREF color)
{
	COLORREF oldcolor;

	IfGDImode(hDC) return SetBkColor(hDC, color);

	oldcolor = DxDraw->sinfo.TextBackColor;
	DxDraw->sinfo.TextBackColor = color;
	return oldcolor;
}

COLORREF USEFASTCALL DxGetBkColor(DXDRAWSTRUCT *DxDraw, HDC hDC)
{
	IfGDImode(hDC) return GetBkColor(hDC);

	return DxDraw->sinfo.TextBackColor;
}

void USEFASTCALL DxSetBenchmarkMode(DXDRAWSTRUCT *DxDraw, BOOL mode)
{
	if ( DxDraw == NULL ) return;
	if ( IsTrue(DxDraw->d3d.SetBenchmarkMode(mode)) ){
		FreeDxObject(DxDraw);
		DxDraw->d3d.ResetDevice();
	}
}

// ܂\
void USEFASTCALL DxExtDraw(DXDRAWSTRUCT *DxDraw, RECT *client)
{
	DxDraw->dxMesh.Draw(
			(static_cast<float>(client->right) - 23.0f) * D3D_ProjScaleX,
			(static_cast<float>(client->top) + 28.0f) * D3D_ProjScaleY,
			ZPOS_MESH,  0.0f, 0.0f, 0.0f);
//	DxDraw->dxText.DrawTest();
}

void DxSetMotion(DXDRAWSTRUCT *DxDraw, int mode)
{
	if ( DxDraw == NULL ) return;
	switch ( mode ){
		case DXMOTION_NewWindow:
			DxDraw->MM_r = DxDraw->sinfo.ClientWidth * D3D_ProjScaleX * (MM_STEP - 0.9f) / MM_STEP;
			DxDraw->MM_c = 0;
			break;

		case DXMOTION_DownDir:
			DxDraw->MM_r = DxDraw->sinfo.ClientHeight * D3D_ProjScaleY * 0.91f;
			DxDraw->MM_c = 0xffffffff;
			break;

		case DXMOTION_StopBusy:
			if ( DxDraw->MotionMode != DXMOTION_Busy ) return;
			EndMotion(DxDraw);
			return;

		case DXMOTION_Busy:
			if ( DxDraw->MotionMode == DXMOTION_Busy ) return;

		case DXMOTION_UpDir:
		case DXMOTION_Root:
		case DXMOTION_ChangeDrive:
		case DXMOTION_ChangePath:
		case DXMOTION_Launch:
			DxDraw->MM_r = 0.0f;
			DxDraw->MM_c = 0xffffffff;
			break;
	}

	EndMotion(DxDraw);
	//  FreeDxObject ɂLڂ
	DxDraw->MotionMode = mode;
	DxDraw->CaptureMode = TRUE;
	DxDraw->MotionTick = GetTickCount();

	InvalidateRect(DxDraw->sinfo.hWnd, NULL, TRUE);
	UpdateWindow(DxDraw->sinfo.hWnd);
}

int DxSetBkMode(DXDRAWSTRUCT *DxDraw, HDC hDC, int mode)
{
	IfGDImode(hDC) return SetBkMode(hDC, mode);

	int oldmode = DxDraw->sinfo.BkMode;
	DxDraw->sinfo.BkMode = mode;
	return mode;
}

void ResetDxDraw(DXDRAWSTRUCT *DxDraw)
{
	if ( DxDraw == NULL ) return;
	FreeDxObject(DxDraw);
	DxDraw->d3d.ResetDevice();
}

void DxSetUnderLineHeight(DXDRAWSTRUCT *DxDraw, int height)
{
	DxDraw->ul_height = height;
}

#ifndef UNICODE
void DxTextOutRelW(DXDRAWSTRUCT *DxDraw, HDC hDC, const WCHAR *str, int len)
{
	char text[0x1000];

	IfGDImode(hDC){
		TextOutW(hDC, 0, 0, str, len);
		return;
	}

	int lenA = WideCharToMultiByte(CP_ACP, 0, str, len, text, 0x1000, NULL, NULL);
	DxTextOutBack(DxDraw, hDC, text, lenA);
}
#endif
#endif // DRAWMODE_3D
#endif // USEDIRECTX
