/*-----------------------------------------------------------------------------
	Paper Plane xUI											PPc, PPvp
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include <commctrl.h>
#include "PPX.H"
#include "VFS.H"
#include "PPX_DRAW.H"
#include "PPX_CV.H"
#pragma hdrstop

extern OSVERSIONINFO OSver;
extern UINT WM_PPXCOMMAND;
extern COLORREF C_back;
extern int X_fles;
extern const TCHAR StrUser32DLL[];

BOOL X_awhel = TRUE;
DLLDEFINED HMODULE hDwmapi DLLPARAM(NULL);


const TCHAR RegWallpaperName[] = T("Wallpaper");
const TCHAR RegWallpaperTile[] = T("TileWallpaper");
const TCHAR RegWallpaperStyle[] = T("WallpaperStyle");
const TCHAR RegIEWallpaperPath[] = T("Software\\Microsoft\\Internet Explorer\\Desktop\\General");
const TCHAR RegWallpaperPath[] = T("Control Panel\\Desktop");
const TCHAR StrX_bg[] = T("X_bg");

const TCHAR arrow[] = T("UDLR");
const TCHAR *arrowJ[] = {T(""), T(""), T(""), T("")};

const TCHAR WallpaperError[] = T("Wallpaper file not found");

struct CLIPNAMES{
	UINT type;
	TCHAR *name;
} ClipNames[] = {
	{CF_TEXT,			T("Text")},
	{CF_BITMAP,			T("BITMAP")},
	{CF_METAFILEPICT,	T("Meta picture")},
	{CF_SYLK,			T("MS Symbolic data")},
	{CF_DIF,			T("Software Arts' Data Interchange Format")},
	{CF_TIFF,			T("TIFF image")},
	{CF_OEMTEXT,		T("OEM Text")},
	{CF_DIB,			T("DIB BITMAP")},
	{CF_PALETTE,		T("Palette")},
	{CF_PENDATA,		T("Pen data")},
	{CF_RIFF,			T("RIFF data")},
	{CF_WAVE,			T("WAVE")},
	{CF_UNICODETEXT,	T("UNICODE Text")},
	{CF_ENHMETAFILE,	T("Ex Meta picture")},
	{CF_HDROP,			T("Drag files")},
	{CF_LOCALE,			T("Locale")},
	{CF_DIBV5,			T("DIB BITMAP V5")},
	{CF_OWNERDISPLAY,	T("Application draw picture")},
	{CF_DSPTEXT,		T("Private Text")},
	{CF_DSPBITMAP,		T("Private BITMAP")},
	{CF_DSPMETAFILEPICT, T("Private Meta picture")},
	{CF_DSPENHMETAFILE,	T("Private Ex Meta picture")},
	{0, NULL}
};

#define xDWM_BB_ENABLE B0
#define xDWM_BB_BLURREGION B1
#define xDWM_BB_TRANSITIONONMAXIMIZED B2

typedef struct tagDWM_BLURBEHIND {
	DWORD dwFlags;
	BOOL fEnable;
	HRGN hRgnBlur;
	BOOL fTransitionOnMaximized;
} xDWM_BLURBEHIND;

typedef struct {
	BYTE BlendOp;
	BYTE BlendFlags;
	BYTE SourceConstantAlpha;
	BYTE AlphaFormat;
} xBLENDFUNCTION;

typedef struct
{
	DWORD attribute;
	PVOID pData;
	ULONG dataSize;
} xWINCOMPATTRDATA;

typedef struct
{
	int nAccentState;
	int nFlags;
	int nColor;
	int nAnimationId;
} xACCENTPOLICY;

const xDWM_BLURBEHIND dwm_opaque = { xDWM_BB_ENABLE, FALSE, NULL, FALSE};
const xDWM_BLURBEHIND dwm_transparent = { xDWM_BB_ENABLE, TRUE, NULL, FALSE};

xBLENDFUNCTION DefaultBlend = {
	/* BlendOp */ AC_SRC_OVER, /* BlendFlags */ 0,
	/* SourceConstantAlpha */ 255, /* AlphaFormat */ AC_SRC_ALPHA
};

xACCENTPOLICY BackAccent = {3, 0, 0, 0};
xWINCOMPATTRDATA BackComp = {19, &BackAccent, sizeof(xACCENTPOLICY)};

POINT ZeroPoint = {0, 0};

DefineWinAPI(HRESULT, DwmEnableBlurBehindWindow, (HWND, const xDWM_BLURBEHIND *)) = NULL;
TypedefWinAPI(BOOL, SetLayeredWindowAttributes, (HWND hwnd, COLORREF crKey, BYTE bAlpha, DWORD dwFlags));
DefineWinAPI(BOOL, UpdateLayeredWindow, (HWND hWnd, HDC hdcDst, POINT *pptDst, SIZE *psize, HDC hdcSrc, POINT *pptSrc, COLORREF crKey, xBLENDFUNCTION *pblend, DWORD dwFlags));
DefineWinAPI(BOOL, SetWindowCompositionAttribute, (HWND, xWINCOMPATTRDATA*)) = NULL; // Win7 ȍ~

DLLDEFINED ValueWinAPI(SetLayeredWindowAttributes) DLLPARAM(NULL);

//HKEY_CURRENT_USER\Control Panel\Desktop\Wallpaper
//HKEY_CURRENT_USER\Control Panel\Desktop\WallpaperStyle
//HKEY_CURRENT_USER\Control Panel\Desktop\TitleWallpaper

const int PPxMouseButtonCode[] = {
	MOUSEBUTTON_L, MOUSEBUTTON_R, MOUSEBUTTON_ETC, MOUSEBUTTON_ETC,
	MOUSEBUTTON_M, MOUSEBUTTON_X, MOUSEBUTTON_Y, MOUSEBUTTON_Z,
	0
};
const TCHAR PPxMouseButtonChar[] = T(" LRMWXYZ?");

//-----------------------------------------------------------------------------
#if !NODLL
// p̑啶
TCHAR USEFASTCALL upper(TCHAR c)
{
	if ( Islower(c) ) c -= (TCHAR)0x20;
	return c;
}
#endif
// Nbv{[h̎ޖ߂
void GetClipboardTypeName(TCHAR *str, UINT cliptype)
{
	if ( !GetClipboardFormatName(cliptype, str, 64) ){
		struct CLIPNAMES *cp;

		thprintf(str, 32, T("Unknown type:%x"), cliptype);
		for ( cp = ClipNames ; cp->type ; cp++ ){
			if ( cp->type == cliptype ){
				tstrcpy(str, cp->name);
				break;
			}
		}
	}
}
//-----------------------------------------------------------------------------
// }EX̉́Es
int CheckXMouseButton(WPARAM wParam)
{
	DWORD flags;

	flags = HIWORD(wParam);
	if ( flags & XBUTTON1 ) return 1;	// X
	if ( flags & XBUTTON2 ) return 2;	// Y
	if ( flags & B2 ) return 3;			// Z
	return 0;
}

// MOUSESTATE \̂̏
void PPxInitMouseButton(MOUSESTATE *ms)
{
	ms->mode = MOUSEMODE_NONE;
	ms->PushButton = MOUSEBUTTON_CANCEL;
}

// {^̃LZ
void PPxCancelMouseButton(MOUSESTATE *ms)
{
	ms->mode = MOUSEMODE_NONE;
	ms->PushButton = MOUSEBUTTON_CANCEL;
	ReleaseCapture(); //  WM_CAPTURECHANGED o
}

// CӃ{^擾
int PPxGetMouseButtonDownInfo(MOUSESTATE *ms, HWND hWnd, DWORD button, LPARAM lParam)
{
	const int *p;

	LPARAMtoPOINT(ms->PushClientPoint, lParam);
	ms->PushScreenPoint = ms->PushClientPoint;
	ClientToScreen(hWnd, &ms->PushScreenPoint);

	// {^
	ms->PushButton = MOUSEBUTTON_ETC;
	for ( p = PPxMouseButtonCode ; *p ; p++ ){
		if ( button & 1 ){
			ms->PushButton = *p;
			break;
		}
		button >>= 1;
	}
	return ms->PushButton;
}

// CӃ{^̉
// PPxDownMouseButtonX() ݂B
int PPxDownMouseButton(MOUSESTATE *ms, HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	DWORD button;

	button = wParam & MOUSEBUTTONMASK;

	// 2ȏ{^Ă邩H
	if ( !((button > 0) && ((button & (button - 1)) == 0)) ){ //bit̂?
		// EȊO̓LZ
		// hbOELZ?
		if ( button != (MK_LBUTTON | MK_RBUTTON) ){
			PPxCancelMouseButton(ms);
			return MOUSEBUTTON_CANCEL;
		}
		if ( ms->PushButton != MOUSEBUTTON_CANCEL ){
			ms->PushButton = MOUSEBUTTON_W;
			ms->mode = MOUSEMODE_PUSH;
		}
	}else{	// Ă{^͂P̂݁VK
		int x = GetSystemMetrics(SM_CXDRAG);
		int y = GetSystemMetrics(SM_CYDRAG);

		ms->mode = MOUSEMODE_PUSH;
		SetCapture(hWnd);
		PPxGetMouseButtonDownInfo(ms, hWnd, button, lParam);
		ms->DDRect.left   = ms->PushScreenPoint.x - x;
		ms->DDRect.right  = ms->PushScreenPoint.x + x;
		ms->DDRect.top    = ms->PushScreenPoint.y - y;
		ms->DDRect.bottom = ms->PushScreenPoint.y + y;
		ms->MovedClientPoint = ms->PushClientPoint;
		ms->MovedScreenPoint = ms->PushScreenPoint;
	}
	ms->PushTick = GetTickCount();
	return ms->PushButton;
}

// CӃ{^̗
int PPxUpMouseButton(MOUSESTATE *ms, WPARAM wParam)
{
	DWORD button;
	int pushbutton;

	if ( ms->PushButton <= MOUSEBUTTON_CANCEL ) return MOUSEBUTTON_CANCEL;
	button = wParam & MOUSEBUTTONMASK;
								// ł܂̃{^Ă
	if ( button != 0 ) return MOUSEBUTTON_CANCEL;
	pushbutton = ms->PushButton;
	ms->PushTick = GetTickCount() - ms->PushTick;
	PPxCancelMouseButton(ms);
	return pushbutton;
}

// CӃ{^̃_uNbN
int PPxDoubleClickMouseButton(MOUSESTATE *ms, HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	// MOUSEBUTTON_CANCEL_DOUBLE  e{^ĂԂȂ瑀얳
	if ( ms->PushButton != MOUSEBUTTON_CANCEL ) return MOUSEBUTTON_CANCEL;
	ms->mode = MOUSEMODE_NONE;
	ReleaseCapture();
	return PPxGetMouseButtonDownInfo(ms, hWnd, wParam & MOUSEBUTTONMASK, lParam);
}

// }EXJ[\̈ړ
BOOL PPxMoveMouse(MOUSESTATE *ms, HWND hWnd, LPARAM lParam)
{
	POINT clipos, scrpos;
	BOOL result = FALSE;

	if ( ms->PushButton <= MOUSEBUTTON_CANCEL ) return FALSE; // LZ

	LPARAMtoPOINT(clipos, lParam);
	scrpos = clipos;
	ClientToScreen(hWnd, &scrpos);

	if ( ms->mode == MOUSEMODE_PUSH ){	// hbOo
		if ( IsTrue(PtInRect(&ms->DDRect, scrpos)) ) return FALSE; // ω
		result = TRUE;
		ms->mode = MOUSEMODE_DRAG;
	}
	ms->MovedClientPoint = clipos;
	// hbOʌo
	ms->MovedOffset.cx = scrpos.x - ms->MovedScreenPoint.x;
	ms->MovedOffset.cy = scrpos.y - ms->MovedScreenPoint.y;
	ms->MovedScreenPoint = scrpos;
	return result;
}

#define WHEEL_REENTRYFLAG 0x4000 // ē`FbNp
// zC[
int PPxWheelMouse(MOUSESTATE *ms, HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	int now, delta;

	if ( X_awhel && !(wParam & WHEEL_REENTRYFLAG) ){
		POINT pos;
		HWND hTwnd;

		LPARAMtoPOINT(pos, lParam);
		hTwnd = WindowFromPoint(pos);
		if ( hTwnd != hWnd ){
			SendMessage(hTwnd, WM_MOUSEWHEEL, wParam | WHEEL_REENTRYFLAG, lParam);
			return 0;
		}
	}
	now = HISHORTINT(wParam);
	if ( (ms->WheelDelta ^ now) & B31 ){
		ms->WheelDelta = 0; // Overflow
	}
	ms->WheelDelta += now;
	delta = ms->WheelDelta / (WHEEL_DELTA / WHEEL_STANDARD_LINES);
	ms->WheelDelta -= delta * (WHEEL_DELTA / WHEEL_STANDARD_LINES);
	return delta;
}

BOOL PPxCheckMouseGesture(MOUSESTATE *stat, TCHAR *textbuf, const TCHAR *keyname)
{
	POINT delta, abs;
	TCHAR GestureStep;
	TCHAR cmd[64];

	if ( (stat->gesture.count + 1) >= MAXGESTURES ) return FALSE;
												// o
	delta.x = stat->MovedScreenPoint.x - stat->PushScreenPoint.x;
	delta.y = stat->MovedScreenPoint.y - stat->PushScreenPoint.y;
	abs.x = delta.x >= 0 ? delta.x : -delta.x;
	abs.y = delta.y >= 0 ? delta.y : -delta.y;
	if ( abs.x > abs.y ){
		GestureStep = ( delta.x >= 0 ) ? (TCHAR)'R' : (TCHAR)'L';
	}else{
		GestureStep = ( delta.y >= 0 ) ? (TCHAR)'D' : (TCHAR)'U';
	}
												// DD Đݒ
	delta.x = GetSystemMetrics(SM_CXDOUBLECLK) * 2;
	delta.y = GetSystemMetrics(SM_CYDOUBLECLK) * 2;

	stat->PushClientPoint = stat->MovedClientPoint;
	stat->PushScreenPoint = stat->MovedScreenPoint;
	stat->DDRect.left   = stat->PushScreenPoint.x - delta.x;
	stat->DDRect.right  = stat->PushScreenPoint.x + delta.x;
	stat->DDRect.top    = stat->PushScreenPoint.y - delta.y;
	stat->DDRect.bottom = stat->PushScreenPoint.y + delta.y;
												// ͖
	if ( stat->gesture.count &&
		(stat->gesture.step[stat->gesture.count - 1] == GestureStep) ){
		return FALSE;
	}

	stat->gesture.step[stat->gesture.count++] = GestureStep;
	stat->gesture.step[stat->gesture.count] = '\0';

#ifdef UNICODE
	if ( (OSver.dwMajorVersion >= 6) || (LOWORD(GetUserDefaultLCID()) == LCID_JAPANESE) )
#else
	if ( LOWORD(GetUserDefaultLCID()) == LCID_JAPANESE )
#endif
	{
		TCHAR *src, *dest;

		for ( src = stat->gesture.step, dest = textbuf ; *src ;  ){
			int direction;
			switch ( *src++ ){
				case 'U':
					direction = 0;
					break;
				case 'D':
					direction = 1;
					break;
				case 'L':
					direction = 2;
					break;
//				case 'R':	// default ƌp
				default:
					direction = 3;
					break;
			}
			*dest++ = arrowJ[direction][0];
			#ifndef UNICODE
			*dest++ = arrowJ[direction][1];
			#endif
		}
		*dest = '\0';
	}else{
		tstrcpy(textbuf, stat->gesture.step);
	}
	thprintf(cmd, TSIZEOF(cmd), T("RG_%s"), stat->gesture.step);
	if ( IsExistCustTable(keyname, cmd) ){
		tstrcat(textbuf, T(" - hit"));
	}
	return TRUE;
}

#if !NODLL
WORD FixCharKeycode(WORD key)
{
	if ( IslowerA(key) ) key -= (WORD)0x20;	// 
	if ( IsalnumA(key) || (key <= 0x20)){
		key |= (WORD)GetShiftKey();
	}else{
		key |= (WORD)(GetShiftKey() & ~K_s);
	}
																// ctrl + char
	if ( (key & K_c) && ((key & 0xff) < 0x20) ) key += (WORD)0x40;
	return key;
}
#endif
//-----------------------------------------------------------------------------
// wi摜
void UnloadWallpaper(BGSTRUCT *bg)
{
	if ( bg->X_WallpaperType == 0 ) return;
	if ( bg->X_WPbmp.DIB != NULL ){
		FreeBMP(&bg->X_WPbmp);
		DxDrawFreeBMPCache(&bg->WPbmpCache);
	}
	bg->X_WallpaperType = 0;
/*
	if ( hDwmapi != NULL ){
		DDwmEnableBlurBehindWindow = NULL;
		FreeLibrary(hDwmapi);
		hDwmapi = NULL;
	}
*/
}

// wi摜̓ǂݍ݂s
void LoadWallpaper(BGSTRUCT *bg, HWND hWnd, const TCHAR *regid)
{
	TCHAR buf[VFPS];
	TCHAR rpath[VFPS];
	const TCHAR *ptr;
	int opaque, mode;
	int bright = 100;
	int dispW, dispH;

	if ( X_fles == 2 ){ // 
		if ( DSetLayeredWindowAttributes == NULL ){
			HMODULE hUser32;

			hUser32 = GetModuleHandle(StrUser32DLL);
			GETDLLPROC(hUser32, SetLayeredWindowAttributes);
			GETDLLPROC(hUser32, UpdateLayeredWindow);
		}
		if ( DSetLayeredWindowAttributes != NULL ){
			SetWindowLong(hWnd, GWL_EXSTYLE,
					GetWindowLong(hWnd, GWL_EXSTYLE) | WS_EX_LAYERED);
		}
		return;
	}
	// x̐ݒ -----
	opaque = 100;
	buf[0] = '\0';
	thprintf(rpath, TSIZEOF(rpath), T("O_%s"), regid);
	if ( NO_ERROR != GetCustTable(StrX_bg, rpath, &buf, sizeof(buf)) ){
		GetCustTable(StrX_bg, T("Opaque"), &buf, sizeof(buf));
	}
	if ( buf[0] != '\0' ){
		ptr = buf;
		opaque = GetIntNumber(&ptr);
	}
	if ( opaque >= 100 ){ // ʏ\
		if ( DSetLayeredWindowAttributes != NULL ){
			SetWindowLong(hWnd, GWL_EXSTYLE,
					GetWindowLong(hWnd, GWL_EXSTYLE) & ~WS_EX_LAYERED);
		}
		if ( DDwmEnableBlurBehindWindow != NULL ){
			DDwmEnableBlurBehindWindow(hWnd, &dwm_opaque);
		}
	}else{ // \
		if ( opaque < 0 ){ // aero ȍ~Ή
			if ( hDwmapi == NULL ) hDwmapi = LoadSystemDLL(SYSTEMDLL_DWMAPI);
			if ( hDwmapi != NULL ){
				GETDLLPROC(hDwmapi, DwmEnableBlurBehindWindow);
				DDwmEnableBlurBehindWindow(hWnd, &dwm_transparent);
				if ( OSver.dwMajorVersion >= 10 ){
					HMODULE hUser32;

					hUser32 = GetModuleHandle(StrUser32DLL);
					GETDLLPROC(hUser32, SetWindowCompositionAttribute);
					if ( DSetWindowCompositionAttribute != NULL ){
						// Win8ȍ~Awǋ@\ȂB
						// Win10̂ݎqEBhEE^Cgo[Ŏgp\
						DSetWindowCompositionAttribute(hWnd, &BackComp);
					}
				}
			}
		}else{
			if ( DSetLayeredWindowAttributes == NULL ){
				HMODULE hUser32;

				hUser32 = GetModuleHandle(StrUser32DLL);
				GETDLLPROC(hUser32, SetLayeredWindowAttributes);
				GETDLLPROC(hUser32, UpdateLayeredWindow);
			}
			if ( (DSetLayeredWindowAttributes != NULL) && (GetParent(hWnd) == NULL) ){
				SetWindowLong(hWnd, GWL_EXSTYLE,
						GetWindowLong(hWnd, GWL_EXSTYLE) | WS_EX_LAYERED);
				if ( X_fles != 2 ){
					if ( opaque ){ // 
						DSetLayeredWindowAttributes(hWnd, 0,
							(BYTE)((255 * opaque)/ 100), LWA_ALPHA);
					}else{ // wiF̂ݓ
						DSetLayeredWindowAttributes(hWnd, C_back, 0, LWA_COLORKEY);
					}
				}
			}
		}
	}
	if ( bg == NULL ) return;
	// ǎ̐ݒ -----
							// ǎgp邩ǂ𔻕
	buf[0] = '\0';
	thprintf(rpath, TSIZEOF(rpath), T("T_%s"), regid);
	if ( NO_ERROR != GetCustTable(StrX_bg, rpath, &buf, sizeof(buf)) ){
		if ( NO_ERROR != GetCustTable(StrX_bg, T("Type"), &buf, sizeof(buf)) ){
			UnloadWallpaper(bg);
			return;
		}
	}

	ptr = buf;
	mode = GetIntNumber(&ptr);	// 󗓂Ȃ 0
	if ( mode == 0 ){
		UnloadWallpaper(bg);
		return;
	}

	if ( mode == 10 ){
		buf[0] = '\0';
		GetRegString(HKEY_CURRENT_USER,
				RegIEWallpaperPath, RegWallpaperTile, buf, TSIZEOF(buf));
		if ( buf[0] == '1' ) mode = 11;
	}
	if ( mode == 20 ){
		if ( GetParent(hWnd) == NULL ) mode = 1;
	}
							// 邳擾
	buf[0] = '\0';
	thprintf(rpath, TSIZEOF(rpath), T("B_%s"), regid);
	if ( NO_ERROR != GetCustTable(StrX_bg, rpath, &buf, sizeof(buf)) ){
		GetCustTable(StrX_bg, T("Bright"), &buf, sizeof(buf));
	}
	if ( buf[0] != '\0' ){
		ptr = buf;
		bright = GetIntNumber(&ptr);
	}
							// gpǎ肷
	buf[0] = '\0';
	thprintf(rpath, TSIZEOF(rpath), T("P_%s"), regid);
	if ( NO_ERROR != GetCustTable(StrX_bg, rpath, &buf, sizeof(buf)) ){
		GetCustTable(StrX_bg, T("Path"), &buf, sizeof(buf));
	}
	if ( buf[0] != '\0' ){
		VFSFixPath(NULL, buf, NULL, VFSFIX_FULLPATH | VFSFIX_REALPATH);
	}else{
		GetRegString(HKEY_CURRENT_USER,
				RegIEWallpaperPath, RegWallpaperName, buf, TSIZEOF(buf));
		if ( GetFileAttributesL(buf) == BADATTR ) buf[0] = '\0';
		if ( buf[0] == '\0' ){
			GetRegString(HKEY_CURRENT_USER,
					RegWallpaperPath, RegWallpaperName, buf, TSIZEOF(buf));
		}
	}

	if ( (buf[0] != '\0') && (GetFileAttributesL(buf) == BADATTR) ){
		SendMessage(hWnd, WM_PPXCOMMAND, TMAKEWPARAM(K_SETPOPMSG, POPMSG_MSG),
			(LPARAM)WallpaperError);
		return;
	}

	DIRECTXDEFINE(bg->WPbmpCache = NULL);
	bg->X_WallpaperType = LoadBMP(&bg->X_WPbmp, buf, bright) == FALSE ? 0 : mode;
	if ( bg->X_WallpaperType != 10 ) return;

	buf[0] = '\0';
	GetRegString(HKEY_CURRENT_USER,
			RegWallpaperPath, RegWallpaperStyle, buf, TSIZEOF(buf));
	if ( buf[0] <= '0' ) return; // XN[TCYɊg傷KvȂ
	// 2:Ƃɂ 6:cv Ȃ͋ 10:v c͂͂ݏo

	{
		HDC hDC;

		hDC = GetDC(hWnd);
		dispW = GetDeviceCaps(hDC, HORZRES); // 
		dispH = GetDeviceCaps(hDC, VERTRES); // c
		ReleaseDC(hWnd, hDC);
	}

	if ( ( dispW == bg->X_WPbmp.size.cx ) &&
		 ( dispH == bg->X_WPbmp.size.cy ) ){
		return; // TCYȂ̂ŕύXsv
	}

	if ( (OSver.dwMajorVersion >= 6) || (bg->X_WPbmp.DIB->biBitCount > 8) ){
		HDC hDC, hMDC;
		LPVOID lpBits;
		BITMAPINFO *bmpinfo;
		int olds;
		size_t bmpsize, bitsize;
		HBITMAP hBMP;
		HGDIOBJ hOldBMP;
		int srcx, srcy, srcw, srch;
		int dstx, dsty, dstw, dsth;
		HPALETTE hOldPal C4701CHECK;

		bmpsize = bg->X_WPbmp.DIB->biClrUsed;
		bmpsize = bg->X_WPbmp.PaletteOffset +
			( bmpsize ? bmpsize * sizeof(RGBQUAD) :
			  ((bg->X_WPbmp.DIB->biBitCount <= 8) ? ((size_t)1 << bg->X_WPbmp.DIB->biBitCount) * sizeof(RGBQUAD) : 0));
		bitsize = (size_t)DwordBitSize(dispW * bg->X_WPbmp.DIB->biBitCount) * dispH;

		hDC = GetDC(hWnd);
		hMDC = CreateCompatibleDC(hDC);
		bmpinfo = (BITMAPINFO *)LocalAlloc(LMEM_FIXED, bmpsize + bitsize);

		memcpy(bmpinfo, bg->X_WPbmp.DIB, bmpsize);
		bmpinfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bmpinfo->bmiHeader.biWidth = dispW;
		bmpinfo->bmiHeader.biHeight = dispH;
		bmpinfo->bmiHeader.biCompression = BI_RGB;

		srcx = srcy = dstx = dsty = 0;
		srcw = bg->X_WPbmp.size.cx;
		srch = bg->X_WPbmp.size.cy;
		dstw = dispW;
		dsth = dispH;

		if ( buf[0] == '1' ){ // v
			dsth = (srch * dstw) / srcw;
			dsty = (dispH - dsth) / 2;
		}else if ( buf[0] == '6' ){ // cv
			dstw = (srcw * dsth) / srch;
			dstx = (dispW - dstw) / 2;
		}

		// gk
		hBMP = CreateDIBSection(hDC, bmpinfo, DIB_RGB_COLORS, &lpBits, NULL, 0);
		hOldBMP = SelectObject(hMDC, hBMP);
		olds = SetStretchBltMode(hMDC, HALFTONE);

		if ( bg->X_WPbmp.hPalette != NULL ){
			hOldPal = SelectPalette(hMDC, bg->X_WPbmp.hPalette, FALSE);
			RealizePalette(hMDC);
		}
		StretchDIBits(hMDC, dstx, dsty, dstw, dsth, srcx, srcy, srcw, srch,
			bg->X_WPbmp.bits, (BITMAPINFO *)bg->X_WPbmp.DIB,
			DIB_RGB_COLORS, SRCCOPY);

		if ( bg->X_WPbmp.hPalette != NULL ){
			SelectPalette(hDC, hOldPal, FALSE); // C4701ok
		}

		SetStretchBltMode(hMDC, olds);
		SelectObject(hMDC, hOldBMP);

		// Vrbg}bvݒ
		if ( bg->X_WPbmp.info != NULL ){
			LocalUnlock(bg->X_WPbmp.info);
			LocalFree(bg->X_WPbmp.info);
		}
		bg->X_WPbmp.DIB = &bmpinfo->bmiHeader;
		bg->X_WPbmp.info = bmpinfo;
		bg->X_WPbmp.bits = (BYTE *)bmpinfo + bmpsize;
		memcpy(bg->X_WPbmp.bits, lpBits, bitsize);
		bg->X_WPbmp.size.cx = dispW;
		bg->X_WPbmp.size.cy = dispH;

		DeleteObject(hBMP);
		DeleteDC(hMDC);
		ReleaseDC(hWnd, hDC);
	}
}

// wi摜̕\s
void DrawWallPaper(DIRECTXARG(DXDRAWSTRUCT *DxDraw) BGSTRUCT *bg, HWND hWnd, PAINTSTRUCT *ps, int Areax)
{
	int x, y, xm;
	POINT pos;
	RECT desk;
	#ifdef USEDIRECTX
		RECT client;
	#endif

	switch ( bg->X_WallpaperType & ~B30 ){
		case 3:		// 
			xm = -(bg->X_WPbmp.size.cx - (Areax % bg->X_WPbmp.size.cx) );
			y = 0;
			break;

		case 20:	// ̉()
			GetWindowRect(GetParent(hWnd), &desk);
			pos.x = desk.left;
			pos.y = desk.top;
			ScreenToClient(hWnd, &pos);
			xm = (pos.x % bg->X_WPbmp.size.cx);
			if ( xm > 0 ) xm -= bg->X_WPbmp.size.cx;
			y = (pos.y % bg->X_WPbmp.size.cy);
			if ( y > 0 ) y -= bg->X_WPbmp.size.cy;
			break;

		case 10:	// fXNgbv(Tile mode)
			GetDesktopRect(hWnd, &desk);
			pos.x = desk.left;
			pos.y = desk.top;
			ScreenToClient(hWnd, &pos);
			xm = (pos.x % bg->X_WPbmp.size.cx);
			if ( xm > 0 ) xm -= bg->X_WPbmp.size.cx;
			y = (pos.y % bg->X_WPbmp.size.cy);
			if ( y > 0 ) y -= bg->X_WPbmp.size.cy;
			break;

		case 11:	// fXNgbv()
			GetDesktopRect(hWnd, &desk);
			pos.x = desk.left +
				((desk.right - desk.left) - bg->X_WPbmp.size.cx) / 2;
			pos.y = desk.top +
				((desk.bottom - desk.top) - bg->X_WPbmp.size.cy) / 2;
			ScreenToClient(hWnd, &pos);
			xm = (pos.x % bg->X_WPbmp.size.cx);
			if ( xm > 0 ) xm -= bg->X_WPbmp.size.cx;
			y = (pos.y % bg->X_WPbmp.size.cy);
			if ( y > 0 ) y -= bg->X_WPbmp.size.cy;
			break;

		default:	// (0)E
			xm = y = 0;
	}
	if ( bg->X_WallpaperType & ~B30 ){
		#ifdef USEDIRECTX
		GetClientRect(hWnd, &client);
		#endif
		for ( ; y < ps->rcPaint.bottom ; y += bg->X_WPbmp.size.cy ){
			for ( x = xm ; x < ps->rcPaint.right ; x += bg->X_WPbmp.size.cx ){
			#ifdef USEDIRECTX
				IfDXmode(ps->hdc){
					desk.left = x;
					desk.top = y;
					desk.right = bg->X_WPbmp.size.cx;
					desk.bottom = bg->X_WPbmp.size.cy;
					DxDrawDIB(DxDraw, bg->X_WPbmp.DIB, bg->X_WPbmp.bits, &desk, &client, &bg->WPbmpCache);
				}else
			#endif
				{
					DrawBMP(ps->hdc, &bg->X_WPbmp, x, y);
				}
			}
		}
	}
}

void InitOffScreen(BGSTRUCT *bg, HDC hWndDC, SIZE *WndSize)
{
	HBITMAP hMemBmp;

	if ( bg->hOffScreenDC != NULL ){
		if ( X_fles == 2 ){
			int size;
			BYTE *p;
			DWORD newbg;

			newbg = 0xffffffff; // C_back;
			size = WndSize->cx * WndSize->cy;
			for ( p = bg->DCBitsPtr ; size ; size-- ){
				*(COLORREF *)p = newbg;
				p += 4;
			}
		}

		return;
	}

	bg->hOffScreenDC = CreateCompatibleDC(hWndDC);
	if ( X_fles != 2 ){
		X_fles = 1;
		hMemBmp = CreateCompatibleBitmap(hWndDC, WndSize->cx, WndSize->cy);
	}else{
		BITMAPINFOHEADER bi;

		memset(&bi, 0, sizeof(BITMAPINFOHEADER));
		bi.biSize = sizeof(BITMAPINFOHEADER);
		bi.biWidth = WndSize->cx;
		bi.biHeight = WndSize->cy;
		bi.biPlanes = 1;
		bi.biBitCount = 32;

		hMemBmp = CreateDIBSection(bg->hOffScreenDC, (BITMAPINFO *)&bi, DIB_RGB_COLORS, (void **)&bg->DCBitsPtr, NULL, 0);
	}
	bg->hOldBitmap = SelectObject(bg->hOffScreenDC, hMemBmp);
}

void OffScreenToScreen(BGSTRUCT *bg, HWND hWnd, HDC hWndDC, RECT *WndRect, SIZE *WndSize)
{
	if ( (X_fles != 2) || (WndRect == NULL) ){
		BitBlt(hWndDC, 0, 0, WndSize->cx, WndSize->cy, bg->hOffScreenDC, 0, 0, SRCCOPY);
	}else{
		HDC hScreenDC;
		POINT wndPos;

		hScreenDC = GetDC(hWnd);
		wndPos.x = WndRect->left;
		wndPos.y = WndRect->top;

		if ( DUpdateLayeredWindow == NULL ){
			HMODULE hUser32;
			hUser32 = GetModuleHandle(StrUser32DLL);
			GETDLLPROC(hUser32, UpdateLayeredWindow);
			if ( DUpdateLayeredWindow == NULL ){
				BitBlt(hWndDC, 0, 0, WndSize->cx, WndSize->cy, bg->hOffScreenDC, 0, 0, SRCCOPY);
				return;
			}
		}

		{
			int size;
			BYTE *pixp;
			DWORD c, bgc, NewBgc;

			#define TRPAR 0x80
#if 0		// ABGR
			bgc = C_back;
			NewBgc = (((((C_back & 0xff00ff) * TRPAR) & 0xff00ff00) | (((C_back & 0xff00) * TRPAR) & 0xff0000)) >> 8) | (TRPAR << 24);
#else		// ARGB
			bgc = ((C_back & 0xff) << 16) | (C_back & 0xff00) | ((C_back & 0xff0000) >> 16);
			NewBgc = ((((C_back & 0x0000ff) * TRPAR) & 0x00ff00) << 8) |
					((((C_back & 0x00ff00) * TRPAR) & 0xff0000) >> 8) |
					(((C_back & 0xff0000) * TRPAR) >> 24) |
					(TRPAR << 24);
#endif
			#undef TRPAR

			#define TRPAR 0xf0
			size = WndSize->cx * WndSize->cy;
			for ( pixp = bg->DCBitsPtr ; size ; size-- ){
				c = *(DWORD *)pixp;
				if ( c == bgc ){
					*(DWORD *)pixp = NewBgc;
				}else{
					*(DWORD *)pixp = (((((c & 0xff00ff) * TRPAR) & 0xff00ff00) + (((c & 0xff00) * TRPAR) & 0xff0000)) >> 8) | (TRPAR << 24);
				}
				pixp += sizeof(DWORD);
			}
			#undef TRPAR
		}

		DUpdateLayeredWindow(hWnd, hScreenDC, &wndPos, WndSize, bg->hOffScreenDC, &ZeroPoint, 0, &DefaultBlend, ULW_ALPHA);
		ReleaseDC(hWnd, hScreenDC);
	}
}

// zXN[
void FreeOffScreen(BGSTRUCT *bg)
{
	if ( bg->hOffScreenDC == NULL ) return;

	DeleteObject(SelectObject(bg->hOffScreenDC, bg->hOldBitmap));
	DeleteDC(bg->hOffScreenDC);
	bg->hOffScreenDC = NULL;
}
#if 0
int PreviewCommand(BGSTRUCT *bg, const TCHAR *param, const TCHAR *path)
{
	if ( param[0] == '\0' ){
		UnloadWallpaper(bg);
		return 0;
	}else{
		TCHAR buf[VFPS];
		int result;

		VFSFullPath(buf, (TCHAR *)param, path);
		result = LoadBMP(&bg->X_WPbmp, buf, 50);
		bg->X_WallpaperType = result;
		return result;
	}
}
#endif
DWORD CalcBmpHeaderSize(BITMAPINFOHEADER *dumpdata)
{
	DWORD offset, color, palette;

	offset = dumpdata->biSize;
	if ( offset < sizeof(BITMAPINFOHEADER) ){
												// OS/2 `
		color = ((BITMAPCOREHEADER *)dumpdata)->bcBitCount;
		if ( color <= 8 ) offset += (1 << color) * (DWORD)sizeof(RGBTRIPLE);
	}else{								// WINDOWS `
		color = dumpdata->biBitCount;
		palette = dumpdata->biClrUsed;
		if ( (offset < (sizeof(BITMAPINFOHEADER) + 12) ) && (dumpdata->biCompression == BI_BITFIELDS) ){
			offset += 12;	// 16/32bit ̂Ƃ̓rbg蓖Ă
		}

		palette = palette ? palette * sizeof(RGBQUAD) :
				((color <= 8) ? (1 << color) * (DWORD)sizeof(RGBQUAD) : 0);

		if ( offset == 0x7c/*BITMAPV5HEADER*/ ){
			DWORD ProfileData = *(DWORD *)((BYTE *)dumpdata + 0x70); //bV5ProfileData
			if ( (offset + palette) == ProfileData ){
				offset += *(DWORD *)((BYTE *)dumpdata + 0x74); //bV5ProfileSize
			}
		}
		offset += palette;
	}
	return offset;
}


// F _AUTO ȂVXe̐F擾 ------------------------------------------
/*
void AutoColor(const TCHAR *str, COLORREF *clr, int def)
{
	GetCustData(str, clr, sizeof(COLORREF));
	if ( *clr == C_AUTO ) *clr = GetSysColor(def);
}
*/
void LoadHiddenMenu(HIDDENMENUS *hms, const TCHAR *name, HANDLE heap, COLORREF mes)
{
	int size, width = HiddenMenu_MinLen;
	HIDDENMENUSTRUCT *tbl;
	char **hmdata;
	int items;

	if ( hms->data != NULL ) HeapFree(heap, 0, hms->data);
	hms->item = hms->width = 0;
	hms->data = NULL;

	size = GetCustDataSize(name);
	items = CountCustTable(name);
	if ( items <= 0 ) return;

	hms->data = hmdata = HeapAlloc(heap, 0, size + sizeof(TCHAR *) * items);
	if ( hmdata == NULL ) return;
	tbl = (HIDDENMENUSTRUCT *)((char *)hmdata + sizeof(TCHAR *) * items);
	GetCustData(name, tbl, size);

	for ( ; ; ){
		DWORD w;
		int namelen;
		COLORREF *color;

		w = (DWORD)tbl->offset;
		if ( w == 0 ) break;

		namelen = tstrlen(tbl->name);
		tbl->offset = (WORD)namelen;
		color = (COLORREF *)(char *)((char *)tbl->name + namelen * sizeof(TCHAR) + sizeof(TCHAR));

		if ( color[HiddenMenu_ColorF] == C_AUTO ){
			color[HiddenMenu_ColorF] = mes; // tbl->fg
		}
		if ( color[HiddenMenu_ColorB] == C_AUTO ){
			color[HiddenMenu_ColorB] = C_back; // tbl->bg
		}

		if ( hms->item == 0 ){ // 1ږڂ̃R}hC̏ꍇ̓j[𖳌ɂ
			TCHAR *cmd = (TCHAR *)&color[2];

			if ( (cmd[0] == '\0') || (cmd[1] == '\0') ) break;
		}
		#ifdef UNICODE
		{ // `敝ȈՔ
			const TCHAR *ptr;

			namelen = 0;
			ptr = tbl->name;
			while( *ptr != '\0' ) namelen += ((UTCHAR)*ptr++ >= 0x2b0) ? 2 : 1;
		}
		#endif
		if ( width < namelen ) width = namelen;

		*hmdata = (char *)tbl->name;
		tbl = (HIDDENMENUSTRUCT *)((char *)tbl + w);
		hms->item++;
		hmdata++;
	}
	hms->width = width + 1;
}

#if !NODLL
/*
	FillRect ̒uŁB FillRect ̕xB
	ExtTextOut œhԂ̂FillRect葁APatBltɍy΂
*/
void FillBox(HDC hDC, const RECT *box, HBRUSH hbr)
{
	HGDIOBJ hOldObj;

	hOldObj = SelectObject(hDC, hbr);
	PatBlt(hDC, box->left, box->top,
			box->right - box->left, box->bottom - box->top,
			PATCOPY);
	SelectObject(hDC, hOldObj);
}
#endif

// AppendMenu ̕p --------------------------------------------------
#if !NODLL
void USEFASTCALL AppendMenuString(HMENU hMenu, UINT id, const TCHAR *string)
{
	AppendMenu(hMenu, MF_ES, id, MessageText(string));
}
void USEFASTCALL AppendMenuCheckString(HMENU hMenu, UINT id, const TCHAR *string, BOOL check)
{
	AppendMenu(hMenu, MF_CHKES(check), id, MessageText(string));
}
#endif

const TCHAR SampleFontText[] = T("0123456789");
#define SampleFontItems TSIZEOFSTR(SampleFontText)

int GetAndFixTextMetrics(HDC hDC, TEXTMETRIC *tm)
{
	int result, numX = 0;
	SIZE textsize;

	GetTextMetrics(hDC, tm);
	if ( tm->tmAveCharWidth < 1 ) tm->tmAveCharWidth = 1;

	//  TMPF_FIXED_PITCH ͈Ӗ΂ɂȂĂ
	if ( !(tm->tmPitchAndFamily & TMPF_FIXED_PITCH) ){ // tHg
		// tmAveCharWidth  ƍĂȂȂ␳ ) Ricty Diminished 9pt
		GetTextExtentExPoint(hDC, SampleFontText, 1, 0, NULL, NULL, &textsize);
		if ( textsize.cx > tm->tmAveCharWidth ) tm->tmAveCharWidth = textsize.cx;
		return 0;
	}

//	XMessage(NULL, NULL, XM_DbgLOG, T(">>> %d"),tm->tmAveCharWidth);
	{ // stHg
		int NumWidth[SampleFontItems], *Nptr, i, oldwidth = 0, newwidth, width;

		GetTextExtentExPoint(hDC, SampleFontText, SampleFontItems, 0x7000, &result, NumWidth, &textsize);
		for ( i = 0, Nptr = NumWidth ; i < SampleFontItems ; i++ ){
			newwidth = *Nptr++;
			width = newwidth - oldwidth;
//			XMessage(NULL, NULL, XM_DbgLOG, T("%c %d"),SampleFontText[i],width);
			oldwidth = newwidth;
			if ( width > numX ) numX = width;
		}
		if ( numX > tm->tmAveCharWidth ) tm->tmAveCharWidth = numX;
	}
	return numX;
}

BOOL RecvExecuteByWMCopyData(PPXAPPINFO *info, COPYDATASTRUCT *copydata)
{
	TCHAR cmd[CMDLINESIZE], *cmdbuf;

	if ( copydata->cbData >= 0x3fffffff ) return FALSE;
	if ( copydata->cbData > TSTROFF(CMDLINESIZE) ){
		cmdbuf = HeapAlloc(GetProcessHeap(), 0, copydata->cbData);
		if ( cmdbuf == NULL ) return FALSE;
	}else{
		cmdbuf = cmd;
	}
	memcpy(cmdbuf, copydata->lpData, copydata->cbData);
	if ( LOWORD(copydata->dwData) == 'H' ) ReplyMessage(TRUE);
	PP_ExtractMacro(info->hWnd, info, NULL, cmdbuf, NULL, 0);
	if ( cmdbuf != cmd ) HeapFree(GetProcessHeap(), 0, cmdbuf);
	return TRUE;
}
