/*-----------------------------------------------------------------------------
	Paper Plane vUI										` R[hy[Wؑ `
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include "PPX.H"
#include "PPVUI.RH"
#include "PPV_STRU.H"
#include "PPV_FUNC.H"
#pragma hdrstop

#define FULLCP 0

typedef struct {
	UINT MaxCharSize;
	BYTE DefaultChar[MAX_DEFAULTCHAR];
	BYTE LeadByte[MAX_LEADBYTES];
	WCHAR UnicodeDefaultChar;
	UINT CodePage;
	TCHAR CodePageName[MAX_PATH];
} impCPINFOEX;

DefineWinAPI(BOOL, GetCPInfoEx, (UINT CodePage, DWORD dwFlags, impCPINFOEX *lpCPInfoEx)) = INVALID_VALUE(impGetCPInfoEx);

typedef struct {
	DWORD cp;
	const TCHAR *name;
} CPTBLSTRUCT;
const CPTBLSTRUCT cptbl[] = {
	{CP_ACP,	T("system locale")},
	{CP_OEMCP,	T("system console locale")},
#if FULLCP
	{CP_MACCP,	T("Mac")},
	{37,	T("EBCDIC č/Ji_")},
	{38,	T("International(old)EBCDIC")},
	{42,	T("Symbol")},
	{111,	T("Greek")},
	{112,	T("Turkish")},
	{113,	T("Yugoslavian")},
	{161,	T("Arabic Linux")},
	{162,	T("Arabic Linux")},
	{163,	T("Arabic Linux")},
	{164,	T("Arabic Linux")},
	{165,	T("Arabic Linux")},
	{237,	T("Germany EBCDIC")},
	{274,	T("Belgium EBCDIC")},
	{275,	T("Brazilian EBCDIC")},
	{277,	T("Danish/Norwegian EBCDIC")},
	{281,	T("Japanese-E EBCDIC")},
	{290,	T("Japanese Kana EBCDIC")},
	{367,	T("US-ASCII ISO 646-US")},
#endif
	{CP__US, T("OEM US(MSDOS)")},
#if FULLCP
	{500,	T("EBCDIC C^[iVi")},
	{708,	T("Arabic ASMO-708")},
	{709,	T("Arabic ASMO-449")},
	{710,	T("Arabic Transparent Arabic")},
	{720,	T("Arabic Transparent ASMO")},
	{737,	T("OEM Greek 437G")},
	{775,	T("OEM Baltic")},
#endif
	{850,	T("OEM ML Latin I")},
#if FULLCP
	{852,	T("OEM Xu e II")},
	{855,	T("OEM L VA")},
	{857,	T("OEM gR")},
	{858,	T("OEM e I + [bp")},
	{860,	T("OEM |gK")},
	{861,	T("OEM ACXh")},
	{862,	T("OEM wuC")},
	{863,	T("OEM Ji_ tX")},
	{864,	T("OEM Arabic")},
	{865,	T("OEM mfBbN")},
	{866,	T("OEM VA")},
	{869,	T("OEM ߑMV")},
	{870,	T("EBCDIC }`K")},
	{874,	T("ANSI/OEM Thailand")},
	{875,	T("EBCDIC _MV")},
	{881,	T("ISO 8859-1 Latin 1")},
	{882,	T("ISO 8859-2 Latin 2")},
	{883,	T("ISO 8859-3 Latin 3")},
	{884,	T("ISO 8859-4 Latin 4")},
	{885,	T("ISO 8859-5 Latin 5")},
#endif
	{CP__SJIS,	T("ANSI/OEM Shift-JIS")},
#if FULLCP
	{934,	T("ANSI/OEM ؍")},
	{936,	T("ANSI/OEM ȑ GBK")},
	{938,	T("ANSI/OEM p")},
	{949,	T("ANSI/OEM ؍")},
	{950,	T("ANSI/OEM ɑ Big5")},
	{951,	T("ANSI/OEM ȑ")},
	{1026,	T("EBCDIC Turkish(Latin 5)")},
	{1047,	T("EBCDIC Latin 1  Open System")},
	{1140,	T("EBCDIC č/Ji_")},
	{1141,	T("EBCDIC hCc")},
	{1142,	T("EBCDIC f}[N/mEF[")},
	{1143,	T("EBCDIC tBh/XEF[f")},
	{1144,	T("EBCDIC C^A")},
	{1145,	T("EBCDIC e/XyC")},
	{1146,	T("EBCDIC p")},
	{1147,	T("EBCDIC tX")},
	{1148,	T("EBCDIC C^[iVi")},
	{1149,	T("EBCDIC ACXh")},
	{CP__UTF16L, T("UNICODE little endian ISO10646")},
	{CP__UTF16B, T("UNICODE big endian ISO10646")},
	{1250,	T("ANSI  Europe Latin2")},
	{1251,	T("ANSI Cyrillic")},
#endif
	{CP__LATIN1,	T("ANSI Latin 1")},
#if FULLCP
	{1253,	T("ANSI Greek")},
	{1254,	T("ANSI Turkish")},
	{1255,	T("ANSI Hebrew")},
	{1256,	T("ANSI Arabic")},
	{1257,	T("ANSI Baltic")},
	{1258,	T("ANSI Vietnamese")},
	{1361,	T("Korean Johab")},
	{10000,	T("Mac Standard(roman)")},
	{10001,	T("Mac {")},
	{10002,	T("Mac Big5")},
	{10003,	T("Mac Korea")},
	{10004,	T("Mac Arabic")},
	{10005,	T("Mac Hebrew")},
	{10006,	T("Mac Greek I")},
	{10007,	T("Mac Cyrillic")},
	{10008,	T("Mac GB 2312")},
	{10010,	T("Mac [}jA")},
	{10017,	T("Mac ENCi")},
	{10021,	T("Mac Thai")},
	{10029,	T("Mac Latin 2")},
	{10079,	T("Mac Icelandic")},
	{10081,	T("Mac Turkish")},
	{10082,	T("Mac NA`A")},
	{20000,	T("p CNS")},
	{20001,	T("p TCA")},
	{20002,	T("p Eten")},
	{20003,	T("p IBM5550")},
	{20004,	T("p TeleText")},
	{20005,	T("p Wang")},
	{20105,	T("IA5 IRV C^[iVi No.5")},
	{20106,	T("IA5 hCc")},
	{20107,	T("IA5 XEF[f")},
	{20108,	T("IA5 mEF[")},
	{20127,	T("ASCII US")},
	{20261,	T("T.61")},
	{20269,	T("ISO 6937 Non-Spacing Accent")},
	{20273,	T("EBCDIC hCc")},
	{20277,	T("EBCDIC f}[N/mEF[")},
	{20278,	T("EBCDIC tBh/XEF[f")},
	{20280,	T("EBCDIC C^A")},
	{20284,	T("EBCDIC e/XyC")},
	{20285,	T("EBCDIC p")},
	{20290,	T("EBCDIC {(Jig)")},
	{20297,	T("EBCDIC tX")},
	{20420,	T("EBCDIC ArA")},
	{20423,	T("EBCDIC MV")},
	{20424,	T("EBCDIC wuC")},
	{20833,	T("EBCDIC ؍")},
	{20866,	T("VA KOI8")},
	{20871,	T("EBCDIC ACXh")},
	{20880,	T("EBCDIC L(VA)")},
	{20905,	T("EBCDIC gR")},
	{20924,	T("EBCDIC e 1/Open System")},
	{20932,	T("{ JIS X 0208-1990 0212-1990(EUC-JP)")},
	{20936,	T("ȑ GB2312")},
	{20949,	T("EUC-KR?")},
	{21025,	T("EBCDIC L(ZrA,uKA)")},
	{21027,	T("Ext Alpha Lowercase")},
	{21866,	T("ENCi")},
	{28591,	T("ISO 8859-1 e 1")},
	{28592,	T("ISO 8859-2 [bp")},
	{28593,	T("ISO 8859-3 e 3")},
	{28594,	T("ISO 8859-4 og")},
	{28595,	T("ISO 8859-5 L")},
	{28596,	T("ISO 8859-6 ArA")},
	{28597,	T("ISO 8859-7 MV")},
	{28598,	T("ISO 8859-8 wuC")},
	{28599,	T("ISO 8859-9 e 5")},
	{28605,	T("ISO 8859-15 e 9")},
	{38598,	T("ISO 8859-8 wuC")},
	{CP__JIS,	T("ISO-2022 { JIS X 0202-1984 1byte J^Ji")},
	{50221,	T("ISO-2022 { JIS X 0202-1984 1byte J^JiL")},
	{CP__JISSI,	T("ISO-2022 { JIS X 0201-1989 (RFC 1468)")},
	{50225,	T("ISO-2022 ؍")},
	{50227,	T("ISO-2022 ȑ̎")},
	{50229,	T("ISO-2022 ɑ̎")},
	{50932,	T("JIS auto detect")},
	{50949,	T("KR auto detect")},
	{CP__EUCJP,	T("euc-jp")},
	{51936,	T("GB2312")},
	{51949,	T("EUC ؍")},
	{51950,	T("EUC p")},
	{52936,	T("HZ-GB2312 ȑ̎")},
	{54936,	T("GB18030")},
	{57002,	T("ISCII foiK")},
	{57003,	T("ISCII xK")},
	{57004,	T("ISCII ^~[")},
	{57005,	T("ISCII eO")},
	{57006,	T("ISCII AbT")},
	{57007,	T("ISCII I[")},
	{57008,	T("ISCII Ji")},
	{57009,	T("ISCII }")},
	{57010,	T("ISCII OW[g")},
	{57011,	T("ISCII OL[")},
#endif
	{CP_UTF7,	T("UTF-7")},
	{CP_UTF8,	T("UTF-8")},
	{0xffff, NULL}
};

const TCHAR StrDefault[] = MES_DEFA;
const TCHAR StrSelCP[] = MES_TSCP;
const TCHAR StrUnknown[] = MES_UNKN;

HWND hCodePageWnd;
int CodePageIndex;

BOOL CALLBACK EnumCodePageProc(TCHAR *str)
{
	TCHAR buf[VFPS], buf2[VFPS];
	const TCHAR *ptr;
	DWORD cp;
	impCPINFOEX ciex;
	HWND hListWnd;

	ptr = str;
	cp = (LCID)GetNumber(&ptr);

	if ( DGetCPInfoEx == INVALID_VALUE(impGetCPInfoEx) ){
		GETDLLPROCT(GetModuleHandle(StrKernel32DLL), GetCPInfoEx);
	}
	if ( (DGetCPInfoEx != NULL) && (FALSE != DGetCPInfoEx(cp, 0, &ciex)) ){
		ptr = ciex.CodePageName;
		while ( Isdigit(*ptr) ) ptr++;
		while ( *ptr == ' ' ) ptr++;
	}else{
		const CPTBLSTRUCT *ct = cptbl;

		for( ;; ){
			if ( ct->cp == 0xffff ){
				ptr = MessageText(StrUnknown);
				break;
			}
			if ( ct->cp == cp ){
				ptr = ct->name;
				break;
			}
			ct++;
		}
	}
	thprintf(buf, TSIZEOF(buf), T("%05d - %s"), cp, ptr);

	hListWnd = GetDlgItem(hCodePageWnd, IDL_PT_LIST);
	{
		int midindex, minindex, maxindex;

		minindex = midindex = 1;
		maxindex = CodePageIndex;
		for (;;){
			if ( minindex >= maxindex ){
				if ( minindex == maxindex ){
					midindex = minindex;
				}
				break;
			}

			midindex = (maxindex + minindex) / 2;

			SendMessage(hListWnd, LB_GETTEXT, (WPARAM)midindex, (LPARAM)buf2);
			if ( tstrcmp(buf, buf2) > 0 ){
				minindex = midindex + 1;
			}else{
				maxindex = midindex;
			}
		}

		SendMessage(hListWnd, LB_SETITEMDATA,
			SendMessage(hListWnd, LB_INSERTSTRING, (WPARAM)midindex, (LPARAM)buf)
			, (LPARAM)cp);
	}

	CodePageIndex++;
	return TRUE;
}

INT_PTR CALLBACK GetCodePageDialog(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch(iMsg){
		case WM_INITDIALOG: {
			hCodePageWnd = hDlg;
			CodePageIndex = 1;

			LocalizeDialogText(hDlg, 0);
			SetWindowLongPtr(hDlg, DWLP_USER, (LONG_PTR)lParam);
			SetWindowText(hDlg, MessageText(StrSelCP));
			SendDlgItemMessage(hCodePageWnd, IDL_PT_LIST, LB_ADDSTRING, 0,
					(LPARAM)MessageText(StrDefault));
			SendDlgItemMessage(hCodePageWnd,
					IDL_PT_LIST, LB_SETITEMDATA, (WPARAM)0, (LPARAM)CP_ACP);

			EnumSystemCodePages(EnumCodePageProc, CP_INSTALLED);
			SendDlgItemMessage(hDlg, IDL_PT_LIST, LB_SETCURSEL, 0, 0);
			PostMessage(hDlg, WM_COMMAND, TMAKELPARAM(IDL_PT_LIST, LBN_SELCHANGE), 0);
			return TRUE;
		}
		case WM_COMMAND:
			switch ( LOWORD(wParam) ){
				case IDOK:
					EndDialog(hDlg, 1);
					break;
				case IDCANCEL:
					EndDialog(hDlg, 0);
					break;
				case IDL_PT_LIST:
					if ( HIWORD(wParam) == LBN_SELCHANGE ){
						LRESULT type;

						type = SendMessage((HWND)lParam, LB_GETCURSEL, 0, 0);
						if ( type == LB_ERR ) break;
						*(UINT *)GetWindowLongPtr(hDlg, DWLP_USER) =
								SendMessage((HWND)lParam,
											LB_GETITEMDATA, (WPARAM)type, 0);
					}
					break;
			}
			break;

		case WM_CLOSE:
			EndDialog(hDlg, 0);
			break;

		default:
			return PPxDialogHelper(hDlg, iMsg, wParam, lParam);
	}
	return FALSE;
}

DWORD GetCodePageType(HWND hWnd)
{
	DWORD result = MAX32;

	if ( PPxDialogBoxParam(hInst, MAKEINTRESOURCE(IDD_PASTETYPE),
			hWnd, GetCodePageDialog, (LPARAM)&result) > 0 ){
		return result;
	}else{
		return MAX32;
	}
}
