/*-----------------------------------------------------------------------------
	Paper Plane viewUI											Main
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include <shlobj.h>
#include "PPX.H"
#include "VFS.H"
#include "PPX_64.H"
#include "PPVUI.RH"
#include "PPV_STRU.H"
#include "PPV_FUNC.H"
#pragma hdrstop
#include "PPV_GVAR.C"	// O[o̎̒`
#define CARETSCROLLMARGINX 4 // Lbg̃XN[Jn錅
#define CARETSCROLLMARGINY 1 // Lbg̃XN[Jns

int GetPointY(int posY);

#ifndef UNICODE
BOOL multichar = FALSE;
#endif

#define CSRTM_OFF 0		// timer gp
#define CSRTM_OUT 1		// ͈͊OXN[(NbN)
#define CSRTM_INERTIA 2	// XN[(NbN)
#define CSRTM_SELECT 3	// ͈͑IXN[(NbN)
#define CSRTM_RAWWIDTH 4	// RawImage̕(NbN)
int CursorTimerMode = CSRTM_OFF;
SIZE OffPos = {0, 0}; // XN[
static LONG ClkTime;
static BOOL KeyChar = FALSE;		// WM_KEYUP  1
int PosChangeEntry = 0;
BOOL detailmode = FALSE;
TCHAR PPvMainThreadName[] = T("PPv main");

#ifdef USEDIRECTX
#pragma argsused
void CALLBACK DrawTimerProc(HWND hWnd, UINT unuse1, UINT_PTR unuse2, DWORD unuse3)
{
	InvalidateRect(hWnd, NULL, FALSE);
}
#endif

void FindIsearch(PPV_APPINFO *vinfo, HWND hEditWnd)
{
	VOsel.VSstring[0] = '\0';
	GetWindowText(hEditWnd, VOsel.VSstring, TSIZEOF(VOsel.VSstring));

	if ( FindInfo.backup.offY < 0 ){
		if ( FindInfo.backup.offY == -3 ){
			FindInfo.backup.offY = -2;
			return;
		}
		FindInfo.backup.offY = VOi->offY;
		FindInfo.backup.selY = VOsel.now.y.line;
		FindInfo.backup.lastY = VOsel.lastY;
	}

	if ( VOsel.VSstring[0] == '\0' ){
		VOsel.highlight = FALSE;
		InvalidateRect(vinfo->info.hWnd, NULL, TRUE);
	}else{
		#ifdef UNICODE
			UnicodeToAnsi(VOsel.VSstringW, VOsel.VSstringA, VFPS);
		#else
			AnsiToUnicode(VOsel.VSstringA, VOsel.VSstringW, VFPS);
		#endif

		if ( VOsel.cursor != FALSE ){
			MoveCsrkey(0, FindInfo.backup.selY - VOsel.now.y.line, FALSE);
		}else{
			MoveCsrkey(0, FindInfo.backup.offY - VOi->offY, FALSE);
		}
		VOsel.lastY = FindInfo.backup.lastY;
		DoFind(vinfo->info.hWnd, FindInfo.mode | VFIND_LOOPFIND);
	}
}

LRESULT GetSelectText(TCHAR *destptr)
{
	const TCHAR *src;
	TMS_struct text = {{NULL, 0, NULL}, 0};
	TCHAR *dest, *maxptr;

	if ( vo_.DModeBit & VO_dmode_SELECTABLE ){
		ClipMem(&text, -1, -1);
		src = text.p ? text.tm.p : NilStr;
		dest = destptr;
		maxptr = destptr + CMDLINESIZE - 100;
		while ( dest < maxptr ){
			TCHAR c;

			c = *src++;
			if ( c == '\r' ) continue;
			if ( c == '\n' ) continue;
			if ( c == '\0' ) break;
			*dest++ = c;
		}
		*dest = '\0';
		if ( dest < maxptr ){
			TM_kill(&text.tm);
		}else{
			TCHAR *longparam;
			size_t paramsize;

			paramsize = (text.p + 1) * sizeof(TCHAR);
			longparam = HeapAlloc(ProcHeap, 0, paramsize );
			if ( longparam != NULL ) memcpy(longparam, text.tm.p, paramsize);
			TM_kill(&text.tm);
			return (LRESULT)longparam;
		}
	}else{
		*destptr = '\0';
	}
	return NO_ERROR;
}

LRESULT PPvPPxCommand(PPV_APPINFO *vinfo, WPARAM wParam, LPARAM lParam)
{
	switch ( LOWORD(wParam) ){
		case K_GETPPXAPPINFO:
			return (LRESULT)vinfo;

		case K_EXTRACT:
			return AnswerExtractCall(&vinfo->info, wParam, lParam);

		case KV_FOCUS:
			ForceSetForegroundWindow(lParam ? (HWND)lParam : hViewReqWnd);
			break;

		case K_SETPOPMSG:
		case K_SETPOPLINENOLOG:
			if ( (TCHAR *)lParam == NULL ){
				StopPopMsg(PMF_STOP);
			}else{
				SetPopMsg(POPMSG_NOLOGMSG, (TCHAR *)lParam, 0);
				UpdateWindow_Part(vinfo->info.hWnd);
			}
			return 1;

		case KE_seltext:
			return GetSelectText((TCHAR *)lParam);

		case K_EDITCHANGE:
			FindIsearch(vinfo, (HWND)lParam);
			break;

/* XWIN_HIDETASK ň̉PPcɖߍވׂ̎R[h
		case K_HIDE:
			if ( (hCommonWnd != NULL) && IsWindow(hCommonWnd) ){
				ShowWindow(hWnd, SW_HIDE);
				return 0;
			}
			PPvCommand(vinfo, LOWORD(wParam));
			return 0;
*/
		case KCW_captureEx:
			Embed = TRUE;
			return (LRESULT)TMAKELPARAM(1, KCW_captureEx);

		case K_E_TABLET:
			switch ( HIWORD(wParam) ){
				case pmc_touch:
					TouchMode = ~X_pmc[pmc_touch];
					break;

				case pmc_mouse:
					TouchMode = 0;
					break;

				case pmc_pen:
					TouchMode = ~X_pmc[pmc_pen];
					break;

				default:
					return NO_ERROR;
			}
			PPxCommonCommand(vinfo->info.hWnd, HIWORD(wParam), K_E_TABLET);
			break;


		case KV_Load:
			hLastViewReqWnd = hViewReqWnd = (HWND)lParam;
		// default 

		default:
			PPvCommand(vinfo, LOWORD(wParam));
	}
	return NO_ERROR;
}

int CallKeyHook(WORD key)
{
	PPXMKEYHOOKSTRUCT keyhookinfo;
	PPXMODULEPARAM pmp;

	keyhookinfo.key = key;
	pmp.keyhook = &keyhookinfo;
	return CallModule(&vinfo.info, PPXMEVENT_KEYHOOK, pmp, KeyHookEntry);
}

void ExecDualParam(PPV_APPINFO *vinfo, const TCHAR *param)
{
	if ( (UTCHAR)*param == EXTCMD_CMD ){
		PP_ExtractMacro(vinfo->info.hWnd, &vinfo->info, NULL, param + 1, NULL, 0);
	}else{
		const WORD *key;

		if ( (UTCHAR)*param == EXTCMD_KEY ) param++;
		key = (WORD *)param;
		while( *key ) PPvCommand(vinfo, *key++);
	}
}

void PPvToolbarCommand(int id, int orcode)
{
	RECT box;
	const TCHAR *ptr;

	box.bottom = -1;
	SendMessage(hToolBarWnd, TB_GETRECT, (WPARAM)id, (LPARAM)&box);
	if ( box.bottom == -1 ){
		PopupPosType = PPT_MOUSE;
	}else{
		PopupPos.x = box.left;
		PopupPos.y = box.bottom;
		ClientToScreen(hToolBarWnd, &PopupPos);
		PopupPosType = PPT_SAVED;
	}
	ptr = GetToolBarCmd(hToolBarWnd, &thGuiWork, id);
	if ( ptr == NULL ) return;
	if ( orcode ){
		WORD key;

		key = *(WORD *)(ptr + 1) | (WORD)orcode;
		if ( key == (K_s | K_raw | K_bs) ){
			key = K_raw | K_c | K_bs;
		}
		PPvCommand(&vinfo, key);
	}else{
		ExecDualParam(&vinfo, ptr);
	}
}

LRESULT PPvNotify(NMHDR *nmh)
{
	if ( nmh->hwndFrom == NULL ) return 0;
	if ( nmh->hwndFrom == hToolBarWnd ){
		if ( nmh->code == (UINT)TBN_DROPDOWN ){
			PPvToolbarCommand(((LPNMTOOLBAR)nmh)->iItem, K_s);
		}
		if ( nmh->code == (UINT)NM_RCLICK ){
			PopupPosType = PPT_MOUSE;
			PPvLayoutCommand(NULL);
		}
		return 0;
	}
	if ( nmh->code == (UINT)TTN_NEEDTEXT ){
		if ( SetToolBarTipText(hToolBarWnd, &thGuiWork, nmh) ) return 0;
		return 0;
	}
	return 0;
}
//-----------------------------------------------------------------------------
#define RANGEOFFSET 1 // ĂIׂ悤ɂ傫
#define COffX ParamX	// istate == SELPOSCHANGE_OFFSET ȂAJ[\Xړ
#define CPosX ParamX	// istate == SELPOSCHANGE_PIX ȂA|CgXW
int CalcTextXPoint(int ParamX, int csrY, int istate)
{
	char *ptr;
#ifdef UNICODE
	TCHAR wbuf[MAXLINELENGTH];
#endif
	int charX = 0;	// ݂ offset
	int MaxcX = MAX_MOVE_X; // őoffset
	int PixX = 0;	// ݂ picel
	int leftX C4701CHECK;	// c蕝
	int XV_bctl3bk;
	HDC hDC;
	HFONT hUseFont;
	HGDIOBJ hOldFont;
	SIZE textsize;
	MAKETEXTINFO mti;

	if ( istate == SELPOSCHANGE_PIX ){ // }[Wƍsԍ̕
		CPosX -= (XV_left + XV_lleft) - VOi->offX * fontX;
		leftX = CPosX + RANGEOFFSET;
		if ( leftX < 0 ) leftX = 0;
	}
	// HEX \ ---------------------------------------------------------------
	if ( vo_.DModeBit == DOCMODE_HEX ){
		int adrX;
		int AddrWidth;

		AddrWidth = (HEXADRWIDTH - 1) * fontHexX + fontSpcX;
		if ( istate == SELPOSCHANGE_PIX ){ // ʒuw
			if ( leftX <= AddrWidth ){ // AhX  // C4701ok
				adrX = 0;
			}else if ( leftX <= (AddrWidth + (HEXNUMSWIDTH * fontHexX)) ){ //HEX
				if ( leftX > (AddrWidth + ((HEXSTRWIDTH / 2) * HEXNWIDTH) * fontHexX) ){
					leftX -= fontHexX; // ̗]
				}
				adrX = (leftX - AddrWidth) / (HEXNWIDTH * fontHexX);
			}else{ // ASCII
				adrX = HEXSTRWIDTH;
			}
		}else{ // SELPOSCHANGE_OFFSET ړ
			if ( (COffX < 0) && (VOsel.now.x.offset == 0) ){
				if ( VOsel.now.y.line == 0 ){
					adrX = 0;
				}else{
					adrX = HEXSTRWIDTH - 1;
					VOsel.now.y.line--;
					VOsel.now.y.pix -= LineY;
				}
			}else{
				int maxP;

				if ( (COffX > 0) &&
					 (VOsel.now.x.offset >= (HEXNWIDTH * (HEXSTRWIDTH - 1) + 1)) ){
					if ( csrY >= (VOi->line - 1) ){
						adrX = HEXSTRWIDTH;
					}else{
						adrX = 0;
						VOsel.now.y.line++;
						VOsel.now.y.pix += LineY;
					}
				}else if ( COffX >= MAX_MOVE_X ){
					adrX = HEXSTRWIDTH;
				}else{
					adrX = (COffX + CalcHexX(VOsel.now.x.offset)) & (HEXSTRWIDTH - 1);
				}
				maxP = (csrY < (VOi->line - 1)) ?
						(HEXSTRWIDTH - 1) :
						((vo_.file.UseSize - 1) & (HEXSTRWIDTH - 1));
				if ( adrX > maxP ) adrX = maxP;
			}
		}
		VOsel.now.x.offset = adrX * HEXNWIDTH + ((adrX >= 8) ? 1 : 0);
		VOsel.now.x.pix = AddrWidth + VOsel.now.x.offset * fontHexX;
		return 0;
	}
	// TEXT \ --------------------------------------------------------------
	if ( csrY >= VOi->line ) csrY = VOi->line;

	if ( istate != SELPOSCHANGE_PIX){ // SELPOSCHANGE_OFFSET
		leftX = MAX_MOVE_X;
		MaxcX = COffX + VOsel.now.x.offset;
		if ( (COffX < 0) && VOsel.posdiffX ) MaxcX++; // ̓rɃJ[\
		VOsel.posdiffX = 0;
	}
	XV_bctl3bk = XV_bctl[2];
	XV_bctl[2] = 0;

	InitMakeTextInfo(&mti);
	mti.srcmax = mtinfo.img + mtinfo.MemSize; // vo->file.image + vo->file.UseSize;
	mti.writetbl = FALSE;
	mti.paintmode = FALSE;

	VOi->MakeText(&mti, &VOi->ti[csrY]);
	XV_bctl[2] = XV_bctl3bk;

	// \ɎgptHgI
	hDC = GetDC(vinfo.info.hWnd);
	switch ( VOi->ti[csrY].type ){
		case VTYPE_IBM:
			hUseFont = GetIBMFont();
			break;

		case VTYPE_ANSI:
			hUseFont = GetANSIFont();
			break;

		default:
			hUseFont = XV_unff ? hUnfixedFont : hBoxFont;
			break;
	}
	hOldFont = SelectObject(hDC, hUseFont);

	ptr = (char *)mti.destbuf;
	while ( *ptr != VCODE_END ) switch ( *ptr++ ){ // VCODE_SWITCH
		case VCODE_ASCII: 	// ASCII Text ---------------------------------
		case VCODE_CONTROL: // 䕶 ---------------------------------
#ifdef UNICODE
		{
			int alength, wlength, wresult;
			UINT cp;

			cp = (vo_.OtherCP.codepage && vo_.OtherCP.valid) ? vo_.OtherCP.codepage : CP_ACP;
			alength = strlen32(ptr);
			// tHgN΍̂߁AUUNICODEɂ
			wlength = MultiByteToWideChar(cp, 0, ptr, alength, wbuf, TSIZEOFW(wbuf));

			if ( istate != SELPOSCHANGE_PIX ){ // J[\ړFɂ
				if ( (charX <= MaxcX) && ((charX + alength) >= MaxcX) ){
					{ // ̒Ԃ̏ꍇ̕␳
						char *fp, *maxp;

						fp = ptr;
						maxp = ptr + MaxcX - charX;
						while( fp < maxp ){
							if ( IskanjiA(*fp) ){
								if ( (fp + 1) == maxp ){
									if ( COffX > 0 ){
										MaxcX++;
									}else{
										MaxcX--;
									}
								}
								fp++;
							}
							fp++;
						}
					}
					GetTextExtentPoint32W(hDC, wbuf,
						MultiByteToWideChar(CP_ACP, 0, ptr, MaxcX - charX, NULL, 0),
						&textsize);
					PixX += textsize.cx;
					charX = MaxcX;
					goto fin;
				}
			}
			GetTextExtentExPointW(hDC, wbuf, wlength, leftX, &wresult, NULL, &textsize);
			leftX -= textsize.cx;
			if ( wresult < wlength ){ // WwFɍW
				charX += WideCharToMultiByte(cp, 0, wbuf, wresult, NULL, 0, NULL, NULL);
				GetTextExtentPoint32W(hDC, wbuf, wresult, &textsize);
				PixX += textsize.cx;
				goto fin;
			}
			charX += alength;
			PixX += textsize.cx;
			ptr += alength + 1;
			break;
		}
#else
		{
			int length, result;
			int addw;

			addw = XV_unff ? 0 : fontWW;
			length = strlen(ptr);
			if ( istate != SELPOSCHANGE_PIX ){ // J[\ړFɂ
				if ( (charX <= MaxcX) && ((charX + length) >= MaxcX) ){
					{ // ̒Ԃ̏ꍇ̕␳
						char *fp, *maxp;

						fp = ptr;
						maxp = ptr + MaxcX - charX;
						while( fp < maxp ){
							if ( IskanjiA(*fp) ){
								PixX += addw;
								if ( (fp + 1) == maxp ){
									if ( COffX > 0 ){
										MaxcX++;
									}else{
										MaxcX--;
									}
								}
								fp++;
							}
							fp++;
						}
					}
					GetTextExtentPoint32A(hDC, ptr, MaxcX - charX, &textsize);
					PixX += textsize.cx;
					charX = MaxcX;
					goto fin;
				}
			}
			if ( addw ){ // ̕␳tvZ
				if ( charX == MaxcX ) goto fin;
				while( *ptr ){
					int width;

					width = ChrlenA(*ptr);
					GetTextExtentPoint32A(hDC, ptr, width, &textsize);
					if ( width > 1) textsize.cx += addw;
					leftX -= textsize.cx;
					if ( leftX < 0 ) goto fin;
					PixX += textsize.cx;
					charX += width;
					if ( charX >= MaxcX ) goto fin;
					ptr += width;
				}
				ptr++; // NUL skip
				break;
			}
			GetTextExtentExPointA(hDC, ptr, length, leftX, &result, NULL, &textsize);

			leftX -= textsize.cx;
			charX += result;
			if ( result < length ){ // WwFɍW
				GetTextExtentPoint32A(hDC, ptr, result, &textsize);
				PixX += textsize.cx;
				goto fin;
			}
			PixX += textsize.cx;
			ptr += length + 1;
			break;
		}
#endif
		case VCODE_UNICODEF:
			ptr++;
		case VCODE_UNICODE:		// UNICODE Text ---------------------------
#ifdef UNICODE
		{
			int length, result;

			length = strlenW32((WCHAR *)ptr);
			if ( istate != SELPOSCHANGE_PIX ){ // J[\ړFɂ
				if ( (charX <= MaxcX) && ((charX + length) >= MaxcX) ){
					GetTextExtentPoint32W(hDC, (WCHAR *)ptr, MaxcX - charX, &textsize);
					PixX += textsize.cx;
					charX = MaxcX;
					goto fin;
				}
			}
			GetTextExtentExPointW(hDC, (WCHAR *)ptr, length, leftX, &result, NULL, &textsize);
			leftX -= textsize.cx;
			charX += result;
			if ( result < length ){ // WwFɍW
				GetTextExtentPoint32W(hDC, (WCHAR *)ptr, result, &textsize);
				PixX += textsize.cx;
				goto fin;
			}
			PixX += textsize.cx;
			ptr += (length + 1) * sizeof(WCHAR);
			break;
		}
#else
		{
			if ( charX == MaxcX ) goto fin;
			while(*(WORD *)ptr){
				GetTextExtentPoint32W(hDC, (WCHAR *)ptr, 1, &textsize);
				leftX -= textsize.cx;
				if ( leftX < 0 ) goto fin;
				PixX += textsize.cx;
				charX++;

				if ( charX == MaxcX ) goto fin;
				ptr += 2;
			}
			ptr += 2; // NUL skip
			break;
		}
#endif
									// Color ... sv
		case VCODE_COLOR:
			ptr += 2;
			break;
		case VCODE_B_COLOR:
		case VCODE_F_COLOR:
			ptr += sizeof(COLORREF);
			break;

		case VCODE_FONT:			// Font ... sv
			ptr++;
			break;

		case VCODE_TAB:{			// Tab -------------------------------
			int wide;
			int tabwidth;

			if ( charX == MaxcX ) goto fin;

			tabwidth = VOi->tab * fontX;
			wide = ((PixX / tabwidth) + 1) * tabwidth - PixX;
			leftX -= wide;
			if ( leftX <= 0 ){
				if ( leftX >= -(wide / 2) ){
					charX++;
					PixX += wide;
				}
				goto fin;
			}
			PixX += wide;
			charX++;
			break;
		}
		case VCODE_RETURN:		// CRLF/LF ------------------------------------
			ptr++;
			// 
		case VCODE_PAGE:		// New Page ----------------------------------
		case VCODE_PARA:		// New Paragraph -----------------------------
			if ( charX == MaxcX ) goto fin;
			leftX -= fontX;
			if ( leftX <= 0 ){
				goto fin;
			}
			// śA͈͂̃JEgɊ܂܂Ȃ
//			PixX += fontX;
//			charX++;
			break;

		case VCODE_SPACE:
			charX++;
		case VCODE_WSPACE:
			if ( charX == MaxcX ) goto fin;
#ifdef UNICODE
			GetTextExtentPoint32W(hDC, StrWideSpace, 1, &textsize);
#else
			GetTextExtentPoint32A(hDC, StrSJISSpace, 2, &textsize);
#endif
			leftX -= textsize.cx;
			if ( leftX <= 0 ){
				goto fin;
			}
			PixX += textsize.cx;
			charX++;
			break;
						// ł͏sv
		case VCODE_LINK:
		case VCODE_DEFCOLOR:
		case VCODE_F_DEFCOLOR:
		case VCODE_B_DEFCOLOR:
			break;

		default:		// `R[h -----------------------------------
			ptr = "";
			break;
	}
fin:
	ReleaseMakeTextInfo(&mti);
	SelectObject(hDC, hOldFont);
	ReleaseDC(vinfo.info.hWnd, hDC);

	VOsel.now.x.offset = charX;
	VOsel.now.x.pix = PixX;
	//
	if ( istate == SELPOSCHANGE_PIX ) VOsel.posdiffX = CPosX - PixX;
	if ( (MaxcX < MAX_MOVE_X) && (MaxcX > charX) ) return 1; // ̍s
	return 0;
}
#undef PosX
#undef COffX

void AutoScroll(HWND hWnd, BOOL reverse)
{
	POINT pos;
	int x = 0, y = 0;

	GetCursorPos(&pos);
	ScreenToClient(hWnd, &pos);

	if ( pos.y < (BoxView.top + LineY) ){
		if ( vo_.DModeBit & VO_dmode_IMAGE ){
			y = -(pos.y - (BoxView.top + LineY));
		}else{
			y = 2 - ((pos.y - BoxView.top) * 2) / LineY;
		}
	}else if ( pos.y >= (BoxView.bottom - (LineY * 2)) ){
		if ( vo_.DModeBit & VO_dmode_IMAGE ){
			y = -(pos.y - (BoxView.bottom - (LineY * 2)));
		}else{
			y = -4 - ((pos.y - BoxView.bottom) * 2) / LineY;
		}
	}
	if ( pos.x < fontX ){
		if ( vo_.DModeBit & VO_dmode_IMAGE ){
			x = fontX - pos.x;
		}else{
			x = 2 - (pos.x * 2) / fontX - 1;
		}
	}else if ( pos.x >= (WndSize.cx - fontX) ){
		if ( vo_.DModeBit & VO_dmode_IMAGE ){
			x = (WndSize.cx - fontX) - pos.x;
		}else{
			x = 1 - ( (pos.x - (WndSize.cx - fontX)) * 2) / fontX;
		}
	}
	if (reverse){
		x = -x;
		y = -y;
	}
	if ( x || y ){
		MoveCsr(x, y, FALSE);
		if ( VOsel.cursor != FALSE ) SetCursorCaret(&VOsel.now);
	}
}

int GetPointY(int posY)
{
	int pointY;

	if ( vo_.DModeBit & VO_dmode_TEXTLIKE ){
		if ( posY < BoxView.top ){
			pointY = -2;
		}else if ( posY >= WndSize.cy ){
			pointY = -3;
		}else{
			pointY = ((posY - BoxView.top) / LineY) + VOi->offY;
			if ( pointY >= VOi->line ) pointY = -4;
		}
	}else{
		pointY = -1;
	}
	return pointY;
}

void SetCursorCaret(SELPOSINFO *posinfo)
{
	if ( GetFocus() == vinfo.info.hWnd ){
		SetCaretPos(posinfo->x.pix - (VOi->offX * fontX) + XV_left + XV_lleft,
				posinfo->y.pix - (VOi->offY * LineY) + BoxView.top);
	}
	DNotifyWinEvent(EVENT_OBJECT_FOCUS, vinfo.info.hWnd, OBJID_CLIENT, posinfo->y.line + 1);
}

void MoveCsrkey(int offx, int offy, BOOL select)
{
	int newY;

	if ( vo_.DModeBit == DOCMODE_NONE ) return;

	if ( (VOsel.cursor == FALSE) || !(vo_.DModeBit & VO_dmode_TEXTLIKE) ){
		// y[W[h^J[\\
		MoveCsr(offx, offy, FALSE);
		if ( GetFocus() == vinfo.info.hWnd ){
			SetCaretPos(0, (LineY >> 1) + BoxView.top); // ANZVreBʒmp
		}
		DNotifyWinEvent(EVENT_OBJECT_FOCUS, vinfo.info.hWnd, OBJID_CLIENT, VOi->offY + 1);
		return;
	}
									// J[\[h^J[\\
	if ( select == FALSE ){ // I[h
		if ( VOsel.select != FALSE ){ // I𒆂Ȃ
			ResetSelect(FALSE);
			InvalidateRect(vinfo.info.hWnd, NULL, TRUE);
			if ( VOsel.cursor != FALSE ){	// J[\OȂĂі߂
				if ( VOsel.now.y.line < VOi->offY ){
					VOsel.now.y.line = VOi->offY;
				}
				if ( VOsel.now.y.line >= (VOi->offY + VO_sizeY - 1) ){
					VOsel.now.y.line = (VOi->offY + VO_sizeY - 1);
				}
			}
		}
	}else{ // I[h
		if ( VOsel.select == FALSE ){ // IȂ珉
			VOsel.select = TRUE;
			VOsel.start = VOsel.now;
			// FixSelectRange ͌Ŏŝŕsv
			InvalidateRect(vinfo.info.hWnd, NULL, FALSE);
		}
	}
									// y ͈͌
	newY = VOsel.now.y.line + offy;
	if ( newY >= VOi->line ) newY = VOi->line - 1;
	if ( newY < VO_minY ) newY = VO_minY;

									// ʂƂĈʒuꂽꍇAXV
	if ( offx || (newY != VOsel.now.y.line) ){
		RECT box;
		int oldY;
		BOOL newlinemode;

		newlinemode = offx ? FALSE : X_vzs;
		if ( VOsel.linemode != newlinemode ){
			VOsel.linemode = newlinemode;
			InvalidateRect(vinfo.info.hWnd, NULL, FALSE);
		}
		// \XV̈
		oldY = VOsel.now.y.line;

		VOsel.now.y.pix  = newY * LineY;
		VOsel.now.y.line = newY;
		if ( newY != oldY ){ // YύX
			int oldpixx;

			oldpixx = VOsel.now.x.pix;
			CalcTextXPoint(VOsel.now.x.pix + XV_left + XV_lleft - VOi->offX * fontX, newY, SELPOSCHANGE_PIX);
			VOsel.now.x.pix = oldpixx; // LbgXWێ
			// IĂƂ́ALbgʒu̕␳悢H
//			if ( (VOsel.select != FALSE) && !X_vzs ) VOsel.posdiffX = 0;
		}else{ // XύX
			if ( (vo_.DModeBit & DOCMODE_TEXT) && ((VOsel.now.x.offset + offx) < 0) ){ // ̍sɈړH
				if ( VOsel.now.y.line <= VO_minY ){ // ŏʍs
					VOsel.now.x.offset = 0;
					VOsel.now.x.pix = 0;
				}else{
					VOsel.now.y.line--;
					VOsel.now.y.pix -= LineY;
					CalcTextXPoint(MAX_MOVE_X, VOsel.now.y.line, SELPOSCHANGE_PIX);
				}
				VOsel.posdiffX = 0;
			}else{
				if ( CalcTextXPoint(offx, newY, SELPOSCHANGE_OFFSET) ){
					if ( newY < (VOi->line - 1) ){ // ̍sɈړ
						VOsel.now.y.line++;
						VOsel.now.y.pix += LineY;
						VOsel.now.x.offset = 0;
						VOsel.now.x.pix = 0;
					}
				}
			}
		}
		newY = VOsel.now.y.line;
		if ( VOsel.select != FALSE ){
			FixSelectRange();
			if ( newY < oldY ){
				box.top =    (newY - VOi->offY) * LineY + BoxView.top;
				box.bottom = (oldY - VOi->offY + 1) * LineY + BoxView.top;
			}else{
				box.top =    (oldY - VOi->offY) * LineY + BoxView.top;
				box.bottom = (newY - VOi->offY + 1) * LineY + BoxView.top;
			}
		}else{
			box.top = (oldY - VOi->offY) * LineY + BoxView.top;
			box.bottom = box.top + LineY;
		}
		box.left = 0;
		box.right = WndSize.cx;
		InvalidateRect(vinfo.info.hWnd, &box, TRUE);
		if ( !FullDraw ){ // J[\
			UpdateWindow_Part(vinfo.info.hWnd);
		}
		// \͈̓`FbN
		{
			int cX, leftbottom;

			cX = (XV_lleft + VOsel.now.x.pix + XV_left) / fontX;
			if ( vo_.DModeBit == DOCMODE_HEX ){
				leftbottom = HEXADRWIDTH;
			}else{
				leftbottom = XV_lleft / fontX;
			}
			if ( cX < (VOi->offX + leftbottom + CARETSCROLLMARGINX) ){ // \͈͂荶
				int delta = cX - (VOi->offX + leftbottom + CARETSCROLLMARGINX);
				if ( delta < offx ) offx = delta;
			}else if ( cX >= (VOi->offX + VO_sizeX - 1 - CARETSCROLLMARGINX) ){ // \͈͂E
				int delta = cX - (VOi->offX + VO_sizeX - 1 - CARETSCROLLMARGINX);
				// J[\̕\X ł邾ςȂ悤ɒ
				if ( (delta > offx) || (offx == MAX_MOVE_X) ){
					offx = delta;
				}
			}else{ // \͈͓
				offx = 0;
			}
		}
		if ( newY < (VOi->offY + CARETSCROLLMARGINY) ){ // \͈͂
			// J[\̕\Y ł邾ςȂ悤ɒ
			int delta = newY - (VOi->offY + CARETSCROLLMARGINY);
			if ( delta < offy ) offy = delta;
		}else if ( newY >= (VOi->offY + VO_sizeY - 2 - CARETSCROLLMARGINY) ){ // \͈͂艺
			// J[\̕\Y ł邾ςȂ悤ɒ
			int delta = newY - (VOi->offY + VO_sizeY - 2 - CARETSCROLLMARGINY);
			if ( delta > offy ) offy = delta;
		}else{
			offy = 0;
		}
		if ( offy || offx ){ // XN[L
			InvalidateRect(vinfo.info.hWnd, &box, FALSE);
			MoveCsr(offx, offy, FALSE);	// XN[
		}
		box.top = (newY - VOi->offY) * LineY + BoxView.top;
		box.bottom = box.top + LineY;
		InvalidateRect(vinfo.info.hWnd, &box, FALSE); // VJ[\\
		if ( !FullDraw ) UpdateWindow_Part(vinfo.info.hWnd);
		InvalidateRect(vinfo.info.hWnd, &BoxStatus, FALSE); // Xe[^XύX
		if ( FullDraw ) UpdateWindow_Part(vinfo.info.hWnd);
	}
	SetCursorCaret(&VOsel.now);
}

void DragSelect(HWND hWnd, BOOL timer)
{
	POINT pos;
	int pointX, oldline, newline, oldoffset;

	if ( VOsel.select == FALSE ) return;
	if ( timer ) AutoScroll(hWnd, TRUE);
	GetCursorPos(&pos);
	ScreenToClient(hWnd, &pos);
	#ifdef USEDIRECTWRITE
	{
		LPARAM lParam = TMAKELPARAM(pos.x, pos.y);
		DxTransformPoint(DxDraw, &lParam);
		LPARAMtoPOINT(pos, lParam);
	}
	#endif
										// y vZ
	oldline = VOsel.now.y.line;
	newline = GetPointY(pos.y);
	switch( newline ){
		case -1:	// eLXgłȂ
			ResetSelect(TRUE);
			return;
		case -2:	// ɂ͂ݏoĂ
			newline = VOi->offY;
			if ( VOsel.linemode == FALSE ){
				InvalidateRect(hWnd, NULL, FALSE);
			}
			VOsel.linemode = X_vzs;
			break;
		case -3:	// ɂ͂ݏoĂ
		case -4:
			if ( VOsel.linemode == FALSE ){
				InvalidateRect(hWnd, NULL, FALSE);
			}
			VOsel.linemode = X_vzs;
			newline = VOi->offY + VO_sizeY - 1;
			if ( newline >= VOi->line ){
				newline = VOi->line - 1;
			}
			break;
	}
										// x vZ
	VOsel.now.y.pix = newline * LineY;
	VOsel.now.y.line = newline;

	oldoffset = VOsel.now.x.offset;
	CalcTextXPoint(pos.x, newline, SELPOSCHANGE_PIX);
	SetCursorCaret(&VOsel.now);
	pointX = (pos.x / fontX) - OldPointCX; // X̃|CgʒüړʂZo
	OldPointCX += pointX; // f
	if ( oldoffset != VOsel.now.x.offset ) pointX = 1;
										// \XV
	if ( oldline != VOsel.now.y.line ){
		RECT box;

		if ( VOsel.linemode == FALSE ){
			InvalidateRect(hWnd, NULL, FALSE);
		}
		VOsel.linemode = X_vzs;
		box.left = 0;
		box.right = WndSize.cx;
		if ( oldline < VOsel.now.y.line ){
			box.top = (oldline - VOi->offY) * LineY + BoxView.top;
			box.bottom = (VOsel.now.y.line - VOi->offY + 1) * LineY + BoxView.top;
		}else{
			box.top = (VOsel.now.y.line - VOi->offY) * LineY + BoxView.top;
			box.bottom = (oldline - VOi->offY + 1) * LineY + BoxView.top;
		}
		InvalidateRect(hWnd, &box, TRUE);
	}else{
		if ( pointX ) VOsel.linemode = FALSE;
	}
	if ( !VOsel.linemode && pointX ){
		InvalidateRect(hWnd, NULL, FALSE);
	}
	FixSelectRange();
}


#pragma argsused
void CALLBACK DragTimerProc(HWND hWnd, UINT msg, UINT_PTR id, DWORD work)
{
	UnUsedParam(msg);UnUsedParam(work);

	switch (CursorTimerMode){
		case CSRTM_OUT:	// ͈͊ÕXN[
			if ( !X_dds && (VOsel.select == FALSE) ) break;
			AutoScroll(hWnd, FALSE);
			return;

		case CSRTM_INERTIA:	// XN[
			MoveCsr(-OffPos.cx, -OffPos.cy, FALSE);
			if ( VOsel.cursor != FALSE ) SetCursorCaret(&VOsel.now);
			OffPos.cx /= 2; OffPos.cy /= 2;
			if ( !OffPos.cx && !OffPos.cy ){
				CursorTimerMode = CSRTM_OFF;
				KillTimer(hWnd, id);
			}
			break;

		case CSRTM_SELECT:	// ͈͑I
			DragSelect(hWnd, TRUE);
			return;
	}
}

BOOL USEFASTCALL WmCopyData(COPYDATASTRUCT *copydata)
{
	switch(LOWORD(copydata->dwData)){
		case 'H':
			return RecvExecuteByWMCopyData(&vinfo.info, copydata);
	}
	return FALSE;
}

void USEFASTCALL DoDropFiles(HWND hWnd, HDROP hDrop)
{
	if ( VO_PrintMode == PRINTMODE_FILES ){
		if ( IsIconic(hWnd) || !IsWindowVisible(hWnd) ){
			PostMessage(hWnd, WM_SYSCOMMAND, SC_RESTORE, 0xffff0000);
		}
		InvalidateRect(hWnd, NULL, TRUE);
		SetForegroundWindow(hWnd);
		PPVPrintFiles(hWnd, hDrop);
	}else{
		TCHAR name[VFPS];

		DragQueryFile(hDrop, 0, name, TSIZEOF(name));
		DragFinish(hDrop);
		OpenAndFollowViewObject(&vinfo, name, NULL, NULL, 0);
		SetForegroundWindow(hWnd);
		if ( VO_PrintMode == PRINTMODE_ONE ) PPVPrint(hWnd);
	}
}

void WmWindowPosChanged(HWND hWnd)
{
	WINDOWPLACEMENT wp;

	PosChangeEntry++;
	if ( PosChangeEntry > 1 ) return; // ēL
	do {
		int OldWidth, OldHeight;
		wp.length = sizeof(wp);
		GetWindowPlacement(hWnd, &wp);
		WinPos.show = (BYTE)wp.showCmd;

		GetClientRect(hWnd, &wp.rcNormalPosition);

		if ( ((wp.showCmd != SW_SHOWMINIMIZED) && (wp.showCmd != SW_HIDE)) &&
			 ( (WndSize.cx != wp.rcNormalPosition.right) ||
			   (WndSize.cy != wp.rcNormalPosition.bottom) ) ){
			WndSize.cx = wp.rcNormalPosition.right;
			WndSize.cy = wp.rcNormalPosition.bottom;
			FreeOffScreen(&BackScreen);
			InvalidateRect(hWnd, NULL, TRUE);
		}

		GetWindowRect(hWnd, &winS);
		if ( !OpenEntryNow && wp.showCmd == SW_SHOWNORMAL ){
			if ( ((XV.img.imgD[imdD_MAG] == IMGD_FIXFRAMESIZE) ||
				  (XV.img.imgD[imdD_MAG] == IMGD_AUTOFRAMESIZE)) &&
				 ((vo_.DModeBit == DOCMODE_NONE ) ||
				  (vo_.DModeBit & VO_dmode_IMAGE) ) ){
				// g傫ς̎͑Ȏ傫ێ
				WinPos.pos.right = winS.left + (WinPos.pos.right - WinPos.pos.left);
				WinPos.pos.bottom = winS.top + (WinPos.pos.bottom - WinPos.pos.top);
				WinPos.pos.left = winS.left;
				WinPos.pos.top = winS.top;
			}else{
				WinPos.pos = winS;
			}
		}

		BoxStatus.left = 0;
		BoxStatus.top = 0;
		BoxStatus.right = WndSize.cx;
		BoxStatus.bottom = X_win & XWIN_NOSTATUS ? 0 : LineY;

		OldWidth = BoxView.right;
		OldHeight = BoxView.bottom;
		BoxView.left = 0;
		BoxView.top = BoxStatus.bottom;
		BoxView.right = WndSize.cx;
		BoxView.bottom = WndSize.cy;

		if ( hToolBarWnd != NULL ){
			RECT box;

			GetWindowRect(hToolBarWnd, &box);
			SetWindowPos(hToolBarWnd, NULL, 0, BoxStatus.bottom,
					WndSize.cx, box.bottom - box.top,
					SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

			// ωƂ́Ac[o[ɂ邱Ƃ邽߁A
			// xʒuݒs
			SetWindowPos(hToolBarWnd, NULL, 0, BoxStatus.bottom,
					WndSize.cx, box.bottom - box.top,
					SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);
			BoxView.top += box.bottom - box.top;
		}

		if ( VOi->defwidth == WIDTH_AUTOFIX ){
			int newwidth = FixedWidthRange(VOi->defwidth);

			if ( newwidth != VOi->width ){
				VOi->width = newwidth;
				ReMakeIndexes(hWnd); // ōēN
			}
		}

		BoxAllView = BoxView;
		if ( Use2ndView ){
			Box2ndView = BoxView;
			if ( Use2ndView == 1 ){ // Eɕׂ
				BoxView.right = (BoxView.left + BoxView.right) / 2;
						// BoxView.left + (BoxView.right - BoxView.left) / 2;
				Box2ndView.left = BoxView.right;
			}else{ // ㉺ɕׂ
				BoxView.bottom = (BoxView.top + BoxView.bottom) / 2;
				Box2ndView.top = BoxView.bottom;
			}
		}

		if ( (vo_.bitmap.ModifyCache.info != NULL) &&
			 ((OldWidth != BoxView.right) ||
			  (OldHeight != BoxView.bottom)) ){
			ClearBitmapModifyCache();
		}

		SetScrollBar(); // ōēN
		if ( X_fles || BackScreen.X_WallpaperType ){
			InvalidateRect(hWnd, NULL, TRUE);
		}

		if ( (wp.showCmd == SW_SHOWMINIMIZED) && (X_tray & X_tray_PPv) ){
			PostMessage(hWnd, WM_PPXCOMMAND, K_HIDE, 0);
		}
		ChangeSizeDxDraw(DxDraw, C_back);
		if ( PosChangeEntry > 4 ) PosChangeEntry = 1; // ߓx̍ē
	}while ( --PosChangeEntry );
}

LRESULT WMGesture(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	if ( TouchMode == 0 ){
		if ( X_pmc[pmc_mode] < 0 ) PPvEnterTabletMode(hWnd);
	}
	{
		switch ( wParam ){
			case GID_TWOFINGERTAP:
				PostMessage(hWnd, WM_PPXCOMMAND, K_apps, 0);
				break;

			case GID_PRESSANDTAP:
				PostMessage(hWnd, WM_PPXCOMMAND, K_apps, 0);
				break;
		}
	}
	return DefWindowProc(hWnd, WM_GESTURE, wParam, lParam);
}

void WMDpiChanged(HWND hWnd, WPARAM wParam, RECT *newpos)
{
	int newDPI = HIWORD(wParam);
	HDC hDC;

	if ( !(X_dss & DSS_ACTIVESCALE) ) return;
	if ( FontDPI == newDPI ) return; // ύX(N)

	if ( vo_.DModeBit & VO_dmode_IMAGE ){ // 摜
		if ( (XV.img.imgD[imdD_MAG] > 0) && (XV.img.imgD[imdD_MAG] != 100) ){
			XV.img.imgD[imdD_MAG] = (XV.img.imgD[imdD_MAG] * newDPI) / FontDPI;
		}
	}

	FontDPI = newDPI;

	DeleteFonts();
	hDC = GetDC(hWnd);
	MakeFonts(hDC, X_textmag);
	ReleaseDC(hWnd, hDC);

	if ( newpos != NULL ){
		SetWindowPos(hWnd, NULL, newpos->left, newpos->top,
				newpos->right - newpos->left, newpos->bottom - newpos->top,
				SWP_NOACTIVATE | SWP_NOZORDER);
	}

	WmWindowPosChanged(hWnd);
	InvalidateRect(hWnd, NULL, FALSE);
}

/*=============================================================================
	}EX֘A
=============================================================================*/
void CheckGesture(MOUSESTATE *ms)
{
	TCHAR buf[GESTURETEXTSIZE];

	if ( PPxCheckMouseGesture(ms, buf, T("MV_click")) == FALSE ) return;
	SetPopMsg(POPMSG_NOLOGMSG, buf, PMF_DOCMSG);
}

int HideMenuPos(LPARAM lParam)
{
	POINT pos;

	int newHMpos = -1;

	if ( XV.HiddenMenu.width > 0 ){
		LPARAMtoPOINT(pos, lParam);
		if ( (pos.x >= BoxStatus.left) &&
			 (pos.y >= BoxStatus.top) &&
			 (pos.y < BoxStatus.bottom) ){
			newHMpos = pos.x / (fontX * XV.HiddenMenu.width);
			if ( newHMpos >= XV.HiddenMenu.item ) newHMpos = -1;
		}
	}
	return newHMpos;
}

void PPvMouseMove(HWND hWnd, MOUSESTATE *ms, WPARAM wParam, LPARAM lParam)
{
	if ( (wParam & MK_CONTROL) && (vo_.DModeBit & VO_dmode_IMAGE) ){
		ShowImageScale = TRUE;
		InvalidateRect(hWnd, &BoxStatus, TRUE);	// 摜ʒu XVw
	}
	//---------------------------------- Bj[(hbO)
	if ( (ms->mode != MOUSEMODE_DRAG) && !(TouchMode & TOUCH_DISABLEHIDDENMENU) ){
		int newHMpos = HideMenuPos(lParam);
		if ( newHMpos != HMpos ){
			HMpos = newHMpos;
			InvalidateRect(hWnd, &BoxStatus, TRUE);	// XVw
		}
		return;
	}

	if ( ms->PushButton <= MOUSEBUTTON_CANCEL ) return;

	ClkTime = GetMessageTime();

	//---------------------------------- WFX`
	if ( ms->PushButton == XV_DragGes ){
		if ( PtInRect(&ms->DDRect, ms->MovedScreenPoint) == FALSE ){
			CheckGesture(ms);
		}
		return;
	}

	if ( (ms->PushButton == XV_DragScr) || (ms->PushButton == XV_DragSel) ){
		//---------------------------------- Raw Image ̕\͈͕ύX
		if ( CursorTimerMode == CSRTM_RAWWIDTH ){
			if ( wParam & MK_SHIFT ){
				ChangeRawImageInfo(hWnd, RawBmpOffset + ms->MovedOffset.cx, FALSE);
			}else{
				ChangeRawImageInfo(hWnd, RawBmpWidth + ms->MovedOffset.cx, TRUE);
			}
			return;
		}
		//---------------------------------- ͈͑I
		if ( (CursorTimerMode == CSRTM_SELECT) && (OSver.dwMajorVersion >= 6) ){
			DragSelect(hWnd, FALSE);
			return;
		}
	}

	//---------------------------------- \eXN[(hbO)
	if ( (ms->PushButton == XV_DragScr) &&
		 ((ms->PushButton != XV_DragSel) || (VOsel.select == FALSE)) ){
		POINT pos;

		pos = ms->MovedClientPoint;
		if ( pos.y >= BoxView.top ){
			if ( !X_dds || !((pos.y < (LineY + BoxView.top)) ||
					(pos.y >= (WndSize.cy - BoxView.top)) || (pos.x < fontX) ||
					(pos.x >= (WndSize.cx - fontX))) ){
				MoveCsr(-ms->MovedOffset.cx, -ms->MovedOffset.cy, FALSE);
				if ( VOsel.cursor != FALSE ) SetCursorCaret(&VOsel.now);
			}
		}
		return;
	}
	//---------------------------------- EBhEhbO(hbO)
	if ( ms->PushButton == XV_DragMov ){
		if ( !(GetAsyncKeyState(VK_LBUTTON) & KEYSTATE_PUSH) &&
			 !(GetAsyncKeyState(MBtoVK(XV_DragMov)) & KEYSTATE_PUSH) ){
			PPxCancelMouseButton(ms);
			ms->mode = MOUSEMODE_NONE;
		}else{
			SetWindowPos(hWnd, NULL,
				winS.left + ms->MovedOffset.cx, winS.top + ms->MovedOffset.cy,
				0, 0, SWP_NOSIZE | SWP_NOZORDER);
		}
		return;
	}
}

void SetCursorIcon(HWND hWnd, LPCTSTR csr)
{
	HCURSOR hCsr;

	hCsr = LoadCursor(NULL, csr);
	SetClassLongPtr(hWnd, GCLP_HCURSOR, (LONG_PTR)hCsr);
	SetCursor(hCsr);
}

void CancelMouse(HWND hWnd)
{
	SetCursorIcon(hWnd, IDC_ARROW);
}

void USEFASTCALL RunGesture(PPV_APPINFO *vinfo, MOUSESTATE *ms)
{
	TCHAR buf[CMDLINESIZE];

	StopPopMsg(PMF_PROGRESS);
	thprintf(buf, TSIZEOF(buf), T("RG_%s"), ms->gesture.step);
	ms->gesture.count = 0;
	if ( NO_ERROR == GetCustTable(T("MV_click"), buf, buf, sizeof(buf)) ){
		ExecDualParam(vinfo, buf);
	}
}

void PPvDownMouse(HWND hWnd, MOUSESTATE *ms, WPARAM wParam)
{
	if ( ms->PushButton <= MOUSEBUTTON_CANCEL ){
		CancelMouse(hWnd);
		if ( IsTrue(VOsel.select) ){
			ResetSelect(TRUE);
			InvalidateRect(hWnd, NULL, FALSE);
		}
		return;
	}
	if ( (ms->PushClientPoint.x < 0) ||
		 (ms->PushClientPoint.y < 0) ||
		 (ms->PushClientPoint.x >= WndSize.cx) ||
		 (ms->PushClientPoint.y >= WndSize.cy) ){
		PPxCancelMouseButton(ms);
		return;
	}
	KillTimer(hWnd, TIMERID_DRAGSCROLL);
	StopPopMsg(PMF_WAITKEY | PMF_FLASH);
	if ( (GetFocus() != hWnd) && (hViewParentWnd == NULL) ){
		PPxCancelMouseButton(ms);
		return;
	}

	// WFX`[Jn
	if ( ms->PushButton == XV_DragGes ){
		ms->mode = MOUSEMODE_DRAG;
		ms->gesture.count = 0;
		return;
	}

	// IJn
	if ( ms->PushButton == XV_DragSel ){
		if ( vo_.DModeBit & VO_dmode_SELECTABLE ){
			int pointY = GetPointY(ms->PushClientPoint.y);

			if ( (ms->PushClientPoint.y >= BoxView.top) && (pointY >= 0) && (pointY < VOi->line) ){
				ms->mode = MOUSEMODE_DRAG;
				SetCursorIcon(NULL, IDC_IBEAM);
				VOsel.linemode =
					(PPxCommonExtCommand(K_IsShowButtonMenu, 0) == NO_ERROR) ?
					X_vzs : 0;
				VOsel.cursor = TRUE;
				VOsel.select = TRUE;

				OldPointCX = ms->PushClientPoint.x / fontX;

				VOsel.now.y.pix  = pointY * LineY;
				VOsel.now.y.line = pointY;
				CalcTextXPoint(ms->PushClientPoint.x, pointY, SELPOSCHANGE_PIX);

				if ( !( (wParam & MK_SHIFT) && IsTrue(VOsel.cursor) ) ){
					VOsel.start = VOsel.now;
				}

				FixSelectRange();
				InvalidateRect(hWnd, NULL, FALSE);

				SetCursorCaret(&VOsel.now);
				UpdateWindow_Part(hWnd);

				CursorTimerMode = CSRTM_SELECT;
				SetTimer(hWnd, TIMERID_DRAGSCROLL, TIME_DRAGSCROLL, DragTimerProc);
			}
			return;
		}
	}
	//---------------------------------- \eXN[(hbO)
	if ( (ms->PushButton == XV_DragScr) || (ms->PushButton == XV_DragSel) ){
		if ( ms->PushClientPoint.y >= BoxView.top ){
			ms->mode = MOUSEMODE_DRAG;
			SetCursorIcon(NULL, IDC_SIZEALL);
			CursorTimerMode = CSRTM_OUT;
			SetTimer(hWnd, TIMERID_DRAGSCROLL, TIME_DRAGSCROLL, DragTimerProc);
			return;
		}
		if ( (vo_.DModeType == DISPT_RAWIMAGE) &&
			 (ms->PushClientPoint.y < BoxView.top) ){
			ms->mode = MOUSEMODE_DRAG;
			SetCursorIcon(NULL, IDC_SIZEWE);
			CursorTimerMode = CSRTM_RAWWIDTH;
		}
		return;
	}
	if ( ms->PushButton == MOUSEBUTTON_W ){
		if ( IsTrue(VOsel.select) ){
			CancelMouse(hWnd);
			ResetSelect(TRUE);
			InvalidateRect(hWnd, NULL, FALSE);
			PPxCancelMouseButton(ms);
			ms->mode = MOUSEMODE_NONE;
//			return;
		}

		if ( (ms->mode == MOUSEMODE_PUSH) && (WinPos.show == SW_SHOWNORMAL) ){
			ms->PushButton = XV_DragMov;
		}
		return;
	}
}

void PPvUpMouse(HWND hWnd, MOUSESTATE *ms, int button, int oldmode, LPARAM lParam)
{
	TCHAR click[4];
	POINT pos;
	int posY;

	if ( button <= MOUSEBUTTON_CANCEL ) return;
	CancelMouse(hWnd);
	if ( GetFocus() != hWnd ) SetFocus(hWnd);
	LPARAMtoPOINT(pos, lParam);
	posY = pos.y;
	ClientToScreen(hWnd, &pos);

	click[0] = PPxMouseButtonChar[button];
	click[1] = '\0';

	PopupPos = pos;
	PopupPosType = PPT_SAVED;

	KillTimer(hWnd, TIMERID_DRAGSCROLL);
	if ( oldmode == MOUSEMODE_DRAG ){
		if ( button == XV_DragGes ){
			if ( ms->gesture.count ) RunGesture(&vinfo , ms);
			return;
		}

		//---------------------------------- \eXN[(hbO)
		if ( (button == XV_DragScr) &&
			 ((button != XV_DragSel) || (VOsel.select == FALSE)) ){
							// timer overlap ͖
			if ( (ClkTime + 60) > GetMessageTime() ){
				CursorTimerMode = CSRTM_INERTIA;
				OffPos = ms->MovedOffset;
				SetTimer(hWnd, TIMERID_DRAGSCROLL, TIME_DRAGSCROLL, DragTimerProc);
				return;
			}else{
				CursorTimerMode = CSRTM_OFF;
				if ( (ms->PushScreenPoint.x != pos.x) || (ms->PushScreenPoint.y != pos.y) ){
					return;
				}
			}
		}
							// }EX̉ENbN
		if ( button == XV_DragSel ){
			if ( VOsel.select != FALSE ){
				int pointY;

				pointY = GetPointY(posY);
				switch(pointY){
					case -1:	// eLXgłȂ
						ResetSelect(TRUE);
						break;
					case -2:	// ɂ͂ݏoĂ
						pointY = VOi->offY;
						break;
					case -3:	// ɂ͂ݏoĂ
					case -4:
						pointY = VOi->offY + VO_sizeY - 1;
						if ( pointY >= VOi->line ) pointY = VOi->line - 1;
						break;
				}
				if ( pointY >= 0 ) FixSelectRange();
				if ( pointY != VOsel.now.y.line ){
					RECT box;

					box.left = 0;
					box.right = WndSize.cx;
					if ( pointY < VOsel.now.y.line ){
						box.top = (pointY - VOi->offY) * LineY + BoxView.top;
						box.bottom = (VOsel.now.y.line - VOi->offY + 1) * LineY + BoxView.top;
					}else{
						box.top = (VOsel.now.y.line - VOi->offY) * LineY + BoxView.top;
						box.bottom = (pointY - VOi->offY + 1) * LineY + BoxView.top;
					}
					InvalidateRect(hWnd, &box, FALSE);
					UpdateWindow_Part(hWnd);
					VOsel.now.y.line = pointY;
				}
			}
			if ( !X_vzs &&
				 (VOsel.now.y.line   == VOsel.start.y.line ) &&
				 (VOsel.now.x.offset == VOsel.start.x.offset) ){
				ResetSelect(TRUE);
				InvalidateRect(hWnd, NULL, FALSE);
			}else{
				oldmode = MOUSEMODE_PUSH;
			}
		}
		if ( posY < BoxView.top ) posY = BoxView.top;
	}

	if ( (oldmode != MOUSEMODE_NONE) &&
		 (ms->PushTick > MOUSE_LONG_PUSH_TIME) ){ // `FbN
		click[1] = 'H';
		click[2] = '\0';
		if ( IsTrue(PPvMouseCommandPos(&vinfo, &pos, click, posY)) ) return;
		click[1] = '\0';
	}

	if ( (button == MOUSEBUTTON_L) && (HMpos >= 0) && (HMpos == HideMenuPos(lParam)) ){
		const TCHAR *p;

		p = HiddenMenu_cmd(XV.HiddenMenu.data[HMpos]);
		ExecDualParam(&vinfo, p);
		return;
	}
	if ( oldmode != MOUSEMODE_DRAG ){
		if ( IsTrue(PPvMouseCommandPos(&vinfo, &pos, click, posY)) ){
			if ( button == XV_DragSel ){
				if ( VOsel.select != FALSE ){
					ResetSelect(TRUE);
					InvalidateRect(hWnd, NULL, FALSE);
				}
			}
		}
	}
}

void DoubleClickMouse(HWND hWnd, MOUSESTATE *ms)
{
	TCHAR type[3];

	if ( ms->PushButton <= MOUSEBUTTON_CANCEL ) return;

	CursorTimerMode = CSRTM_OFF;
	KillTimer(hWnd, TIMERID_DRAGSCROLL);
	if ( GetFocus() != hWnd ) SetFocus(hWnd);
	if ( (ms->PushClientPoint.x < 0) ||
		 (ms->PushClientPoint.y < 0) ||
		 (ms->PushClientPoint.x >= WndSize.cx) ||
		 (ms->PushClientPoint.y >= WndSize.cy) ){
		return;
	}
	type[0] = PPxMouseButtonChar[ms->PushButton];
	type[1] = 'D';
	type[2] = '\0';
	PPvMouseCommandPos(&vinfo, &ms->PushScreenPoint, type, ms->PushClientPoint.y);
}

void WheelMouse(HWND hWnd, MOUSESTATE *ms, WPARAM wParam, LPARAM lParam)
{
	int now;
	int X_wheel = WHEEL_STANDARD_LINES;

	now = PPxWheelMouse(ms, hWnd, wParam, lParam);
	if ( now == 0 ) return;
	GetCustData(T("X_wheel"), &X_wheel, sizeof(X_wheel));

#ifdef USEDIRECTWRITE
	if ( GetAsyncKeyState(VK_MENU) & KEYSTATE_PUSH ){ // ]f
		CursorTimerMode = CSRTM_OFF;
		KillTimer(hWnd, TIMERID_DRAGSCROLL);
		CancelMouse(hWnd);

		DxSetRotate(DxDraw, now * 2);
		InvalidateRect(hWnd, NULL, TRUE);
		return;
	}
#endif
	if ( wParam & MK_CONTROL ){ // CtrlctHgTCYExύX
		CursorTimerMode = CSRTM_OFF;
		KillTimer(hWnd, TIMERID_DRAGSCROLL);
		CancelMouse(hWnd);

		if ( VOsel.select != FALSE ){
			ResetSelect(TRUE);
			InvalidateRect(hWnd, NULL, TRUE);
		}

		if ( now != 0 ){
			if ( wParam & MK_SHIFT ){
				PPxCommonCommand(hWnd, 0, (now > 0) ? (WORD)(K_c | K_s | K_v | VK_ADD) : (WORD)(K_c | K_s | K_v | VK_SUBTRACT));
			}else{
				SetMag( (now > 0) ? IMGD_OFFSET : -IMGD_OFFSET );
			}
		}
		return;
	}else if ( wParam & MK_LBUTTON ){ // EXN[
		MoveCsrkey(-now * X_wheel / WHEEL_STANDARD_LINES * VO_stepX, 0, VOsel.select);
	}else if ( wParam & MK_MBUTTON ){
		MoveCsrkey(0, -now * VO_sizeY / WHEEL_STANDARD_LINES, VOsel.select);
	}else{
		int step;
#if 0
		if ( (vo_.DModeBit & VO_dmode_IMAGE) && !vo_.bitmap.page.animate &&
			 ((XV.img.imgD[imdD_MAG] == IMGD_WINDOWSIZE) ||
			  (XV.img.imgD[imdD_MAG] == IMGD_AUTOWINDOWSIZE) ||
			  (XV.img.imgD[imdD_MAG] == IMGD_WINDOWSIZE)) ){ // 摜
			if ( (now > 0) && (vo_.bitmap.page.current > 0) ){
				ChangePage( -1 );
				return;
			}
			if ( (now < 0) && (vo_.bitmap.page.current < vo_.bitmap.page.max) ){
				ChangePage( 1 );
				return;
			}
		}
#endif
		if ( X_pppv == '1' ){ // t@C؂ւ
			HWND hPPcWnd;
			const TCHAR *p = T("C");

			hPPcWnd = (hLastViewReqWnd != NULL) ?
					hLastViewReqWnd : GetPPxhWndFromID(&vinfo.info, &p, NULL);
			if ( hPPcWnd != NULL ){
				CursorTimerMode = CSRTM_OFF;
				KillTimer(hWnd, TIMERID_DRAGSCROLL);
				CancelMouse(hWnd);
				PostMessage(hPPcWnd, WM_PPXCOMMAND,
					now < 0 ? (K_raw | K_dw) : (K_raw | K_up), 0);
				PostMessage(hPPcWnd, WM_PPXCOMMAND, K_raw | 'N', 0);
				return;
			}
		}
		// XN[
		if ( ((VO_stepY * X_wheel) >= VO_sizeY) &&
			 ((now <= -X_wheel) || (now >= X_wheel)) ){
			// -now * X_wheel / X_wheel / WHEEL_STANDARD_LINES * VO_sizeY
			step = (-now * VO_sizeY) / WHEEL_STANDARD_LINES;
		}else{
			step = (-now * X_wheel * VO_stepY) / WHEEL_STANDARD_LINES;
		}
		MoveCsr(0, step, FALSE);
		if ( VOsel.cursor != FALSE ) SetCursorCaret(&VOsel.now);
	}
}

void H_WheelMouse(PPV_APPINFO *vinfo, WPARAM wParam, LPARAM lParam)
{
	POINT pos;

	LPARAMtoPOINT(pos, lParam);
	PPvMouseCommandPos(vinfo, &pos, (HISHORTINT(wParam) < 0) ? T("H") : T("I"), pos.y);
}

LRESULT USEFASTCALL PPvWmCommand(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	if ( lParam ){
		if ( (HWND)lParam == hToolBarWnd ){
			PPvToolbarCommand(LOWORD(wParam), 0);
			return 0;
		}
	}
	switch ( LOWORD(wParam) >> 12){
		case (IDW_MENU >> 12):
			PopupPosType = PPT_MOUSE;
			CommandDynamicMenu(&DynamicMenu, &vinfo.info, wParam);
			break;

		case 0xf: {				// f000-ffff System Menu ==============
			WORD cmdID;
			cmdID = (WORD)(wParam & 0xfff0);

			if ( (cmdID == SC_KEYMENU) || (cmdID == SC_MOUSEMENU) ){
				DynamicMenu.Sysmenu = TRUE;
			}

			if ( (cmdID == SC_MINIMIZE) && (X_tray & X_tray_PPv) ){
				PPxCommonCommand(hWnd, 0, K_HIDE);
				break;
			}

			return DefWindowProc(hWnd, WM_SYSCOMMAND, wParam, lParam);
		}

		default:
			XMessage(NULL, NULL, XM_NiERRld, T("Unknown WM_COMMAND:%x"), wParam);
			break;
	}
	return 0;
}

void USEFASTCALL PPvWmHscroll(HWND hWnd, WORD scrollcode)
{
	switch ( scrollcode ){
								// ԏ .............................
		case SB_TOP:
			MoveCsr(-VO_maxX, 0, FALSE);
			break;
								// ԉ .............................
		case SB_BOTTOM:
			MoveCsr(VO_maxX, 0, FALSE);
			break;
								// s .............................
		case SB_LINEUP:
			MoveCsr(-VO_stepX, 0, FALSE);
			break;
								// s .............................
		case SB_LINEDOWN:
			MoveCsr(VO_stepX, 0, FALSE);
			break;
								// ŏ .............................
		case SB_PAGEUP:
			MoveCsr(1-VO_sizeX, 0, FALSE);
			break;
								// ŉ .............................
		case SB_PAGEDOWN:
			MoveCsr(VO_sizeX-1, 0, FALSE);
			break;
								// ʒu܂ňړ .................
		case SB_THUMBTRACK:
			//SB_THUMBPOSITION ֑
								// ʒu܂ňړ ...................
		case SB_THUMBPOSITION:{
			SCROLLINFO scri;

			scri.cbSize = sizeof(scri);
			scri.fMask = SIF_TRACKPOS;
			GetScrollInfo(hWnd, SB_HORZ, &scri);
			MoveCsr(scri.nTrackPos - VOi->offX, 0, FALSE);
			break;
		}
	}
	if ( VOsel.cursor != FALSE ) SetCursorCaret(&VOsel.now);
}

void DDmul6432(UINTHL *src1, DWORD src2, DWORD *destL, DWORD *destM, DWORD *destH)
{
	DWORD tmpM;

	DDmul(src1->s.L, src2, destL, destM);
	DDmul(src1->s.H, src2, &tmpM, destH);
	AddDD(*destM, *destH, tmpM, 0);
}

// mul div 16bit͈͂Ɍ
void MulDiv6416(UINTHL *dest, DWORD mul, DWORD div)
{
	DWORD tmpL, tmpM, tmpH, tmp;

	DDmul6432(dest, mul, &tmpL, &tmpM, &tmpH);
//	*destH = tmpH / div;
	tmp = (tmpM >> 16) | ((tmpH % div) << 16);
	dest->s.H = (tmp / div) << 16;
	tmp = (tmpM & 0xffff) | ((tmp % div) << 16);
	dest->s.H |= tmp / div;
	tmp = (tmpL >> 16) | ((tmp % div) << 16);
	dest->s.L = (tmp / div) << 16;
	tmp = (tmpL & 0xffff) | ((tmp % div) << 16);
	dest->s.L |= tmp / div;
}

void USEFASTCALL PPvWmVscroll(HWND hWnd, WORD scrollcode, WORD range) // XN[
{
	int delta = 0;
	SCROLLINFO scri;

	if ( (FileDivideMode >= FDM_DIV) && (vo_.DModeBit & VO_dmode_TEXTLIKE) ){
		switch ( scrollcode ){
										// ԏ .............................
			case SB_TOP:
				if ( !(FileDividePointer.s.L | FileDividePointer.s.H) ){
					return;
				}
				LetHL_0(FileDividePointer);
				PPvReload(&vinfo);
				return;
										// ԉ .............................
			case SB_BOTTOM:
				GetDivMax(&FileDividePointer);
				VOi->offY = 0;
				PPvReload(&vinfo);
				return;
										// ʒu܂ňړ .................
			case SB_THUMBTRACK:
				//SB_THUMBPOSITION ֑
										// ʒu܂ňړ ...................
			case SB_THUMBPOSITION:
			{
				UINTHL divpos;

				divpos = FileRealSize;
				if ( (divpos.s.H != 0) || (divpos.s.L >= X_wsiz) ){
					SubUHLI(divpos, X_wsiz - 1);
				}else{
					divpos.s.L = 0;
				}
				MulDiv6416(&divpos, range, 0x4000);

				if ( (divpos.s.H == 0) &&
					 (divpos.s.L >= FileDividePointer.s.L) &&
					 (divpos.s.L < (FileDividePointer.s.L + X_wsiz)) ){
					delta = CalcMulDiv(VO_maxY, (divpos.s.L - FileDividePointer.s.L), X_wsiz);
					MoveCsr(0, delta - VOi->offY, FALSE);
					if ( VOsel.cursor != FALSE ) SetCursorCaret(&VOsel.now);
					return;
				}
				if ( scrollcode == SB_THUMBTRACK ){
					FileTrackPointer = divpos;
					EnableFileTrackPointer = TRUE;
					InvalidateRect(vinfo.info.hWnd, &BoxStatus, TRUE);
					return;
				}
				if ( vo_.DModeBit == DOCMODE_HEX ){ // AhXK
					divpos.s.L &= 0xffffff00;
				}
				FileDividePointer = divpos;
				VOi->offY = 0;
				PPvReload(&vinfo);
				return;
			}
		}
	}

	switch ( scrollcode ){
										// ԏ .............................
		case SB_TOP:
			delta = -VO_maxY;
			break;
										// ԉ .............................
		case SB_BOTTOM:
			delta = VO_maxY;
			break;
										// s .............................
		case SB_LINEUP:
			delta = -VO_stepY;
			break;
										// s .............................
		case SB_LINEDOWN:
			delta = VO_stepY;
			break;
										// ŏ .............................
		case SB_PAGEUP:
			delta = 1 - VO_sizeY;
			break;
										// ŉ .............................
		case SB_PAGEDOWN:
			delta = VO_sizeY - 1;
			break;
										// ʒu܂ňړ .................
		case SB_THUMBTRACK:
			//SB_THUMBPOSITION ֑
										// ʒu܂ňړ ...................
		case SB_THUMBPOSITION:
			scri.cbSize = sizeof(scri);
			scri.fMask = SIF_ALL | SIF_TRACKPOS;
			GetScrollInfo(hWnd, SB_VERT, &scri);

			delta = scri.nTrackPos - VOi->offY;
			if ( scri.nPage && WndSize.cy ){
				int barrange;

				barrange = scri.nMax / scri.nPage;
				if ( barrange > WndSize.cy ){ // ڍׂKvH
					if ( (GetKeyState(VK_SHIFT) | GetKeyState(VK_RBUTTON)) & KEYSTATE_PUSH ){
						detailmode = TRUE;
					}
					if ( detailmode ){
						delta = (scri.nPos - VOi->offY)
								- ((scri.nMax / 2) - scri.nTrackPos) /
									(barrange / WndSize.cy);
					}
				}
			}
			break;

		case SB_ENDSCROLL:
			if ( detailmode ){
				detailmode = FALSE;
				SetScrollBar();
			}
			break;
	}
	if ( delta ){
		MoveCsr(0, delta, detailmode);
		if ( VOsel.cursor != FALSE ) SetCursorCaret(&VOsel.now);
	}
}

/*=============================================================================
	WinMain
=============================================================================*/
#pragma warning(suppress:28251) // SDK ɂ hPrevInstance ̑قȂ
#pragma argsused
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	MSG msg;
	int result;
	THREADSTRUCT threadstruct = {PPvMainThreadName, XTHREAD_ROOT, NULL, 0, 0};
	UnUsedParam(hPrevInstance);UnUsedParam(lpCmdLine);

	hInst = hInstance;
#if NODLL
	InitCommonDll((HINSTANCE)hInst);
#endif
	PPxRegisterThread(&threadstruct);
	CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
	WinPos.show = (BYTE)nShowCmd;
	PPvHeap = GetProcessHeap();

	GlobalTextBuf.size = DISPTEXTBUFSIZE;
	GlobalTextBuf.buff = HeapAlloc(PPvHeap, 0, GlobalTextBuf.size);

	if ( InitializePPv(&result) == FALSE ) return result;
	PPxCommonExtCommand(K_TBB_INIT, 1);
#if USEDELAYCURSOR || SHOWFRAMERATE
	SetTimer(vinfo.info.hWnd, TIMERID_DRAW, TIME_FLOATDRAW, DrawTimerProc);
#endif
	if ( FirstCommand != NULL ){
		PostMessage(vinfo.info.hWnd, WM_PPXCOMMAND, K_FIRSTCMD, 0);
	}
	if ( IsExistCustTable(T("KV_main"), T("FIRSTEVENT")) ){
		PostMessage(vinfo.info.hWnd, WM_PPXCOMMAND, K_E_FIRST, 0);
	}
										// C[v -----------------------
	while( (int)GetMessage(&msg, NULL, 0, 0) > 0 ){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	HeapFree(PPvHeap, 0, GlobalTextBuf.buff);

	if ( hComdlg32 != NULL ) FreeLibrary(hComdlg32);
	if ( hWinmm != NULL ) FreeLibrary(hWinmm);
	PPxCommonCommand(NULL, 0, K_CLEANUP);
	PPxUnRegisterThread();
	CoUninitialize();
	return EXIT_SUCCESS;
}

/*=============================================================================
=============================================================================*/
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message){
		case WM_NCCREATE:
			if ( (X_dss & DSS_COMCTRL) && (OSver.dwMajorVersion >= 10) ){
				PPxCommonCommand(hWnd, 0, K_ENABLE_NC_SCALE);
			}
			return 1;

		case WM_COPYDATA:
			return WmCopyData((COPYDATASTRUCT *)lParam);

		case WM_DROPFILES:
			DoDropFiles(hWnd, (HDROP)wParam);
			break;

		case WM_MENUCHAR:
			if ( KeyChar ){
				KeyChar = FALSE;
				return 0;
			}
			// default Ȃ
		case WM_MENUSELECT:
		case WM_MENUDRAG:
		case WM_MENURBUTTONUP:
			return PPxMenuProc(hWnd, message, wParam, lParam);

		case WM_INITMENU:
			DynamicMenu_InitMenu(&DynamicMenu, (HMENU)wParam, X_win & XWIN_MENUBAR);
			break;

		case WM_INITMENUPOPUP:
			if ( (hDispTypeMenu != NULL) && ((HMENU)wParam == hDispTypeMenu) ){
				PPvAddDisplayTypeMenu(hDispTypeMenu, FALSE);
				hDispTypeMenu = NULL;
				break;
			}
			DynamicMenu_InitPopupMenu(&DynamicMenu, (HMENU)wParam, &vinfo.info);
			break;

		case WM_SETFOCUS:
			if ( vo_.DModeBit & VO_dmode_TEXTLIKE ){
				if ( VOsel.cursor != FALSE ){
					CreateCaret(hWnd, NULL, fontX, fontY);
					SetCaretPos(
						VOsel.now.x.pix - (VOi->offX * fontX) + XV_left + XV_lleft,
						VOsel.now.y.pix - (VOi->offY * LineY) + BoxView.top);
					ShowCaret(hWnd);
				}else{
					CreateCaret(hWnd, NULL, 0, 0);
					SetCaretPos(0, (LineY >> 1) + BoxView.top);
				}
			}
			if ( X_IME == 1 ) PostMessage(hWnd, WM_PPXCOMMAND, K_IMEOFF, 0);
			if ( IsTrue(UseActiveEvent) ){
				PostMessage(hWnd, WM_PPXCOMMAND, K_E_ACTIVE, 0);
			}
			if ( IsTrue(Embed) ){
				SendMessage(GetParent(hWnd), WM_PPXCOMMAND, KCW_focus, (LPARAM)hWnd);
			}
			InvalidateRect(hWnd, NULL, FALSE); // XPŃS~c̑΍
			break;

		case WM_KILLFOCUS:
			DestroyCaret();
			break;
							// }EẌړ
		case WM_MOUSEMOVE:
			DxTransformPoint(DxDraw, &lParam);
			ClkTime = GetMessageTime();
			PPxMoveMouse(&MouseStat, hWnd, lParam);
			PPvMouseMove(hWnd, &MouseStat, wParam, lParam);
			break;
							// }EX̍_uNbN
		case WM_NCLBUTTONUP:
		case WM_NCRBUTTONUP:
		case WM_NCMBUTTONUP:
		case WM_NCXBUTTONUP:
			if ( GetFocus() != hWnd ) break;
		case WM_NCLBUTTONDBLCLK:
		case WM_NCMBUTTONDBLCLK:
		case WM_NCRBUTTONDBLCLK:
		case WM_NCXBUTTONDBLCLK:
			return PPvNCMouseCommand(hWnd, message, wParam, lParam);

		case WM_NCRBUTTONDOWN:
			if ( wParam == HTCAPTION ) DynamicMenu.Sysmenu = TRUE;
		// WM_NCLBUTTONDOWN 
		case WM_NCLBUTTONDOWN:
			PopupPosType = PPT_MOUSE;
			return DefWindowProc(hWnd, message, wParam, lParam);

							// }EXXNbN
		case WM_LBUTTONDOWN:
		case WM_MBUTTONDOWN:
		case WM_RBUTTONDOWN:
		case WM_XBUTTONDOWN:
			DxTransformPoint(DxDraw, &lParam);
			PPxDownMouseButton(&MouseStat, hWnd, wParam, lParam);
			PPvDownMouse(hWnd, &MouseStat, wParam);
			break;

		case WM_CAPTURECHANGED:
			wParam = 0;
			lParam = 0;
			// WM_XBUTTONUP 
		case WM_LBUTTONUP:
		case WM_MBUTTONUP:
		case WM_RBUTTONUP:
		case WM_XBUTTONUP: {
			int oldmode, i;

			oldmode = MouseStat.mode;
			DxTransformPoint(DxDraw, &lParam);
			i = PPxUpMouseButton(&MouseStat, wParam);
			PPvUpMouse(hWnd, &MouseStat, i, oldmode, lParam);
			break;
		}
		case WM_LBUTTONDBLCLK:
		case WM_MBUTTONDBLCLK:
		case WM_RBUTTONDBLCLK:
		case WM_XBUTTONDBLCLK:
			DxTransformPoint(DxDraw, &lParam);
			PPxDoubleClickMouseButton(&MouseStat, hWnd, wParam, lParam);
			DoubleClickMouse(hWnd, &MouseStat);
			break;

		case WM_MOUSEWHEEL:
//			DxTransformPoint(DxDraw, &lParam); sv
			WheelMouse(hWnd, &MouseStat, wParam, lParam);
			break;
							// zC[̈ړ(E, Vistaȍ~)
		case WM_MOUSEHWHEEL:
			DxTransformPoint(DxDraw, &lParam);
			H_WheelMouse(&vinfo, wParam, lParam);
			break;

		case WM_MOUSEACTIVATE:
			if ( X_askp && (GetFocus() != hWnd) ){
				PPxCancelMouseButton(&MouseStat);
				return MA_ACTIVATEANDEAT;
			}
			if ( IsTrue(Embed) ) SetFocus(hWnd);
			return DefWindowProc(hWnd, message, wParam, lParam);

							// eRg[ (w:ID, lH:message, lL:CtrlHandle)
		case WM_SYSCOMMAND:
		case WM_COMMAND:
			return PPvWmCommand(hWnd, wParam, lParam);

							// Ԃ̕ύX
		case WM_WINDOWPOSCHANGED:
			WmWindowPosChanged(hWnd);
			break;
							// XN[
		case WM_VSCROLL:
			PPvWmVscroll(hWnd, LOWORD(wParam), HIWORD(wParam));
			break;
							// XN[
		case WM_HSCROLL:
			PPvWmHscroll(hWnd, LOWORD(wParam));
			break;
							// ALT+? ꂽ(w:z key, lH:l, lL:repeat)--
		case WM_SYSKEYDOWN:
			if ( !(lParam & B29) ) SetFocus(hWnd);
			// WM_KEYDOWN 
							// key   ꂽ(w:z key, lH:l, lL:repeat)--
		case WM_KEYDOWN:{
			WORD key;

			StopPopMsg(PMF_WAITKEY | PMF_FLASH);
			KeyChar = TRUE;
										// [ALT]  j[ڍs֎~
			key = (WORD)(wParam | GetShiftKey() | K_v);
			PopupPosType = PPT_FOCUS;

			if ( KeyHookEntry != NULL ){
				if ( CallKeyHook(key) != PPXMRESULT_SKIP ) break;
			}

			if ( PPvCommand(&vinfo, key) == ERROR_INVALID_FUNCTION ){
				if ( X_alt && (wParam == VK_MENU) ) break;
				return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		}
							// key   ꂽ(w:key, lH:l, lL:repeat)--
		case WM_SYSCHAR:
		case WM_CHAR: {
			WORD key;

			KeyChar = FALSE;
			key = (WORD)wParam;

#ifndef UNICODE
			if ( multichar != FALSE ){
				multichar = FALSE;
				break;
			}
			if ( IskanjiA(key) ){
				multichar = TRUE;
				SetPopMsg(POPMSG_NOLOGMSG, MES_EKCD, PMF_DOCMSG);
			}
#endif
			if ( key < 0x80 ){
				PopupPosType = PPT_FOCUS;

				if ( KeyHookEntry != NULL ){
					if ( CallKeyHook(FixCharKeycode(key)) != PPXMRESULT_SKIP ){
						break;
					}
				}

				if ( PPvCommand(&vinfo, FixCharKeycode(key)) == NO_ERROR ){
					break;
				}
			}
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
							// ̍ĕ`(w:gp, l:gp) ------------------
		case WM_PAINT:
			Paint(hWnd);
			break;

		case WM_CLOSE:
			if ( (hViewReqWnd != NULL) && (GetFocus() != FALSE) ){
				SetForegroundWindow(hViewReqWnd);
			}
			return DefWindowProc(hWnd, message, wParam, lParam);
							// ̔j, I(w:gp, l:gp) ---------
		case WM_DESTROY:
			DestroyPPv();
			PostQuitMessage(EXIT_SUCCESS);	// ŏI
			break;
							// Iv(w:gp, l:gp) ---------------
// w=0 logoff   w != 0 [Uɂ邱̃\tg̋I
//		case WM_QUERYENDSESSION:
//			return (long)TRUE;	// TRUE ȂΏI, FALSE ȂI̋
							// I̕ -----------------------------
		case WM_ENDSESSION:
			if ( wParam ){	// TRUE:ZbV̏I(WM_DESTROY ͒ʒmȂ)
				PPxCommonExtCommand(K_REPORTSHUTDOWN, 0);
				DestroyPPv();
								// ԂȂ̂łőŜ̌nȂ
				PostQuitMessage(EXIT_SUCCESS);
			}
			break;
//		case WM_PALETTEISCHANGING: // pbg̎̉ʒm:sv

		case WM_PALETTECHANGED:
			if ( (HWND)wParam == hWnd) break;
			// WM_QUERYNEWPALETTE 
		case WM_QUERYNEWPALETTE:
			if ( vo_.bitmap.hPal != NULL ){
				HDC hDC;
				HPALETTE hOldPal;
				int redraw;

				hDC = GetDC(hWnd);
				hOldPal = SelectPalette(hDC, vo_.bitmap.hPal, 0);
				redraw = RealizePalette(hDC);
				SelectPalette(hDC, hOldPal, 0);
				ReleaseDC(hWnd, hDC);
				if ( redraw ) InvalidateRect(hWnd, NULL, FALSE);
			}
			break;

		case WM_SETTINGCHANGE:
			if ( (wParam == 0) && (lParam != 0) && (*(char *)lParam == 'I') ){ // "ImmersiveColorSet" ̊ȈՔ
				if ( PPvSettingChange(hWnd) ) InvalidateRect(hWnd, NULL, TRUE);
			}
//			PPxCommonCommand(hWnd, lParam, K_SETTINGCHANGE);
			return DefWindowProc(hWnd, message, wParam, lParam);

		case WM_SYSCOLORCHANGE:
			PPvCommand(&vinfo, K_Scust);
			PPvCommand(&vinfo, K_Lcust);
			FreeOffScreen(&BackScreen);
			break;

		case WM_DISPLAYCHANGE:{
			HDC hDC;

			hDC = GetDC(hWnd);
			VideoBits = GetDeviceCaps(hDC, BITSPIXEL);
			ReleaseDC(hWnd, hDC);
			ChangeSizeDxDraw(DxDraw, C_back); // DXŕKvBDWł͕sv
			InvalidateRect(hWnd, NULL, TRUE);
			break;
		}

		case WM_NOTIFY:
			return PPvNotify((NMHDR *)lParam);

//		case WM_DESTROYCLIPBOARD:	// ݂ TEXT, DIB ݂̂̂߁Asv

		//  WM_GETOBJECTwParam/lParam64bitł͏32bitp
		case WM_GETOBJECT:
			if ( ((DWORD)lParam == (DWORD)OBJID_CLIENT) && X_iacc ){
				return WmGetObject(wParam, lParam);
			}
			return DefWindowProc(hWnd, message, wParam, lParam);

		case WM_GESTURE:
			return WMGesture(hWnd, wParam, lParam);

		case WM_DPICHANGED:
			WMDpiChanged(hWnd, wParam, (RECT *)lParam);
			break;

							// mȂbZ[W -----------------------------
		default:
			if ( message == WM_PPXCOMMAND ){
				return PPvPPxCommand(&vinfo, wParam, lParam);
			}
			return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}
