/*-----------------------------------------------------------------------------
	Paper Plane tray	Main
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include "PPX.H"
#include "VFS.H"
#include "PPTRAY.RH"

#define WM_TRAY_T		(WM_APP + 1060)	// Task Tray ̎MɎgp
#define TRAYID			0
#define HOTKEYID 0xe000

HINSTANCE hInst;
int X_HookEdit = 0;
DWORD WM_TASKBARCREATE = MAX32;				// ^XNo[쐬ꂽ
DWORD WM_PPXCOMMAND    = MAX32;

HWND hCommonWnd = NULL;
int UseCount = 0;
HWND hForegroundWnd = NULL;

UINT *HotKeys;	// o^zbgL[ö
struct BUTTONS {	// {^̃GCAX`e[u
	UINT msg;
	TCHAR *name;
} buttonname[] = {
	{WM_LBUTTONDOWN,	T("L_ICON")},
	{WM_LBUTTONDBLCLK,	T("LD_ICON")},
	{WM_MBUTTONDOWN,	T("M_ICON")},
	{WM_MBUTTONDBLCLK,	T("MD_ICON")},
	{WM_RBUTTONDOWN,	T("R_ICON")},
	{WM_RBUTTONDBLCLK,	T("RD_ICON")},
	{WM_XBUTTONDOWN,	T("X_ICON")},
	{WM_XBUTTONDBLCLK,	T("XD_ICON")},
	{0, NULL}
};

const TCHAR TRAYCCLASS[] = T(PPTrayWinClass) T("C");
const TCHAR TRAYCLASS[] = T(PPTrayWinClass);

TCHAR PPTrayMainThreadName[] = T("PPtray main");
TCHAR PPTrayRegID[REGIDSIZE] = T(PPTRAY_REGID) T("A");
enum { HOOKSW = 100, EXITCMD };
const TCHAR HookStr[] = MES_CTHE;
const TCHAR ExitStr[] = MES_EXIT;

DWORD_PTR USECDECL PPtrayInfoFunc(PPXAPPINFO *info, DWORD cmdID, PPXAPPINFOUNION *uptr);
PPXAPPINFO PPtrayInfo = {(PPXAPPINFOFUNCTION)PPtrayInfoFunc, TRAYCLASS, PPTrayRegID, NULL};

const TCHAR StrK_tray[] = T("K_tray");

ERRORCODE PPXAPI PPtrayCommand(PPXAPPINFO *info, WORD key)
{
	return PPxCommonCommand(info->hWnd, 0, key);
}

const EXECKEYCOMMANDSTRUCT TrayExecKey = {PPtrayCommand, StrK_tray, NULL};

#pragma argsused
DWORD_PTR USECDECL PPtrayInfoFunc(PPXAPPINFO *info, DWORD cmdID, PPXAPPINFOUNION *uptr)
{
	UnUsedParam(info);

	switch(cmdID){
		case PPXCMDID_GETFGWND:
			return (DWORD_PTR)hForegroundWnd;

		default:
			if ( cmdID <= PPXCMDID_FILL ) *uptr->enums.buffer = '\0';
			return PPXA_INVALID_FUNCTION;
	}
}

// zbgL[ =============================================================
//-------------------------------------- zbgL[̊蓖ď
void SetHotKey(HWND hWnd)
{
	TCHAR key[CUST_NAME_LENGTH], buf[MAX_PATH];
	CTCHAR *p;
	int keycode, vkey, i, maxi;
	UINT *hk;

	HotKeys = NULL;
	maxi = CountCustTable(StrK_tray);
	if ( maxi == 0 ) return;
	hk = HotKeys = HeapAlloc(GetProcessHeap(), 0, (maxi + 1) * sizeof hk[0]);

	for ( i = 0 ; i < maxi ; i++ ){
		if ( EnumCustTable(i, StrK_tray, key, buf, 0) < 0 ) break;
		p = key;
		*hk++ = keycode = GetKeyCode(&p);
		if ( keycode < 0 ){
			XMessage(hWnd, T("PPtray"), XM_FaERRd, MES_EBDK, key);
			continue;
		}
										// RegisterHotKey p̃L[R[h쐬
		vkey = keycode & 0xff;
		if ( !(keycode & K_v) ){
			vkey = VkKeyScan((TCHAR)vkey);
			vkey &= 0xff;
		}
										// zbgL[o^
		if ( FALSE == RegisterHotKey(hWnd, keycode,
						((keycode & K_e) ? MOD_WIN : 0) |
						((keycode & K_s) ? MOD_SHIFT : 0) |
						((keycode & K_c) ? MOD_CONTROL : 0) |
						((keycode & K_a) ? MOD_ALT : 0), vkey) ){
			XMessage(hWnd, T("PPtray"), XM_FaERRd, MES_EHKY, key);
		}
	}
	*hk = 0;
}
//-------------------------------------- zbgL[蓖ĂSĉ
void FreeHotKey(HWND hWnd)
{
	UINT *hk;

	if ( HotKeys == NULL ) return;
	for ( hk = HotKeys ; *hk ; hk++ ) UnregisterHotKey(hWnd, *hk);
	HeapFree( GetProcessHeap(), 0, HotKeys );
	HotKeys = NULL;
}

// PPxi[pWindowǗ ========================================================
LRESULT CALLBACK CommonWindow(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg){
		case WM_SETFOCUS:
			SetForegroundWindow(PPcGetWindow(0, CGETW_GETFOCUS));
			break;
							// ̔j,I(w:gp, l:gp) -----------
		case WM_DESTROY:
			hCommonWnd = NULL;
			// default 
		default:
			if ( uMsg == WM_PPXCOMMAND ){
				if ( (WORD)wParam == KRN_freecwnd ){
					UseCount--;
					if ( UseCount <= 0 ){
						UseCount = 0;
						SendMessage(hWnd, WM_CLOSE, 0, 0);
					}
				}
				return ERROR_INVALID_FUNCTION;
			}
			return DefWindowProc(hWnd, uMsg, wParam, lParam);
	}
	return 0;
}

HWND GetCommonWnd(void)
{
	if ( hCommonWnd == NULL ){
		WNDCLASS wndClass;

		wndClass.style			= 0;
		wndClass.lpfnWndProc	= CommonWindow;
		wndClass.cbClsExtra		= 0;
		wndClass.cbWndExtra		= 0;
		wndClass.hInstance		= hInst;
		wndClass.hIcon			= LoadIcon(hInst, MAKEINTRESOURCE(IDI_TRAY));
		wndClass.hCursor		= NULL;
		wndClass.hbrBackground	= NULL;
		wndClass.lpszMenuName	= NULL;
		wndClass.lpszClassName	= TRAYCCLASS;
											// NXo^
		RegisterClass(&wndClass);
		hCommonWnd = CreateWindow(TRAYCCLASS, T("PPx"),
				WS_POPUPWINDOW | WS_CAPTION | WS_MINIMIZEBOX,
				0, 0, 0, 0, NULL, NULL, hInst, 0);
		ShowWindow(hCommonWnd, SW_SHOW);
	}
	UseCount++;
	return hCommonWnd;
}

// gCǗ =================================================================
// gC̃bZ[W -------------------------------------------
BOOL TrayMessage(HWND hWnd, DWORD Message, WORD Icon, const TCHAR *TipStr)
{
	NOTIFYICONDATA tnd;

	tnd.cbSize				= sizeof(NOTIFYICONDATA);
	tnd.hWnd				= hWnd;
	tnd.uID					= TRAYID;
	tnd.uFlags				= NIF_MESSAGE;
	tnd.uCallbackMessage	= WM_TRAY_T;
	if ( Icon ){
		tnd.hIcon = LoadIcon(hInst, MAKEINTRESOURCE(Icon));
		setflag(tnd.uFlags, NIF_ICON);
	}
	if ( TipStr ){
		setflag(tnd.uFlags, NIF_TIP);
		tstrcpy(tnd.szTip, TipStr);
	}
	return Shell_NotifyIcon(Message, &tnd);
}
//-------------------------------------- PPtray ̃Cj[
void TrayMenu(HWND hWnd)
{
	POINT pos;
	HMENU popup;
	int i;

	SetForegroundWindow(hWnd);	// ܂ȂQ
	GetMessagePosPoint(pos);

	popup = CreatePopupMenu();
	AppendMenu(popup, MF_CHKES(X_HookEdit), HOOKSW, MessageText(HookStr));
	AppendMenu(popup, MF_ES, EXITCMD, MessageText(ExitStr));

	i = TrackPopupMenu(popup, TPM_TDEFAULT, pos.x, pos.y, 0, hWnd, NULL);
	DestroyMenu(popup);
	switch (i){
		case EXITCMD:	// Exit -----------------------------------
			PostMessage(hWnd, WM_CLOSE, 0, 0);
			break;

		case HOOKSW:	// X_HookEdit ------------------------------
			X_HookEdit = X_HookEdit ? 0 : 1;
			PPxHookEdit( X_HookEdit ? 0 : -1 );
			SetCustData(T("X_eedit"), &X_HookEdit, sizeof(X_HookEdit));
			break;
//		default: // gp
	}
}

//-------------------------------------- PPtray ̊eR}h̎s
void TrayCommand(HWND hWnd, UINT mes)
{
	struct BUTTONS *b;
	TCHAR buf[CMDLINESIZE];
										// ENbN:Cj[ ----------
	if ( mes == WM_RBUTTONDOWN ){
		TrayMenu(hWnd);
		return;
	}
										// zbgL[ -------------------------
	if ( (mes & HOTKEYID) == HOTKEYID ){
		ExecKeyCommand(&TrayExecKey, &PPtrayInfo, (WORD)(mes & ~HOTKEYID));
		return;
	}
										// NbNs -----------------------
	for ( b = buttonname ; b->msg != 0 ; b++ ){
		if ( b->msg == mes ) break;
	}
	if ( b->msg == 0 ) return;
	SetForegroundWindow(hWnd);	// ܂ȂQ
	if ( NO_ERROR == GetCustTable(T("MT_icon"), b->name, &buf, sizeof buf) ){
		if ( (UTCHAR)buf[0] == EXTCMD_CMD ){
			PP_ExtractMacro(hWnd, &PPtrayInfo, NULL, buf + 1, NULL, 0);
		}
	}else{
		PP_ExtractMacro(hWnd, NULL, NULL, T("*SELECTPPX"), NULL, 0);
	}
}

LRESULT CALLBACK TrayWindow(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg){
		case WM_CREATE:
			TrayMessage(hWnd, NIM_ADD, IDI_TRAY, T("PPtray"));
			break;

		case WM_HOTKEY:
			PostMessage(hWnd, WM_COMMAND, wParam | HOTKEYID, 0); // ܂ȂP
			break;
							// ̔j,I(w:gp, l:gp) -----------
		case WM_DESTROY: {
			PPXMODULEPARAM pmp = {NULL};

			ExecKeyCommand(&TrayExecKey, &PPtrayInfo, K_E_CLOSE);
			CallModule(&PPtrayInfo, PPXMEVENT_DESTROY, pmp, NULL);

			FreeHotKey(hWnd);
			TrayMessage(hWnd, NIM_DELETE, 0, NULL);
			PostQuitMessage(EXIT_SUCCESS);	// ŏI
			break;
		}
							// I̕ -----------------------------
		case WM_ENDSESSION:
			if ( wParam == 0 ) break;
							// TRUE:ZbV̏I(WM_DESTROY ͒ʒmȂ)
			FreeHotKey(hWnd);
			TrayMessage(hWnd, NIM_DELETE, 0, NULL);
			break;

		case WM_COMMAND:
			TrayCommand( hWnd, LOWORD(wParam) );
			break;

		case WM_TRAY_T:
			// _uNbNɊɃj[JĂƂ̓j[
			// _uNbNɃEBhEJĂtH[JXړłȂ
			if ( (lParam == WM_LBUTTONDBLCLK) ||
				 (lParam == WM_RBUTTONDBLCLK) ||
				 (lParam == WM_MBUTTONDBLCLK) ||
				 (lParam == WM_XBUTTONDBLCLK) ){
				HWND hMenuWnd;

				hMenuWnd = FindWindow(T(WNDCLASS_POPUPMENU), NULL);
				if ( hMenuWnd != NULL ) PostMessage(hMenuWnd, WM_CLOSE, 0, 0);
			}
			PostMessage(hWnd, WM_COMMAND, lParam, 0); // ܂ȂP
			break;

		default:
			if ( uMsg == WM_PPXCOMMAND ){
				if ( (WORD)wParam == K_Lcust ){	// ăJX^}CY -------------
					FreeHotKey(hWnd);
					SetHotKey(hWnd);
				}
				if ( (WORD)wParam == KRN_getcwnd ){
					return (LRESULT)GetCommonWnd();
				}
				return PPxCommonCommand(hWnd, 0, (WORD)wParam);
			}
			if ( uMsg == WM_TASKBARCREATE ){
				TrayMessage(hWnd, NIM_ADD, IDI_TRAY, T("PPtray"));
				break;
			}
			return DefWindowProc(hWnd, uMsg, wParam, lParam);
	}
	return 0;
}
//-----------------------------------------------------------------------------
#pragma warning(suppress:28251) // SDK ɂ hPrevInstance ̑قȂ
#pragma argsused
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
	WNDCLASS wndClass;
	MSG msg;
	HWND hWnd;
	THREADSTRUCT threadstruct = {PPTrayMainThreadName, XTHREAD_ROOT, NULL, 0, 0};
	CTCHAR *param;

#ifdef UNICODE
	TCHAR buf[CMDLINESIZE];
	UnUsedParam(hInstance);UnUsedParam(hPrevInstance);UnUsedParam(lpCmdLine);UnUsedParam(nShowCmd);

	PPxRegisterThread(&threadstruct);
	param = GetCommandLine();
	GetLineParamS((const TCHAR **)&param, buf, TSIZEOF(buf));
#else
	UnUsedParam(hInstance);UnUsedParam(hPrevInstance);UnUsedParam(nShowCmd);

	PPxRegisterThread(&threadstruct);
	param = lpCmdLine;
#endif
	SkipSpace((const TCHAR **)&param);	// 󔒍폜
	if ( (*param == '-') || (*param == '/') ){		// IvV
		TCHAR option;

		CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
		PPxCommonCommand(NULL, JOBSTATE_NORMAL, K_ADDJOBTASK);
		option = TinyCharLower(*(param + 1));
		param += 2;
		SkipSpace(&param);
		if ( option == 'c' ){	// -c command R}hs
			PP_ExtractMacro(NULL, NULL, NULL, param, NULL, XEO_NOUSEPPB);
		}else if ( option == 'b' ){	// -b filename ob`t@Cws
			TCHAR *top = NULL, *text;

			if ( LoadTextImage(param, &top, &text, NULL) == NO_ERROR ){
				PP_ExtractMacro(NULL, NULL, NULL, text, NULL, XEO_NOUSEPPB);
				HeapFree(GetProcessHeap(), 0, top);
			}
		}
		PPxCommonCommand(NULL, 0, K_DELETEJOBTASK);
		CoUninitialize();
		return EXIT_SUCCESS;
	}
															// dN̋֎~
	if ( PPxRegist(PPXREGIST_DUMMYHWND, PPTrayRegID, PPXREGIST_IDASSIGN) < 0 ){
		return EXIT_FAILURE;
	}
	hInst = hInstance;
	CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
	PPxCommonExtCommand(K_UxTheme, KUT_INIT);
	WM_TASKBARCREATE = RegisterWindowMessage(T(WMTASKBARCREATE));
	WM_PPXCOMMAND = RegisterWindowMessage(T(PPXCOMMAND_WM));
										// EChENX` ---------
	wndClass.style			= 0;
	wndClass.lpfnWndProc	= TrayWindow;
	wndClass.cbClsExtra		= 0;
	wndClass.cbWndExtra		= 0;
	wndClass.hInstance		= hInst;
	wndClass.hIcon			= NULL;
	wndClass.hCursor		= NULL;
	wndClass.hbrBackground	= NULL;
	wndClass.lpszMenuName	= NULL;
	wndClass.lpszClassName	= TRAYCLASS;
	RegisterClass(&wndClass);

	PPtrayInfo.hWnd = hWnd = CreateWindow(TRAYCLASS, NULL, 0, 0, 0, 0, 0, NULL, NULL, hInst, 0);

	PPxRegist(hWnd, PPTrayRegID, PPXREGIST_SETHWND);
	GetCustData(T("X_eedit"), &X_HookEdit, sizeof(X_HookEdit));
	if ( X_HookEdit ) PPxHookEdit(0);

	ShowWindow(hWnd, SW_HIDE);
	SetHotKey(hWnd);
	ExecKeyCommand(&TrayExecKey, &PPtrayInfo, K_E_FIRST);

	while( (int)GetMessage(&msg, NULL, 0, 0) > 0 ){
//		TranslateMessage(&msg);	//  WM_CHAR gpȂ̂ŃRgAEg
		DispatchMessage(&msg);
	}
	PPxRegist(hWnd, PPTrayRegID, PPXREGIST_FREE);
	if ( X_HookEdit ) PPxHookEdit(-1);

	PPxCommonCommand(NULL, 0, K_UNHIDEALL); //i[Ăǂo
	PPxCommonCommand(NULL, 0, K_CLEANUP);
	PPxUnRegisterThread();
	CoUninitialize();
	return EXIT_SUCCESS;
}
