/*-----------------------------------------------------------------------------
	Paper Plane xUI	 commom library							񑀍
-----------------------------------------------------------------------------*/
#define ONPPXDLL		// PPCOMMON.H  DLL `w
#include "WINAPI.H"
#include "PPX.H"
#include "PPD_DEF.H"
#pragma hdrstop

#define DEFINE_memsearch
#define DEFINE_tstrreplace
#define DEFINE_tstpmaxcpy
#define DEFINE_tstplimcpy
#define DEFINE_tstpcpy
#define DEFINE_stpcpyA
#define DEFINE_tstrchr
#define DEFINE_tstrrchr
#define DEFINE_tstristr
#define DEFINE_bchrlen
#define DEFINE_SearchVLINE
#define DEFINE_strstrW

#include "tstrings.c"

#ifndef UNICODE
const BYTE ZHtbl[] =
	"@Ihfij{C|D^"	// 2x 000
	"OPQRSTUVWXFGH"	// 3x 020
	"`abcdefghijklmn"	// 4x 040
	"opqrstuvwxymnOQ"	// 5x 080
	"e"	// 6x 0a0
	"obp`"	// 7x 0c0
	"BuvAE@BDFHb"	// ax 0e0
	"[ACEGIJLNPRTVXZ\"	// bx 100
	"^`cegijklmnqtwz}"	// cx 120
	"~JK"	// dx 140

	"KMOQSUWY[]_adfho"	// etc 160
	"rux{psvy|";				//     180-191
#else
const WCHAR ZHtbl[] = L"BuvAE@BDFHb[ACEGIJLNPRTVXZ\^`cegijklmnqtwz}~JKKMOQSUWY[]_adfhorux{psvy|";
#endif

// 1bytes   2bytes ϊ ---------------------------------------------
PPXDLL TCHAR * PPXAPI Strsd(TCHAR *dststr, const TCHAR *srcstr)
{
	const UTCHAR *src;
	UTCHAR *dst, code;

	src = (const UTCHAR *)srcstr;
	dst = (UTCHAR *)dststr;

	for ( ; (code = *src) != '\0' ; src++ ){
		#ifdef UNICODE
		if ( code == L' ' ){
			*dst++ = L'@';
			continue;
		}
		if ( code == L'\\' ){
			*dst++ = L'';
			continue;
		}
		if ( (code >= L'!') && (code <= L'~') ){
			*dst++ = (UTCHAR)(*src + (L'I' - L'!'));
			continue;
		}
		if ( (code >= L'') && (code <= L'') ){
			*dst = (UTCHAR)ZHtbl[code - L''];
			if ( *(src + 1) == L'' ){
				if ( (code >= L'') && (code <= L'') ){
					src++;
					(*dst)++;
				}else if ( (code >= L'') && (code <= L'') ){
					src++;
					(*dst)++;
				}else if (code == L'' ){
					src++;
					*dst = L'';
				}
			}else if ( (*(src + 1) == L'') &&
						(code >= L'') && (code <= L'') ){
				src++;
				*dst += (UTCHAR)2;
			}
			dst++;
			continue;
		}
		#else
		const BYTE *p;

		if ( (code >= 0x20) && (code < 0x80) ){
			p = &ZHtbl[(code - 0x20) << 1];
			*dst++ = *p++;
			*dst++ = *p;
			continue;
		}
		if ( (code >= 0xa0) && (code < 0xe0) ){

			p = &ZHtbl[(code - 0x20 - 0x20) << 1];
			if ( *(src + 1) == (BYTE)'' ){
				if ( (code >= (BYTE)'') && (code <= (BYTE)'') ){
					src++;
					p += 0x2a * 2;
				}else if ( (code >= (BYTE)'') && (code <= (BYTE)'') ){
					src++;
					p += (0x2a - 5) * 2;
				}else if (code == (BYTE)'' ){
					src++;
					p = (BYTE *)"";
				}
			}else if ( (*(src + 1) == (BYTE)'') &&
						(code >= (BYTE)'') && (code <= (BYTE)'') ){
				src++;
				p += 0x2a * 2;
			}
			*dst++ = *p++;
			*dst++ = *p;
			continue;
		}
		if ( IskanjiA(code) && *(src + 1) ) *dst++ = *src++;
		#endif
		*dst++ = *src;
	}
	*dst = '\0';
	return (TCHAR *)dst;
}

// 2bytes   1bytes ϊ ---------------------------------------------
PPXDLL TCHAR * PPXAPI Strds(TCHAR *dststr, const TCHAR *srcstr)
{
	const UTCHAR *src;
	UTCHAR *dst;

	src = (const UTCHAR *)srcstr;
	dst = (UTCHAR *)dststr;
	for ( ; *src ; src++ ){
		#ifdef UNICODE
		if ( *src == L'[' ){
			*dst++ = L'';
			continue;
		}
		if ( *src == L'E' ){
			*dst++ = L'';
			continue;
		}
		if ( *src == L'' ){
			*dst++ = L'\\';
			continue;
		}
		if ( (*src >= L'I') && (*src <= L'`') ){
			*dst++ = (UTCHAR)(*src - (L'I' - L'!'));
			continue;
		}
		if ( (*src >= L'@') && (*src <= L'B') ){
			if ( *src == L'@' ){
				*dst++ = L' ';
			}else{
				*dst++ = *src == L'B' ? L'' : L'';
			}
			continue;
		}
		if ( (*src >= L'u') && (*src <= L'v') ){
			*dst++ = (WCHAR)(*src + (L'' - L'u'));
			continue;
		}

		if ( (*src >= L'J') && (*src <= L'') ){
			WCHAR c, off;
			const WCHAR *p;

			if ( *src == L'' ){
				*dst++ = L'';
				*dst++ = L'';
				continue;
			}

			c = *src;
			for ( p = ZHtbl ; *p ; p++ ){
				if ( *p != c ) continue;
				off = (WCHAR)(p - ZHtbl);
				if ( off < 0x3f ){
					c = (WCHAR)(L'' + off);
					break;
				}
				if ( off < (0x3f + 20) ){
					if ( off >= (0x3f + 15) ) off += (WCHAR)5;
					*dst++ = (WCHAR)(L'' + off - 0x3f + 21);
					c = L'';
					break;
				}
				*dst++ = (WCHAR)(L'' + off - 0x3f -20 + 41);
				c = L'';
				break;
			}
			*dst++ = c;
			continue;
		}
		#else
		const BYTE *p;
		BYTE c1, c2;

		if ( IskanjiA(*src) ){
			if ( (*src >= 0x81) && (*src <= 0x83) ){
				c1 = *src;
				c2 = *(src + 1);
				for( p = ZHtbl ; *p ; p += 2){
					if ( (*(p + 1) == c2 ) && (*p == c1) ){
						c1 = (BYTE)(((p - ZHtbl) >> 1) + 0x20);
						c2 = 0;
						if ( c1 >= (BYTE)0x80 ) c1 += (BYTE)0x20;
						if ( c1 >= 0xe0 ){
							if ( c1 < 0xf4 ){
								c1 -= (c1 < 0xef) ? (BYTE)0x2a : (BYTE)0x25;
								c2 = '';
							}else{
								c1 -= (BYTE)0x2a;
								c2 = '';
							}
						}
						src++;
						*dst++ = c1;
						if (c2) *dst++ = c2;
						goto next;
					}
				}
				if ( (c1 == (BYTE)0x83) && (c2 == (BYTE)0x94) ){ // 
					src++;
					*dst++ = '';
					*dst++ = '';
					goto next;
				}
			}
			*dst++ = *src++;
		}
		#endif
		*dst++ = *src;
#ifndef UNICODE
next:
;	// cl.exe ͕K{H
#endif
	}
	*dst = 0;
	return (TCHAR *)dst;
}

// Ή -----------------------------------------------------------
PPXDLL TCHAR * PPXAPI Strlwr(TCHAR *str)
{
	TCHAR *ptr, type;

	for ( ptr = str ; *ptr ; ptr++){
	#ifdef UNICODE
		type = *ptr;
		if ( (type >= 'A') && (type <= 'Z') ){
			*ptr += (TCHAR)('a' - 'A');
			continue;
		}
		if ( (type >= L'`') && (type <= L'y') ){
			*ptr += (TCHAR)(L'' - L'`');
			continue;
		}
	#else
		type = T_CHRTYPE[(unsigned char)(*ptr)];
		if ( type & T_IS_KNJ ){			// ̏ꍇ̏
			unsigned char code;

			code = *(unsigned char *)ptr++;
			if ( !code ) break;
			if ( (code == 0x82) &&	((unsigned char)*ptr >= 0x60) &&
									((unsigned char)*ptr <= 0x79) ){
				*ptr += (char)0x21;
			}
		}else{
			if (type & T_IS_UPP) *ptr += (char)0x20;
		}
	#endif
	}
	return ptr;
}

// Ή啶 -----------------------------------------------------------
PPXDLL TCHAR * PPXAPI Strupr(TCHAR *str)
{
	TCHAR *ptr, type;

	for ( ptr = str ; *ptr ; ptr++){
	#ifdef UNICODE
		type = *ptr;
		if ( (type >= 'a') && (type <= 'z') ){
			*ptr -= (TCHAR)('a' - 'A');
			continue;
		}
		if ( (type >= L'') && (type <= L'') ){
			*ptr -= (TCHAR)(L'' - L'`');
			continue;
		}
	#else
		type = T_CHRTYPE[(unsigned char)(*ptr)];
		if ( type & T_IS_KNJ ){			// ̏ꍇ̏
			unsigned char code;

			code = *(unsigned char *)ptr++;
			if ( !code ) break;
			if ( (code == 0x82) &&	((unsigned char)*ptr >= 0x81) &&
									((unsigned char)*ptr <= 0x9A) ){
				*ptr -= (char)0x21;
			}
		}else{
			if (type & T_IS_LOW) *ptr -= (char)0x20;
		}
	#endif
	}
	return ptr;
}

/*-----------------------------------------------------------------------------
	󔒂ǂݔ΂(L)
-----------------------------------------------------------------------------*/
TCHAR *SkipSpaceAndFix(TCHAR *str)
{
	while( *str != '\0' ){
		if ( *str == ' ' ){
			str++;
			continue;
		}
		if ( *str == '\t' ){
			*str++ = ' ';
			continue;
		}
		if ( (*str == '\r') || (*str == '\n') ){
			*str = '\0';
			if ( (*(str + 1) == '\r') || (*(str + 1) == '\n') ) str++;
		}
		break;
	}
	return str;
}

const TCHAR *EscapeMacrochar(const TCHAR *string, TCHAR *buf)
{
	const TCHAR *src;

	src = tstrchr(string, '%');
	if ( src == NULL ) return string;
	tstrcpy(buf, string);
	tstrreplace(buf, T("%"), T("%%"));
	return buf;
}

typedef struct {
	void *buffer;
	int buflen;
	const TCHAR *src;
	TCHAR *dest;
	int left, columns;
	TCHAR space;
} THPRINTF_STRUCT;


#define thprintf_dest(buffer) ((TCHAR *)(char *)(((ThSTRUCT *)(buffer))->bottom + ((ThSTRUCT *)(buffer))->top))
#define thprintf_left(buffer) ((size_t)(((ThSTRUCT *)(buffer))->size - ((ThSTRUCT *)(buffer))->top) / sizeof(TCHAR) - 1)
#define thprintf_set_top(buffer, dest) (((ThSTRUCT *)(buffer))->top = (char *)(dest) - ((ThSTRUCT *)(buffer))->bottom)

#if defined(__WINE__) && defined(_WIN64)
	// x64  gcc + libc ̏ꍇ́Ava_list ẑ߁ALXgKv
	// mingw ̏ꍇ́Azł͖
	#define VA_LIST_POINTER(arglist) ((va_list *)(arglist))
#else
	#define VA_LIST_POINTER(arglist) (&(arglist))
#endif

int thprintf_expand_main(void *buffer, TCHAR *dest, int reqsize)
{
	*dest = '\0';
	thprintf_set_top(buffer, dest);

	if ( ThSize((ThSTRUCT *)buffer, TSTROFF(reqsize)) != FALSE ){
	//	printf("[thprintf_expand realloc:%d]", ((ThSTRUCT *)buffer)->size);
		return thprintf_left(buffer);
	}
	// printf("[thprintf_expand realloc x]");
	return 0;
}

#define thprintf_check_left(buffer, buflen, dest, left, reqlen, message) { \
	if ( reqlen > left ){ \
		int nleft; \
		if ( ((buflen) > 0) || ((nleft = thprintf_expand_main(buffer, dest, reqlen)) == 0) ){ \
			XMessage(NULL, NULL, XM_DbgLOG, T("thprintf over 2: %s"), message);\
			reqlen = left; \
		}else{ \
			left = nleft; \
			dest = thprintf_dest(buffer); \
		} \
	} \
}

#define thprintf_spacing(buffer, buflen, dest, left, srclength, columns, space, message){ \
	if ( srclength < columns ){ \
		thprintf_check_left(buffer, buflen, dest, left, columns, message); \
		columns -= srclength; \
		if ( columns > 0 ){ \
			left -= columns; \
			for (;;){ \
				*dest++ = space; \
				if ( --columns == 0 ) break; \
			} \
		} \
	} \
}

#define HEX_LEN 8
#define HEX64_POINTERLEN 4 // PML4 ̂Ƃ 56bit
#define HEX64_UPLEN 16
int thprintf_hex32(DWORD num, TCHAR high, TCHAR *buf)
{
	int part;

	for ( part = HEX_LEN; ; ) {
		UTCHAR chr;

		chr = (UTCHAR)(num & 0xf);
		buf[--part] = (TCHAR)(UTCHAR)(chr + ((chr >= 10) ? high : '0'));
		if ( num < 16 ) break;
		num >>= 4;
	}
	return part;
}

int thprintf_hex64(UINTHL num, TCHAR high, TCHAR *buf, int uplen)
{
	DWORD numL = num.s.H;
	int hpart = uplen, lpart;

	//  DWORD
	if ( numL != 0 ){
		if ( numL & 0xffff0000 ){ // PML5 ȍ~ 64bit or 0xfxxx...
			hpart = uplen = HEX_LEN;
		}
		for ( ; ; ) {
			UTCHAR chr;

			chr = (UTCHAR)(numL & 0xf);
			buf[--hpart] = (TCHAR)(UTCHAR)(chr + ((chr >= 10) ? high : '0'));
			if ( numL < 16 ) break;
			numL >>= 4;
		}
	}

	//  DWORD
	numL = num.s.L;
	for ( lpart = HEX_LEN; ; ) {
		UTCHAR chr;

		chr = (UTCHAR)(numL & 0xf);
		buf[--lpart + uplen] = (TCHAR)(UTCHAR)(chr + ((chr >= 10) ? high : '0'));
		if ( numL < 16 ) break;
		numL >>= 4;
	}

	// 
	buf[HEX64_UPLEN] = (TCHAR)uplen;
	if ( hpart != uplen ){ // ʂ
		for ( ; lpart; ) buf[--lpart + uplen] = '0';
		return hpart;
	}else{ // ʂ̂
		return lpart + uplen;
	}
}

int thprintf_extra(THPRINTF_STRUCT *ts, t_va_list *arglist) // %Mx
{
	TCHAR buf[VFPS];
	TCHAR c;
	int length;

	c = *ts->src++;
	if ( (c == 'd') || (c == 'u') ){ // %Md Pʌ^ UINT32
		DWORD num;

		num = t_va_arg(*arglist, DWORD);
		length = FormatNumber(buf, XFN_DECIMALPOINT | XFN_MINKILO, ts->columns ? ts->columns : ts->left, num, 0) - buf;
	}else if ( (c == 'D') || (c == 'U') ){ // %Md Pʌ^ UINT32
		DWORD num;

		num = t_va_arg(*arglist, DWORD);
		length = FormatNumber(buf, XFN_DECIMALPOINT | XFN_MINKILO | XFN_HEXUNIT, ts->columns ? ts->columns : ts->left, num, 0) - buf;
	}else if ( (c == 'L') && ((*ts->src == 'd') || (*ts->src == 'u')) ){ // %MLd Pʌ^ UINT64
		UINTHL num;

		ts->src++;
		num.rawdata = t_va_arg(*arglist, INTHL_RAWDATA);
		length = FormatNumber(buf, XFN_DECIMALPOINT | XFN_MINKILO,
				ts->columns ? ts->columns : ts->left, num.s.L, num.s.H) - buf;
	}else if ( (c == 'L') && ((*ts->src == 'D') || (*ts->src == 'U')) ){ // %MLd Pʌ^ UINT64(1024)
		UINTHL num;

		ts->src++;
		num.rawdata = t_va_arg(*arglist, INTHL_RAWDATA);
		length = FormatNumber(buf, XFN_DECIMALPOINT | XFN_MINKILO | XFN_HEXUNIT,
				ts->columns ? ts->columns : ts->left, num.s.L, num.s.H) - buf;
	}else if ( c == 'F' ){ // %MF FILETIME (UTC)
		FILETIME *utc, local;
		SYSTEMTIME st;

		utc = t_va_arg(*arglist, FILETIME *);
		if ( (utc->dwLowDateTime | utc->dwHighDateTime) == 0 ){ // `
			memset(&st, 0, sizeof(st));
		}else{
			FileTimeToLocalFileTime(utc, &local);
			FileTimeToSystemTime(&local, &st);
		}
		length = thprintf(buf, 64, T("%04d-%02d-%02d %02d:%02d:%02d.%03d"),
				st.wYear, st.wMonth, st.wDay,
				st.wHour, st.wMinute, st.wSecond, st.wMilliseconds) - buf;
	}else if ( c == 'm' ){ // %Mm Win32 error message
		PPErrorMsg(buf, (ERRORCODE)t_va_arg(*arglist, ERRORCODE));
		length = tstrlen(buf);
	}else{
		*ts->dest++ = '%';
		*ts->dest++ = 'M';
		*ts->dest++ = c;
		return 0;
	}
	thprintf_spacing(ts->buffer, ts->buflen, ts->dest, ts->left, length, ts->columns, ts->space, NilStr);
	thprintf_check_left(ts->buffer, ts->buflen, ts->dest, ts->left, length, NilStr)
	memcpy(ts->dest, buf, TSTROFF(length));
	ts->dest += length;
	ts->left -= length;
	return length;
}


PPXDLL TCHAR * USECDECL thprintf(void *buffer, int buflen, const TCHAR *message, ...)
{
	t_va_list arglist;
	TCHAR *result;

	t_va_start(arglist, message);
	result = thvprintf(buffer, buflen, message, arglist);
	t_va_end(arglist);
	return result;
}

PPXDLL TCHAR * WINAPI thvprintf(void *buffer, int buflen, const TCHAR *message, t_va_list arglist)
{
	const TCHAR *src = message;
	TCHAR buf[64];
	TCHAR *dest;
	int left, columns;
	TCHAR space;
	BOOL separator;

	if ( buflen > 0 ){
		dest = (TCHAR *)buffer;
		left = buflen - 1;
	}else{
		ThAllocCheck((ThSTRUCT *)buffer);
		dest = thprintf_dest(buffer);
		left = thprintf_left(buffer);
	}
	for(;;){
		TCHAR c;
		int length;

		c = src[0];
		if ( c == '\0' ) break;
		if ( left <= 0 ){
			if ( (buflen > 0) || (left = thprintf_expand_main(buffer, dest, tstrlen(src))) == 0 ){
				XMessage(NULL, NULL, XM_DbgLOG, T("thprintf over 1: %s"), message);
				break;
			}
			dest = thprintf_dest(buffer);
		}
		src++;
		if ( c != '%' ){
			*dest++ = c;
			left--;
			continue;
		}
		// '%' GXP[v
		c = *src++;
		columns = 0;
		space = ' ';
		separator = FALSE;

		if ( c == '\'' ){ // ' ؂
			separator = TRUE;
			c = *src++;
		}

		if ( (UTCHAR)(c - '0') < 10 ){ // l...tB[h
			if ( c == '0' ) space = '0';
			for(;;){
				columns = columns * 10 + (c - '0');
				c = *src++;
				if ( (UTCHAR)(c - '0') >= 10 ) break;
			}
		}

		if ( c == 's' ){ // %s  TCHAR 
			const TCHAR *str;

			str = t_va_arg(arglist, const TCHAR *);
			length = (str != NULL) ? tstrlen(str) : 0;
			thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
			thprintf_check_left(buffer, buflen, dest, left, length, message);
			memcpy(dest, str, TSTROFF(length));
			dest += length;
			left -= length;
			continue;
		}else if ( c == 'd' ){ // %d  int32
			int num;
			BOOL minus;

			num = t_va_arg(arglist, int);

			if ( num < 0 ){
				left--;
				num = -num;
				if ( columns > 0 ) columns--;
				if ( space == ' ' ){
					minus = TRUE;
				}else{
					*dest++ = '-';
					minus = FALSE;
				}
			}else{
				minus = FALSE;
			}
			if ( separator ){
				length = FormatNumber(buf, XFN_SEPARATOR | XFN_DECIMALPOINT, columns ? columns : left, num, 0) - buf;
			}else{
				length = Numer32ToString(buf, (DWORD)num) - buf;
			}
			thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
			thprintf_check_left(buffer, buflen, dest, left, length, message);
			if ( minus ) *dest++ = '-';
			memcpy(dest, buf, TSTROFF(length));
			dest += length;
			left -= length;
			continue;
		}else if ( c == 'u' ){ // %u  UINT32
			DWORD num;

			num = t_va_arg(arglist, DWORD);
			if ( separator ){
				length = FormatNumber(buf, XFN_SEPARATOR | XFN_DECIMALPOINT, columns ? columns : left, num, 0) - buf;
			}else{
				length = Numer32ToString(buf, (DWORD)num) - buf;
			}
		}else if ( c == 'c' ){ // %c  1 TCHAR
			*dest++ = (TCHAR)t_va_arg(arglist, int); // char / word  x86/x64ACg int 
			left--;
			continue;
		}else if ( c == '%' ){ // %%  % g
			*dest++ = c;
			left--;
			continue;
		}else if ( (c == 'x') || (c == 'X') || (c == 'p') ){
			int part;
			int length;

			if ( c == 'p' ){ // %p  UINT32/UINT64 pointer(%08X)
				#ifdef _WIN64
					UINTHL numHL;

					if ( columns == 0 ) columns = 12;
					numHL.HL = t_va_arg(arglist, unsigned __int64);
					part = thprintf_hex64(numHL, (TCHAR)('A' - 10),
							buf, HEX64_POINTERLEN);
					length = HEX_LEN + buf[HEX64_UPLEN] - part;
				#else // WIN32
					if ( columns == 0 ) columns = 8;
					part = thprintf_hex32(t_va_arg(arglist, DWORD), (TCHAR)('A' - 10), buf);
					length = HEX_LEN - part;
				#endif
				space = '0';
			}else{ // %x %X  UINT32 hex
				part = thprintf_hex32(t_va_arg(arglist, DWORD),
					(c == 'x') ? (TCHAR)('a' - 10) : (TCHAR)('A' - 10), buf);
				length = 8 - part;
			}

			thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
			thprintf_check_left(buffer, buflen, dest, left, length, message);
			memcpy(dest, buf + part, TSTROFF(length));
			dest += length;
			left -= length;
			continue;
		}else if ( c == 'L' ){ // long double / (Ǝ) long long prefix
			c = *src++;
			if ( c == 'd' ){ // %Ld  int64
				int length;
				UINTHL num;
				BOOL minus;

				num.rawdata = t_va_arg(arglist, INTHL_RAWDATA);
			#if _INTEGRAL_MAX_BITS >= 64
				if ( (__int64)num.HL < 0 ){
					left--;
					num.HL = (unsigned __int64)-(__int64)num.HL;
					if ( columns > 0 ) columns--;
					if ( space == ' ' ){
						minus = TRUE;
					}else{
						*dest++ = '-';
						minus = FALSE;
					}
				}else{
					minus = FALSE;
				}
			#else
				if ( (LONG)num.s.H < 0 ){
					left--;
					num.s.H = ~num.s.H;
					if ( num.s.L == 0 ) num.s.H++;
					num.s.L = ~num.s.L;
					num.s.L++;
					if ( columns > 0 ) columns--;
					if ( space == ' ' ){
						minus = TRUE;
					}else{
						*dest++ = '-';
						minus = FALSE;
					}
				}else{
					minus = FALSE;
				}
			#endif
				if ( separator ){
					length = FormatNumber(buf, XFN_SEPARATOR | XFN_DECIMALPOINT, columns ? columns : left, num.s.L, num.s.H) - buf;
				}else{
					length = Numer64ToString(buf, num) - buf;
				}
				thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
				thprintf_check_left(buffer, buflen, dest, left, length, message);
				if ( minus ) *dest++ = '-';
				memcpy(dest, buf, TSTROFF(length));
				dest += length;
				left -= length;
				continue;
			}else if ( c == 'u' ){ // %Lu  UINT64
				UINTHL num;

				num.rawdata = t_va_arg(arglist, INTHL_RAWDATA);
				if ( separator ){
					length = FormatNumber(buf, XFN_SEPARATOR | XFN_DECIMALPOINT, columns ? columns : left, num.s.L, num.s.H) - buf;
				}else{
					length = Numer64ToString(buf, num) - buf;
				}
			}else if ( (c == 'x') || (c == 'X') ){ // %Lx %LX  UINT64 hex
				int part;
				int length;
				UINTHL numHL;

				numHL.rawdata = t_va_arg(arglist, INTHL_RAWDATA);
				part = thprintf_hex64(numHL,
						(c == 'x') ? (TCHAR)('a' - 10) : (TCHAR)('A' - 10),
						buf, HEX_LEN);
				length = HEX_LEN + buf[HEX64_UPLEN] - part;

				thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
				thprintf_check_left(buffer, buflen, dest, left, length, message);
				memcpy(dest, buf + part, TSTROFF(length));
				dest += length;
				left -= length;
				continue;
			}else if ( c == 's' ){ // %Ls  UNICODE strings
			#ifdef UNICODE
				const WCHAR *strW;

				strW = t_va_arg(arglist, const WCHAR *);
				length = strlenW(strW);
				thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
				thprintf_check_left(buffer, buflen, dest, left, length, message);
				memcpy(dest, strW, TSTROFF(length));
			#else
				const WCHAR *strW;

				strW = t_va_arg(arglist, const WCHAR *);
				length = WideCharToMultiByte(CP_ACP, 0, strW, -1, NULL, 0, NULL, NULL);
				thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
				thprintf_check_left(buffer, buflen, dest, left, length, message);
				length = WideCharToMultiByte(CP_ACP, 0, strW, -1, dest, length, NULL, NULL);
				if ( length > 0 ) length--;
			#endif
				dest += length;
				left -= length;
				continue;
			}else{
				*dest++ = '%';
				*dest++ = 'L';
				*dest++ = c;
				continue;
			}
		}else if ( c == 'M' ){ // Ȍ`
			THPRINTF_STRUCT ts;

			ts.buffer = buffer;
			ts.buflen = buflen;
			ts.src = src;
			ts.dest = dest;
			ts.left = left;
			ts.columns = columns;
			ts.space = space;
			thprintf_extra(&ts, VA_LIST_POINTER(arglist));
			src = ts.src;
			dest = ts.dest;
			left = ts.left;
			continue;
		}else if ( c == 'h' ){ // ANSIw
			c = *src++;
			if ( c == 's' ){ // %hs  ansi string
			#ifdef UNICODE
				const char *strA;

				strA = t_va_arg(arglist, const char *);
				length = MultiByteToWideChar(CP_ACP, 0, strA, -1, NULL, 0);
				thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
				thprintf_check_left(buffer, buflen, dest, left, length, message);
				length = MultiByteToWideChar(CP_ACP, 0, strA, -1, dest, length);
				if ( length > 0 ) length--;
			#else
				const char *str;

				str = t_va_arg(arglist, const char *);
				length = strlen(str);
				thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
				thprintf_check_left(buffer, buflen, dest, left, length, message);
				memcpy(dest, str, TSTROFF(length));
			#endif
				dest += length;
				left -= length;
				continue;
			}else{
				*dest++ = '%';
				*dest++ = 'h';
				*dest++ = c;
				continue;
			}
		}else if ( c == '\0' ){ //  %
			*dest++ = '%';
			break;
		}else{ // s
			*dest++ = c;
			continue;
		}
		thprintf_spacing(buffer, buflen, dest, left, length, columns, space, message);
		thprintf_check_left(buffer, buflen, dest, left, length, message);
		memcpy(dest, buf, TSTROFF(length));
		dest += length;
		left -= length;
		continue;

//		if ( c == 'a' ) // _ e
//		if ( c == 'A' ) // _ E
//		if ( c == 'c' ) // (ISO)char / (MS)TCHAR  1 
//		if ( c == 'C' ) // (ISO)wchar / (MS)݂ƈقȂ char  1 
//		if ( c == 'd' ) // int
//		if ( c == 'e' ) // _ e
//		if ( c == 'E' ) // _ E
//		if ( c == 'f' ) // _ e
//		if ( c == 'F' ) // _ E
//		if ( c == 'g' ) // _ e
//		if ( c == 'G' ) // _ E
//		if ( c == 'h' ) // char prefix
//		if ( c == 'l' ) // wchar prefix
//		if ( c == 'i' ) // tl
//		if ( c == 'o' ) //  8i
//		if ( c == 'n' ) // wʒu܂ł̕ۑ
//		if ( c == 'm' ) // (glibc)G[R[hɑΉbZ[Wo
//		if ( c == 'p' ) // |C^l(16il)
//		if ( c == 's' ) // (ISO)char / (MS)TCHAR  
//		if ( c == 'S' ) // (ISO)wchar / (MS)݂ƈقȂ char  
//		if ( c == 'u' ) // UINT
//		if ( c == 'x' ) //  16i 
//		if ( c == 'X' ) //  16i 啶
//		if ( c == 'Z' ) // (MS)xxx_STRING struct 
// ̗p tO # - +  I
// ̗p Cq h:(d)short, (MS c)char, hh:(d)char,
//		I:(MS)pointer/size_t,(glibc)P[ˑ I32:(MS), I64:(MS),
//		j:intmax, l:(MS)long double, (d)long int, (c)wchar,  L:long double,
//		ll:long long int, q, t:pointer, w:(MS c,s)wchar, z:size_t,
//		 *(Ŏw肵)
// ̗p ϊwq m

	}
	*dest = '\0';
	if ( buflen <= 0 ){
		thprintf_set_top(buffer, dest);
		// ADD ɂɂ́A (top) \0  \0 (top) \0 ɂ
		if ( buflen == THP_ADD ){
			if ( (((ThSTRUCT *)buffer)->top + sizeof(TCHAR) * 2) < ((ThSTRUCT *)buffer)->size ){
				ThSize((ThSTRUCT *)buffer, sizeof(TCHAR) * 2);
				dest = thprintf_dest(buffer);
			}
			((ThSTRUCT *)(buffer))->top += sizeof(TCHAR);
			*(dest + 1) = '\0';
		}
	}
	return dest;
}

