/*-----------------------------------------------------------------------------
	Paper Plane xUI	 commom library					gGfBbg
-----------------------------------------------------------------------------*/
#pragma setlocale("Japanese")
#define ONPPXDLL		// PPCOMMON.H  DLL `w
#include "WINAPI.H"
//#include <stddef.h>
//#include <string.h>
#include <richedit.h>
#include <shlobj.h>
#include "PPX.H"
#include "VFS.H"
#include "PPCOMMON.RH"
#include "PPD_DEF.H"
#define PPEFINDREPLACESTRUCT
#include "PPD_EDL.H"
#include "VFS_STRU.H"
#pragma hdrstop

#ifdef WINEGCC
	#undef FINDMSGSTRING // Wine 5.0 ł
	#define FINDMSGSTRING  T("commdlg_FindReplace")
#endif

const TCHAR StrPPxED[] = T("PPxExEdit");
const TCHAR StrReload[] = MES_QRLT;
int Cursor_TopOfWindow = -13;
int Cursor_EndOfWindow = -14;
int Cursor_TopOfText = -15;
int Cursor_EndOfText = -16;
int Cursor_LogUp[] = {-18, 0, -1, 0, 0, 0};
int Cursor_LogDown[] = {-18, 0, 1, 0, 0, 0};

#ifndef UNICODE
int xpbug = 0;		// XP  EM_?ETSEL  WIDE ɕKȂ bug Ȃ畉
#endif
int USEFASTCALL PPeFill(PPxEDSTRUCT *PES);
int USEFASTCALL PPeDefaultMenu(PPxEDSTRUCT *PES);
ERRORCODE PPedCommand(PPxEDSTRUCT *PES, PPECOMMANDPARAM *param);
ERRORCODE PPedExtCommand(PPxEDSTRUCT *PES, PPECOMMANDPARAM *param, const TCHAR *command);
void InitExEdit(PPxEDSTRUCT *PES);
int X_esrx = 0; // ŐK\g


const TCHAR FINDMSGSTRINGstr[] = FINDMSGSTRING;
UINT ReplaceDialogMessage = 0xff77ff77;

const TCHAR CRCD_CR[] = T("CR");
const TCHAR CRCD_CRLF[] = T("CRLF");
const TCHAR CRCD_LF[] = T("LF");
const TCHAR *CRCD_list[] = {CRCD_CRLF, CRCD_CR, CRCD_LF};

typedef struct {
	TCHAR *text;
	TCHAR textbuf[0x410];
	int len;
} EditTextStruct;

void RichChangeFontStyle(PPxEDSTRUCT *PES, DWORD mask, DWORD effect)
{
	CHARFORMAT chfmt;

	if ( !(PES->flags & PPXEDIT_RICHEDIT) ) return;

	chfmt.cbSize = sizeof(chfmt);
	chfmt.dwMask = mask;
	SendMessage(PES->hWnd, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&chfmt);
	chfmt.dwEffects ^= effect;
	SendMessage(PES->hWnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&chfmt);
}

void RichChangeFontColor(PPxEDSTRUCT *PES)
{
	CHARFORMAT chfmt;

	if ( !(PES->flags & PPXEDIT_RICHEDIT) ) return;

	chfmt.cbSize = sizeof(chfmt);
	chfmt.dwMask = CFM_COLOR;
	SendMessage(PES->hWnd, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&chfmt);
	if ( (chfmt.dwEffects & CFE_AUTOCOLOR) || (chfmt.crTextColor == C_WindowText) ){
		resetflag(chfmt.dwEffects, CFE_AUTOCOLOR);
		chfmt.crTextColor = C_RED;
	}else{
		chfmt.crTextColor = C_WindowText;
	}
	SendMessage(PES->hWnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&chfmt);
}

void RichChangeBackColor(PPxEDSTRUCT *PES)
{
	CHARFORMAT chfmt;

	if ( !(PES->flags & PPXEDIT_RICHEDIT) ) return;

	chfmt.cbSize = sizeof(chfmt);
	chfmt.dwMask = CFM_COLOR;
	SendMessage(PES->hWnd, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM)&chfmt);
	if ( (chfmt.dwEffects & CFE_AUTOCOLOR) || (chfmt.crTextColor == C_WindowText) ){
		resetflag(chfmt.dwEffects, CFE_AUTOCOLOR);
		chfmt.crTextColor = C_RED;
	}else{
		chfmt.crTextColor = C_WindowText;
	}
	SendMessage(PES->hWnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&chfmt);
}

void SetSelectCombbox(HWND hEditWnd)
{
	TCHAR textbuf[CMDLINESIZE];
	HWND hComboWnd;

	hComboWnd = GetParent(hEditWnd);
	GetWindowText(hEditWnd, textbuf, CMDLINESIZE);
	textbuf[CMDLINESIZE - 1] = '\0';
	SendMessage(hComboWnd, CB_DELETESTRING, 0, 0);
	SetWindowTextWithSelect(hEditWnd, textbuf);
	GetWindowText(hEditWnd, textbuf, CMDLINESIZE);
	SendMessage(hComboWnd, CB_INSERTSTRING, 0, (LPARAM)textbuf);
}

BOOL OpenEditText(PPxEDSTRUCT *PES, EditTextStruct *ets, int margin)
{
	int sizelen;

	// GetWindowTextLength ͓ WM_GETTEXTLENGTH gpĂ邪A
	// vZXȂ̂őBCallWindowProc ȂXɑ
	// GetWindowText,SetWindowTextl
	sizelen = Edit_GetWindowTextLength(PES) + margin + 1;
	if ( sizelen <= TSIZEOF(ets->textbuf) ){
		ets->text = ets->textbuf;
		ets->len = Edit_GetWindowText(PES, ets->text, sizelen);
		return TRUE;
	}else{
		ets->text = (TCHAR *)HeapAlloc(DLLheap, 0, TSTROFF(sizelen));
		if ( ets->text == NULL ) return FALSE;
		ets->len = Edit_GetWindowText(PES, ets->text, sizelen);
		if ( ets->len > 0 ) return TRUE;
		HeapFree(DLLheap, 0, ets->text);
		return FALSE;
	}
}

void CloseEditText(EditTextStruct *ets)
{
	if ( ets->text == ets->textbuf ) return;
	HeapFree(DLLheap, 0, ets->text);
}

// ItZbgJ[\ł邩𔻒BtH[JXƂ͎s
BOOL IsEditCursorPos(HWND hWnd, DWORD coff)
{
	POINT pos;
	DWORD coffset;

	GetCaretPos(&pos); // DPIzΉ
	coffset = (DWORD)SendMessage(hWnd, EM_CHARFROMPOS, 0, TMAKELPARAM(pos.x, pos.y));
	if ( LOWORD(coffset) != LOWORD(coff) ) return FALSE; // xʂvȂ
	if ( HIWORD(coff) == 0 ) return TRUE; // xʂŔm

	// yʂv(EM_LINEFROMCHAR 1]ɂ鎞)
	return (DWORD)(LOWORD(SendMessage(hWnd, EM_LINEFROMCHAR, coff,0)) - HIWORD(coffset)) <= 1;
#if 0
	POINT pos;
	DWORD wpos;

	GetCaretPos(&pos);
	wpos = SendMessage(hWnd, EM_POSFROMCHAR, (WPARAM)coff, 0);

	return (LOWORD(pos.x) == LOWORD(wpos)) && (LOWORD(pos.y) == HIWORD(wpos));
#endif
}

#define INUM_SEL_START 4
#define INUM_SEL_END 5
int GetSelAndGetCursorLeftSel(HWND hWnd, int *inums)
{
	SendMessage(hWnd, EM_GETSEL, (WPARAM)&inums[INUM_SEL_START], (LPARAM)&inums[INUM_SEL_END]);
	if ( inums[INUM_SEL_START] == inums[INUM_SEL_END] ) return INUM_SEL_START; // I𖳂
	switch (inums[3]){ // J[\ʒuɂ
		case 1: // 
			return INUM_SEL_START;
		case 2: // E
			return INUM_SEL_END;
		case 3: // ړɂ ɈړȂ獶
			return (inums[1] <= 0) ? INUM_SEL_START : INUM_SEL_END;
		default: // case 0: J[\ʒu
			return IsEditCursorPos(hWnd, (DWORD)inums[INUM_SEL_START]) ? INUM_SEL_START : INUM_SEL_END;
	}
}

// Y ړʂɑ镶ItZbg߂
int CursorYMove(HWND hWnd, int deltaY, int nowW)
{
	int nowY, newY;

	if ( deltaY == 0 ) return 0;
	nowY = (nowW != 0) ? (int)SendMessage(hWnd, EM_LINEFROMCHAR, (WPARAM)nowW, 0) : 0;
	newY = nowY + deltaY;
	if ( newY < 0 ) newY = 0;
	return	(int)SendMessage(hWnd, EM_LINEINDEX, (WPARAM)newY, 0) -
			((nowW != 0) ? (int)SendMessage(hWnd, EM_LINEINDEX, (WPARAM)nowY, 0) : 0);
}

int FixCursorXmove(HWND hWnd, int start, int offset)
{
	int nowpos = start;
	const WCHAR *EditText;

#ifdef UNICODE
	BOOL uselocalheap = FALSE;
	HLOCAL hEd;

	EditText = NULL;
	hEd = (HLOCAL)SendMessage(hWnd, EM_GETHANDLE, 0, 0);
	if ( hEd != NULL ){
		EditText = LocalLock(hEd);
		if ( EditText != NULL ) uselocalheap = TRUE;
	}
	if ( EditText == NULL )
#endif
	{
		DWORD len;

		len = GetWindowTextLength(hWnd);
		EditText = HeapAlloc(DLLheap, 0, TSTROFF(len + 1));
		GetWindowText(hWnd, (TCHAR *)EditText, len + 1);
	}
	if ( EditText == NULL ){
		nowpos += offset;
		if ( nowpos < 0 ) nowpos = 0;
#ifndef UNICODE
	}else if ( xpbug >= 0 ){ // ANSI
		if ( xpbug ) CaretFixToA((const char *)EditText, (DWORD *)&nowpos);
		if ( offset >= 0 ){ // 
			for (;offset > 0;){
				BYTE c;

				c = (BYTE)*((char *)EditText + nowpos);
				if ( c == '\0' ) break;
				if ( c == '\r' ){
					nowpos++;
					continue;
				}
				if ( IskanjiA(c) ){
					nowpos++;
					c = (BYTE)*((char *)EditText + nowpos);
					if ( c == '\0' ) break;
				}
				nowpos++;
				offset--;
			}
		}else for (;offset < 0;){ // 
			BYTE c;

			if ( nowpos == 0 ) break;
			if ( nowpos > 1 ){
				c = (BYTE)*((char *)EditText + nowpos - 2);
				if ( c == '\r' ){
					nowpos--;
					continue;
				}
				if ( IskanjiA(c) ){
					nowpos--;
				}
			}
			nowpos--;
			offset++;
		}
		if ( xpbug ) CaretFixToW((const char *)EditText, (DWORD *)&nowpos);
#endif
	// UNICODE 
	}else if ( offset >= 0 ){ // 
		for (;offset > 0;){
			WCHAR c, c2;

			c = *(EditText + nowpos);
			if ( c == '\0' ) break;
			c2 = *(EditText + nowpos + 1);
			if ( (c == '\r') ||
				 ((c >= 0xd800) && (c < 0xdc00)) || // TQ[gyA1
				 ((c >= 0x180b) && (c <= 0x180d)) || // FVS
				 ((c >= 0xfe00) && (c <= 0xfe0f)) || // VS1-VS16
				// U+E0100?U+E01EF // VS17-VS256
//				 ((c2 >= 0x93a) && (c2 <= 0x94f)) || //
				 ((c2 >= 0x300) && (c2 <= 0x36f))  // _CANeBJ
				){
				nowpos++;
				continue;
			}
			nowpos++;
			offset--;
		}
	}else for (;offset < 0;){ // 
		WCHAR c, c2;

		if ( nowpos == 0 ) break;
		if ( nowpos > 1 ){
			c = *(EditText + nowpos - 2);
			c2 = *(EditText + nowpos - 1);
			if ((c == '\r') ||
				((c >= 0xd800) && (c < 0xdc00)) || // TQ[gyA
				((c >= 0x180b) && (c <= 0x180d)) || // FVS
				((c >= 0xfe00) && (c <= 0xfe0f)) || // VS1-VS16
				// U+E0100?U+E01EF // VS17-VS256
//				 ((c2 >= 0x93a) && (c2 <= 0x94f)) || //
				 ((c2 >= 0x300) && (c2 <= 0x36f))  // _CANeBJ
				){
				nowpos--;
				continue;
			}
		}
		nowpos--;
		offset++;
	}
#ifdef UNICODE
	if ( uselocalheap != FALSE ){
		LocalUnlock(hEd);
	}else
#endif
	if ( EditText != NULL ){
		HeapFree(DLLheap, 0, (void *)EditText);
	}
	return nowpos;
}

int USEFASTCALL PPeSelectExtensionMain(PPxEDSTRUCT *PES, int mode)
{
	ECURSOR cursor, cursorRange;
	TCHAR *p;
	DWORD extoffset;
	HWND hWnd = PES->hWnd;

	EditTextStruct ets;

	if ( OpenEditText(PES, &ets, 0) == FALSE ) return 0;
	if ( ets.len == 0 ) return 0;
												// ҏW(S)擾
	GetEditSel(hWnd, ets.text, &cursor);
	if ( PES->flags & PPXEDIT_SINGLEREF ){	// Pڂ̂
		cursorRange.start = 0;
		cursorRange.end = ets.len;
	}else{	// 
		cursorRange = cursor;
		GetWordStrings(ets.text, &cursorRange, GWSF_SPLIT_PARAM);
	}
	// gq̈ʒum
	p = FindLastEntryPoint(ets.text + cursorRange.start);
	cursorRange.start = p - ets.text;
	p += FindExtSeparator(p);
	extoffset = p - ets.text;

	if ( mode < -7 ){
		if ( mode == -8 ){ // Ô
			cursor.start = cursor.end;
		}else{  // if ( mode == -9 ) // gq̂
			cursor.start = cursorRange.start;
			cursor.end = extoffset;
		}
	}

	if ( cursor.start == cursor.end ){ // IOw
		cursor.start = cursorRange.start;
		cursor.end = extoffset;
	}else if ( cursor.start == cursorRange.start ){	// S͈͎w or Ow
		if ( cursor.end > extoffset ){ // S͈͎w聨Ow
			cursor.end = extoffset;
		}else{	// Ow聨gqw
			if ( ets.text[extoffset] == '.' ) extoffset++;
			cursor.start = extoffset;
			cursor.end = cursorRange.end;
		}
	}else{ // ̑S͈͎w
		cursor.start = cursorRange.start;
		cursor.end = cursorRange.end;
	}
	SetEditSel(hWnd, ets.text, cursor.start, cursor.end);
	CloseEditText(&ets);
	return 0;
}

int USEFASTCALL PPeSelectExtension(PPxEDSTRUCT *PES)
{
	return PPeSelectExtensionMain(PES, 0);
}

int GetPageInfo(PPxEDSTRUCT *PES, BOOL getheight)
{
	RECT box;

	CallWindowProc(PES->hOldED, PES->hWnd, EM_GETRECT, 0, (LPARAM)&box);
	if ( PES->exstyle & WS_EX_CLIENTEDGE ){
		box.top++;
		box.left++;
	}
	#pragma warning(suppress:6001) // ُłł
	return getheight ?
			((box.bottom - box.top) / PES->fontY) :
			((box.right - box.left) / PES->fontX);
}

BOOL USEFASTCALL PPeLogicalLinePos(PPxEDSTRUCT *PES, EditLPos *elp)
{
	DWORD len;
	EditTextStruct ets;

	TCHAR *textptr; // Qƈʒu
	BOOL rely = FALSE;
	int curindex;

	if ( OpenEditText(PES, &ets, 0) == FALSE ) return FALSE;
	len = ets.len;
	if ( len == 0 ) return FALSE; // len == 0 ̎Closesv

	textptr = ets.text;

	if ( elp->mode & EditLPos_SET_RANGE ){
		curindex = GetSelAndGetCursorLeftSel(PES->hWnd, elp->inums);
		if ( curindex == INUM_SEL_END ) elp->mode ^= EditLPos_CURSOR_ENDSEL;
	}

	if ( elp->mode & EditLPos_RELCURSOR ){
		TCHAR *line; // s
		int y = 0;
		DWORD posC, firstC, lastC;

		// ݃J[\ x,y ߂
		SendMessage(PES->hWnd, EM_GETSEL, (WPARAM)&firstC, (LPARAM)&lastC);
		if ( elp->mode & EditLPos_CURSOR_ENDSEL ) firstC = lastC;
		#ifndef UNICODE
			if ( xpbug < 0 ) CaretFixToA(ets.text, &firstC);
		#endif
		line = textptr;
		posC = 0;
		for(;;){
			TCHAR chr;

			if ( posC >= firstC ) break;
			chr = *textptr;
			if ( chr == '\0' ) break;
			textptr++;
			posC++;
			if ( chr == '\r' ){
				if ( *textptr == '\n' ){
					textptr++;
					posC++;
				}
				y++;
				line = textptr;
				continue;
			}
			if ( chr == '\n' ){
				y++;
				line = textptr;
				continue;
			}
		}
		if ( elp->mode & EditLPos_SET_POS ){
			elp->x += textptr - line;
			elp->y += y;
			if ( elp->y != 0 ) rely = TRUE;
		}else if ( elp->mode & EditLPos_GET_L_CURSORPOS ){
			elp->x = textptr - line;
			elp->y = y;
		}
//		XMessage(NULL, NULL, XM_DbgDIA, T("> %d %d"),elp->x,elp->y);
	}

	if ( elp->mode & EditLPos_COUNT_POS ){
		int y = 0;

		textptr = ets.text;
		for(;;){
			TCHAR chr;

			if ( y >= elp->y ){
//				XMessage(NULL, NULL, XM_DbgDIA, T("f %d %d"),y,textptr - ets.text);
				// PʉςłȂ
				if ( elp->mode & EditLPos_SET ){
					DWORD lp;

					if ( rely ){
						int offx;

						offx = elp->x;
						for(; offx > 0; offx--, textptr++ ){
							TCHAR chr;

							chr = *textptr;
							if ( (chr == '\0') || (chr == '\r') || (chr == '\n') ){
								break;
							}
						}
					}else{
						textptr += elp->x;
					}
					lp = textptr - ets.text;
					#ifndef UNICODE
						if ( xpbug < 0 ) CaretFixToW(ets.text, &lp);
					#endif

					if ( elp->mode & EditLPos_SET_RANGE ){
						elp->inums[curindex] = lp;
						SendMessage(PES->hWnd, EM_SETSEL, (WPARAM)elp->inums[curindex ^ 1 /* 4/5  5/4 */], (LPARAM)elp->inums[curindex]);
					}else{
						SendMessage(PES->hWnd, EM_SETSEL, (WPARAM)lp, (LPARAM)lp);
					}
				}
				break;
			}

			chr = *textptr;
			if ( chr == '\0' ) break;
			textptr++;
			if ( chr == '\r' ){
				if ( *textptr == '\n' ){
					textptr++;
				}
				y++;
				continue;
			}
			if ( chr == '\n' ){
				y++;
				continue;
			}
		}
		if ( elp->mode & EditLPos_SET_POS ){
			elp->y = y;
		}
	}

	if ( elp->mode & EditLPos_GET_TEXT ){
		elp->textbuf = ets.text;
		elp->textptr = textptr;
	}else{
		CloseEditText(&ets);
	}
	return TRUE;
}

void PPeMoveLogicalLine(PPxEDSTRUCT *PES, int *inums, int mode)
{
	EditLPos elp = { NULL, NULL, 0, 0, 0, NULL};

	elp.mode = mode;
	elp.x = inums[1];
	elp.y = inums[2];
	elp.inums = inums;
	if ( inums[0] == -17 ){
		elp.x = (elp.x > 0) ? (elp.x - 1) : 0;
		elp.y--;
	}
	PPeLogicalLinePos(PES, &elp);
	Edit_SendMessageMsg(PES, EM_SCROLLCARET);
}

int PPeGetLogicalPos(PPxEDSTRUCT *PES, int mode)
{
	EditLPos elp = { NULL, NULL, EditLPos_GET_CURSORPOS, 0, 0, NULL};

	if ( mode >= 4 ){
		elp.mode = EditLPos_COUNT_POS | EditLPos_SET_POS;
		elp.y = 0x7fffffff;
		mode = 1;
	}else if ( mode >= 2 ){
		elp.mode = EditLPos_GET_CURSORPOS | EditLPos_CURSOR_ENDSEL;
		mode -= 2;
	}
	if ( PPeLogicalLinePos(PES, &elp) == FALSE ) return 0;
	return mode ? elp.y : elp.x;
}



void SendEditKey(PPxEDSTRUCT *PES, int keycode, int repeat)
{
	BYTE keytable[256], oldtable[256];

	GetKeyboardState(keytable);
	memcpy(oldtable, keytable, 256);
	keytable[VK_SHIFT] = 0;
	keytable[VK_LSHIFT] = 0;
	keytable[VK_RSHIFT] = 0;
	keytable[VK_CONTROL] = 0;
	keytable[VK_LCONTROL] = 0;
	keytable[VK_RCONTROL] = 0;
	keytable[VK_MENU] = 0;
	keytable[VK_LMENU] = 0;
	keytable[VK_RMENU] = 0;
	SetKeyboardState(keytable);

	for ( ; repeat > 0; repeat-- ){
		CallWindowProc(PES->hOldED, PES->hWnd, WM_KEYDOWN, (WPARAM)keycode, 0);
		CallWindowProc(PES->hOldED, PES->hWnd, WM_KEYUP, (WPARAM)keycode, B30 | B31);
	}

	SetKeyboardState(oldtable);
}

void EditMoveCursor(PPxEDSTRUCT *PES, int keyInc, int keyDec, int delta)
{
	if ( delta < 0 ){
		keyInc = keyDec;
		delta = -delta;
	}
	SendEditKey(PES, keyInc, delta);
}

void EditMoveCursorDispRel(PPxEDSTRUCT *PES, int *inums)
{
	int curindex;
	DWORD newindex;

	curindex = GetSelAndGetCursorLeftSel(PES->hWnd, inums);
	newindex = inums[curindex] + CursorYMove(PES->hWnd, inums[2], inums[curindex]);
	newindex = FixCursorXmove(PES->hWnd, newindex, inums[1]);
	if ( inums[0] == -1 ){
		inums[1] = newindex;
		if ( inums[1] == inums[curindex] ) return;
		SendMessage(PES->hWnd, EM_SETSEL, (WPARAM)inums[1], (LPARAM)inums[1]);
	}else{
		inums[curindex] = newindex;
		SendMessage(PES->hWnd, EM_SETSEL, (WPARAM)inums[curindex ^ 1 /* 4/5  5/4 */], (LPARAM)inums[curindex]);
	}
}

void EditSelectWord(PPxEDSTRUCT *PES, int mode)
{
	EditTextStruct ets;

	TCHAR *textbuf;
	ECURSOR cursor;
	int braket;
	DWORD len;

	// u"vǉ邱Ƃ
	if ( OpenEditText(PES, &ets, 1) == FALSE ) return;
	len = ets.len;
	if ( len == 0 ) return;
	textbuf = ets.text;

	GetEditSel(PES->hWnd, textbuf, &cursor);
	braket = GetWordStrings(textbuf, &cursor, GWSF_SPLIT_PARAM);
	if ( mode == -5 ){
		if ( braket >= GWS_BRAKET_LEFT ) cursor.start--;
		if ( braket >= GWS_BRAKET_LEFTRIGHT ){
			#ifndef UNICODE
				textbuf[cursor.end] = '\"';
				textbuf[cursor.end + 1] = '\0';
			#endif
			cursor.end++;
		}
	}
	SetEditSel(PES->hWnd, textbuf, cursor.start, cursor.end);
	CloseEditText(&ets);
}

// *cursor
DWORD_PTR EditCursorCommand(PPxEDSTRUCT *PES, PPXAPPINFOUNION *uptr)
{
	switch ( uptr->inums[0] ){ // ͐ePPx̑pɊm
		case -1: // \ΈړAI
		case -2: // \ΈړAI
			EditMoveCursorDispRel(PES, uptr->inums);
			break;

		case -3: { // \ΈړAI
			int w;

			w = uptr->nums[1] + CursorYMove(PES->hWnd, uptr->inums[2], 0);
			SendMessage(PES->hWnd, EM_SETSEL, (WPARAM)w, (LPARAM)w);
			break;
		}
		case -4: // \ΈړAI
			SendMessage(PES->hWnd, EM_SETSEL,
				(WPARAM)(uptr->nums[1] + CursorYMove(PES->hWnd, uptr->inums[2], 0)),
				(LPARAM)(uptr->nums[3] + CursorYMove(PES->hWnd, uptr->inums[4], 0)));
			break;

		case -5:	// J[\ʒuI(u"v܂)
		case -6:	// J[\ʒuI(u"v)
			EditSelectWord(PES, uptr->inums[0]);
			break;

		case -7: // J[\ʒut@C̑IgO
		case -8: // J[\ʒut@C̖OI
		case -9: // J[\ʒut@C̊gqI
			PPeSelectExtensionMain(PES, uptr->inums[0]);
			break;

		case -11: // y[Wړ / ⊮ꗗXg̃y[Wړ p
		case -12: // y[Wړ / ⊮ꗗXg̃y[Wړ / L[[h p
			if ( ListPageUpDown(PES, (uptr->inums[1] >= 0) ? EDITDIST_NEXT : EDITDIST_BACK, (uptr->inums[0] == -12) ) != ERROR_INVALID_FUNCTION ){
				break;
			}
			// -10 
		case -10: // y[Wړ
			EditMoveCursor(PES, VK_NEXT, VK_PRIOR, uptr->inums[1]);
			break;

		case -13: // Top of window
			JumptoLine(PES->hWnd,
					(int)SendMessage(PES->hWnd, EM_GETFIRSTVISIBLELINE, 0, 0) );
			break;

		case -14: // End of window
			JumptoLine(PES->hWnd,
					(int)SendMessage(PES->hWnd, EM_GETFIRSTVISIBLELINE, 0, 0) +
						GetPageInfo(PES, TRUE) - 1);
			break;

		case -15: // Top of text
			SendMessage(PES->hWnd, EM_SETSEL, 0, 0);
			SendMessage(PES->hWnd, EM_SCROLLCARET, 0, 0);
			break;

		case -16: // End of text
#ifndef UNICODE
			// Win9x  EC_LAST, EC_LAST ƁAړȂB0, EC_LAST  0x7fff, 0x7fff ƈړ
			if ( OSver.dwPlatformId != VER_PLATFORM_WIN32_NT ){
				SendMessage(PES->hWnd, EM_SETSEL, 0x7fff, 0x7fff);
			}else //  SendMessage s
#endif
			SendMessage(PES->hWnd, EM_SETSEL, EC_LAST, EC_LAST);
			SendMessage(PES->hWnd, EM_SCROLLCARET, 0, 0);
			break;

		case -17: // sԍړ
			PPeMoveLogicalLine(PES, uptr->inums, EditLPos_SET_POS);
			break;

		case -18: // _ΈړAI
			PPeMoveLogicalLine(PES, uptr->inums, EditLPos_RELCURSOR | EditLPos_SET_POS);
			break;

		case -19: // _ΈړAI
			PPeMoveLogicalLine(PES, uptr->inums, EditLPos_RELCURSOR | EditLPos_SET_POS | EditLPos_SET_RANGE);
			break;

		case -20: // _ΈړAI
			PPeMoveLogicalLine(PES, uptr->inums, EditLPos_SET_POS);
			break;

		case -21: // _ΈړAI
			PPeMoveLogicalLine(PES, uptr->inums, EditLPos_SET_POS | EditLPos_SET_POS);
			break;

		case -22: // Window Left
			SendEditKey(PES, VK_HOME, 1);
			break;

		case -23: // Window Right
			SendEditKey(PES, VK_END, 1);
			break;

		// -24 _ home
		// -25 _ end

		default:
			if ( (PES->info == NULL) || (PES->info->Function == NULL) ){
				return PPXA_INVALID_FUNCTION;
			}
			return PPxInfoFunc(PES->info, PPXCMDID_MOVECSR, uptr);
	}
	return PPXA_NO_ERROR;
}

void ListHScrollMain(HWND hListWnd, int dest)
{
	RECT listbox;
	int width;
//	SCROLLINFO sinfo;

	if ( hListWnd == NULL ) return;
	GetWindowRect(hListWnd, &listbox);
	listbox.right -= listbox.left;
	width = (int)SendMessage(hListWnd, LB_GETHORIZONTALEXTENT, 0, 0);
	width = width + (listbox.right * 2 * dest) / 3;
	if ( width < listbox.right ) width = listbox.right;
	SendMessage(hListWnd, LB_SETHORIZONTALEXTENT, (WPARAM)width, 0);

	SendMessage(hListWnd, WM_HSCROLL, (dest > 0) ? SB_PAGERIGHT : SB_PAGELEFT, 0);
/*
	sinfo.cbSize = sizeof(sinfo);
	sinfo.fMask = SIF_POS;
	GetScrollInfo(hListWnd, SB_HORZ, &sinfo);
	sinfo.nPos = width - listbox.right;
	SetScrollInfo(hListWnd, SB_HORZ, &sinfo, TRUE);
*/
}

void ListWidthMain(HWND hListWnd, int dest)
{
	RECT listbox;
	int width, page;

	if ( hListWnd == NULL ) return;
	GetWindowRect(hListWnd, &listbox);
	listbox.right -= listbox.left;
	listbox.bottom -= listbox.top;
	page = (int)SendMessage(hListWnd, LB_GETITEMHEIGHT, 0, 0) * 10;
	if ( dest > 1 ){
		width = dest;
	}else{
		width = listbox.right + page * dest;
	}
	if ( width < page ) width = page;
	SetWindowPos( hListWnd, NULL, 0, 0, width, listbox.bottom,
			SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);
}


void ListHScroll(PPxEDSTRUCT *PES, int dest)
{
	ListHScrollMain(PES->list.hWnd, dest);
	ListHScrollMain(PES->list.hSubWnd, dest);
}
void ListWidth(PPxEDSTRUCT *PES, int dest)
{
	ListWidthMain(PES->list.hWnd, dest);
	ListWidthMain(PES->list.hSubWnd, dest);
}

BOOL SearchStrCheck(PPxEDSTRUCT *PES, int mode)
{
	if ( (PES->findrep == NULL) || (PES->findrep->findtext[0] == '\0') ){
		return FALSE;
	}
	SearchStr(PES, mode);
	return TRUE;
}

void PPeReplaceStrCommand(PPxEDSTRUCT *PES, FINDREPLACE *freplace)
{
	DWORD firstC, lastC;

	if ( freplace->Flags & FR_FINDNEXT ){
		SearchStr(PES, (freplace->Flags & FR_DOWN) ? EDITDIST_NEXT_WITHNOW : EDITDIST_BACK );
	}else if ( freplace->Flags & FR_REPLACE ){
		SendMessage(PES->hWnd, EM_GETSEL, (WPARAM)&firstC, (LPARAM)&lastC);
		if ( firstC != lastC ){
			TEXTSEL ts;

			if ( SelectEditStrings(PES, &ts, TEXTSEL_CHAR) == FALSE ) return;

			if ( X_esrx ?
				(IsTrue(SearchStr(PES, EDITDIST_REPLACE_TEST))) :
				(tstricmp(ts.word, freplace->lpstrFindWhat) == 0) ){
				SendMessage(PES->hWnd, EM_REPLACESEL, 0, (LPARAM)freplace->lpstrReplaceWith);
			}
			FreeTextselStruct(&ts);
		}
		SearchStr(PES, EDITDIST_NEXT_WITHNOW);
	}else if ( freplace->Flags & FR_REPLACEALL ){ // ͂߂Ō܂
		SendMessage(PES->hWnd, WM_SETREDRAW, FALSE, 0);
		SendMessage(PES->hWnd, EM_SETSEL, 0, 0);
		for ( ;; ){
			if ( SearchStr(PES, EDITDIST_NEXT_WITHNOW) == FALSE ) break;
			SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)freplace->lpstrReplaceWith); // replaceAJ[\͒u̖Ɉړ
		}
		SendMessage(PES->hWnd, WM_SETREDRAW, TRUE, 0);
		InvalidateRect(PES->hWnd, NULL, FALSE);
		if ( freplace->lCustData != 0 ){
			PostMessage((HWND)freplace->lCustData, WM_CLOSE, 0, 0);
		}
	}
}

void PPeReplaceStr(PPxEDSTRUCT *PES)
{
	HMODULE hCOMDLG32;
	DefineWinAPI(HWND, ReplaceText, (LPFINDREPLACE));
	HWND hReplaceWnd;
	FINDREPLACE freplace;

	if ( PES->findrep == NULL ){
		if ( InitPPeFindReplace(PES) == FALSE ) return;
	}

	hCOMDLG32 = LoadSystemDLL(SYSTEMDLL_COMDLG32);
	if ( hCOMDLG32 == NULL ) return;
	GETDLLPROCT(hCOMDLG32, ReplaceText);
	if ( DReplaceText == NULL ) return;

	ReplaceDialogMessage = RegisterWindowMessage(FINDMSGSTRINGstr);

	freplace.lStructSize = sizeof(FINDREPLACE);
	freplace.hwndOwner = PES->hWnd;
	freplace.Flags = FR_DOWN | FR_HIDEMATCHCASE | FR_HIDEWHOLEWORD;
	#pragma warning(suppress:6001 6011) // InitPPeFindReplace ŏ
	freplace.lpstrFindWhat = PES->findrep->findtext;
	freplace.lpstrReplaceWith = PES->findrep->replacetext;
	freplace.wFindWhatLen = VFPS;
	freplace.wReplaceWithLen = VFPS;

	hReplaceWnd = DReplaceText(&freplace);
	if ( hReplaceWnd != NULL ){ // u_CAOoĂԂ̃[v
		MSG msg;

		freplace.lCustData = (LPARAM)hReplaceWnd;
		while( (int)GetMessage(&msg, NULL, 0, 0) > 0 ){
			if ( DialogKeyProc(&msg) ) continue;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
			if ( !IsWindow(hReplaceWnd) || (freplace.Flags & FR_DIALOGTERM) ){
				// _CAOɕ
				hReplaceWnd = NULL;
				break;
			}
		}
		if ( hReplaceWnd != NULL ) DestroyWindow(hReplaceWnd);
	}
	FreeLibrary(hCOMDLG32);
//	SendMessage(hWnd, EM_REPLACESEL, 0, (LPARAM)T("\"\""));
}

typedef struct {
	HWND hParentWnd;
	RECT boxEdit, boxDialog, boxDesk;
	int delta;
} WindowExpandInfoStruct;

BOOL CALLBACK EnumChildExpandProc(HWND hWnd, LPARAM lParam)
{
	RECT box;
	POINT pos;

	GetWindowRect(hWnd, &box);
	if ( (box.top > ((WindowExpandInfoStruct *)lParam)->boxEdit.top) &&
		 (GetParent(hWnd) == ((WindowExpandInfoStruct *)lParam)->hParentWnd) ){
		pos.x = box.left;
		pos.y = box.top;
		ScreenToClient( ((WindowExpandInfoStruct *)lParam)->hParentWnd, &pos);

		SetWindowPos(hWnd, NULL,
				pos.x, pos.y + ((WindowExpandInfoStruct *)lParam)->delta,
				0, 0,
				SWP_NOSIZE | SWP_NOACTIVATE | SWP_NOZORDER | SWP_NOREDRAW);
	}
	return TRUE;
}

void EditBoxExpand(PPxEDSTRUCT *PES, WindowExpandInfoStruct *eis)
{
	int oldflags = PES->flags, dialogheight;

	/* EBhEɁAĒȂ悤AꎞIɒ~B
		 DeferWindowPos ́Aeq֌W̃EBhEύX܂Ƃ߂čsȂ͗l */
	resetflag(PES->flags, PPXEDIT_LINE_MULTI | PPXEDIT_LINE_MULTILINE);

	// _CAOɂ͂ݏoƂ́AɈړ
	if ( (eis->boxDialog.bottom + eis->delta) >= eis->boxDesk.bottom ){
		int diff = eis->boxDialog.bottom + eis->delta - eis->boxDesk.bottom;

		if ( (eis->boxDialog.top >= eis->boxDesk.top) && ((eis->boxDialog.top - diff) < eis->boxDesk.top) ){
			diff = eis->boxDialog.top - eis->boxDesk.top;
		}
		if ( diff <= 0 ) return;
		eis->boxDialog.top -= diff;
		eis->boxDialog.bottom -= diff;

		SetWindowPos(eis->hParentWnd, NULL,
				eis->boxDialog.left, eis->boxDialog.top, 0, 0,
				SWP_NOSIZE | SWP_NOACTIVATE | SWP_NOZORDER | SWP_NOREDRAW);
	}

	dialogheight = eis->boxDialog.bottom - eis->boxDialog.top + eis->delta;
	if ( dialogheight < GetSystemMetrics(SM_CYCAPTION) ){ //  1.68+4
		dialogheight = GetSystemMetrics(SM_CYCAPTION) * 3;
	}

	// IDE_INPUT_LINE edit box
	SetWindowPos(PES->hWnd, NULL, 0, 0,
			eis->boxEdit.right - eis->boxEdit.left,
			eis->boxEdit.bottom,
			SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER | SWP_NOREDRAW);

	// IDE_INPUT_LINE 艺̃Rg[C
	EnumChildWindows(eis->hParentWnd, EnumChildExpandProc, (LPARAM)eis);

	// Dialog box
	SetWindowPos(eis->hParentWnd, NULL, 0, 0,
			eis->boxDialog.right - eis->boxDialog.left, dialogheight,
			SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER | SWP_NOREDRAW);

	if ( PES->FloatBar.hWnd != NULL ){
		SetWindowPos(PES->FloatBar.hWnd, NULL,
				eis->boxEdit.left, eis->boxEdit.top + eis->boxEdit.bottom,
				0, 0,
				SWP_NOACTIVATE | SWP_NOZORDER | SWP_NOSIZE);
	}
	PES->flags = oldflags;
}

void ChangeFontSize(PPxEDSTRUCT *PES, int delta)
{
	HWND hWnd = PES->hWnd;
	HFONT hFont = (HFONT)SendMessage(hWnd, WM_GETFONT, 0, 0);
	HFONT hNewFont;
	LOGFONT lfont;
	LONG oldheight;
	BOOL firstcreate = FALSE;

	GetObject(hFont, sizeof(LOGFONT), &lfont);
	if ( PES->OrgFontY == 0 ){
		PES->OrgFontY = lfont.lfHeight;
		firstcreate = TRUE;
	}
	oldheight = lfont.lfHeight;
	if ( delta == -9 ){
		lfont.lfHeight = PES->OrgFontY;
	}else{
		if ( lfont.lfHeight > 0 ){
			lfont.lfHeight += delta * 4;
			if ( lfont.lfHeight < 5 ) lfont.lfHeight = 5;
		}else{
			lfont.lfHeight -= delta * 4;
			if ( lfont.lfHeight > -5 ) lfont.lfHeight = -5;
		}
	}
	hNewFont = CreateFontIndirect(&lfont);
	SendMessage(hWnd, WM_SETFONT, (WPARAM)hNewFont, 0);
	if ( !firstcreate ) DeleteObject(hFont);

	if ( PES->flags & PPXEDIT_LINEEDIT ) {
		WindowExpandInfoStruct eis;

		eis.delta = lfont.lfHeight - oldheight;
		if ( lfont.lfHeight < 0 ) eis.delta = -eis.delta;

		eis.hParentWnd = GetParent(hWnd);
		GetDesktopRect(hWnd, &eis.boxDesk);
		GetWindowRect(hWnd, &eis.boxEdit);
		GetWindowRect(eis.hParentWnd, &eis.boxDialog);
		eis.boxEdit.bottom += -eis.boxEdit.top + eis.delta;
		EditBoxExpand(PES, &eis);
		hWnd = eis.hParentWnd;
	}
	InvalidateRect(hWnd, NULL, TRUE);
}

#define INMENU_BREAK B31
PPXINMENU escmenu[] = {
	{ K_c | 'O',	MES_MCOP },
	{ K_F12,		T("&Save as...")},
//	{ KE_en,		T("&New Files")},
//	{ ,				T("&Read Files")},
//	{ K_c | 'L',	T("&Load File")}, // ւǂݍ
	{ KE_ea,		T("&Append to file") },
//	{ ,				T("&Path Rename")}, // filename ύXAۑ͂Ȃ
	{ KE_ed,		T("&Duplicate PPe")},
//	{ KE_eu,		T("&Undo Edit")}, // ēǂݍ
	{ KE_ei,		T("&Insert from file")},
//	{ ,				T("Close all(&X)")},
	{ K_c | 'Q',	MES_MEED}, // T("edit menu")},
	{ K_s | K_F2,	T("%G\"MEST|settings menu\"(&G)")},
	{PPXINMENY_SEPARATE, NULL },
	{ KE_kp	,		T("&Print by PPv")}, // 
	{PPXINMENY_SEPARATE, NULL },
	{ K_s | K_F1,	T("&Help")},
	{PPXINMENY_SEPARATE, NULL },
	{ KE_er,		T("&Run as admin")},
	{ KE_ee,		T("&Exec command")},
	{ KE_ec,		MES_TABC },
//	{ KE_eq,		T("&Quit")},
	{ 0, NULL }
};

PPXINMENU f2menu[] = {
	{ KE_qj,	MES_SJLN},
//	{ KE_2b,	T("&Block Top/End")},
//	{ KE_2l,	T("Restore &Line")},
//	{ KE_2s,	T("&Screen Lines")}, // sύX
//	{ KE_kr,	T("&Read Only")},
	{ KE_qv,	MES_MERO}, //T("&View Mode")},
	{ KE_2t,	T("&TAB stop...")},
	{ KE_2c,	T("&Char code...")},
	{ KE_2r,	T("&Return code...")},
	{ KE_2p,	MES_MEWW}, // T("&Word wrap")},
	{ KE_2x,	MES_MERS}, // T("Regexp serach(&X)")},
//	{ KE_2a,	T("&Auto Save")},
	{ 0, NULL }
};

PPXINMENU kmenu[] = {
	{ KE_kp,	T("&Print by PPv")},
//	{ KE_ku,	T("&Undo Paste")},
//	{ KE_kc,	T("Paste(&Copy)")},
//	{ KE_kk,	T("Copy Line/Bloc&k")},
	{ KE_kd,	MES_MEDL}, // T("&Duplicate line")},
	{ KE_kz,	MES_SWCZ},
//	{ KE_kr,	T("&Read only")},
//	{ KE_kb,	T("Column &Block")},
//	{ KE_ky,	T("&Y clear stack")},
//	{ KE_k0,	T("Set Marker #&0")},
//	{ KE_k1,	T("Set Marker #&1")},
//	{ KE_k2,	T("Set Marker #&2")},
//	{ KE_k3,	T("Set Marker #&3")},
//	{ KE_k4,	T("Set Marker #&4")},
	{ 0, NULL }
};

PPXINMENU qmenu[] = {
//	{ KE_qh,	T("Cut word left(&H)")},
//	{ KE_qt,	T("Cu&t BOL")},
//	{ KE_qy,	T("Cut EOL(&Y)")},
	{ KE_qu,	T("%G\"SWCA|Word case\"(&U)")},
	{ KE_kz,	MES_SWCZ},
	{ KE_kd,	MES_MEDL}, // T("&Duplicate line")},
	{ KE_qv,	MES_MERO}, //T("&View Mode")},
//	{ KE_ql,	T("Restore &Line")},
//	{ KE_qf,	T("Set &Find string")},
//	{ KE_qo,	T("Replece Next(&O)")},
//	{ KE_qp,	T("&Put File Name")},
	{ K_c | K_s | 'I', T("%G\"VIMF|Insert selected filename...\"(&N)")},
	{ K_s | K_F7,	T("%G\"MEFS|&Insert find str\"\tShift+F7")},

	{ KE_qj,	MES_SJLN},
	{ KE_qr,	MES_SJTT}, // T("Top of text(&R)")},
	{ KE_qc,	MES_SJTE}, // T("End of text(&C)")},
//	{ KE_qp,	T("Last &Position")},
//	{ KE_qo,	T("Replace Next(&O)")},
//	{ KE_qlw,	T("Left of Window(&[)")},
//	{ KE_qrw,	T("Right of Window(&])")},
//	{ KE_qs,	T("Top of Line(&S)")},
//	{ KE_qd,	T("End of Line(&D)")},
	{ KE_qe,	MES_SJWT}, // T("Top of Window(&E)")},
	{ KE_qx,	MES_SJWE}, // T("End of Window(&X)")},
//	{ KE_qk,	T("Jump Brac&ket")},
//	{ KE_qm,	T("Set &Marker #0")},
//	{ KE_q0,	T("Jump to Marker #&0")},
//	{ KE_q1,	T("Jump to Marker #&1")},
//	{ KE_q2,	T("Jump to Marker #&2")},
//	{ KE_q3,	T("Jump to Marker #&3")},
//	{ KE_q4,	T("Jump to Marker #&4")},
//	{ KE_qb,	T("&Block Top/End")},
	{ 0, NULL }
};

//abcdefg  j lmnopq stu w  z
PPXINMENU amenu[] = {
	{ K_c | 'Z',	T("%G\"JMUN|Undo\"(&U)\tCtrl+Z")},
	{PPXINMENY_SEPARATE, NULL},
	{ K_c | 'X',	T("%G\"JMCU|Cut\"(&T)\tCtrl+X")},
	{ K_c | 'C',	T("%G\"JMCL|Copy\"(&C)\tCtrl+C")},
	{ K_c | 'V',	T("%G\"JMPA|Paste\"(&P)\tCtrl+V")},
	{ K_del,		T("%G\"JMDE|Delete\"(&D)\tDelete")},
	{PPXINMENY_SEPARATE, NULL},
	{ K_c | 'A',	T("%G\"JMAL|Select All\"(&A)\tCtrl+A")},

	{ KE_defmenu | INMENU_BREAK,	T("%G\"MEDM|Original menu\"(&B)\tShift+F10")},
	{ K_c | ']',	T("%G\"MEMD|File &menu\"\tCtrl+]")},
	{ K_c | 'Q',	T("%G\"MEED|Edit menu\"\tCtrl+&Q")},
	{ K_s | K_F2,	T("%G\"MEST|Settings menu\"(&S)\tShift+F2")},
	{PPXINMENY_SEPARATE, NULL},
	{ KE_qu,		T("%G\"SWCA|Word case transfer\"(&W)\tCtrl+Q-U")},
	{ KE_kz,		T("%G\"SWCZ|&Zen/han transfer\"\tCtrl+K-Z")},
	{ KE_er,		T("&Run as admin\tESC-R")},
//	{ KE_ee,		T("&Execute command\tESC-E")},

	{ KE_qj | INMENU_BREAK,	T("%G\"SJLN|&Jump to Line\"\tCtrl+Q-J")},
	{ K_c | 'F',	T("%G\"VCHF|Find\"(&F)\tCtrl+F")},
	{PPXINMENY_SEPARATE, NULL},
	{ K_raw | K_s | K_c | 'P', T("Path List(&N)\tCtrl+Shift+P")},
	{ K_raw | K_s | K_c | 'L', T("PPc &List\tCtrl+Shift+L")},
	{ K_c | K_s | 'D', T("F&older dialog...\tCtrl+Shift+D")},
	{ K_c | K_s | 'I', T("%G\"VIMF|Insert selected filename...\"(&G)\tCtrl+Shift+I")},
	{ 0, NULL }
};

const TCHAR amenu2str[] = T("&Insert");
PPXINMENU amenu2[] = {
	{ K_c | 'N',	T("File&name\tCtrl+N")},
	{ K_c | 'P',	T("Full&path Filename\tCtrl+P")},
	{ K_c | 'E',	T("Filename without &ext\tCtrl+E")},
	{ K_c | 'T',	T("File ext\tCtrl+&T")},
	{ K_c | 'R',	T("Filename on curso&r\tCtrl+&R")},
	{ K_c | '0',	T("PPx path\tCtrl+&0")},
	{ K_c | '1',	T("Current path\tCtrl+&1")},
	{ K_c | '2',	T("Pair path\tCtrl+&2")},
	{ K_F5,			T("now &Date\tF5")},
	{ 0, NULL }
};

PPXINMENU returnmenu[] = {
	{ VTYPE_CRLF + 1,	T("C&R LF(Windows)")},
	{ VTYPE_CR + 1,		T("&CR")},
	{ VTYPE_LF + 1,		T("&LF(Unix)")},
	{ 0, NULL }
};

const TCHAR charmenustr_lcp[] = T("&local codepage");
const TCHAR charmenustr_other[] = T("&other...");

PPXINMENU charmenu[charmenu_items] = {
	{ CP__US,			T("US(&A)")},
	{ CP__LATIN1,		T("&Latin1")},
	{ VTYPE_SYSTEMCP,	T("&Shift_JIS")},
	{ VTYPE_EUCJP,		T("&EUC-JP")},
	{ CP__UTF16L,		T("UTF-1&6")},
	{ VTYPE_UNICODE,	T("&UTF-16LE(BOM)")},
	{ CP__UTF16B,		T("UTF-1&6BE")},
	{ VTYPE_UNICODEB,	T("UTF-1&6BE(BOM)")},
	{ CP_UTF8,			T("UTF-&8")},
	{ VTYPE_UTF8,		T("UTF-8(&BOM)")},
	{ 0, NULL }, //	{ VTYPE_SYSTEM/CP_UTF8,	charmenustr_lcp},
	{ 0, NULL }, //	{ VTYPE_OTHER		, T("codepage : %d")}
	{ 0, NULL }
};

typedef struct {
	PPXAPPINFO info;
	PPxEDSTRUCT *PES;
} EDITMODULEINFOSTRUCT;
const TCHAR EditInfoName[] = WC_EDIT;
const TCHAR GetFileExtsStr[] = T("All Files\0*.*\0\0");

LRESULT EdPPxWmCommand(PPxEDSTRUCT *PES, HWND hWnd, WPARAM wParam, LPARAM lParam);
void GetPPePopupPositon(PPxEDSTRUCT *PES, POINT *pos);

#define WIDEDELTA 32

#define CLOSELIST_NONE			0 // Xg͕\ĂȂ
#define CLOSELIST_MANUALLIST	1 // 蓮\Xg
#define CLOSELIST_AUTOLIST		2 // Xg

DefineWinAPI(HRESULT, SHAutoComplete, (HWND hwndEdit, DWORD dwFlags)) = NULL;
#ifndef SHACF_FILESYSTEM
#define SHACF_AUTOAPPEND_FORCE_ON	0x40000000
#define SHACF_AUTOSUGGEST_FORCE_ON	0x10000000
#define SHACF_FILESYSTEM			1
#define SHACF_USETAB				8
#endif

LOADWINAPISTRUCT SHLWAPIDLL[] = {
	LOADWINAPI1(SHAutoComplete),
	{NULL, NULL}
};
#define FloatBarID 12266
const TCHAR FloatClassStr[] = T("PPxFloatBar");
const TCHAR FloatBarNameMouseStr[] = T("B_flm");
const TCHAR FloatBarNamePenStr[] = T("B_flp");
const TCHAR FloatBarNameTouchStr[] = T("B_flt");

LRESULT CALLBACK FloatProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	PPxEDSTRUCT *PES;

	PES = (PPxEDSTRUCT *)GetWindowLongPtr(hWnd, GWLP_USERDATA);
	if ( PES == NULL ){
		if ( message == WM_CREATE ){
			PES = (PPxEDSTRUCT *)(((CREATESTRUCT *)lParam)->lpCreateParams);
			SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)PES);
			return 0;
		}
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	switch (message){
		case WM_COMMAND:
			if ( (HWND)lParam == PES->FloatBar.hToolBarWnd ){
				const TCHAR *ptr;

				ptr = GetToolBarCmd((HWND)lParam, &PES->FloatBar.Cmd, LOWORD(wParam));
				if ( ptr != NULL ){
					if ( ((UTCHAR)ptr[0] == EXTCMD_KEY) &&
						 (*(WORD *)(ptr + 1) == 'X') ){
						PostMessage(hWnd, WM_CLOSE, 0, 0);
					}else{
						PPECOMMANDPARAM param = {0, 0};

						PPedExtCommand(PES, &param, ptr);
					}
				}
				return 0;
			}
			break;

		case WM_WINDOWPOSCHANGED: {
			RECT box;

			GetClientRect(hWnd, &box);
			SetWindowPos(PES->FloatBar.hToolBarWnd, NULL,
					0, box.top, box.right, 32, SWP_NOACTIVATE | SWP_NOZORDER);
			break;
		}

		case WM_DESTROY:
			CloseToolBar(PES->FloatBar.hToolBarWnd);
			PES->FloatBar.hToolBarWnd = NULL;
			ThFree(&PES->FloatBar.Cmd);

			PES->FloatBar.hWnd = NULL;
			break;

		case WM_MOUSEACTIVATE:
			return MA_NOACTIVATE; // ANeBu
	}
	return DefWindowProc(hWnd, message, wParam, lParam);
}

#define BARSPACE 2
void InitFloatBar(PPxEDSTRUCT *PES, int posX)
{
	WNDCLASS FloatClass;
	UINT ID = FloatBarID;
	RECT box, editbox;
	LPARAM pointtype = GetMessageExtraInfo();
	const TCHAR *FloatBarNamePtr;
	int minheight, posY;
	HWND hParentWnd;

	if ( PES->FloatBar.Cmd.size == 1 ) return;

	if ( (pointtype & POINTTYPE_SIG_MASK) == POINTTYPE_TOUCH ){
		minheight = 32 - BARSPACE;
		FloatBarNamePtr = FloatBarNameTouchStr;
		if ( (pointtype & POINTTYPE_TOUCH_MASK) == POINTTYPE_TOUCH_PEN ){ //pen
			if ( (X_pmc[pmc_pen] & TOUCH_EDIT_COMMAND_BAR) ){ // _
				PES->FloatBar.Cmd.size = 1;
				return;
			}
			if ( IsExistCustData(FloatBarNamePenStr) ){
				FloatBarNamePtr = FloatBarNamePenStr;
			}
		}else{ //touch
			if ( (X_pmc[pmc_touch] & TOUCH_EDIT_COMMAND_BAR) ){ // _
				PES->FloatBar.Cmd.size = 1;
				return;
			}
		}
	}else{
		if ( (X_pmc[pmc_mouse] & TOUCH_EDIT_COMMAND_BAR) ){ // _
			PES->FloatBar.Cmd.size = 1;
			return;
		}

		minheight = 16 - BARSPACE;
		FloatBarNamePtr = FloatBarNameMouseStr;
	}

	if ( !IsExistCustData(FloatBarNamePtr) ){
		PES->FloatBar.Cmd.size = 1;
		return;
	}

	FloatClass.style		= 0;
	FloatClass.lpfnWndProc	= FloatProc;
	FloatClass.cbClsExtra	= 0;
	FloatClass.cbWndExtra	= 0;
	FloatClass.hInstance	= DLLhInst;
	FloatClass.hIcon		= NULL;
	FloatClass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	FloatClass.hbrBackground	= NULL;
	FloatClass.lpszMenuName	= NULL;
	FloatClass.lpszClassName	= FloatClassStr;
	RegisterClass(&FloatClass);

	// c[o[e
	PES->FloatBar.hWnd = CreateWindowEx(WS_EX_NOACTIVATE | WS_EX_TOOLWINDOW,
		FloatClassStr, NilStr, WS_POPUP,
		0, 0, 0, 0, PES->hWnd, NULL, DLLhInst, (LPVOID)PES);

	ThInit(&PES->FloatBar.Cmd);
	PES->FloatBar.hToolBarWnd = CreateToolBar(&PES->FloatBar.Cmd, PES->FloatBar.hWnd, &ID, FloatBarNamePtr, DLLpath, 0);

	// c[o[{̂̈ʒuƑ傫
	SetWindowPos(PES->FloatBar.hToolBarWnd, NULL,
			0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);

	SendMessage(PES->FloatBar.hToolBarWnd, TB_GETITEMRECT,
		SendMessage(PES->FloatBar.hToolBarWnd, TB_BUTTONCOUNT, 0, 0) - 1,
		(LPARAM)(RECT *)&box);

	minheight = (minheight * GetMonitorDPI(PES->hWnd)) / DEFAULT_WIN_DPI;
	if ( box.bottom < minheight ){
		box.bottom = minheight;
		SendMessage(PES->FloatBar.hToolBarWnd, TB_SETBUTTONSIZE, 0, TMAKELPARAM(minheight, minheight));
	}
	box.bottom += BARSPACE;

	GetWindowRect(PES->hWnd, &editbox);

	posX = editbox.left + posX - box.right / 2;
	if ( posX < editbox.left ) posX = editbox.left;
	posY = editbox.bottom; // ʏ̏ꏊ: EDIT ̒
	hParentWnd = GetParentCaptionWindow(PES->hWnd);
	if ( hParentWnd != PES->hWnd ){
		RECT tmpbox, deskbox;

		GetWindowRect(hParentWnd, &tmpbox);
		if ( (tmpbox.bottom - posY) < (int)PES->fontY * 3 ) posY = tmpbox.bottom - 4;
		if ( PES->flags & PPXEDIT_COMBOBOX ){
			posY = editbox.top - box.bottom;
		}

		GetDesktopRect(hParentWnd, &deskbox);
		if ( (posX + box.right) > deskbox.right ){
			posX = deskbox.right - box.right;
		}
		if ( posX < deskbox.left ) posX = deskbox.left;
		if ( (posY + box.bottom) > deskbox.bottom ){ // ɂ͂ݏoȂEDIT
			posY = editbox.top - box.bottom;
		}
	}

	SetWindowPos(PES->FloatBar.hWnd, NULL,
			posX, posY,  box.right, box.bottom,
			SWP_NOREDRAW | SWP_NOACTIVATE | SWP_NOZORDER);

	ShowWindow(PES->FloatBar.hWnd, SW_SHOWNOACTIVATE);
}

void WMGestureEdit(HWND hWnd, WPARAM wParam/*, LPARAM lParam*/)
{
/*
	if ( TouchMode == 0 ){
		GetCustData(T("X_pmc"), &X_pmc, sizeof(X_pmc));
		if ( X_pmc[pmc_mode] < 0 ){
			TouchMode = ~X_pmc[pmc_touch];
			PPxCommonCommand(hWnd, 0, K_E_TABLET);
		}
	}else{
*/
	{
		switch ( wParam ){
			case GID_TWOFINGERTAP:
				PostMessage(hWnd, WM_PPXCOMMAND, K_apps, 0);
				break;

			case GID_PRESSANDTAP:
				PostMessage(hWnd, WM_PPXCOMMAND, K_apps, 0);
				break;
		}
	}
}

void PPeRunas(PPxEDSTRUCT *PES, TCHAR *cmdline)
{
	TCHAR path[VFPS];
	TCHAR exefile[VFPS];
	const TCHAR *ptr;
	PPXCMDENUMSTRUCT work;

	PPxEnumInfoFunc(PES->info, '1', path, &work);
	ptr = cmdline;
	GetLineParamS(&ptr, exefile, TSIZEOF(exefile));
	if ( PPxShellExecute(PES->hWnd, T("RUNAS"), exefile, ptr, path, 0, cmdline) != NULL ){
		WriteHistory(PPXH_COMMAND, cmdline, 0, NULL);
		PostMessage(GetParentCaptionWindow(PES->hWnd), WM_CLOSE, 0, 0);
	}else{
		if ( GetLastError() != ERROR_CANCELLED ){
			XMessage(PES->hWnd, NULL, XM_GrERRld, cmdline);
		}
	}
}

void WideWindowByKey(PPxEDSTRUCT *PES, int offsetW, int offsetH)
{
	RECT box;
	HWND hWnd;

	if ( !(PES->flags & (PPXEDIT_LINEEDIT | PPXEDIT_ENABLE_SIZE_CHANGE)) ){
		return;
	}
	hWnd = GetParentCaptionWindow(PES->hWnd);
	GetWindowRect(hWnd, &box);

	box.right -= box.left;
	if ( (offsetW < 0) && (box.right < (WIDEDELTA * 2)) ) offsetW = 0;

	box.bottom -= box.top;
	if ( (!(PES->flags & PPXEDIT_ENABLE_HEIGHT_CHANGE)) ||
		 ((offsetH < 0) && (box.bottom < (int)(PES->fontY * 2))) ){
		offsetH = 0;
	}
	if ( offsetW || offsetH ){
		box.right += offsetW * WIDEDELTA;
		box.bottom += offsetH * PES->fontY;

		SetWindowPos(hWnd, NULL, 0, 0,
				box.right, box.bottom, SWP_NOZORDER | SWP_NOMOVE);
	}
}

#define ZENRATE (2 / sizeof(TCHAR)) // Multibyte ̎ 2(S2{), UNICODE ̂Ƃ 1
void USEFASTCALL PPeConvertZenHanMain(PPxEDSTRUCT *PES, HWND hWnd, int mode)
{
	TEXTSEL ts;
	TCHAR defbuf[CMDLINESIZE * ZENRATE], *buf;
	TCHAR *buflast;
	const TCHAR *first;
	size_t wordlen;

	if ( SelectEditStrings(PES, &ts, TEXTSEL_WORD) == FALSE ) return;

	// ȈՑSo
	for ( first = ts.word ; (UTCHAR)*first < ' ' ; first++ );

	if ( mode < 0 ){
	#ifdef UNICODE
		mode = ((*first >= L' ') && (*first <= L'~')) || ((*first >= L'') && (*first <= L''));
	#else
		mode = !IskanjiA(*first);
	#endif
	}
	wordlen = tstrlen(ts.word);

	if ( wordlen < (CMDLINESIZE - 1) ){
		buf = defbuf;
	}else{
		buf = HeapAlloc(DLLheap, 0, TSTROFF(wordlen * ZENRATE));
	}
	if ( buf != NULL ){
		// ϊ
		if ( mode ){
			buflast = Strsd(buf, ts.word);
		}else{
			buflast = Strds(buf, ts.word);
		}
#ifdef UNICODE
		if ( memcmp(buf, ts.word, TSTROFF(buflast - buf)) == 0 )
#else
		if ( (buflast - buf) == wordlen )
#endif
		{ // ϊɎsΕɕϊ
			if ( !mode ){
				buflast = Strsd(buf, ts.word);
			}else{
				buflast = Strds(buf, ts.word);
			}
		}
		SendMessage(hWnd, EM_REPLACESEL, 1, (LPARAM)buf);
		if ( ts.cursororg.start != ts.cursororg.end ){
			ts.cursororg.end = buflast - buf;
#ifndef UNICODE
			if ( xpbug < 0 ) CaretFixToW(buf, &ts.cursororg.end);
#endif
			ts.cursororg.end += ts.cursororg.start;
		}
		SendMessage(hWnd, EM_SETSEL, ts.cursororg.start, ts.cursororg.end);
		if ( buf != defbuf ) HeapFree(DLLheap, 0, buf);
	}
	FreeTextselStruct(&ts);
}

// *find
void PPeFind(PPxEDSTRUCT *PES, const TCHAR *param)
{
	DWORD replaceFlags = 0;
	const TCHAR *more;
	TCHAR buf[CMDLINESIZE];
	UTCHAR code;
	int dist = EDITDIST_NEXT;

	if ( PES->findrep == NULL ){
		if ( InitPPeFindReplace(PES) == FALSE ) return;
	}
	while( '\0' != (code = GetOptionParameter(&param, buf, CONSTCAST(TCHAR **, &more))) ){
		if ( code == '-' ){
			if ( !tstrcmp( buf + 1, T("REPLACE")) ){
				tstplimcpy(PES->findrep->replacetext, more, VFPS);
				if ( replaceFlags == 0 ) replaceFlags = FR_REPLACE;
				continue;
			}
			if ( !tstrcmp( buf + 1, T("ALL")) ){
				replaceFlags = FR_REPLACEALL;
				continue;
			}
			/*
			if ( !tstrcmp( buf + 1, T("FORWARD")) ){
				dist = EDITDIST_NEXT;
				continue;
			}
			*/
			if ( !tstrcmp( buf + 1, T("BACK")) || !tstrcmp( buf + 1, T("PREVIOUS")) ){
				dist = EDITDIST_BACK;
				continue;
			}
			if ( !tstrcmp( buf + 1, T("DIALOG")) ){
				dist = EDITDIST_DIALOG;
				continue;
			}
			if ( !tstrcmp( buf + 1, T("REGEXP")) ){
				X_esrx = CheckParamOnOff(&more);
				continue;
			}
			XMessage(NULL, NULL, XM_GrERRld, StrOptionError, buf);
		}else{
			#pragma warning(suppress:6001 6011) // InitPPeFindReplace ŏ
			tstplimcpy(PES->findrep->findtext, buf, VFPS);
		}
	}
	if ( replaceFlags == 0 ){
		SearchStr(PES, dist);
	}else{
		if ( dist == EDITDIST_DIALOG ){
			PPeReplaceStr(PES);
		}else{
			FINDREPLACE freplace;

			freplace.hwndOwner = PES->hWnd;
			freplace.Flags = FR_DOWN | FR_HIDEMATCHCASE | FR_HIDEWHOLEWORD | replaceFlags;
			freplace.lpstrFindWhat = PES->findrep->findtext;
			freplace.lpstrReplaceWith = PES->findrep->replacetext;
//			freplace.wFindWhatLen = VFPS;
//			freplace.wReplaceWithLen = VFPS;
			freplace.lCustData = 0;
			PPeReplaceStrCommand(PES, &freplace);
		}
	}
}

BOOL SetHistorySettings(PPxEDSTRUCT *PES, const TCHAR *more)
{
	BOOL result;
	TINPUT_EDIT_OPTIONS options;

	result = GetEditMode(&more, &options);
	if ( IsTrue(result) ){
		PES->list.RhistID = options.hist_readflags;
		PES->list.WhistID = HistWriteTypeflag[options.hist_writetype];
		PES->flags = (PES->flags & ~(TIEX_REFTREE | TIEX_SINGLEREF)) |
				TinputTypeflags[options.hist_writetype];
		if ( options.flags & TINPUT_EDIT_OPTIONS_single_param ){
			setflag(PES->flags, TIEX_SINGLEREF);
		}
	}
	return result;
}

void SetMatchMode(PPxEDSTRUCT *PES, int mode)
{
	if ( mode >= 2 ){ // v
		setflag(PES->ED.cmdsearch, CMDSEARCH_FLOAT);
		if ( mode == 3 ){ // v + I
			setflag(PES->flags, CMDSEARCHI_SELECTPART | PPXEDIT_LISTCOMP);
			if ( X_flst_mode == X_fmode_off ) X_flst_mode = X_fmode_manual;
		}else if ( mode == 4 ){ // migemo
			setflag(PES->ED.cmdsearch, CMDSEARCH_ROMA);
		}else if ( mode == 5 ){ // and
			setflag(PES->ED.cmdsearch, CMDSEARCH_WILDCARD);
		}else if ( mode == 6 ){ // and + migemo
			setflag(PES->ED.cmdsearch, CMDSEARCH_WILDCARD | CMDSEARCH_ROMA);
		}else if ( mode == 7 ){ // regexp
			setflag(PES->ED.cmdsearch, CMDSEARCH_REGEXP);
		}
	}
}

// *completelist
void EditCompleteListCommand(PPxEDSTRUCT *PES, const TCHAR *param)
{
	TCHAR *more, *option = NULL;
	TCHAR buf[CMDLINESIZE], text[CMDLINESIZE];
	UTCHAR code;

	BOOL setmode = FALSE;

	text[0] = '\0';
	while( '\0' != (code = GetOptionParameter(&param, buf, &more)) ){
		if ( code == '-' ){
			if ( !tstrcmp( buf + 1, T("CLOSE")) ){
				CloseLineList(PES);
				return;
			}

			if ( !tstrcmp( buf + 1, T("RELOAD")) ){
				CleanUpEdit();
				continue;
			}

			if ( !tstrcmp( buf + 1, T("FREE")) ){
				CancelListThread(PES);
				CloseLineList(PES);
				CleanUpEdit();
				PES->ListThreadCount = 0;
				continue;
			}

			if ( !tstrcmp( buf + 1, T("SET")) ){
				setmode = TRUE;
				continue;
			}

			if ( !tstrcmp( buf + 1, T("SHOW")) ){
				setmode = FALSE;
				tstrcpy(text, more);
				option = text;
				continue;
			}

			if ( !tstrcmp( buf + 1, T("HISTORY")) ){
				if ( SetHistorySettings(PES, more) ){
					resetflag(PES->list.flags, LISTFLAG_USER_COMB);
					continue;
				}else{
					return;
				}
			}

			if ( !tstrcmp( buf + 1, T("LIST")) ){
				int mode;

				if ( SkipSpace((const TCHAR **)&more) == '\0' ){
					mode = 9; // -list:on 
				}else{
					mode = GetStringListCommand(more,
							T("disable\0") T("file\0") T("api\0") T("single\0") T("double\0") T("doubleex\0")
							T("paramchange\0") T("allchange\0") T("off\0") T("on\0"));
				}
				if ( mode < 0 ){
					XMessage(PES->hWnd, T("*completelist"), XM_GrERRld, StrOptionError, more);
				}else if ( mode < 6 ){ // disable, file, api, single, double/ex
					CancelListThread(PES);
					CloseLineList(PES);
					X_flst_mode = mode;
					if ( X_flst_mode == X_fmode_off ){
						resetflag(PES->flags, PPXEDIT_LISTCOMP);
					}else{
						setflag(PES->flags, PPXEDIT_LISTCOMP);
					}
					continue;
				}else if ( mode == 6 ){ // paramchange
					resetflag(PES->flags, PPXEDIT_SINGLEREF);
					continue;
				}else if ( mode == 7 ){ // allchange
					setflag(PES->flags, PPXEDIT_SINGLEREF);
					continue;
				}else{
					if ( mode == 8 ){ // -list:off
						resetflag(PES->list.flags, LISTFLAG_LISTMODE);
					}else{ // mode == 9 -list:on
						setflag(PES->list.flags, LISTFLAG_LISTMODE);
						option = KeyStepFill_listmode;
					}
					continue;
				}
			}

			if ( !tstrcmp( buf + 1, T("MODULE")) ){
				if ( CheckParamOnOff((const TCHAR **)&more) != 0 ){
					resetflag(PES->list.flags, LISTFLAG_NOMODULE);
				}else{
					setflag(PES->list.flags, LISTFLAG_NOMODULE);
				}
				continue;
			}

			if ( !tstrcmp( buf + 1, T("MATCH")) ){
				resetflag(PES->ED.cmdsearch, CMDSEARCH_MATCHFLAGS);
				SetMatchMode(PES, GetIntNumber((const TCHAR **)&more));
				if ( SkipSpace((const TCHAR **)&more) == ',' ){
					setflag(PES->flags, CMDSEARCHI_SELECTPART | PPXEDIT_LISTCOMP);
					if ( X_flst_mode == X_fmode_off ) X_flst_mode = X_fmode_manual;
				}
				continue;
			}

			// keystepfillƃL[ƏĂ܂B
/*
			if ( !tstrcmp( buf + 1, T("ADDITEM")) ){
				KeyStepFill(PES, option);
				if ( PES->list.hWnd == NULL ){
					int direction;

					PES->list.mode = PES->list.startmode = LIST_FILL;
					direction = (PES->flags & PPXEDIT_COMBOBOX) ? -1 : 1;

					CreateMainListWindow(PES, direction);
				}

				if ( PES->list.hWnd != NULL ){
					SendMessage(PES->list.hWnd, LB_INSERTSTRING, 0, (LPARAM)more);
					ShowWindow(PES->list.hWnd, SW_SHOWNA);
				}
				return;
			}
*/
			if ( !tstrcmp( buf + 1, T("DETAIL")) ){
				if ( *more == '\0' ){
					resetflag(PES->list.flags, LISTFLAG_USER_COMB);
				}else{
					setflag(PES->list.flags, LISTFLAG_USER_COMB);
					ThSetString(&PES->LocalStringValue, LSV_user_comb, more);
				}
				continue;
			}

			if ( !tstrcmp( buf + 1, T("SCROLL")) ){
				ListWidth(PES, GetIntNumber((const TCHAR **)&more));
				return;
			}

			if ( !tstrcmp( buf + 1, T("WIDE")) ){
				ListWidth(PES, GetIntNumber((const TCHAR **)&more));
				return;
			}

			if ( !tstrcmp( buf + 1, T("FILE")) ){
				ERRORCODE result;

				{ // file gp̏I҂
					#define ThreadChkSleepTime 20
					int WaitTimer = 1000 / ThreadChkSleepTime;
					PES->ActiveListThreadID = 0;
					for ( ;; ){
						if ( PES->ListThreadCount == 0 ) break;
						PeekMessageLoop(PES->hWnd);
						Sleep(ThreadChkSleepTime);
						if ( --WaitTimer <= 0 ) break;
					}
				}

				FreeFillTextFile(&PES->list.filltext_user);
				if ( *more == '\0' ) return;


				PES->list.filltext_user.loading = TRUE;
				VFSFullPath(NULL, more, DLLpath);

				if ( (result = LoadTextData(more, &PES->list.filltext_user.mem, &PES->list.filltext_user.text, NULL, 0)) != NO_ERROR ){
					PES->list.filltext_user.loading = FALSE;
					PPErrorBox(PES->hWnd, T("*completelist -file"), result);
					return;
				}
				PES->list.filltext_user.loading = FALSE;
				continue;
			}
		}
		XMessage(PES->hWnd, T("*completelist"), XM_GrERRld, StrOptionError, buf);
		return;
	}
	if ( IsTrue(setmode) ){
		if ( option == KeyStepFill_listmode ){
			setflag(PES->list.flags, LISTFLAG_LISTMODE);
		}
		return;
	}

	KeyStepFill(PES, option);
}

void EditTreeCommand(PPxEDSTRUCT *PES, const TCHAR *param)
{
	TCHAR cmdstr[VFPS];

	if ( PES->hTreeWnd == NULL ){
		GetLineParamS(&param, cmdstr, TSIZEOF(cmdstr));
		if ( !tstrcmp(cmdstr, T("off")) ) return; // close ς
		PPeTreeWindow(PES);
		if ( cmdstr[0] == '\0' ) return;
	}
	if ( PES->hTreeWnd != NULL ){
		SendMessage(PES->hTreeWnd, VTM_TREECOMMAND, 0, (LPARAM)param); // `On
	}
}

BOOL EditModeParam(EDITMODESTRUCT *ems, const TCHAR *param, const TCHAR *more)
{
	// codepage
	if ( tstrcmp(param, T("SYSTEM")) == 0 ){
		ems->codepage = VTYPE_SYSTEMCP;
	}else if ( (tstrcmp(param, T("UNICODE")) == 0) || (tstrcmp(param, T("UTF16")) == 0) ){
		ems->codepage = CP__UTF16L;
	}else if ( (tstrcmp(param, T("UNICODEB")) == 0) || (tstrcmp(param, T("UTF16BE")) == 0) ){
		ems->codepage = CP__UTF16B;
	}else if ( tstrcmp(param, T("UNICODEBOM")) == 0 ){
		ems->codepage = VTYPE_UNICODE;
	}else if ( tstrcmp(param, T("UNICODEBBOM")) == 0 ){
		ems->codepage = VTYPE_UNICODEB;
	}else if ( tstrcmp(param, T("EUC")) == 0 ){
		ems->codepage = VTYPE_EUCJP;
	}else if ( tstrcmp(param, T("UTF8")) == 0 ){
		ems->codepage = CP_UTF8;
	}else if ( tstrcmp(param, T("UTF8BOM")) == 0 ){
		ems->codepage = VTYPE_UTF8;
	}else if ( tstrcmp(param, T("SJIS")) == 0 ){
		ems->codepage = (GetACP() == CP__SJIS) ? VTYPE_SYSTEMCP : CP__SJIS;
	}else if ( (tstrcmp(param, T("IBM")) == 0) || (tstrcmp(param, T("US")) == 0) ){
		ems->codepage = CP__US;
	}else if ( (tstrcmp(param, T("ANSI")) == 0) || (tstrcmp(param, T("LATIN1")) == 0)){
		ems->codepage = CP__LATIN1;
	}else if ( tstrcmp(param, T("CODEPAGE")) == 0 ){
		ems->codepage = GetNumber((const TCHAR **)&more);
	// crcode
	}else if ( tstrcmp(param, CRCD_CR) == 0 ){
		ems->crcode = VTYPE_CR;
	}else if ( tstrcmp(param, CRCD_CRLF) == 0 ){
		ems->crcode = VTYPE_CRLF;
	}else if ( tstrcmp(param, CRCD_LF) == 0 ){
		ems->crcode = VTYPE_LF;
	// tabwidth
	}else if ( tstrcmp(param, T("TAB")) == 0 ){
		ems->tabwidth = GetNumber((const TCHAR **)&more);
	}else{
		return FALSE;
	}
	return TRUE;
}

void PutOptionFlags(TCHAR *dest, DWORD flags, const TCHAR *flagletters, int maxbits)
{
	int i;

	for ( i = 0; i < maxbits; i++ ){
		if ( flags & (1 << i) ) *dest++ = *(flagletters + i);
	}
	*dest = '\0';
}

void CursorTextFunction(PPxEDSTRUCT *PES, PPXMDLFUNCSTRUCT *funcparam) // %*cursortext
{
	EditTextStruct ets;
	ECURSOR cursor;
	int len;

	funcparam->dest[0] = '\0';
	if ( OpenEditText(PES, &ets, 0) == FALSE ) return;
	GetEditSel(PES->hWnd, ets.text, &cursor);
	GetWordStrings(ets.text, &cursor, (*funcparam->optparam == 'o') ? GWSF_SPLIT_PARAM : 0);

	len = tstrlen(ets.text + cursor.start);
	if ( len >= CMDLINESIZE ){
		TCHAR *longbuf;
		longbuf = HeapAlloc(ProcHeap, 0, TSTROFF(len + 1));
		if ( longbuf != NULL ){
			funcparam->dest = longbuf;
			tstrcpy(funcparam->dest, ets.text + cursor.start);
		}else{
			tstplimcpy(funcparam->dest, ets.text + cursor.start, CMDLINESIZE);
		}
	}else{
		tstrcpy(funcparam->dest, ets.text + cursor.start);
	}
	CloseEditText(&ets);
}

// *jumpline
void EditJumpLineCommand(PPxEDSTRUCT *PES, const TCHAR *param)
{
	int line, col = 0;
	EditLPos elp = { NULL, NULL, EditLPos_GET_CURSORPOS, 0, 0, NULL};
	TCHAR buf[20], pre;

	PPeLogicalLinePos(PES, &elp);

	if ( param == NULL ){
		param = buf;
		Numer32ToString(buf, elp.y + 1);
//		line = SendMessage(PES->hWnd, EM_LINEFROMCHAR, (WPARAM)-1, 0);
//		Numer32ToString(buf, line + 1);
		if ( tInput(PES->hWnd, MES_TLNO, buf, 10, PPXH_NUMBER, PPXH_NUMBER) <= 0 ){
			return;
		}
	}
	pre = TinyCharUpper(*param);
	if ( pre == 'L' ){
		param++;
	}else if ( pre == 'Y' ){
		param++;
	}
	line = GetIntNumber(&param);
	if ( SkipSpace(&param) == ',' ){
		param++;
		col = GetIntNumber(&param);
	}
	if ( (line != 0) || (col != 0) ){
		int CursorCmd[] = {0, 0, 0, 0, 0, 0};
		if ( pre == 'Y' ){
			if ( col == 0 ){
				JumptoLine(PES->hWnd, line - 1);
			}else{
				CursorCmd[0] = -3;
				CursorCmd[1] = (col > 0) ? col - 1 : 0;
				CursorCmd[2] = (line > 0) ? line - 1 : 0;
				EditCursorCommand(PES, (PPXAPPINFOUNION *)&CursorCmd);
			}
		}else{
			CursorCmd[0] = -17;
			CursorCmd[1] = (col > 0) ? col : elp.x + 1;
			CursorCmd[2] = (line > 0) ? line : elp.y + 1;
			EditCursorCommand(PES, (PPXAPPINFOUNION *)&CursorCmd);
		}
	}
}

const TCHAR Hist_flags[] = T("gnd\x3xu\x6\x7vshfcmp");

// %*editprop
void EditGetPropFunction(PPxEDSTRUCT *PES, PPXMDLFUNCSTRUCT *fparam)
{
	WPARAM wParam;
	LPARAM lParam;
	TCHAR param[64];

	fparam->dest[0] = '\0';
	GetCommandParameter(&fparam->optparam, param, TSIZEOF(param));
	switch ( param[0] ){
		case 'c': // codepage
			Numer32ToString(fparam->dest, PES->CharCP);
			break;

		case 'd': // displaytop
			Numer32ToString(fparam->dest,
				(DWORD)SendMessage(PES->hWnd, EM_GETFIRSTVISIBLELINE, 0, 0) + 1);
			break;

		case 'f': // flags, findtext
			if ( tstrcmp(param + 1, T("indtext")) == 0 ){ // findtext
				tstrcpy(fparam->dest, (PES->findrep != NULL) ? PES->findrep->findtext : NilStr);
			}else{ // flags
				Numer32ToString(fparam->dest, PES->flags);
			}
			break;

		case 'h': // history
			PutOptionFlags(fparam->dest, PES->list.RhistID, Hist_flags, TSIZEOFSTR(Hist_flags));
			break;

		case 'l': // list / line,lines,loglines / liststatus
			if ( tstrcmp(param + 1, T("ist")) == 0 ){ // list
				Int32ToString(fparam->dest, PES->list.ListFocus);
			}else if ( tstrcmp(param + 1, T("iststatus")) == 0 ){ // liststatus
				thprintf(fparam->dest, CMDLINESIZE,
					T("list1: %s   list2: %s\n")
					T("focus: %d\n")
					T("threads: %d/") T(DefineToStr(LIST_THREAD_MAX)) T("\n")
					T("user list: %s"),
					(PES->list.hWnd != NULL) ? T("use") : T("close"),
					(PES->list.hSubWnd != NULL) ? T("use") : T("close"),
					PES->list.ListFocus,
					PES->ListThreadCount,
					(PES->list.filltext_user.mem != NULL) ? T("on") : T("off")
				);
			}else if ( tstrcmp(param + 1, T("oglines")) == 0 ){ // loglines
				Numer32ToString(fparam->dest, (DWORD)PPeGetLogicalPos(PES, 4) + 1);
			}else { // line,lines
				Numer32ToString(fparam->dest, (DWORD)SendMessage(PES->hWnd, EM_GETLINECOUNT, 0, 0));
			}
			break;

		case 'm': // modify / mode
			if ( tstrcmp(param, T("modify")) == 0 ){ // modify
				Numer32ToString(fparam->dest, (DWORD)SendMessage(PES->hWnd, EM_GETMODIFY, 0, 0));
			}else{ // mode
				fparam->dest[0] = (TCHAR)((PES->flags & PPXEDIT_TEXTEDIT) ? 'T' : 'L');
				fparam->dest[1] = (TCHAR)((PES->flags & PPXEDIT_LINE_MULTI) ? 'M' : ' ');
				Numer32ToString(fparam->dest + 2, PES->style);
			}
			break;

		case 'n': // name
			ThGetString(&PES->LocalStringValue, LSV_filename, fparam->dest, VFPS);
			break;

		case 'p': // pagex / pagey
			Numer32ToString(fparam->dest,
					GetPageInfo(PES, (tstrcmp(param, T("pagex")) != 0)) );
			break;

		case 'r':
			if ( tstrcmp(param + 1, T("eplacetext")) == 0 ){ // replacetext
				tstrcpy(fparam->dest, (PES->findrep != NULL) ? PES->findrep->replacetext : NilStr);
			}else{ // returncode
				tstrcpy(fparam->dest, CRCD_list[PES->CrCode]);
			}
			break;

		case 's': // start / startline / startlogx startlogy
		case 'e': // end / endline
			if ( tstrcmp(param + 1, T("tartlogcolumn")) == 0 ){ // startlogcolumn
				wParam = PPeGetLogicalPos(PES, 0) + 1;
			}else if ( tstrcmp(param + 1, T("tartlogline")) == 0 ){ // startlogline
				wParam = PPeGetLogicalPos(PES, 1) + 1;
			}else if ( tstrcmp(param + 1, T("ndlogcolumn")) == 0 ){ // endlogcolumn
				wParam = PPeGetLogicalPos(PES, 2) + 1;
			}else if ( tstrcmp(param + 1, T("ndlogline")) == 0 ){ // endlogline
				wParam = PPeGetLogicalPos(PES, 3) + 1;
			}else if ( tstrcmp(param, T("startlogy")) == 0 ){
				wParam = PPeGetLogicalPos(PES, 1);
			}else if ( tstrcmp(param, T("startlogx")) == 0 ){
				wParam = PPeGetLogicalPos(PES, 0);
			}else{ // start / end
				SendMessage(PES->hWnd, EM_GETSEL, (WPARAM)&wParam, (LPARAM)&lParam);
				if ( param[0] == 'e' ) wParam = lParam;
				if ( tstrchr(param, 'l') != NULL ){
					wParam = SendMessage(PES->hWnd, EM_LINEFROMCHAR, wParam, 0) + 1;
				}
			}
			Numer32ToString(fparam->dest, (DWORD)wParam);
			break;

		case 't': // tab
			Numer32ToString(fparam->dest, PES->tab);
			break;

		case 'w': // whistory
			PutOptionFlags(fparam->dest, PES->list.WhistID, Hist_flags, TSIZEOFSTR(Hist_flags));
			break;

		default:
			tstrcpy(fparam->dest, T("?"));
	}
}

#define LineBreak_TOGGLE	-1 // toggle
#define LineBreak_NOWRAP	0 // off
#define LineBreak_CHAR	1 // on / char
#define LineBreak_WORD	2 // word
void ChangeLineBreak(PPxEDSTRUCT *PES, int mode)
{
	PPxEDSTRUCT *NewPES;
	HWND hNewWnd, hParentWnd;
	UINT newstyle;
	RECT box;
	EditTextStruct ets;

	if ( PES->flags & PPXEDIT_COMBOBOX ) return; // R{{bNX͕s

	if ( mode < 0 ){ // LineBreak_TOGGLE
		mode = (PES->style & ES_AUTOHSCROLL) ? LineBreak_CHAR : LineBreak_NOWRAP;
	}
	if ( mode == LineBreak_NOWRAP ){
		if ( PES->style & ES_AUTOHSCROLL ) return; // ύXsv
		newstyle = PES->style | ES_AUTOHSCROLL | WS_HSCROLL;
	}else{
		if ( !(PES->style & ES_AUTOHSCROLL) ) return; // ύXsv
		newstyle = PES->style & ~(ES_AUTOHSCROLL | WS_HSCROLL);
	}
	// Ҕ
	hParentWnd = GetParent(PES->hWnd);
	GetClientRect(hParentWnd, &box);

	hNewWnd = CreateWindowEx(PES->exstyle, EditClassName, NilStr, newstyle,
			 box.left, box.top, box.right - box.left, box.bottom - box.top,
			 hParentWnd, CHILDWNDID(IDE_PPEMAIN), DLLhInst, 0);
	if ( hNewWnd == NULL ) return; // ύXɎs

	if ( SendMessage(hParentWnd, WM_PPXCOMMAND, KE_ChangeHWND, (LPARAM)hNewWnd) != (LRESULT)hNewWnd ){ // ύXɑΉĂ邩H
		DestroyWindow(hNewWnd);
		return;
	}

	// VWindowݒ
	NewPES = HeapAlloc(DLLheap, 0, sizeof(PPxEDSTRUCT));
	if ( NewPES == NULL ) {
		DestroyWindow(hNewWnd);
		return; // s
	}
	*NewPES = *PES;

	// ݒ̈ڐA
	FixUxTheme(hNewWnd, EditClassName);
	SendMessage(hNewWnd, WM_SETFONT, (WPARAM)
			SendMessage(PES->hWnd, WM_GETFONT, 0, 0), 0);

	NewPES->style = newstyle;
	NewPES->hWnd = hNewWnd;
	SendMessage(hNewWnd, EM_LIMITTEXT, SendMessage(PES->hWnd, EM_GETLIMITTEXT, 0, 0), 0);
	InitExEdit(NewPES);

	// eLXg̈ڐA
	if ( IsTrue(OpenEditText(PES, &ets, 0)) ){
		SetWindowText(hNewWnd, ets.text);
		CloseEditText(&ets);
	}else{
		DestroyWindow(hNewWnd);
		HeapFree(DLLheap, 0, (void*)NewPES);
		return; // s
	}

	// g@\悤ɍŏIݒ
	SendMessage(hNewWnd, EM_SETMODIFY,
			SendMessage(PES->hWnd, EM_GETMODIFY, 0, 0), 0);
	NewPES->hOldED = (WNDPROC)
			SetWindowLongPtr(hNewWnd, GWLP_WNDPROC, (LONG_PTR)EDsHell);

	ShowWindow(hNewWnd, SW_SHOW);

	// Windowj
	PostMessage(PES->hWnd, WM_PPXCOMMAND, KE_scrapwindow, 0);
}

#if 0
void EditKeyCommand(PPxEDSTRUCT *PES, const TCHAR *param) // *key
{
	TCHAR buf[CMDLINESIZE];
	const TCHAR *ptr;
	int key;

	for ( ;; ){
		if ( GetCommandParameter(&param, buf, TSIZEOF(buf)) == 0 ) return;
		if ( tstrcmp(buf, "remove") == 0 ){
			RemoveCharKey(PES->hWnd);
			return;
		}
		ptr = buf;
		key = GetKeyCode(&ptr);
		if ( key > 0 ) {
			if ( key == K_cr ) key = '\n';
			if ( key & K_v ) {
				CallWindowProc(PES->hOldED, PES->hWnd, WM_KEYDOWN, key & 0xff, 0);
				CallWindowProc(PES->hOldED, PES->hWnd, WM_KEYUP, key & 0xff, B30 | B31);
			}else{
				CallWindowProc(PES->hOldED, PES->hWnd, WM_CHAR, key & 0xff, 0);
			}
		}
	}
}
#endif
/*
void EditColorCommand(PPxEDSTRUCT *PES, const TCHAR *param) // *color
{
	int mode = 3;
	TCHAR buf[CMDLINESIZE]

	if ( GetCommandParameter(&param, buf, TSIZEOF(buf)) == 0 ) return;
	if ( tstrcmp(buf, T("cursor")) == 0 ){
		mode = 1;
	}else if ( tstrcmp(buf, T("back")) == 0 ){
		mode = 2;
	}
	if ( mode & 1 ){ // cursor color
		clr = (*param > ' ') ? GetColor(&param, TRUE) : C_AUTO;
	}
}
*/
void EditSetModeCommand(PPxEDSTRUCT *PES, const TCHAR *param) // *editmode
{
	TCHAR buf[CMDLINESIZE], code, *more;
	EDITMODESTRUCT ems = {EDITMODESTRUCT_DEFAULT};

	for ( ;; ){
		code = GetOptionParameter(&param, buf, &more);
		if ( code == '\0' ) break;
		if ( code == '-' ){
			if ( IsTrue(EditModeParam(&ems, buf + 1, more)) ){
				if ( ems.codepage > 0 ) PES->CharCP = ems.codepage;
				if ( ems.crcode >= 0 ) PES->CrCode = ems.crcode;
				if ( ems.tabwidth >= 0 ){
					PPeSetTab(PES, ems.tabwidth);
					ems.tabwidth = -1;
				}
			}else if ( !tstrcmp(buf + 1, T("LEAVECANCEL")) ){
				SendMessage(GetParent(PES->hWnd), WM_PPXCOMMAND, KE_setLeaveCancel, 1);
			}else if ( !tstrcmp(buf + 1, T("LINEBREAK")) ){
				if ( SkipSpace((const TCHAR **)&more) < ' ' ){
					ChangeLineBreak(PES, LineBreak_TOGGLE);
				}else if ( *more == 'c' ){
					ChangeLineBreak(PES, LineBreak_CHAR);
//				}else if ( *more == 'w' ){
//					ChangeLineBreak(PES, LineBreak_WORD);
				}else{
					ChangeLineBreak(PES,
							((*more == 'o') && (*(more + 1) == 'f')) ?
							LineBreak_NOWRAP : LineBreak_CHAR);
				}
			}else if ( !tstrcmp(buf + 1, T("TABKEY")) ){
				setflag(PES->flags, PPXEDIT_TABCOMP);
				if ( (*more == 'o') && (*(more + 1) == 'f') ){
					resetflag(PES->flags, PPXEDIT_TABCOMP);
				}
			}else if ( !tstrcmp(buf + 1, T("ALLKEY")) ){
				setflag(PES->flags, PPXEDIT_WANTALLKEY);
				if ( (*more == 'o') && (*(more + 1) == 'f') ){
					resetflag(PES->flags, PPXEDIT_WANTALLKEY);
				}
			}else if ( !tstrcmp(buf + 1, T("MODIFY")) ){
				switch ( SkipSpace((const TCHAR **)&more) ){
					case 'q': // query
						resetflag(PES->flags, PPXEDIT_DISABLE_CHECKSAVE);
						break;

					case 's':
						if ( more[1] == 'a' ){ // save
							setflag(PES->flags, PPXEDIT_DISABLE_CHECKSAVE | PPXEDIT_SAVE_BYCLOSE);
						}else{ // silent / save
							setflag(PES->flags, PPXEDIT_DISABLE_CHECKSAVE);
						}
						break;

					case 'w': // write
						if ( PES->style & ES_READONLY ){
							SendMessage(PES->hWnd, EM_SETREADONLY, FALSE, 0);
							resetflag(PES->style, ES_READONLY);
						}
						break;

					case 'r': // readonly
						if ( !(PES->style & ES_READONLY) ){
							SendMessage(PES->hWnd, EM_SETREADONLY, TRUE, 0);
							setflag(PES->style, ES_READONLY);
						}
						break;

					case 'c': // clear
						XEditClearModify(PES);
						break;

					default: // modify
						XEditSetModify(PES);
				}
			}else if ( !tstrcmp( buf + 1, T("HISTORY")) ){
				if ( SetHistorySettings(PES, more) ){
					SendMessage(GetParent(PES->hWnd), WM_PPXCOMMAND, KE_setWType, (LPARAM)PES->list.WhistID );
				}else{
					break;
				}
			}else{
				XMessage(PES->hWnd, NULL, XM_GrERRld, MES_EUOP, buf);
			}
			continue;
		}
		if ( SetHistorySettings(PES, buf) ){
			SendMessage(GetParent(PES->hWnd), WM_PPXCOMMAND, KE_setWType, (LPARAM)PES->list.WhistID );
		}else{
			break;
		}
	}
}

void GetCursorLocate(PPxEDSTRUCT *PES, DWORD *start, DWORD *end)
{
	ECURSOR cursor = {0, 0};

#ifdef UNICODE
	SendMessage(PES->hWnd, EM_GETSEL, (WPARAM)&cursor.start, (LPARAM)&cursor.end);
#else
	EditTextStruct ets;

	if ( (xpbug < 0) && OpenEditText(PES, &ets, 0) ){
		GetEditSel(PES->hWnd, ets.text, &cursor);
		CloseEditText(&ets);
	}else{
		SendMessage(PES->hWnd, EM_GETSEL, (WPARAM)&cursor.start, (LPARAM)&cursor.end);
	}
#endif
	if ( start != NULL ) *start = cursor.start;
	if ( end != NULL ) *end = cursor.end;
}

ERRORCODE EditPPeKeyCommand(PPxEDSTRUCT *PES, DWORD key)
{
	PPECOMMANDPARAM param;
	ERRORCODE result;

	param.key = (WORD)(DWORD)key;
	param.repeat = 0;

	result = PPedCommand(PES, &param);
	if ( (result == ERROR_INVALID_FUNCTION) &&
		 ((key & (K_v | K_ex | K_internal)) == K_v) ) { // s̉zL[H
		CallWindowProc(PES->hOldED, PES->hWnd, WM_KEYDOWN, key & 0xff, 0);
		CallWindowProc(PES->hOldED, PES->hWnd, WM_KEYUP, key & 0xff, B30 | B31);
	}
	return result;
}

// sҏWɎgp
DWORD_PTR USECDECL EditInfoFunc(PPXAPPINFO *info, DWORD cmdID, PPXAPPINFOUNION *uptr)
{
	PPxEDSTRUCT *PES;

	PES = ((EDITMODULEINFOSTRUCT *)info)->PES;
	switch (cmdID){
		case PPXCMDID_PPXCOMMAD:
			EditPPeKeyCommand(PES, uptr->key);
			return 0;

		case PPXCMDID_REQUIREKEYHOOK:
			PES->KeyHookEntry = FUNCCAST(CALLBACKMODULEENTRY, uptr);
			break;

		case PPXCMDID_POPUPPOS:
			GetPPePopupPositon(PES, (POINT *)uptr);
			break;

		case PPXCMDID_SETPOPLINE:
			if ( *uptr->str ){
				SetMessageForEdit(PES->hWnd, uptr->str);
			}else{
				SetMessageForEdit(PES->hWnd, NULL);
			}
			break;

		case PPXCMDID_CSRX:
			GetCursorLocate(PES, &uptr->num, NULL);
			break;

		case PPXCMDID_CSRY:
			GetCursorLocate(PES, NULL, &uptr->num);
			break;

		case PPXCMDID_CSRLOCATE:
			GetCursorLocate(PES, &uptr->nums[0], &uptr->nums[1]);
			uptr->nums[2] = uptr->nums[3] = 0;
			break;

		case PPXCMDID_CSRSETLOCATE: {
			int wp, lp;
			wp = uptr->nums[0];
			if ( wp < 0 ) wp = EC_LAST;
			lp = uptr->nums[1];
			if ( lp < 0 ){
				lp = (lp == -2) ? wp : EC_LAST;
			}
			SendMessage(PES->hWnd, EM_SETSEL, (WPARAM)uptr->nums[0], (LPARAM)lp );
			break;
		}

		case PPXCMDID_CSRRECT:
			GetPPePopupPositon(PES, (POINT *)uptr);
			uptr->nums[2] = 1;
			uptr->nums[3] = PES->fontY;
			break;

		case PPXCMDID_GETREQHWND:
			if ( uptr != NULL ){
				switch ( uptr->str[0] ){
					case '\0':
						return (DWORD_PTR)PES->hWnd;

					case 'F':
						return (DWORD_PTR)PES->FloatBar.hWnd;

					case 'L':
						return (uptr->str[1] == 'S') ? (DWORD_PTR)PES->list.hSubWnd : (DWORD_PTR)PES->list.hWnd;
					case 'P':
						if ( (PES->info == NULL) || (PES->info->Function == NULL) ) return (DWORD_PTR)NULL;
						return PPxInfoFunc(PES->info, PPXCMDID_GETREQHWND, (TCHAR *)(uptr->str + 1) );
					case 'T':
						return (DWORD_PTR)PES->hTreeWnd;
				}
			}
			return (DWORD_PTR)NULL;

		case PPXCMDID_MOVECSR:
			return EditCursorCommand(PES, uptr);

		case PPXCMDID_GETCONTROLVARIABLESTRUCT:
			return (DWORD_PTR)&PES->LocalStringValue;

		case PPXCMDID_FUNCTION:
			if ( !tstrcmp(uptr->funcparam.param, T("EDITPROP")) ){
				EditGetPropFunction(PES, &uptr->funcparam);
				return PPXA_NO_ERROR;
			}
			if ( !tstrcmp(uptr->funcparam.param, T("CURSORTEXT")) ){
				CursorTextFunction(PES, &uptr->funcparam);
				return PPXA_NO_ERROR;
			}
			if ( !tstrcmp(uptr->funcparam.param, T("EDITTEXT")) ){
				int len;
				len = Edit_GetWindowTextLength(PES);
				if ( len >= CMDLINESIZE ){
					TCHAR *longbuf;
					longbuf = HeapAlloc(ProcHeap, 0, TSTROFF(len + 1));
					if ( longbuf != NULL ){
						uptr->funcparam.dest = longbuf;
					}else{
						len = CMDLINESIZE - 1;
					}
				}
				Edit_GetWindowText(PES, uptr->funcparam.dest, len + 1);
				uptr->funcparam.dest[len] = '\0';
				return PPXA_NO_ERROR;
			}
			if ( (PES->info == NULL) || (PES->info->Function == NULL) ){
				return PPXA_INVALID_FUNCTION;
			}
			return PPxInfoFunc(PES->info, cmdID, uptr);

		case PPXCMDID_COMMAND:{
			const TCHAR *param = uptr->str + tstrlen(uptr->str) + 1;
#if 0
			if ( !tstrcmp(uptr->str, T("KEY")) ){
				EditKeyCommand(PES, param);
				break;
			}
#endif
			if ( !tstrcmp(uptr->str, T("TREE")) ){
				EditTreeCommand(PES, param);
				break;
			}
/*
			if ( !tstrcmp(uptr->str, T("COLOR")) ){
				EditColorCommand(PES, param);
				break;
			}
*/
			if ( !tstrcmp(uptr->str, T("EDITMODE")) ){
				EditSetModeCommand(PES, param);
				break;
			}
			if ( !tstrcmp(uptr->str, T("JUMPLINE")) ){
				EditJumpLineCommand(PES, param);
				break;
			}
			if ( !tstrcmp(uptr->str, T("SETCAPTION")) ){
				SetWindowText(GetParentCaptionWindow(PES->hWnd), param);
				break;
			}
			if ( !tstrcmp(uptr->str, T("COMPLETELIST")) ){
				EditCompleteListCommand(PES, param);
				break;
			}
			if ( !tstrcmp(uptr->str, T("DEFAULTMENU")) ){
				PPeDefaultMenu(PES);
				break;
			}
			if ( !tstrcmp(uptr->str, T("REPLACEFILE")) ){
				OpenFromFile(PES, PPE_OPEN_MODE_CMDOPEN, param);
				break;
			}
			if ( !tstrcmp(uptr->str, T("INSERTFILE")) ){
				OpenFromFile(PES, PPE_OPEN_MODE_CMDINSERT, param);
				break;
			}
			if ( !tstrcmp(uptr->str, T("ZENHAN")) ){
				int mode = -1;
				TCHAR c = *param;

				if ( (c == 'z') || (c == '1') ) mode = 1;
				if ( (c == 'h') || (c == '0') ) mode = 0;
				PPeConvertZenHanMain(PES, PES->hWnd, mode);
				break;
			}
			if ( !tstrcmp(uptr->str, T("FIND")) ){
				PPeFind(PES, param);
				break;
			}
			// default 
		}

		default:
			if ( (LONG_PTR)PES->info < 0x10000 ){
				if ( cmdID <= PPXCMDID_FILL ) *uptr->enums.buffer = '\0';
				return PPXA_INVALID_FUNCTION;
			}
			if ( (PES->info == NULL) || (PES->info->Function == NULL) ){
				return PPXA_INVALID_FUNCTION;
			}
			return PPxInfoFunc(PES->info, cmdID, uptr);
	}
	return PPXA_NO_ERROR;
}

int CallCloseEvent(PPxEDSTRUCT *PES)
{
	EDITMODULEINFOSTRUCT ppxa;
	PPXMODULEPARAM pmp = {NULL};

	ppxa.info.Name = EditInfoName;
	ppxa.info.RegID = PES->info->RegID;
	ppxa.info.Function = (PPXAPPINFOFUNCTION)EditInfoFunc;
	ppxa.info.hWnd = PES->hWnd;
	ppxa.PES = PES;

	return CallModule(&ppxa.info, PPXMEVENT_DESTROY, pmp, NULL);
}

int CallEditKeyHook(PPxEDSTRUCT *PES, WORD key)
{
	PPXMKEYHOOKSTRUCT keyhookinfo;
	PPXMODULEPARAM pmp;
	EDITMODULEINFOSTRUCT ppxa;

	keyhookinfo.key = key;
	pmp.keyhook = &keyhookinfo;
	ppxa.info.Name = EditInfoName;
	ppxa.info.RegID = PES->info->RegID;
	ppxa.info.Function = (PPXAPPINFOFUNCTION)EditInfoFunc;
	ppxa.info.hWnd = PES->hWnd;
	ppxa.PES = PES;

	return CallModule(&ppxa.info, PPXMEVENT_KEYHOOK, pmp, PES->KeyHookEntry);
}

ERRORCODE EditExtractMacro(PPxEDSTRUCT *PES, const TCHAR *param, TCHAR *extract, int flags)
{
	EDITMODULEINFOSTRUCT ppxa;

	ppxa.info.Name = EditInfoName;
	ppxa.info.RegID = PES->info->RegID;
	ppxa.info.Function = (PPXAPPINFOFUNCTION)EditInfoFunc;
	ppxa.info.hWnd = PES->hWnd;
	ppxa.PES = PES;
	return PP_ExtractMacro(ppxa.info.hWnd, &ppxa.info, NULL, param, extract, flags);
}

LRESULT CmdSelText(PPxEDSTRUCT *PES, TCHAR *strbuf)
{
	TEXTSEL ts;
	size_t wordlen;

	if ( SelectEditStrings(PES, &ts, TEXTSEL_ALL) == FALSE ) return NO_ERROR;
	wordlen = tstrlen(ts.word);
	if ( wordlen >= (CMDLINESIZE - 1) ){
		TCHAR *longparam;

		wordlen = (wordlen + 1) * sizeof(TCHAR);
		longparam = HeapAlloc(ProcHeap, 0, wordlen );
		if ( longparam != NULL ) memcpy(longparam, ts.word, wordlen);
		FreeTextselStruct(&ts);
		return (LRESULT)longparam;
	}
	tstrcpy(strbuf, ts.word);
	FreeTextselStruct(&ts);
	return NO_ERROR;
}

HMENU MakePopupMenus(PPXINMENU *menus, DWORD check)
{
	HMENU hMenu;
	TCHAR strbuf[0x200];

	hMenu = CreatePopupMenu();
	while ( menus->key ){
		if ( menus->str != NULL ){
			const TCHAR *str;

			if ( *menus->str == '%' ){
				PP_ExtractMacro(NULL, NULL, NULL, menus->str, strbuf, 0);
				str = strbuf;
			}else{
				str = MessageText(menus->str);
			}

			AppendMenu(hMenu,
					((menus->key == check) ? MF_CHECKED : 0) |
					((menus->key & INMENU_BREAK) ? MF_ES | MF_MENUBARBREAK : MF_ES),
					menus->key & ~INMENU_BREAK, str);
		}else{
			AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
		}
		menus++;
	}
	return hMenu;
}

void GetPPePopupPositon(PPxEDSTRUCT *PES, POINT *pos)
{
	if ( PES->mousepos ){
		GetCursorPos(pos);
	}else{
		GetCaretPos(pos);
		pos->y += PES->fontY;
		ClientToScreen(PES->hWnd, pos);
	}
}

void PPeMenu(PPxEDSTRUCT *PES, PPECOMMANDPARAM *param, PPXINMENU *menus)
{
	POINT pos;
	HMENU popup;
	WORD key;

	GetPPePopupPositon(PES, &pos);
	popup = MakePopupMenus(menus, 0);
	if ( menus == amenu ){
		AppendMenu(popup, MF_EPOP, (UINT_PTR)MakePopupMenus(amenu2, 0), amenu2str);
	}
	if ( menus == f2menu ){
		if ( !(PES->style & ES_AUTOHSCROLL) ){
			CheckMenuItem(popup, KE_2p, MF_BYCOMMAND | MF_CHECKED );
		}
		if ( X_esrx ) CheckMenuItem(popup, KE_2x, MF_BYCOMMAND | MF_CHECKED );
		if ( PES->style & ES_READONLY ) CheckMenuItem(popup, KE_qv, MF_BYCOMMAND | MF_CHECKED );
	}
	key = (WORD)TrackPopupMenu(popup, TPM_TDEFAULT, pos.x, pos.y, 0, PES->hWnd, NULL);
	DestroyMenu(popup);
	if ( key != 0 ){
		param->key = (WORD)(key | K_raw);
		PPedCommand(PES, param);
	}
}

	// ^V
int USEFASTCALL PPePaste(PPxEDSTRUCT *PES)
{
	if ( !(PES->flags & PPXEDIT_TEXTEDIT) && IsTrue(OpenClipboard2(PES->hWnd)) ){
		HGLOBAL hGMem;
		size_t maxlen;
		BOOL dopaste;

		// sҏŴƂ́As / ShellIDlist p\
		dopaste = FALSE;
		maxlen = SendMessage(PES->hWnd, EM_GETLIMITTEXT, 0, 0);
		hGMem = GetClipboardData(CF_TTEXT);
		if ( hGMem != NULL ){
			TCHAR *src, *srcmax, *dest;
			size_t len;
			TCHAR *textp;

			src = GlobalLock(hGMem);
			#pragma warning(suppress: 6011 6387) // GlobalLock ͎sȂƌȂ
			len = tstrlen(src);
			if ( len >= maxlen ) len = maxlen;
			textp = HeapAlloc(DLLheap, 0, TSTROFF(len + 1));
			if ( textp != NULL ){
				srcmax = src + len;
				dest = textp;
				while ( src < srcmax ){
					if ( (*src != '\r') && (*src != '\n') ){
						*dest++ = *src;
					}
					if ( src == srcmax ) break;
					src++;
				}

				if ( (size_t)(dest - textp) < len ){
					*dest = '\0';
					SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)textp);
					dopaste = TRUE;
				}

				HeapFree(DLLheap, 0, textp);
			}
			GlobalUnlock(hGMem);
		}else if ( (hGMem = GetClipboardData(RegisterClipboardFormat(CFSTR_SHELLIDLIST))) != NULL ){
			TCHAR text[CMDLINESIZE];

			GetTextFromCF_SHELLIDLIST(text, CMDLINESIZE, hGMem, FALSE);
			SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)text);
			dopaste = TRUE;
		}
		CloseClipboard();
		if ( IsTrue(dopaste) ) return 0;
	}
	// ƎȂ̂łƂ̏s
	CallWindowProc(PES->hOldED, PES->hWnd, WM_PASTE, 0, 0);
	return 0;
}

		// ^S
int USEFASTCALL PPeSaveFile(PPxEDSTRUCT *PES)
{
	FileSave(PES, EDL_FILEMODE_NODIALOG);
	return 0;
}
		// F12 , ESC-S
int USEFASTCALL PPeSaveAsFile(PPxEDSTRUCT *PES)
{
	FileSave(PES, EDL_FILEMODE_DIALOG);
	return 0;
}

int USEFASTCALL PPePPcListMain(PPxEDSTRUCT *PES, int mincount)
{
	HMENU hMenu;
	int count, id;
	DWORD id2 = 1;
	RECT box;
	TCHAR path[VFPS + 8];

	hMenu = CreatePopupMenu();
	count = GetPPxList(hMenu, GetPPcList_Path, NULL, &id2);
	if ( count >= mincount ){
		GetWindowRect(PES->hWnd, &box);
		id = TrackPopupMenu(hMenu, TPM_TDEFAULT, box.left, box.bottom, 0, PES->hWnd, NULL);
		if ( id ){
			TCHAR *sep;

			path[0] = '\0';
			GetMenuString(hMenu, id, path, TSIZEOF(path), MF_BYCOMMAND);
			if ( PES->flags & PPXEDIT_SINGLEREF ){
				SendMessage(PES->hWnd, EM_SETSEL, 0, EC_LAST);
			}
			sep = tstrchr(path, ':'); // "&A: path"
			if ( sep != NULL ){
				SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)(sep + 2));
			}
		}
	}
	DestroyMenu(hMenu);
	return 0;
}

int USEFASTCALL PPePPcList(PPxEDSTRUCT *PES)
{
	return PPePPcListMain(PES, 1);
}

int USEFASTCALL PPePPcListMin3(PPxEDSTRUCT *PES)
{
	return PPePPcListMain(PES, 3);
}

			// ESC-A
int USEFASTCALL PPeAppendFile(PPxEDSTRUCT *PES)
{
	FileSave(PES, EDL_FILEMODE_APPEND);
	return 0;
}

			// ^O , ESC-O
int USEFASTCALL PPeOpenFileCmd(PPxEDSTRUCT *PES)
{
	FileOpen(PES, PPE_OPEN_MODE_OPEN);
	return 0;
}

// ESC-I
int USEFASTCALL PPeInsertFile(PPxEDSTRUCT *PES)
{
	FileOpen(PES, PPE_OPEN_MODE_INSERT);
	return 0;
}

							// ESC-C
int USEFASTCALL PPeCloseFile(PPxEDSTRUCT *PES)
{
	HWND hWnd = PES->hWnd;

	if ( EdPPxWmCommand(PES, hWnd, KE_closecheck, 0) ){
		SendMessage(hWnd, EM_SETMODIFY, FALSE, 0);
		PostMessage(GetParentCaptionWindow(hWnd), WM_CLOSE, 0, 0);
	}
	return 0;
}
//----------------------------------------------- Tab/Ins ɂt@C⊮
int USEFASTCALL PPeFillMain(PPxEDSTRUCT *PES)
{
	EditTextStruct ets;
	ECURSOR cursor;
	TCHAR *ptr;
	DWORD mode;
	HWND hWnd;

	mode = PES->ED.cmdsearch & CMDSEARCH_MATCHFLAGS;

	if ( OpenEditText(PES, &ets, 0) == FALSE ) return 0;
												// ҏW(S)擾
	hWnd = PES->hWnd;
	GetEditSel(hWnd, ets.text, &cursor);
	SendMessage(hWnd, WM_SETREDRAW, FALSE, 0);
	mode |= ((PES->list.WhistID & PPXH_COMMAND) ?
					CMDSEARCH_CURRENT : CMDSEARCH_OFF) |
			((PES->flags & PPXEDIT_SINGLEREF) ? 0 : CMDSEARCH_MULTI) |
			CMDSEARCH_EDITBOX;

	if ( (PES->list.WhistID & (PPXH_DIR | PPXH_PPCPATH)) &&
		 IsTrue(GetCustDword(T("X_fdir"), TRUE)) ){
		setflag(mode, CMDSEARCH_DIRECTORY);
	}

	ptr = SearchFileIned(&PES->ED, ets.text, &cursor, mode);
	if ( ptr != NULL ){
		size_t len;

		SendMessage(hWnd, EM_SETSEL, cursor.start, cursor.end);
								// SearchFileIned ŉHς
		SendMessage(hWnd, EM_REPLACESEL, 0, (LPARAM)ptr);
		SendMessage(hWnd, EM_SETSEL, 0, 0);	// \Jn␳

		len = tstrlen(ptr);
		if ( len && (*(ptr + len - 1) == '\"') ) len--;
#ifndef UNICODE
		if ( xpbug < 0 ) CaretFixToW(ptr, (DWORD *)&len);
#endif
		SendMessage(hWnd, EM_SETSEL, cursor.start + len, cursor.start + len);
		SendMessage(hWnd, WM_SETREDRAW, TRUE, 0);
		InvalidateRect(hWnd, NULL, FALSE);
		SetMessageForEdit(PES->hWnd, NULL);
	}else{
		SendMessage(hWnd, WM_SETREDRAW, TRUE, 0);
		SetMessageForEdit(PES->hWnd, MES_EENF);
	}
	CloseEditText(&ets);
	return 0;
}

int USEFASTCALL PPeFillInit(PPxEDSTRUCT *PES)
{
	if ( PES->flags & PPXEDIT_LISTCOMP ){
		if ( PES->list.mode >= LIST_FILL ){
			if ( PES->list.ListFocus != LISTU_NOLIST ){
				PES->oldkey2 = 1;
				if ( ListUpDown(PES->hWnd, PES, 1, 0) == FALSE ) return 0;
				return 0;
			}
		}
		FloatList(PES, EDITDIST_NEXT_FILL);
		return 0;
	}
	// ꗗ⊮
	return PPeFillMain(PES);
}

int USEFASTCALL PPeFillIns(PPxEDSTRUCT *PES)
{
	resetflag(PES->ED.cmdsearch, CMDSEARCH_FLOAT);
	return PPeFillInit(PES);
}

int USEFASTCALL PPeTabChar(PPxEDSTRUCT *PES)
{
	if ( !(PES->flags & PPXEDIT_TABCOMP) ) return 1; // TABċ@\
	return 0;
}

int USEFASTCALL PPeShiftTab(PPxEDSTRUCT *PES)
{
	if ( PES->flags & (PPXEDIT_TEXTEDIT | PPXEDIT_LINE_MULTILINE) ) return 1;	// }`Ȃ{TAB
	if ( !(PES->flags & PPXEDIT_TABCOMP) ){
		HWND hWnd = PES->hWnd;

		if ( PES->flags & PPXEDIT_LINE_MULTI ) return 1; // ssҏŴƂ
		SetFocus(GetNextDlgTabItem(GetParentCaptionWindow(hWnd), hWnd, TRUE));
		return 0;
	}
	if ( (PES->list.hWnd != NULL) && (PES->list.ListFocus == LISTU_FOCUSMAIN) ){
		PES->oldkey2 = 1;
		ListUpDown(PES->hWnd, PES, (PES->list.direction >= 0) ? -1 : 1, 0);
		return 0;
	}
	if ( (PES->list.hSubWnd != NULL) && (PES->list.ListFocus == LISTU_FOCUSSUB) ){
		PES->oldkey2 = 1;
		ListUpDown(PES->hWnd, PES, (PES->list.direction >= 0) ? -1 : 1, 0);
		return 0;
	}
	return 0;
}

int USEFASTCALL PPeFillTab(PPxEDSTRUCT *PES)
{
	DWORD X_ltab[2] = Default_X_ltab;

	if ( PES->flags & (PPXEDIT_TEXTEDIT | PPXEDIT_LINE_MULTILINE)){
		if ( PES->flags & PPXEDIT_WANTALLKEY ){
			PostMessage(PES->hWnd, WM_CHAR, (WPARAM)'\t', 0);
		}
		return 1;	// PPeȂ{TAB
	}
	if ( !(PES->flags & PPXEDIT_TABCOMP) ){
		HWND hWnd = PES->hWnd;

		if ( PES->flags & PPXEDIT_LINE_MULTI ) return 1; // ssҏŴƂ
		SetFocus(GetNextDlgTabItem(GetParentCaptionWindow(hWnd), hWnd, FALSE));
		return 0;
	}
	// ⊮
	GetCustData(T("X_ltab"), &X_ltab, sizeof(X_ltab));
	if ( X_ltab[1] == 0 ){
		if ( X_flst_part && (X_ltab[0] < 2) ) X_ltab[0] = 2;
		resetflag(PES->ED.cmdsearch, CMDSEARCH_MATCHFLAGS);
		SetMatchMode(PES, X_ltab[0] );
	}
	return PPeFillInit(PES);
}

int USEFASTCALL DeleteSub(PPxEDSTRUCT *PES, int mode, int key)
{
	TEXTSEL ts;

	if ( SelectEditStrings(PES, &ts, mode) == FALSE ) return 1;
	PushTextStack((key == VK_DELETE) ? (TCHAR)B0 : (TCHAR)0, ts.word);
	CallWindowProc(PES->hOldED, PES->hWnd, WM_KEYDOWN, key, 0);
	if ( (key == VK_DELETE) &&
		 (mode != TEXTSEL_CHAR) &&
		 ( (PES->list.mode >= LIST_FILL) ||
		 ((X_flst_mode >= X_fmode_auto1) &&
		  !(PES->flags & PPXEDIT_NOINCLIST) &&
		  (PES->list.hWnd == NULL))) ){
		KeyStepFill(PES, NULL);
	}
	FreeTextselStruct(&ts);
	return 0;
}

int USEFASTCALL PPeBackSpace(PPxEDSTRUCT *PES)
{
	return DeleteSub(PES, TEXTSEL_BACK, VK_BACK);
}

int USEFASTCALL PPeDeleteBackLine(PPxEDSTRUCT *PES)
{
	return DeleteSub(PES, TEXTSEL_BEFORE, VK_BACK);
}
int USEFASTCALL PPeDeleteBackWord(PPxEDSTRUCT *PES)
{
	TEXTSEL ts;

	if ( SelectEditStrings(PES, &ts, TEXTSEL_BEFOREWORD) == FALSE ) return 1;
	PushTextStack((TCHAR)0, ts.word);
	CallWindowProc(PES->hOldED, PES->hWnd, EM_REPLACESEL, 1, (LPARAM)NilStr);
	FreeTextselStruct(&ts);
	return 0;
}

int USEFASTCALL PPeDeleteAfterLine(PPxEDSTRUCT *PES)
{
	return DeleteSub(PES, TEXTSEL_AFTER, VK_DELETE);
}
int USEFASTCALL PPeDeleteAfterWord(PPxEDSTRUCT *PES)
{
	return DeleteSub(PES, TEXTSEL_WORD, VK_DELETE);
}

int USEFASTCALL PPeDelete(PPxEDSTRUCT *PES)
{
	int result = DeleteSub(PES, TEXTSEL_CHAR, VK_DELETE);

	if ( !( PES->flags & PPXEDIT_TEXTEDIT ) || (PES->list.ListFocus != LISTU_NOLIST) ){
		// X_fmode_autoX ̎⊮@\ẗꗗ\
		if ( (PES->list.mode >= LIST_FILL) ||
			 ((X_flst_mode >= X_fmode_auto1) &&
			  !(PES->flags & PPXEDIT_NOINCLIST) &&
			  (PES->list.hWnd == NULL)) ){
			KeyStepFill(PES, NULL);

		// ⊮⃊Xg̃CN^T[`
		}else if ( PES->style & WS_VSCROLL ){
			ListSearch(PES->hWnd, PES, -1);
		}
	}
	return result;
}

int USEFASTCALL PPeGetFileName(PPxEDSTRUCT *PES)
{
	TCHAR buf[VFPS], path[VFPS];
	PPXCMDENUMSTRUCT work;
	HMODULE hCOMDLG32;
	impGetOpenFileName DGetOpenFileName;
	HWND hWnd = PES->hWnd;
	OPENFILENAME ofile = {sizeof(ofile), NULL, NULL, GetFileExtsStr, NULL, 0, 0,
		NULL, VFPS, NULL, 0, NULL, NULL, OFN_HIDEREADONLY | OFN_SHAREAWARE,
		0, 0, WildCard_All, 0, NULL, NULL OPENFILEEXTDEFINE };

	ofile.lpstrTitle = MessageText(MES_TSFN);
	PPxEnumInfoFunc(PES->info, '1', path, &work);
	hCOMDLG32 = LoadSystemDLL(SYSTEMDLL_COMDLG32);
	if ( hCOMDLG32 == NULL ) return 0;
	GETDLLPROCT(hCOMDLG32, GetOpenFileName);
	if ( DGetOpenFileName == NULL ) return 0;
	tstrcpy(buf, NilStr);  // Ⴆ΁Ad:\\winnt\\*.*
	ofile.hwndOwner = hWnd;
	ofile.lpstrFile = buf;
	ofile.lpstrInitialDir = path;
	if ( !DGetOpenFileName(&ofile) ){
		FreeLibrary(hCOMDLG32);
		return 0;
	}
	FreeLibrary(hCOMDLG32);
	if ( PES->flags & PPXEDIT_SINGLEREF ){
		SendMessage(hWnd, EM_SETSEL, 0, EC_LAST);
	}else{
		DWORD wP, lP;

		SendMessage(hWnd, EM_GETSEL, (WPARAM)&wP, (LPARAM)&lP);
		if ( tstrchr(buf, ' ') != NULL ){ // 󔒂̂ŁAu"|"v|ɑ}
			SendMessage(hWnd, EM_REPLACESEL, 0, (LPARAM)T("\"\""));
			SendMessage(hWnd, EM_SETSEL, wP + 1, wP + 1);
			PostMessage(hWnd, WM_KEYDOWN, VK_RIGHT, 0);
			PostMessage(hWnd, WM_KEYUP, VK_RIGHT, 0);
		}
	}
	SendMessage(hWnd, EM_REPLACESEL, 1, (LPARAM)buf);
	return 0;
}

int USEFASTCALL PPeDuplicate(PPxEDSTRUCT *PES)
{
	EditTextStruct ets;

	if ( IsTrue(OpenEditText(PES, &ets, 0)) ){
		PPEui(PES->hWnd, T("DupText"), ets.text);
		CloseEditText(&ets);
	}
	return 0;
}

			// ^[K][Z] ϊ ----------------------
int USEFASTCALL PPeConvertZenHan(PPxEDSTRUCT *PES)
{
	PPeConvertZenHanMain(PES, PES->hWnd, -1);
	return 0;
}

//----------------------------------------------- ^Q-[U] 召ϊ
int USEFASTCALL PPeConvertCase(PPxEDSTRUCT *PES)
{
	TEXTSEL ts;
	TCHAR *q;
	int f = 0;

	if ( SelectEditStrings(PES, &ts, TEXTSEL_WORD) == FALSE ) return 0;
	for ( q = ts.word ; *q ; q++ ){
		if ( Isalpha(*q) ){
			f = Isupper(*q) ? 1 : 2;
			break;
		}
#ifndef UNICODE
		if ( IskanjiA(*q) ){
			if ( (BYTE)*q == 0x82 ){
				BYTE c;
				c = (BYTE)*(q + 1);
				if ( (c >= 0x60) && (c <= 0x79) ){
					f = 1;
					break;
				}else if ( (c >= 0x81) && (c <= 0x9A) ){
					f = 2;
					break;
				}
			}
			q++;
		}
#endif
	}
	if ( f == 1 ) Strlwr(ts.word);
	if ( f == 2 ) Strupr(ts.word);
	SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)ts.word);
	SendMessage(PES->hWnd, EM_SETSEL, ts.cursororg.start, ts.cursororg.end);
	FreeTextselStruct(&ts);
	return 0;
}

#ifdef UNICODE
	#define DEF_CHAR_CODE_OPT T("-utf16")
#else
	#define DEF_CHAR_CODE_OPT T("-system")
#endif

int USEFASTCALL PPePrintByPPv(PPxEDSTRUCT *PES)
{
	EditTextStruct ets;
	DWORD size;
	TCHAR filename[VFPS], cmd[CMDLINESIZE];

	MakeTempEntry(VFPS, filename, FILE_ATTRIBUTE_NORMAL);

	if ( IsTrue(OpenEditText(PES, &ets, 0)) ){
		HANDLE hFile;

		if ( ets.len == 0 ) return 0;

		hFile = CreateFileL(filename, GENERIC_WRITE,
				FILE_SHARE_WRITE | FILE_SHARE_READ, NULL, OPEN_ALWAYS,
				FILE_ATTRIBUTE_NORMAL, NULL);
		if ( hFile != INVALID_HANDLE_VALUE ){
			WriteFile(hFile, ets.text, TSTROFF(ets.len), &size, NULL);
			CloseHandle(hFile);

			thprintf(cmd, TSIZEOF(cmd), T("%%Os *ppv ") DEF_CHAR_CODE_OPT T(" \"%s\" -k %%%%K\"@^P@Q\""), filename);
			EditExtractMacro(PES, cmd, NULL, 0);
			DeleteFile(filename);
		}
		CloseEditText(&ets);
	}
	return 0;
}

int USEFASTCALL PPeDeleteLine(PPxEDSTRUCT *PES)
{
	HWND hWnd = PES->hWnd;

	if ( PES->flags & PPXEDIT_TEXTEDIT ){
		DWORD line, wP, lP;

#ifndef UNICODE
		if ( xpbug < 0 ) return 0;
#endif
		line = SendMessage(hWnd, EM_LINEFROMCHAR, (WPARAM)-1, 0);
		wP = SendMessage(hWnd, EM_LINEINDEX, (WPARAM)line, 0);
		lP = SendMessage(hWnd, EM_LINEINDEX, (WPARAM)line + 1, 0);
		SendMessage(hWnd, EM_SETSEL, wP, lP);
	}else{
		SendMessage(hWnd, EM_SETSEL, 0, EC_LAST);
	}
	return DeleteSub(PES, TEXTSEL_CHAR, VK_DELETE);
}

int USEFASTCALL PPeUndoChar(PPxEDSTRUCT *PES)
{
	TCHAR mode, buf[0x1000];
	DWORD wP, lP;
	HWND hWnd = PES->hWnd;

	PopTextStack(&mode, buf);
	if ( buf[0] == '\0' ) return 0;

	SendMessage(hWnd, EM_GETSEL, (WPARAM)&wP, (LPARAM)&lP);
	SendMessage(hWnd, EM_SETSEL, wP, wP);
	SendMessage(hWnd, EM_REPLACESEL, 0, (LPARAM)buf);
	if ( !(mode & B0) ){
		lP = tstrlen32(buf);
#ifndef UNICODE
		if ( xpbug < 0 ) CaretFixToW(buf, &lP);
#endif
		wP += lP;
	}
	SendMessage(hWnd, EM_SETSEL, wP, wP);
	return 0;
}

int USEFASTCALL PPeDuplicateLine(PPxEDSTRUCT *PES)
{
	DWORD line, wP, lP, index;
	TCHAR buf[0x6000];
	DWORD len;
	HWND hWnd = PES->hWnd;

	SendMessage(hWnd, EM_GETSEL, (WPARAM)&wP, (LPARAM)&lP);

	*(WORD *)buf = (WORD)TSIZEOF(buf) - 4;
	line = SendMessage(hWnd, EM_LINEFROMCHAR, (WPARAM)-1, 0);
	len = SendMessage(hWnd, EM_GETLINE, (WPARAM)line, (LPARAM)buf);

	if ( PES->flags & PPXEDIT_TEXTEDIT ){
		buf[len++] = '\r';
		buf[len++] = '\n';
	}
	buf[len] = '\0';

	index = SendMessage(hWnd, EM_LINEINDEX, (WPARAM)line + 1, 0);
	SendMessage(hWnd, EM_SETSEL, index, index);
	SendMessage(hWnd, EM_REPLACESEL, 1, (LPARAM)buf);
	SendMessage(hWnd, EM_SETSEL, wP, lP);
	return 0;
}

int USEFASTCALL PPeGetFullPath(PPxEDSTRUCT *PES)
{
	PPXCMD_F fbuf;
	PPXCMDENUMSTRUCT work;

	PPxEnumInfoFunc(PES->info, PPXCMDID_STARTENUM, fbuf.dest, &work);
	fbuf.source = FullPathMacroStr;
	fbuf.dest[0] = '\0';
	Get_F_MacroData(PES->info, &fbuf, &work);
	SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)fbuf.dest);
	PPxEnumInfoFunc(PES->info, PPXCMDID_ENDENUM, fbuf.dest, &work);
	return 0;
}

int USEFASTCALL PPeUnSelect(PPxEDSTRUCT *PES)
{
	DWORD lPos, rPos;
	HWND hWnd = PES->hWnd;

	SendMessage(hWnd, EM_GETSEL, (WPARAM)&lPos, (LPARAM)&rPos);
	if ( lPos == rPos ) return 0; // IĂȂ

	if ( IsEditCursorPos(hWnd, lPos) ){ // J[\H
		rPos = lPos;
	}
	SendMessage(hWnd, EM_SETSEL, (WPARAM)rPos, (LPARAM)rPos);
	return 0;
}

int USEFASTCALL PPeDefaultMenu(PPxEDSTRUCT *PES)
{
	SendMessage(PES->hWnd, WM_RBUTTONDOWN, MK_SHIFT, 0);
	SendMessage(PES->hWnd, WM_RBUTTONUP, MK_SHIFT, 0);
	return 0;
}

const KEYCOMMANDS ppecommands[] = {
	{K_c | K_s | 'A',	PPeUnSelect},

	{K_c | 'O',			PPeOpenFileCmd},
	{K_c | 'S',			PPeSaveFile},
	{K_c | 'U',			PPeUndoChar},
	{K_c | 'V',			PPePaste},

	{K_s | K_c | 'F',	PPeGetFileName},
	{K_s | K_c | 'L',	PPePPcList},
	{K_s | K_c | '3',	PPePPcListMin3},

	{KE_ea,				PPeAppendFile},
	{KE_ei,				PPeInsertFile},
	{KE_ec,				PPeCloseFile},
	{KE_ed,				PPeDuplicate},

	{KE_kp,				PPePrintByPPv},
	{KE_kd,				PPeDuplicateLine},
	{KE_kz,				PPeConvertZenHan},

	{KE_qu,				PPeConvertCase},

	{KE_defmenu,		PPeDefaultMenu},

	{K_tab,				PPeFillTab},
	{K_s | K_tab,		PPeShiftTab},
	{K_ins,				PPeFillIns},
//	{K_s | ' ',			PPeFill},	0.35 p~
	{'\t',				PPeTabChar},
	{K_s | '\t',		PPeTabChar},

	{K_bs,				PPeBackSpace},
	{K_del,				PPeDelete},
	{K_c | K_del,		PPeDeleteAfterWord},
	{K_s | K_del,		PPeDeleteAfterLine},
	{K_s | K_bs,		PPeDeleteBackWord}, // PPeDeleteBackLine {AgȂƂ̂ŁB
	{K_c | 0x7f,		PPeDeleteBackLine }, // PPeDeleteBackWord {
//	{K_c | K_bs,		PPeDeleteBackWord}, // WM_CHAR  0x7f o
	{K_c | 'Y',			PPeDeleteLine},

//	{K_c | 'P',			PPeGetFullPath},
	{K_a | 'P',			PPeGetFullPath},

	{K_F2,				PPeSelectExtension},
	{K_F12,				PPeSaveAsFile},
	{K_c | K_s | 'S',	PPeSaveAsFile},
	{0, NULL}
};

void XEditSetModify(PPxEDSTRUCT *PES)
{
	SendMessage(PES->hWnd, EM_SETMODIFY, TRUE, 0);
	SendMessage(GetParent(PES->hWnd), WM_COMMAND, TMAKEWPARAM(0, EN_UPDATE), 0);
}

void XEditClearModify(PPxEDSTRUCT *PES)
{
	SendMessage(PES->hWnd, EM_SETMODIFY, FALSE, 0);
	SendMessage(GetParent(PES->hWnd), WM_PPXCOMMAND, KE_clearmodify, 0);
}


void InsertTime(PPxEDSTRUCT *PES, WORD key)
{
	TCHAR buf[64];

	GetNowTime(buf, (key == K_F5) && !(PES->flags & PPXEDIT_TEXTEDIT) );
	SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)buf);
}

// s當𒊏oBline ͔j󂳂A񖖔'\0't
PPXDLL int PPXAPI GetWordStrings(TCHAR *line, ECURSOR *cursor, DWORD flags)
{
	int start, bcnt = 0, bk C4701CHECK;
	int tmpb;
	int braket = GWS_BRAKET_NONE;
											// u"vŊĂ邩 --------
											// J[\܂ł́u"v̐߂
	start = cursor->start;
	for ( tmpb = 0 ; tmpb <= start ; tmpb++ ){
		if ( line[tmpb] == '\"' ){
						// J[\(̒O)u"vŁA
						// ̎󔒂̏ꍇ́A擪A
						// ̔fs
			if ( ( (tmpb + 1) >= start) &&
				 ((UTCHAR)line[tmpb + 1] <= (UTCHAR)' ') ){
				if ( bcnt & 1 ) break;	// 聨JEg
			}
			bk = tmpb;
			bcnt++;
		}
	}
	if ( bcnt & 1 ){	// 肠聨O̊o
		TCHAR *p;

		start = bk + 1; // C4701ok, bcnt & 1 Ƃbkݒ
		p = tstrchr(line + start, '\"');
		if ( p == NULL ){
			cursor->end = start + tstrlen32(line + start);
			braket = GWS_BRAKET_LEFT;
		}else{
			cursor->end = p - line;
			braket = GWS_BRAKET_LEFTRIGHT;
		}
	}else{				// 薳Ő󔒂o
		while ( start &&
				((UTCHAR)line[start - 1] > (UTCHAR)' ') ){
			start--;
		}
		while ((UTCHAR)line[cursor->end] > (UTCHAR)' ') (cursor->end)++;

		if ( flags & GWSF_SPLIT_PARAM ){
			TCHAR c;
			TCHAR *p;

			p = line + start;
			c = *p;
			if ( ((c == '-') || (c == '/')) &&
				 Isalpha(line[start + 1]) ){ // -option:param `Ȃ param 
				p += 2;
				for (;;){
					c = *p;
					if ( c == ':' ){
						if ( (cursor->start >= (DWORD)(p - line + 1)) && // J[\ : ȍ~
							 (memcmp((char *)(TCHAR *)(line + start + 1), T("shell"), TSTROFF(5)) != 0) ){ // -shell: ł͂Ȃ
							start = p - line + 1;
						}
						break;
					}
					if ( !Isalpha(c) ) break;
					p++;
				}
			}
		}

	}
	line[cursor->end] = '\0';
	cursor->start = start;
	return braket;
}

void PPeSetCharCode(PPxEDSTRUCT *PES)
{
	POINT pos;
	HMENU hMenu;
	int index, oof = charmenu_other;
	PPXINMENU menus[charmenu_items];
	TCHAR otherstr[20], filename[VFPS];
	UINT cp;

	InitEditCharCode(PES);

	GetPPePopupPositon(PES, &pos);
	memcpy(menus, charmenu, sizeof(charmenu));
	if ( GetACP() != CP__SJIS ){
		menus[charmenu_sjis].key = CP__SJIS;
		menus[oof].key = VTYPE_SYSTEMCP;
		menus[oof].str = charmenustr_lcp;
		oof++;
	}
	cp = (PES->CharCP < VTypeToCPlist_max) ? VTypeToCPlist[PES->CharCP] : PES->CharCP;
	thprintf(otherstr, TSIZEOF(otherstr), T("codepage %d..."), cp);
	menus[oof].key = VTYPE_OTHER;
	menus[oof].str = otherstr;

	hMenu = MakePopupMenus(menus, PES->CharCP);
	index = TrackPopupMenu(hMenu, TPM_TDEFAULT, pos.x, pos.y, 0, PES->hWnd, NULL);
	DestroyMenu(hMenu);
	if ( index != 0 ){
		if ( index == VTYPE_OTHER ){
			const TCHAR *ptr;

			Numer32ToString(otherstr, cp);
			if ( tInput(PES->hWnd, T("codepage"), otherstr, 10, PPXH_NUMBER, PPXH_NUMBER) <= 0 ){
				return;
			}
			ptr = otherstr;
			index = GetIntNumber(&ptr);
			if ( index == 0 ) return;
		}
		PES->CharCP = (UINT)index;
		ThGetString(&PES->LocalStringValue, LSV_filename, filename, VFPS);
		if ( (filename[0] != '\0') && (SendMessage(PES->hWnd, EM_GETMODIFY, 0, 0) == FALSE) && (PMessageBox(PES->hWnd, StrReload, T("PPe"), MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON1) == IDYES) ){ // w肵R[hōēǂݍ
			DWORD memsize;
			TCHAR *textimage = NULL;

			if ( NO_ERROR == LoadFileImage(filename, 0x40, (char **)&textimage, &memsize, NULL) ){
				SendMessage(PES->hWnd, WM_SETREDRAW, FALSE, 0);
				OpenMainFromMem(PES, PPE_OPEN_MODE_OPEN, NULL, textimage, memsize, PES->CharCP);
				HeapFree(ProcHeap, 0, textimage);
				SendMessage(PES->hWnd, WM_SETREDRAW, TRUE, 0);
				InvalidateRect(PES->hWnd, NULL, TRUE);
			}
		}else{
			XEditSetModify(PES);
		}
	}
}

void PPeSetReturnCode(PPxEDSTRUCT *PES)
{
	POINT pos;
	HMENU hMenu;
	int index;

	GetPPePopupPositon(PES, &pos);
	hMenu = MakePopupMenus(returnmenu, PES->CrCode + 1);
	index = TrackPopupMenu(hMenu, TPM_TDEFAULT, pos.x, pos.y, 0, PES->hWnd, NULL);
	DestroyMenu(hMenu);
	if ( index ){
		PES->CrCode = index - 1;
		XEditSetModify(PES);
	}
}

void PPeSetTab(PPxEDSTRUCT *PES, int usetab)
{
	int count = 0;
	UINT tab = 8;
	TCHAR keyword[CUST_NAME_LENGTH], param[VFPS];

	if ( usetab > 0 ){
		tab = usetab;
	}else if ( usetab < 0 ){
		TCHAR filename[VFPS], *entry;

		ThGetString(&PES->LocalStringValue, LSV_filename, filename, VFPS);
		entry = VFSFindLastEntry(filename);
		while( EnumCustTable(count++, T("XV_tab"), keyword, param, sizeof(param)) >= 0){
			FN_REGEXP fn;
			const TCHAR *p;
			int ctab;

			p = keyword;
			ctab = GetIntNumber(&p);
			MakeFN_REGEXP(&fn, param);
			if ( FilenameRegularExpression(entry, &fn) ){
				tab = ctab;
				FreeFN_REGEXP(&fn);
				break;
			}
			FreeFN_REGEXP(&fn);
		}
	}else{ // == 0
		const TCHAR *ptr;

		Numer32ToString(param, PES->tab);
		if ( tInput(PES->hWnd, MES_TTAB, param, 10, PPXH_NUMBER, PPXH_NUMBER) <= 0 ){
			return;
		}
		ptr = param;
		tab = GetIntNumber(&ptr);
		if ( tab <= 0 ) return;
	}
	PES->tab = tab;
	tab <<= 2 ; // _CAO{bNXPʂɕϊ(x4)
	SendMessage(PES->hWnd, EM_SETTABSTOPS, 1, (LPARAM)&tab);
	InvalidateRect(PES->hWnd, NULL, FALSE);
}

void PPeGetString(PPxEDSTRUCT *PES, TCHAR cmd)
{
	TCHAR buf[VFPS];
	PPXCMDENUMSTRUCT work;

	PPxEnumInfoFunc(PES->info, PPXCMDID_STARTENUM, buf, &work);
	if ( PES->info == &PPxDefInfo ){
		switch (cmd){
			case '0': {	// gւ̃pX
				TCHAR *p;

				GetModuleFileName(NULL, buf, MAX_PATH);
				p = FindLastEntryPoint(buf);
				*p = '\0';
				break;
			}

			case '1':
				GetCurrentDirectory(VFPS, buf);
				break;

			case 'C':
			case 'R':
				ThGetString(&PES->LocalStringValue, LSV_filename, buf, VFPS);
				break;

			default:
				PPxEnumInfoFunc(PES->info, cmd, buf, &work);
		}
	}else{
		PPxEnumInfoFunc(PES->info, cmd, buf, &work);
	}

	SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)buf);
	PPxEnumInfoFunc(PES->info, PPXCMDID_ENDENUM, buf, &work);
}

void CloseUpperList(PPxEDSTRUCT *PES)
{
	if ( PES->list.hWnd == NULL ) return;
	if ( PES->list.direction > 0 ) return; // Ȃ̂Ŗ
	if ( SendMessage(PES->list.hWnd, LB_GETCURSEL, 0, 0) >= 0 ) return; // I
	PostMessage(PES->list.hWnd, WM_CLOSE, 0, 0);
}

int CloseLineList(PPxEDSTRUCT *PES)
{
	int result = CLOSELIST_NONE;

	if ( PES->list.hSubWnd != NULL ){
		if ( SendMessage(PES->list.hSubWnd, LB_GETCOUNT, 0, 0) > 0 ){
			result = (PES->list.mode == LIST_MANUAL) ?
					CLOSELIST_MANUALLIST : CLOSELIST_AUTOLIST;
		}
		DestroyWindow(PES->list.hSubWnd);
	}
	if ( PES->list.hWnd != NULL ){
		if ( SendMessage(PES->list.hWnd, LB_GETCOUNT, 0, 0) > 0 ){
			result = (PES->list.mode == LIST_MANUAL) ?
					CLOSELIST_MANUALLIST : CLOSELIST_AUTOLIST;
		}
		DestroyWindow(PES->list.hWnd);
	}
	return result;
}
void USEFASTCALL EnterFix(PPxEDSTRUCT *PES)
{
	TCHAR buf[CMDLINESIZE];

	if ( PES->flags & (PPXEDIT_TEXTEDIT | PPXEDIT_LINE_MULTILINE) ) return;

	if ( (PES->list.WhistID != 0) && (PES->flags & PPXEDIT_WANTENTER) ){
		buf[0] = '\0';
		Edit_GetWindowText(PES, buf, TSIZEOF(buf));
		buf[TSIZEOF(buf) - 1] = '\0';
		WriteHistory(PES->list.WhistID, buf, 0, NULL);
	}
	if ( !(PES->flags & PPXEDIT_WANTALLKEY) ){
		CloseLineList(PES);

		// WM_CHAR  13 (Enter) p
		RemoveCharKey(PES->hWnd);
	}
}

/*-----------------------------------------------------------------------------
	gGfBbg{bNXR}h
-----------------------------------------------------------------------------*/
ERRORCODE PPedExtCommand(PPxEDSTRUCT *PES, PPECOMMANDPARAM *param, const TCHAR *command)
{
	const WORD *ptr;

	if ( param->key == K_cr ) EnterFix(PES);
	// R}hs
	if ( (UTCHAR)command[0] == EXTCMD_CMD ){
		return EditExtractMacro(PES, command + 1, NULL, 0);
	}

	// L[s
	ptr = (WORD *)(((UTCHAR)command[0] == EXTCMD_KEY) ? (command + 1) : command);
	param->key = *ptr;
	if ( param->key == 0 ) return NO_ERROR;

	for( ; *(++ptr) ; param->key = *ptr ){ // ŌȊÕL[s
		if ( PES->AKey != NULL ){
			if ( SendMessage(GetParent(PES->hWnd), WM_PPXCOMMAND, param->key, 0) == ERROR_SEEK ){
				continue;
			}
		}
		EdPPxWmCommand(PES, PES->hWnd, param->key, 0);
//		PPedCommand(PES, param);
	}
	// Ō̃L[s
	if ( PES->AKey != NULL ){
		if ( SendMessage(GetParent(PES->hWnd), WM_PPXCOMMAND, param->key, 0) == ERROR_SEEK ){
			return NO_ERROR;
		}
	}
	EdPPxWmCommand(PES, PES->hWnd, param->key, 0);
	return NO_ERROR;
}

BOOL USEFASTCALL CtrlESCFix(PPxEDSTRUCT *PES)
{
	MSG msg;
	HWND hParentWnd = GetParent(PES->hWnd);

	if ( hParentWnd == NULL ) return FALSE;
	if ( PES->flags & PPXEDIT_WANTENTER ){
		PostMessage(hParentWnd, WM_COMMAND, TMAKELPARAM(0, VK_ESCAPE), (LPARAM)PES->hWnd);
		return TRUE;
	}
	// _CAO ESC Ƃ WM_CHAR P[XΉ
	if ( PeekMessage(&msg, hParentWnd, WM_CLOSE, WM_CLOSE, PM_NOREMOVE) ){
		return TRUE; // IȂ̂Ńj[\Ȃ
	}
	return FALSE;
}

// s=ERROR_INVALID_FUNCTION , sL=NO_ERROR
ERRORCODE PPedCommand(PPxEDSTRUCT *PES, PPECOMMANDPARAM *param)
{
	TCHAR buf[CMDLINESIZE], *bufp;

	PES->oldkey = PES->oldkey2;
	if ( !(param->key & K_raw) ){
		PutKeyCode(buf, param->key);
		if ( ((PES->AKey != NULL) && (NULL != (bufp = GetCustValue(PES->AKey, buf, buf, sizeof(buf)))) ) ||
			 (NULL != (bufp = GetCustValue(StrK_edit, buf, buf, sizeof(buf)))) ){
			ERRORCODE cmdresult;

			cmdresult = PPedExtCommand(PES, param, bufp);
			if ( bufp != buf ) HeapFree(ProcHeap, 0, bufp);
			return cmdresult;
		}
	}
	PES->oldkey2 = 0;
	resetflag(param->key, K_raw);	// GCAXrbg𖳌ɂ
	{
		const KEYCOMMANDS *cms = ppecommands;

		while ( cms->key ){
			if ( cms->key == param->key ) return cms->func(PES);
			cms++;
		}
	}

	switch (param->key) {
case K_c | 'M':			// ^[M]
	if ( PES->flags & (PPXEDIT_TEXTEDIT | PPXEDIT_LINE_MULTILINE) ){
		SendMessage(PES->hWnd, EM_REPLACESEL, 1, (LPARAM)T("\r\n"));
	}else{
		PostMessage(GetParentCaptionWindow(PES->hWnd), WM_COMMAND, TMAKELPARAM(IDOK, BN_CLICKED), 0);
	}
	break;
//-----------------------------------------------
case K_c | 'W':			// ^[W]
	if ( PES->flags & PPXEDIT_TEXTEDIT ){
		PPeCloseFile(PES);
		break;
	}else{
		return ERROR_INVALID_FUNCTION;
	}
//-----------------------------------------------
case K_c | K_s | 'N':			// ^\[N]
	EditExtractMacro(PES, T("*ppe"), NULL, 0);
	break;
//-----------------------------------------------
case K_c | 'N':			// ^[N]
case K_a | 'C':			// &[C]
	PPeGetString(PES, 'C');
	break;
//-----------------------------------------------
case K_c | 'E':			// ^[E]
case K_a | 'X':			// &[X]
	PPeGetString(PES, 'X');
	break;
//-----------------------------------------------
case K_c | 'T':			// ^[T]
case K_a | 'T':			// &[T]
	PPeGetString(PES, 'T');
	break;
//-----------------------------------------------
case K_c | 'R':			// ^[R]
case K_a | 'R':			// &[R]
	PPeGetString(PES, 'R');
	break;
//-----------------------------------------------
case K_c | 'P':	// ^[P]
	if ( PES->flags & PPXEDIT_TEXTEDIT ){
		PPePrintByPPv(PES);
	}else{
		PPeGetFullPath(PES);
	}
	break;
case K_s | K_c | 'P':	// ^\[P]
	EditExtractMacro(PES, T("*replace %M_pjump"), NULL, 0);
	break;
//------------------------------------------------------
case K_c | K_v | '0':	// ^[0]
case K_c | '0':			// ^[0]
case K_a | '0':			// &[0]
	PPeGetString(PES, '0');
	break;
//-----------------------------------------------
case K_c | K_v | '1':	// ^[1]
case K_c | '1':			// ^[1]
case K_a | '1':			// &[1]
case K_a | 'Q':			// &[Q]
	PPeGetString(PES, '1');
	break;
//-----------------------------------------------
case K_c | K_v | '2':	// ^[2]
case K_c | '2':			// ^[2]
case K_a | '2':			// &[2]
case K_a | 'W':			// &[W]
	PPeGetString(PES, '2');
	break;
//-----------------------------------------------
case K_s | K_c | 'D':	// ^\[D] fBNg
	PPeTreeWindow(PES);
	break;
//-----------------------------------------------
case KE_RefButton:		// Qƃ{^
case K_s | K_c | 'I':	// ^\[I] t@C擾
	param->key = (WORD)((PES->flags & PPXEDIT_REFTREE) ?
			(K_raw | K_s | K_c | 'D') : (K_raw | K_s | K_c | 'F'));
	PPedCommand(PES, param);
	break;
//-----------------------------------------------
case K_c | 'A':			// ^[A] ׂĂI
	SendMessage(PES->hWnd, EM_SETSEL, 0, EC_LAST);
	break;
//-----------------------------------------------
case K_s | K_up:		// \[]
	if ( !(PES->flags & PPXEDIT_NOINCLIST) ) return ERROR_INVALID_FUNCTION;
	// K_up 
case K_up:				// []
	PES->oldkey2 = 1;
	if ( ListUpDown(PES->hWnd, PES, -1, param->repeat) == FALSE ) return ERROR_INVALID_FUNCTION;
	break;
//-----------------------------------------------
case K_s | K_dw:		// \[]
	if ( !(PES->flags & PPXEDIT_NOINCLIST) ) return ERROR_INVALID_FUNCTION;
	// K_dw 
case K_dw:				// []
	PES->oldkey2 = 1;
	if ( ListUpDown(PES->hWnd, PES, 1, param->repeat) == FALSE ) return ERROR_INVALID_FUNCTION;
	break;
//-----------------------------------------------
case K_F3:
	SearchStr(PES, EDITDIST_NEXT);
	break;
case K_s | K_F3:
	SearchStr(PES, EDITDIST_BACK);
	break;
case K_F5:
case K_s | K_F5:
	InsertTime(PES, param->key);
	break;
case K_F6:
case K_c | 'F':
	SearchStr(PES, EDITDIST_DIALOG);
	break;
case K_F7:
	PPeReplaceStr(PES);
	break;
case K_s | K_F7:
	if ( PES->findrep == NULL ) break;
	SendMessage(PES->hWnd, EM_REPLACESEL, 1,
			(LPARAM)((PES->findrep->replacetext[0] != '\0') ?
				PES->findrep->replacetext : PES->findrep->findtext));
	break;
//-----------------------------------------------
case K_s | K_Pup:		// \[PgUp]
case K_Pup:				// [PgUp]
	return ListPageUpDown(PES, EDITDIST_BACK, FALSE);
//-----------------------------------------------
case K_s | K_Pdw:		// \[PgDw]
case K_Pdw:				// [PgDw]
	return ListPageUpDown(PES, EDITDIST_NEXT, FALSE);
//-----------------------------------------------
case K_e | K_lf:			// ~[]
	ListHScroll(PES, -1);
	break;
case K_e | K_ri:			// ~[]
	ListHScroll(PES, 1);
	break;
case K_e | K_c | K_lf:		// ~^[]
	ListWidth(PES, -1);
	break;
case K_e | K_c | K_ri:		// ~^[]
	ListWidth(PES, 1);
	break;

case K_a | K_home:			// &[home]
	CenterWindow(GetParentCaptionWindow(PES->hWnd));
	break;
case K_a | K_up:			// &[]
	MoveWindowByKey(GetParentCaptionWindow(PES->hWnd), 0, -1);
	break;
case K_a | K_dw:			// &[]
	MoveWindowByKey(GetParentCaptionWindow(PES->hWnd), 0, 1);
	break;
case K_a | K_lf:			// &[]
	MoveWindowByKey(GetParentCaptionWindow(PES->hWnd), -1, 0);
	break;
case K_a | K_ri:			// &[]
	MoveWindowByKey(GetParentCaptionWindow(PES->hWnd), 1, 0);
	break;
case K_a | K_s | K_up:		// &\[]
	WideWindowByKey(PES, 0, -1);
	break;
case K_a | K_s | K_dw:		// &\[]
	WideWindowByKey(PES, 0, 1);
	break;
case K_a | K_s | K_lf:		// &\[]
	WideWindowByKey(PES, -1, 0);
	break;
case K_a | K_s | K_ri:		// &\[]
	WideWindowByKey(PES, 1, 0);
	break;
//-----------------------------------------------
case K_s | K_esc:	// \[ESC]
	if ( PES->flags & PPXEDIT_TEXTEDIT ){
		HWND hPWnd;

		hPWnd = GetParentCaptionWindow(PES->hWnd);
		ShowWindow(hPWnd, SW_MINIMIZE);
		PostMessage(hPWnd, WM_LBUTTONUP, 0, MAX32);
		PostMessage(hPWnd, WM_RBUTTONUP, 0, MAX32);
	}
	break;
case K_F4:
	if ( PES->list.ListFocus != LISTU_NOLIST ){
		CloseLineList(PES);
		break;
	}else{
		if ( !(PES->style & WS_VSCROLL) ) return ERROR_INVALID_FUNCTION;
		if ( PES->flags & PPXEDIT_TEXTEDIT ){
			if ( PES->list.RhistID == 0 ){
				PES->list.RhistID = PPXH_COMMAND | PPXH_GENERAL | PPXH_DIR | PPXH_PATH | PPXH_SEARCH | PPXH_PPCPATH;
			}
			if ( PES->list.WhistID == 0 ){
				PES->list.WhistID = PPXH_GENERAL;
			}
			KeyStepFill(PES, NULL);
		}else if ( X_flst_mode >= X_fmode_auto2 ){
			KeyStepFill(PES, KeyStepFill_listmode);
		}else{
			FloatList(PES, EDITDIST_NEXT);
		}
	}
	return NO_ERROR;
//------------------------------------
case K_esc:			// [ESC]
	// WM_CHAR  27 (Enter) p
	RemoveCharKey(PES->hWnd);
	if ( !(PES->flags & PPXEDIT_TEXTEDIT) || (PES->flags & PPXEDIT_LINE_MULTILINE) ){ // _CAO
		if ( CloseLineList(PES) != CLOSELIST_NONE ) break;
		if ( PES->flags & PPXEDIT_WANTALLKEY ){
			PostMessage(GetParent(PES->hWnd), WM_COMMAND, IDCANCEL, 0);
			return NO_ERROR;
		}else{
			if ( CtrlESCFix(PES) ) break;
			return ERROR_INVALID_FUNCTION;
		}
	}
	if ( CtrlESCFix(PES) ) break;
//	if ( CloseLineList(PES) != CLOSELIST_NONE ) break;
//	return ERROR_INVALID_FUNCTION;	// ftHgs킹

case K_c | ']':		// ^[]]
case K_F1:			// [F1]
case '\x1b': /*K_esc  WM_CHAR ŕāAj[\łȂ */	// [ESC]
	if ( CloseLineList(PES) != CLOSELIST_NONE ) break;
	if ( param->key == '\x1b' ){
		if ( CtrlESCFix(PES) ) break;
	}
	PPeMenu(PES, param, escmenu);
	break;
//------------------------------------
case K_s | K_F1:
	PPxHelp(PES->hWnd, HELP_CONTEXT, IDH_PPE);
	break;
//------------------------------------
case K_s | K_F2:			// \[F2]
	PPeMenu(PES, param, f2menu);
	break;
//------------------------------------
case K_c | 'K':				// ^[K]
	PPeMenu(PES, param, kmenu);
	break;
//------------------------------------
case K_c | 'Q':				// ^[Q]
	PPeMenu(PES, param, qmenu);
	break;
//------------------------------------
case K_apps:
case K_a | ' ':				// &[ ]
	PPeMenu(PES, param, amenu);
	break;
//------------------------------------
case KE_ee:					// ESC-exec
	buf[0] = '\0';
	if ( tInput(PES->hWnd, MES_TSHL, buf, TSIZEOF(buf),
				PPXH_COMMAND, PPXH_COMMAND) > 0 ){
		EditExtractMacro(PES, buf, NULL, 0);
	}
	break;
//------------------------------------
case KE_er:					// ESC-Run as admin
	if ( Edit_GetWindowText(PES, buf, TSIZEOF(buf)) < (TSIZEOF(buf) - 1) ){
		PPeRunas(PES, buf);
	}
	break;
//------------------------------------
//case KE_eq:		// ESC-Quit
//case KE_ex:		// ESC-X CloseAll
//	PostMessage(GetParentCaptionWindow(PES->hWnd), WM_CLOSE, 0, 0);
//	break;
//-----------------------------------------------
case KE_qj:		// ^Q-J Jump to Line
	if ( PES->flags & PPXEDIT_TEXTEDIT ){
		EditJumpLineCommand(PES, NULL);
	}
	break;
//------------------------------------
case K_home:
	if ( !(PES->flags & PPXEDIT_LINE_MULTI) ) return ERROR_INVALID_FUNCTION;
	// K_c | K_Pup 
case KE_qr:	// Top of text
	if ( SearchStrCheck(PES, EDITDIST_BACK) ) break;
// case K_c | K_home: edit controlčς
	 //  inum[1]ȍ~͎gpȂƑO
	EditCursorCommand(PES, (PPXAPPINFOUNION *)&Cursor_TopOfText);
	break;

//-----------------------------------------------
case K_end:
	if ( !(PES->flags & PPXEDIT_LINE_MULTI) ) return ERROR_INVALID_FUNCTION;
	// K_c | K_Pdw 
	if ( SearchStrCheck(PES, EDITDIST_NEXT) ) break;
case KE_qc:	// Top of text
// case K_c | K_end: edit controlčς
	 //  inum[1]ȍ~͎gpȂƑO
	EditCursorCommand(PES, (PPXAPPINFOUNION *)&Cursor_EndOfText);
	break;

//-----------------------------------------------
case K_c | K_up:	// one logical line up
	if ( SearchStrCheck(PES, EDITDIST_BACK) ) break;
	EditCursorCommand(PES, (PPXAPPINFOUNION *)&Cursor_LogUp);
	break;
case K_c | K_Pup:	// Top of window
	if ( SearchStrCheck(PES, EDITDIST_BACK) ) break;
case KE_qe:	// Top of Window
	if ( PES->style & ES_MULTILINE ){ //  inum[1]ȍ~͎gpȂƑO
		EditCursorCommand(PES, (PPXAPPINFOUNION *)&Cursor_TopOfWindow);
	}
	break;
//-----------------------------------------------
case K_c | K_dw:	// one logical line down
	if ( SearchStrCheck(PES, EDITDIST_NEXT) ) break;
	EditCursorCommand(PES, (PPXAPPINFOUNION *)&Cursor_LogDown);
	break;
case K_c | K_Pdw:	// End of window
	if ( SearchStrCheck(PES, EDITDIST_NEXT) ) break;
case KE_qx:	// End of Window
	if ( PES->style & ES_MULTILINE ){ //  inum[1]ȍ~͎gpȂƑO
		EditCursorCommand(PES, (PPXAPPINFOUNION *)&Cursor_EndOfWindow);
	}
	break;

case KE_2t:	// tabstop
	PPeSetTab(PES, 0);
	break;

case KE_2r:	// Return code
	PPeSetReturnCode(PES);
	break;

case KE_2p:
	ChangeLineBreak(PES, -1);
	break;

case KE_2x:
	X_esrx = !X_esrx;
	break;

case KE_2c:	// Char code
	PPeSetCharCode(PES);
	break;

case KE_qv:	// Q-View mode
	SendMessage(PES->hWnd, EM_SETREADONLY,
			(PES->style & ES_READONLY) ? FALSE : TRUE, 0);
	PES->style = GetWindowLong(PES->hWnd, GWL_STYLE);
	break;

case K_c | K_v | 'V': // RichEdit ͂̃R[h Paste ŝŖ
	break;

case K_c | K_s | 'B':
	RichChangeFontStyle(PES, CFM_BOLD, CFE_BOLD);
	break;
case K_c | K_s | 'R':
	RichChangeFontColor(PES);
	break;
case K_c | K_s | 'U':
	RichChangeFontStyle(PES, CFM_UNDERLINE, CFE_UNDERLINE);
	break;

// case K_c | 'V': // PPePaste ŏς
case K_c | 'C':
	CallWindowProc(PES->hOldED, PES->hWnd, WM_COPY, 0, 0);
	break;
case K_c | 'X':
	CallWindowProc(PES->hOldED, PES->hWnd, WM_CUT, 0, 0);
	break;
case K_c | 'Z':
	CallWindowProc(PES->hOldED, PES->hWnd, WM_UNDO, 0, 0);
	break;

case K_a | K_del: {
	if ( Edit_GetWindowText(PES, buf, TSIZEOF(buf)) < (TSIZEOF(buf) - 1) ){
		if ( DeleteHistory(PES->list.WhistID, buf) || DeleteHistory(PES->list.RhistID, buf) ){
			Edit_SetWindowText(PES, NilStr);
			SetMessageForEdit(PES->hWnd, T("Delete history"));
			if ( PES->list.hWnd != NULL ){
				int index;

				index = SendMessage(PES->list.hWnd, LB_GETCURSEL, 0, 0);
				if ( index >= 0 ){
					SendMessage(PES->list.hWnd, LB_DELETESTRING, index, 0);
					SendMessage(PES->list.hWnd, LB_SETCURSEL, index, 0);
				}
			}
			if ( PES->list.hSubWnd != NULL ){
				int index;

				index = SendMessage(PES->list.hSubWnd, LB_GETCURSEL, 0, 0);
				if ( index >= 0 ){
					SendMessage(PES->list.hSubWnd, LB_DELETESTRING, index, 0);
					SendMessage(PES->list.hSubWnd, LB_SETCURSEL, index, 0);
				}
			}
		}
	}
	break;
}

//----------------------------------------------- Zoom in
case K_c | K_v | VK_ADD:
case K_c | K_v | VK_OEM_PLUS:
	ChangeFontSize(PES, 1);
	break;
//----------------------------------------------- Zoom out
case K_c | K_v | VK_SUBTRACT:
case K_c | K_v | VK_OEM_MINUS:
	ChangeFontSize(PES, -1);
	break;
//----------------------------------------------- Zoom mode change
case K_c | K_v | VK_NUMPAD0:
	ChangeFontSize(PES, -9);
	break;

case K_c | K_s | K_v | VK_ADD:
case K_c | K_s | K_v | VK_OEM_PLUS: // US[=/+] JIS[;/+]
	ChangeOpaqueWindow(PES->hWnd, 1);
	break;
case K_c | K_s | K_v | VK_SUBTRACT:
case K_c | K_s | K_v | VK_OEM_MINUS: // US[-/_] JIS[-/=]
	ChangeOpaqueWindow(PES->hWnd, -1);
	break;

case K_a | K_cr:
	if ( PES->flags & PPXEDIT_LINE_MULTILINE ){
		PostMessage(GetParent(PES->hWnd), WM_COMMAND, IDOK, 0);
	}
	break;

case K_cr:
	if ( PES->flags & PPXEDIT_WANTENTER ){
		PostMessage(GetParent(PES->hWnd), WM_COMMAND, TMAKELPARAM(0, VK_RETURN), (LPARAM)PES->hWnd);
		break;
	}
	// ēx enter ͂A肳(WM_GETDLGCODEUʉ߂Ă̂ŁA_CAO肷邱Ƃ͌_ł͂łȂ)
	if ( CloseLineList(PES) == CLOSELIST_AUTOLIST ){
		if ( !( PES->flags & PPXEDIT_TEXTEDIT ) ){
			PostMessage(PES->hWnd, WM_KEYDOWN, VK_RETURN, 0);
			RemoveCharKey(PES->hWnd); // WM_CHAR  13 (Enter) p
		}
		break;
	}
	if ( PES->flags & PPXEDIT_WANTALLKEY ){
		if ( PES->flags & PPXEDIT_TEXTEDIT ){
			PostMessage(PES->hWnd, WM_CHAR, 13, 0);
		}else{
			PostMessage(GetParent(PES->hWnd), WM_COMMAND, IDOK, 0);
		}
	}
	return ERROR_INVALID_FUNCTION;

	// default 
//-----------------------------------------------
default:
	return PPxCommonCommand(PES->hWnd, 0, param->key);
//-----------------------------------------------
	}
	return NO_ERROR; // sς
}

void FreeEdStruct(PPxEDSTRUCT *PES)
{
	if ( --PES->ref > 0 ) return;
	HeapFree(DLLheap, 0, PES);
}

// LineMulti ́AXN[o[̂܂܎ؗpłȂ̂ŁAWM_NCLBUTTONDOWN ŏ
void LineMulti_VScrollDown(HWND hWnd, int fontY, LPARAM lParam)
{
	POINT pos;

	LPARAMtoPOINT(pos, lParam);
	ScreenToClient(hWnd, &pos);
	EDsHell(hWnd, WM_VSCROLL, ( pos.y <= (fontY / 2) ) ? SB_LINEUP : SB_LINEDOWN, 0);
}

void SetDropFiles(HWND hWnd, HDROP hDrop)
{
	TCHAR name[VFPS];

	DragQueryFile(hDrop, 0, name, TSIZEOF(name));
	DragFinish(hDrop);
	SetWindowText(hWnd, name);
}

// WM_SYSKEYDOWN ŉpL[̏sƂA㑱 WM_SYSCHAR 
// ȂߌxoɑΏ
void SkipAltLetterKeyDef(HWND hWnd)
{
	MSG WndMsg;

	if ( IsTrue(PeekMessage(&WndMsg, hWnd, WM_SYSCHAR, WM_SYSCHAR, PM_NOREMOVE)) ){
		if ( IsalnumA(WndMsg.wParam) ){ // Y WM_SYSCHAR j
			PeekMessage(&WndMsg, hWnd, WM_SYSCHAR, WM_SYSCHAR, PM_REMOVE);
		}
	}
}

void LineExpand(HWND hWnd, PPxEDSTRUCT *PES)
{
	DWORD line, deskline;
	WindowExpandInfoStruct eis;

	line = Edit_SendMessageMsg(PES, EM_GETLINECOUNT);
	if ( PES->caretLY == line ) return;

	eis.hParentWnd = GetParent(hWnd);
	GetDesktopRect(hWnd, &eis.boxDesk);

	deskline = (eis.boxDesk.bottom - eis.boxDesk.top) / PES->fontY;
	if ( deskline < 1 ) deskline = 1;
	if ( deskline > 3 ) deskline--;
	if ( deskline > 20 ) deskline /= 2;
	if ( line > deskline ){
		line = deskline;
		if ( PES->caretLY == line ) return;
	}

	GetWindowRect(hWnd, &eis.boxEdit);
	GetWindowRect(eis.hParentWnd, &eis.boxDialog);

	eis.delta = (line - PES->caretLY) * PES->fontY;
	eis.boxEdit.bottom += -eis.boxEdit.top + eis.delta;

	if ( eis.boxEdit.bottom < (int)PES->fontY ){ // PsȂ̂ŕ␳
		eis.delta += PES->fontY - eis.boxEdit.bottom;
		eis.boxEdit.bottom = PES->fontY;
	}

	PES->caretLY = line;
	EditBoxExpand(PES, &eis);
	InvalidateRect(eis.hParentWnd, NULL, TRUE);
}

LRESULT CharProc(PPxEDSTRUCT *PES, HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	if ( !(PES->flags & PPXEDIT_TEXTEDIT) || (PES->list.ListFocus != LISTU_NOLIST) ){ // sҏWL
		// X_fmode_autoX ̎⊮@\ẗꗗ\
		if ( ( (wParam != '\t') && (wParam != '\xd') && (wParam != '\x1b')) && // TAB/CR/ESCłȂ
				((PES->list.mode >= LIST_FILL) ||
				 ((X_flst_mode >= X_fmode_auto1) &&
				  !(PES->flags & PPXEDIT_NOINCLIST) &&
				  (PES->list.hWnd == NULL)) ) )
		{
			LRESULT lr;

			lr = CallWindowProc(PES->hOldED, hWnd, iMsg, wParam, lParam);
			KeyStepFill(PES, NULL);
			return lr;

		// ⊮⃊Xg̃CN^T[`
		}else if ( PES->style & WS_VSCROLL ){
			int oldlen;
			LRESULT lr;

			if ( wParam == '\t' ) return 1;
			oldlen = Edit_GetWindowTextLength(PES);
			lr = CallWindowProc(PES->hOldED, hWnd, iMsg, wParam, lParam);
			ListSearch(hWnd, PES, oldlen);
			return lr;
		}
	}
	// PPXEDIT_LINECSŔAES_MULTILINE ̂ƂLɂȂĂȂ
	if ( PES->flags & (PPXEDIT_LINECSR | PPXEDIT_LINE_MULTI | PPXEDIT_LINE_MULTILINE) ){
		LRESULT lr = CallWindowProc(PES->hOldED, hWnd, iMsg, wParam, lParam);

		if ( PES->flags & (PPXEDIT_LINE_MULTI | PPXEDIT_LINE_MULTILINE) ){
			LineExpand(hWnd, PES);
		}else{
			LineCursor(PES, iMsg);
		}
		return lr;
	}
	return CallWindowProc(PES->hOldED, hWnd, iMsg, wParam, lParam);
}

/*-----------------------------------------------------------------------------
	gGfBbg{bNXbZ[W
-----------------------------------------------------------------------------*/
LRESULT CALLBACK EDsHell(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	PPxEDSTRUCT *PES;
	PPECOMMANDPARAM cparam;

	PES = (PPxEDSTRUCT *)GetProp(hWnd, StrPPxED);
	if ( PES == NULL ) return DefWindowProc(hWnd, iMsg, wParam, lParam);
	switch (iMsg){
		case WM_CTLCOLORLISTBOX:
			if ( !(ThemeColors.ExtraDrawFlags & (EDF_WINDOW_TEXT | EDF_WINDOW_BACK)) ){
				return DefWindowProc(hWnd, iMsg, wParam, lParam);
			}
			return ControlWindowColor(wParam);

		case WM_NCLBUTTONDOWN:
			if ( (PES->flags & PPXEDIT_LINE_MULTI) && (wParam == HTVSCROLL) ){
				LineMulti_VScrollDown(hWnd, PES->fontY, lParam);
				return 0;
			}
			goto nextproc;

		case WM_IME_NOTIFY:
			// EBhËʒuωƂɒʒm遨
			// XgEBhËʒuύXɗp
			if ( (wParam == IMN_SETCOMPOSITIONWINDOW) &&
				 (PES->list.hWnd != NULL) ){
				PostMessage(hWnd, WM_PPXCOMMAND, KE_changepos, 0);
			}
			goto nextproc;

		case WM_DROPFILES:		// hbvt@C̖O捞
			SetDropFiles(hWnd, (HDROP)wParam);
			goto nextproc;

		case WM_KILLFOCUS:
			if ( PES->FloatBar.hWnd != NULL ) DestroyWindow(PES->FloatBar.hWnd);
		// WM_LBUTTONDOWN ֑
		case WM_LBUTTONDOWN:
									// qXgȂǂ̃XgȂ
			if ((PES->list.hWnd != NULL) && ((HWND)wParam != PES->list.hWnd) ){
				PostMessage(PES->list.hWnd, WM_CLOSE, 0, 0);
			}
			if ((PES->list.hSubWnd != NULL) && ((HWND)wParam != PES->list.hSubWnd) ){
				PostMessage(PES->list.hSubWnd, WM_CLOSE, 0, 0);
			}
			break; // line cursor L

		case WM_MOUSEWHEEL:
			if ( wParam & MK_CONTROL ){
				if ( wParam & MK_SHIFT ){
					ChangeOpaqueWindow(hWnd, (wParam & B31) ? -1 : 1);
				}else{
					ChangeFontSize(PES, (wParam & B31) ? -1 : 1);
				}
				return 0;
			}

			if ( PES->flags & PPXEDIT_COMBOBOX ){
				return SendMessage(GetParent(hWnd), WM_MOUSEWHEEL, wParam, lParam);
			}

			if ( PES->list.ListFocus != LISTU_NOLIST ){
				return SendMessage( (PES->list.ListFocus == LISTU_FOCUSSUB) ?
					PES->list.hSubWnd : PES->list.hWnd,
					WM_MOUSEWHEEL, wParam, lParam);
			}

			if ( !(PES->flags & PPXEDIT_TEXTEDIT) || (PES->list.ListFocus != LISTU_NOLIST) ){ // qXgQ
				if ( HISHORTINT(wParam) >= 0 ){
					cparam.key = K_up;
				}else{
					cparam.key = K_dw;
				}
				cparam.repeat = 0;
				PES->mousepos = TRUE;
				PPedCommand(PES, &cparam);
				return 0;
			}
			goto nextproc;

		case WM_MOUSEACTIVATE:
			if ( PES->flags & PPXEDIT_PANEMODE ){ //vANeBuo
				// ANeBû
				if ( GetFocus() == NULL ){
					// ANeBũNbNo𖳌ɂ
					return MA_ACTIVATEANDEAT; // ANeBu & }EX bZ[Wp
				}else{
					return MA_ACTIVATE; // ANeBup
				}
			}
			goto nextproc;

		case WM_COMMAND:
			if ( HIWORD(wParam) == LBN_SELCHANGE ){	// XgIH
				ListSelect(PES, (HWND)lParam);
			}
			goto nextproc;

		case WM_MENUCHAR:
		case WM_MENUSELECT:
		case WM_MENUDRAG:
		case WM_MENURBUTTONUP:
			return PPxMenuProc(hWnd, iMsg, wParam, lParam);

		case WM_LBUTTONUP:
			if ( PES->FloatBar.hWnd == NULL ){
				InitFloatBar(PES, LOSHORTINT(lParam));
			}
			goto nextproc;

		case WM_RBUTTONUP:
			// ctrl/shiftLȂ猳̏s
			if ( (wParam & (MK_SHIFT | MK_CONTROL)) != 0 ) goto nextproc;
			cparam.key = K_a | ' ';
			cparam.repeat = 0;
			PES->mousepos = TRUE;
			PPedCommand(PES, &cparam);
			return 0;

		case WM_SYSKEYDOWN:
														// Alt n̎gp֎~
			if ( !(PES->flags & PPXEDIT_USEALT) &&
				 ((WORD)wParam >= '0') &&
				 ((WORD)wParam <= VK_DIVIDE)){
				goto nextproc;
			}
			// WM_KEYDOWN 
		case WM_KEYDOWN:
			if ( PES->list.flags & LISTFLAG_DISABLE ) goto nextproc;

			cparam.key = (WORD)(wParam | GetShiftKey() | K_v);
			cparam.repeat = lParam & B30;
			PES->mousepos = FALSE;

#ifndef WINEGCC
			/*  WM_GETDLGCODE ̏ŁAXgȂ WM_SYSCHAR ȂA
			 Xg WM_SYSCHAR 邽߁A */
			if ( (cparam.key & K_a) && IsalnumA(cparam.key) &&
				 !( PES->flags & PPXEDIT_TEXTEDIT ) &&
				 (PES->list.ListFocus == LISTU_NOLIST) ){
				resetflag(cparam.key, K_v);
			}
#endif
			if ( PES->flags & PPXEDIT_WANTALLKEY ){
				if ( ((wParam == VK_RETURN) &&
					  ((PES->flags & (PPXEDIT_WANTENTER | PPXEDIT_TEXTEDIT)) != (PPXEDIT_WANTENTER | PPXEDIT_TEXTEDIT)) ) ||
					(wParam == VK_TAB) || (wParam == VK_ESCAPE) ){
					RemoveCharKey(PES->hWnd); // WM_CHAR ̊eL[p
				}
			}

			if ( PES->KeyHookEntry != NULL ){
				if ( CallEditKeyHook(PES, cparam.key) != PPXMRESULT_SKIP ){
					return 0;
				}
			}

			if ( PPedCommand(PES, &cparam) != ERROR_INVALID_FUNCTION ){
				if ( (cparam.key & K_a) &&
					 (T_CHRTYPE[(unsigned char)(cparam.key)] & (T_IS_DIG | T_IS_UPP)) ){
					SkipAltLetterKeyDef(hWnd);
				}
				return 0;
			}

			if ( wParam == VK_MENU ){ // [ALT] ̓j[ڍs֎~
				if ( GetCustDword(T("X_alt"), 1) ) return 0;
			}
			break; // line cursor L

		#ifdef UNICODE
		case WM_IME_CHAR:
			#ifdef UNICODE
				if ( PES->list.flags & LISTFLAG_DISABLE ) goto nextproc;
				// WM_CHAR  iMsg ɂ WM_CHAR ʉ߂Ă܂
				return CharProc(PES, hWnd, WM_CHAR, wParam, lParam);
			#else // Win9x, WinNTŊ͂łȂ߁Ax~
				unsigned char charcode;

				if ( PES->list.flags & LISTFLAG_DISABLE ) goto nextproc;
				charcode = (BYTE)((wParam >> 8) & 0xff);
				if ( charcode != '\0' ){
					CharProc(PES, hWnd, WM_CHAR, charcode, lParam);
				}
				return CharProc(PES, hWnd, WM_CHAR, wParam & 0xff, lParam);
			#endif
		#endif

		case WM_SYSCHAR:
			if ( !(PES->flags & PPXEDIT_USEALT) ) goto nextproc; // Alt n̎gp֎~
		//	WM_CHAR 

		case WM_CHAR:
			if ( PES->list.flags & LISTFLAG_DISABLE ) goto nextproc;
			if ( (WORD)wParam < 0x80 ){ // pȂJX^}CY
				cparam.key = FixCharKeycode((WORD)wParam);
				cparam.repeat = lParam & B30;
				PES->mousepos = FALSE;

				if ( PES->KeyHookEntry != NULL ){
					if ( CallEditKeyHook(PES, cparam.key) != PPXMRESULT_SKIP ){
						return 0;
					}
				}
				if ( PPedCommand(PES, &cparam) != ERROR_INVALID_FUNCTION ){
					return 0;
				}
			}
			return CharProc(PES, hWnd, iMsg, wParam, lParam);

		case WM_CLOSE:
			setflag(PES->list.flags, LISTFLAG_DISABLE);
			CancelListThread(PES);
			return CallWindowProc(PES->hOldED, hWnd, iMsg, wParam, lParam);

		case WM_DESTROY: {
			WNDPROC hOldED;

			setflag(PES->list.flags, LISTFLAG_DISABLE);
			CancelListThread(PES);

			if ( PES->flags & PPXEDIT_WANTEVENT ){
				if ( IsExistCustTable(StrK_edit, StrCLOSEEVENT) ||
					 ((PES->AKey != NULL) && IsExistCustTable(PES->AKey, StrCLOSEEVENT)) ){
					EditPPeKeyCommand(PES, K_E_CLOSE);
				}
				CallCloseEvent(PES);
			}

			if ( PES->list.ListFocus != LISTU_NOLIST ) CloseLineList(PES);
			FreeBackupText(PES);

			SearchFileIned(&PES->ED, NilStrNC, NULL, 0);
			hOldED = PES->hOldED;

			FreeFillTextFile(&PES->list.filltext_user);
			if ( PES->findrep != NULL ){
				HeapFree(ProcHeap, 0, PES->findrep);
			}
			if ( PES->FloatBar.hWnd != NULL ){
				DestroyWindow(PES->FloatBar.hWnd);
			}
			ThFree(&PES->LocalStringValue);
			SetWindowLongPtr(hWnd, GWLP_WNDPROC, (LONG_PTR)hOldED );
			RemoveProp(hWnd, StrPPxED);
			PES->info = &DummyPPxAppInfo;
			FreeEdStruct(PES);
			return CallWindowProc(hOldED, hWnd, iMsg, wParam, lParam);
		}

		case WM_SETFONT:
			GetHeight(PES, (HFONT)wParam);
			goto nextproc;

		case WM_GETDLGCODE: {
			LRESULT retcode;

			if ( PES->list.ListFocus != LISTU_NOLIST ){
				return DLGC_WANTALLKEYS;
			}
			retcode = 0;
			if ( PES->flags & PPXEDIT_TABCOMP ) retcode = DLGC_WANTTAB;
			if ( PES->flags & PPXEDIT_WANTALLKEY ){
				if ( PES->flags & PPXEDIT_LINE_MULTILINE ){
					return DLGC_WANTALLKEYS;
				}
				retcode = DLGC_WANTALLKEYS | DLGC_BUTTON;
			}
			return CallWindowProc(PES->hOldED, hWnd, iMsg, wParam, lParam) | retcode;
		}

		case WM_VSCROLL:
			if ( PES->flags & PPXEDIT_TEXTEDIT ) goto nextproc;
			SetFocus(hWnd);
			switch ( LOWORD(wParam) ){
				case SB_LINEUP:
					if ( X_flst_mode >= X_fmode_auto2 ){
						if ( PES->list.ListFocus != LISTU_NOLIST ){
							CloseLineList(PES);
						}else{
							KeyStepFill(PES, KeyStepFill_listmode);
						}
					}else{
						FloatList(PES, EDITDIST_BACK);
					}
					break;

				case SB_LINEDOWN:
					FloatList(PES, EDITDIST_NEXT);
					break;

				// default:
			}
			return 0;

		case WM_ENABLE:
			if ( (BOOL)wParam == FALSE ) ClosePPeTreeWindow(PES);
			goto nextproc;

		case WM_GESTURE:
			WMGestureEdit(hWnd, wParam/*, lParam*/);
			goto nextproc;

		case WM_COPYDATA:
			return PPWmCopyData(PES->info, (COPYDATASTRUCT *)lParam);

		default:
			if ( iMsg == WM_PPXCOMMAND ){
				LRESULT result;

				result = EdPPxWmCommand(PES, hWnd, wParam, lParam);
				if ( result != (LRESULT)MAX32 ) return result;
				goto nextproc;
			}else if ( iMsg == ReplaceDialogMessage ){
				PPeReplaceStrCommand(PES, (FINDREPLACE *)lParam);
				goto nextproc;
			}
			break;
	}
	// PPXEDIT_LINECSŔAES_MULTILINE ̂ƂLɂȂĂȂ
	if ( (PES->flags & (PPXEDIT_LINECSR | PPXEDIT_LINE_MULTI | PPXEDIT_LINE_MULTILINE)) &&
		// Aedit message  wm_paint ̎Ɏgp
		 ( ((iMsg >= EM_SETSEL) && (iMsg <= EM_SETREADONLY)) ||
		   (iMsg == WM_PAINT) ||
		   (iMsg == WM_KEYDOWN) ||
		   (iMsg == WM_LBUTTONDOWN) ) ){
		LRESULT lr = CallWindowProc(PES->hOldED, hWnd, iMsg, wParam, lParam);

		if ( PES->flags & (PPXEDIT_LINE_MULTI | PPXEDIT_LINE_MULTILINE) ){
			LineExpand(hWnd, PES);
		}else{
			LineCursor(PES, iMsg);
		}
		return lr;
	}
nextproc:
	return CallWindowProc(PES->hOldED, hWnd, iMsg, wParam, lParam);
}

void InsertAndSelect(HWND hWnd, const TCHAR *text, BOOL spacebraket)
{
	DWORD wP, lP;

	SendMessage(hWnd, EM_GETSEL, (WPARAM)&wP, (LPARAM)&lP);
	lP = tstrlen32(text);
#ifndef UNICODE
	if ( xpbug < 0 ) CaretFixToW(text, &lP);
#endif
	if ( spacebraket && (tstrchr(text, ' ') != NULL) ){
		SendMessage(hWnd, EM_REPLACESEL, 0, (LPARAM)T("\"\""));
		SendMessage(hWnd, EM_SETSEL, wP + 1, wP + 1);
		lP += 2;
	}
	SendMessage(hWnd, EM_REPLACESEL, 1, (LPARAM)text);
	SendMessage(hWnd, EM_SETSEL, wP, wP + lP);
}

// ߂l MAX32 ̂Ƃ́AȂɂȂBCJ[\L
LRESULT EdPPxWmCommand(PPxEDSTRUCT *PES, HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	switch ( LOWORD(wParam) ){
		case KE_insertsel: // *insertsel {
			InsertAndSelect(hWnd, (const TCHAR *)lParam, FALSE);
			break;

		case KE_insert: // *insert {
			SendMessage(hWnd, EM_REPLACESEL, 1, lParam);
			break;

		case KE_replace:
			Edit_SetWindowText(PES, (TCHAR *)lParam);
			Edit_SendMessage(PES, EM_SETSEL, 0, EC_LAST);
			break;

		case KE_closecheck:
			if ( (PES->flags & PPXEDIT_DISABLE_CHECKSAVE) ||
				 (Edit_SendMessageMsg(PES, EM_GETMODIFY) == FALSE) ){
				if ( (PES->flags & (PPXEDIT_SAVE_BYCLOSE | PPXEDIT_DISABLE_CHECKSAVE)) == (PPXEDIT_SAVE_BYCLOSE | PPXEDIT_DISABLE_CHECKSAVE) ){ // ۑ
					if ( FileSave(PES, EDL_FILEMODE_NODIALOG) == FALSE ){
						break; // ۑŝŒ~
					}
				}
				return 1; //  || ύX̂܂܏I
			}else{
				int result;

				result = PMessageBox(hWnd, MES_QSAV, T("PPe"),
					MB_ICONQUESTION | MB_YESNOCANCEL | MB_DEFBUTTON1);
				if ( result == IDYES ){
					if ( FileSave(PES, EDL_FILEMODE_NODIALOG) ) return 1;
				}else if ( result == IDNO ){
					return 1;
				}
			}
			return 0;

		case KE_openfile:
			return OpenFromFile(PES, PPE_OPEN_MODE_OPEN, (const TCHAR *)lParam);

		case KE_opennewfile:
			return OpenFromFile(PES, PPE_OPEN_MODE_OPENNEW, (const TCHAR *)lParam);
		case KE_excmdopen:
			return OpenFromFile(PES, HIWORD(wParam), (const TCHAR *)lParam);

		case KE_seltext:
			return CmdSelText(PES, (TCHAR *)lParam);

		case KE__FREE: {
			WNDPROC hOldED;

			SearchFileIned(&PES->ED, NilStrNC, NULL, 0);
			hOldED = PES->hOldED;
			RemoveProp(hWnd, StrPPxED);
			FreeEdStruct(PES);
			SetWindowLongPtr(hWnd, GWLP_WNDPROC, (LONG_PTR)hOldED);
			return NO_ERROR;
		}

		case KE_setkeya:
			if ( wParam != KE_firstevent_enable ){
				PES->AKey = (const TCHAR *)lParam;
			}
			if ( wParam != KE_setkeya ){
				setflag(PES->flags, PPXEDIT_WANTEVENT); // K_E_CLOSE MΉ
				if ( IsExistCustTable(StrK_edit, StrFIRSTEVENT) ||
					 ((PES->AKey != NULL) && IsExistCustTable(PES->AKey, StrFIRSTEVENT)) ){
					PostMessage(PES->hWnd, WM_PPXCOMMAND, K_E_FIRST, 0);
				}
			}
			return NO_ERROR;

		case KTN_close:
			ClosePPeTreeWindow(PES);
//		case KTN_focus: 
		case KTN_escape:
		case KTN_focus:
			SetFocus(hWnd);
			break;

		case KTN_select:
		case KTN_selected:
			if ( PES->flags & PPXEDIT_SINGLEREF ){
				Edit_SetWindowText(PES, (TCHAR *)lParam);
				Edit_SendMessage(PES, EM_SETSEL, EC_LAST, EC_LAST);
			}else{
				InsertAndSelect(hWnd, (const TCHAR *)lParam, TRUE);
			}
			if ( LOWORD(wParam) == KTN_selected ){
				ClosePPeTreeWindow(PES);
				SetFocus(hWnd);
			}
			break;

		case KE_closeUList:
			CloseUpperList(PES);
			break;

		case KE_scrapwindow:
			RemoveProp(hWnd, StrPPxED);
			FreeEdStruct(PES);
			DestroyWindow(hWnd);
			return NO_ERROR; // CallWindowProc sȂ

		case KE_changepos:
			FixListPosition(PES);
			break;

		case KE_setselectCB:
			SetSelectCombbox(hWnd);
			break;

		case K_EXECUTE:
			EditExtractMacro(PES, (TCHAR *)lParam, NULL, 0);
			break;

		default:
			PES->mousepos = FALSE;
			return EditPPeKeyCommand(PES, (DWORD)wParam);
	}
	return MAX32;
}

//------------------------------------
void RegisterSHAutoComplete(HWND hRealED)
{
	if ( DSHAutoComplete == NULL ){
		if ( LoadSystemWinAPI(SYSTEMDLL_SHLWAPI, SHLWAPIDLL) == NULL ){
			return;
		}
	}
	#pragma warning(suppress:6001 6011) // LoadSystemWinAPI ŏ
	DSHAutoComplete(hRealED, SHACF_FILESYSTEM | // SHACF_USETAB | tƁAW2kBS/DEL̋ȂH
			SHACF_AUTOAPPEND_FORCE_ON | SHACF_AUTOSUGGEST_FORCE_ON);
}

// | Ŕ͈͑I\ SetWindowText
BOOL SetWindowTextWithSelect(HWND hEditWnd, const TCHAR *defstr)
{
	DWORD firstC, lastC;
	TCHAR *firstp = SearchVLINE(defstr), *lastp;

	if ( firstp == NULL ){
		SetWindowText(hEditWnd, defstr);
		return FALSE;
	}else{
		TCHAR strbuf[CMDLINESIZE];

		tstplimcpy(strbuf, defstr, CMDLINESIZE);
		firstp = strbuf + (firstp - defstr);
		memmove( firstp , firstp + 1 , TSTRSIZE(firstp + 1) );

		lastp = SearchVLINE(strbuf);
		if ( lastp != NULL ){
			memmove( lastp , lastp + 1 , TSTRSIZE(lastp + 1) );
		}else{
			lastp = firstp;
		}

		SetWindowText(hEditWnd, strbuf);
		firstC = firstp - strbuf;
		lastC = lastp - strbuf;
#ifndef UNICODE
		if ( xpbug == 0 ){
			xpbug = IsWindowUnicode(hEditWnd) ? -1 : 1;
		}
		if ( xpbug < 0 ){
			CaretFixToW(strbuf, (DWORD *)&firstC);
			CaretFixToW(strbuf, (DWORD *)&lastC);
		}
#endif
		SendMessage(hEditWnd, EM_SETSEL, (WPARAM)firstC, (LPARAM)lastC);
		return TRUE;
	}
}

/*
	Action 
		_uNbNɂ͈͑I:	WB_LEFT - WB_RIGHT
		\̂߂̉s:			WB_ISDELIMITER
		Pړ(Ctrl+left)				WB_LEFT - WB_RIGHT
		Pړ(Ctrl+right)			WB_ISDELIMITER - WB_RIGHT - WB_RIGHT
*/
int wordbreak_action_right = 0; // WB_RIGHT ̌JԂ

int SearchLeftWord(LPWSTR lpch, int ichCurrent)
{
	// PꕔXLbv
	if ( (ichCurrent > 0) && (*(lpch + ichCurrent - 1) <= ' ') ){
		for (;;){
			if ( ichCurrent <= 0 ) return 0;
			ichCurrent--;
			if ( *(lpch + ichCurrent) > ' ' ) break;
		}
	}
	// ؂蕔XLbv
	for (;;){
		if ( ichCurrent <= 0 ) return 0;
		if ( *(lpch + ichCurrent - 1) <= ' ' ) return ichCurrent;
		ichCurrent--;
	}
}

int SearchLeftSeparator(LPWSTR lpch, int ichCurrent, TCHAR sepchr)
{
	// PꕔXLbv
	if ( (ichCurrent > 0) && (*(lpch + ichCurrent - 1) == sepchr) ){
		for (;;){
			if ( ichCurrent <= 0 ) return 0;
			ichCurrent--;
			if ( *(lpch + ichCurrent) != sepchr ) break;
		}
	}
	// ؂蕔XLbv
	for (;;){
		if ( ichCurrent <= 0 ) return 0;
		if ( *(lpch + ichCurrent - 1) == sepchr ) return ichCurrent;
		ichCurrent--;
	}
}

int SearchRightWord(LPWSTR lpch, int ichCurrent, int cch)
{
	// ؂蕔XLbv
	if ( *(lpch + ichCurrent) <= ' ' ){
		for (;;){
			if ( ichCurrent >= cch ) return cch;
			if ( *(lpch + ichCurrent + 1) > ' ' ) break;
			ichCurrent++;
		}
		return ichCurrent;
	}
	// PꕔXLbv
	for (;;){
		if ( ichCurrent >= cch ) return cch;
		if ( *(lpch + ichCurrent) <= ' ' ) return ichCurrent;
		ichCurrent++;
	}
}

int SearchRightSeparator(LPWSTR lpch, int ichCurrent, int cch, TCHAR sepchr)
{
	// ؂蕔XLbv
	if ( *(lpch + ichCurrent) == sepchr ){
		for (;;){
			if ( ichCurrent >= cch ) return cch;
			if ( *(lpch + ichCurrent + 1) != sepchr ) break;
			ichCurrent++;
		}
		return ichCurrent;
	}
	// PꕔXLbv
	for (;;){
		if ( ichCurrent >= cch ) return cch;
		if ( *(lpch + ichCurrent) == sepchr ) return ichCurrent;
		ichCurrent++;
	}
}
int CALLBACK LineEditWordBreakProcW(LPWSTR lpch, int ichCurrent, int cch, int action)
{
	int newpos;

	switch ( action ){
		case WB_LEFT:
			wordbreak_action_right = 0;
			if ( ichCurrent == 0 ) return 0;
			newpos = SearchLeftWord(lpch, ichCurrent);
			if ( newpos != 0 ) return newpos;
			newpos = SearchLeftSeparator(lpch, ichCurrent, '\\');
			if ( newpos != 0 ) return newpos;
			newpos = SearchLeftSeparator(lpch, ichCurrent, '/');
			if ( newpos != 0 ) return newpos;
			return SearchLeftSeparator(lpch, ichCurrent, '.');

		// WB_RIGHT  WB_ISDELIMITER   TRUE ̂߁A2Ă΂̂
		// 2ڂ͓XLbv
		case WB_RIGHT:
			if ( wordbreak_action_right++ == 1 ) return ichCurrent;
			if ( ichCurrent >= cch ) return cch;
			newpos = SearchRightWord(lpch, ichCurrent, cch);
			if ( newpos < cch ) return newpos;
			newpos = SearchRightSeparator(lpch, ichCurrent, cch, '\\');
			if ( newpos < cch ) return newpos;
			newpos = SearchRightSeparator(lpch, ichCurrent, cch, '/');
			if ( newpos < cch ) return newpos;
			return SearchRightSeparator(lpch, ichCurrent, cch, '.');
	}
	wordbreak_action_right = 0;
	//	WB_ISDELIMITER ... ɋ؂ɂ邱ƂŁA܂莞 WordBreak 𒲐
	return TRUE;
}

void InitExEdit(PPxEDSTRUCT *PES)
{
	if ( PES->style & ES_MULTILINE ){
		if ( PES->flags & PPXEDIT_LINE_MULTI ){
			PES->caretLY = 1;
			if ( (WinType >= WINTYPE_VISTA) &&
				 !(PES->flags & PPXEDIT_RICHEDIT) ){
				SendMessage(PES->hWnd, EM_SETWORDBREAKPROC, 0, (LPARAM)LineEditWordBreakProcW);
			}
		}else{
			setflag(PES->flags, PPXEDIT_TEXTEDIT);
			if ( GetCustDword(T("X_ucsr"), 1) ){
				setflag(PES->flags, PPXEDIT_LINECSR);
			}
			if ( (WinType >= WINTYPE_VISTA) &&
				 (PES->flags & PPXEDIT_NOWORDBREAK) &&
				 !(PES->flags & PPXEDIT_RICHEDIT) ){
				SendMessage(PES->hWnd, EM_SETWORDBREAKPROC, 0, (LPARAM)LineEditWordBreakProcW);
			}
		}
	}
	SetProp(PES->hWnd, StrPPxED, (HANDLE)PES);
}

#ifndef SPF_SETDEFAULT
  #define SPF_SETDEFAULT  0x0004
  #define EM_SETEDITSTYLE  (WM_USER + 204)
  #define SES_EXTENDBACKCOLOR  4
#endif
#ifndef IMF_DUALFONT
  #define IMF_DUALFONT  0x0080
#endif

void InitRichMode(PPxEDSTRUCT *PES, HWND hRealED, HFONT hEditFont)
{
	CHARFORMAT chfmt;
	LOGFONT lfont;
	TCHAR classname[128];

	GetClassName(hRealED, classname, TSIZEOF(classname));
	if ( TinyCharLower(classname[0]) != 'r' ) return;
	setflag(PES->flags, PPXEDIT_RICHEDIT);

	// tHgݒ
	// ASCII tHgƓ{tHgʂɂ
	SendMessage(hRealED, EM_SETLANGOPTIONS, 0,
			SendMessage(hRealED, EM_GETLANGOPTIONS, 0, 0) & ~IMF_DUALFONT );
	// KtHg擾
	GetObject(hEditFont, sizeof(LOGFONT), &lfont);

	// wiFݒ
	if ( ThemeColors.ExtraDrawFlags & (EDF_WINDOW_TEXT | EDF_WINDOW_BACK) ){
		SendMessage(hRealED, EM_SETBKGNDCOLOR, 0, (LPARAM)C_WindowBack);
	}
	// tHgݒ
	chfmt.cbSize = sizeof(chfmt);
	chfmt.dwMask = CFM_COLOR | CFM_SIZE | CFM_FACE | CFM_CHARSET;
	chfmt.dwEffects = CFE_AUTOCOLOR;
	chfmt.yHeight = (lfont.lfHeight * 1440) / 96;
	tstrcpy(chfmt.szFaceName, lfont.lfFaceName);
	chfmt.bCharSet = lfont.lfCharSet;
	chfmt.bPitchAndFamily = lfont.lfPitchAndFamily;
	// SCF_DEFAULT  0 Ȃ̂ŕʌɎw
	SendMessage(hRealED, EM_SETCHARFORMAT, SCF_DEFAULT, (LPARAM)&chfmt);
	SendMessage(hRealED, EM_SETCHARFORMAT, SPF_SETDEFAULT | SCF_ALL, (LPARAM)&chfmt);
	// wiEBhEŜ
	SendMessage(hRealED, EM_SETEDITSTYLE, SES_EXTENDBACKCOLOR, SES_EXTENDBACKCOLOR);
	SendMessage(hRealED, EM_SETOPTIONS, ECOOP_OR, ECO_NOHIDESEL);
	// E[Ō܂ݒ
	SendMessage(hRealED, EM_SETTARGETDEVICE, 0, 0);
	SendMessage(hRealED, EM_SETOPTIONS, ECOOP_AND, ~ECO_AUTOHSCROLL);
}

/*-----------------------------------------------------------------------------
	gGfBbg{bNXo^
-----------------------------------------------------------------------------*/
PPXDLL HWND PPXAPI PPxRegistExEdit(PPXAPPINFO *info, HWND hEditWnd, int maxlen, const TCHAR *defstr, WORD rHist, WORD wHist, int flags)
{
	PPxEDSTRUCT *PES;
	HWND hRealED;
	DWORD X_ltab[2] = Default_X_ltab;
	HFONT hEditFont;

	GetCustData(T("X_ltab"), &X_ltab, sizeof(X_ltab));
	if ( X_ltab[0] != 0 ) setflag(flags, PPXEDIT_TABCOMP);
	GetCustData(T("X_flst"), &X_flst, sizeof(X_flst));
	if ( X_flst_mode != X_fmode_off ) setflag(flags, PPXEDIT_LISTCOMP);

	if ( !(flags & PPXEDIT_COMBOBOX) ){	// ΏۂGfBbg{bNX ===========
		if ( maxlen != 0 ){
			#ifndef UNICODE
			if ( (maxlen > 0x8000) && (WinType == WINTYPE_9x) ){
				SendMessage(hEditWnd, EM_LIMITTEXT, 0x8000 - 1, 0);
			}else
			#endif
			{
				SendMessage(hEditWnd, EM_LIMITTEXT, maxlen - 1, 0);
			}
		}
		if ( (defstr != NULL) && (*defstr != '\0') ){
			if ( flags & PPXEDIT_INSTRSEL ){
				SetWindowTextWithSelect(hEditWnd, defstr);
			}else{
				SetWindowText(hEditWnd, defstr);
				SendMessage(hEditWnd, EM_SETSEL, 0, EC_LAST);
			}
		}
		hRealED = hEditWnd;
	}else{								// ΏۂR{{bNX ===============
		hRealED = PPxRegistExEditCombo(hEditWnd, maxlen, defstr, rHist, wHist, flags);
	}
#ifndef UNICODE
	if ( xpbug == 0 ){
		xpbug = IsWindowUnicode(hRealED) ? -1 : 1;
	}
#endif
	PES = GetProp(hRealED, StrPPxED);
	if ( PES == NULL ){					// Ɨ̈m ---------------------
		PES = HeapAlloc(DLLheap, HEAP_ZERO_MEMORY, sizeof(PPxEDSTRUCT));
		if ( PES == NULL ) return NULL;
		PES->ref = 1;
		PES->hWnd = hRealED;
//		PES->hTreeWnd = NULL;
//		PES->hOldED = NULL;
//		PES->AKey = NULL;
//		PES->KeyHookEntry = NULL;
//		PES->findstring[0] = '\0';
		PES->ED.hF = NULL;

		if ( X_ltab[1] == 0 ){
			if ( X_flst_part && (X_ltab[0] < 2) ) X_ltab[0] = 2;
			X_ltab[1] = X_ltab[0];
		}
		SetMatchMode(PES, X_ltab[1]);
		FixUxTheme(hRealED, EditClassName);
	}	// PES != NULL ... o^ς݁ݒ̕ύX̂ݍs

										// v[Wݒ -------------------
	PES->info = PES->ED.info = (info != NULL) ? info : &PPxDefInfo;
//	PES->list.index = 0;
	PES->list.WhistID = wHist;
	PES->list.RhistID = rHist;
	PES->list.OldString = NULL;
	PES->list.ListFocus = LISTU_NOLIST;
	PES->list.flags = 0;
//	PES->list.filltext_user.filename = NULL;
//	PES->list.filltext_user.mem = NULL;
//	PES->list.filltext_user.text = NULL;
//	PES->list.filltext_user.ref = 0;

	PES->flags = flags;
	PES->oldkey2 = 0;

	hEditFont = (HFONT)SendMessage(hRealED, WM_GETFONT, 0, 0);
	if ( hEditFont == NULL ){
		hEditFont = (HFONT)SendMessage(GetParent(hRealED), WM_GETFONT, 0, 0);
	};
	GetHeight(PES, hEditFont);
	if ( UseRichEdit > 0 ) InitRichMode(PES, hRealED, hEditFont);

	PES->tab = 8 * 4;
	PES->CrCode = VTYPE_CRLF;
	PES->CharCP = 0; // InitEditCharCode() ŏ

	PES->style = GetWindowLong(PES->hWnd, GWL_STYLE);
	PES->exstyle = GetWindowLong(PES->hWnd, GWL_EXSTYLE);
	PES->list.hWnd = NULL;
	PES->list.hSubWnd = NULL;

	GetCustData(T("X_pmc"), &X_pmc, sizeof(X_pmc));
	InitExEdit(PES);

	if ( PES->hOldED == NULL ){
		PES->hOldED = (WNDPROC)
				SetWindowLongPtr(hRealED, GWLP_WNDPROC, (LONG_PTR)EDsHell);
/*
		if ( PES->hOldED == NULL ){
			XMessage(hEditWnd, NULL, XM_GrERRld, T("PPxRegistExEdit error"));
		}
*/
		if ( !(PES->flags & PPXEDIT_TEXTEDIT) &&
			 (X_flst_mode == X_fmode_api) ){
			// SHAutoComplete ̓JgfBNgő΃pX⊮
			RegisterSHAutoComplete(hRealED);
		}
		if ( flags & PPXEDIT_WANTEVENT ){
			if ( IsExistCustTable(StrK_edit, StrFIRSTEVENT) ){
				PostMessage(hRealED, WM_PPXCOMMAND, K_E_FIRST, 0);
			}
		}
	}

	return hRealED;
}
