/*-----------------------------------------------------------------------------
	Paper Plane xUI	 commom library						_CAO֘A
-----------------------------------------------------------------------------*/
#define ONPPXDLL		// PPCOMMON.H  DLL `w
#include "WINAPI.H"
#include "PPX.H"
#include "VFS.H"
#include "PPD_DEF.H"
#pragma hdrstop

const TCHAR *ClassAtomString[] = {
	ButtonClassName, EditClassName, StaticClassName, ListBoxClassName,
	ScrollBarClassName, ComboBoxClassName
};

#ifdef UNICODE
	const WCHAR RichTextClassW[] = L"RichEdit20W";
#else
	const WCHAR RichTextClassW[] = L"RichEdit20A";
#endif
HMODULE hRichEdit = NULL;

BOOL IsUseRichEdit(void)
{
	if ( UseRichEdit >= 0 ) return UseRichEdit;
	if ( hRichEdit == NULL ){
		hRichEdit = LoadLibrary(T("riched20.dll"));
		if ( hRichEdit == NULL ){
			UseRichEdit = 0;
			return FALSE;
		}
	}

	GetCustTable(StrCustOthers, T("richedit"), &UseRichEdit, sizeof(UseRichEdit));
	UseRichEdit = Isdigit(UseRichEdit) ? ((UseRichEdit & 0xff) - '0') : 0;
	return UseRichEdit;
}

/*
vpeBV[g
eng
	95-2000	MS Sans Serif
	XP		MS Shell Dlg
jpn
	95-98	lr oSVbN
	2000-XP	MS UI Gothic
*/

PPXDLL LPDLGTEMPLATE PPXAPI GetDialogTemplate(HWND hParentWnd, HANDLE hinst, LPCTSTR lpszTemplate)
{
	BYTE *dialog;
	DLGTEMPLATE *dialog_res;
	HRSRC hRc;
	DWORD dialogsize, fontsize;
	int i;
	BYTE *dp, *dpitem;
	WCHAR fontdata[LF_FACESIZE + 1];
	UINT monitordpi, gdidpi;
	LOGFONTWITHDPI BoxFont;
	LCID forcust = 0;
									// ev[g̓ǂݍ
	hRc = FindResource(hinst, lpszTemplate, RT_DIALOG);
	if ( hRc == NULL ) return NULL;
	dialogsize = SizeofResource(hinst, hRc);
	dialog_res = LockResource(LoadResource(hinst, hRc));
#if 0
	dialog = HeapAlloc(ProcHeap, 0, dialogsize);
	memcpy(dialog, dialog_res, dialogsize);
#else
									// tHg̍쐬
	monitordpi = GetMonitorDPI(hParentWnd);
	GetPPxFont(PPXFONT_F_dlg, monitordpi, &BoxFont);

	if ( (dialog_res->style & DS_SETFONT) && // JX^}CU̎̓ʏ
		 ((LONG_PTR)lpszTemplate >= ID_CUST_MIN) &&
		 ((LONG_PTR)lpszTemplate <= ID_CUST_MAX) ){
		DWORD custfont = 0;

		GetCustTable(StrCustOthers, T("custfont"), &custfont, sizeof(custfont));
		if ( custfont == 0 ){
			forcust = LOWORD(GetUserDefaultLCID());
			if ( forcust == LCID_JAPANESE ){
//				tstrcpy(BoxFont.font.lfFaceName, T("MS UI Gothic"));
				if ( ((LONG_PTR)lpszTemplate == IDD_GENERAL) ||
					 ((LONG_PTR)lpszTemplate == IDD_GENERALE) ){
					tstrcpy(BoxFont.font.lfFaceName, T("lr oSVbN"));
				}else{
					tstrcpy(BoxFont.font.lfFaceName, T("lr SVbN"));
				}
			}else if ( forcust == LCID_ENGLISH ){
				tstrcpy(BoxFont.font.lfFaceName, T("MS Sans Serif"));
			}else{
				forcust = 0;
			}
		}
	}

	// fontsize : lfFaceName ̕(\0܂) + word(fontsize)
#ifdef UNICODE
	fontsize = (strlenW(BoxFont.font.lfFaceName) + 2) * sizeof(WCHAR);
	memcpy(&fontdata[1], BoxFont.font.lfFaceName, fontsize - sizeof(WCHAR));
#else
	fontsize = (MultiByteToWideChar(CP_ACP, 0,
		BoxFont.font.lfFaceName, -1, &fontdata[1],
		sizeof(fontdata) / sizeof(WCHAR) - 2) + 1) * sizeof(WCHAR);
#endif
	dialog = HeapAlloc(ProcHeap, 0, dialogsize + fontsize + sizeof(WORD) + (IsUseRichEdit() ? (14 * 8) : 0));
	memcpy(dialog, dialog_res, dialogsize);

	// dp = dialog + sizeof(DLGTEMPLATE) 
	dp = dialog + (sizeof(DWORD) * 2 + sizeof(WORD) * 5);

	if ( (X_dss & DSS_DIALOGREDUCE) &&
		 !((hinst == DLLhInst) &&
		 ((lpszTemplate == MAKEINTRESOURCE(IDD_INPUT)) ||
			 (lpszTemplate == MAKEINTRESOURCE(IDD_INPUT_OPT)) ||
			 (lpszTemplate == MAKEINTRESOURCE(IDD_INPUTREF)))) ){

		int DlgWidth = *(WORD *)(dialog + sizeof(DWORD) * 2 + sizeof(WORD) * 3);
		int DlgHeight = *(WORD *)(dialog + sizeof(DWORD) * 2 + sizeof(WORD) * 4);
		int heightPt;
		RECT deskbox;
		int minHeight = (PPX_FONT_MIN_PT * monitordpi + (DEFAULT_WIN_DPI / 2)) / DEFAULT_WIN_DPI; // 8pt

		DlgHeight += 8; // _CAÕ^Cgo[ǉ
		if ( ((LONG_PTR)lpszTemplate >= 0x7400) &&
			 ((LONG_PTR)lpszTemplate <= 0x77ff) ){
			DlgHeight += 24; // vpeBV[g̃{^ǉ
		}

		heightPt = BoxFont.font.lfHeight >= 0 ? BoxFont.font.lfHeight : -BoxFont.font.lfHeight;
		GetDesktopRect(hParentWnd, &deskbox);

#define DLGBASE_W 7 // ߂ɂĂ
#define DLGBASE_H 8
		gdidpi = GetGDIdpi(NULL);
		// Pt ϊ
		deskbox.right = ((deskbox.right - deskbox.left) * DEFAULT_DTP_DPI) / DEFAULT_WIN_DPI;
		deskbox.bottom = ((deskbox.bottom - deskbox.top) * DEFAULT_DTP_DPI) / DEFAULT_WIN_DPI;

		if ( ((OSver.dwMajorVersion > 10) ||
			((OSver.dwMajorVersion == 10) && (OSver.dwBuildNumber >= WINTYPE_10_BUILD_RS2))) &&
			((monitordpi == gdidpi) && (gdidpi != DEFAULT_WIN_DPI)) ){ // Win10 RS2 ȍ~́Aɕ␳Ă̂ŁA̕
			deskbox.right = (deskbox.right * DEFAULT_WIN_DPI) / gdidpi;
			deskbox.bottom = (deskbox.bottom * DEFAULT_WIN_DPI) / gdidpi;
		}
		// _CAỎ͂ݏoȂAk߂
		if ( ((DlgWidth * heightPt) / DLGBASE_W) > deskbox.right ){
			heightPt = (deskbox.right * DLGBASE_W) / DlgWidth;
			if ( heightPt < minHeight ) heightPt = minHeight;
			BoxFont.font.lfHeight = BoxFont.font.lfHeight >= 0 ? heightPt : -heightPt;
		}

		if ( ((DlgHeight * heightPt) / DLGBASE_H) > deskbox.bottom ){
			heightPt = (deskbox.bottom * DLGBASE_H) / DlgHeight;
			if ( heightPt < minHeight ) heightPt = minHeight;
			BoxFont.font.lfHeight = BoxFont.font.lfHeight >= 0 ? heightPt : -heightPt;
		}
	}
	// tHgTCY(pixelłȂAPt)
	fontdata[0] = (WCHAR)BoxFont.font.lfHeight;

									// j[ANXA^Cg΂
	for ( i = 0; i < 3; i++ ){
		WORD id;

		id = *(WORD *)dp;
		if ( id == 0 ){ // Ȃ
			dp += sizeof(WORD);
//		} else if ( id == 0xffff ){ // WORDl 2.05+1 ŏC\
		} else if ( id == 0 ){ // WORDl
			dp += sizeof(WORD) * 2;
		} else { // UCS-2 - z
			dp += sizeof(WORD);
			while ( *dp != 0 ) dp += sizeof(WORD);
			dp += sizeof(WORD);
		}
	}
	dpitem = dp;
									// ̃tHgΔ΂
	if ( ((DLGTEMPLATE *)dialog)->style & DS_SETFONT ){
		if ( forcust != 0 ){
			fontdata[0] = *(WORD *)dpitem;
			if ( forcust == LCID_JAPANESE ){ // tHgTCY␳
				switch ( (LONG_PTR)lpszTemplate ){
					case IDD_INFO:
					case IDD_COLOR:
					case IDD_ADDON:
					case IDD_ETCTREE:
						fontdata[0] += (WCHAR)2;
						break;

					case IDD_GENERALE:
					case IDD_EXT:
					case IDD_KEYD:
					case IDD_MOUSED:
					case IDD_MENUD:
					case IDD_BARD:
						fontdata[0]++;
						break;
				}
			}
		}
		dpitem += sizeof(WORD); // font point
		while ( *dpitem != '\0' ) dpitem += sizeof(WORD);
		dpitem += sizeof(WORD); // NIL
	}
								// dword ␳1
	if ( ALIGNMENT_BITS(dpitem) & 3 ) dpitem += sizeof(WORD);
								// dword ␳2
	if ( (ALIGNMENT_BITS(dp) + fontsize) & 3 ) fontsize += sizeof(WORD);
									// ev[g̏C
	setflag(((DLGTEMPLATE *)dialog)->style, DS_SETFONT);
	memmove(dp + fontsize, dpitem, dialogsize - (dpitem - dialog));
	memcpy(dp, fontdata, fontsize);

	if ( UseRichEdit > 0 ){ // Class EDIT  RichEdit ɕϊ
		BYTE *dpmax;
		dpmax = dialog + dialogsize + fontsize;
		dpitem += fontsize - 2;
		while (dpitem < dpmax){
//			XMessage(NULL, NULL, XM_DbgLOG, T("Item %x"),((DLGITEMTEMPLATE *)dpitem)->id);
			dpitem += sizeof(DLGITEMTEMPLATE);
								// NXA^CgAǉf[^΂
			for ( i = 0; i < 3; i++ ){
				WORD id;

				id = *(WORD *)dpitem;
				if ( id == 0 ){ // Ȃ
//					XMessage(NULL, NULL, XM_DbgLOG, T("%d: none"),i);
					dpitem += sizeof(WORD);
				} else if ( id == 0xffff ){ // WORDl
//					XMessage(NULL, NULL, XM_DbgLOG, T("%d: atom %s"),i,ClassAtomString[*(WORD *)(dpitem + 2)-0x80] );
					if ( (i == 0) &&
						 (*(WORD *)(dpitem + sizeof(WORD)) == 0x81) ){
						memmove(dpitem + sizeof(RichTextClassW),
						 		dpitem + sizeof(WORD) * 2,
						 		dpmax - (dpitem + sizeof(WORD) * 2));
						memcpy(dpitem, RichTextClassW, sizeof(RichTextClassW));
						dpitem += sizeof(RichTextClassW);
						dpmax += sizeof(RichTextClassW);
					}else{
						dpitem += sizeof(WORD) * 2;
					}
				} else { // UCS-2 - z
//					XMessage(NULL, NULL, XM_DbgLOG, T("%d: %Ls"),i,dpitem);
					dpitem += sizeof(WORD);
					while ( *dpitem != 0 ) dpitem += sizeof(WORD);
					dpitem += sizeof(WORD);
				}
			}
			if ( ALIGNMENT_BITS(dpitem) & 3 ) dpitem += sizeof(WORD);
		}
	}
#endif
	return (DLGTEMPLATE *)dialog;
}

// CXbh̃EBhEbZ[W[vɓO
// TuXbhŃ_CAO\悤ƂƁA
// ATOK ̃XbhŃfbhbNɊׂ̂R[h
void FixBeforeDialog(HWND hParentWnd)
{
	DWORD WndThreadID;

	if ( hParentWnd == NULL ) return;

	WndThreadID = GetWindowThreadProcessId(hParentWnd, NULL);

	if ( WndThreadID != GetCurrentThreadId() ){ // TuXbh?
		DWORD_PTR sendresult;

		// bZ[W|vĂƂ߂ĂB
		// łȂ TIMEOUT ܂őҋ@
		SendMessageTimeout(hParentWnd, WM_NULL, 0, 0, 0, 5000, &sendresult);
	}
}

// Ă݂ǁAForegroundWindow / Focus  NULL Ȃ̂ŁAӖȂH
HWND hPrevFGwnd;
HWND hNowFGwnd, hNowFGwnd2;

#pragma argsused
static void CALLBACK ConsoleAssistProc(HWND hWnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{
	HWND hFG;
	TCHAR buf[CMDLINESIZE];
	DWORD size;
	INPUT_RECORD cin;
	UnUsedParam(hWnd);UnUsedParam(uMsg);UnUsedParam(idEvent);UnUsedParam(dwTime);

	hFG = GetForegroundWindow();
	if ( hFG != hNowFGwnd ){
		hNowFGwnd2 = hNowFGwnd;
		hNowFGwnd = hFG;
		GetWindowText(hFG, buf, TSIZEOF(buf));
		XMessage(NULL, NULL, XM_DbgCon, T("Focus: %s\r\n"), buf);
	}

	if ( (DPeekConsoleInput(hConsoleStdin, &cin, 1, &size) == FALSE) || (size == 0) ){
		return;
	}
	if ( cin.EventType == KEY_EVENT ){
		if ( cin.Event.KeyEvent.bKeyDown == FALSE ){
			DReadConsoleInput(hConsoleStdin, &cin, 1, &size);
			return;
		}
	}
	DReadConsoleInput(hConsoleStdin, &cin, 1, &size);
/*
	XMessage(NULL, NULL, XM_DbgCon, T("size:%d %d %d %d"),size,input.EventType,
	input.Event.KeyEvent.wVirtualKeyCode,
	input.Event.KeyEvent.wVirtualScanCode );
*/
	if ( hFG != hPrevFGwnd ){
		PostMessage(hFG, WM_KEYDOWN, cin.Event.KeyEvent.wVirtualKeyCode, 0);
		PostMessage(hFG, WM_KEYUP, cin.Event.KeyEvent.wVirtualKeyCode, 0);
	}else if ( hNowFGwnd2 != hPrevFGwnd ){
		PostMessage(hNowFGwnd2, WM_KEYDOWN, cin.Event.KeyEvent.wVirtualKeyCode, 0);
		PostMessage(hNowFGwnd2, WM_KEYUP, cin.Event.KeyEvent.wVirtualKeyCode, 0);
	}
}

PPXDLL INT_PTR PPXAPI PPxDialogBoxParam(HANDLE hinst, const TCHAR *lpszTemplate, HWND hwndOwner, DLGPROC dlgprc, LPARAM lParamInit)
{
#if 1
	DLGTEMPLATE *dialog;
	INT_PTR result;
	DWORD old;

	InitSysColors();
	dialog = GetDialogTemplate(hwndOwner, hinst, lpszTemplate);
	if ( dialog == NULL ) return -1;
	if ( ConsoleMode >= ConsoleMode_ConsoleOnly ){
		hPrevFGwnd = hNowFGwnd = hNowFGwnd2 = GetForegroundWindow();
		old = UseConsoleKey();
		SetTimer(NULL, TIMERID_CONSOLE_ASSIST, TIME_CONSOLE_ASSIST, ConsoleAssistProc);
	}
	result = DialogBoxIndirectParam(hinst, dialog, hwndOwner, dlgprc, lParamInit);
#ifdef WINEGCC
	if ( (result == -1) && (GetLastError() == ERROR_OPEN_FAILED) ){
		result = DialogBoxParam(hinst, lpszTemplate, hwndOwner, dlgprc, lParamInit);
	}
#endif
	if ( ConsoleMode >= ConsoleMode_ConsoleOnly ){
		FreeConsoleKey(old);
		KillTimer(NULL, TIMERID_CONSOLE_ASSIST);
	}
	HeapFree(ProcHeap, 0, dialog);
	return result;
#else

	return DialogBoxParam(hinst, lpszTemplate, hwndOwner, dlgprc, lParamInit);
#endif
}

#ifdef UNICODE
static const TCHAR *GetDialogTemplateText(const BYTE **dpitem)
#else
static const TCHAR *GetDialogTemplateText(const BYTE **dpitem, char *text)
#endif
{
	if ( *((WORD *)*dpitem) == 0xffff ){ // atom
		WORD atom;

		atom = *(WORD *)((BYTE *)(*dpitem + sizeof(WORD)));
		*dpitem += sizeof(WORD) * 2;
		if ( (atom >= 0x80) && (atom <= 0x85) ){
			return ClassAtomString[atom - 0x80];
		}
		return (const TCHAR *)(DWORD_PTR)atom;
	} else{
#ifdef UNICODE
		WCHAR *text;
		DWORD size;

		text = (WCHAR *)*dpitem;
		size = strlenW(text) + 1;
		*dpitem += sizeof(WORD) * size;
#else
		WCHAR *resulttextW;
		DWORD size;

		resulttextW = (WCHAR *)*dpitem;
		size = strlenW(resulttextW) + 1;
		*dpitem += sizeof(WORD) * size;
		if ( text != NULL ) UnicodeToAnsi(resulttextW, text, MAX_PATH);
#endif
		return text;
	}
}

static const TCHAR * USEFASTCALL GetCaptionText(int id)
{
	TCHAR name[8];

	if ( id < 0 ) return NULL;
	thprintf(name, TSIZEOF(name), T("%04X"), id);
	return SearchMessageText(name);
}

// hParentWnd Ŏw肵EBhE lpszTemplate ̃Rg[Q\t
HWND *CreateDialogControls(HANDLE hinst, LPCTSTR lpszTemplate, HWND hParentWnd)
{
	HRSRC hrDialog;
	DWORD controls;
	const BYTE *dialog;
	const BYTE *dp, *dpitem;
	DLGITEMTEMPLATE *dtp;
	RECT box;
	int i;
	HFONT hFont;
	HWND *hCtrlWnds, *hCtrlWndDst;

// InitSysColors();
	hFont = (HFONT)SendMessage(hParentWnd, WM_GETFONT, 0, 0);
	hrDialog = FindResource(hinst, lpszTemplate, RT_DIALOG);

	dialog = LockResource(LoadResource(hinst, hrDialog));

	controls = ((DLGTEMPLATE *)dialog)->cdit;
	hCtrlWnds = hCtrlWndDst = HeapAlloc(DLLheap, 0, (controls + 1) * sizeof(HWND));
	if ( hCtrlWnds == NULL ) return NULL;

	dp = dialog + (sizeof(DWORD) * 2 + sizeof(WORD) * 5); // DLGTEMPLATE 
									// j[ANXA^Cg΂
	for ( i = 0; i < 3; i++ ){
		WORD id;

		id = *(WORD *)dp;
		if ( id == 0 ){ // Ȃ
			dp += sizeof(WORD);
//		} else if ( id == 0xffff ){ // WORDl 2.05+1 ŏC\
		} else if ( id == 0 ){ // WORDl
			dp += sizeof(WORD) * 2;
		} else { // UCS-2 - z
			dp += sizeof(WORD);
			while ( *dp != 0 ) dp += sizeof(WORD);
			dp += sizeof(WORD);
		}
	}
	dpitem = dp;
									// ̃tHgΔ΂
	if ( ((DLGTEMPLATE *)dialog)->style & DS_SETFONT ){
		dpitem += sizeof(WORD);
		while( *dpitem ) dpitem += sizeof(WORD);
		dpitem += sizeof(WORD);
	}
	for ( ; controls ; controls-- ){
		const TCHAR *ClassName, *CaptionName;
#ifndef UNICODE
		char ClassNameA[MAX_PATH];
		char CaptionNameA[MAX_PATH];
#endif
		WORD extrasize;
		HWND hCtrlWnd;

		if ( ALIGNMENT_BITS(dpitem) & 3 ) dpitem += sizeof(WORD); // ACg␳

		dtp = (DLGITEMTEMPLATE *)dpitem;
		box.left	= dtp->x;
		box.top		= dtp->y;
		box.right	= dtp->cx;
		box.bottom	= dtp->cy;
		MapDialogRect(hParentWnd, &box);

		dpitem += (sizeof(DWORD) * 2 + sizeof(WORD) * 5); //DLGITEMTEMPLATE
#ifdef UNICODE
		ClassName = GetDialogTemplateText(&dpitem);
		CaptionName = GetCaptionText(dtp->id);
		if ( CaptionName != NULL ){
			GetDialogTemplateText(&dpitem);
		}else{
			CaptionName = GetDialogTemplateText(&dpitem);
		}
#else
		ClassName = GetDialogTemplateText(&dpitem, ClassNameA);
		CaptionName = GetCaptionText(dtp->id);
		if ( CaptionName != NULL ){
			GetDialogTemplateText(&dpitem, NULL);
		}else{
			CaptionName = GetDialogTemplateText(&dpitem, CaptionNameA);
		}
#endif
		extrasize = *(WORD *)dpitem;

		hCtrlWnd = CreateWindowEx(dtp->dwExtendedStyle | WS_EX_NOPARENTNOTIFY,
				ClassName, CaptionName, dtp->style | WS_CHILD | WS_VISIBLE,
				box.left, box.top, box.right, box.bottom, hParentWnd,
				CHILDWNDID(dtp->id), hinst, extrasize ? (void *)dpitem : NULL);
		if ( hCtrlWnd == NULL ){
			PPErrorBox(hParentWnd, NULL, PPERROR_GETLASTERROR);
			break;
		}
		SendMessage(hCtrlWnd, WM_SETFONT, (WPARAM)hFont, TMAKELPARAM(TRUE,0));
		FixUxTheme(hCtrlWnd, ClassName);
		*hCtrlWndDst++ = hCtrlWnd;
		dpitem += extrasize ? extrasize : sizeof(WORD);
	}
	*hCtrlWndDst = NULL;
	return hCtrlWnds;
}

//===================================== ȈՐ`\EBhENX
static void PaintPPxStatic(HWND hWnd)
{
	PAINTSTRUCT ps;
	TCHAR buf[0x800], *maxptr;
	RECT rect;

	BeginPaint(hWnd, &ps);
	maxptr = buf + GetWindowText(hWnd, buf, TSIZEOF(buf));

	if ( maxptr != buf ){
		TCHAR *first, *format;
		POINT Draw = {1, 2};
		int align = -1; // ͂ݏoƂ̑
		HGDIOBJ hOldFont;
		TEXTMETRIC tm;
		int baseW, baseH;

		#if 0
		{	// ĂяoԊuvp
			DWORD oldtick,nowtick = GetTickCount();

			oldtick = (DWORD)GetProp(hWnd,T("IntervalCheck"));
			if ( (nowtick - oldtick) < 100 ){
				XMessage(NULL, NULL, XM_DbgLOG, T("Static %x %3dm %s"), (DWORD)hWnd & 0xff, (nowtick - oldtick), buf);
			}
			SetProp(hWnd,T("IntervalCheck"),(HANDLE)nowtick);
		}
		#endif

		rect.top = 0;
		rect.bottom = 0;
		rect.left = 0;
		rect.right = 1;
		MapDialogRect(GetParent(hWnd), &rect);
		baseW = rect.right;
		GetClientRect(hWnd, &rect);
		InitSysColors();

		// WS_BORDER ̑ɎOŘg`B
		//  WS_BORDER _CAO쐬 WS_EX_CLIENTEDGE ɒuA
		//    AŕύXłȂ
		rect.right--;
		rect.bottom--;
		FrameRect(ps.hdc, &rect, GetEdgeLineBrush());
		rect.left += 2;
		rect.top++;
		rect.right--;
		rect.bottom--;

		SetTextColor(ps.hdc, C_DialogText);
		SetBkColor(ps.hdc, C_DialogBack);
		hOldFont = SelectObject(ps.hdc,
				(HFONT)GetWindowLongPtr(hWnd, GWLP_USERDATA));

		GetTextMetrics(ps.hdc, &tm);
		baseH = tm.tmHeight;

		format = buf;
		while ( format < maxptr ){
			SIZE ssize;
			size_t strlength;

			first = format;
			while ( format < maxptr ){
				if ( (UTCHAR)*format < ' ' ) break;
				format++;
			}
			strlength = format - first;
			if ( strlength ){
				RECT box;

				GetTextExtentPoint32(ps.hdc, first, strlength, &ssize);
				if ( ssize.cx < (rect.right - Draw.x) ){ // ͂ݏoȂ
					if ( align != SS_RIGHT ){ // 
						ssize.cx = Draw.x;
					}else{ // E
						ssize.cx = rect.right - ssize.cx;
					}
				}else{ // ͂ݏo
					if ( align < 0 ){
						align = GetWindowLongPtr(hWnd, GWL_STYLE) & 7;
					}
					switch ( align ){
						case SS_CENTER: // ()ŏIGg\
							first = VFSFindLastEntry(first);
							strlength = tstrlen(first);
							format = first + strlength;
							ssize.cx = Draw.x;
							break;
						case SS_RIGHT: // E
							ssize.cx = Draw.x;
							break;
						case 3: // (SS_RIGHT + SS_CENTER)dir̂݉E
							format = VFSFindLastEntry(first);
							if ( *format == '\\' ) format++;
							strlength = format - first;
							format += tstrlen(format);
							GetTextExtentPoint32(ps.hdc, first, strlength, &ssize);
							ssize.cx = rect.right - ssize.cx;
							break;
						default: //  ( SS_LEFT )
							ssize.cx = rect.right - ssize.cx;
					}
				}
				box.left = Draw.x;
				box.top = Draw.y;
				box.right = rect.right;
				box.bottom = min(rect.bottom, Draw.y + baseH);

				ExtTextOut(ps.hdc, ssize.cx, Draw.y, ETO_CLIPPED | ETO_OPAQUE,
						&box, first, strlength, NULL);
				if ( format >= maxptr ) break;
			}
			switch ( *format ){
				case PXSC_NORMAL: {				// ʏ
					SetTextColor(ps.hdc, C_DialogText);
					SetBkColor(ps.hdc, C_DialogBack);
					break;
				}
				case PXSC_HILIGHT: {
					SetTextColor(ps.hdc, C_HighlightText);
					SetBkColor(ps.hdc, C_HighlightBack);
					break;
				}
				case '\n':			// s
					Draw.x = 1;
					Draw.y += baseH;
					break;
				case PXSC_PAR: {	// vOX\
/*
----------------------+
3                     |
  +----+  +--+5 +--+  |
x1| x10|x1|c|x2|c|x1|
  +----+  +--+  +--+  |
2                     |
----------------------+
*/
					// PAR_ALLBLOCKS * PAR_BLOCKRANGE = 100
					#define PAR_ALLBLOCKS 10 // SubN
					#define PAR_BLOCKRANGE 10 // ubN̒P
					#define PAR_BLOCKSIZE 10 // 1ubN̕`敝
					#define PAR_BLOCKSBLANK 1 // ubNԂ̋
					#define PAR_BLOCKSPACING (PAR_BLOCKSIZE + PAR_BLOCKSBLANK)
					#define PAR_WIDTH (PAR_BLOCKSBLANK + PAR_BLOCKSPACING * PAR_ALLBLOCKS + PAR_BLOCKSBLANK + PAR_BLOCKSBLANK ) // vOX\
					int i;
					RECT box;
					HBRUSH hB;
					int count, par, drawbar;

					par = (DWORD)*((BYTE *)(format + 1)) - 1;	// 1-100(-1)
					count = *(BYTE *)(format + 2) - 1;			// 1-11(-1)
					format += 2;

					box.top = rect.top + (baseW + (baseW / 2));
					box.bottom = min(rect.bottom, Draw.y + baseH) - baseW;

					hB = (count <= 10) ? GetHighlightBackBrush() : GetEdgeLineBrush();
														// Ō㒼O܂
					box.left  = Draw.x + baseW;
					box.right = Draw.x + baseW * PAR_BLOCKSPACING;
					for ( i = 0 ; (i + PAR_BLOCKRANGE) < par ; i += PAR_BLOCKRANGE ){
						FillBox(ps.hdc, &box, hB);
						box.left = box.right + baseW;
						// 50% E͋󔒕{
						if ( i == (PAR_BLOCKRANGE * (5 - 1)) ){
							box.left += baseW; // * PAR_BLOCKSBLANK
						}
						box.right = box.left + baseW * PAR_BLOCKSIZE;
					}
														// Ō
					box.right = box.left + ((par - i) * baseW);
					FillBox(ps.hdc, &box, hB);
													//  -------------------
					box.top = rect.top;
					box.bottom += baseW;
					box.left = box.right;
					box.right = Draw.x + baseW * PAR_WIDTH;
					hB = GetDialogBackBrush();
					FillBox(ps.hdc, &box, hB);

					drawbar = (int)GetWindowLongPtr(hWnd, 0);
					if ( (drawbar > 0) && (drawbar < box.left) ){
						// Ȍo[
						box.left = drawbar;
						box.right = drawbar + baseW;
						FillBox(ps.hdc, &box, hB);
					}
											// o[ -----------
					if ( (count >= 0) && (count <= 10) ){
						hB = CreateSolidBrush(C_WindowText);
						box.left = Draw.x + ( count * PAR_BLOCKSPACING + PAR_BLOCKSPACING ) * baseW;
						if ( count >= 4 ) box.left += baseW;
						box.right = box.left + baseW;
						FillBox(ps.hdc, &box, hB);
						DeleteObject(hB);
						SetWindowLongPtr(hWnd, 0, (LONG_PTR)box.left);
					}

					Draw.x += baseW * PAR_WIDTH;
					break;
				}
				case PXSC_LEFT:
					align = SS_LEFT;
					break;
				case PXSC_RIGHT:
					align = SS_RIGHT;
					break;
				default:	// `
					format = maxptr;
			}
			format++;
		}
		SelectObject(ps.hdc, hOldFont);
	}
	EndPaint(hWnd, &ps);
}

LRESULT CALLBACK PPxStaticProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch ( message ){
		case WM_PAINT:
			PaintPPxStatic(hWnd);
			return 0;

		case WM_LBUTTONUP:
		case WM_RBUTTONUP:
			PostMessage(GetParent(hWnd), WM_COMMAND, GetDlgCtrlID(hWnd) | (WM_CONTEXTMENU << 16), (LPARAM)hWnd);
			return 0;

		case WM_SETTEXT:
			InvalidateRect(hWnd, NULL, FALSE);
			break;

		case WM_SETFONT:
			SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)wParam);
			if ( LOWORD(lParam) ) InvalidateRect(hWnd, NULL, FALSE);
			break;
	}
	return DefWindowProc(hWnd, message, wParam, lParam);
}

void ShowDlgWindow(const HWND hDlg, const UINT id, BOOL show)
{
	HWND hControlWnd;

	hControlWnd = GetDlgItem(hDlg, id);
	if ( hControlWnd == NULL ) return;
	ShowWindow(hControlWnd, show ? SW_SHOW : SW_HIDE);
}

void EnableDlgWindow(HWND hDlg, int id, BOOL state)
{
	HWND hControlWnd;

	hControlWnd = GetDlgItem(hDlg, id);
	if ( hControlWnd == NULL ) return;
	EnableWindow(hControlWnd, state ? TRUE : FALSE);
}

struct {
	HWND hCheckWnd;
	HWND hParentWnd;
	BOOL result;
} DialogKeyProcCache = {NULL, NULL, FALSE}; // _CAÖȑǑ

// msg _CAORg[ǂ𔻒肵AĂ IsDialogMessage s
BOOL DialogKeyProc(MSG *msg)
{
	DWORD style;

	if ( (msg->message < WM_KEYFIRST) || (msg->message >= 0x109) ) return FALSE;
	if ( msg->hwnd == DialogKeyProcCache.hCheckWnd ){
//		XMessage(NULL, NULL, XM_DbgLOG, T("cache %x %d"),msg->hwnd,DialogKeyProcCache.result);
		if ( DialogKeyProcCache.result == FALSE ) return FALSE;
	}else{
		HWND hParent;

		DialogKeyProcCache.hCheckWnd = msg->hwnd;

//		XMessage(NULL, NULL, XM_DbgLOG, T("check %x"),msg->hwnd);

		hParent = GetParent(msg->hwnd); // e_CAO𔻒f
		if ( hParent == DialogKeyProcCache.hParentWnd ){
			if ( DialogKeyProcCache.result == FALSE ) return FALSE;
		}else{
			DialogKeyProcCache.hParentWnd = hParent;
			DialogKeyProcCache.result = FALSE;
			if ( hParent == NULL ) return FALSE;
			style = GetWindowLongPtr(hParent, GWL_STYLE);
			if ( style & WS_CHILD ){
				DialogKeyProcCache.hParentWnd = hParent = GetParent(hParent);
				if ( hParent == NULL ) return FALSE;
				style = GetWindowLongPtr(hParent, GWL_STYLE);
			}
			// _CAO WS_POPUP LȂ̂łŔf
			if ( !(style & WS_POPUP) ) return FALSE;
			DialogKeyProcCache.result = TRUE;
		}
	}
//		XMessage(NULL, NULL, XM_DbgLOG, T("check %x -> dialog %x"),msg->hwnd,DialogKeyProcCache.hParentWnd);
	return IsDialogMessage(DialogKeyProcCache.hParentWnd, msg);
}

