/*-----------------------------------------------------------------------------
	Paper Plane xUI	customizer									FV[g
-----------------------------------------------------------------------------*/
#include "WINAPI.H"
#include <shlobj.h>
#include "PPX.H"
#include "VFS.H"
#include "PPCUST.H"
#pragma hdrstop

// COMMON_LVB_ ́AWindowNTn̑oCg or Windows10ȍ~ŃT|[g
#ifndef COMMON_LVB_UNDERSCORE
	#define COMMON_LVB_UNDERSCORE 0x8000
#endif

#define GC_mask		0xff
#define GC_single	0
#define GC_list		1
#define GC_table	2 // CustTable (gqF)
#define GC_entry	3
#define GC_hmenu	4
#define GC_line		5
#define GC_theme	6  // e[}p
#define GC_nocolor	B9 // FI𖳂(GC_themep)
#define GC_aoff		B10 // C_AUTO ͔\
#define GC_ppbItem	B11 // GC_list
#define GC_sortItem	B12 // GC_table
#define GC_editItem	B13 // GC_table
#define GC_haveItem	B14 // GC_list
#define GC_auto		B15 // ꕔGC_single

typedef struct {
	const TCHAR *name;
	const TCHAR *item;
	DWORD flags; // GC_
	const TCHAR **sublist;
	int subs;
} LISTS;

#define THEMEINDEX_RESTORE 0
#define THEMEINDEX_MAXRESOURCE 5
#define THEMEINDEX_USER (THEMEINDEX_MAXRESOURCE + 1)
const TCHAR *GCtheme[] = {
	MES_VCTB, MES_VCTC, MES_VCTD, MES_VCTE, MES_VCTF, MES_VCTH, NULL
};

const TCHAR *GCline[] = { MES_VCLM, MES_VCLL, NULL};
const TCHAR *GCCdisp[] = { MES_VCDA, MES_VCDB, NULL};
const TCHAR *GCwin[] = {
	MES_VCWA, MES_VCWB, MES_VCWC, MES_VCWD,
	MES_VCWE, MES_VCWF, MES_VCWG, MES_VCWH,
	MES_VCWI, MES_VCWJ, MES_VCWK, MES_VCWL,
	NULL};
const TCHAR *GCcapt[] = {
	MES_VCFF, MES_VCFG, MES_VCFH, MES_VCFI,
	MES_VCFJ, MES_VCFK, MES_VCFL, MES_VCFM,
	MES_VCFN, MES_VCFO, MES_VCFP, MES_VCFQ,
	MES_VCFR, MES_VCFS, NULL};
const TCHAR *GCentry[] = {
	MES_VCEM, MES_VCEC, MES_VCEP, MES_VCEA,
	MES_VCED, MES_VCES, MES_VCEH, MES_VCER,
	MES_VCEN, MES_VCEO, MES_VCEL, MES_VCEI,
	MES_VCEE, MES_VCEF, NULL};
const TCHAR *GCeInfo[] = {
	MES_VCJA, MES_VCJB, MES_VCJC, MES_VCJD,
	MES_VCJE, MES_VCJF, MES_VCJG, MES_VCJH,
	MES_VCJI, MES_VCJJ, MES_VCJK,
	MES_VCJL, MES_VCJM,
	MES_VCJN, MES_VCJO, MES_VCJP, MES_VCJQ,
	MES_VCJR, MES_VCJS, MES_VCJT, MES_VCJV, MES_VCJW, NULL};
const TCHAR *GCltag[] = { MES_VCTT, MES_VCTS, NULL};
const TCHAR *GCchar[] = {
	MES_VCPI, MES_VCPM, MES_VCPK, MES_VCPJ,
	MES_VCPO, MES_VCPL, MES_VCPN, MES_VCPP,
	MES_VCPQ, MES_VCPE, MES_VCPC, MES_VCPB,
	MES_VCPG, MES_VCPD, MES_VCPF, MES_VCPR,
	NULL};
const TCHAR *GCb_pals[] = {
	MES_VCPQ, MES_VCPB, MES_VCPC, MES_VCPD,
	MES_VCPE, MES_VCPF, MES_VCPG, MES_VCPR,
	MES_VCPI, MES_VCPJ, MES_VCPK, MES_VCPL,
	MES_VCPM, MES_VCPN, MES_VCPO, MES_VCPP,
	NULL};
const TCHAR *GChili[] = { MES_VCHF,
	MES_VCJN, MES_VCJO, MES_VCJP, MES_VCJQ,
	MES_VCJR, MES_VCJS, MES_VCJT, MES_VCJU,
	NULL};

const TCHAR *GClbak[] = { MES_VCVC, MES_VCVA, MES_VCVD, NULL};
const TCHAR *GClnum[] = { MES_VCLG, MES_VCLH, NULL};

const TCHAR *GCBedit[] = {
	MES_VCBS, MES_VCBT, MES_VCBU, MES_VCBV,
	MES_VCBW, MES_VCBX, MES_VCBY, MES_VCBZ,
	NULL};

const TCHAR *GCBpop[] = {
	MES_VCBF, MES_VCBG, MES_VCBC, MES_VCBD,
	MES_VCBA, MES_VCBB, MES_VCBU, MES_VCBV,
	MES_VCBH, MES_VCBI,
	NULL};

const LISTS GClist[] = {
	{MES_VCCT, NilStr,		GC_theme | GC_nocolor | GC_haveItem, GCtheme, 5},
	{MES_VCBK, T("C_back"),	GC_single | GC_auto, NULL, 0},
	{MES_VCME, T("C_mes"),	GC_single | GC_auto, NULL, 0},
	{MES_VCIN, T("C_info"),	GC_single | GC_auto, NULL, 0},
	{MES_VCRE, T("C_res"),	GC_list | GC_haveItem, GCCdisp, 2},
	{MES_VCLI, T("C_line"),	GC_list | GC_haveItem, GCline, 2},
	{MES_VCTR, T("CC_tree"),GC_list | GC_haveItem, GCCdisp, 2},
	{MES_VCTI, T("C_tip"),	GC_list | GC_haveItem, GCCdisp, 2},
	{MES_VCFD, T("C_win"),	GC_list | GC_haveItem, GCwin, 12},
	{MES_VCFE, T("C_ext"),	GC_table | GC_haveItem | GC_editItem | GC_sortItem, NULL, 0},
	{MES_VCET, T("C_entry"), GC_list | GC_haveItem, GCentry, 14},
	{MES_VCEB, T("C_eInfo"), GC_list | GC_haveItem, GCeInfo, 22},
	{MES_VCIA, T("XC_inf1"), GC_list | GC_haveItem, GCCdisp, 2},
	{MES_VCIB, T("XC_inf2"), GC_list | GC_haveItem, GCCdisp, 2},
	{MES_VCCA, T("C_capt"),	GC_list | GC_haveItem, GCcapt, 14},
	{MES_VCLA, T("CC_log"), GC_list | GC_haveItem, GCCdisp, 2},
	{MES_VCVT, T("CV_char"), GC_list | GC_haveItem, GCchar, 16},
	{MES_VCVE, T("CV_lbak"), GC_list | GC_haveItem | GC_aoff, GClbak, 3},
	{MES_VCVB, T("CV_boun"), GC_single,	NULL, 0},
	{MES_VCCL, T("CV_lcsr"), GC_single,	NULL, 0},
	{MES_VCLN, T("CV_lnum"), GC_list | GC_haveItem, GClnum, 2},
	{MES_VCCC, T("CV_ctrl"), GC_single,	NULL, 0},
	{MES_VCLF, T("CV_lf"),	GC_single,	NULL, 0},
	{MES_VCTA, T("CV_tab"),	GC_single,	NULL, 0},
	{MES_VCWS, T("CV_spc"),	GC_single,	NULL, 0},
	{MES_VCLK, T("CV_link"), GC_single,	NULL, 0},
	{MES_VCTG, T("CV_syn"),	GC_list | GC_haveItem, GCltag, 3},
	{MES_VCHL, T("CV_hili"), GC_list | GC_haveItem, GChili, 9},
	{MES_VCBE, T("CB_edit"), GC_list | GC_haveItem | GC_ppbItem, GCBedit, 4},
	{MES_VCBR, T("CB_com"),	GC_list | GC_haveItem | GC_ppbItem, GCCdisp, 2},
	{MES_VCBO, T("CB_pop"),	GC_list | GC_haveItem | GC_ppbItem, GCBpop, 6},
	{MES_VCBP, T("CB_pals"), GC_list | GC_haveItem, GCb_pals, 16},
	{NULL, NULL, 0, NULL, 0}
};

const TCHAR stringauto[] = MES_VCAU;
const TCHAR stringaoff[] = MES_VCDI;
const TCHAR stringother[] = MES_VCOT;
const TCHAR AutoString[] = T("a)");
const TCHAR SubMenuString[] = T("> ");
const WCHAR stringExtInfo[] = BANNERTEXT(MES_VBEI, L"gq/ChJ[h\0extention/wildcard");

#define COLOR_SPECIAL 0xfe000000
#define COLOR_SUB 0xfffffffe // w
#define COLOR_NO 0xfefefefe // Fw薳(themep)

#define COLORLIST_WIDTH 6
#define COLORLIST_HEIGHT 12
#define COLORLIST_COLORS (COLORLIST_WIDTH * COLORLIST_HEIGHT)

enum {
//PPc̒`F
	CL_back = (COLORLIST_COLORS - 12), CL_mes, CL_info,
//Windows̒`F
	CL_windowtext, CL_window, CL_hilighttext, CL_hilight,
	CL_btnface, CL_inactive,
//JX^}CU֘A
	CL_prev, // OŎgpF
	CL_user, // [U쐬F
	CL_auto // I擾F
};

#define CL_first CL_back
#define CL_withtext CL_user
#define CL_last CL_auto

COLORREF G_Colors[COLORLIST_COLORS] = {
	C_BLACK, C_RED, C_GREEN, C_BLUE,
	C_YELLOW, C_CYAN, C_MAGENTA, C_SBLUE,
	C_MGREEN, 0x80ff80, C_CREAM, 0x202020,

	C_DBLACK, 0x0000c0, 0x40ff00, 0xc00000,
	0x00c0c0, 0xff8000, 0x8000ff, 0xffff80,
	0x4080ff, 0x80ff00, 0x80ffff, 0x404040,

	C_GRAY, 0x404080, 0x408000, 0xa00000,
	0x408080, 0xc08000, 0xff0080, 0x804000,
	0x0080ff, 0x80ff00, 0x40c0c0, 0x606060,

	C_DWHITE, C_DRED, C_DGREEN, C_DBLUE,
	C_DYELLOW, C_DCYAN, C_DMAGENTA, 0x400080,
	0xc08080, 0x00ff80, 0x8080ff, 0xa0a0a0,

	C_WHITE, 0x000040, 0x004000, 0x400000,
	0x004080, 0x404000, 0x800040, 0x400040,
	0xff8080, 0x808040, 0xff80ff, 0xe0e0e0,

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, C_AUTO
};


#define CONSOLECOLOR 16

COLORREF ConsoleColors[CONSOLECOLOR] = {
	C_BLACK, C_DBLUE, C_DGREEN, C_DCYAN, C_DRED, C_DMAGENTA, C_DYELLOW, C_DWHITE,
	C_DBLACK, C_BLUE, C_GREEN, C_CYAN, C_RED, C_MAGENTA, C_YELLOW, C_WHITE,
};

#define USERUSEPPXCOLOR 3
// Fڍ׃_CAÕ[U`F
#define userColor_SEL 15 // ݑIĂF
COLORREF userColor[16] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

#define GC_THEME 0
int edit_gct = GC_THEME;	// IDV_GCTYPE ̑I𒆃CfbNX
const LISTS *GcType = &GClist[GC_THEME];

int edit_sitem = 0;			// IDV_GCITEM ̑I𒆃CfbNX

#define WINDOWSCOLOR 6
int GDIColors[WINDOWSCOLOR] = {
	COLOR_WINDOWTEXT, COLOR_WINDOW,
	COLOR_HIGHLIGHTTEXT, COLOR_HIGHLIGHT,
	COLOR_BTNFACE, COLOR_INACTIVECAPTION
};

const TCHAR OldColorWildcard[] = T("&C*,&!CV_hkey");
TCHAR *OldColorTheme = NULL;
int OldX_uxt[2] = {X_uxt_defvalue};

typedef struct {
	TCHAR text[VFPS], *textptr;
	BOOL cb_top, cb_bottom;
} HighlightItem;

int DrawHeight = -1;

int InitDrawHeight(HWND hDlg)
{
	HDC hDC;
	HGDIOBJ hOldFont;
	TEXTMETRIC tm;

	hDC = GetDC(hDlg);
	hOldFont = SelectObject(hDC, (HFONT)SendMessage(hDlg, WM_GETFONT, 0, 0));
	GetTextMetrics(hDC, &tm);
	SelectObject(hDC, hOldFont);
	ReleaseDC(hDlg, hDC);
	return tm.tmHeight + 1;
}

BOOL ListView__Select(HWND hListView, int index)
{
	LV_ITEM lvi;

	lvi.mask = LVIF_STATE;
	lvi.state = LVIS_FOCUSED | LVIS_SELECTED;
	lvi.stateMask = 0xf;
	lvi.iItem = index;
	lvi.iSubItem = 0;

	SendMessage(hListView, LVM_SETITEMSTATE, (WPARAM)index, (LPARAM)&lvi);
	SendMessage(hListView, LVM_ENSUREVISIBLE, (WPARAM)index, (LPARAM)FALSE);
	return TRUE;
}

void ListView__FixColorColumn(HWND hListView)
{
	int width;
	RECT box;

	if ( DrawHeight < 0 ) DrawHeight = InitDrawHeight(hListView);
	SendMessage(hListView, LVM_SETCOLUMNWIDTH, 0, LVSCW_AUTOSIZE);
	width = ListView_GetColumnWidth(hListView, 0) + DrawHeight;
	GetClientRect(hListView, &box);
	if ( width < box.right ) width = box.right;
	SendMessage(hListView, LVM_SETCOLUMNWIDTH, 0, width);
}

BOOL ListView__GetText(HWND hListView, int index, TCHAR *text, int textlen)
{
	LV_ITEM lvi;

	lvi.iItem = (index >= 0) ? index : TListView_GetFocusedItem(hListView);
	if ( lvi.iItem < 0 ){
		text[0] = '\0';
		return FALSE;
	}
	lvi.mask = LVIF_TEXT;
	lvi.iSubItem = 0;
	lvi.pszText = text;
	lvi.cchTextMax = textlen;
	ListView_GetItem(hListView, &lvi);
	return TRUE;
}
/*
BOOL ListView__DeleteSelectedItem(HWND hListView)
{
	int index = TListView_GetFocusedItem(hListView);

	if ( index < 0 ) return FALSE;
	return ListView_DeleteItem(hListView, index);
}
*/
LPARAM ListView__GetItemData(HWND hListView, int index)
{
	LV_ITEM lvi;

	lvi.iItem = (index >= 0) ? index : TListView_GetFocusedItem(hListView);
	if ( lvi.iItem < 0 ) return 0;
	lvi.mask = LVIF_PARAM;
	lvi.iSubItem = 0;
	ListView_GetItem(hListView, &lvi);
	return lvi.lParam;
}

BOOL ListView__SetItemData(HWND hListView, int index, LPARAM lParam)
{
	LV_ITEM lvi;

	lvi.iItem = (index >= 0) ? index : TListView_GetFocusedItem(hListView);
	if ( lvi.iItem < 0 ) return FALSE;
	lvi.mask = LVIF_PARAM;
	lvi.iSubItem = 0;
	lvi.lParam = lParam;
	ListView_SetItem(hListView, &lvi);
	return TRUE;
}

TCHAR *GetUserTheme(HWND hDlg)
{
	PPXDBINFOSTRUCT dbinfo;
	TCHAR path[VFPS], buf[VFPS];
	TCHAR *mem, *text, *maxptr, *last;
	ERRORCODE err;

	dbinfo.structsize = sizeof dbinfo;
	dbinfo.custpath = path;
	GetPPxDBinfo(&dbinfo);

	if ( ListView__GetText(GetDlgItem(hDlg, IDV_GCITEM), edit_sitem, buf, TSIZEOF(buf)) == FALSE ) return NULL;
	last = VFSFindLastEntry(path);
	thprintf(last, VFPS - (last - path), T("\\color-%s"), buf);
	err = LoadTextImage(path, &mem, &text, &maxptr);
	if ( err != NO_ERROR ){
		XMessage(NULL, NULL, XM_GrERRld, T("%s\n%Mm"), path, err);
		return NULL;
	}
	text = mem; // FƃtHgȊO̐ݒ肪΋ۂBiZLeBړIj
	for (;;){
		TCHAR c, d;

		c = *text++;
		if ( c == '\0' ) break;
		if ( (c == ' ') || (c == '\t') || (c == '\r') || (c == '\n') ) continue;

		d = *text;
		if ( d == '\0' ) break;
		if ( ((d == '_') &&
				((c == 'C') || (c == 'F') || // C_, F_
				 ((c == 'X') && (text[1] == 'u') && (text[2] == 'x')) || // X_uxt
				 ((c == 'A') && (text[1] == 'c') && (text[2] == 'o')))) || // A_color
			  ((c == 'C') && Isalpha(d) && (text[1] == '_')) ){ // Cx_
			// `
		}else if ( ((c == '_') && Isalpha(d)) || // _xxx
			 ((d == '_') && Isalpha(c)) || // x_xxx
			 (Isalpha(c) && Isalpha(d) && (text[1] == '_')) || // xx_xxx
			 ((c == 'M') && (d == 'e') && (text[1] == 's')) ){ // Mesxxxx
			XMessage(NULL, NULL, XM_GrERRld, T("%s"), MessageText(MES_ECCF));
			HeapFree(GetProcessHeap(), 0, mem);
			return NULL;
		}
		for(;;){
			if ( d == '\0' ) return mem;
			text++;
			if ( (d == '\r') || (d == '\n') ) break;
			d = *text;
		}
	}
	return mem;
}

#define CUSTOFFSETDATA(cust) (const BYTE *)(cust + sizeof(WORD))
int WINAPI SortColorFunc(const BYTE *cust1, const BYTE *cust2)
{
	return *((DWORD *)(CUSTOFFSETDATA(cust1) + TSTRSIZE((const TCHAR *)CUSTOFFSETDATA(cust1)))) -
		   *((DWORD *)(CUSTOFFSETDATA(cust2) + TSTRSIZE((const TCHAR *)CUSTOFFSETDATA(cust2))));
}

// gȐFꗗɗpӂ
void FixColorList(void)
{
	int i;

	// PPx ̐FRFp
	for ( i = 0 ; i < USERUSEPPXCOLOR ; i++ ){
		GetCustData(GClist[i + 1].item, &userColor[i], sizeof(COLORREF));
		G_Colors[CL_first + i] = userColor[i];
	}
	// Windows ̐F6Fp
	for ( i = 0 ; i < WINDOWSCOLOR ; i++ ){
		G_Colors[CL_windowtext + i] =
			userColor[USERUSEPPXCOLOR + i] = GetSysColor(GDIColors[i]);
	}
}

void SetColorList(HWND hDlg, COLORREF c)
{
	int i;
	DWORD index;

	index = SendDlgItemMessage(hDlg, IDL_GCOLOR, LB_GETCURSEL, 0, 0);
	if ( index < COLORLIST_COLORS ){
		G_Colors[CL_prev] = G_Colors[index];
		InvalidateRect(GetDlgItem(hDlg, IDL_GCOLOR), NULL, FALSE);
	}

	if ( c == C_AUTO ){
		i = CL_auto;
	}else{
		for ( i = 0 ; i < CL_user ; i++ ){
			if ( G_Colors[i] == c ) break;
		}
		G_Colors[i] = c;
	}
	SendDlgItemMessage(hDlg, IDL_GCOLOR, LB_SETCURSEL, (WPARAM)i, 0);
}

void ThemeCust(TCHAR *mem, DWORD size)
{
	TCHAR *Have_C_ext;

	Have_C_ext = tstrstr(mem, T("\nC_ext"));
	PPcustCStore(mem, mem + size, PPXCUSTMODE_STORE, NULL, NULL);
	HeapFree(GetProcessHeap(), 0, mem);

	if ( Have_C_ext == NULL ){ // C_ext Ȃꍇ͊ȈՖxs
		COLORREF C_back = C_AUTO, color;
		DWORD blight, tmpblight;
		TCHAR ext[CUST_NAME_LENGTH];
		int i;

		GetCustData(T("C_back"), &C_back, sizeof(COLORREF));
		if ( C_back == C_AUTO ) C_back = GetSysColor(COLOR_WINDOW);

		// C_back ̖邳߂
		blight = GetRValue(C_back);
		blight = blight * blight * 2;
		tmpblight = GetGValue(C_back);
		blight += tmpblight * tmpblight * 4;
		tmpblight = GetBValue(C_back);
		blight += tmpblight * tmpblight * 3;
		// l
		blight = (blight >= (0xff * 0xff * 5)) ? 0x808080 : 0;

		for ( i = 0; ;i++ ){
			if ( 0 > EnumCustTable(i, T("C_ext"), ext, &color, sizeof(color)) ){
				break;
			}
			if ( (color & 0xff808080) != blight ) continue;
			// lɊYȂ璲
			color ^= 0x808080; // x 0.5 邩
			SetCustTable(T("C_ext"), ext, &color, sizeof(color));
		}
	}
	Test();
}

void CSelectItem(HWND hDlg)
{
	const LISTS *gcl;
	TCHAR buf[0x4000];

	gcl = GcType;
	switch( gcl->flags & GC_mask ){
		case GC_list:
			memset(buf, 0xff, sizeof buf);
			GetCustData(gcl->item, buf, sizeof(buf));
			if ( gcl->flags & GC_ppbItem ){ // console ̐Fɕϊ
				WORD conc;

				conc = ((WORD *)buf)[edit_sitem / 2];
				if ( conc == 0xffff ){
					conc = FOREGROUND_BLUE | FOREGROUND_GREEN | FOREGROUND_RED;
				}
				((COLORREF *)buf)[0] = ConsoleColors[conc & 0xf];
				((COLORREF *)buf)[1] = ConsoleColors[(conc >> 4) & 0xf];
				CheckDlgButton(hDlg, IDX_GCULINE, conc & COMMON_LVB_UNDERSCORE);
				SetColorList(hDlg, ((COLORREF *)buf)[edit_sitem & 1]);
			}else{
				SetColorList(hDlg, ((COLORREF *)buf)[edit_sitem]);
			}
			break;

		case GC_table:
			if ( ListView__GetText(GetDlgItem(hDlg, IDV_GCITEM), edit_sitem, buf, TSIZEOF(buf)) ){
				COLORREF c;

				GetCustTable(gcl->item, buf, (TCHAR *)&c, sizeof(c));
				SetColorList(hDlg, c);
			}
			break;

		case GC_theme: {
			TCHAR *mem;
			int BeforeX_uxt[2];
			int AfterX_uxt[2];
			HWND hPropWnd;

			GetCustData(T("X_uxt"), &BeforeX_uxt, sizeof(BeforeX_uxt));
			if ( edit_sitem == THEMEINDEX_RESTORE ){ // ɖ߂
				if ( OldColorTheme == NULL ) break;
				mem = HeapAlloc(GetProcessHeap(), 0, TSTRSIZE(OldColorTheme));
				if ( mem == NULL ) break;
				tstrcpy(mem, OldColorTheme);
			}else{
				if ( OldColorTheme == NULL ){ // obNAbv
					OldColorTheme = PPcust(PPXCUSTMODE_DUMP_PART_NOBOM, OldColorWildcard);
					memcpy(OldX_uxt, BeforeX_uxt, sizeof(OldX_uxt));
				}
				if ( edit_sitem <= THEMEINDEX_MAXRESOURCE ){
					mem = LoadTextResourceData(hInst,
						MAKEINTRESOURCE((edit_sitem - 1) + COLOR_THEME_1));
				}else{
					mem = GetUserTheme(hDlg);
				}
				if ( mem == NULL ) break;
			}
			SetCustData(T("X_uxt"), &OldX_uxt, sizeof(OldX_uxt));
			ThemeCust(mem, tstrlen(mem));

			GetCustData(T("X_uxt"), &AfterX_uxt, sizeof(AfterX_uxt));
			// e[}w UXT_OFF ɂƂ́AU UXT_AUTO 𔽉fȂ
			// O̎w肪c
			if ( (AfterX_uxt[0] < UXT_MINMODIFY) &&
				 (BeforeX_uxt[0] >= UXT_MINMODIFY) ){
				BeforeX_uxt[0] = UXT_AUTO;
				SetCustData(T("X_uxt"), &BeforeX_uxt, sizeof(BeforeX_uxt));
				Changed(hDlg); // UXT_AUTO Ŕf
				Sleep(300);
				SetCustData(T("X_uxt"), &AfterX_uxt, sizeof(AfterX_uxt));
				// AfterX_uxt ōĔf
			}
			PPxCommonCommand(hDlg, 0, K_Lcust);
			X_uxt[0] = PPxCommonExtCommand(K_UxTheme, KUT_LOADCUST);

			Changed(hDlg); //  GUILoadCust()
			hPropWnd = GetParent(hDlg);
			SetTabTitles(hPropWnd);
			LocalizeDialogText(hPropWnd, 0);
			InitPropSheetsUxtheme(hDlg);
			if ( X_uxt[0] == UXT_OFF ){
				SendDlgItemMessage(hDlg, IDV_GCTYPE, LVM_SETBKCOLOR, 0, (LPARAM)WinColors.c.DialogBack);
				SendDlgItemMessage(hDlg, IDV_GCTYPE, LVM_SETTEXTCOLOR, 0, (LPARAM)WinColors.c.DialogText);
				SendDlgItemMessage(hDlg, IDV_GCITEM, LVM_SETBKCOLOR, 0, (LPARAM)WinColors.c.DialogBack);
				SendDlgItemMessage(hDlg, IDV_GCITEM, LVM_SETTEXTCOLOR, 0, (LPARAM)WinColors.c.DialogText);
			}
			InvalidateRect(hPropWnd, NULL, TRUE);
			break;
		}
	}
	SetDlgItemText(hDlg, IDE_GCEDIT, NilStr);
}

void CSelectType(HWND hDlg)
{
	const LISTS *gcl;
	HWND hListView;
	BYTE buf[0x400];
	COLORREF color;
	DWORD flags;
	BOOL showflag;
	LV_ITEM lvi;

	hListView = GetDlgItem(hDlg, IDV_GCITEM);
	gcl = GcType;

	flags = gcl->flags;
	showflag = flags & GC_haveItem;	// ACeL(IDV_GCITEML)
	ShowDlgWindow(hDlg, IDS_GCITEM, showflag);
	ShowDlgWindow(hDlg, IDV_GCITEM, showflag);

	showflag = flags & GC_editItem;	// ACeǉEo^E\[g(gqFp)
	ShowDlgWindow(hDlg, IDE_GCEDIT, showflag);
	ShowDlgWindow(hDlg, IDB_GCADD, showflag);
	ShowDlgWindow(hDlg, IDB_GCDEL, showflag);
	ShowDlgWindow(hDlg, IDB_GCSORTN, showflag);
	ShowDlgWindow(hDlg, IDB_GCSORTC, showflag);
	ShowDlgWindow(hDlg, IDB_GCGROUP, showflag);
	ShowDlgWindow(hDlg, IDX_GCULINE, flags & GC_ppbItem); // R\[F
	SetWindowLongPtr(hListView, GWL_STYLE, showflag ?
			WS_CHILD | WS_VISIBLE | WS_BORDER | WS_TABSTOP | LVS_REPORT | LVS_NOCOLUMNHEADER | LVS_SHOWSELALWAYS | LVS_OWNERDRAWFIXED :
			WS_CHILD | WS_VISIBLE | WS_BORDER | WS_TABSTOP | LVS_REPORT | LVS_NOCOLUMNHEADER | LVS_SHOWSELALWAYS | LVS_SINGLESEL | LVS_OWNERDRAWFIXED);

	showflag = !(flags & GC_nocolor); // FIL(GC_themeȊO)
	ShowDlgWindow(hDlg, IDL_GCOLOR, showflag);
	ShowDlgWindow(hDlg, IDB_GCSEL, showflag);

	switch( flags & GC_mask ){
		case GC_single:{
			COLORREF c = C_AUTO;

			GetCustData(gcl->item, &c, sizeof(c));
			SetColorList(hDlg, c);
			break;
		}
		case GC_theme:
		case GC_list:{
			const TCHAR **list;
			int i;

			if ( (flags & GC_mask) == GC_theme ){
				memset(buf, (char)(BYTE)(COLOR_NO >> 24) , 32 * sizeof(COLORREF));
			}else{
				memset(buf, 0, 32 * sizeof(COLORREF));
				GetCustData(gcl->item, buf, sizeof(buf));
			}

			SendMessage(hListView, WM_SETREDRAW, FALSE, 0);
			ListView_DeleteAllItems(hListView);
			lvi.mask = LVIF_TEXT | LVIF_PARAM;
			lvi.iItem = 0;
			lvi.iSubItem = 0;

			for ( list = gcl->sublist, i = 0 ; *list ; list++, i++ ){
				if ( gcl->flags & GC_ppbItem ){
					WORD bc;

					bc = ((WORD *)buf)[i / 2];
					if ( i & 1 ){
						color = ConsoleColors[(bc >> 4) & 0xf];
					}else{
						color = ConsoleColors[bc & 0xf];
					}
					lvi.lParam = color;
				}else{
					lvi.lParam = *((COLORREF *)buf + i);
				}
				lvi.pszText = (TCHAR *)MessageText(*list);
				ListView_InsertItem(hListView, &lvi);
				lvi.iItem++;
			}
			edit_sitem = (gcl->sublist == GCchar) ? 15 : 0;

			if ( (flags & GC_mask) == GC_theme ){
				PPXDBINFOSTRUCT dbinfo;
				TCHAR path[VFPS];
				HANDLE hFF;
				WIN32_FIND_DATA ff;

				dbinfo.structsize = sizeof dbinfo;
				dbinfo.custpath = path;
				GetPPxDBinfo(&dbinfo);
				tstrcpy( VFSFindLastEntry(path), T("\\color-*.cfg") );
				hFF = FindFirstFileL(path, &ff);
				if ( INVALID_HANDLE_VALUE != hFF ){
					do{
						if ( IsRelativeDir(ff.cFileName) ) continue;
						lvi.pszText = ff.cFileName + 6;
						lvi.lParam = COLOR_NO;
						ListView_InsertItem(hListView, &lvi);
					}while( FindNextFile(hFF, &ff) );
					FindClose(hFF);
				}
			}

			ListView__FixColorColumn(hListView);
			SendMessage(hListView, WM_SETREDRAW, TRUE, 0);
			ListView__Select(hListView, edit_sitem);
			CSelectItem(hDlg);
			break;
		}

		case GC_table:{
			int size;
			TCHAR label[CUST_NAME_LENGTH];

			SendMessage(hListView, WM_SETREDRAW, FALSE, 0);
			ListView_DeleteAllItems(hListView);

			lvi.mask = LVIF_TEXT | LVIF_PARAM;
			lvi.iItem = 0;
			lvi.iSubItem = 0;
			lvi.pszText = label;

			for ( ;; ){
				size = EnumCustTable(lvi.iItem, gcl->item, label, &color, sizeof(color));
				if ( 0 > size ) break;

				lvi.lParam = color;
				ListView_InsertItem(hListView, &lvi);
				lvi.iItem++;
			}
			edit_sitem = 0;
			ListView__FixColorColumn(hListView);
			SendMessage(hListView, WM_SETREDRAW, TRUE, 0);

			CSelectItem(hDlg);
			break;
		}
	}
}

COLORREF USEFASTCALL ConColorConvertSub(COLORREF color)
{
	color &= 0xff;
	if ( color < 0x60 ) return 0;
	if ( color < 0xe0 ) return 0x80;
	return 0xff;
}

COLORREF USEFASTCALL ConColorConvert(COLORREF color)
{
	if ( color == C_DWHITE ) return color;
	color = ConColorConvertSub(color) |
		(ConColorConvertSub(color >> 8) << 8) |
		(ConColorConvertSub(color >> 16) << 16);
	if ( color & 0x010101 ){ // 0xff ̗vfA0x800xffϊ
		if ( color & 0x000080 ) color |= 0x0000ff;
		if ( color & 0x008000 ) color |= 0x00ff00;
		if ( color & 0x800000 ) color |= 0xff0000;
	}
	return color;
}

void SelectColor(HWND hDlg, DWORD index)
{
	COLORREF selc;
	TCHAR buf[0x4000];

	if ( index >= COLORLIST_COLORS ) return;
	selc = G_Colors[index];
	switch( GcType->flags & GC_mask ){
		case GC_single: {
			LV_ITEM lvi;

			SetCustData(GcType->item, (TCHAR *)&selc, sizeof(selc));
			lvi.mask = LVIF_PARAM;
			lvi.iItem = edit_gct;
			lvi.iSubItem = 0;
			lvi.lParam = selc;
			SendDlgItemMessage(hDlg, IDV_GCTYPE, LVM_SETITEM, 0, (LPARAM)&lvi);
			InvalidateRect(GetDlgItem(hDlg, IDV_GCTYPE), NULL, TRUE);
			break;
}
		case GC_list: {
			DWORD size, minsize;
			HWND hListView = GetDlgItem(hDlg, IDV_GCITEM);

			if ( GcType->flags & GC_ppbItem ){	// R\[
				int i;
				WORD *dest;

				minsize = GcType->subs * sizeof(WORD);
				size = GetCustDataSize(GcType->item);
				if ( (size < minsize) || (size > 0x800000) ) size = minsize;
				dest = &((WORD *)buf)[edit_sitem / 2];
				*dest = 0;

				GetCustData(GcType->item, buf, sizeof(buf));
				selc = ConColorConvert(selc);
				for ( i = 0 ; i < CONSOLECOLOR ; i++ ){
					if ( ConsoleColors[i] == selc ) break;
				}
				if ( i < CONSOLECOLOR ){
					if ( edit_sitem & 1 ){ // B4-7
						*dest = (WORD)((*dest & 0x000f) | (i << 4));
					}else{				// B0-3
						*dest = (WORD)((*dest & 0x00f0) | i);
					}
					if ( IsDlgButtonChecked(hDlg, IDX_GCULINE) ){
						setflag(*dest, COMMON_LVB_UNDERSCORE);
					}
					SetCustData(GcType->item, buf, size);
				}else{
					selc = (COLORREF)ListView__GetItemData(hListView, edit_sitem);
				}
				CSelectItem(hDlg);
			}else{									// GUI
				minsize = GcType->subs * sizeof(COLORREF);
				size = GetCustDataSize(GcType->item);
				if ( (size < minsize) || (size > 0x800000) ) size = minsize;

				memset(buf, 0xff, sizeof buf);
				GetCustData(GcType->item, buf, sizeof(buf));
				((COLORREF *)buf)[edit_sitem] = selc;
				SetCustData(GcType->item, buf, size);
			}
			ListView__SetItemData(hListView, edit_sitem, selc);
			InvalidateRect(hListView, NULL, FALSE);
			break;
		}
		case GC_table: { // gqF
			HWND hListView = GetDlgItem(hDlg, IDV_GCITEM);
			LONG_PTR index = -1;

			for (;;){
				index = SendMessage(hListView, LVM_GETNEXTITEM, index, TMAKELPARAM(LVNI_SELECTED, 0));
				if ( index < 0 ) break;

				if ( ListView__GetText(hListView, index, buf, TSIZEOF(buf)) ){
					SetCustTable(GcType->item, buf, (TCHAR *)&selc, sizeof(selc));
					ListView__SetItemData(hListView, index, selc);
				}
			}
			InvalidateRect(hListView, NULL, FALSE);
			break;
		}
	}
	FixColorList();
}

void ChangeUnderline(HWND hDlg)
{
	DWORD size, minsize;
	WORD *dest;
	BYTE buf[0x100];

	minsize = GcType->subs * sizeof(WORD);
	size = GetCustDataSize(GcType->item);
	if ( (size < minsize) || (size > 0x800000) ) size = minsize;
	dest = &((WORD *)buf)[edit_sitem / 2];
	*dest = 0;

	GetCustData(GcType->item, buf, sizeof(buf));
	*dest = (WORD)(*dest & ~COMMON_LVB_UNDERSCORE);
	if ( IsDlgButtonChecked(hDlg, IDX_GCULINE) ){
		setflag(*dest, COMMON_LVB_UNDERSCORE);
	}
	SetCustData(GcType->item, buf, size);
}

void InitColorControls(HWND hDlg)
{
	HWND hCListWnd;
	RECT box;

	hCListWnd = GetDlgItem(hDlg, IDL_GCOLOR);
	GetClientRect(hCListWnd, &box);
	SendMessage(hCListWnd, LB_SETCOLUMNWIDTH,
			(WPARAM)((box.right - box.left) / COLORLIST_WIDTH), 0);
	SendMessage(hCListWnd, LB_SETITEMHEIGHT,
			0, (LPARAM)((box.bottom - box.top) / COLORLIST_HEIGHT));
	DrawHeight = InitDrawHeight(hDlg);
}

void InitColorPage(HWND hDlg)
{
	int i;
	HWND hControlWnd;
	COLORREF color;
	LV_ITEM lvi;
	LV_COLUMN lvc;

	InitColorControls(hDlg);
		/* ͂߂́Al COLORREF 𒼐ړĂASP 
		   WinXP ŁA0 gpĂo^Ȃ߁A_~[̒l
		   悤ɕύX									*/
	hControlWnd = GetDlgItem(hDlg, IDL_GCOLOR);
	for ( i = 0 ; i <= CL_last ; i++ ){
		SendMessage(hControlWnd, LB_ADDSTRING, 0, (LPARAM)1);
	}

	lvc.mask = LVCF_WIDTH;
	lvc.cx = 200;

	hControlWnd = GetDlgItem(hDlg, IDV_GCTYPE);
	if ( hControlWnd != NULL ){
		SendMessage(hControlWnd, WM_SETREDRAW, FALSE, 0);
		SendMessage(hControlWnd, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);

		ListView_InsertColumn(hControlWnd, 0, &lvc);

		lvi.mask = LVIF_TEXT | LVIF_PARAM;
		lvi.iItem = 0;
		lvi.iSubItem = 0;

		for ( i = 0 ; GClist[i].name ; i++ ){
			lvi.pszText = (TCHAR *)MessageText(GClist[i].name);
			if ( (GClist[i].flags & GC_mask) == GC_single ){
				GetCustData(GClist[i].item, &color, sizeof(color));
				lvi.lParam = color;
			}else{
				lvi.lParam = COLOR_SUB;
			}
			ListView_InsertItem(hControlWnd, &lvi);
			lvi.iItem++;
		}
		ListView__FixColorColumn(hControlWnd);
		SendMessage(hControlWnd, WM_SETREDRAW, TRUE, 0);
	}

	hControlWnd = GetDlgItem(hDlg, IDV_GCITEM);
	if ( hControlWnd != NULL ){
		SendMessage(hControlWnd, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
		ListView_InsertColumn(hControlWnd, 0, &lvc);
	}

	SendDlgItemMessage(hDlg, IDE_GCEDIT, EM_SETCUEBANNER, 0, (LPARAM)GetBannerText(stringExtInfo));

	FixColorList();
}

// I\ȐF̈ꗗ̕\
void ColorSampleDraw(DRAWITEMSTRUCT *lpdis)
{
	if ( lpdis->itemAction & (ODA_DRAWENTIRE | ODA_SELECT) ){
		int OldBkMode;
		HBRUSH hB;
		COLORREF showcolor;

		OldBkMode = SetBkMode(lpdis->hDC, OPAQUE);
		showcolor = (lpdis->itemID == CL_auto) ?
				C_WindowBack : G_Colors[lpdis->itemID];

		if ( GcType->flags & GC_ppbItem ){
			showcolor = ConColorConvert(showcolor);
		}

		hB = CreateSolidBrush(showcolor);
		FillRect(lpdis->hDC, &lpdis->rcItem, hB);
		DeleteObject(hB);

		if ( lpdis->itemID >= CL_withtext ){
			const TCHAR *text;

			text = MessageText(
				(lpdis->itemID == CL_auto) ?
					( (GcType->flags & GC_aoff) ?
						stringaoff : stringauto)  : stringother);
			TextOut(lpdis->hDC, lpdis->rcItem.left + 2,
					lpdis->rcItem.top + 2, text, tstrlen32(text));
		}

		SetBkMode(lpdis->hDC, OldBkMode);
		if ( lpdis->itemState & ODS_SELECTED ){
			RECT rect;

			FrameRect(lpdis->hDC, &lpdis->rcItem, GetStockObject(BLACK_BRUSH));
			rect.left = lpdis->rcItem.left + 1;
			rect.top = lpdis->rcItem.top + 1;
			rect.right = lpdis->rcItem.right - 1;
			rect.bottom = lpdis->rcItem.bottom - 1;
			FrameRect(lpdis->hDC, &rect, GetStockObject(WHITE_BRUSH));
		}
	}
	if ( lpdis->itemAction & ODA_FOCUS ){
		int i;
		RECT rect;
		for ( i = 0 ; i < 2 ; i++ ){
			rect.left = lpdis->rcItem.left + i;
			rect.top = lpdis->rcItem.top + i;
			rect.right = lpdis->rcItem.right - i;
			rect.bottom = lpdis->rcItem.bottom - i;
			DrawFocusRect(lpdis->hDC, &rect);
		}
	}
}

// ڈꗗ + ݂̐F̕\
void ColorItemDraw(DRAWITEMSTRUCT *lpdis)
{
	TCHAR buf[CMDLINESIZE];
	int OldBkMode;
	COLORREF OldText, OldBack;
	RECT box;
	HBRUSH hB;
	LV_ITEM lvi;

	lvi.mask = LVIF_TEXT | LVIF_PARAM;
	lvi.iItem = lpdis->itemID;
	lvi.iSubItem = 0;
	lvi.pszText = buf;
	lvi.cchTextMax = TSIZEOF(buf);

	ListView_GetItem(lpdis->hwndItem, &lvi);

	OldBkMode = SetBkMode(lpdis->hDC, OPAQUE);
	box = lpdis->rcItem;
	if ( (lpdis->itemAction & ODA_FOCUS) && !(lpdis->itemState & ODS_FOCUS) ){
		hB = CreateSolidBrush(C_WindowBack);
		FillRect(lpdis->hDC, &lpdis->rcItem, hB);
		DeleteObject(hB);
	}

	if ( lpdis->itemState & ODS_SELECTED ){
		OldText = SetTextColor(lpdis->hDC, GetSysColor(COLOR_HIGHLIGHTTEXT));
		OldBack = SetBkColor(lpdis->hDC, GetSysColor(COLOR_HIGHLIGHT));
	}else{
		OldText = SetTextColor(lpdis->hDC, C_WindowText);
		OldBack = SetBkColor(lpdis->hDC, C_WindowBack);
	}

	box.right = box.left + (box.bottom - box.top);
	if ( lvi.lParam >= COLOR_SPECIAL ){
		if ( lvi.lParam == COLOR_SUB ){ // wA
			TextOut(lpdis->hDC, box.left, box.top, SubMenuString, 2);
		}else if ( lvi.lParam == C_AUTO ){ // 
			TextOut(lpdis->hDC, box.left, box.top, AutoString, 2);
		}else{
			box.right = box.left;
		}
	}else{
		hB = CreateSolidBrush((COLORREF)lvi.lParam);
		FillRect(lpdis->hDC, &box, hB);
		DeleteObject(hB);
	}
	TextOut(lpdis->hDC, box.right, box.top, buf, tstrlen32(buf));
	SetTextColor(lpdis->hDC, OldText);
	SetBkColor(lpdis->hDC, OldBack);
	if ( lpdis->itemState & ODS_FOCUS ){
		DrawFocusRect(lpdis->hDC, &lpdis->rcItem);
	}
	SetBkMode(lpdis->hDC, OldBkMode);
}

BOOL SelectUserColor(HWND hDlg)
{
	CHOOSECOLOR cc;
	DWORD index;

	index = SendDlgItemMessage(hDlg, IDL_GCOLOR, LB_GETCURSEL, 0, 0);
	if ( index < COLORLIST_COLORS ){
		cc.rgbResult = G_Colors[index];
	}
	userColor[userColor_SEL] = G_Colors[CL_user];
	cc.lStructSize = sizeof(cc);
	cc.hwndOwner = hDlg;
	cc.lpCustColors = userColor;
	cc.Flags = CC_FULLOPEN | CC_RGBINIT;
	if ( ChooseColor(&cc) ){
		G_Colors[CL_user] = cc.rgbResult;
		SendDlgItemMessage(hDlg, IDL_GCOLOR, LB_SETCURSEL, (WPARAM)CL_user, 0);
		return TRUE;
	}
	return FALSE;
}

#pragma argsused
INT_PTR CALLBACK ColorPage(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	TCHAR buf[MAX_PATH];

	switch (msg){
		case WM_SETTINGCHANGE:
			DrawHeight = -1;
			InitColorControls(hDlg);
			break;

		case WM_INITDIALOG:
			InitPropSheetsUxtheme(hDlg);
			InitColorPage(hDlg);
			CSelectType(hDlg);
			return FALSE;

		case WM_MEASUREITEM:
			if ( (wParam == IDV_GCTYPE) || (wParam == IDV_GCITEM) ){
				((MEASUREITEMSTRUCT *)lParam)->itemHeight =
						InitDrawHeight(GetDlgItem(hDlg, wParam));
			}
			return TRUE;

		case WM_DRAWITEM:
			if ( wParam == IDL_GCOLOR ){
				ColorSampleDraw((DRAWITEMSTRUCT *)lParam);
			}else if ( (wParam == IDV_GCTYPE) || (wParam == IDV_GCITEM) ){
				ColorItemDraw((DRAWITEMSTRUCT *)lParam);
			}
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ){
				case IDB_TEST:
					Test();
					break;

				case IDB_GCADD:
					GetControlText(hDlg, IDE_GCEDIT, buf, TSIZEOF(buf));
					if ( buf[0] != '\0' ){
						int index, selcolor;
						LV_ITEM lvi;
						LV_FINDINFO lvf;
						HWND hListView = GetDlgItem(hDlg, IDV_GCITEM);

						FixWildItemName(buf);
						if ( !IsExistCustTable(GcType->item, buf) ){
							lvi.mask = LVIF_TEXT;
							lvi.iItem = INT32__MAX;
							lvi.iSubItem = 0;
							lvi.pszText = buf;
							selcolor = SendDlgItemMessage(hDlg, IDL_GCOLOR, LB_GETCURSEL, 0, 0);
							if ( selcolor < 0 ) selcolor = 0;
							edit_sitem = ListView_InsertItem(hListView, &lvi);
							SelectColor(hDlg, selcolor);
							Changed(hDlg);
						}
						lvf.flags = LVFI_STRING;
						lvf.psz = buf;
						index = ListView_FindItem(hListView, 0, &lvf);
						if ( index >= 0 ){
							ListView__Select(hListView, index);
							edit_sitem = index;
						}
						SetDlgItemText(hDlg, IDE_GCEDIT, NilStr);
					}
					break;

				case IDB_GCDEL:
					if ( edit_sitem >= 0 ){
						HWND hListView = GetDlgItem(hDlg, IDV_GCITEM);
						int old_edit_sitem;
						LONG_PTR index;

						old_edit_sitem = edit_sitem;
						for (;;){
							index = SendMessage(hListView, LVM_GETNEXTITEM, -1, TMAKELPARAM(LVNI_SELECTED, 0));
							if ( index < 0 ) break;

							if ( ListView__GetText(hListView, index, buf, TSIZEOF(buf)) ){
								DeleteCustTable(GcType->item, buf, 0);
								ListView_DeleteItem(hListView, index);
							}
						}
						ListView__Select(hListView, old_edit_sitem);
						Changed(hDlg);
					}
					break;

				case IDL_GCOLOR:
					if ( HIWORD(wParam) == LBN_SELCHANGE ){
						SelectColor(hDlg, SendMessage((HWND)lParam, LB_GETCURSEL, 0, 0));
						Changed(hDlg);
					}
					break;

				case IDB_GCSEL:
					if ( IsTrue(SelectUserColor(hDlg))){
						SelectColor(hDlg, CL_user);
						Changed(hDlg);
					}
					InvalidateRect(GetDlgItem(hDlg, IDL_GCOLOR), NULL, FALSE);
					break;

				case IDB_GCSORTN:
					SortCustTable(T("C_ext"), NULL);
					CSelectType(hDlg);
					break;

				case IDB_GCSORTC:
					SortCustTable(T("C_ext"), SortColorFunc);
					CSelectType(hDlg);
					break;

				case IDX_GCULINE:
					ChangeUnderline(hDlg);
					Changed(hDlg);
					break;

				case IDB_GCGROUP: {
					HWND hListView = GetDlgItem(hDlg, IDV_GCITEM);
					COLORREF oldcolor = (COLORREF)ListView__GetItemData(hListView, edit_sitem);
					LV_ITEM lvi;
					LONG_PTR index = 0;

					for (;;){
						lvi.mask = LVIF_PARAM;
						lvi.iItem = (int)index;
						lvi.iSubItem = 0;
						if ( ListView_GetItem(hListView, &lvi) == FALSE ){
							break;
						}
						if ( (COLORREF)lvi.lParam == oldcolor ){
							lvi.mask = LVIF_STATE;
							lvi.state = lvi.stateMask = LVIS_SELECTED;
							SendMessage(hListView, LVM_SETITEMSTATE, index, (LPARAM)&lvi);
						}
						index++;
					}
					InvalidateRect(hListView, NULL, FALSE);
					break;
				}
			}
			break;

		case WM_NOTIFY:
			#define NHPTR ((NMHDR *)lParam)
			#define PNM ((NM_LISTVIEW *)lParam)
			if ( NHPTR->code == PSN_SETACTIVE ){
				InitWndIcon(hDlg, IDB_TEST);
			}else if ( wParam == IDV_GCTYPE ){
				if ( NHPTR->code == LVN_ITEMCHANGED ){
					if ( edit_gct != PNM->iItem ){
						edit_gct = PNM->iItem;
						GcType = &GClist[edit_gct];
						CSelectType(hDlg);
					}
				}
				return TRUE;
			}else if ( wParam == IDV_GCITEM ){
				if ( NHPTR->code == LVN_ITEMCHANGED ){
					if ( edit_sitem != PNM->iItem ){
						edit_sitem = PNM->iItem;
						CSelectItem(hDlg);
					}
				}
				return TRUE;
			}
			#undef PNM
			#undef NHPTR
		// default 
		default:
			return DlgSheetProc(hDlg, msg, wParam, lParam, IDD_COLOR);
	}
	return TRUE;
}

//=============================================================================
INT_PTR CALLBACK HideMenuColorDlgBox(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch(iMsg){
		case WM_INITDIALOG:
			LocalizeDialogText(hDlg, IDD_SCOLOR);
			SetWindowLongPtr(hDlg, DWLP_USER, (LONG_PTR)lParam);
			InitColorPage(hDlg);
			SetColorList(hDlg, *(COLORREF *)lParam);
			return TRUE;

		case WM_DRAWITEM:
			if (wParam == IDL_GCOLOR) ColorSampleDraw((DRAWITEMSTRUCT *)lParam);
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ){
				case IDB_GCSEL:
					SelectUserColor(hDlg);
					break;

				case IDL_GCOLOR: {
					int index;

					if ( GetListCursorIndex(wParam, lParam, &index) != 0 ){
						*(COLORREF *)GetWindowLongPtr(hDlg, DWLP_USER) =
								G_Colors[index];
					}
					break;
				}
				case IDOK:
					EndDialog(hDlg, 1);
					break;

				case IDCANCEL:
					EndDialog(hDlg, 0);
					break;
			}
			break;

		default:
			return PPxDialogHelper(hDlg, iMsg, wParam, lParam);
	}
	return TRUE;
}

//=============================================================================
// nCCg(CV_hkey)

void InitHighlightDialogBox(HWND hDlg, TCHAR *subkey)
{
	TCHAR text[VFPS], data[0x10000], *line, *next;
	HWND hListView;
	LV_ITEM lvi;

	LocalizeDialogText(hDlg, 0);
	thprintf(text, TSIZEOF(text), MessageText(MES_TEHC), subkey);
	SetWindowText(hDlg, text);

	FixWildItemName(subkey);
	SetWindowLongPtr(hDlg, DWLP_USER, (LONG_PTR)subkey);
	InitColorPage(hDlg);

	hListView = GetDlgItem(hDlg, IDV_GCITEM);
	SendMessage(hListView, WM_SETREDRAW, FALSE, 0);
	ListView_DeleteAllItems(hListView);

	lvi.mask = LVIF_TEXT | LVIF_PARAM;
	lvi.iItem = 0;
	lvi.iSubItem = 0;

	data[0] = '\0';
	if ( (NO_ERROR == GetCustTable(T("CV_hkey"), subkey, data, sizeof(data))) && data[0] ){
		line = data;
		for (;;){
			COLORREF color;
			TCHAR *dst;

			dst = text;
			next = tstrchr(line, '\n');
			if ( next != NULL ) *next = '\0';
			for(;;){
				TCHAR c = *line;
				if ( (c == '<') || (c == '>') ){
					*dst++ = c;
					line++;
					continue;
				}
				break;
			}
			*dst++ = ',';
			color = GetColor((const TCHAR **)&line, TRUE);
			if ( SkipSpace((const TCHAR **)&line) == ',' ) line++;
			SkipSpace((const TCHAR **)&line);
			tstrcpy(dst, line);

			if ( dst[0] != '\0' ){
				lvi.pszText = text;
				lvi.lParam = color;
				ListView_InsertItem(hListView, &lvi);
				lvi.iItem++;
			}

			if ( next != NULL ){
				line = next + 1;
				continue;
			}
			break;
		}
	}
	ListView__FixColorColumn(hListView);
	SendMessage(hListView, WM_SETREDRAW, TRUE, 0);
}

void GetHighlightItem(HWND hListView, int index, HighlightItem *hi)
{
	TCHAR *wordptr;

	if ( hListView != NULL ){
		ListView__GetText(hListView, index, hi->text, TSIZEOF(hi->text));
	}

	hi->cb_top = hi->cb_bottom = FALSE;
	wordptr = hi->text;

	for(;;){
		TCHAR c = *wordptr;

		if ( c == '<' ){
			hi->cb_top = TRUE;
		}else if ( c == '>' ){
			hi->cb_bottom = TRUE;
		}else{
			if ( c == ',' ) wordptr++;
			hi->textptr = wordptr;
			return;
		}
		wordptr++;
	}
}

void SetHighlightItem(HWND hListView, int index, HighlightItem *hi, COLORREF color)
{
	TCHAR text[VFPS], *dst = text;
	LV_ITEM lvi;

	if ( hi->cb_top ) *dst++ = '<';
	if ( hi->cb_bottom ) *dst++ = '>';
	if ( hListView == NULL ) dst = thprintf(dst, 16, T("H%06X"), color);
	*dst++ = ',';
	tstrcpy(dst, hi->textptr);
	if ( hListView == NULL ){
		tstrcpy(hi->text, text);
		return;
	}

	lvi.mask = LVIF_TEXT | LVIF_PARAM;
	lvi.iSubItem = 0;
	lvi.lParam = color;
	lvi.pszText = text;

	if ( index >= 0 ){
		lvi.iItem = index;
		ListView_SetItem(hListView, &lvi);
	}else{
		lvi.iItem = INT32__MAX;
		index = ListView_InsertItem(hListView, &lvi);
		ListView__Select(hListView, index);
	}
}

void ChangeHighlightItem(HWND hDlg, int id)
{
	HighlightItem hi;
	HWND hListView;
	int index;
	COLORREF color;
	TCHAR text[VFPS];

	hListView = GetDlgItem(hDlg, IDV_GCITEM);
	index = (int)TListView_GetFocusedItem(hListView);
	text[0] = '\0';
	GetControlText(hDlg, IDE_GCEDIT, text, TSIZEOF(text));

	if ( index >= 0 ){ // IL
		GetHighlightItem(hListView, index, &hi);
		color = (COLORREF)ListView__GetItemData(hListView, index);
		if ( tstrcmp(hi.textptr, text) != 0 ){
			if ( id != IDB_GCADD ) return;
			index = -1;
		}
	}
	if ( index < 0 ){ // I𖳂cVK(add{^̎̂)
		int cindex;

		if ( (id != IDB_GCADD) || (text[0] == '\0') ) return;
		cindex = (int)SendDlgItemMessage(hDlg, IDL_GCOLOR, LB_GETCURSEL, 0, 0);
		if ( cindex == LB_ERR ) cindex = 0;
		color = G_Colors[cindex];

		tstrcpy(hi.text, text);
		hi.textptr = hi.text;
	}
	hi.cb_top = IsDlgButtonChecked(hDlg, IDX_HL_TOP);
	hi.cb_bottom = IsDlgButtonChecked(hDlg, IDX_HL_BOTTOM);

	SetHighlightItem(hListView, index, &hi, color);
}

void SelectHighlightItem(HWND hDlg, int index)
{
	HighlightItem hi;
	HWND hListView;

	hListView = GetDlgItem(hDlg, IDV_GCITEM);
	GetHighlightItem(hListView, index, &hi);
	if ( hi.textptr == hi.text ) return;

	SetDlgItemText(hDlg, IDE_GCEDIT, hi.textptr);
	SetColorList(hDlg, (COLORREF)ListView__GetItemData(hListView, index));
	CheckDlgButton(hDlg, IDX_HL_TOP, hi.cb_top);
	CheckDlgButton(hDlg, IDX_HL_BOTTOM, hi.cb_bottom);
}

void SelectHighlightColor(HWND hDlg, DWORD colorindex)
{
	if ( colorindex >= COLORLIST_COLORS ) return;

	ListView__SetItemData(GetDlgItem(hDlg, IDV_GCITEM), -1, G_Colors[colorindex]);
}

void SaveHighlightDialogBox(HWND hDlg)
{
	HighlightItem hi;
	HWND hListView;
	int count, index = 0;
	TCHAR text[0x2000], *dst = text, *subkey;

	subkey = (TCHAR *)GetWindowLongPtr(hDlg, DWLP_USER);
	hListView = GetDlgItem(hDlg, IDV_GCITEM);

	count = ListView_GetItemCount(hListView);
	if ( count == 0 ){
		DeleteCustTable(T("CV_hkey"), subkey, 0);
		return;
	}
	while ( index < count ){
		COLORREF color;

		GetHighlightItem(hListView, index, &hi);
		color = (COLORREF)ListView__GetItemData(hListView, index);
		SetHighlightItem(NULL, 0, &hi, color);
		dst = thprintf(dst, CMDLINESIZE, T("%s\n"), hi.text);
		index++;
	}
	*dst = '\0';
	SetCustStringTable(T("CV_hkey"), subkey, text, 0);
}

INT_PTR CALLBACK HighlightDialogBox(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch(iMsg){
		case WM_INITDIALOG:
			InitHighlightDialogBox(hDlg, (TCHAR *)lParam);
			return FALSE;

		case WM_MEASUREITEM:
			if ( wParam == IDV_GCITEM ){
				((MEASUREITEMSTRUCT *)lParam)->itemHeight =
						InitDrawHeight(GetDlgItem(hDlg, wParam));
			}
			return TRUE;

		case WM_DRAWITEM:
			if ( wParam == IDL_GCOLOR ){
				ColorSampleDraw((DRAWITEMSTRUCT *)lParam);
			}else if ( wParam == IDV_GCITEM ){
				ColorItemDraw((DRAWITEMSTRUCT *)lParam);
			}
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ){
				case IDOK:
					SaveHighlightDialogBox(hDlg);
					EndDialog(hDlg, 1);
					break;

				case IDCANCEL:
					EndDialog(hDlg, 0);
					break;

				case IDL_GCOLOR:
					if ( HIWORD(wParam) == LBN_SELCHANGE ){
						SelectHighlightColor(hDlg,
								SendMessage((HWND)lParam, LB_GETCURSEL, 0, 0));
					}
					break;

				case IDX_HL_TOP:
				case IDX_HL_BOTTOM:
				case IDB_GCADD:
					ChangeHighlightItem(hDlg, LOWORD(wParam));
					break;

				case IDB_GCDEL: {
					int index;
					HWND hListView = GetDlgItem(hDlg, IDV_GCITEM);

					index = TListView_GetFocusedItem(hListView);
					if ( index < 0 ) break;
					ListView_DeleteItem(hListView, index);
					ListView__Select(hListView, index);
					break;
				}

				case IDB_GCSEL:
					if ( IsTrue(SelectUserColor(hDlg)) ){
						SelectHighlightColor(hDlg, CL_user);
					}
					InvalidateRect(GetDlgItem(hDlg, IDL_GCOLOR), NULL, FALSE);
					break;
			}
			break;

		case WM_NOTIFY:
			#define NHPTR ((NMHDR *)lParam)
			#define PNM ((NM_LISTVIEW *)lParam)
			if ( wParam == IDV_GCITEM ){
				if ( NHPTR->code == LVN_ITEMCHANGED ){
					if ( PNM->iItem >= 0 ){
						SelectHighlightItem(hDlg, PNM->iItem);
						return TRUE;
					}
				}
			}
			#undef PNM
			#undef NHPTR
		// default 

		default:
			return PPxDialogHelper(hDlg, iMsg, wParam, lParam);
	}
	return TRUE;
}
